<?php

header('Content-Type: application/json; charset=utf-8');

$json = file_get_contents('php://input');

$json_obj = json_decode($json);

$output = array();

$result = "";

$domain_name = ""; $admin_folder_name = "";
if(isset($json_obj->domain_name)) { 
    $domain_name = $json_obj->domain_name;		
    $domain_name = trim($domain_name);

    if(isset($json_obj->admin_folder_name)) { 
        $admin_folder_name = $json_obj->admin_folder_name;		
        $admin_folder_name = trim($admin_folder_name);
    }

    if(!empty($domain_name) && !empty($admin_folder_name)) {
        $domain_admin_path = "../".$domain_name."/".$admin_folder_name."/include.php";

        include($domain_admin_path);

        if(isset($json_obj->get_website_status)){
            if ($json_obj->get_website_status == 1) {
                $settings_list = array();
                $settings_list = $obj->getTableRecords($GLOBALS['settings_table'], '', '');
        
                $disable_form = "";
                $enquiry_customer_order_link = "";
                $enquiry_customer_order_code = "";
                $disable_page_form = 2;
                $disable_page_image = "";
        
                if (!empty($settings_list)) {
                    foreach ($settings_list as $data) {
        
                        if (!empty($data['name']) && $data['value'] != $GLOBALS['null_value'] && $data['name'] == "disable_site") {
                            $disable_site = $obj->encode_decode('decrypt', $data['value']);
                        }
        
                        if (!empty($data['name']) && $data['value'] != $GLOBALS['null_value'] && $data['name'] == "enquiry_customer_order_link") {
                            $enquiry_customer_order_link = $data['value'];
                            if (!empty($enquiry_customer_order_link)) {
                                $enquiry_customer_order_link = $obj->encode_decode('decrypt', $enquiry_customer_order_link);
                            }
                        }
                        if (!empty($data['name']) && $data['value'] != $GLOBALS['null_value'] && $data['name'] == "enquiry_customer_order_code") {
                            $enquiry_customer_order_code = $data['value'];
                            if (!empty($enquiry_customer_order_code)) {
                                $enquiry_customer_order_code = $obj->encode_decode('decrypt', $enquiry_customer_order_code);
                            }
                        }
                        if (!empty($data['name']) && $data['value'] != $GLOBALS['null_value'] && $data['name'] == "enquiry_customer_order_code") {
                            $enquiry_customer_order_code = $data['value'];
                            if (!empty($enquiry_customer_order_code)) {
                                $enquiry_customer_order_code = $obj->encode_decode('decrypt', $enquiry_customer_order_code);
                            }
                        }
                        if (!empty($data['name']) && $data['value'] != $GLOBALS['null_value'] && $data['name'] == "disable_page_form") {
                            $disable_page_form = $data['value'];
                        }
                    }
                }
        
                if (!empty($domain_admin_path)) {
                    if (empty($enquiry_customer_order_link)) {
                        $enquiry_customer_order_link = $domain_admin_path . "/enquiry.php";
                    }
                    if (empty($enquiry_customer_order_code)) {
                        $enquiry_customer_order_code = rand(100000, 999999);
                    }
                }
        
                $output["head"]["code"] = 200;
                $output["head"]["msg"] = [
                    "disable_site" => $disable_site,
                    "enquiry_customer_order_link" => $enquiry_customer_order_link,
                    "enquiry_customer_order_code" => $enquiry_customer_order_code,
                    "disable_page_form" => $disable_page_form,
                ];
            }
        }
        
        if (isset($json_obj->update_status)) {
            $update_status = $json_obj->update_status;
            if (!empty($update_status)) {
                $disable_site = "";
                $disable_page_form = 2;
        
                $disable_site = $json_obj->update_status;
                $disable_page_form = $json_obj->disable_form;
        
                $settings_list[] = array('settings_name' => 'disable_site', 'settings_value' => $obj->encode_decode('encrypt', $disable_site), 'action' => 'Disable Site');
                $settings_list[] = array('settings_name' => 'disable_page_form', 'settings_value' => $disable_page_form, 'action' => 'Disable page form');
            
                if (!empty($settings_list)) {
                    $success = 0;
        
                    foreach ($settings_list as $data) {
                        if (!empty($data['settings_name']) &&  !empty($data['action'])) {
                            $getUniqueID = "";
                            $getUniqueID = $obj->getTableColumnValue($GLOBALS['settings_table'], 'name', $data['settings_name'], 'id');
                            if (preg_match("/^\d+$/", $getUniqueID) && $data['settings_name'] != "state_name") {
                                $action = "";
                                if (!empty($data['action'])) {
                                    $action = "Settings Param Updated. Name - " . $data['action'];
                                }
        
                                $settings_update_id = "";
                                $columns = array();
                                $values = array();
                                $columns = array('value');
                                $values = array("'" . $data['settings_value'] . "'");
                                $settings_update_id = $obj->UpdateSQL($GLOBALS['settings_table'], $getUniqueID, $columns, $values, $action);
                                if (preg_match("/^\d+$/", $settings_update_id)) {
                                    $success++;
                                }
                            } else {
                                $action = "";
                                if (!empty($data['action'])) {
                                    $action = "New Settings Param Created. Name - " . $data['action'];
                                }
                                $settings_insert_id = "";
                                $columns = array();
                                $values = array();
                                $columns = array('name', 'value', 'deleted');
                                $values = array("'" . $data['settings_name'] . "'", "'" . $data['settings_value'] . "'", "'0'");
                                $settings_insert_id = $obj->InsertSQL($GLOBALS['settings_table'], $columns, $values, $action);
                                if (preg_match("/^\d+$/", $settings_insert_id)) {
                                    $success++;
                                }
                            }
                        }
                    }
                    if (!empty($success) && $success == count($settings_list)) {
                        $output["head"]["code"] = 200;
                        $output["head"]["msg"] = "Updated Successfully";
                    } else {
                        $output["head"]["code"] = 400;
                        $output["head"]["msg"] = "Some Values not inserted properly - " .$success . count($settings_list);
                    }
                }
            }
        }
    }
}

$result = json_encode($output, JSON_NUMERIC_CHECK);

echo $result;
