<?php
/**
 * Recursively scan directories and set permissions
 * Folders → 0755
 * Files   → 0644
 */

function fixPermissions($path) {
    // Skip special dirs
    if ($path === '.' || $path === '..') {
        return;
    }

    if (is_dir($path)) {
        // If it's a directory
        $perms = substr(sprintf('%o', fileperms($path)), -3);
        if ($perms !== '755') {
            chmod($path, 0755);
            echo "Changed folder permission: $path → 755<br>";
        }

        // Recurse into directory
        $items = scandir($path);
        foreach ($items as $item) {
            if ($item === '.' || $item === '..') continue;
            fixPermissions($path . DIRECTORY_SEPARATOR . $item);
        }
    } else {
        // If it's a file
        $perms = substr(sprintf('%o', fileperms($path)), -3);
        if ($perms !== '644') {
            chmod($path, 0644);
            echo "Changed file permission: $path → 644<br>";
        }
    }
}

// Start from current directory (.)
$root = __DIR__;
fixPermissions($root);

echo "Permission check completed.<br>";
