<?php
include 'include.php';

// Header This Application is a JSON APPLICATION
header('Content-Type: application/json; charset=utf-8');

// get Post Form Data on API
$json = file_get_contents('php://input');

// Decode JSON Format
$json_obj = json_decode($json);

// Output Result Array Variable
$output = array();

$result = "";

if(isset($json_obj->new_order_id)) {
    $new_order_id = "";

    $new_order_id = $json_obj->new_order_id;		
    $new_order_id = trim($new_order_id);
        
    if(!empty($new_order_id)) {
        $order_unique_id = "";
        $order_unique_id = $obj->getTableColumnValue($GLOBALS['order_table'], 'order_id', $new_order_id, 'id');
        if(preg_match("/^\d+$/", $order_unique_id)) {        
            $columns = array(); $values = array(); $msg = "";				
            $columns = array('new_order');
            $values = array("'0'");
            $msg = $obj->UpdateSQL($GLOBALS['order_table'], $order_unique_id, $columns, $values, '');
            if(preg_match("/^\d+$/", $msg)) {
                $output["head"]["code"] = 200;
                $output["head"]["msg"] = 'Successfully Updated';
            }
            else {
                $output["head"]["code"] = 400;
                $output["head"]["msg"] = $msg;
            }
        }
        else {
            $output["head"]["code"] = 400;
            $output["head"]["msg"] = 'Invalid order';
        }
    }
    else {
        $output["head"]["code"] = 400;
        $output["head"]["msg"] = 'Empty order';
    }
}

if(isset($json_obj->confirmed_order_id)) {
    $confirmed_order_id = ""; $confirm_status = "";

    $confirmed_order_id = $json_obj->confirmed_order_id;		
    $confirmed_order_id = trim($confirmed_order_id);

    $confirm_status = $json_obj->confirm_status;		
    $confirm_status = trim($confirm_status);
        
    if(!empty($confirmed_order_id) && ($confirm_status == 1)) {
        $order_unique_id = "";
        $order_unique_id = $obj->getTableColumnValue($GLOBALS['order_table'], 'order_id', $confirmed_order_id, 'id');
        if(preg_match("/^\d+$/", $order_unique_id)) {
            $order_number = "";
            $order_number = $obj->getTableColumnValue($GLOBALS['order_table'], 'order_id', $confirmed_order_id, 'order_number');
        
            $action = "";
            if(!empty($confirm_status)) {
                if(!empty($confirmed)) {
                    $action = "Order Confirmed. Change to ON. Order Number - ".$obj->encode_decode('decrypt', $order_number);
                }
                else {
                    $action = "Order Confirmed. Change to OFF. Order Number - ".$obj->encode_decode('decrypt', $order_number);
                }
            }
        
            $columns = array(); $values = array(); $msg = "";				
            $columns = array('confirmed');
            $values = array("'".$confirm_status."'");
            $msg = $obj->UpdateSQL($GLOBALS['order_table'], $order_unique_id, $columns, $values, $action);
            if(preg_match("/^\d+$/", $msg)) {
                $output["head"]["code"] = 200;
                $output["head"]["msg"] = 'Successfully Updated';
            }
            else {
                $output["head"]["code"] = 400;
                $output["head"]["msg"] = $msg;
            }
        }
        else {
            $output["head"]["code"] = 400;
            $output["head"]["msg"] = 'Invalid order';
        }
    }
    else {
        $output["head"]["code"] = 400;
        $output["head"]["msg"] = 'Empty order';
    }
}

if(isset($json_obj->despatched_order_id)) {
    $despatched_order_id = ""; $despatched_status = "";

    $despatched_order_id = $json_obj->despatched_order_id;		
    $despatched_order_id = trim($despatched_order_id);

    $despatched_status = $json_obj->despatched_status;		
    $despatched_status = trim($despatched_status);
    
    if(!empty($despatched_order_id) && ($despatched_status == 1)) {
        $order_unique_id = "";
        $order_unique_id = $obj->getTableColumnValue($GLOBALS['order_table'], 'order_id', $despatched_order_id, 'id');
        if(preg_match("/^\d+$/", $order_unique_id)) {
            $order_number = "";
            $order_number = $obj->getTableColumnValue($GLOBALS['order_table'], 'order_id', $despatched_order_id, 'order_number');
        
            $action = "";
            if(!empty($despatched_status)) {
                if(!empty($despatched)) {
                    $action = "Order despatched. Change to ON. Order Number - ".$obj->encode_decode('decrypt', $order_number);
                }
                else {
                    $action = "Order despatched. Change to OFF. Order Number - ".$obj->encode_decode('decrypt', $order_number);
                }
            }
        
            $columns = array(); $values = array(); $msg = "";				
            $columns = array('despatched');
            $values = array("'".$despatched_status."'");
            $msg = $obj->UpdateSQL($GLOBALS['order_table'], $order_unique_id, $columns, $values, $action);
            if(preg_match("/^\d+$/", $msg)) {
                $output["head"]["code"] = 200;
                $output["head"]["msg"] = 'Successfully Updated';
            }
            else {
                $output["head"]["code"] = 400;
                $output["head"]["msg"] = $msg;
            }
        }
        else {
            $output["head"]["code"] = 400;
            $output["head"]["msg"] = 'Invalid order';
        }
    }
    else {
        $output["head"]["code"] = 400;
        $output["head"]["msg"] = 'Empty order';
    }
}

if(isset($json_obj->delivered_order_id)) {
    $delivery_order_id = $json_obj->delivered_order_id;
    $delivery_order_id = trim($delivery_order_id);

    $delivery_status = $json_obj->delivery_status;
    $delivery_status = trim($delivery_status);

    $delivery_error = "";

    $delivery_number = "";
    if(isset($json_obj->delivery_number)) {
        $delivery_number = $json_obj->delivery_number;
        $delivery_number = trim($delivery_number);
        if(!empty($delivery_number)) {
            $delivery_number_error = "";
            $delivery_number_error = $valid->common_validation($delivery_number, "delivery number", "text");
            if(!empty($delivery_number_error)) {
                $delivery_error = $delivery_number_error;
            }
        }
    }
    $delivery_particulars = "";
    if(isset($json_obj->delivery_particulars)) {
        $delivery_particulars = $json_obj->delivery_particulars;
        $delivery_particulars = trim($delivery_particulars);
        if(!empty($delivery_particulars)) {
            $delivery_particulars_error = "";
            $delivery_particulars_error = $valid->common_validation($delivery_particulars, "particulars", "text");
            if(!empty($delivery_particulars_error)) {
                if(!empty($delivery_error)) {
                    $delivery_error = $delivery_error."<br>".$delivery_particulars_error;
                }
                else {
                    $delivery_error = $delivery_particulars_error;
                }
            }
        }
    }

    if(empty($delivery_error)) {
        if(!empty($delivery_order_id)) {
            $order_unique_id = "";
            $order_unique_id = $obj->getTableColumnValue($GLOBALS['order_table'], 'order_id', $delivery_order_id, 'id');
            if(preg_match("/^\d+$/", $order_unique_id)) {

                if(!empty($delivery_number)) {
                    $delivery_number = $obj->encode_decode('encrypt', $delivery_number);
                }
                else {
                    $delivery_number = $GLOBALS['null_value'];
                }

                if(!empty($delivery_particulars)) {
                    $delivery_particulars = $obj->encode_decode('encrypt', $delivery_particulars);
                }
                else {
                    $delivery_particulars = $GLOBALS['null_value'];
                }

                $order_number = "";
                $order_number = $obj->getTableColumnValue($GLOBALS['order_table'], 'order_id', $delivery_order_id, 'order_number');
            
                $action = "";
                if(!empty($order_number)) {
                    if(!empty($delivery_status)) {
                        $action = "Order Delivered. Change to ON. Order Number - ".$obj->encode_decode('decrypt', $order_number);
                    }
                    else {
                        $action = "Order Delivered. Change to OFF. Order Number - ".$obj->encode_decode('decrypt', $order_number);
                    }
                }

                $delivery_photo = $GLOBALS['null_value'];
            
                $columns = array(); $values = array(); $msg = "";				
                $columns = array('delivered', 'delivery_number', 'delivery_particulars', 'delivery_photo');
                $values = array("'".$delivery_status."'", "'".$delivery_number."'", "'".$delivery_particulars."'", "'".$delivery_photo."'");
                $msg = $obj->UpdateSQL($GLOBALS['order_table'], $order_unique_id, $columns, $values, $action);
                if(preg_match("/^\d+$/", $msg)) {    
                    $output["head"]["code"] = 200;
                    $output["head"]["msg"] = 'Successfully Updated';
                }
                else {
                    $output["head"]["code"] = 400;
                    $output["head"]["msg"] = $msg;
                }
            }
            else {
                $output["head"]["code"] = 400;
                $output["head"]["msg"] = 'Invalid Order';
            }
        }
        else {
            $output["head"]["code"] = 400;
            $output["head"]["msg"] = 'Empty Order';
        }
    }
    else {
        $output["head"]["code"] = 400;
        $output["head"]["msg"] = $delivery_error;
    }
}

$result = json_encode($output, JSON_NUMERIC_CHECK);

echo $result;
?>