

CREATE TABLE `jjc_2023_category` (
  `id` int(100) NOT NULL AUTO_INCREMENT,
  `created_date_time` datetime NOT NULL,
  `creator` mediumtext NOT NULL,
  `creator_name` mediumtext NOT NULL,
  `category_id` mediumtext NOT NULL,
  `name` mediumtext NOT NULL,
  `lower_case_name` mediumtext NOT NULL,
  `ordering` int(11) NOT NULL,
  `show_frontend` int(100) NOT NULL,
  `deleted` int(100) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;



CREATE TABLE `jjc_2023_company` (
  `id` int(100) NOT NULL AUTO_INCREMENT,
  `created_date_time` datetime NOT NULL,
  `creator` mediumtext NOT NULL,
  `creator_name` mediumtext NOT NULL,
  `company_id` mediumtext NOT NULL,
  `name` mediumtext NOT NULL,
  `logo` mediumtext NOT NULL,
  `address` mediumtext NOT NULL,
  `contact_numbers` mediumtext NOT NULL,
  `whatsapp_number` mediumtext NOT NULL,
  `call_us_number` mediumtext NOT NULL,
  `mobile_number` mediumtext NOT NULL,
  `email` mediumtext NOT NULL,
  `ac_name` mediumtext NOT NULL,
  `ac_number` mediumtext NOT NULL,
  `ac_type` mediumtext NOT NULL,
  `bank_name` mediumtext NOT NULL,
  `ifsc_code` mediumtext NOT NULL,
  `running_text` mediumtext NOT NULL,
  `running_text_color` mediumtext NOT NULL,
  `running_text_back_color` mediumtext NOT NULL,
  `running_text_duration` mediumtext NOT NULL,
  `order_prefix` mediumtext NOT NULL,
  `deleted` int(100) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;


INSERT INTO jjc_2023_company (id, created_date_time, creator, creator_name, company_id, name, logo, address, contact_numbers, whatsapp_number, call_us_number, mobile_number, email, ac_name, ac_number, ac_type, bank_name, ifsc_code, running_text, running_text_color, running_text_back_color, running_text_duration, order_prefix, deleted) VALUES ('1','2023-06-28 09:35:45','4e6b5a3054445a464e793946625574746447686c556a42436133426a55543039','56334d7a626e6450526c6c7a636a4a425132563552484e4c625552335647317865574e3553316c305546593257454e5255326f764c336877627a303d','64336c445a486f354d6d355453464d30556c6f3451306476645442725a7a3039','61574636556b5a494b7a46534b335656567a524b576a6445567a42455655395361486445596b527554454648576c567a6547564a4e565a73617a303d','NULL','63486c344e3346434e6b463552323954636d6c4e61465a72556d787a55697450646e457853336c45556c564b576c597a61555a6e55573149515730354b7a5671545539704d3064435557787453474e544e5778794d773d3d','4e6a5632523263776456424e5a6b6c355545387a516b355a5555523355543039','4e6a5632523263776456424e5a6b6c355545387a516b355a5555523355543039','4e6a5632523263776456424e5a6b6c355545387a516b355a5555523355543039','4e6a5632523263776456424e5a6b6c355545387a516b355a5555523355543039','596d4a74623070304c336c4556336779596a5246536b644c515655325a58633556567034636c55346147347854577068596b3944556d6831597a303d','NULL','NULL','NULL','NULL','NULL','574870514d6d7072596d787764455a4852454a545a444656646a466f525856775957564555566f324d5578755a6b565556544232556a4132564773794f44687a596e457656444251524770444e6a5a5657544a49636e464859336b3354466b304d6b466b62327331576b733465566858544645335645566f64544e734f4456735631707162304e43576b356c6246426c51306c78515456695332644d4e6b4e7a5a6d745854486c4c4d56413d','#000000','#ec1f24','12000','65444e716145685a5a4868615633524953466c474c30633461554e4455543039','0');


CREATE TABLE `jjc_2023_customer` (
  `id` int(100) NOT NULL AUTO_INCREMENT,
  `created_date_time` datetime NOT NULL,
  `creator` mediumtext NOT NULL,
  `creator_name` mediumtext NOT NULL,
  `customer_id` mediumtext NOT NULL,
  `name` mediumtext NOT NULL,
  `mobile_number` mediumtext NOT NULL,
  `email` mediumtext NOT NULL,
  `address` mediumtext NOT NULL,
  `city` mediumtext NOT NULL,
  `state` mediumtext NOT NULL,
  `deleted` int(100) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;



CREATE TABLE `jjc_2023_discount` (
  `id` int(100) NOT NULL AUTO_INCREMENT,
  `created_date_time` datetime NOT NULL,
  `creator` mediumtext NOT NULL,
  `creator_name` mediumtext NOT NULL,
  `discount_id` mediumtext NOT NULL,
  `discount` int(100) NOT NULL,
  `category_ids` mediumtext NOT NULL,
  `show_frontend` int(100) NOT NULL,
  `deleted` int(100) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;



CREATE TABLE `jjc_2023_enquiry_customer` (
  `id` int(100) NOT NULL AUTO_INCREMENT,
  `created_date_time` datetime NOT NULL,
  `customer_id` mediumtext NOT NULL,
  `name` mediumtext NOT NULL,
  `mobile_number` mediumtext NOT NULL,
  `login` int(100) NOT NULL,
  `login_details` mediumtext NOT NULL,
  `deleted` int(100) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;



CREATE TABLE `jjc_2023_home_banner` (
  `id` int(100) NOT NULL AUTO_INCREMENT,
  `created_date_time` datetime NOT NULL,
  `creator` mediumtext NOT NULL,
  `creator_name` mediumtext NOT NULL,
  `home_banner_id` mediumtext NOT NULL,
  `home_banner` mediumtext NOT NULL,
  `deleted` int(100) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;


INSERT INTO jjc_2023_home_banner (id, created_date_time, creator, creator_name, home_banner_id, home_banner, deleted) VALUES ('1','2023-10-11 18:49:23','4e6b5a3054445a464e793946625574746447686c556a42436133426a55543039','644735724b326c4c4e586c6a5954424e4d4670364d476c34516c5a4955555a3555334533556a597752453835557a4e68625670785a47387a5154303d','4d30686f4c306b35626e705659325a545957704b645652555956453151543039','home_banner_11_10_2023_06_49_22.webp','0');


CREATE TABLE `jjc_2023_login` (
  `id` int(100) NOT NULL AUTO_INCREMENT,
  `login_date_time` datetime NOT NULL,
  `logout_date_time` datetime NOT NULL,
  `ip_address` mediumtext NOT NULL,
  `browser` mediumtext NOT NULL,
  `os_detail` mediumtext NOT NULL,
  `type` mediumtext NOT NULL,
  `user_id` mediumtext NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;


INSERT INTO jjc_2023_login (id, login_date_time, logout_date_time, ip_address, browser, os_detail, type, user_id) VALUES ('1','2023-10-11 18:48:28','2023-10-11 19:06:47','127.0.0.1','Mozilla/5.0 (Windows NT 10.0; Win64; x64; rv:109.0) Gecko/20100101 Firefox/118.0','Windows NT DESKTOP-RC16R56 10.0 build 19045 (Windows 10) AMD64','Super Admin','4e6b5a3054445a464e793946625574746447686c556a42436133426a55543039');

INSERT INTO jjc_2023_login (id, login_date_time, logout_date_time, ip_address, browser, os_detail, type, user_id) VALUES ('2','2023-10-11 19:08:08','0000-00-00 00:00:00','127.0.0.1','Mozilla/5.0 (Windows NT 10.0; Win64; x64; rv:109.0) Gecko/20100101 Firefox/118.0','Windows NT DESKTOP-RC16R56 10.0 build 19045 (Windows 10) AMD64','Super Admin','4e6b5a3054445a464e793946625574746447686c556a42436133426a55543039');

INSERT INTO jjc_2023_login (id, login_date_time, logout_date_time, ip_address, browser, os_detail, type, user_id) VALUES ('3','2023-10-20 16:19:58','0000-00-00 00:00:00','127.0.0.1','Mozilla/5.0 (Windows NT 10.0; Win64; x64; rv:109.0) Gecko/20100101 Firefox/118.0','Windows NT DESKTOP-1O194FK 10.0 build 22621 (Windows 11) AMD64','Super Admin','4e6b5a3054445a464e793946625574746447686c556a42436133426a55543039');


CREATE TABLE `jjc_2023_mobile_banner` (
  `id` int(100) NOT NULL AUTO_INCREMENT,
  `created_date_time` datetime NOT NULL,
  `creator` mediumtext NOT NULL,
  `creator_name` mediumtext NOT NULL,
  `mobile_banner_id` mediumtext NOT NULL,
  `mobile_banner` mediumtext NOT NULL,
  `deleted` int(100) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;



CREATE TABLE `jjc_2023_order_notification_send` (
  `id` int(100) NOT NULL AUTO_INCREMENT,
  `notification_id` mediumtext NOT NULL,
  `fcm_ids` mediumtext NOT NULL,
  `send_date_time` mediumtext NOT NULL,
  `deleted` int(100) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;



CREATE TABLE `jjc_2023_orders` (
  `id` int(100) NOT NULL AUTO_INCREMENT,
  `created_date_time` datetime NOT NULL,
  `creator` mediumtext NOT NULL,
  `creator_name` mediumtext NOT NULL,
  `order_id` mediumtext NOT NULL,
  `order_type` mediumtext NOT NULL,
  `order_number` mediumtext NOT NULL,
  `order_date` date NOT NULL,
  `company_details` mediumtext NOT NULL,
  `bank_details` mediumtext NOT NULL,
  `customer_id` mediumtext NOT NULL,
  `customer_details` mediumtext NOT NULL,
  `customer_city` mediumtext NOT NULL,
  `delivery_address` mediumtext NOT NULL,
  `category_id` mediumtext NOT NULL,
  `category_name` mediumtext NOT NULL,
  `product_id` mediumtext NOT NULL,
  `product_code` mediumtext NOT NULL,
  `product_name` mediumtext NOT NULL,
  `product_content` mediumtext NOT NULL,
  `quantity` mediumtext NOT NULL,
  `actual_price` mediumtext NOT NULL,
  `price` mediumtext NOT NULL,
  `discount` mediumtext NOT NULL,
  `extra_discount` mediumtext NOT NULL,
  `show_extra_discount_amount` int(100) NOT NULL,
  `minimum_order_amount` mediumtext NOT NULL,
  `packing_charges` mediumtext NOT NULL,
  `promotion_code_id` mediumtext NOT NULL,
  `promotion_code_name` mediumtext NOT NULL,
  `promotion_code_price` mediumtext NOT NULL,
  `promotion_code_discount_value` mediumtext NOT NULL,
  `otp_number` mediumtext NOT NULL,
  `total_amount` mediumtext NOT NULL,
  `new_order` int(100) NOT NULL,
  `confirmed` int(100) NOT NULL,
  `despatched` int(100) NOT NULL,
  `delivered` int(100) NOT NULL,
  `push_notification` int(100) NOT NULL,
  `delivery_number` mediumtext NOT NULL,
  `delivery_particulars` mediumtext NOT NULL,
  `delivery_photo` mediumtext NOT NULL,
  `send_sms_email` int(100) NOT NULL,
  `deleted` int(100) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;



CREATE TABLE `jjc_2023_otp_send_phone_numbers` (
  `id` int(100) NOT NULL AUTO_INCREMENT,
  `send_date_time` datetime NOT NULL,
  `phone_number` mediumtext NOT NULL,
  `otp_number` mediumtext NOT NULL,
  `otp_send_count` int(100) NOT NULL,
  `deleted` int(100) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;



CREATE TABLE `jjc_2023_product` (
  `id` int(100) NOT NULL AUTO_INCREMENT,
  `created_date_time` datetime NOT NULL,
  `creator` mediumtext NOT NULL,
  `creator_name` mediumtext NOT NULL,
  `product_id` mediumtext NOT NULL,
  `category_id` mediumtext NOT NULL,
  `name` mediumtext NOT NULL,
  `lower_case_name` mediumtext NOT NULL,
  `product_code` mediumtext NOT NULL,
  `lower_case_product_code` mediumtext NOT NULL,
  `product_content` mediumtext NOT NULL,
  `price` mediumtext NOT NULL,
  `product_image` mediumtext NOT NULL,
  `product_video` mediumtext NOT NULL,
  `ordering` int(100) NOT NULL,
  `show_frontend` int(100) NOT NULL,
  `deleted` int(100) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;



CREATE TABLE `jjc_2023_promotion_code` (
  `id` int(100) NOT NULL AUTO_INCREMENT,
  `created_date_time` datetime NOT NULL,
  `creator` mediumtext NOT NULL,
  `creator_name` mediumtext NOT NULL,
  `promotion_code_id` mediumtext NOT NULL,
  `name` mediumtext NOT NULL,
  `lower_case_name` mediumtext NOT NULL,
  `price` mediumtext NOT NULL,
  `expiry_date` date NOT NULL,
  `minimum_order_amount` double NOT NULL,
  `discount_upto_value` double NOT NULL,
  `deleted` int(100) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;



CREATE TABLE `jjc_2023_settings` (
  `id` int(100) NOT NULL AUTO_INCREMENT,
  `name` mediumtext NOT NULL,
  `value` mediumtext NOT NULL,
  `deleted` int(100) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=91 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;


INSERT INTO jjc_2023_settings (id, name, value, deleted) VALUES ('1','top_portion_back_color','4d7a52536548525064314578613151774e5852316546465156544272647a3039','0');

INSERT INTO jjc_2023_settings (id, name, value, deleted) VALUES ('2','top_portion_text_color','55486c5652576c435545316e4e6d645363464531523164455357525651543039','0');

INSERT INTO jjc_2023_settings (id, name, value, deleted) VALUES ('3','table_header_back_color','4e485635535656484e585a714f56597a633264554e33647754327778647a3039','0');

INSERT INTO jjc_2023_settings (id, name, value, deleted) VALUES ('4','table_header_text_color','55486c5652576c435545316e4e6d645363464531523164455357525651543039','0');

INSERT INTO jjc_2023_settings (id, name, value, deleted) VALUES ('5','category_background_color','596b4d336432785763446c43566c4e7a53466851644841344e6e704951543039','0');

INSERT INTO jjc_2023_settings (id, name, value, deleted) VALUES ('6','category_text_color','5153744563586868616d3935596e4e77566c46754e6938355647357455543039','0');

INSERT INTO jjc_2023_settings (id, name, value, deleted) VALUES ('7','product_color1','54323554617a5a6f64565a716333526156556c7153466c4e5448424355543039','0');

INSERT INTO jjc_2023_settings (id, name, value, deleted) VALUES ('8','product_color2','54323554617a5a6f64565a716333526156556c7153466c4e5448424355543039','0');

INSERT INTO jjc_2023_settings (id, name, value, deleted) VALUES ('9','text_color','55486c5652576c435545316e4e6d645363464531523164455357525651543039','0');

INSERT INTO jjc_2023_settings (id, name, value, deleted) VALUES ('10','strike_color','55334672526d5230535870495955566d4f4468734f455a7152575a6851543039','0');

INSERT INTO jjc_2023_settings (id, name, value, deleted) VALUES ('11','rate_background_color','#ffff80','0');

INSERT INTO jjc_2023_settings (id, name, value, deleted) VALUES ('12','border_color','55486c5652576c435545316e4e6d645363464531523164455357525651543039','0');

INSERT INTO jjc_2023_settings (id, name, value, deleted) VALUES ('13','show_product_code','1','0');

INSERT INTO jjc_2023_settings (id, name, value, deleted) VALUES ('14','cart_background_color','5153744563586868616d3935596e4e77566c46754e6938355647357455543039','0');

INSERT INTO jjc_2023_settings (id, name, value, deleted) VALUES ('15','footer_content_message','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','0');

INSERT INTO jjc_2023_settings (id, name, value, deleted) VALUES ('16','thankyou_message','634764794e33673257464e4b4c305270546a5a7a56574d78616d6b775233466c5a324678646c59344d6e7076556b5a314e334650515768475154303d','0');

INSERT INTO jjc_2023_settings (id, name, value, deleted) VALUES ('17','frontend_layout','596c4a735743394862576b3265464e314c3046305a484a6e5a304a5151543039','0');

INSERT INTO jjc_2023_settings (id, name, value, deleted) VALUES ('18','giftbox','534846735956493157457734646a4e6b6246424753324e736443746c51543039','0');

INSERT INTO jjc_2023_settings (id, name, value, deleted) VALUES ('19','terms_conditions','NULL','0');

INSERT INTO jjc_2023_settings (id, name, value, deleted) VALUES ('20','desktop_layout','564564545931525a61553079533273305743393262304d3359305a7955543039','0');

INSERT INTO jjc_2023_settings (id, name, value, deleted) VALUES ('21','tab_layout','564564545931525a61553079533273305743393262304d3359305a7955543039','0');

INSERT INTO jjc_2023_settings (id, name, value, deleted) VALUES ('22','mobile_layout','564564545931525a61553079533273305743393262304d3359305a7955543039','0');

INSERT INTO jjc_2023_settings (id, name, value, deleted) VALUES ('23','disable_site','4b3168475955783161336c7163314e3152454635646a56614e6e6f72647a3039','0');

INSERT INTO jjc_2023_settings (id, name, value, deleted) VALUES ('24','enquiry_customer_order_link','NULL','0');

INSERT INTO jjc_2023_settings (id, name, value, deleted) VALUES ('25','enquiry_customer_order_code','NULL','0');

INSERT INTO jjc_2023_settings (id, name, value, deleted) VALUES ('26','list_top_portion_back_color','55334672526d5230535870495955566d4f4468734f455a7152575a6851543039','0');

INSERT INTO jjc_2023_settings (id, name, value, deleted) VALUES ('27','list_top_portion_text_color','5153744563586868616d3935596e4e77566c46754e6938355647357455543039','0');

INSERT INTO jjc_2023_settings (id, name, value, deleted) VALUES ('28','list_table_header_back_color','4d327436626e6f3363544e33537a4a444e56553565446c5a566a425051543039','0');

INSERT INTO jjc_2023_settings (id, name, value, deleted) VALUES ('29','list_table_header_text_color','55334672526d5230535870495955566d4f4468734f455a7152575a6851543039','0');

INSERT INTO jjc_2023_settings (id, name, value, deleted) VALUES ('30','list_category_background_color','#800000','0');

INSERT INTO jjc_2023_settings (id, name, value, deleted) VALUES ('31','list_category_text_color','#ffff80','0');

INSERT INTO jjc_2023_settings (id, name, value, deleted) VALUES ('32','list_product_color1','#ffff80','0');

INSERT INTO jjc_2023_settings (id, name, value, deleted) VALUES ('33','list_product_color2','#ffff80','0');

INSERT INTO jjc_2023_settings (id, name, value, deleted) VALUES ('34','list_text_color','#400000','0');

INSERT INTO jjc_2023_settings (id, name, value, deleted) VALUES ('35','list_strike_color','#000000','0');

INSERT INTO jjc_2023_settings (id, name, value, deleted) VALUES ('36','list_border_color','#000000','0');

INSERT INTO jjc_2023_settings (id, name, value, deleted) VALUES ('37','grid_top_portion_back_color','576c6c7455316c7a59544a4e626e5676556c4535516b526f6157787051543039','0');

INSERT INTO jjc_2023_settings (id, name, value, deleted) VALUES ('38','grid_top_portion_text_color','5153744563586868616d3935596e4e77566c46754e6938355647357455543039','0');

INSERT INTO jjc_2023_settings (id, name, value, deleted) VALUES ('39','grid_category_background_color','#ffff80','0');

INSERT INTO jjc_2023_settings (id, name, value, deleted) VALUES ('40','grid_category_text_color','#804040','0');

INSERT INTO jjc_2023_settings (id, name, value, deleted) VALUES ('41','grid_product_color1','#ffff80','0');

INSERT INTO jjc_2023_settings (id, name, value, deleted) VALUES ('42','grid_product_color2','#ffff80','0');

INSERT INTO jjc_2023_settings (id, name, value, deleted) VALUES ('43','grid_text_color','#000000','0');

INSERT INTO jjc_2023_settings (id, name, value, deleted) VALUES ('44','grid_strike_color','#8d8d8d','0');

INSERT INTO jjc_2023_settings (id, name, value, deleted) VALUES ('45','pdf_font_size','9','0');

INSERT INTO jjc_2023_settings (id, name, value, deleted) VALUES ('46','category_based_multiple_image_upload','NULL','0');

INSERT INTO jjc_2023_settings (id, name, value, deleted) VALUES ('47','show_promotion_code','2','0');

INSERT INTO jjc_2023_settings (id, name, value, deleted) VALUES ('48','otp_verification','2','0');

INSERT INTO jjc_2023_settings (id, name, value, deleted) VALUES ('49','desktop_box_count','NULL','0');

INSERT INTO jjc_2023_settings (id, name, value, deleted) VALUES ('50','list_topbar_background_color','#c3c3c3','0');

INSERT INTO jjc_2023_settings (id, name, value, deleted) VALUES ('51','list_topbar_text_color','#000000','0');

INSERT INTO jjc_2023_settings (id, name, value, deleted) VALUES ('52','list_topbar_category_background_color','#800000','0');

INSERT INTO jjc_2023_settings (id, name, value, deleted) VALUES ('53','list_topbar_category_text_color','#ffff80','0');

INSERT INTO jjc_2023_settings (id, name, value, deleted) VALUES ('54','list_topbar_rupees_background_color','#800000','0');

INSERT INTO jjc_2023_settings (id, name, value, deleted) VALUES ('55','list_topbar_rupees_text_color','#ffff80','0');

INSERT INTO jjc_2023_settings (id, name, value, deleted) VALUES ('56','list_table_head_color','#400040','0');

INSERT INTO jjc_2023_settings (id, name, value, deleted) VALUES ('57','list_table_head_text_color','#f1f1f1','0');

INSERT INTO jjc_2023_settings (id, name, value, deleted) VALUES ('58','grid_topbar_background_color','#ff8040','0');

INSERT INTO jjc_2023_settings (id, name, value, deleted) VALUES ('59','grid_topbar_text_color','#6c3600','0');

INSERT INTO jjc_2023_settings (id, name, value, deleted) VALUES ('60','grid_topbar_category_background_color','#ffff80','0');

INSERT INTO jjc_2023_settings (id, name, value, deleted) VALUES ('61','grid_topbar_category_text_color','#800040','0');

INSERT INTO jjc_2023_settings (id, name, value, deleted) VALUES ('62','grid_topbar_rupees_background_color','#800000','0');

INSERT INTO jjc_2023_settings (id, name, value, deleted) VALUES ('63','grid_topbar_rupees_text_color','#ffff80','0');

INSERT INTO jjc_2023_settings (id, name, value, deleted) VALUES ('64','grid_border_color','#000000','0');

INSERT INTO jjc_2023_settings (id, name, value, deleted) VALUES ('65','rate_text_color','#000000','0');

INSERT INTO jjc_2023_settings (id, name, value, deleted) VALUES ('66','grid_product_code_background_color','#ffff80','0');

INSERT INTO jjc_2023_settings (id, name, value, deleted) VALUES ('67','grid_product_code_text_color','#000000','0');

INSERT INTO jjc_2023_settings (id, name, value, deleted) VALUES ('68','box_topbar_background_color','#804040','0');

INSERT INTO jjc_2023_settings (id, name, value, deleted) VALUES ('69','box_topbar_text_color','#ffff80','0');

INSERT INTO jjc_2023_settings (id, name, value, deleted) VALUES ('70','box_topbar_category_background_color','#ffff80','0');

INSERT INTO jjc_2023_settings (id, name, value, deleted) VALUES ('71','box_topbar_category_text_color','#804040','0');

INSERT INTO jjc_2023_settings (id, name, value, deleted) VALUES ('72','box_topbar_rupees_background_color','#800000','0');

INSERT INTO jjc_2023_settings (id, name, value, deleted) VALUES ('73','box_topbar_rupees_text_color','#ffff80','0');

INSERT INTO jjc_2023_settings (id, name, value, deleted) VALUES ('74','box_category_background_color','#ffff80','0');

INSERT INTO jjc_2023_settings (id, name, value, deleted) VALUES ('75','box_category_text_color','#800000','0');

INSERT INTO jjc_2023_settings (id, name, value, deleted) VALUES ('76','box_strike_color','#000000','0');

INSERT INTO jjc_2023_settings (id, name, value, deleted) VALUES ('77','box_product_code_background_color','#ffff80','0');

INSERT INTO jjc_2023_settings (id, name, value, deleted) VALUES ('78','box_product_code_text_color','#800000','0');

INSERT INTO jjc_2023_settings (id, name, value, deleted) VALUES ('79','new_arrivals_category_count','1','0');

INSERT INTO jjc_2023_settings (id, name, value, deleted) VALUES ('80','new_arrivals_headings','NULL','0');

INSERT INTO jjc_2023_settings (id, name, value, deleted) VALUES ('81','new_arrivals_products','NULL','0');

INSERT INTO jjc_2023_settings (id, name, value, deleted) VALUES ('82','pricelist_display_in_home_page','2','0');

INSERT INTO jjc_2023_settings (id, name, value, deleted) VALUES ('83','download_pricelist_pdf_in_frontend','1','0');

INSERT INTO jjc_2023_settings (id, name, value, deleted) VALUES ('84','show_discoun_row','2','0');

INSERT INTO jjc_2023_settings (id, name, value, deleted) VALUES ('85','show_category_filter','2','0');

INSERT INTO jjc_2023_settings (id, name, value, deleted) VALUES ('86','show_search_filter','2','0');

INSERT INTO jjc_2023_settings (id, name, value, deleted) VALUES ('87','disable_page_form','2','0');

INSERT INTO jjc_2023_settings (id, name, value, deleted) VALUES ('88','disable_page_image','NULL','0');

INSERT INTO jjc_2023_settings (id, name, value, deleted) VALUES ('89','product_price_display_format','1','0');

INSERT INTO jjc_2023_settings (id, name, value, deleted) VALUES ('90','apply_frontend_actual_rate','1','0');


CREATE TABLE `jjc_2023_settings_private` (
  `id` int(100) NOT NULL AUTO_INCREMENT,
  `name` mediumtext NOT NULL,
  `value` mediumtext NOT NULL,
  `deleted` int(100) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;



CREATE TABLE `jjc_2023_staff` (
  `id` int(100) NOT NULL AUTO_INCREMENT,
  `created_date_time` datetime NOT NULL,
  `creator` mediumtext NOT NULL,
  `creator_name` mediumtext NOT NULL,
  `staff_id` mediumtext NOT NULL,
  `name` mediumtext NOT NULL,
  `mobile_number` mediumtext NOT NULL,
  `user_id` mediumtext NOT NULL,
  `password` mediumtext NOT NULL,
  `access_pages` mediumtext NOT NULL,
  `deleted` int(100) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;



CREATE TABLE `jjc_2023_state_city` (
  `id` int(100) NOT NULL AUTO_INCREMENT,
  `state` mediumtext NOT NULL,
  `minimum_order_amount` mediumtext NOT NULL,
  `packing_charges` mediumtext NOT NULL,
  `all_cities` int(100) NOT NULL,
  `cities` mediumtext NOT NULL,
  `deleted` int(100) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;


INSERT INTO jjc_2023_state_city (id, state, minimum_order_amount, packing_charges, all_cities, cities, deleted) VALUES ('1','656b4a7956476f344e6a42685132357057546c73626e466e5647703051543039','NULL','NULL','1','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','0');


CREATE TABLE `jjc_2023_user` (
  `id` int(100) NOT NULL AUTO_INCREMENT,
  `created_date_time` datetime NOT NULL,
  `creator` mediumtext NOT NULL,
  `creator_name` mediumtext NOT NULL,
  `staff_id` mediumtext NOT NULL,
  `user_id` mediumtext NOT NULL,
  `name` mediumtext NOT NULL,
  `mobile_number` mediumtext NOT NULL,
  `type` mediumtext NOT NULL,
  `code` mediumtext NOT NULL,
  `lower_case_code` mediumtext NOT NULL,
  `password` mediumtext NOT NULL,
  `admin` int(100) NOT NULL,
  `fcm_id` mediumtext NOT NULL,
  `deleted` int(11) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=11 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;


INSERT INTO jjc_2023_user (id, created_date_time, creator, creator_name, staff_id, user_id, name, mobile_number, type, code, lower_case_code, password, admin, fcm_id, deleted) VALUES ('1','2021-07-12 09:44:21','VzBuVkJYUEp1b0VHOVdyOVRCN05HZz09','5a6d746c4e6d4a346544566c51553174616e64696130686a544864495a7a3039','NULL','4e6b5a3054445a464e793946625574746447686c556a42436133426a55543039','644735724b326c4c4e586c6a5954424e4d4670364d476c34516c5a4955555a3555334533556a597752453835557a4e68625670785a47387a5154303d','4d304e565954677a5257787a63323536643031754e48687751546c4b5a7a3039','4f445a70596e4130656a593053324e55616e64565655645a563156585a7a3039','5a6d746c4e6d4a346544566c51553174616e64696130686a544864495a7a3039','5232684b4b3034345a305a7862315a316232356955587077544756334f44687a636d51344e6d5a51553278794d554e576244644f4e55633461453946557a567963577730523355794d57707a525546554d6d6451525664765433524a4d544e58547a42596345785355566c71656a4a73513342475a554e6b556c5a4964553933625852544d554e535369747953476339','63455669576a64614d30643157444a5261304a785a79746e52565178647a3039','1','','0');
