<?php
    class Billing_Functions extends Basic_Functions {
		public function CheckUnitNameAlreadyExists($bill_company_id, $unit_name) {
			$list = array(); $select_query = ""; $unit_id = "";
			if(!empty($bill_company_id) && !empty($unit_name)) {
				$select_query = "SELECT unit_id FROM ".$GLOBALS['unit_table']." WHERE lower_case_name = '".$unit_name."' AND deleted = '0'";	
			}
			//echo $select_query;
			if(!empty($select_query)) {
				$list = $this->getQueryRecords($GLOBALS['unit_table'], $select_query);
				if(!empty($list)) {
					foreach($list as $data) {
						if(!empty($data['unit_id'])) {
							$unit_id = $data['unit_id'];
						}
					}
				}
			}
			return $unit_id;
		}
		public function CheckProductCodeAlreadyExists($bill_company_id, $product_code) {
			$list = array(); $select_query = ""; $product_id = "";
			if(!empty($bill_company_id) && !empty($product_code)) {
				$select_query = "SELECT product_id FROM ".$GLOBALS['product_table']." WHERE bill_company_id = '".$bill_company_id."' AND product_code = '".$product_code."' AND deleted = '0'";	
			}
			//echo $select_query;
			if(!empty($select_query)) {
				$list = $this->getQueryRecords($GLOBALS['product_table'], $select_query);
				if(!empty($list)) {
					foreach($list as $data) {
						if(!empty($data['product_id'])) {
							$product_id = $data['product_id'];
						}
					}
				}
			}
			return $product_id;
		}

		public function CheckProductNameAlreadyExists($bill_company_id, $product_name) {
			$list = array(); $select_query = ""; $product_id = "";
			if(!empty($bill_company_id) && !empty($product_name)) {
				$select_query = "SELECT product_id FROM ".$GLOBALS['product_table']." WHERE bill_company_id = '".$bill_company_id."' AND lower_case_name = '".$product_name."' AND deleted = '0'";	
			}
			//echo $select_query;
			if(!empty($select_query)) {
				$list = $this->getQueryRecords($GLOBALS['product_table'], $select_query);
				if(!empty($list)) {
					foreach($list as $data) {
						if(!empty($data['product_id'])) {
							$product_id = $data['product_id'];
						}
					}
				}
			}
			return $product_id;
		}

		public function BillCompanyDetails($bill_company_id, $table) {
			$bill_company_details = "";
			if(!empty($bill_company_id)) {
				$check_company = array();
				$check_company = $this->getTableRecords($GLOBALS['company_table'], '','');
				if(!empty($check_company)) {
					foreach($check_company as $data) {
						/*if(!empty($table) && $table == $GLOBALS['invoice_table']) {
							if(!empty($data['invoice_company_name'])) {
								$bill_company_details = $this->encode_decode('decrypt', $data['invoice_company_name']);
							}
							if(!empty($data['invoice_address'])) {
								$bill_company_details = $bill_company_details."$$$".$this->encode_decode('decrypt', $data['invoice_address']);
							}
						}
						else {*/
							if(!empty($data['name'])) {
								$bill_company_details = $this->encode_decode('decrypt', $data['name']);
							}
							if(!empty($data['address'])) {
								$bill_company_details = $bill_company_details."$$$".$this->encode_decode('decrypt', $data['address']);
							}
						//}
						if(!empty($data['state'])) {
							$bill_company_details = $bill_company_details."$$$".$this->encode_decode('decrypt', $data['state']);
						}
						if(!empty($data['mobile_number']) && $data['mobile_number'] != $GLOBALS['null_value']) {
							$bill_company_details = $bill_company_details."$$$".$this->encode_decode('decrypt', $data['mobile_number']);
						}
						else {
							$bill_company_details = $bill_company_details."$$$".$GLOBALS['null_value'];
						}
						if(!empty($data['email']) && $data['email'] != $GLOBALS['null_value']) {
							$bill_company_details = $bill_company_details."$$$".$this->encode_decode('decrypt', $data['email']);
						}
						else {
							$bill_company_details = $bill_company_details."$$$".$GLOBALS['null_value'];
						}
						if(!empty($data['gst_number']) && $data['gst_number'] != $GLOBALS['null_value']) {
							$bill_company_details = $bill_company_details."$$$".$this->encode_decode('decrypt', $data['gst_number']);
						}
						else {
							$bill_company_details = $bill_company_details."$$$".$GLOBALS['null_value'];
						}
					}
				}
				if(!empty($bill_company_details)) {
					$bill_company_details = $this->encode_decode('encrypt', $bill_company_details);
				}
			}
			return $bill_company_details;
		}
	

		public function PartyDetails($party_id) {
			$party_details = "";
			if(!empty($party_id)) {
				$check_party = array();
				$check_party = $this->getTableRecords($GLOBALS['purchase_party_table'], 'purchase_party_id', $party_id);
				if(!empty($check_party)) {
					foreach($check_party as $data) {
						if(!empty($data['name'])) {
							$party_details = $this->encode_decode('decrypt', $data['name']);
						}
						if(!empty($data['address']) && $data['address'] != $GLOBALS['null_value']) {
							$party_details = $party_details."$$$".$this->encode_decode('decrypt', $data['address']);
						}
						if(!empty($data['city']) && $data['city'] != $GLOBALS['null_value']) {
							$party_details = $party_details."$$$".$this->encode_decode('decrypt', $data['city']);
						}
						if(!empty($data['state'])) {
							$party_details = $party_details."$$$".$this->encode_decode('decrypt', $data['state']);
						}
						if(!empty($data['mobile_number']) && $data['mobile_number'] != $GLOBALS['null_value']) {
							$party_details = $party_details."$$$".$this->encode_decode('decrypt', $data['mobile_number']);
						}
						else {
							$party_details = $party_details."$$$".$GLOBALS['null_value'];
						}
						if(!empty($data['email']) && $data['email'] != $GLOBALS['null_value']) {
							$party_details = $party_details."$$$".$this->encode_decode('decrypt', $data['email']);
						}
						else {
							$party_details = $party_details."$$$".$GLOBALS['null_value'];
						}
						if(!empty($data['gst_number']) && $data['gst_number'] != $GLOBALS['null_value']) {
							$party_details = $party_details."$$$".$this->encode_decode('decrypt', $data['gst_number']);
						}
						else {
							$party_details = $party_details."$$$".$GLOBALS['null_value'];
						}
						if(!empty($data['identification']) && $data['identification'] != $GLOBALS['null_value']) {
							$party_details = $party_details."$$$".$this->encode_decode('decrypt', $data['identification']);
						}
						else {
							$party_details = $party_details."$$$".$GLOBALS['null_value'];
						}
					}
				}
				if(!empty($party_details)) {
					$party_details = $this->encode_decode('encrypt', $party_details);
				}
			}
			return $party_details;
		}

		public function CheckPlanNameAlreadyExists($bill_company_id, $plan_name) {
			$list = array(); $select_query = ""; $plan_id = "";
			if(!empty($bill_company_id) && !empty($plan_name)) {
				$select_query = "SELECT plan_id FROM ".$GLOBALS['plan_table']." WHERE lower_case_name = '".$plan_name."' AND deleted = '0'";	
			}
			//echo $select_query;
			if(!empty($select_query)) {
				$list = $this->getQueryRecords($GLOBALS['plan_table'], $select_query);
				if(!empty($list)) {
					foreach($list as $data) {
						if(!empty($data['plan_id'])) {
							$plan_id = $data['plan_id'];
						}
					}
				}
			}
			return $plan_id;
		}

		public function BonusUpdate($reference_id) {
			$reference = ""; $bonus_update = ""; $msg = ""; 
			$reference = $reference_id;
			$reference = $this->encode_decode("decrypt", $reference);
			$reference = explode("/", $reference);
			if($reference[0] == "MVMMM") {
				if(!empty($reference_id)) {	
					$manager_unique_id = ""; 
					$manager_unique_id = $this->getTableColumnValue($GLOBALS['manager_table'], 'manager_unique_id', $reference_id, 'id');
					$bonus_point = $this->getTableColumnValue($GLOBALS['manager_table'], 'manager_unique_id', $reference_id, 'bonus_point'); 					
					if(empty($bonus_point)) {
						$bonus_point = 0;
					}
					$bonus_point = $bonus_point + 300;
					if(preg_match("/^\d+$/", $manager_unique_id)) {
						$manager_name = "";
						$manager_name = $this->getTableColumnValue($GLOBALS['manager_table'], 'manager_unique_id', $reference_id, 'manager_name');
					
						$action = "";
						if(!empty($manager_name)) {
							$action = "Bonus Point Added For Reference. Name - ".$this->encode_decode('decrypt', $manager_name);
						}
					
						$columns = array(); $values = array();						
						$columns = array('bonus_point');
						$values = array("'".$bonus_point."'");
						$msg = $this->UpdateSQL($GLOBALS['manager_table'], $manager_unique_id, $columns, $values, $action);
					}
				}
			} 
			else if($reference[0] == "MVMME") {
				if(!empty($reference_id)) {	
					$member_unique_id = ""; 
					$member_unique_id = $this->getTableColumnValue($GLOBALS['member_table'], 'member_unique_id', $reference_id, 'id');
					$bonus_point = $this->getTableColumnValue($GLOBALS['member_table'], 'member_unique_id', $reference_id, 'bonus_point');
					$manager_id = $this->getTableColumnValue($GLOBALS['member_table'], 'member_unique_id', $reference_id, 'manager_id');
					if(empty($bonus_point)) {
						$bonus_point = 0;
					}
					$bonus_point = $bonus_point + 300;
					if(preg_match("/^\d+$/", $member_unique_id)) {
						$member_name = "";
						$member_name = $this->getTableColumnValue($GLOBALS['member_table'], 'member_unique_id', $reference_id, 'member_name');
					
						$action = "";
						if(!empty($member_name)) {
							$action = "Bonus Point Added For Reference. Name - ".$this->encode_decode('decrypt', $member_name);
						}
					
						$columns = array(); $values = array();						
						$columns = array('bonus_point');
						$values = array("'".$bonus_point."'");
						$msg = $this->UpdateSQL($GLOBALS['member_table'], $member_unique_id, $columns, $values, $action);
					}

					if(!empty($manager_id)) {
						$manager_unique_id = "";
						$manager_unique_id =  $this->getTableColumnValue($GLOBALS['manager_table'], 'manager_unique_id', $manager_id, 'id');
						$manager_name = ""; 
						$manager_name = $this->getTableColumnValue($GLOBALS['manager_table'], 'manager_unique_id', $manager_id, 'manager_name');
						$bonus_point = $this->getTableColumnValue($GLOBALS['manager_table'], 'manager_unique_id', $manager_id, 'bonus_point');
						if(empty($bonus_point)) {
							$bonus_point = 0;
						}
						$bonus_point = $bonus_point + 100;
					
						$action = "";
						if(!empty($manager_name)) {
							$action = "Bonus Point Added For Reference. Name - ".$this->encode_decode('decrypt', $manager_name);
						}
					
						$columns = array(); $values = array();						
						$columns = array('bonus_point');
						$values = array("'".$bonus_point."'");
						$msg = $this->UpdateSQL($GLOBALS['manager_table'], $manager_unique_id, $columns, $values, $action);
					}
				}
			}
			if(!empty($msg)) {
				$bonus_update = $msg;
			}
			return $bonus_update;
	
		}

		public function MemberDetails($member_unique_id, $view_type) {
			$member_details = "";
			if(!empty($member_unique_id)) {
				if($view_type == 1) {
					$check_member = array();
					$check_member = $this->getTableRecords($GLOBALS['manager_table'], 'manager_unique_id', $member_unique_id);
					if(!empty($check_member)) {
						foreach($check_member as $data) {
							if(!empty($data['manager_name'])) {
								$member_details = $this->encode_decode('decrypt', $data['manager_name']);
							}
							if(!empty($data['address']) && $data['address'] != $GLOBALS['null_value']) {
								$member_details = $member_details."$$$".$this->encode_decode('decrypt', $data['address']);
							}
							if(!empty($data['city']) && $data['city'] != $GLOBALS['null_value']) {
								$member_details = $member_details."$$$".$this->encode_decode('decrypt', $data['city']);
							}
							if(!empty($data['state'])) {
								$member_details = $member_details."$$$".$this->encode_decode('decrypt', $data['state']);
							}
							if(!empty($data['mobile_number']) && $data['mobile_number'] != $GLOBALS['null_value']) {
								$member_details = $member_details."$$$".$this->encode_decode('decrypt', $data['mobile_number']);
							}
							else {
								$member_details = $member_details."$$$".$GLOBALS['null_value'];
							} 						
						}
					}
				} else {
					$check_member = array();
					$check_member = $this->getTableRecords($GLOBALS['member_table'], 'member_unique_id', $member_unique_id);
					if(!empty($check_member)) {
						foreach($check_member as $data) {
							if(!empty($data['member_name'])) {
								$member_details = $this->encode_decode('decrypt', $data['member_name']);
							}
							if(!empty($data['address']) && $data['address'] != $GLOBALS['null_value']) {
								$member_details = $member_details."$$$".$this->encode_decode('decrypt', $data['address']);
							}
							if(!empty($data['city']) && $data['city'] != $GLOBALS['null_value']) {
								$member_details = $member_details."$$$".$this->encode_decode('decrypt', $data['city']);
							}
							if(!empty($data['state'])) {
								$member_details = $member_details."$$$".$this->encode_decode('decrypt', $data['state']);
							}
							if(!empty($data['mobile_number']) && $data['mobile_number'] != $GLOBALS['null_value']) {
								$member_details = $member_details."$$$".$this->encode_decode('decrypt', $data['mobile_number']);
							}
							else {
								$member_details = $member_details."$$$".$GLOBALS['null_value'];
							} 						
						}
					}
				}
				if(!empty($member_details)) {
					$member_details = $this->encode_decode('encrypt', $member_details);
				}
			}
			return $member_details;
		}

		function MemberWalletAmount($member_id) {

			$wallet_amount = 0; $receipt_query = "";

			if(!empty($member_id)) {
				$receipt_query = "SELECT sum(amount) as paid_amount FROM ".$GLOBALS['receipt_table']." WHERE member_id='".$member_id."' AND deleted='0' ORDER BY receipt_date ASC" ;
			}

			if(!empty($receipt_query)) {
				$list = $this->getQueryRecords('', $receipt_query);
				if(!empty($list)) {
					foreach($list as $data) {
						$wallet_amount = $data['paid_amount'];
					}
				}
			}

			return $wallet_amount;
		}
		function getPendingApprovalList() {

			$pending_list =  array();

			$select_query = "SELECT * FROM ".$GLOBALS['member_table']." WHERE is_approved='0' AND is_rejected='0' AND deleted='0' Order by id ASC"; 

			if(!empty($select_query)) {
				$pending_list = $this->getQueryRecords($GLOBALS['member_table'], $select_query);
			}

			return $pending_list;
		}

		function getMemeberRejectedList() {
			$rejected_list =  array();

			$select_query = "SELECT * FROM ".$GLOBALS['member_table']." WHERE is_rejected='1' AND deleted='0' Order by id ASC"; 

			if(!empty($select_query)) {
				$rejected_list = $this->getQueryRecords($GLOBALS['member_table'], $select_query);
			}

			return $rejected_list;
		}

		public function getReceiptList($manager_id,$member_id,$plan_id,$from_date, $to_date) {
			$list = array(); $select_query = ""; $where = "";

			if(!empty($manager_id)) {
				$where = "manager_id = '".$manager_id."' AND";
			}

			if(!empty($member_id)) {
				if(!empty($where)) {
					$where = $where." member_id = '".$member_id."' AND";
				}
				else {
					$where = "member_id = '".$member_id."' AND";
				}
			}
			
			if(!empty($plan_id)) {
				if(!empty($where)) {
					$where = $where." plan_id = '".$plan_id."' AND";
				}
				else {
					$where = "plan_id = '".$plan_id."' AND";
				}
			}
			if(!empty($from_date)) {
				$from_date = date("Y-m-d", strtotime($from_date));
				if(!empty($where)) {
					$where = $where." receipt_date >= '".$from_date."' AND";
				}
				else {
					$where = "receipt_date >= '".$from_date."' AND";
				}
			}
			
			if(!empty($to_date)) {
				$to_date = date("Y-m-d", strtotime($to_date));
				if(!empty($where)) {
					$where = $where." receipt_date <= '".$to_date."' AND";
				}
				else {
					$where = "receipt_date <= '".$to_date."' AND";
				}
			}

			// if(!empty($where)) {
				
				$select_query = "SELECT * FROM ".$GLOBALS['receipt_table']." WHERE ".$where." deleted = '0' AND is_approved='1' ORDER BY id DESC";
			// }
			if(!empty($select_query)) {
				$list = $this->getQueryRecords($GLOBALS['receipt_table'], $select_query);
			}
			return $list;
		}

		function getPendingAcknowledgementList($member_id) {

			$where = "";

			if(!empty($member_id)) {
				if(!empty($where)) {
					$where = $where." member_id = '".$member_id."' AND";
				}
				else {
					$where = "member_id = '".$member_id."' AND";
				}
			}

			$pending_ack_list =  array();

			if(!empty($where)) {
				$select_query = "SELECT * FROM ".$GLOBALS['receipt_table']." WHERE ".$where." is_approved='0' AND is_rejected='0' AND deleted='0'"; 
			}
			else {
				$select_query = "SELECT * FROM ".$GLOBALS['receipt_table']." WHERE is_approved='0' AND is_rejected='0' AND deleted='0'"; 
			}

			if(!empty($select_query)) {
				$pending_ack_list = $this->getQueryRecords($GLOBALS['receipt_table'], $select_query);
			}

			return $pending_ack_list;
		}

		function deleteMember($member_id) {
			if(!empty($member_id)) {	
				$member_unique_id = ""; 
				$member_unique_id = $this->getTableColumnValue($GLOBALS['member_table'], 'member_unique_id', $member_id, 'id');
				
				if(preg_match("/^\d+$/", $member_unique_id)) {
					$member_name = "";
					$member_name = $this->getTableColumnValue($GLOBALS['member_table'], 'member_unique_id', $member_id, 'member_name');
				
					$action = "";
					if(!empty($member_name)) {
						$action = "Member Deleted through Plan Closure. Name - ".$this->encode_decode('decrypt', $member_name);
					}
				
					$columns = array(); $values = array();						
					$columns = array('deleted');
					$values = array("'1'");
					$msg = $this->UpdateSQL($GLOBALS['member_table'], $member_unique_id, $columns, $values, $action);
				}
			}			
		}

		public function getManagerReportDetails($manager_id) {
			$list = array(); $select_query = ""; $where = "";

			if(!empty($manager_id)) {
				$where = "manager_id = '".$manager_id."' AND";
			} 
			
			if(!empty($where)) { 				
				$select_query = "SELECT * FROM ".$GLOBALS['member_table']." WHERE ".$where." deleted = '0' ORDER BY id DESC";
			}
			else {
				$select_query = "SELECT * FROM ".$GLOBALS['manager_table']." WHERE deleted = '0' ORDER BY id DESC";
			}

			if(!empty($select_query)) {
				$list = $this->getQueryRecords($GLOBALS['manager_table'], $select_query);
			}
			return $list;
		}

		public function getMemberReportDetails($member_id) {
			$list = array(); $select_query = ""; $where = "";

			if(!empty($member_id)) {
				$where = "reference_id = '".$member_id."' AND";
			} 
			
			if(!empty($where)) {
				
				$select_query = "SELECT * FROM ".$GLOBALS['member_table']." WHERE ".$where." deleted = '0' AND is_approved='1' AND is_rejected ='0' ORDER BY id DESC";
			} else {
				$select_query = "SELECT * FROM ".$GLOBALS['member_table']." WHERE deleted = '0' AND is_approved='1' AND is_rejected ='0' ORDER BY id DESC";
			}
			if(!empty($select_query)) {
				$list = $this->getQueryRecords($GLOBALS['member_table'], $select_query);
			}
			return $list;
		}

		public function balance_report($type, $member_id) {
			// echo "hello" .$type;
			$con = $this->connect();
			$select_query = ""; $list = array(); $reports = array(); $purchase_query = ""; $receipt_query = ""; $sales_query = "";
			
			if(!empty($member_id)) { 		
				if($type == "member") {		
					$select_query = "SELECT member_unique_id, member_name, mobile_number, plan_id, bonus_point FROM ".$GLOBALS['member_table']." WHERE member_unique_id = '".$member_id."' AND deleted = '0' AND is_approved='1' AND is_rejected='0'";
					$list = $this->getQueryRecords($GLOBALS['member_table'], $select_query);
					if(!empty($list)) {
						foreach($list as $data) {
							if(!empty($data['member_unique_id'])) {
								$bill_list = array();

								$plan_query = "SELECT created_date_time as bill_date, plan_closure_number as bill_number, 'plan closing' as bill_type, '0' as credit, paid_amount as debit FROM ".$GLOBALS['plan_closure_table']." WHERE member_id = '".$data['member_unique_id']."' AND deleted = '0'";

								$receipt_query = "SELECT receipt_date as bill_date, receipt_number as bill_number, 'Receipt' as bill_type, amount as credit, '0' as debit FROM ".$GLOBALS['receipt_table']." WHERE member_id = '".$data['member_unique_id']."' AND deleted = '0' AND is_approved='1' AND is_rejected='0'";

								$select_query = "SELECT bill_date, bill_number, bill_type, credit, debit FROM ( (".$plan_query.") UNION ALL (".$receipt_query.") ) as g ORDER BY g.bill_date ASC"; 

								$bill_list = $this->getQueryRecords($GLOBALS['member_table'], $select_query);

								$reports[] = array('party_id' => $data['member_unique_id'], 'party_name' => $data['member_name'], 'party_mobile_number' => $data['mobile_number'],"bonus_point" => $data['bonus_point'],'bill_list' => $bill_list);
							}
						}
					}
				} else {
					$select_query = "SELECT manager_unique_id, manager_name, mobile_number, plan_id, bonus_point FROM ".$GLOBALS['manager_table']." WHERE manager_unique_id = '".$member_id."' AND deleted = '0'";
					$list = $this->getQueryRecords($GLOBALS['manager_table'], $select_query);
					if(!empty($list)) {
						foreach($list as $data) {
							if(!empty($data['manager_unique_id'])) {
								$bill_list = array();

								$plan_query = "SELECT created_date_time as bill_date, plan_closure_number as bill_number, 'plan closing' as bill_type, '0' as credit, paid_amount as debit FROM ".$GLOBALS['plan_closure_table']." WHERE member_id = '".$data['manager_unique_id']."' AND deleted = '0'";

								$receipt_query = "SELECT receipt_date as bill_date, receipt_number as bill_number, 'Receipt' as bill_type, amount as credit, '0' as debit FROM ".$GLOBALS['receipt_table']." WHERE member_id = '".$data['manager_unique_id']."' AND deleted = '0' AND is_approved='1' AND is_rejected='0'";

								$select_query = "SELECT bill_date, bill_number, bill_type, credit, debit FROM ( (".$plan_query.") UNION ALL (".$receipt_query.") ) as g ORDER BY g.bill_date ASC"; 

								$bill_list = $this->getQueryRecords($GLOBALS['manager_table'], $select_query);

								$reports[] = array('party_id' => $data['manager_unique_id'], 'party_name' => $data['manager_name'], 'party_mobile_number' => $data['mobile_number'],"bonus_point" => $data['bonus_point'],'bill_list' => $bill_list);
							}
						}
					}
				}
			} 			
			else { 	

				$member_query = "SELECT 'member' as party_type, sp.member_unique_id as party_id, sp.member_name as party_name, sp.mobile_number as party_mobile_number, sp.bonus_point, (SELECT SUM(r.amount) FROM ".$GLOBALS['receipt_table']." as r WHERE r.member_id = sp.member_unique_id AND r.deleted = '0' and r.is_approved='1' AND r.is_rejected='0' GROUP BY r.member_id) as credit,(SELECT SUM(pv.paid_amount) FROM ".$GLOBALS['plan_closure_table']." as pv WHERE pv.plan_id = sp.plan_id AND pv.deleted = '0' GROUP BY sp.member_unique_id) as debit FROM ".$GLOBALS['member_table']." as sp WHERE sp.deleted = '0' AND sp.is_approved='1' AND sp.is_rejected='0'";

				$manager_query = "SELECT 'manager' as party_type, mm.manager_unique_id as party_id, mm.manager_name as party_name, mm.mobile_number as party_mobile_number, mm.bonus_point ,(SELECT SUM(rm.amount) FROM ".$GLOBALS['receipt_table']." as rm WHERE rm.member_id = mm.manager_unique_id AND rm.deleted = '0' and rm.is_approved='1' AND rm.is_rejected='0' GROUP BY rm.member_id) as credit,(SELECT SUM(pv.paid_amount) FROM ".$GLOBALS['plan_closure_table']." as pv WHERE pv.plan_id = mm.plan_id AND pv.deleted = '0' GROUP BY mm.manager_unique_id) as debit FROM ".$GLOBALS['manager_table']." as mm WHERE mm.deleted = '0' ";

				$select_query = "SELECT party_type, party_id, party_name, party_mobile_number,bonus_point, credit, debit FROM ( (".$member_query.") UNION ALL (".$manager_query.")) as g";

				if(!empty($select_query)) {
					$list = $this->getQueryRecords('',$select_query);
					if(!empty($list)) {
						foreach($list as $data) {
							if(!empty($data['party_type']) && !empty($data['party_id'])) {
								$total_credit = 0; $total_debit = 0; $balance = 0;
								if(!empty($data['bonus_point']) ) {
									$total_credit = $total_credit + $data['bonus_point'];
								}
								if(!empty($data['credit'])) {
									$total_credit = $total_credit + $data['credit'];
								}								
								if(!empty($data['debit'])) {
									$total_debit = $total_debit + $data['debit'];
								}
								if(!empty($total_credit)) {
									$balance = $balance + $total_credit;
								}
								if(!empty($total_debit)) {
									$balance = $balance - $total_debit;
								}
								if(!empty($balance)) {
									$reports[] = array('party_type' => $data['party_type'], 'party_id' => $data['party_id'], 'party_name' => $data['party_name'], 'party_mobile_number' => $data['party_mobile_number'], "balance" => $balance, "credit"=>$data['credit'], "debit"=>$data['debit'], "bonus_point"=>$data['bonus_point']);
								}
							}
						}
					}
				}
			}
			
			return $reports;
		}

		public function getBonusDetails($member_id, $bonus_limit, $filter_type) {
			$list = array(); $select_query = ""; $where = "";

			if(!empty($filter_type)) {
				$where = "g.type = '".$filter_type."' AND";
			}
	
			if(!empty($member_id)) {
				if(!empty($where)) {
					$where = $where." g.member_id = '".$member_id."' AND";
				}
				else {
					$where = "g.member_id = '".$member_id."' AND";
				}
			}

			if(!empty($bonus_limit)) {
				if($bonus_limit == 1) {
					if(!empty($where)) {
						$where = $where." g.bonus_point >= 3500 AND";
					}
					else {
						$where = "g.bonus_point >= 3500 AND ";
					}
				} else if($bonus_limit == 2) {
					if(!empty($where)) {
						$where = $where." g.bonus_point < 3500 AND";
					}
					else {
						$where = "g.bonus_point < 3500 AND ";
					}
				}
			}
			
			// if(!empty($where)) {	
				
				$select_query = "SELECT member_id, member_name, mobile_number, plan_id, bonus_point, type FROM ((SELECT me.member_unique_id as member_id, me.member_name as member_name, me.mobile_number as mobile_number, me.plan_id as plan_id, me.bonus_point as bonus_point, 'member' as type FROM ".$GLOBALS['member_table']." as me WHERE me.deleted = '0' and me.is_approved='1' and me.is_rejected='0' ORDER BY me.created_date_time ASC) UNION ALL (SELECT mm.manager_unique_id as member_id, mm.manager_name as member_name, mm.mobile_number as mobile_number, mm.plan_id as plan_id, mm.bonus_point as bonus_point,'manager' as type FROM ".$GLOBALS['manager_table']." as mm WHERE mm.deleted = '0' ORDER BY mm.created_date_time ASC) ) as g where ".$where." bonus_point >'0' ORDER by g.bonus_point ASC";
			// } 
			if(!empty($select_query)) {
				$list = $this->getQueryRecords('', $select_query);
			}
			return $list;
		}

		public function getReceiptWholeList($receipt_id) {
			$list = array(); $select_query = ""; $where = ""; 
			
			
			if(!empty($receipt_id)) {
				if(!empty($where)) {
					$where = $where." receipt_id = '".$receipt_id."' ";
				}
				else {
					$where = "receipt_id = '".$receipt_id."' ";
				}
			}

			if(!empty($where)) {
				$select_query = "SELECT * FROM ".$GLOBALS['receipt_table']." WHERE ".$where." ORDER BY created_date_time ASC";
			}
			
			if(!empty($select_query)) {
				$list = $this->getQueryRecords('', $select_query);
			}
			return $list;
		}

		public function getOldPaymentTotal($member_id) {
			$list = array(); $select_query = ""; $where = ""; $old_payment = 0;
			
			$select_query = "SELECT sum(amount) as old_payment FROM ".$GLOBALS['receipt_table']." WHERE member_id='".$member_id."' AND deleted='0' and is_approved= '1' and is_rejected='0' ORDER BY created_date_time ASC";

			// $select_query = "SELECT wallet_amount, bonus_point from (SELECT sum(amount) as wallet_amount, '0' as bonus_point FROM ".$GLOBALS['receipt_table']." where deleted='0' and is_approved='1' ORDER BY created_date_time ASC) UNION ALL (SELECT '0' as wallet_amount, '0' as bonus_point FROM ".$GLOBALS['receipt_table']." where deleted='0' and is_approved='1' ORDER BY created_date_time ASC)";
			
			if(!empty($select_query)) {
				$list = $this->getQueryRecords($GLOBALS['receipt_table'], $select_query);
				if(!empty($list)) {
					foreach($list as $data) {
						$old_payment = $data['old_payment'];
					}
				}
			}
			return $old_payment;
		}

	public function ClosingPlan($member_id, $plan_id, $plan_value) {

		$member_type = "";

		if(!empty($member_id)) {
			$member_name = $this->getTableColumnValue($GLOBALS['member_table'], 'member_unique_id', $member_id, 'member_name');
			$member_type = "member";
			if(empty($member_name)) {
				$member_name = $this->getTableColumnValue($GLOBALS['manager_table'], 'manager_unique_id', $member_id, 'manager_name');
				$member_type = "manager";
			}
		} 

		$created_date_time = $GLOBALS['create_date_time_label']; $creator = $GLOBALS['creator'];
		$creator_name = $this->encode_decode('encrypt', $GLOBALS['creator_name']);

		$action = "";
		if(!empty($name)) {
			$action = "Plan closing bill Created. Name - ".$this->encode_decode('decrypt', $member_name);
		}

		$null_value = $GLOBALS['null_value'];
		$columns = array('created_date_time', 'creator', 'creator_name', 'plan_closing_id', 'member_id', 'plan_id', 'plan_value','deleted', 'bill_company_id', 'member_type');
		$values = array("'".$created_date_time."'", "'".$creator."'", "'".$creator_name."'", "'".$null_value."'", "'".$member_id."'", "'".$plan_id."'","'".$plan_value."'","'0'","'NULL'", "'".$member_type."'");

		$plan_closing_insert_id = $this->InsertSQL($GLOBALS['plan_closingdetails_table'], $columns,$values, $action);						
		if(preg_match("/^\d+$/", $plan_closing_insert_id)) {
			$plan_closing_id = "";
			if($plan_closing_insert_id < 10) {
				$plan_closing_id = "plan_closing_".date("dmYhis")."_0".$plan_closing_insert_id;
			}
			else {
				$plan_closing_id = "plan_closing_".date("dmYhis")."_".$plan_closing_insert_id;
			}
			if(!empty($plan_closing_id)) {
				$plan_closing_id = $this->encode_decode('encrypt', $plan_closing_id);
			}
			$columns = array(); $values = array();						
			$columns = array('plan_closing_id');
			$values = array("'".$plan_closing_id."'");
			$plan_closing_update_id = $this->UpdateSQL($GLOBALS['plan_closingdetails_table'], $plan_closing_insert_id, $columns, $values, '');
			if(preg_match("/^\d+$/", $plan_closing_update_id)) {		
				$result = array('number' => '1', 'msg' => 'Plan Closing Successfully Created');
			}
			else {
				$result = array('number' => '2', 'msg' => $plan_closing_update_id);
			}
		}

		if(!empty($result)) {
			return json_encode($result);
		}
	}

	public function getFullyPaidReports($member_id, $filter_type) {
		$list = array(); $select_query = ""; $where = "";

		if(!empty($filter_type)) {
			$where = "member_type = '".$filter_type."' AND";
		}

		if(!empty($member_id)) {
			if(!empty($where)) {
				$where = $where." member_id = '".$member_id."' AND";
			}
			else {
				$where = "member_id = '".$member_id."'AND";
			}
		} 		
		// if(!empty($where)) {
			
			$select_query = "SELECT * FROM ".$GLOBALS['plan_closingdetails_table']." WHERE ".$where." deleted = '0' 
			ORDER BY id DESC";
		// }
		if(!empty($select_query)) {
			$list = $this->getQueryRecords($GLOBALS['plan_closingdetails_table'], $select_query);
		}
		return $list;
	}

	public function GetWalletAmount($member_id) {

		$where = "";

		if(!empty($member_id)) {
			$where = "member_unique_id = '".$member_id."' AND";
		}

		$select_query = "SELECT * FROM ".$GLOBALS['member_table']." WHERE ".$where." deleted = '0' AND wallet_balance > 0 and bonus_point > 0 and is_approved='1' and is_rejected='0' ORDER BY id DESC";
		// }
		if(!empty($select_query)) {
			$list = $this->getQueryRecords($GLOBALS['receipt_table'], $select_query);
		}
		return $list;
	}

	function ClearWalletBalance($member_id) {
		$msg = ""; $member_array = array(); $member_decrypted_id = "";

		$member_decrypted_id = $this->encode_decode("decrypt", $member_id);

		$member_array = explode("/", $member_decrypted_id); 

		if(!empty($member_id)) {	
			if($member_array[0] == "MVMME") {
				$member_unique_id = ""; 
				$member_unique_id = $this->getTableColumnValue($GLOBALS['member_table'], 'member_unique_id', $member_id, 'id');
				
				if(preg_match("/^\d+$/", $member_unique_id)) {
					$member_name = "";
					$member_name = $this->getTableColumnValue($GLOBALS['member_table'], 'member_unique_id', $member_id, 'member_name');
				
					$action = "";
					if(!empty($member_name)) {
						$action = "Member Wallet Balance cleared through Plan Closure. Name - ".$this->encode_decode('decrypt', $member_name);
					}
				
					$columns = array(); $values = array();						
					$columns = array('wallet_balance');
					$values = array("'0'");
					$msg = $this->UpdateSQL($GLOBALS['member_table'], $member_unique_id, $columns, $values, $action);
				}
			} else {
				$manager_unique_id = ""; 
				$manager_unique_id = $this->getTableColumnValue($GLOBALS['manager_table'], 'manager_unique_id', $member_id, 'id');
				
				if(preg_match("/^\d+$/", $manager_unique_id)) {
					$manager_name = "";
					$manager_name = $this->getTableColumnValue($GLOBALS['manager_table'], 'manager_unique_id', $member_id, 'manager_name');
				
					$action = "";
					if(!empty($manager_name)) {
						$action = "Member Wallet Balance cleared through Plan Closure. Name - ".$this->encode_decode('decrypt', $manager_name);
					}
				
					$columns = array(); $values = array();						
					$columns = array('wallet_balance');
					$values = array("'0'");
					$msg = $this->UpdateSQL($GLOBALS['manager_table'], $manager_unique_id, $columns, $values, $action);
				}
			}
		}	
		return $msg;		
	}

	function UpadateWalletBalance($member_id, $amount, $view_type) {
		$msg = ""; $wallet_balance = 0;
		if(!empty($member_id)) {	
			if(!empty($view_type) && ($view_type == 1)) {
				$manager_unique_id = "";  
				$manager_unique_id = $this->getTableColumnValue($GLOBALS['manager_table'], 'manager_unique_id', $member_id, 'id');
				
				if(preg_match("/^\d+$/", $manager_unique_id)) {
					$manager_name = "";
					$manager_name = $this->getTableColumnValue($GLOBALS['manager_table'], 'manager_unique_id', $member_id, 'manager_name');
					$wallet_balance = $this->getTableColumnValue($GLOBALS['manager_table'], 'manager_unique_id', $member_id, 'wallet_balance');
					$wallet_balance = $wallet_balance + $amount;
				
					$action = "";
					if(!empty($manager_name)) {
						$action = "Member Wallet Balance Upadted through Receipt. Name - ".$this->encode_decode('decrypt', $manager_name);
					}
				
					$columns = array(); $values = array();						
					$columns = array('wallet_balance');
					$values = array($wallet_balance);
					$msg = $this->UpdateSQL($GLOBALS['manager_table'], $manager_unique_id, $columns, $values, $action);
				} 
			} else {
				$member_unique_id = "";  
				$member_unique_id = $this->getTableColumnValue($GLOBALS['member_table'], 'member_unique_id', $member_id, 'id');
				
				if(preg_match("/^\d+$/", $member_unique_id)) {
					$member_name = "";
					$member_name = $this->getTableColumnValue($GLOBALS['member_table'], 'member_unique_id', $member_id, 'member_name');
					$wallet_balance = $this->getTableColumnValue($GLOBALS['member_table'], 'member_unique_id', $member_id, 'wallet_balance');
					$wallet_balance = $wallet_balance + $amount;
				
					$action = "";
					if(!empty($member_name)) {
						$action = "Member Wallet Balance Upadted through Receipt. Name - ".$this->encode_decode('decrypt', $member_name);
					}
				
					$columns = array(); $values = array();						
					$columns = array('wallet_balance');
					$values = array($wallet_balance);
					$msg = $this->UpdateSQL($GLOBALS['member_table'], $member_unique_id, $columns, $values, $action);
				}
			}
			
		}	
		return $msg;		
	}

	function getPlanClosureMemberList() {
		$select_query = "";

		$select_query = "SELECT member_id, member_name, city, mobile_number FROM ((SELECT me.member_unique_id as member_id, me.member_name as member_name, me.city as city, me.mobile_number as mobile_number FROM ".$GLOBALS['member_table']." as me WHERE me.wallet_balance > '0' AND me.deleted = '0' AND me.is_approved='1' AND is_rejected='0' ORDER BY id DESC) UNION ALL (SELECT mm.manager_unique_id as member_id, mm.manager_name as member_name, mm.city as city, mm.mobile_number as mobile_number FROM ".$GLOBALS['manager_table']." as mm WHERE mm.wallet_balance > '0' AND mm.deleted = '0' ORDER BY id DESC)) as g";

		if(!empty($select_query)) {
			$list = $this->getQueryRecords('', $select_query);
		}

		return $list;
	}

	function getPlanStatus($member_id, $plan_id) {

		$where = ""; $plan_closing_status = "";

		if(!empty($member_id)) {
			$where = "member_id = '".$member_id."' AND";
		}

		if(!empty($plan_id)) {
			if(!empty($where)) {
				$where = $where." plan_id = '".$plan_id."' AND";
			}
			else {
				$where = "plan_id = '".$plan_id."' AND";
			}
		}

		$select_query = "SELECT closing_type FROM ".$GLOBALS['plan_closure_table']." WHERE ".$where." deleted = '0' ORDER BY id DESC";

		if(!empty($select_query)) {
			$list = $this->getQueryRecords($GLOBALS['plan_closure_table'], $select_query);
			if(!empty($list)) {
				foreach($list as $data) {
					$plan_closing_status = $data['closing_type'];
				}
			}
		}
		return $plan_closing_status;

	}

	function getPaymentReportDashboard() {

		$select_query = ""; $where = "";

		$today_date = date("Y-m-d");

		$where = "receipt_date = '".$today_date."' AND";

		$select_query = "SELECT receipt_number, member_id, sum(amount) as amount FROM ".$GLOBALS['receipt_table']." WHERE ".$where." deleted='0' AND is_approved='1' AND is_rejected='0' GROUP BY member_id ORDER BY id ASC";

		if(!empty($select_query)) {
			$list = $this->getQueryRecords($GLOBALS['receipt_table'], $select_query);
		}

		return $list;
	}

	function getBalanceReport($filter_member_id, $filter_type) {

		$select_query = ""; $where = "";

		if(!empty($filter_type)) {
			$where = "WHERE g.type = '".$filter_type."' ";
		}

		if(!empty($filter_member_id)) {
			if(!empty($where)) {
				$where = $where." AND g.member_id = '".$filter_member_id."' ";
			}
			else {
				$where = "g.member_id = '".$filter_member_id."' ";
			}
		}

		$select_query = "SELECT member_id, mobile_number, member_name, plan_id, wallet_balance, bonus_point, type FROM ((SELECT me.member_unique_id as member_id, me.mobile_number as mobile_number, me.member_name as member_name, me.plan_id as plan_id, me.wallet_balance as wallet_balance, me.bonus_point as bonus_point, 'member' as type FROM ".$GLOBALS['member_table']." as me WHERE me.deleted = '0' AND me.is_approved='1' AND me.is_rejected='0' AND me.wallet_balance >= '0' ORDER BY id DESC) UNION ALL (SELECT mm.manager_unique_id as member_id, mm.mobile_number as mobile_number, mm.manager_name as member_name,mm.plan_id as plan_id, mm.wallet_balance as wallet_balance, mm.bonus_point as bonus_point, 'manager' as type FROM ".$GLOBALS['manager_table']." as mm WHERE mm.wallet_balance >= '0' OR mm.bonus_point > '0' AND mm.deleted = '0' ORDER BY id DESC)) as g ".$where." ORDER BY g.wallet_balance DESC";

		if(!empty($select_query)) {
			$list = $this->getQueryRecords('', $select_query);
		}

		return $list;
	}

	function getReceiptRejectedList($member_id) {

		$where = "";

		if(!empty($member_id)) {
			if(!empty($where)) {
				$where = $where." member_id = '".$member_id."' AND";
			}
			else {
				$where = "member_id = '".$member_id."' AND";
			}
		}

		$rejected_receipt_list =  array();

		if(!empty($where)) {
			$select_query = "SELECT * FROM ".$GLOBALS['receipt_table']." WHERE ".$where." is_approved='0' AND is_rejected='1' AND deleted='0'"; 
		}
		else {
			$select_query = "SELECT * FROM ".$GLOBALS['receipt_table']." WHERE is_approved='0' AND is_rejected='1' AND deleted='0'"; 
		}

		if(!empty($select_query)) {
			$rejected_receipt_list = $this->getQueryRecords($GLOBALS['receipt_table'], $select_query);
		}

		return $rejected_receipt_list;
	}

	public function RevertBonus($reference_id) {
		$reference = ""; $bonus_update = ""; $msg = ""; 
		$reference = $reference_id;
		$reference = $this->encode_decode("decrypt", $reference);
		$reference = explode("/", $reference);
		if($reference[0] == "MVMMM") {
			if(!empty($reference_id)) {	
				$manager_unique_id = ""; 
				$manager_unique_id = $this->getTableColumnValue($GLOBALS['manager_table'], 'manager_unique_id', $reference_id, 'id');
				$bonus_point = $this->getTableColumnValue($GLOBALS['manager_table'], 'manager_unique_id', $reference_id, 'bonus_point'); 					
				if(empty($bonus_point)) {
					$bonus_point = 0;
				}
				$bonus_point = $bonus_point - 300;
				if(preg_match("/^\d+$/", $manager_unique_id)) {
					$manager_name = "";
					$manager_name = $this->getTableColumnValue($GLOBALS['manager_table'], 'manager_unique_id', $reference_id, 'manager_name');
				
					$action = "";
					if(!empty($manager_name)) {
						$action = "Bonus Point reverted For Referenced member rejection. Name - ".$this->encode_decode('decrypt', $manager_name);
					}
				
					$columns = array(); $values = array();						
					$columns = array('bonus_point');
					$values = array("'".$bonus_point."'");
					$msg = $this->UpdateSQL($GLOBALS['manager_table'], $manager_unique_id, $columns, $values, $action);
				}
			}
		} 
		else if($reference[0] == "MVMME") {
			if(!empty($reference_id)) {	
				$member_unique_id = ""; 
				$member_unique_id = $this->getTableColumnValue($GLOBALS['member_table'], 'member_unique_id', $reference_id, 'id');
				$bonus_point = $this->getTableColumnValue($GLOBALS['member_table'], 'member_unique_id', $reference_id, 'bonus_point');
				$manager_id = $this->getTableColumnValue($GLOBALS['member_table'], 'member_unique_id', $reference_id, 'manager_id');
				if(empty($bonus_point)) {
					$bonus_point = 0;
				}
				$bonus_point = $bonus_point - 300;
				if(preg_match("/^\d+$/", $member_unique_id)) {
					$member_name = "";
					$member_name = $this->getTableColumnValue($GLOBALS['member_table'], 'member_unique_id', $reference_id, 'member_name');
				
					$action = "";
					if(!empty($member_name)) {
						$action = "Bonus Point reverted For Referenced member rejection. Name - ".$this->encode_decode('decrypt', $member_name);
					}
				
					$columns = array(); $values = array();						
					$columns = array('bonus_point');
					$values = array("'".$bonus_point."'");
					$msg = $this->UpdateSQL($GLOBALS['member_table'], $member_unique_id, $columns, $values, $action);
				}

				if(!empty($manager_id)) {
					$manager_unique_id = "";
					$manager_unique_id =  $this->getTableColumnValue($GLOBALS['manager_table'], 'manager_unique_id', $manager_id, 'id');
					$manager_name = ""; 
					$manager_name = $this->getTableColumnValue($GLOBALS['manager_table'], 'manager_unique_id', $manager_id, 'manager_name');
					$bonus_point = $this->getTableColumnValue($GLOBALS['manager_table'], 'manager_unique_id', $manager_id, 'bonus_point');
					if(empty($bonus_point)) {
						$bonus_point = 0;
					}
					$bonus_point = $bonus_point - 100;
				
					$action = "";
					if(!empty($manager_name)) {
						$action = "Bonus Point reverted For Referenced member rejection. Name - ".$this->encode_decode('decrypt', $manager_name);
					}
				
					$columns = array(); $values = array();						
					$columns = array('bonus_point');
					$values = array("'".$bonus_point."'");
					$msg = $this->UpdateSQL($GLOBALS['manager_table'], $manager_unique_id, $columns, $values, $action);
				}
			}
		}
		if(!empty($msg)) {
			$bonus_update = $msg;
		}
		return $bonus_update;

	}

	function getReferredList($member_id) {

		$referred_list = array(); $select_query = "";

		$select_query = "SELECT * FROM ".$GLOBALS['member_table']." WHERE reference_id='".$member_id."' AND is_approved='1' AND is_rejected='0' AND deleted='0' ORDER BY id desc";

		if(!empty($select_query)) {
			$referred_list = $this->getQueryRecords($GLOBALS['member_table'], $select_query);
		}

		return $referred_list;
	}

	function RevertWalletBalance($member_id, $receipt_amount) {

		$msg = ""; $member_unique_id = ""; $wallet_balance = 0;

		if(!empty($member_id)) { 

			$member_unique_id = $this->getTableColumnValue($GLOBALS['member_table'], 'member_unique_id', $member_id, 'id');
			$wallet_balance = $this->getTableColumnValue($GLOBALS['member_table'], 'member_unique_id', $member_id,'wallet_balance');

			if(empty($member_unique_id)) {
				$manager_unique_id = $this->getTableColumnValue($GLOBALS['manager_table'], 'manager_unique_id', $member_id, 'id');
				$wallet_balance = $this->getTableColumnValue($GLOBALS['manager_table'], 'manager_unique_id', $member_id,'wallet_balance');
			} 

			// echo $wallet_balance."/".$receipt_amount;

			$wallet_balance = $wallet_balance - $receipt_amount;

			if(!empty($member_unique_id)) {
				if(preg_match("/^\d+$/", $member_unique_id)) {
					$action = "Member Wallet Upadted while receipt rejection.";
				
					$columns = array(); $values = array();						
					$columns = array('wallet_balance');
					$values = array("'".$wallet_balance."'");
					$msg = $this->UpdateSQL($GLOBALS['member_table'], $member_unique_id, $columns, $values, $action);
				}
			} 

			if(!empty($manager_unique_id)) {
				if(preg_match("/^\d+$/", $manager_unique_id)) {
					$action = "manager Wallet Upadted while receipt rejection.";
				
					$columns = array(); $values = array();						
					$columns = array('wallet_balance');
					$values = array("'".$wallet_balance."'");
					$msg = $this->UpdateSQL($GLOBALS['manager_table'], $manager_unique_id, $columns, $values, $action);
				}
			} 
		} 

		if(!empty($msg)) {
			$rejected_update = $msg;
		}

		return $rejected_update;
	}

	function validReference($reference_id) {
		$referred_list = array(); $result = 1;
		if(!empty($reference_id)) {
			$reference_id = $this->encode_decode("encrypt", $reference_id); 
		}

		$select_query = "SELECT reference_id FROM ((SELECT me.member_unique_id as reference_id FROM ".$GLOBALS['member_table']." as me WHERE me.deleted='0') UNION ALL (SELECT mm.manager_unique_id FROM ".$GLOBALS['manager_table']." as mm WHERE mm.deleted='0') ) as g WHERE g.reference_id='".$reference_id."' ";

		if(!empty($select_query)) {
			$referred_list = $this->getQueryRecords('', $select_query); 
			if(!empty($referred_list)) {
				$result = 1;
			}
			else {
				$result = 0;
			}
		}

		return $result;
	}


	function PlanwisePaidAmount($member_id, $plan_id) {

		$wallet_amount = 0; $receipt_query = "";

		if(!empty($member_id)) {
			$receipt_query = "SELECT sum(amount) as paid_amount FROM ".$GLOBALS['receipt_table']." WHERE member_id='".$member_id."' AND plan_id='".$plan_id."' AND deleted='0' AND is_approved='1' ORDER BY receipt_date ASC" ;
		}

		if(!empty($receipt_query)) {
			$list = $this->getQueryRecords('', $receipt_query);
			if(!empty($list)) {
				foreach($list as $data) {
					$wallet_amount = $data['paid_amount'];
				}
			}
		}

		return $wallet_amount;
	}

	function getManagerList() {

		$manager_query = array(); $manager_list = array();

		$manager_query = "SELECT * FROM ".$GLOBALS['manager_table']." WHERE deleted = '0' AND manager_unique_id not in ((select member_id FROM ".$GLOBALS['plan_closingdetails_table']." WHERE deleted='0') UNION ALL (select member_id FROM ".$GLOBALS['plan_closure_table']." WHERE deleted='0')) ORDER BY id ASC" ;
		
		if(!empty($manager_query)) {
			$manager_list = $this->getQueryRecords('', $manager_query);
		}

		return $manager_list;
	}

	function getMemberList() {

		$member_query = array(); $member_list = array();

		$member_query = "SELECT * FROM ".$GLOBALS['member_table']." WHERE deleted = '0' AND member_unique_id not in ((select member_id FROM ".$GLOBALS['plan_closingdetails_table']." WHERE deleted='0') UNION ALL (select member_id FROM ".$GLOBALS['plan_closure_table']." WHERE deleted='0')) ORDER BY id ASC" ;
		
		if(!empty($member_query)) {
			$member_list = $this->getQueryRecords('', $member_query);
		}

		return $member_list;
	}
}
