<?php
	include("include_files.php");
    include("include/billing_functions.php");

    if(isset($_POST['page_number'])) {
		$page_number = $_POST['page_number'];
		$page_limit = $_POST['page_limit'];
		$page_title = $_POST['page_title']; 

        $search_text = "";
		if(isset($_POST['search_text'])) {
			$search_text = $_POST['search_text'];
		} 

        $filter_manager_id = "";
        if(isset($_POST['filter_manager_id'])) {
			$filter_manager_id = $_POST['filter_manager_id'];
		}

		$total_records_list = array();
		$total_records_list = $obj->getManagerReportDetails($filter_manager_id);

		if(!empty($search_text)) {
            $search_text = strtolower($search_text);
            $list = array();
            if(!empty($total_records_list)) {
                foreach($total_records_list as $val) {
                    $selected = 0;
                    if( (strpos(strtolower($obj->encode_decode('decrypt', $val['manager_name'])), $search_text) !== false) || (strpos(strtolower($obj->encode_decode('decrypt', $val['mobile_number'])), $search_text) !== false) ) {
                        $selected = 1;
                    }
                    if(!empty($selected) && $selected == 1) {
                        $list[] = $val;
                    }
                }
            }
            $total_records_list = $list;
        }
        
        $total_pages = 0;	
        $total_pages = count($total_records_list);
        
        $page_start = 0; $page_end = 0;
        if(!empty($page_number) && !empty($page_limit) && !empty($total_pages)) {
            if($total_pages > $page_limit) {
                if($page_number) {
                    $page_start = ($page_number - 1) * $page_limit;
                    $page_end = $page_start + $page_limit;
                }
            }
            else {
                $page_start = 0;
                $page_end = $page_limit;
            }
        }
    
        $show_records_list = array();
        if(!empty($total_records_list)) {
            $show_records_list = array_slice($total_records_list, $page_start, $page_limit);
        } ?>
        
		<table class="table nowrap smallfnt bg-white text-center" id="manager_list">
            <thead class="bg-light">
                <tr>
                    <th>S.No</th>
                    <th>Created Date</th>
                    <?php if(empty($filter_manager_id)) { ?>
                        <th>Manager ID</th>
                        <th>Manager Name</th>
                    <?php } else { ?>
                        <th>Member ID</th>
                        <th>Member Name</th>
                    <?php } ?>
                    <th>Mobile Number</th>
                    <th>Plan Name</th>
                </tr>
            </thead>
            <tbody>
                <?php if(!empty($show_records_list)) {
                        // $edit_action = $obj->encode_decode('encrypt', 'edit_action');
                        foreach($show_records_list as $key => $list) {
                            $index = $key + 1; $manager_unique_id = ""; $reference = "";
                            if(!empty($prefix)) { $index = $index + $prefix; } 
                            if(!empty($filter_manager_id)) { ?>
                                <tr>
                                    <td>
                                        <?php echo $index?>                                
                                    </td>
                                    <td>
                                        <?php 
                                            if(!empty($list['created_date_time']) && $list['created_date_time'] != "0000-00-00 00:00:00") { 
                                                echo date("d-m-Y", strtotime($list['created_date_time'])); 
                                            } 
                                        ?>
                                    </td>
                                    <td>
                                        <?php if(!empty($list['member_unique_id'])) {
                                            echo $obj->encode_decode("decrypt", $list['member_unique_id']);
                                        }
                                        ?>
                                    </td>
                                    <td>
                                        <?php if(!empty($list['member_name'])) {
                                            echo $obj->encode_decode("decrypt", $list['member_name']);
                                        }
                                        ?>
                                    </td>
                                    <td>
                                        <?php if(!empty($list['mobile_number'])) {
                                            echo $obj->encode_decode("decrypt", $list['mobile_number']);
                                        }
                                        ?>
                                    </td>                       
                                    <td>
                                        <?php if(!empty($list['plan_id'])) {
                                            $plan_name = $obj->getTableColumnValue($GLOBALS['plan_table'], 'plan_id', $list['plan_id'], 'plan_name');
                                            echo $obj->encode_decode("decrypt", $plan_name);
                                        }
                                        ?>
                                </tr>
                            <?php } else { ?>
                                <tr>
                                <td>
                                    <?php echo $index?>                                
                                </td>
                                <td>
                                    <?php 
                                        if(!empty($list['created_date_time']) && $list['created_date_time'] != "0000-00-00 00:00:00") { 
                                            echo date("d-m-Y", strtotime($list['created_date_time'])); 
                                        } 
                                    ?>
                                </td>
                                <td>
                                    <?php if(!empty($list['manager_unique_id'])) {
                                        echo $obj->encode_decode("decrypt", $list['manager_unique_id']);
                                    }
                                    ?>
                                </td>
                                <td>
                                    <?php if(!empty($list['manager_name'])) {
                                        echo $obj->encode_decode("decrypt", $list['manager_name']);
                                    }
                                    ?>
                                </td>
                                <td>
                                    <?php if(!empty($list['mobile_number'])) {
                                        echo $obj->encode_decode("decrypt", $list['mobile_number']);
                                    }
                                    ?>
                                </td>                       
                                <td>
                                    <?php if(!empty($list['plan_id'])) {
                                        $plan_name = $obj->getTableColumnValue($GLOBALS['plan_table'], 'plan_id', $list['plan_id'], 'plan_name');
                                        echo $obj->encode_decode("decrypt", $plan_name);
                                    }
                                    ?>
                            </tr>
                           <?php }  
                        } 
                } else { ?>
                    <tr>
                        <td colspan="4" class="text-center">Sorry! No records found</td>
                    </tr>
            <?php }   ?>                
            </tbody>
        </table>
    <?php } ?>  
    
    <script>
        function DownloadProductExcel(table, name) {
             var uri = 'data:application/vnd.ms-excel;base64,'
                     ,
                     template = '<html xmlns:o="urn:schemas-microsoft-com:office:office" xmlns:x="urn:schemas-microsoft-com:office:excel" xmlns="http://www.w3.org/TR/REC-html40"><meta http-equiv="content-type" content="application/vnd.ms-excel; charset=UTF-8"><head><!--[if gte mso 9]><xml><x:ExcelWorkbook><x:ExcelWorksheets><x:ExcelWorksheet><x:Name>{worksheet}</x:Name><x:WorksheetOptions><x:DisplayGridlines/></x:WorksheetOptions></x:ExcelWorksheet></x:ExcelWorksheets></x:ExcelWorkbook></xml><![endif]--></head><body><table>{table}</table></body></html>'
                    , base64 = function (s) {
                        return window.btoa(unescape(encodeURIComponent(s)))
                    }
                    , format = function (s, c) {
                        return s.replace(/{(\w+)}/g, function (m, p) {
                            return c[p];
                        })
                    }
                if (!table.nodeType) table = document.getElementById(table)
                var ctx = {worksheet: name || 'Worksheet', table: table.innerHTML}
                var a = document.createElement('a');
                a.href = uri + base64(format(template, ctx))
                a.download = name+'.xls';
                 //triggering the function
                 a.click();
         }
    </script>
	