<?php 
	$access_page = "Customer";
    include("include_user_check.php");
	
	$project_title = "";
	$project_title = $obj->getProjectTitle();

    $page_title = "Customer Report";

    $customer_list = array();
    $customer_list = $obj->getTableRecords($GLOBALS['customer_table'], '', '');
?>
<!DOCTYPE html>
<html lang="en">
<head>
	<title> <?php if(!empty($project_title)) { echo $project_title; } ?> - <?php if(!empty($page_title)) { echo $page_title; } ?> </title>
	<?php include "link_style_script.php"; ?>
	<script type="text/javascript" src="include/print_pdf/jspdf.min.js"></script>
    <script type="text/javascript" src="include/print_pdf/html2canvas.js"></script>
    <script type="text/javascript" src="include/print_pdf/print_pdf.js"></script>
</head>
<body>
	<?php include "header.php";  ?>
	<!-- sidebar-wrapper  -->          
	<div class="page-wrapper chiller-theme toggled">
		<main class="page-content">
			<div class="container-fluid px-lg-5">
				<div class="border card-box">

                    <div class="card-header">              
                        <div class="row">
                            <div class="col-sm-5 text-center text-sm-left">
                                <h5 class="headfnt"><?php if(!empty($page_title)) { echo $page_title; } ?></h5>
                            </div>
                            <div class="col-sm-3 search_text"></div>
                            <div class="col-sm-4 text-center text-sm-right">
                                <button class="btn btn-dark poppins" style="font-size:11px;" type="button" onClick="window.open('reports/rpt_customer_list.php')"> <i class="fa fa-file-pdf-o"></i> &ensp; PDF</button>
                                <button class="btn btn-dark poppins" style="font-size:11px;" target="_self" type="button" onclick="window.open('export/exp_customer.php')"> <i class="fa fa-download" aria-hidden="true"></i>   Export</button>
                                &nbsp; <a class="btn btn-danger poppins" style="font-size:11px;" href="customer.php">Back</a>
                            </div>
                        </div>
                    </div>
					
					<div class="table-responsive px-3 py-3">
                        <div id="report_area" class="w-100">
                            <table cellpadding="0" cellspacing="0" class="report_table print_order" style="width: 100%;">
                                <thead>
                                    <tr>
                                        <th colspan="6" style="padding: 5px; border: 1px solid #000; text-align: center; font-size: 15px;">Customer Report</th>
                                    </tr>
                                    <tr>
                                        <th style="padding: 5px; border: 1px solid #000; text-align: center; width: 50px; font-size: 12px;">S.No</th>
                                        <th style="padding: 5px; border: 1px solid #000; border-left: none; text-align: center; font-size: 12px;">Customer Name</th>
                                        <th style="padding: 5px; border: 1px solid #000; border-left: none; text-align: center; width: 100px; font-size: 12px;">Mobile Number</th>
                                        <th style="padding: 5px; border: 1px solid #000; border-left: none; text-align: center; width: 200px; font-size: 12px;">Address</th>
                                        <th style="padding: 5px; border: 1px solid #000; border-left: none; text-align: center; width: 150px; font-size: 12px;">City</th>
                                        <th style="padding: 5px; border: 1px solid #000; border-left: none; text-align: center; width: 150px; font-size: 12px;">State</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <?php
                                        if(!empty($customer_list)) {
                                            foreach($customer_list as $key => $data) {
                                                if(!empty($data['customer_id'])) {
                                    ?>
                                                    <tr>
                                                        <td style="padding: 5px; border: 1px solid #000; text-align: center; width: 50px; font-size: 12px;">
                                                            <?php echo $key + 1; ?>
                                                        </td>
                                                        <td style="padding: 5px 10px; border: 1px solid #000; border-left: none; font-size: 12px;">
                                                            <?php
                                                                if(!empty($data['name'])) {
                                                                    $data['name'] = $obj->encode_decode('decrypt', $data['name']);
                                                                    echo $data['name'];
                                                                }
                                                            ?>
                                                        </td>
                                                        <td style="padding: 5px; border: 1px solid #000; border-left: none; text-align: center; width: 100px; font-size: 12px;">
                                                            <?php
                                                                if(!empty($data['mobile_number'])) {
                                                                    $data['mobile_number'] = $obj->encode_decode('decrypt', $data['mobile_number']);
                                                                    echo $data['mobile_number'];
                                                                }
                                                            ?>
                                                        </td>
                                                        <td style="padding: 5px; border: 1px solid #000; border-left: none; text-align: left; width: 200px; font-size: 12px;">
                                                            <?php
                                                                if(!empty($data['address'])) {
                                                                    $data['address'] = $obj->encode_decode('decrypt', $data['address']);
                                                                    $data['address'] = str_replace("\r\n", ", ", $data['address']);
																	$data['address'] = str_replace("<br>", " ", $data['address']);
                                                                    echo $data['address'];
                                                                    
                                                                }
                                                            ?>
                                                        </td>
                                                        <td style="padding: 5px; border: 1px solid #000; border-left: none; text-align: center; width: 150px; font-size: 12px;">
                                                            <?php
                                                                if(!empty($data['city']) && $data['city'] != $GLOBALS['null_value']) {
                                                                    $data['city'] = $obj->encode_decode('decrypt', $data['city']);
                                                                    echo $data['city'];
                                                                }
                                                            ?>
                                                        </td>
                                                        <td style="padding: 5px; border: 1px solid #000; border-left: none; text-align: center; width: 150px; font-size: 12px;">
                                                            <?php
                                                                if(!empty($data['state'])) {
                                                                    $data['state'] = $obj->encode_decode('decrypt', $data['state']);
                                                                    echo $data['state'];
                                                                }
                                                            ?>
                                                        </td>
                                                    </tr>
                                    <?php  
                                                }
                                            }
                                        }
                                        else {
                                    ?>
                                            <tr>
                                                <td colspan="6" style="padding: 5px; border: 1px solid #000; text-align: center;">Sorry! No customers found</td>
                                            </tr>
                                    <?php        
                                        }
                                    ?>
                                </tbody>
                            </table>
                        </div>
                    </div>

				</div>
			</div>
		</main>
	</div>  
	<!-- page-wrapper -->

	<script>
		jQuery(document).ready(function(){
			jQuery("#customeractive").addClass("active");
            prepare_print_view();
		});
	</script>

	<?php include "footer.php"; ?>

    </body>
</html>