<?php 
    include("include_user_check.php");

	$project_title = "";
	$project_title = $obj->getProjectTitle();

    $page_number = $GLOBALS['page_number']; $page_limit = $GLOBALS['page_limit'];

	$current_date = "";
	if(isset($_POST['current_date'])) {
		$current_date = $_POST['current_date'];
	}

	if(empty($current_date)) {
    	$current_date = date("d-m-Y");
	}

	$login_list = array();
	$login_list = $obj->getUserLoginList($current_date);

?>
<!DOCTYPE html>
<html lang="en">
<head>
	<title> <?php if(!empty($project_title)) { echo $project_title; } ?> - Login </title>
	<?php include "link_style_script.php"; ?>
</head>
<body>
	<?php include "header.php";  ?>
	<!-- sidebar-wrapper  -->          
	<div class="page-wrapper chiller-theme toggled">
		<main class="page-content">
			<div class="container-fluid px-lg-5">
				<div class="border card-box">

					<form name="table_listing_form" method="post">
                        <input type="hidden" name="page_number" value="<?php if(!empty($page_number)) { echo $page_number; } ?>">
						<input type="hidden" name="page_limit" value="<?php if(!empty($page_limit)) { echo $page_limit; } ?>">
						<div class="card-header">						
							<div class="row">
								<div class="col-6 col-sm-9">
									<h5 class="headfnt mb-0">Login List</h5>
								</div>
								<div class="col-6 col-sm-3 text-center text-sm-right">
									<div class="form-label-group in-border mb-0">
										<input name="current_date" value="<?php if(!empty($current_date)) { echo $current_date; } ?>" class="form-control shadow-none date_field" placeholder="From Date" onChange="Javascript:getloginReport();">
										<label>Date</label>
									</div>
								</div>
							</div>
						</div>
					</form>
					<div id="table_listing_records" class="table-responsive poppins">
						<table class="table nowrap">
							<thead>
								<tr>
									<th class="text-center px-2 py-2">S.No</th>
									<th class="text-center px-2 py-2">Login Date & Time</th>
									<th class="text-center px-2 py-2">Logout Date & Time</th>
									<th class="text-center px-2 py-2">IP Address</th>
									<th class="text-center px-2 py-2" style="width: 150px;">Device</th>
									<th class="text-center px-2 py-2">User Type</th>
									<th class="text-center px-2 py-2">Username</th>
								</tr>
							</thead>
							<tbody>
								<?php
									if(!empty($login_list)) {
										foreach($login_list as $key => $data) {
											$index = $key + 1;
								?>
											<tr>
												<td class="text-center px-2 py-2"><?php echo $index; ?></td>
												<td class="text-center px-2 py-2">
													<?php 
														if(!empty($data['login_date_time']) && $data['login_date_time'] != "0000-00-00 00:00:00") { 
															echo date("d-m-Y", strtotime($data['login_date_time']))."<br>".date("h:i:s A", strtotime($data['login_date_time'])); 
														} 
													?>
												</td>
												<td class="text-center px-2 py-2">
													<?php 
														if(!empty($data['logout_date_time']) && $data['logout_date_time'] != "0000-00-00 00:00:00") { 
															echo date("d-m-Y", strtotime($data['logout_date_time']))."<br>".date("h:i:s A", strtotime($data['logout_date_time'])); 
														} 
													?>
												</td>
												<td class="text-center px-2 py-2">
													<?php if(!empty($data['ip_address'])) { echo $data['ip_address']; } ?>
												</td>
												<td class="text-center px-2 py-2">
													<?php if(!empty($data['browser'])) { echo $data['browser']; } ?>
												</td>
												<td class="text-center px-2 py-2">
													<?php if(!empty($data['type'])) { echo $data['type']; } ?>
												</td>
												<td class="text-center px-2 py-2">
													<?php
														if(!empty($data['user_id'])) {
															$username = "";
															$username = $obj->getTableColumnValue($GLOBALS['user_table'], 'user_id', $data['user_id'], 'name');
															if(empty($username)) {
																$username = $obj->getTableColumnValue($GLOBALS['group_user_table'], 'group_user_id', $data['user_id'], 'name');
															}
															if(!empty($username)) {
																$username = $obj->encode_decode('decrypt', $username);
																echo $username;
															}
														}
													?>
												</td>
											</tr>
								<?php
										}
									}
									else {
								?>
										<tr>
											<td colspan="8" class="text-center">Sorry! No records found</td>
										</tr>
								<?php } ?>
							</tbody>
						</table>
					</div>

				</div>
			</div>
		</main>
	</div>  
	<!-- page-wrapper -->

	<script>
		jQuery(document).ready(function(){
			jQuery("#loginactive").addClass("active");
		});

		function getloginReport() {
			if(jQuery('form[name="table_listing_form"]').length > 0) {
				jQuery('form[name="table_listing_form"]').submit();
			}
		}
	</script>

	<?php include "footer.php"; ?>

    </body>
</html>