<?php
    include("../include.php");
    require_once('../../order/fpdf/fpdf.php');
	
	$customer_list = array();
    $customer_list = $obj->getTableRecords($GLOBALS['enquiry_customer_table'], '', '');

    $company_list = array();
    $company_list = $obj->getTableRecords($GLOBALS['company_table'], '', '');

    foreach($company_list as $data){
        $company_name = ""; $company_address = ""; $company_mobile = ""; $company_email = ""; $logo = "";

        if(!empty($data['name'])) {
            $company_name = $obj->encode_decode('decrypt', $data['name']);
        }
        if(!empty($data['logo']) && $data['logo'] != $GLOBALS['null_value']) {
            $logo = $data['logo'];
        }
        if(!empty($data['address']) && $data['address'] != $GLOBALS['null_value']) {
            $company_address = $obj->encode_decode('decrypt', $data['address']);
        }
        if(!empty($data['mobile_number'])) {
            $company_mobile = $obj->encode_decode('decrypt', $data['mobile_number']);
        }
        if(!empty($data['email'])) {
            $company_email = $obj->encode_decode('decrypt', $data['email']);
        }
    }

    $logo = "../../images/logo.png";
    
    $pdf = new FPDF('P','mm','A4');
    $pdf->AliasNbPages(); 
    $pdf->AddPage();
    $pdf->SetAutoPageBreak(true);
    $pdf->SetTitle('Enquiry List');
    $pdf->SetFont('Arial','B',10);
    $pdf->SetY(10);
    $pdf->Cell(0,5,strtoupper($company_name),0,1,'C',0);
    $pdf->SetFont('Arial','',7);
    $pdf->Cell(0,4,$company_address,0,1,'C',0);
    $pdf->Cell(0,4,'E-mail : '.$company_email.'   Phone : '.$company_mobile,0,1,'C',0);


    if(!empty($logo)){
        $pdf->Image('../../images/upload/'.$logo,10,7,25,20);
    }
    
    $pdf->SetY(7);
    $pdf->Cell(0,20,'',1,1,'L',0);
    $pdf->SetFont('Arial','B',9);
    $pdf->Cell(0,6,'ENQUIRY LIST',1,0,'C',0);
    $pdf->SetTextColor(34,139,34);
    $pdf->Cell(0,6,'Total Enquiries : '.count($customer_list),1,1,'R',0);
    $pdf->SetTextColor(0,0,0);
    $pdf->SetFont('Arial','B',8);
    $pdf->SetX(10);
    $pdf->Cell(15,8,'S.No',1,0,'C',0);
    $pdf->SetX(25);
    $pdf->Cell(50,8,'Date & Time',1,0,'C',0);
    $pdf->SetX(75);
    $pdf->Cell(100,8,'Customer Name',1,0,'C',0);
    $pdf->SetX(175);
    $pdf->Cell(25,8,'Mobile Number',1,1,'C',0);
    $pdf->SetFont('Arial','',8);

    if(!empty($customer_list)) {
        $sno = 1;
        foreach($customer_list as $data) {
            if($pdf->GetY()>260){
                $pdf->AddPage();
                $pdf->SetFont('Arial','B',10);
                $pdf->SetY(10);
                $pdf->Cell(0,5,strtoupper($company_name),0,1,'C',0);
                $pdf->SetFont('Arial','',7);
                $pdf->Cell(0,4,$company_address,0,1,'C',0);
                $pdf->Cell(0,4,'E-mail : '.$company_email.'   Phone : '.$company_mobile,0,1,'C',0);

                if(!empty($logo)){
                    $pdf->Image('../../images/upload/'.$logo,10,7,25,20);
                }
                
                $pdf->SetY(7);
                $pdf->Cell(0,20,'',1,1,'L',0);
                $pdf->SetFont('Arial','B',9);
                $pdf->Cell(0,6,'ENQUIRY LIST',1,0,'C',0);
                $pdf->SetTextColor(34,139,34);
                $pdf->Cell(0,6,'Total Enquiries : '.count($customer_list),1,1,'R',0);
                $pdf->SetTextColor(0,0,0);
                $pdf->SetFont('Arial','B',8);
                $pdf->SetX(10);
                $pdf->Cell(15,8,'S.No',1,0,'C',0);
                $pdf->SetX(25);
                $pdf->Cell(50,8,'Date & Time',1,0,'C',0);
                $pdf->SetX(75);
                $pdf->Cell(105,8,'Customer Name',1,0,'C',0);
                $pdf->SetX(175);
                $pdf->Cell(25,8,'Mobile Number',1,1,'C',0);
                $pdf->SetFont('Arial','',8);
            }
            if(!empty($data['name'])) {

                $created_date_time = "";
                if(!empty($data['created_date_time']) && $data['created_date_time'] != "0000-00-00 00:00:00") { 
                    $created_date_time = date("d-m-Y h:i:s A", strtotime($data['created_date_time'])); 
                }

                $yaxis = $pdf->GetY();
                $pdf->SetX(10);
                $pdf->Cell(15,7,$sno,0,0,'C',0);
                $pdf->SetX(25);
                $pdf->Cell(50,7,$created_date_time,0,0,'C',0);
                $pdf->SetX(77);
                $data['name'] = $obj->encode_decode('decrypt',$data['name']);
                $pdf->MultiCell(100,7,$data['name'],0,'L',0);
                $yaxis1 = $pdf->GetY();
                $pdf->SetY($yaxis);
                $pdf->SetX(175);
                $pdf->Cell(25,7,$obj->encode_decode('decrypt',$data['mobile_number']),0,0,'C',0);
                $yaxis4 = $pdf->GetY();
                
                $pdf->SetY($yaxis);
                $pdf->SetX(10);
                $pdf->Cell(15,7,'',1,0,'C',0);
                $pdf->SetX(25);
                $pdf->Cell(50,7,'',1,0,'C',0);
                $pdf->SetX(75);
                $pdf->Cell(100,7,'',1,0,'C',0);
                $pdf->SetX(175);
                $pdf->Cell(25,7,'',1,1,'C',0);

                $sno++;
            }
        }
    }
    
    $pdf->SetY(-10);
    $pdf->Cell(0, 5, "Page " . $pdf->PageNo() . "/{nb}", 0, 1,'C',0);

    $pdf->Output();
?>