<?php 
	$access_page = "Orders";
    include("include_user_check.php");
	
	include("permission_check.php");
	
	$project_title = "";
	$project_title = $obj->getProjectTitle();

    $page_title = "Order"; $page_number = $GLOBALS['page_number']; $page_limit = $GLOBALS['page_limit'];

    $from_date = date("01-01-Y"); $to_date = date("31-12-Y");
    $customer_list = array();   
	
	$staff_list = array();
    $staff_list = $obj->getTableRecords($GLOBALS['staff_table'], '', '');

	$staff_unique_id = ""; $staff_id = ""; $staff_name = ""; $filter_staff_id = "";
	if(!empty($_SESSION[$GLOBALS['site_name_user_prefix'].'_user_id']) && isset($_SESSION[$GLOBALS['site_name_user_prefix'].'_user_id'])) {
		$staff_unique_id = $obj->getTableColumnValue($GLOBALS['staff_table'], 'staff_id', $_SESSION[$GLOBALS['site_name_user_prefix'].'_user_id'], 'id');								
		if(preg_match("/^\d+$/", $staff_unique_id)) {	
			$staff_id = $_SESSION[$GLOBALS['site_name_user_prefix'].'_user_id'];	
			$filter_staff_id = $staff_id;
			$staff_name = $obj->getTableColumnValue($GLOBALS['staff_table'], 'staff_id', $staff_id, 'name');
		}
	}

	if(!empty($staff_id) && !empty($staff_name)) {
		$customer_list = $obj->StaffCreatedCustomers($staff_id, '1');
	}
	else {
		$customer_list = $obj->getTableRecords($GLOBALS['customer_table'], '', '');
	}

	$order_type_list = array($GLOBALS['frontend_order'], $GLOBALS['backend_order']);

	$promotion_code_list = array();
    $promotion_code_list = $obj->getTableRecords($GLOBALS['promotion_code_table'], '', '');
	
	$show_promotion_code = 2;
	$show_promotion_code = $obj->getTableColumnValue($GLOBALS['settings_table'], 'name', 'show_promotion_code', 'value');

	$transport_list = array();
    $transport_list = $obj->getTableRecords($GLOBALS['transport_table'], '', '');

	$bank_list = array();
    $bank_list = $obj->getTableRecords($GLOBALS['bank_table'], '', '');

	$city_list = array();
	$city_list = $obj->getTransportCityList();

?>
<!DOCTYPE html>
<html lang="en">
<head>
	<title> <?php if(!empty($project_title)) { echo $project_title; } ?> - Enquiry List </title>
	<?php include "link_style_script.php"; ?>
	<script type="text/javascript" src="include/js/common.js"></script>
	<script type="text/javascript" src="include/js/order.js"></script>
</head>
<body>
	<?php include "header.php";  ?>
	<!-- sidebar-wrapper  -->          
	<div class="page-wrapper chiller-theme toggled">
		<main class="page-content">
			<div class="container-fluid px-lg-5">
				<div class="border card-box">

					<div class="card-header">
                        <div class="row">
                            <div class="col-6 text-center text-sm-left">
                                <h5 class="headfnt">Enquiry List</h5>
                            </div>
                            <div class="col-6 text-center text-sm-right">
                                <a class="btn btn-dark poppins" style="font-size:11px;" href="Javascript:OrdersPreview();"> <i class="fas fa-print"></i> &ensp; Preview</a>
                            </div>	
                        </div>
					</div>

					<div class="add_update_form_content"></div>

                    <form name="table_listing_form" method="post">
						<input type="hidden" name="page_number" value="<?php if(!empty($page_number)) { echo $page_number; } ?>">
						<input type="hidden" name="page_limit" value="<?php if(!empty($page_limit)) { echo $page_limit; } ?>">
						<input type="hidden" name="page_title" value="<?php if(!empty($page_title)) { echo $page_title; } ?>">
						<input type='hidden' name='filter_status' id='filter_status'>
						<div class="row my-3 mx-0">
							<div class="col-sm-6 col-xl-3 form-group">
								<select name="filter_customer_id" class="form-control" onChange="Javascript:table_listing_records_filter();">
									<option value="">Select Customer</option>
									<?php
										if(!empty($customer_list)) {
											foreach($customer_list as $data) {
									?>
												<option value="<?php if(!empty($data['customer_id'])) { echo $data['customer_id']; } ?>">
													<?php
														if(!empty($data['name'])) {
															$data['name'] = $obj->encode_decode('decrypt', $data['name']);
															echo $data['name'];
															if(!empty($data['mobile_number'])) {
																$data['mobile_number'] = $obj->encode_decode('decrypt', $data['mobile_number']);
																echo " - ".$data['mobile_number'];
															}
														}
													?>
												</option>
									<?php			
											}
										}
									?>
								</select>
							</div>
							<div class="col-sm-6 col-xl-3 form-group">
								<?php if(!empty($filter_staff_id)) { ?>
									<input type="hidden" name="filter_staff_id" value="<?php if(!empty($filter_staff_id)) { echo $filter_staff_id; } ?>">
								<?php } else { ?>
								<select name="filter_staff_id" class="form-control" onChange="Javascript:table_listing_records_filter();">
									<option value="">Select Staff</option>
									<?php
										if(!empty($staff_list)) {
											foreach($staff_list as $data) {
									?>
												<option value="<?php if(!empty($data['staff_id'])) { echo $data['staff_id']; } ?>">
													<?php
														if(!empty($data['name'])) {
															$data['name'] = $obj->encode_decode('decrypt', $data['name']);
															echo $data['name'];
														}
													?>
												</option>
									<?php			
											}
										}
									?>
								</select>
								<?php } ?>
							</div>
							
							<div class="col-sm-6 col-xl-3 form-group">
								<select name="filter_transport_id" class="form-control" onChange="Javascript:table_listing_records_filter();">
									<option value="">Select Transport</option>
									<?php
										if(!empty($transport_list)) {
											foreach($transport_list as $data) {
									?>
												<option value="<?php if(!empty($data['transport_id'])) { echo $data['transport_id']; } ?>">
													<?php
														if(!empty($data['name'])) {
															$data['name'] = $obj->encode_decode('decrypt', $data['name']);
															echo $data['name'];
														}
													?>
												</option>
									<?php			
											}
										}
									?>
								</select>
							</div>

							<div class="col-sm-6 col-xl-3 form-group">
								<select name="filter_bank_id" class="form-control" onChange="Javascript:table_listing_records_filter();">
									<option value="">Select Bank</option>
									<?php
										if(!empty($bank_list)) {
											foreach($bank_list as $data) {
									?>
												<option value="<?php if(!empty($data['bank_id'])) { echo $data['bank_id']; } ?>">
													<?php
														if(!empty($data['bank_name'])) {
															$data['bank_name'] = $obj->encode_decode('decrypt', $data['bank_name']);
															echo $data['bank_name'];
															if(!empty($data['account_number'])) {
																$data['account_number'] = $obj->encode_decode('decrypt', $data['account_number']);
																echo " - ".$data['account_number'];
															}
														}
													?>
												</option>
									<?php			
											}
										}
									?>
								</select>
							</div>

							<div class="col-sm-6 col-xl-2 form-group">
								<input type="text" name="from_date" class="form-control date_field" onChange="Javascript:table_listing_records_filter();" value="<?php if(!empty($from_date)) { echo $from_date; } ?>" placeholder="From Date">
							</div>
							<div class="col-sm-6 col-xl-2 form-group">
								<input type="text" name="to_date" class="form-control date_field" onChange="Javascript:table_listing_records_filter();" value="<?php if(!empty($to_date)) { echo $to_date; } ?>" placeholder="To Date">
							</div>
							<div class="col-sm-6 col-xl-2 form-group">
								<?php if(empty($staff_name)) { ?>
								<select name="filter_order_type" class="form-control" onChange="Javascript:table_listing_records_filter();">
									<option value="">Select Enquiry Type</option>
									<?php
										if(!empty($order_type_list)) {
											foreach($order_type_list as $order_type) {
												if(!empty($order_type)) {
									?>
													<option value="<?php echo $obj->encode_decode('encrypt', $order_type); ?>"> <?php echo $order_type; ?> </option>
									<?php				
												}
											}
										}
									?>
								</select>
								<?php } ?>
							</div>
							<div class="col-sm-6 col-xl-2 form-group">
								<input type="text" name="search_text" class="form-control" onKeyUp="Javascript:table_listing_records_filter();" value="" placeholder="Search By Enquiry No">
							</div>

							<div class="col-sm-6 col-xl-4 form-group">
								<div class="row">
									<div class="col-sm-5 pr-1">										
										<select name="city" class="form-control" onChange="javascript:getCityTransportList(this.value);">
											<option value="">Select City</option>
											<?php
												if(!empty($city_list)) {
													foreach($city_list as $city) {
														if(!empty($city)) {
											?>
															<option value="<?php echo $obj->encode_decode('encrypt', $city); ?>"><?php echo $city; ?></option>
											<?php
														}
													}
												}
											?>
										</select>
									</div>
									<div id="city_transport_list" class="col-sm-7 pl-1">
										<select name="city_transport" class="form-control">
											<option value="">City Transport</option>
											<?php
												if(!empty($transport_list)) {
													foreach($transport_list as $data) {
											?>
														<option value="<?php if(!empty($data['transport_id'])) { echo $data['transport_id']; } ?>">
															<?php
																if(!empty($data['name'])) {
																	$data['name'] = $obj->encode_decode('decrypt', $data['name']);
																	echo $data['name'];
																}
															?>
														</option>
											<?php			
													}
												}
											?>
										</select>										
									</div>
								</div>
							</div>
							
							<div class="col-sm-6 col-xl-4 form-group">
								<?php if(!empty($show_promotion_code) && $show_promotion_code == 1) { ?>
								<select name="filter_promotion_code_id" class="form-control" onChange="Javascript:table_listing_records_filter();">
									<option value="">Select Promotion Code</option>
									<?php
										if(!empty($promotion_code_list)) {
											foreach($promotion_code_list as $data) {
									?>
												<option value="<?php if(!empty($data['promotion_code_id'])) { echo $data['promotion_code_id']; } ?>">
													<?php
														if(!empty($data['name'])) {
															$data['name'] = $obj->encode_decode('decrypt', $data['name']);
															echo $data['name'];
														}
													?>
												</option>
									<?php			
											}
										}
									?>
								</select>
								<?php } ?>
							</div>
						</div>
					</form>

					<div id="table_listing_records" class="table-responsive poppins"></div>
					
				</div>
			</div>
		</main>
	</div>  
	<!-- page-wrapper -->
	<link rel="stylesheet" type="text/css" href="include/css/order.css">
	<script>
		jQuery(document).ready(function(){
			jQuery("#ordersactive").addClass("active");
		});

		table_listing_records_filter();

		function getCityTransportList(city) {
			if(jQuery('#city_transport_list').length > 0) {
				jQuery('#city_transport_list').html('');
			}

			var check_login_session = 1;
			var post_url = "dashboard_changes.php?check_login_session=1";	
			jQuery.ajax({url: post_url, success: function(check_login_session){
				if(check_login_session == 1) {
					var post_url = "order_changes.php?transport_city_name="+city;
					jQuery.ajax({url: post_url, success: function(result){
						if(jQuery('#city_transport_list').length > 0) {
							jQuery('#city_transport_list').html(result);
						}
					}}); 
				}
				else {
					window.location.reload();
				}
			}});

		}
	</script>
	<style>
		.canvasjs-chart-toolbar { display: none; }
	</style>
	<?php include "footer.php"; ?>

	<?php include "modal_content.php"; ?>

    </body>
</html>