<?php 
	$access_page = "Orders To PDF";
    include("include_user_check.php");
	
	$project_title = "";
	$project_title = $obj->getProjectTitle();

    $page_title = "Order To PDF";

    $from_date = date("01-01-Y"); $to_date = date("31-12-Y");
    $customer_list = array();
    $customer_list = $obj->getTableRecords($GLOBALS['customer_table'], '', '');
?>
<!DOCTYPE html>
<html lang="en">
<head>
	<title> <?php if(!empty($project_title)) { echo $project_title; } ?> - Enquiry To PDF </title>
	<?php include "link_style_script.php"; ?>
	<script type="text/javascript" src="include/js/common.js"></script>
</head>
<body>
	<?php include "header.php";  ?>
	<!-- sidebar-wrapper  -->          
	<div class="page-wrapper chiller-theme toggled">
		<main class="page-content">
			<div class="container-fluid px-lg-5">
				<div class="border card-box">

					<div class="card-header">
                        <div class="row">
                            <div class="col-6 text-center text-sm-left">
                                <h5 class="headfnt">Enquiry To PDF</h5>
                            </div>
                            <div class="col-6 text-center text-sm-right">
                                <button type="button" class="btn btn-dark poppins" style="font-size:13px;" onClick="Javascript:GetPDF();">Get PDF</button>
                            </div>	
                        </div>
					</div>

                    <form name="table_listing_form" method="post">
						<div class="row my-3 mx-0">
							<div class="col-sm-3 form-group">
								<input type="text" name="order_from_date" class="form-control date_field" value="<?php if(!empty($from_date)) { echo $from_date; } ?>" placeholder="From Date">
							</div>
                            <div class="col-sm-3 form-group">
								<input type="text" name="order_to_date" class="form-control date_field" value="<?php if(!empty($to_date)) { echo $to_date; } ?>" placeholder="To Date">
							</div>
							<div class="col-sm-6 form-group">
								<select name="order_customer_id" class="form-control">
									<option value="">Select Customer</option>
									<?php
										if(!empty($customer_list)) {
											foreach($customer_list as $data) {
									?>
												<option value="<?php if(!empty($data['customer_id'])) { echo $data['customer_id']; } ?>">
													<?php
														if(!empty($data['name'])) {
															$data['name'] = $obj->encode_decode('decrypt', $data['name']);
															echo $data['name'];
															if(!empty($data['mobile_number'])) {
																$data['mobile_number'] = $obj->encode_decode('decrypt', $data['mobile_number']);
																echo " - ".$data['mobile_number'];
															}
														}
													?>
												</option>
									<?php			
											}
										}
									?>
								</select>
							</div>
						</div>
					</form>

                    <div class="add_update_form_content"></div>

				</div>
			</div>
		</main>
	</div>  
	<!-- page-wrapper -->

	<script>
		jQuery(document).ready(function(){
			jQuery("#order2pdfactive").addClass("active");
		});

		function GetPDF() {
            var check_login_session = 1;
            var post_url = "dashboard_changes.php?check_login_session=1";	
            jQuery.ajax({url: post_url, success: function(check_login_session){
                if(check_login_session == 1) {
                    jQuery.ajax({
                        url: "order_changes.php",
                        type: "post",
                        async: true,
                        data: jQuery('form[name="table_listing_form"]').serialize(),
                        dataType: 'html',
                        contentType: 'application/x-www-form-urlencoded; charset=UTF-8',
                        success: function(result) {
                            if(jQuery('.add_update_form_content').length > 0) {
                                jQuery('.add_update_form_content').html(result);
                            }
                        },
                        error: function(jqXHR, textStatus, errorThrown) {
                            console.log(textStatus, errorThrown);
                        }
                    });
                }
                else {
                    window.location.reload();
                }
            }}); 
        }

        function GetSinglePDF(order_id) {
            if(typeof order_id != "undefined" && order_id != "") {
			var post_url = "order_changes.php?order2pdf_order_id="+order_id;
                jQuery.ajax({url: post_url, success: function(result){
                    if(jQuery('#print_order_'+order_id).length > 0) {
                        jQuery('#print_order_'+order_id).html("");
                        jQuery('#print_order_'+order_id).html(result);
                    }
                }});
            }
        }
	</script>

	<?php include "footer.php"; ?>

    </body>
</html>