<?php 
    header("Location:dashboard.php");
    exit;

	$access_page = "Product";
    include("include_user_check.php");

    include("permission_check.php");
	
	$project_title = "";
	$project_title = $obj->getProjectTitle();

    $page_title = "Product Pricelist";

    $pricelist = array();
    $pricelist = $obj->ProductPricelist('1');

    $company_list = array();
    $company_list = $obj->getTableRecords($GLOBALS['company_table'], '', '');

    $company_name = ""; $company_address = ""; $company_mobile = ""; $company_email = ""; $logo = "";

    foreach($company_list as $data){
        if(!empty($data['name'])) {
            $company_name = $obj->encode_decode('decrypt', $data['name']);
        }
        if(!empty($data['logo']) && $data['logo'] != $GLOBALS['null_value']) {
            $logo = $data['logo'];
        }
        if(!empty($data['address']) && $data['address'] != $GLOBALS['null_value']) {
            $company_address = $obj->encode_decode('decrypt', $data['address']);
            $company_address = str_replace("\r\n", "<br>", $company_address);
        }
        if(!empty($data['mobile_number'])) {
            $company_mobile = $obj->encode_decode('decrypt', $data['mobile_number']);
        }
        if(!empty($data['email'])) {
            $company_email = $obj->encode_decode('decrypt', $data['email']);
        }
    }

    $target_dir = $obj->image_directory(); $format = 1;
    $format = $obj->getTableColumnValue($GLOBALS['settings_table'], 'name', 'product_price_display_format', 'value');

?>
<!DOCTYPE html>
<html lang="en">
<head>
	<title> <?php if(!empty($project_title)) { echo $project_title; } ?> - <?php if(!empty($page_title)) { echo $page_title; } ?> </title>
	<?php include "link_style_script.php"; ?>
	<script type="text/javascript" src="include/print_pdf/jspdf.min.js"></script>
    <script type="text/javascript" src="include/print_pdf/html2canvas.js"></script>
    <script type="text/javascript" src="include/print_pdf/print_pdf.js"></script>
</head>
<body>
	<?php include "header.php";  ?>
	<!-- sidebar-wrapper  -->          
	<div class="page-wrapper chiller-theme toggled">
		<main class="page-content">
			<div class="container-fluid px-lg-5">
				<div class="border card-box">

                    <div class="card-header">  
                        <div class="row">
                            <div class="col-sm-5 text-center text-sm-left">
                                <h5 class="headfnt"><?php if(!empty($page_title)) { echo $page_title; } ?></h5>
                            </div>
                            <div class="col-sm-3 search_text"></div>
                            <div class="col-sm-4 text-center text-sm-right">
                                <?php /* ?><button class="btn btn-dark poppins" style="font-size:11px;" type="button" onClick="Javascript:print_content();"> <i class="fa fa-print"></i> &ensp; Print</button> <?php */ ?>
                                <button class="btn btn-dark poppins" style="font-size:11px;" type="button" onClick="window.open('reports/rpt_price_list.php?format=<?php if(!empty($format)) { echo $format; } ?>')"> <i class="fa fa-print"></i> &ensp; PDF</button>
                                &nbsp; <a class="btn btn-danger poppins" style="font-size:11px;" href="product.php">Back</a>
                            </div>
                        </div>
                    </div>
					
					<div class="table-responsive px-3 py-3">
                        <div id="report_area" class="w-100">
                            <table cellpadding="0" cellspacing="0" class="report_table print_order" style="width: 100%;">
                                <thead>
                                    <tr>
                                        <td colspan="8" style="padding: 5px; border: 1px solid #000; text-align: center; font-size: 15px;">
                                            <div style="display: table;">
                                                <div style="display: table-row;">
                                                    <div style="display: table-cell; width: 143.7px; vertical-align: top;">
                                                        <?php if(!empty($logo) && file_exists($target_dir.$logo)) { ?>
                                                            <img src="<?php echo $target_dir.$logo; ?>" style="max-width: 150px; max-height: 150px;" />
                                                        <?php } ?>
                                                    </div>
                                                    <div style="display: table-cell; width: 650px; vertical-align: top;">
                                                        <div style="width: 100%; font-size: 18px; font-weight: bold;"><?php if(!empty($company_name)) { echo $company_name; } ?></div>
                                                        <div style="width: 100%;"><?php if(!empty($company_address)) { echo $company_address; } ?></div>
                                                        <div style="width: 100%;">
                                                            <?php if(!empty($company_email)) { echo "Email : ".$company_email.", "; } ?>
                                                            <?php if(!empty($company_mobile)) { echo "Phone : ".$company_mobile; } ?>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                        </td>
                                    </tr>
                                    <tr>
                                        <th colspan="8" style="padding: 5px; border: 1px solid #000; text-align: center; font-size: 15px;">PRICE LIST</th>
                                    </tr>
                                    <tr>
                                        <th style="padding: 5px; border: 1px solid #000; text-align: center; width: 50px; font-size: 12px;">Product Code</th>
                                        <th style="padding: 5px; border: 1px solid #000; border-left: none; text-align: center; font-size: 12px; width: 193px;">Product Name</th>
                                        <th style="padding: 5px; border: 1px solid #000; border-left: none; text-align: center; width: 100px; font-size: 12px;">Content</th>
                                        <th style="padding: 5px; border: 1px solid #000; border-left: none; text-align: center; width: 125px; font-size: 12px;">Rate / Qty</th>
                                        <th style="padding: 5px; border: 1px solid #000; border-left: none; text-align: center; width: 125px; font-size: 12px;">Discount</th>
                                        <th style="padding: 5px; border: 1px solid #000; border-left: none; text-align: center; width: 125px; font-size: 12px;">Final Rate</th>
                                        <th style="padding: 5px; border: 1px solid #000; border-left: none; text-align: center; width: 75px; font-size: 12px;">Quantity</th>
                                        <th style="padding: 5px; border: 1px solid #000; border-left: none; text-align: center; width: 125px; font-size: 12px;">Amount</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <?php
                                        if(!empty($pricelist)) {
                                            $sno = 1;
                                            foreach($pricelist as $data) {
                                                if(!empty($data['category_name'])) {
                                    ?>
                                                    <tr>
                                                        <td colspan="8" style="padding: 5px; border: 1px solid #000; font-weight: bold; text-align: center; text-transform: uppercase; font-size: 12px;">
                                                            <?php
                                                                if(!empty($data['category_name'])) {
                                                                    $data['category_name'] = $obj->encode_decode('decrypt', $data['category_name']);
                                                                    echo $data['category_name'];

                                                                    $category_discount = 0;
                                                                    if(!empty($data['discount'])) {
                                                                        $category_discount = $data['discount'];
                                                                    }
                                                                    if(!empty($category_discount)) {
                                                                        echo "&nbsp; (".$category_discount."% Discount)";
                                                                    }
                                                                    else {
                                                                        echo "&nbsp; (Net Rate)";
                                                                    }
                                                                }
                                                            ?>
                                                        </td>
                                                    </tr>
                                    <?php          
                                                    if(!empty($data['product_list'])) {
                                                        foreach($data['product_list'] as $product) {
                                                            if(!empty($product['name'])) {

                                                                $actual_price = 0; $discounted_price = 0;
                                                                if(!empty($format)) {
                                                                    if($format == 1) {
                                                                        if(!empty($product['price'])) {
                                                                            $actual_price = $product['price'];
                                                                            if(!empty($category_discount)) {
                                                                                $discounted_value = 0;
                                                                                $discounted_value = ($actual_price * $category_discount) / 100;
                                                                                if(!empty($discounted_value)) {
                                                                                    $discounted_value = number_format($discounted_value, 2);
                                                                                    $discounted_value = str_replace(",", "", $discounted_value);
                                                                                    $discounted_price = $actual_price - $discounted_value;
                                                                                }
                                                                            }
                                                                            else {
                                                                                $discounted_price = $actual_price;
                                                                            }
                                                                        }
                                                                    }
                                                                    else if($format == 2) {
                                                                        if(!empty($product['price'])) {
                                                                            $discounted_price = $product['price'];
                                                                            if(!empty($discounted_price)) {
                                                                                if(!empty($category_discount) && !empty($discounted_price)) {
                                                                                    $actual_price = $obj->getActualPrice($discounted_price, $category_discount);
                                                                                }
                                                                                else {
                                                                                    $actual_price = $discounted_price;   
                                                                                }
                                                                            }
                                                                        }
                                                                    }
                                                                }

                                                                $discounted_value = 0;
                                                                if(!empty($actual_price) && !empty($category_discount)) {                   
                                                                    $discounted_value = ($actual_price * $category_discount) / 100;
                                                                    if(!empty($discounted_value)) {
                                                                        $discounted_value = number_format($discounted_value, 2);
                                                                        $discounted_value = str_replace(",", "", $discounted_value);
                                                                    }
                                                                }

                                    ?>
                                                                <tr>
                                                                    <td style="width: 50px; padding: 5px; border: 1px solid #000; text-align: center; font-size: 12px;">
                                                                        <?php
                                                                            if(!empty($product['product_code'])) {
                                                                                $product['product_code'] = $obj->encode_decode('decrypt', $product['product_code']);
                                                                                echo $product['product_code'];
                                                                            }
                                                                        ?>
                                                                    </td>
                                                                    <td style="padding: 5px 10px; border: 1px solid #000; border-left: none; font-size: 12px; width: 193px;">
                                                                        <?php
                                                                            if(!empty($product['name'])) {
                                                                                $product['name'] = $obj->encode_decode('decrypt', $product['name']);
                                                                                $product['name'] = str_replace("$", '"', $product['name']);
                                                                                echo $product['name'];
                                                                            }
                                                                        ?>
                                                                    </td>
                                                                    <td style="width: 100px; padding: 5px; border: 1px solid #000; border-left: none; text-align: center; font-size: 12px;">
                                                                        <?php
                                                                            if(!empty($product['product_content'])) {
                                                                                $product['product_content'] = $obj->encode_decode('decrypt', $product['product_content']);
                                                                                echo $product['product_content'];
                                                                            }
                                                                        ?>
                                                                    </td>
                                                                    <td style="width: 125px; padding: 5px; border: 1px solid #000; border-left: none; text-align: center; font-size: 12px;">
                                                                        <?php if(!empty($actual_price)) { echo number_format($actual_price, 2); } ?>
                                                                    </td>
                                                                    <td style="width: 125px; padding: 5px; border: 1px solid #000; border-left: none; text-align: center; font-size: 12px;">
                                                                        <?php if(!empty($discounted_value)) { echo $discounted_value; } else { echo "-"; } ?>
                                                                    </td>
                                                                    <td style="width: 125px; padding: 5px; border: 1px solid #000; border-left: none; text-align: center; font-size: 12px;">
                                                                        <?php if(!empty($discounted_price)) { echo number_format($discounted_price, 2); } ?>
                                                                    </td>
                                                                    <td style="width: 75px; padding: 5px; border: 1px solid #000; border-left: none; text-align: center; font-size: 12px;">
                                                                    </td>
                                                                    <td style="width: 125px; padding: 5px; border: 1px solid #000; border-left: none; text-align: center; font-size: 12px;">
                                                                        
                                                                    </td>
                                                                </tr>
                                    <?php                  
                                                                $sno = $sno + 1;          
                                                            }
                                                        }
                                                    }      
                                                }
                                            }
                                        }
                                        else {
                                    ?>
                                            <tr>
                                                <td colspan="7" style="padding: 5px; border: 1px solid #000; text-align: center;">Sorry! No products found</td>
                                            </tr>
                                    <?php        
                                        }
                                    ?>
                                </tbody>
                            </table>
                        </div>
                    </div>

				</div>
			</div>
		</main>
	</div>  
	<!-- page-wrapper -->

	<script>
		jQuery(document).ready(function(){
			jQuery("#productactive").addClass("active");
            prepare_print_view();
		});
	</script>

	<?php include "footer.php"; ?>

    </body>
</html>