<?php
	include("include.php");
	
	if(isset($_REQUEST['show_transport_id'])) {
        $show_transport_id = $_REQUEST['show_transport_id'];

        $name = ""; $cities = "";
        if(!empty($show_transport_id)) {
            $transport_list = array();
			$transport_list = $obj->getTableRecords($GLOBALS['transport_table'], 'transport_id', $show_transport_id);
            if(!empty($transport_list)) {
                foreach($transport_list as $data) {
                    if(!empty($data['name'])) {
                        $name = $obj->encode_decode('decrypt', $data['name']);
					}
					if(!empty($data['cities'])) {
                        $cities = $data['cities'];
					}
                }
            }
		} 
?>
		
        <form class="py-4 poppins pd-20 col-xl-6 mx-auto" name="transport_form" method="POST">
            <div class="row">
                <input type="hidden" name="edit_id" value="<?php if(!empty($show_transport_id)) { echo $show_transport_id; } ?>">
                <div class="form-group col-12">
                    <div class="form-label-group in-border mb-0">
                        <input type="text" name="name" value="<?php if(!empty($name)) { echo $name; } ?>" class="form-control shadow-none" placeholder="Transport Name">
                        <label>Transport Name (*)</label>
                    </div>
                </div>
				<div class="form-group col-12">
                    <div class="form-label-group in-border mb-0">
                        <input type="text" name="cities" value="<?php if(!empty($cities)) { echo $cities; } ?>" class="form-control shadow-none" placeholder="Cities">
                        <label>Cities (*)</label>
                    </div>
                </div>                
                <div class="col-md-12 pt-3 text-center">
                    <button class="btn btn-primary btnwidth submit_button" type="button" onClick="Javascript:SaveModalContent('transport_form', 'transport_changes.php', 'transport.php');">Submit</button>
                </div>
            </div>
			<script type="text/javascript">
				jQuery(document).ready(function(){
					jQuery('form[name="transport_form"]').find('select').select2();
				});    
			</script>
			<script type="text/javascript"> 
				CheckFormChangeEvent(); 
			</script>
        </form>
<?php        
    }

    if(isset($_POST['name'])) {	
		$name = ""; $name_error = ""; $cities = ""; $cities_error = "";
		$valid_transport = ""; $form_name = "transport_form";
	
        $name = $_POST['name'];
		$name = $valid->clean_value($name);
        $name_error = $valid->common_validation($name, "name", "text");
		if(!empty($name_error)) {
			$valid_transport = $valid->error_display($form_name, "name", $name_error, 'text');			
		}

		$cities = $_POST['cities'];
		$cities = $valid->clean_value($cities);
		$cities_error = $valid->common_validation($cities, "cities", "text");
		if(!empty($cities_error)) {
			if(!empty($valid_transport)) {
				$valid_transport = $valid_transport." ".$valid->error_display($form_name, "cities", $cities_error, 'text');
			}
			else {
				$valid_transport = $valid->error_display($form_name, "cities", $cities_error, 'text');
			}
		}

		if(isset($_POST['edit_id'])) {
			$edit_id = $_POST['edit_id'];
		}
		
		$result = "";
		
		if(empty($valid_transport) && empty($state_city_error)) {
			$check_user_id_ip_address = "";
			$check_user_id_ip_address = $obj->check_user_id_ip_address();	
			if(preg_match("/^\d+$/", $check_user_id_ip_address)) {
				
                $lower_case_name = "";
				if(!empty($name)) {
					$name = str_replace("''", "$", $name);
					$name = str_replace('"', "$", $name);
                    $lower_case_name = strtolower($name);
					$lower_case_name = $obj->encode_decode('encrypt', $lower_case_name);
                    $name = $obj->encode_decode('encrypt', $name);
				}

				if(!empty($cities)) {
                    $cities = strtolower($cities);
					//$cities = $obj->encode_decode('encrypt', $cities);
				}

                $prev_transport_id = ""; $transport_error = "";
				if(!empty($lower_case_name)) {
					$prev_transport_id = $obj->getTableColumnValue($GLOBALS['transport_table'], 'lower_case_name', $lower_case_name, 'transport_id');
					if(!empty($prev_transport_id)) {
                        $transport_error = "This transport name already exist";
                    }
                }
				
				if(empty($edit_id)) {
					if(empty($prev_transport_id)) {
						$created_date_time = $GLOBALS['create_date_time_label']; $creator = $GLOBALS['creator'];
                        $creator_name = $obj->encode_decode('encrypt', $GLOBALS['user_name']);
						
						$action = "";
						if(!empty($name)) {
							$action = "New transport Created. Name - ".str_replace("$", '"', $obj->encode_decode('decrypt', $name));
						}

						$null_value = $GLOBALS['null_value'];
                        $columns = array('created_date_time', 'creator', 'creator_name', 'transport_id', 'name', 'lower_case_name', 'cities', 'deleted');
                        $values = array("'".$created_date_time."'", "'".$creator."'", "'".$creator_name."'", "'".$null_value."'", "'".$name."'", "'".$lower_case_name."'", "'".$cities."'", "'0'");
						$transport_insert_id = $obj->InsertSQL($GLOBALS['transport_table'], $columns, $values, $action);						
						if(preg_match("/^\d+$/", $transport_insert_id)) {
							$transport_id = "";
							if($transport_insert_id < 10) {
								$transport_id = "transport_0".$transport_insert_id;
							}
							else {
								$transport_id = "transport_".$transport_insert_id;
							}
                            if(!empty($transport_id)) {
                                $transport_id = $obj->encode_decode('encrypt', $transport_id);
                            }
                            $columns = array(); $values = array();						
                            $columns = array('transport_id');
                            $values = array("'".$transport_id."'");
                            $transport_update_id = $obj->UpdateSQL($GLOBALS['transport_table'], $transport_insert_id, $columns, $values, '');
                            if(preg_match("/^\d+$/", $transport_update_id)) {
                                $result = array('number' => '1', 'msg' => 'Transport Successfully Created');					
                            }
                            else {
                                $result = array('number' => '2', 'msg' => $transport_update_id);
                            }
						}
						else {
							$result = array('number' => '2', 'msg' => $transport_insert_id);
						}
					}
					else {
						$result = array('number' => '2', 'msg' => $transport_error);
					}
				}
				else {
					if(empty($prev_transport_id) || $prev_transport_id == $edit_id) {
						$getUniqueID = "";
						$getUniqueID = $obj->getTableColumnValue($GLOBALS['transport_table'], 'transport_id', $edit_id, 'id');
						if(preg_match("/^\d+$/", $getUniqueID)) {
							$action = "";
							if(!empty($name)) {
								$action = "transport Updated. Name - ".str_replace("$", '"', $obj->encode_decode('decrypt', $name));
							}
						
							$columns = array(); $values = array();						
							$columns = array('name', 'lower_case_name', 'cities');
							$values = array("'".$name."'", "'".$lower_case_name."'", "'".$cities."'");
							$transport_update_id = $obj->UpdateSQL($GLOBALS['transport_table'], $getUniqueID, $columns, $values, $action);
							if(preg_match("/^\d+$/", $transport_update_id)) {			
								$result = array('number' => '1', 'msg' => 'Updated Successfully');						
							}
							else {
								$result = array('number' => '2', 'msg' => $transport_update_id);
							}							
						}
					}
					else {
						$result = array('number' => '2', 'msg' => $transport_error);
					}
                }

			}
			else {
				$result = array('number' => '2', 'msg' => 'Invalid IP');
			}
		}
		else {
            if(!empty($valid_transport)) {
			    $result = array('number' => '3', 'msg' => $valid_transport);
            }
            else if(!empty($state_city_error)) {
			    $result = array('number' => '2', 'msg' => $state_city_error);
            }
		}
		
		if(!empty($result)) {
			$result = json_encode($result);
		}
		echo $result; exit;
	}
	
	if(isset($_POST['page_number'])) {
		$page_number = $_POST['page_number'];
		$page_limit = $_POST['page_limit'];
		$page_title = $_POST['page_title'];

		$search_text = "";
		if(isset($_POST['search_text'])) {
			$search_text = $_POST['search_text'];
		}

		$filter_city = "";
		if(isset($_POST['filter_city'])) {
			$filter_city = $_POST['filter_city'];
		}

		$total_records_list = array();
		$total_records_list = $obj->getTransportList($filter_city);

		if(!empty($search_text)) {
			$search_text = strtolower($search_text);
			$list = array();
			if(!empty($total_records_list)) {
				foreach($total_records_list as $val) {
					if(strpos(strtolower($obj->encode_decode('decrypt', $val['name'])), $search_text) !== false) {
						$list[] = $val;
					}
				}
			}
			$total_records_list = $list;
		}
		
		$total_pages = 0;
		if(!empty($total_records_list)) {
			$total_pages = count($total_records_list);
		}
		
		$page_start = 0; $page_end = 0;
		if(!empty($page_number) && !empty($page_limit) && !empty($total_pages)) {
			if($total_pages > $page_limit) {
				if($page_number) {
					$page_start = ($page_number - 1) * $page_limit;
					$page_end = $page_start + $page_limit;
				}
			}
			else {
				$page_start = 0;
				$page_end = $page_limit;
			}
		}

		$show_records_list = array();
        if(!empty($total_records_list)) {
            foreach($total_records_list as $key => $val) {
                if($key >= $page_start && $key < $page_end) {
                    $show_records_list[] = $val;
                }
            }
        }
?>
        
		<?php if($total_pages > $page_limit) { ?>
			<div class="pagination_cover mt-3"> 
				<?php
					include("pagination.php");
				?> 
			</div> 
		<?php } ?>

		<table class="table nowrap show_frontend_table">
            <thead>
                <tr>
					<th class="text-center px-2 py-2">S.No</th>
                    <th class="text-center px-2 py-2">Transport Name</th>
                    <th class="text-center px-2 py-2">Action</th>
                </tr>
            </thead>
            <tbody>
                <?php
                    if(!empty($show_records_list)) {
                        foreach($show_records_list as $key => $data) {
							$transport_name = "";
							if(!empty($data['name'])) {
								$transport_name = $obj->encode_decode('decrypt', $data['name']);
								$transport_name = str_replace("$", '"', $transport_name);
								$transport_name = str_replace("'''", '"', $transport_name);
								$transport_name = trim($transport_name);
							}
                ?>
							<tr>
								<td class="text-center px-2 py-2"><?php echo $key + 1; ?></td>
								<td class="px-2 py-2">
									<div class="w-100">
										<?php if(!empty($transport_name)) { echo $transport_name; } ?>
									</div>
									
									<?php
										if(!empty($data['creator_name'])) {
											$data['creator_name'] = $obj->encode_decode('decrypt', $data['creator_name']);
									?>
											<small><?php echo "creator : ".$data['creator_name']; ?></small>
									<?php		
										}
									?>
								</td>
								<td class="text-center px-2 py-2">
									<div class="dropdown">
										<a class="btn btn-dark poppins px-3" href="#" role="button" data-toggle="dropdown">
											<i class="fa fa-ellipsis-v text-white"></i>
										</a>
										<div class="dropdown-menu dropdown-menu-right dropdown-menu-icon-list">
											<a class="dropdown-item" href="Javascript:ShowModalContent('<?php if(!empty($page_title)) { echo $page_title; } ?>', '<?php if(!empty($data['transport_id'])) { echo $data['transport_id']; } ?>');"><i class="fa fa-pencil"></i> &ensp; View / Edit</a>
											<a class="dropdown-item" href="Javascript:DeleteModalContent('<?php if(!empty($page_title)) { echo $page_title; } ?>', '<?php if(!empty($data['transport_id'])) { echo $data['transport_id']; } ?>');"><i class="fa fa-trash"></i> &ensp; Delete</a>
										</div>
									</div>
								</td>
							</tr>
                <?php
                        }
                    }
                    else {
                ?>
                        <tr>
                            <td colspan="3" class="text-center">Sorry! No records found</td>
                        </tr>
                <?php } ?>
            </tbody>
        </table>
<?php	
	}
	
	if(isset($_REQUEST['delete_transport_id'])) {
		$delete_transport_id = $_REQUEST['delete_transport_id'];
		$msg = "";
		if(!empty($delete_transport_id)) {	
			$order_list = array(); $orders_count = 0;
            $order_list = $obj->getTableRecords($GLOBALS['order_table'], 'transport_id', $delete_transport_id);
			if(!empty($order_list)) {
				$orders_count = count($order_list);
			}

			if(empty($orders_count)) {
				$transport_unique_id = "";
				$transport_unique_id = $obj->getTableColumnValue($GLOBALS['transport_table'], 'transport_id', $delete_transport_id, 'id');
				if(preg_match("/^\d+$/", $transport_unique_id)) {
					$name = "";
					$name = $obj->getTableColumnValue($GLOBALS['transport_table'], 'transport_id', $delete_transport_id, 'name');
				
					$action = "";
					if(!empty($name)) {
						$action = "Transport Deleted. Name - ".$obj->encode_decode('decrypt', $name);
					}
				
					$columns = array(); $values = array();						
					$columns = array('deleted');
					$values = array("'1'");
					$msg = $obj->UpdateSQL($GLOBALS['transport_table'], $transport_unique_id, $columns, $values, $action);
				}
			}
			else {
				$msg = "Unable To Delete";
			}
		}
		echo $msg;
		exit;	
	}
?>