

CREATE TABLE `demo_plan_agent` (
  `id` int(100) NOT NULL AUTO_INCREMENT,
  `created_date_time` datetime NOT NULL,
  `creator` mediumtext NOT NULL,
  `creator_name` mediumtext NOT NULL,
  `agent_id` mediumtext NOT NULL,
  `agent_unique_number` mediumtext NOT NULL,
  `name` mediumtext NOT NULL,
  `mobile_number` mediumtext NOT NULL,
  `address` mediumtext NOT NULL,
  `city` mediumtext NOT NULL,
  `state` mediumtext NOT NULL,
  `chit_id` mediumtext NOT NULL,
  `chit_details` mediumtext NOT NULL,
  `commission` mediumtext NOT NULL,
  `login_user_name` mediumtext NOT NULL,
  `password` mediumtext NOT NULL,
  `fund_wallet` double NOT NULL,
  `commission_wallet` double NOT NULL,
  `merge_wallet` double NOT NULL,
  `total_wallet` double NOT NULL,
  `deleted` int(100) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;



CREATE TABLE `demo_plan_category` (
  `id` int(100) NOT NULL AUTO_INCREMENT,
  `created_date_time` datetime NOT NULL,
  `creator` mediumtext NOT NULL,
  `creator_name` mediumtext NOT NULL,
  `category_id` mediumtext NOT NULL,
  `name` mediumtext NOT NULL,
  `lowercase_name` mediumtext NOT NULL,
  `ordering` int(11) NOT NULL,
  `show_frontend` int(100) NOT NULL,
  `deleted` int(100) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;



CREATE TABLE `demo_plan_chit` (
  `id` int(100) NOT NULL AUTO_INCREMENT,
  `created_date_time` datetime NOT NULL,
  `creator` mediumtext NOT NULL,
  `creator_name` mediumtext NOT NULL,
  `chit_id` mediumtext NOT NULL,
  `name` mediumtext NOT NULL,
  `chit_name` mediumtext NOT NULL,
  `lower_case_chit_name` mediumtext NOT NULL,
  `maturity_value` mediumtext NOT NULL,
  `type` mediumtext NOT NULL,
  `due_amount` double NOT NULL,
  `due_duration` double NOT NULL,
  `due_days` int(100) NOT NULL,
  `due_reminder_days` int(100) NOT NULL,
  `payable_amount` double NOT NULL,
  `start_date` date NOT NULL,
  `end_date` date NOT NULL,
  `last_date_to_join` date NOT NULL,
  `booking_open_date` date NOT NULL,
  `no_of_users` double NOT NULL,
  `chit_image` mediumtext NOT NULL,
  `penalty_duration` double NOT NULL,
  `penalty_value` mediumtext NOT NULL,
  `min_value` double NOT NULL,
  `max_value` double NOT NULL,
  `accept_advance_amount` int(100) NOT NULL,
  `accept_previous_due` int(100) NOT NULL,
  `allow_termination` int(100) NOT NULL,
  `termination_days` int(100) NOT NULL,
  `allow_split_up_due_payment` int(100) NOT NULL,
  `allow_agent` int(100) NOT NULL,
  `agent_commission` mediumtext NOT NULL,
  `add_transport_charges` int(100) NOT NULL,
  `allow_merge_completed_wallet` int(100) NOT NULL,
  `add_due_without_penalty` int(100) NOT NULL,
  `upi_id` mediumtext NOT NULL,
  `upi_id_image` mediumtext NOT NULL,
  `terms_conditions` mediumtext NOT NULL,
  `deleted` int(100) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;



CREATE TABLE `demo_plan_city` (
  `id` int(100) NOT NULL AUTO_INCREMENT,
  `created_date_time` datetime NOT NULL,
  `creator` mediumtext NOT NULL,
  `creator_name` mediumtext NOT NULL,
  `state_name` mediumtext NOT NULL,
  `city_name` mediumtext NOT NULL,
  `deleted` int(100) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4;


INSERT INTO demo_plan_city (id, created_date_time, creator, creator_name, state_name, city_name, deleted) VALUES ('1','2023-01-06 13:01:05','','','Tamil Nadu','Sivakasi','0');


CREATE TABLE `demo_plan_company` (
  `id` int(100) NOT NULL AUTO_INCREMENT,
  `created_date_time` datetime NOT NULL,
  `creator` mediumtext NOT NULL,
  `creator_name` mediumtext NOT NULL,
  `company_id` mediumtext NOT NULL,
  `name` mediumtext NOT NULL,
  `lower_case_name` mediumtext NOT NULL,
  `logo` mediumtext NOT NULL,
  `address` mediumtext NOT NULL,
  `city` mediumtext NOT NULL,
  `pincode` mediumtext NOT NULL,
  `state` mediumtext NOT NULL,
  `mobile_number` mediumtext NOT NULL,
  `email` mediumtext NOT NULL,
  `gst_number` mediumtext NOT NULL,
  `deleted` int(100) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4;


INSERT INTO demo_plan_company (id, created_date_time, creator, creator_name, company_id, name, lower_case_name, logo, address, city, pincode, state, mobile_number, email, gst_number, deleted) VALUES ('1','2022-11-09 15:30:39','56564e46556c38774f5445784d6a41794d6a45314d4455784d6c38774d513d3d','51326870644342476457356b','5932397463474675655638774f5445784d6a41794d6a417a4d7a417a4f5638774d513d3d','55334a7049464e686133526f61585a6c6243424761584a6c6432397961334d3d','63334a7049484e686133526f61585a6c6243426d61584a6c6432397961334d3d','logo_21_12_2022_07_09_31.webp','5457563064474674595778686153776755326c325957746863326b674c5342545958523064584967556d5173','55326c325957746863326b3d','4e6a49324d546735','5647467461577767546d466b64513d3d','4e7a55354f4455674e7a67774f44673d','63334a706332467264476870646d56735a6d6c795a586476636d747a5147647459576c734c6d4e7662513d3d','NULL','0');


CREATE TABLE `demo_plan_customer` (
  `id` int(100) NOT NULL AUTO_INCREMENT,
  `created_date_time` datetime NOT NULL,
  `creator` mediumtext NOT NULL,
  `creator_name` mediumtext NOT NULL,
  `customer_id` mediumtext NOT NULL,
  `customer_unique_number` mediumtext NOT NULL,
  `agent_id` mediumtext NOT NULL,
  `agent_details` mediumtext NOT NULL,
  `name` mediumtext NOT NULL,
  `mobile_number` mediumtext NOT NULL,
  `address` mediumtext NOT NULL,
  `city` mediumtext NOT NULL,
  `state` mediumtext NOT NULL,
  `proof_type` mediumtext NOT NULL,
  `proof_number` mediumtext NOT NULL,
  `proof_image` mediumtext NOT NULL,
  `login_user_name` mediumtext NOT NULL,
  `password` mediumtext NOT NULL,
  `new_customer` int(100) NOT NULL,
  `fund_wallet` double NOT NULL,
  `merge_wallet` double NOT NULL,
  `total_wallet` double NOT NULL,
  `previously_in_fund` int(100) NOT NULL,
  `deleted` int(100) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;



CREATE TABLE `demo_plan_customer_chit` (
  `id` int(100) NOT NULL AUTO_INCREMENT,
  `created_date_time` datetime NOT NULL,
  `creator` mediumtext NOT NULL,
  `creator_name` mediumtext NOT NULL,
  `customer_chit_id` mediumtext NOT NULL,
  `customer_chit_unique_number` mediumtext NOT NULL,
  `agent_id` mediumtext NOT NULL,
  `agent_details` mediumtext NOT NULL,
  `customer_id` mediumtext NOT NULL,
  `customer_details` mediumtext NOT NULL,
  `chit_id` mediumtext NOT NULL,
  `chit_details` mediumtext NOT NULL,
  `maturity_value` double NOT NULL,
  `chit_type` mediumtext NOT NULL,
  `due_amount` double NOT NULL,
  `due_duration` double NOT NULL,
  `due_days` int(100) NOT NULL,
  `due_reminder_days` int(100) NOT NULL,
  `payable_amount` double NOT NULL,
  `start_date` date NOT NULL,
  `end_date` date NOT NULL,
  `booking_open_date` date NOT NULL,
  `penalty_duration` double NOT NULL,
  `penalty_value` mediumtext NOT NULL,
  `min_value` double NOT NULL,
  `max_value` double NOT NULL,
  `allow_split_up_due_payment` int(100) NOT NULL,
  `accept_advance_amount` int(100) NOT NULL,
  `accept_previous_due` int(100) NOT NULL,
  `allow_termination` int(100) NOT NULL,
  `termination_days` int(100) NOT NULL,
  `allow_agent` int(100) NOT NULL,
  `add_transport_charges` int(100) NOT NULL,
  `allow_merge_completed_wallet` int(100) NOT NULL,
  `add_due_without_penalty` int(100) NOT NULL,
  `completed_date` date NOT NULL,
  `due_count` int(100) NOT NULL,
  `last_paid_date` date NOT NULL,
  `next_due_date` date NOT NULL,
  `penalty_amount` double NOT NULL,
  `wallet` double NOT NULL,
  `commission` double NOT NULL,
  `amount_to_use_order_agent` double NOT NULL,
  `amount_to_use_order_customer` double NOT NULL,
  `account_merger_id` mediumtext NOT NULL,
  `order_id` mediumtext NOT NULL,
  `admin_approval` int(100) NOT NULL,
  `cancelled` int(100) NOT NULL,
  `cancel_date` date NOT NULL,
  `cancel_remarks` mediumtext NOT NULL,
  `deleted` int(100) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;



CREATE TABLE `demo_plan_customer_chit_merge` (
  `id` int(100) NOT NULL AUTO_INCREMENT,
  `created_date_time` datetime NOT NULL,
  `creator` mediumtext NOT NULL,
  `creator_name` mediumtext NOT NULL,
  `merge_request_id` mediumtext NOT NULL,
  `customer_chit_unique_number` mediumtext NOT NULL,
  `customer_chit_id` mediumtext NOT NULL,
  `wallet` double NOT NULL,
  `admin_approval` int(100) NOT NULL,
  `cancelled` int(100) NOT NULL,
  `deleted` int(100) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;



CREATE TABLE `demo_plan_login` (
  `id` int(100) NOT NULL AUTO_INCREMENT,
  `loginer_name` mediumtext NOT NULL,
  `login_date_time` datetime NOT NULL,
  `logout_date_time` datetime NOT NULL,
  `ip_address` mediumtext NOT NULL,
  `browser` mediumtext NOT NULL,
  `os_detail` mediumtext NOT NULL,
  `type` mediumtext NOT NULL,
  `user_id` mediumtext NOT NULL,
  `deleted` int(100) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=11 DEFAULT CHARSET=utf8mb4;


INSERT INTO demo_plan_login (id, loginer_name, login_date_time, logout_date_time, ip_address, browser, os_detail, type, user_id, deleted) VALUES ('1','51326870644342476457356b494367334e5441794d6a45774f444d314b513d3d','2023-01-04 18:05:20','2023-01-04 18:05:50','127.0.0.1','Mozilla/5.0 (Windows NT 10.0; Win64; x64; rv:108.0) Gecko/20100101 Firefox/108.0','Windows NT DESKTOP-1O194FK 10.0 build 19045 (Windows 10) AMD64','Admin','56564e46556c38774f5445784d6a41794d6a45314d4455784d6c38774d513d3d','0');

INSERT INTO demo_plan_login (id, loginer_name, login_date_time, logout_date_time, ip_address, browser, os_detail, type, user_id, deleted) VALUES ('2','51326870644342476457356b494367334e5441794d6a45774f444d314b513d3d','2023-01-06 12:47:33','2023-01-06 12:47:49','127.0.0.1','Mozilla/5.0 (Windows NT 10.0; Win64; x64; rv:108.0) Gecko/20100101 Firefox/108.0','Windows NT DESKTOP-1O194FK 10.0 build 19045 (Windows 10) AMD64','Admin','56564e46556c38774f5445784d6a41794d6a45314d4455784d6c38774d513d3d','0');

INSERT INTO demo_plan_login (id, loginer_name, login_date_time, logout_date_time, ip_address, browser, os_detail, type, user_id, deleted) VALUES ('3','51326870644342476457356b494367334e5441794d6a45774f444d314b513d3d','2023-01-06 12:58:08','2023-01-06 12:58:51','127.0.0.1','Mozilla/5.0 (Windows NT 10.0; Win64; x64; rv:108.0) Gecko/20100101 Firefox/108.0','Windows NT DESKTOP-1O194FK 10.0 build 19045 (Windows 10) AMD64','Admin','56564e46556c38774f5445784d6a41794d6a45314d4455784d6c38774d513d3d','0');

INSERT INTO demo_plan_login (id, loginer_name, login_date_time, logout_date_time, ip_address, browser, os_detail, type, user_id, deleted) VALUES ('4','51326870644342476457356b494367334e5441794d6a45774f444d314b513d3d','2023-01-06 13:00:19','0000-00-00 00:00:00','127.0.0.1','Mozilla/5.0 (Windows NT 10.0; Win64; x64; rv:108.0) Gecko/20100101 Firefox/108.0','Windows NT DESKTOP-1O194FK 10.0 build 19045 (Windows 10) AMD64','Admin','56564e46556c38774f5445784d6a41794d6a45314d4455784d6c38774d513d3d','0');

INSERT INTO demo_plan_login (id, loginer_name, login_date_time, logout_date_time, ip_address, browser, os_detail, type, user_id, deleted) VALUES ('5','55326868626d31315a324567554746755a476c686269416f4e7a41784d4467334e5467784e436b3d','2023-01-06 13:02:41','2023-01-06 13:04:11','127.0.0.1','Mozilla/5.0 (Windows NT 10.0; Win64; x64; rv:108.0) Gecko/20100101 Firefox/108.0','Windows NT DESKTOP-1O194FK 10.0 build 19045 (Windows 10) AMD64','Customer','5933567a644739745a584a664d4459774d5449774d6a4d774d5441794d6a64664d44453d','0');

INSERT INTO demo_plan_login (id, loginer_name, login_date_time, logout_date_time, ip_address, browser, os_detail, type, user_id, deleted) VALUES ('6','51326870644342476457356b494367334e5441794d6a45774f444d314b513d3d','2023-01-06 13:04:17','2023-01-06 13:06:44','127.0.0.1','Mozilla/5.0 (Windows NT 10.0; Win64; x64; rv:108.0) Gecko/20100101 Firefox/108.0','Windows NT DESKTOP-1O194FK 10.0 build 19045 (Windows 10) AMD64','Admin','56564e46556c38774f5445784d6a41794d6a45314d4455784d6c38774d513d3d','0');

INSERT INTO demo_plan_login (id, loginer_name, login_date_time, logout_date_time, ip_address, browser, os_detail, type, user_id, deleted) VALUES ('7','55326868626d31315a324567554746755a476c686269416f4e7a41784d4467334e5467784e436b3d','2023-01-06 13:07:02','2023-01-06 13:07:12','127.0.0.1','Mozilla/5.0 (Windows NT 10.0; Win64; x64; rv:108.0) Gecko/20100101 Firefox/108.0','Windows NT DESKTOP-1O194FK 10.0 build 19045 (Windows 10) AMD64','Customer','5933567a644739745a584a664d4459774d5449774d6a4d774d5441794d6a64664d44453d','0');

INSERT INTO demo_plan_login (id, loginer_name, login_date_time, logout_date_time, ip_address, browser, os_detail, type, user_id, deleted) VALUES ('8','51326870644342476457356b494367334e5441794d6a45774f444d314b513d3d','2023-01-06 17:23:38','2023-01-06 18:00:07','127.0.0.1','Mozilla/5.0 (Windows NT 10.0; Win64; x64; rv:108.0) Gecko/20100101 Firefox/108.0','Windows NT DESKTOP-1O194FK 10.0 build 19045 (Windows 10) AMD64','Admin','56564e46556c38774f5445784d6a41794d6a45314d4455784d6c38774d513d3d','0');

INSERT INTO demo_plan_login (id, loginer_name, login_date_time, logout_date_time, ip_address, browser, os_detail, type, user_id, deleted) VALUES ('9','51326870644342476457356b494367334e5441794d6a45774f444d314b513d3d','2023-01-07 11:53:27','2023-01-07 11:53:39','127.0.0.1','Mozilla/5.0 (Windows NT 10.0; Win64; x64; rv:108.0) Gecko/20100101 Firefox/108.0','Windows NT DESKTOP-1O194FK 10.0 build 19045 (Windows 10) AMD64','Admin','56564e46556c38774f5445784d6a41794d6a45314d4455784d6c38774d513d3d','0');

INSERT INTO demo_plan_login (id, loginer_name, login_date_time, logout_date_time, ip_address, browser, os_detail, type, user_id, deleted) VALUES ('10','51326870644342476457356b494367334e5441794d6a45774f444d314b513d3d','2023-01-07 11:53:44','0000-00-00 00:00:00','127.0.0.1','Mozilla/5.0 (Windows NT 10.0; Win64; x64; rv:108.0) Gecko/20100101 Firefox/108.0','Windows NT DESKTOP-1O194FK 10.0 build 19045 (Windows 10) AMD64','Admin','56564e46556c38774f5445784d6a41794d6a45314d4455784d6c38774d513d3d','0');


CREATE TABLE `demo_plan_orders` (
  `id` int(100) NOT NULL AUTO_INCREMENT,
  `created_date_time` datetime NOT NULL,
  `creator` mediumtext NOT NULL,
  `creator_name` mediumtext NOT NULL,
  `order_id` mediumtext NOT NULL,
  `order_number` mediumtext NOT NULL,
  `order_date` date NOT NULL,
  `company_details` mediumtext NOT NULL,
  `agent_id` mediumtext NOT NULL,
  `customer_id` mediumtext NOT NULL,
  `customer_name` mediumtext NOT NULL,
  `customer_mobile_number` mediumtext NOT NULL,
  `customer_city` mediumtext NOT NULL,
  `customer_state` mediumtext NOT NULL,
  `customer_details` mediumtext NOT NULL,
  `delivery_address` mediumtext NOT NULL,
  `customer_chit_ids` mediumtext NOT NULL,
  `customer_chit_details` mediumtext NOT NULL,
  `category_id` mediumtext NOT NULL,
  `category_name` mediumtext NOT NULL,
  `product_id` mediumtext NOT NULL,
  `product_code` mediumtext NOT NULL,
  `product_name` mediumtext NOT NULL,
  `product_content` mediumtext NOT NULL,
  `quantity` mediumtext NOT NULL,
  `price` mediumtext NOT NULL,
  `discount` mediumtext NOT NULL,
  `packing_charges` mediumtext NOT NULL,
  `packing_charges_option` int(100) NOT NULL,
  `total_amount` mediumtext NOT NULL,
  `new_order` int(100) NOT NULL,
  `confirmed` int(100) NOT NULL,
  `chit_ids` mediumtext NOT NULL,
  `despatched` int(100) NOT NULL,
  `delivered` int(100) NOT NULL,
  `deleted` int(100) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;



CREATE TABLE `demo_plan_orders_chit` (
  `id` int(100) NOT NULL AUTO_INCREMENT,
  `created_date_time` datetime NOT NULL,
  `creator` mediumtext NOT NULL,
  `creator_name` mediumtext NOT NULL,
  `order_id` mediumtext NOT NULL,
  `agent_id` mediumtext NOT NULL,
  `customer_id` mediumtext NOT NULL,
  `customer_chit_id` mediumtext NOT NULL,
  `amount` double NOT NULL,
  `deleted` int(100) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;



CREATE TABLE `demo_plan_orders_despatch` (
  `id` int(100) NOT NULL AUTO_INCREMENT,
  `created_date_time` datetime NOT NULL,
  `creator` mediumtext NOT NULL,
  `creator_name` mediumtext NOT NULL,
  `order_number` mediumtext NOT NULL,
  `despatch_date` date NOT NULL,
  `lr_number` mediumtext NOT NULL,
  `transport_name` mediumtext NOT NULL,
  `transfer_details` mediumtext NOT NULL,
  `lr_number_image` mediumtext NOT NULL,
  `deleted` int(100) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;



CREATE TABLE `demo_plan_otp_send_phone_numbers` (
  `id` int(100) NOT NULL AUTO_INCREMENT,
  `send_date` date NOT NULL,
  `phone_number` mediumtext NOT NULL,
  `otp_number` double NOT NULL,
  `otp_send_count` int(100) NOT NULL,
  `deleted` int(100) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;



CREATE TABLE `demo_plan_private_settings` (
  `id` int(100) NOT NULL AUTO_INCREMENT,
  `name` mediumtext NOT NULL,
  `value` mediumtext NOT NULL,
  `deleted` int(100) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=utf8mb4;


INSERT INTO demo_plan_private_settings (id, name, value, deleted) VALUES ('1','allow_booking','1','0');

INSERT INTO demo_plan_private_settings (id, name, value, deleted) VALUES ('2','allow_discount','2','0');

INSERT INTO demo_plan_private_settings (id, name, value, deleted) VALUES ('3','allow_sms','1','0');

INSERT INTO demo_plan_private_settings (id, name, value, deleted) VALUES ('4','sms_count','3000','0');

INSERT INTO demo_plan_private_settings (id, name, value, deleted) VALUES ('5','due_reminder_secret_key','4f5467334e6a55304d7a49784d413d3d','0');


CREATE TABLE `demo_plan_product` (
  `id` int(100) NOT NULL AUTO_INCREMENT,
  `created_date_time` datetime NOT NULL,
  `creator` mediumtext NOT NULL,
  `creator_name` mediumtext NOT NULL,
  `product_id` mediumtext NOT NULL,
  `category_id` mediumtext NOT NULL,
  `name` mediumtext NOT NULL,
  `lowercase_name` mediumtext NOT NULL,
  `product_code` mediumtext NOT NULL,
  `product_content` mediumtext NOT NULL,
  `price` mediumtext NOT NULL,
  `product_image` mediumtext NOT NULL,
  `product_video` mediumtext NOT NULL,
  `ordering` int(100) NOT NULL,
  `show_frontend` int(100) NOT NULL,
  `deleted` int(100) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;



CREATE TABLE `demo_plan_receipt` (
  `id` int(100) NOT NULL AUTO_INCREMENT,
  `created_date_time` datetime NOT NULL,
  `creator` mediumtext NOT NULL,
  `creator_name` mediumtext NOT NULL,
  `receipt_id` mediumtext NOT NULL,
  `receipt_unique_number` mediumtext NOT NULL,
  `receipt_date` date NOT NULL,
  `agent_id` mediumtext NOT NULL,
  `agent_details` mediumtext NOT NULL,
  `agent_commission` double NOT NULL,
  `customer_id` mediumtext NOT NULL,
  `customer_details` mediumtext NOT NULL,
  `receipter_details` mediumtext NOT NULL,
  `customer_chit_id` mediumtext NOT NULL,
  `customer_chit_details` mediumtext NOT NULL,
  `chit_due_amount` double NOT NULL,
  `chit_due_count` int(100) NOT NULL,
  `amount` double NOT NULL,
  `penalty_amount` double NOT NULL,
  `total_amount` double NOT NULL,
  `split_up_amount` int(100) NOT NULL,
  `payment_mode` mediumtext NOT NULL,
  `transaction_id` mediumtext NOT NULL,
  `transaction_screenshot` mediumtext NOT NULL,
  `admin_approval` int(100) NOT NULL,
  `later_due` int(100) NOT NULL,
  `deleted` int(100) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;



CREATE TABLE `demo_plan_settings` (
  `id` int(100) NOT NULL AUTO_INCREMENT,
  `name` mediumtext NOT NULL,
  `value` mediumtext NOT NULL,
  `deleted` int(100) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=26 DEFAULT CHARSET=utf8mb4;


INSERT INTO demo_plan_settings (id, name, value, deleted) VALUES ('1','backend_theme_color','#800000','0');

INSERT INTO demo_plan_settings (id, name, value, deleted) VALUES ('2','backend_theme_text_color','#ffffff','0');

INSERT INTO demo_plan_settings (id, name, value, deleted) VALUES ('3','frontend_theme_color','#800000','0');

INSERT INTO demo_plan_settings (id, name, value, deleted) VALUES ('4','frontend_theme_text_color','#ffffff','0');

INSERT INTO demo_plan_settings (id, name, value, deleted) VALUES ('5','current_year_diwali_date','14-11-2023','0');

INSERT INTO demo_plan_settings (id, name, value, deleted) VALUES ('6','allow_excess_wallet_amount_purchase','1','0');

INSERT INTO demo_plan_settings (id, name, value, deleted) VALUES ('7','transport_charges_option','2','0');

INSERT INTO demo_plan_settings (id, name, value, deleted) VALUES ('8','admin_forgot_password_otp_sms','1','0');

INSERT INTO demo_plan_settings (id, name, value, deleted) VALUES ('9','frontend_new_customer_register_sms','1','0');

INSERT INTO demo_plan_settings (id, name, value, deleted) VALUES ('10','request_sms_for_joining_chit','1','0');

INSERT INTO demo_plan_settings (id, name, value, deleted) VALUES ('11','request_sms_for_receipt_created_user','1','0');

INSERT INTO demo_plan_settings (id, name, value, deleted) VALUES ('12','request_sms_for_merging_chit','1','0');

INSERT INTO demo_plan_settings (id, name, value, deleted) VALUES ('13','booking_sms_from_user','1','0');

INSERT INTO demo_plan_settings (id, name, value, deleted) VALUES ('14','agent_forgot_password_otp_sms','1','0');

INSERT INTO demo_plan_settings (id, name, value, deleted) VALUES ('15','customer_register_otp_sms','1','0');

INSERT INTO demo_plan_settings (id, name, value, deleted) VALUES ('16','customer_forgot_password_otp_sms','1','0');

INSERT INTO demo_plan_settings (id, name, value, deleted) VALUES ('17','approval_sms_for_joining_chit','1','0');

INSERT INTO demo_plan_settings (id, name, value, deleted) VALUES ('18','approval_sms_for_receipt_created_user','1','0');

INSERT INTO demo_plan_settings (id, name, value, deleted) VALUES ('19','approval_sms_for_merging_chit','1','0');

INSERT INTO demo_plan_settings (id, name, value, deleted) VALUES ('20','due_amount_paid_sms_to_user','1','0');

INSERT INTO demo_plan_settings (id, name, value, deleted) VALUES ('21','due_reminder_sms_to_user','1','0');

INSERT INTO demo_plan_settings (id, name, value, deleted) VALUES ('22','chit_close_sms_to_user','1','0');

INSERT INTO demo_plan_settings (id, name, value, deleted) VALUES ('23','terminate_from_chit_sms_to_user','1','0');

INSERT INTO demo_plan_settings (id, name, value, deleted) VALUES ('24','booking_opening_date_sms_to_user','1','0');

INSERT INTO demo_plan_settings (id, name, value, deleted) VALUES ('25','delivery_sms_to_user','1','0');


CREATE TABLE `demo_plan_shipping_address` (
  `id` int(100) NOT NULL AUTO_INCREMENT,
  `created_date_time` datetime NOT NULL,
  `creator` mediumtext NOT NULL,
  `creator_name` mediumtext NOT NULL,
  `shipping_address_id` mediumtext NOT NULL,
  `agent_id` mediumtext NOT NULL,
  `customer_id` mediumtext NOT NULL,
  `name` mediumtext NOT NULL,
  `mobile_number` mediumtext NOT NULL,
  `address` mediumtext NOT NULL,
  `city` mediumtext NOT NULL,
  `state` mediumtext NOT NULL,
  `deleted` int(100) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;



CREATE TABLE `demo_plan_sms_count` (
  `id` int(100) NOT NULL AUTO_INCREMENT,
  `sms_type` mediumtext NOT NULL,
  `sms_count` double NOT NULL,
  `deleted` int(100) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;



CREATE TABLE `demo_plan_sms_histroy` (
  `id` int(100) NOT NULL AUTO_INCREMENT,
  `send_date` date NOT NULL,
  `sms_type` mediumtext NOT NULL,
  `action` mediumtext NOT NULL,
  `deleted` int(100) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;



CREATE TABLE `demo_plan_state` (
  `id` int(100) NOT NULL AUTO_INCREMENT,
  `created_date_time` datetime NOT NULL,
  `creator` mediumtext NOT NULL,
  `creator_name` mediumtext NOT NULL,
  `state_name` mediumtext NOT NULL,
  `transport_charges` mediumtext NOT NULL,
  `deleted` int(100) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4;


INSERT INTO demo_plan_state (id, created_date_time, creator, creator_name, state_name, transport_charges, deleted) VALUES ('1','2023-01-06 13:00:30','56564e46556c38774f5445784d6a41794d6a45314d4455784d6c38774d513d3d','51326870644342476457356b','Tamil Nadu','100','0');


CREATE TABLE `demo_plan_user` (
  `id` int(100) NOT NULL AUTO_INCREMENT,
  `created_date_time` datetime NOT NULL,
  `creator` mediumtext NOT NULL,
  `creator_name` mediumtext NOT NULL,
  `user_id` mediumtext NOT NULL,
  `name` mediumtext NOT NULL,
  `mobile_number` mediumtext NOT NULL,
  `user_login_id` mediumtext NOT NULL,
  `password` mediumtext NOT NULL,
  `admin` int(100) NOT NULL,
  `deleted` int(100) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4;


INSERT INTO demo_plan_user (id, created_date_time, creator, creator_name, user_id, name, mobile_number, user_login_id, password, admin, deleted) VALUES ('1','2022-11-09 15:05:12','56564e46556c38774f5445784d6a41794d6a45314d4455784d6c38774d513d3d','52476c335957787049454e6f6158513d','56564e46556c38774f5445784d6a41794d6a45314d4455784d6c38774d513d3d','51326870644342476457356b','4e7a55774d6a49784d44677a4e513d3d','55314a4a5530394756466442556b5661','51575274615734784d6a4e41','1','0');


CREATE TABLE `demo_plan_voucher` (
  `id` int(100) NOT NULL AUTO_INCREMENT,
  `created_date_time` datetime NOT NULL,
  `creator` mediumtext NOT NULL,
  `creator_name` mediumtext NOT NULL,
  `voucher_id` mediumtext NOT NULL,
  `voucher_unique_number` mediumtext NOT NULL,
  `voucher_date` date NOT NULL,
  `agent_id` mediumtext NOT NULL,
  `agent_details` mediumtext NOT NULL,
  `voucher_details` mediumtext NOT NULL,
  `customer_chit_id` mediumtext NOT NULL,
  `customer_chit_details` mediumtext NOT NULL,
  `amount` double NOT NULL,
  `payment_mode` mediumtext NOT NULL,
  `transaction_id` mediumtext NOT NULL,
  `transaction_screenshot` mediumtext NOT NULL,
  `remarks` mediumtext NOT NULL,
  `deleted` int(100) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

