<?php		
	include("include.php");	
    
    if(isset($_REQUEST['show_product_id'])) {
        $show_product_id = $_REQUEST['show_product_id'];

        $category_id = ""; $name = ""; $product_code = ""; $product_content = ""; $price = ""; $product_image = ""; $product_video = "";

        if(!empty($show_product_id)) {
            $product_list = array();
            $product_list = $obj->getTableRecords($GLOBALS['product_table'], 'product_id', $show_product_id);
            if(!empty($product_list)) {
				foreach($product_list as $data) {
					if(!empty($data['category_id'])) {
						$category_id = $data['category_id'];
					}
                    if(!empty($data['name'])) {
						$name = $obj->encode_decode('decrypt', $data['name']);
						$name = str_replace("$", "''", $name);
					}
					if(!empty($data['product_code'])) {
						$product_code = $obj->encode_decode('decrypt', $data['product_code']);
					}
                    if(!empty($data['product_content'])) {
						$product_content = $obj->encode_decode('decrypt', $data['product_content']);
					}
                    if(!empty($data['price'])) {
						$price = $data['price'];
					}
                    if(!empty($data['product_image']) && $data['product_image'] != $GLOBALS['null_value']) {
						$product_image = $data['product_image'];
					}
					if(!empty($data['product_video']) && $data['product_video'] != $GLOBALS['null_value']) {
						$product_video = $obj->encode_decode('decrypt', $data['product_video']);
					}
				}
            }
        }
		$target_dir = $obj->image_directory();
		$target_dir = str_replace("include", "..", $target_dir);

        $category_list = array();
		$category_list = $obj->getTableRecords($GLOBALS['category_table'], '', '');
?>
        <form class="py-4 poppins pd-20" name="product_form" method="POST">
            <div class="row pt-3">
                <input type="hidden" name="edit_id" value="<?php if(!empty($show_product_id)) { echo $show_product_id; } ?>">
				<input type="hidden" name="multi_image_upload" id="multi_image_upload" value="">
				<div class="col-xl-6">
					<div class="form-group">
						<div class="form-label-group in-border mb-0"> <?php /* onChange="Javascript:checkCategoryName(this.value);" */ ?>
							<select name="category_id" class="form-control" >
                                <option value="">Select the category</option>
                                <?php
                                    if(!empty($category_list)) {
                                        foreach($category_list as $data) {
                                ?>
                                            <option value="<?php if(!empty($data['category_id'])) { echo $data['category_id']; } ?>" <?php if(!empty($category_id) && $data['category_id'] == $category_id) { ?> selected <?php } ?> >
                                                <?php
                                                    if(!empty($data['name'])) {
                                                        $data['name'] = $obj->encode_decode('decrypt', $data['name']);
														$data['name'] = str_replace("$", '"', $data['name']);
														$data['name'] = str_replace("'''", '"', $data['name']);
                                                        echo $data['name'];
                                                    }
                                                ?>
                                            </option>
                                <?php        
                                        }
                                    }
                                ?>
                            </select>
							<label>Category</label>
						</div>
					</div>
					<div class="form-group">
						<div style="color: red; font-size: 13px; line-height: 15px; margin-bottom: 10px;">Max.Chars Count : 60</div>
						<div class="form-label-group in-border mb-0">
							<input type="text" name="name" value="<?php if(!empty($name)) { echo $name; } ?>" class="form-control shadow-none" placeholder="Product Name">
							<label>Product Name *</label>
						</div>
					</div>
                    <div class="row mx-0 form-group">
                        <div class="col-6">
                            <div class="form-label-group in-border mb-0">
                                <input type="text" name="product_code" value="<?php if(!empty($product_code)) { echo $product_code; } ?>" class="form-control shadow-none" placeholder="Product Code">
                                <label>Product Code *</label>
                            </div>
                        </div>
                        <div class="col-6">
                            <div class="form-label-group in-border mb-0">
                                <input type="text" name="product_content" value="<?php if(!empty($product_content)) { echo $product_content; } ?>" class="form-control shadow-none" placeholder="Product Content">
                                <label>Product Content *</label>
                            </div>
                        </div>
                    </div>
				</div>
				<div class="col-xl-6">
					<div id="product_image_cover" class="form-group">
						<h6 class="w-100 text-center d-none">Product Image (500 x 500) <br> Max.Upload Size - 2 MB</h6> 
						<div class="image-upload text-center">
							<label for="product_image">   
								<div class="product_image_list row">
									<div class="col-12">
										<div class="cover">
											<?php if(!empty($product_image) && file_exists($target_dir.$product_image)) { ?>
												<button type="button" onclick="Javascript:delete_upload_image_before_save(this, 'product_image', '<?php if(!empty($product_image)) { echo $product_image; } ?>');" class="btn btn-danger"><i class="fa fa-close"></i></button>
												<img id="product_image_preview" src="<?php echo $target_dir.$product_image; ?>" style="max-width: 100%; max-height: 150px;" />
												<input type="hidden" name="product_image_name[]" value="<?php if(!empty($product_image)) { echo $product_image; } ?>">
											<?php } else { ?>
												<img id="product_image_preview" src="include/images/upload_image.png" style="max-width: 150px;" />
											<?php } ?>
										</div>
									</div>        
								</div>
								<input type="file" name="product_image" id="product_image" style="display: none;" accept="image/*" />
							</label>
						</div>
						
						<div class="product_image_container" style="display: none;">
							<canvas id="product_image_canvas"></canvas>
						</div>
					</div>
				</div>
                <div class="form-group col-sm-4">
					<div class="form-label-group in-border mb-0">
						<input type="text" name="price" value="<?php if(!empty($price)) { echo $price; } ?>" class="form-control shadow-none" placeholder="Price">
						<label>Price *</label>
					</div>
				</div>
                <div class="form-group col-sm-6">
					<div class="form-label-group in-border mb-0">
						<input type="text" name="product_video" value="<?php if(!empty($product_video)) { echo $product_video; } ?>" class="form-control shadow-none" placeholder="Video URL">
						<label>Video URL</label>
					</div>
				</div>
			</div>	

			<div class="col-md-12 pt-3 text-center">
				<button class="btn btn-primary btnwidth submit_button" type="button" onClick="Javascript:SaveModalContent(event, 'product_form', 'product_changes.php', 'product.php');">Submit</button>
			</div>

			<script type="text/javascript" src="include/js/image_upload.js"></script>

            <script type="text/javascript">
				jQuery(document).ready(function(){
					jQuery('form[name="product_form"]').find('select').select2();
				});    
			</script>
        </form>
<?php        
    }

    if(isset($_POST['category_id'])) {	
        $category_id = ""; $category_id_error = ""; $name = ""; $name_error = ""; $product_code = ""; $product_code_error = "";
        $product_content = ""; $product_content_error = ""; $price = ""; $price_error = ""; $product_image_name = array();
        $product_image_error = ""; $product_image = ""; $product_video = "";

		$create_date_time = $GLOBALS['create_date_time_label']; $creator = $GLOBALS['creator'];
		$valid_product = ""; $form_name = "product_form";
        
        $category_id = $_POST['category_id'];
		$category_id = trim($category_id);
        if(empty($category_id)) {
            $category_id_error = "Select the category";
        }
		if(!empty($category_id) && empty($category_id_error)) {
			$category_unique_id = "";
			$category_unique_id = $obj->getTableColumnValue($GLOBALS['category_table'], 'category_id', $category_id, 'id');
			if(!preg_match("/^\d+$/", $category_unique_id)) {
				$category_id_error = "Invalid category";
			}
		}
		if(!empty($category_id_error)) {
			$valid_product = $valid->error_display($form_name, "category_id", $category_id_error, 'select');
        }

        $name = $_POST['name'];
		$name = trim($name);
        if(empty($name)) {
            $name_error = "Enter the name";
        }
		else if(!empty($name) && empty($name_error)) {
            if(strlen($name) > 60) {
				$name_error = "Product name is max 60 characters are allowed";
			}
        }

		if(!empty($name_error)) {
			if(!empty($valid_product)) {
				$valid_product = $valid_product." ".$valid->error_display($form_name, "name", $name_error, 'text');
			}
			else {
				$valid_product = $valid->error_display($form_name, "name", $name_error, 'text');
			}
		}

        $product_code = $_POST['product_code'];
		$product_code = trim($product_code);
        if(empty($product_code)) {
            $product_code_error = "Enter the product code";
        }
		if(!empty($product_code_error)) {
			if(!empty($valid_product)) {
				$valid_product = $valid_product." ".$valid->error_display($form_name, "product_code", $product_code_error, 'text');
			}
			else {
				$valid_product = $valid->error_display($form_name, "product_code", $product_code_error, 'text');
			}
		}

        $product_content = $_POST['product_content'];
		$product_content = trim($product_content);
        if(empty($product_content)) {
            $product_content_error = "Enter the product content";
        }
		if(!empty($product_content_error)) {
			if(!empty($valid_product)) {
				$valid_product = $valid_product." ".$valid->error_display($form_name, "product_content", $product_content_error, 'text');
			}
			else {
				$valid_product = $valid->error_display($form_name, "product_content", $product_content_error, 'text');
			}
		}

        $price = $_POST['price'];
		$price = trim(str_replace(",", "", $price));
		$price = trim($price);
		$price_error = $valid->valid_price($price, "Price", "1");
		if(!empty($price_error)) {
			if(!empty($valid_product)) {
				$valid_product = $valid_product." ".$valid->error_display($form_name, "price", $price_error, 'text');
			}
			else {
				$valid_product = $valid->error_display($form_name, "price", $price_error, 'text');
			}
		}

		if(isset($_POST['product_image_name'])) {
            $product_image_name = $_POST['product_image_name'];
        }
        
		if(isset($_POST['product_video'])) {
			$product_video = $_POST['product_video'];
			$product_video = trim($product_video);
		}
		
		if(isset($_POST['edit_id'])) {
			$edit_id = $_POST['edit_id'];
		}
		
		$result = "";
		
		if(empty($valid_product)) {
			$check_user_id_ip_address = 0;
			$check_user_id_ip_address = $obj->check_user_id_ip_address();	
			if(preg_match("/^\d+$/", $check_user_id_ip_address)) {

				$lowercase_name = "";
				if(!empty($name)) {
					$name = htmlentities($name, ENT_QUOTES);
					$lowercase_name = strtolower($name);
					$lowercase_name = $obj->encode_decode('encrypt', $lowercase_name);
					$name = $obj->encode_decode('encrypt', $name);
				}
                if(!empty($product_code)) {
                    $product_code = $obj->encode_decode('encrypt', $product_code);
                }
                if(!empty($product_content)) {
                    $product_content = $obj->encode_decode('encrypt', $product_content);
                }

				if(!empty($product_image_name) && is_array($product_image_name)) {
                    $product_image = implode("$$$", $product_image_name);
                }
                if(empty($product_image)) {
                    $product_image = $GLOBALS['null_value'];
                }

				if(!empty($product_video)) {
                    $product_video = $obj->encode_decode('encrypt', $product_video);
                }
				else {
                    $product_video = $GLOBALS['null_value'];
                }

				$prev_product_id = ""; $agent_error = "";			
				if(!empty($product_code)) {
					$prev_product_id = $obj->getTableColumnValue($GLOBALS['product_table'], 'product_code', $product_code, 'product_id');
					if(!empty($prev_product_id)) {
                        $product_error = "This product name is already exist";
                    }
                }

				$image_copy = 0;

				if(empty($edit_id)) {
					if(empty($prev_product_id)) {
                        $created_date_time = $GLOBALS['create_date_time_label']; $creator = $GLOBALS['creator'];
                        $creator_name = $obj->encode_decode('encrypt', $GLOBALS['user_name']);

						$action = "";
						if(!empty($name)) {
							$action = "New Product Created. Code - ".$obj->encode_decode('decrypt', $product_code)." Name - ".$obj->encode_decode('decrypt', $name);
						}

                        $ordering_number = "";
						$ordering_number = $obj->getOrderingNumber($GLOBALS['product_table'], $category_id);

						$null_value = $GLOBALS['null_value'];
                        $columns = array('created_date_time', 'creator', 'creator_name', 'product_id', 'category_id', 'name', 'lowercase_name', 'product_code', 'product_content', 'price', 'product_image', 'product_video', 'ordering', 'show_frontend', 'deleted');
                        $values = array("'".$created_date_time."'", "'".$creator."'", "'".$creator_name."'", "'".$null_value."'", "'".$category_id."'", "'".$name."'", "'".$lowercase_name."'", "'".$product_code."'", "'".$product_content."'", "'".$price."'", "'".$product_image."'", "'".$product_video."'", "'".$ordering_number."'", "'0'", "'0'");
						$product_insert_id = $obj->InsertSQL($GLOBALS['product_table'], $columns, $values, $action);						
						if(preg_match("/^\d+$/", $product_insert_id)) {
							$product_id = "";
							if($product_insert_id < 10) {
								$product_id = "PRODUCT_".date("dmYhis")."_0".$product_insert_id;
							}
							else {
								$product_id = "PRODUCT_".date("dmYhis")."_".$product_insert_id;
							}
                            if(!empty($product_id)) {
                                $product_id = $obj->encode_decode('encrypt', $product_id);
                            }

                            $columns = array(); $values = array();						
                            $columns = array('product_id');
                            $values = array("'".$product_id."'");
                            $product_update_id = $obj->UpdateSQL($GLOBALS['product_table'], $product_insert_id, $columns, $values, '');
                            if(preg_match("/^\d+$/", $product_update_id)) {	
								$image_copy = 1;
                                $result = array('number' => '1', 'msg' => 'Product Successfully Created');					
                            }
                            else {
                                $result = array('number' => '2', 'msg' => $product_update_id);
                            }
						}
						else {
							$result = array('number' => '2', 'msg' => $product_insert_id);
						}
					}
					else {
						$result = array('number' => '2', 'msg' => $product_error);
					}
				}
				else {
					if(empty($prev_product_id) || $prev_product_id == $edit_id) {
						$getUniqueID = "";
						$getUniqueID = $obj->getTableColumnValue($GLOBALS['product_table'], 'product_id', $edit_id, 'id');
						if(preg_match("/^\d+$/", $getUniqueID)) {
							$action = "";
							if(!empty($name)) {
								$action = "Product Updated. Code - ".$obj->encode_decode('decrypt', $product_code)." Name - ".str_replace("$", '"', $obj->encode_decode('decrypt', $name));
							}

							$columns = array(); $values = array();						
							$columns = array('category_id', 'name', 'lowercase_name', 'product_code', 'product_content', 'price', 'product_image', 'product_video');
							$values = array("'".$category_id."'", "'".$name."'", "'".$lowercase_name."'", "'".$product_code."'", "'".$product_content."'", "'".$price."'", "'".$product_image."'", "'".$product_video."'");
							$product_update_id = $obj->UpdateSQL($GLOBALS['product_table'], $getUniqueID, $columns, $values, $action);
							if(preg_match("/^\d+$/", $product_update_id)) {	
								$image_copy = 1;
								$result = array('number' => '1', 'msg' => 'Updated Successfully');						
							}
							else {
								$result = array('number' => '2', 'msg' => $product_update_id);
							}							
						}
					}
					else {
						$result = array('number' => '2', 'msg' => $product_error);
					}
                }

				if(!empty($image_copy) && $image_copy == 1) {
					$target_dir = $obj->image_directory(); $temp_dir = $obj->temp_image_directory();
					$target_dir = str_replace("include", "..", $target_dir);
					$temp_dir = str_replace("include", "..", $temp_dir);
					if(!empty($product_image)) {				
						if(file_exists($temp_dir.$product_image)) {   
							if(!empty($prev_product_image)) {		
								if(file_exists($target_dir.$prev_product_image)) {   
									unlink($target_dir.$prev_product_image);
								}
							}
							copy($temp_dir.$product_image, $target_dir.$product_image);
						}
						else {
							if($product_image == $GLOBALS['null_value']) {
								if(!empty($prev_product_image) && file_exists($target_dir.$prev_product_image)) {   
									unlink($target_dir.$prev_product_image);
								}
							}
						}
					}
					//$obj->clear_temp_image_directory();
					$temp_dir = "../images/temp/";
			
					$files = glob($temp_dir.'*'); // get all file names
					foreach($files as $file){ // iterate files
					if(is_file($file))
						unlink($file); // delete file
					}
				}

			}
			else {
				$result = array('number' => '2', 'msg' => 'Invalid IP');
			}
		}
		else {
			if(!empty($valid_product)) {
				$result = array('number' => '3', 'msg' => $valid_product);
			}
		}
		
		if(!empty($result)) {
			$result = json_encode($result);
		}
		echo $result; exit;
	}	
	
	if(isset($_POST['page_number'])) {
		$page_number = $_POST['page_number'];
		$page_limit = $_POST['page_limit'];
		$page_title = $_POST['page_title'];

		$search_text = "";
		if(isset($_POST['search_text'])) {
			$search_text = $_POST['search_text'];
		}

		$filter_category_id = "";
		if(isset($_POST['filter_category_id'])) {
			$filter_category_id = $_POST['filter_category_id'];
		}
		
		$total_records_list = array();
		if(!empty($filter_category_id)) {
			$total_records_list = $obj->getTableRecords($GLOBALS['product_table'], 'category_id', $filter_category_id);
		}
		else {
			$total_records_list = $obj->getTableRecords($GLOBALS['product_table'], '', '');
		}

		if(!empty($search_text)) {
			$search_text = strtolower($search_text);
			$list = array();
			if(!empty($total_records_list)) {
				foreach($total_records_list as $val) {
					if( (strpos(strtolower($obj->encode_decode('decrypt', $val['name'])), $search_text) !== false) ) {
						$list[] = $val;
					}
				}
			}
			$total_records_list = $list;
		}
		
		$total_pages = 0;	
		if(!empty($total_records_list) && is_array($total_records_list)) { 
			$total_pages = count($total_records_list);
		}
		
		$page_start = 0; $page_end = 0;
		if(!empty($page_number) && !empty($page_limit) && !empty($total_pages)) {
			if($total_pages > $page_limit) {
				if($page_number) {
					$page_start = ($page_number - 1) * $page_limit;
					$page_end = $page_start + $page_limit;
				}
			}
			else {
				$page_start = 0;
				$page_end = $page_limit;
			}
		}

		$show_records_list = array();
        if(!empty($total_records_list)) {
            foreach($total_records_list as $key => $val) {
                if($key >= $page_start && $key < $page_end) {
                    $show_records_list[] = $val;
                }
            }
        }
?>

        <?php if($total_pages > $page_limit) { ?>
			<div class="pagination_cover mt-3"> 
				<?php
					include("pagination.php");
				?> 
			</div> 
		<?php } ?>

		<table class="table nowrap show_frontend_table">
            <thead>
                <tr>
                    <th class="text-center px-2 py-2" style="width: 75px;">Code</th>
					<?php if(empty($filter_category_id)) { ?>
                    <th class="text-center px-2 py-2" style="width: 300px;">Category Name</th>
					<?php } ?> 
                    <th class="text-center px-2 py-2">Product Name</th>
					<th class="text-center px-2 py-2" style="width: 125px;">Price</th>
					<th class="text-center px-2 py-2" style="width: 150px;">Show Frontend</th>
                    <th class="text-center px-2 py-2" style="width: 100px;">Action</th>
                </tr>
            </thead>
            <tbody>
                <?php
                    if(!empty($show_records_list)) {
                        foreach($show_records_list as $key => $data) {
                ?>
                            <tr>
                                <td class="text-center px-2 py-2">
									<?php
                                        if(!empty($data['product_code'])) {
                                            $data['product_code'] = $obj->encode_decode('decrypt', $data['product_code']);
                                            echo $data['product_code'];
                                        }
                                    ?>
								</td>
								<?php if(empty($filter_category_id)) { ?>
                                <td class="text-center px-2 py-2">
                                    <?php
										$category_name = "";
                                        if(!empty($data['category_id'])) {
                                            $category_name = $obj->getTableColumnValue($GLOBALS['category_table'], 'category_id', $data['category_id'], 'name');
                                            if(!empty($category_name)) {
												$category_name = $obj->encode_decode('decrypt', $category_name);
												echo $category_name;
											}
                                        }
                                    ?>
                                </td>
								<?php } ?>
                                <td class="px-2 py-2" onclick="Javascript:EditProduct(this, '<?php if(!empty($data['product_id'])) { echo $data['product_id']; } ?>');">
									<?php
										if(!empty($data['name'])) {
											$data['name'] = $obj->encode_decode('decrypt', $data['name']);
											echo $data['name'];
										}
									?>
                                </td>
								<td class="text-center px-2 py-2" onclick="Javascript:EditPrice(this, '<?php if(!empty($data['product_id'])) { echo $data['product_id']; } ?>');">
									<?php if(!empty($data['price'])) { echo number_format($data['price'], 2); } ?>
								</td>
								<td class="text-center px-2 py-2">
									<div class="w-100 category_product_toggle_cover">
										<label class="switch" onChange="Javascript:ShowHideProduct(this, '<?php if(!empty($data['product_id'])) { echo $data['product_id']; } ?>');">
											<input type="checkbox" id="product_toggle_<?php if(!empty($data['product_id'])) { echo $data['product_id']; } ?>" <?php if(empty($data['show_frontend'])) { ?> checked <?php } ?> >
											<div class="slider round"></div>
										</label>
									</div>
								</td>
                                <td class="text-center">
									<div class="dropdown">
										<a class="btn btn-dark poppins px-3" href="#" role="button" data-toggle="dropdown">
											<i class="fa fa-ellipsis-v text-white"></i>
										</a>
										<div class="dropdown-menu dropdown-menu-right dropdown-menu-icon-list">
											<a class="dropdown-item" href="Javascript:ShowModalContent('<?php if(!empty($page_title)) { echo $page_title; } ?>', '<?php if(!empty($data['product_id'])) { echo $data['product_id']; } ?>');"><i class="fa fa-pencil"></i> &ensp; View / Edit</a>
											<a class="dropdown-item" href="Javascript:DeleteModalContent('<?php if(!empty($page_title)) { echo $page_title; } ?>', '<?php if(!empty($data['product_id'])) { echo $data['product_id']; } ?>');"><i class="fa fa-trash"></i> &ensp; Delete</a>
										</div>
									</div>         
                                </td>
                            </tr>
                <?php
                        }
                    }
                    else {
                ?>
                        <tr>
                            <td colspan="<?php if(empty($filter_category_id)) { echo "6"; } else { echo "5"; } ?>" class="text-center">Sorry! No records found</td>
                        </tr>
                <?php } ?>
            </tbody>
        </table>
<?php	
	}

	if(isset($_REQUEST['show_product_order'])) {
		$show_product_order = $_REQUEST['show_product_order'];
		$ordering_category_id = $_REQUEST['ordering_category_id'];
		if(!empty($show_product_order) && $show_product_order == 1) {
			$product_list = array();
			if(!empty($ordering_category_id)) {
				$product_list = $obj->DisplayCategoryProductsByOrder($ordering_category_id);
			}
?>
			<form class="py-4 poppins pd-20 col-xl-8 mx-auto" name="ordering_product_form" method="POST">
				<div class="row">
					<div class="form-group col-12">
						<input type="hidden" name="ordering_category_id" class="form-control" value="<?php if(!empty($ordering_category_id)) { echo $ordering_category_id; } ?>">
						<table class="data-table table nowrap tablefont ordering_product_table" style="margin: auto;">
                            <thead class="thead-dark">
                                <tr>
                                    <th style="text-align: center; width: 50px;">S.No</th>
                                    <th style="text-align: center;">Product Name</th>
                                    <th style="text-align: center; width: 100px;">Position</th>
                                </tr>
								<?php
									if(!empty($product_list)) {
										foreach($product_list as $key => $data) {
											if(!empty($data['product_id'])) {
								?>
												<tr>
													<td style="text-align: center; width: 50px;"><?php echo $key + 1; ?></td>
													<td>
														<?php
															if(!empty($data['name'])) {
																$data['name'] = $obj->encode_decode('decrypt', $data['name']);
																$data['name'] = str_replace("$", '"', $data['name']);
																$data['name'] = str_replace("'''", '"', $data['name']);
																echo $data['name'];
															}
														?>
														<input type="hidden" name="ordering_product_id[]" class="form-control" value="<?php echo $data['product_id']; ?>">
													</td>
													<td style="text-align: center; width: 100px;">
														<input type="text" name="ordering_product_position[]" class="form-control" value="<?php if(!empty($data['ordering'])) { echo $data['ordering']; } ?>">
													</td>
												</tr>
								<?php				
											}
										}
									}
									else {
								?>
									<tr>
										<td colspan="3" class="text-center">Sorry! No records found</td>
									</tr>
								<?php } ?>
                            </thead>
						</table>	
					</div>
					<div class="col-md-12 pt-3 text-center">
						<button class="btn btn-primary btnwidth submit_button" type="button" onClick="Javascript:UpdateProductOrder('ordering_product_form');">Update</button>
					</div>
				</div>
			</form>
<?php			
		}
	}

	if(isset($_POST['ordering_category_id'])) {
		$ordering_category_id = ""; $ordering_product_id = array(); $ordering_product_position = array(); $ordering_error = "";
		$ordering_positions = array();

		$ordering_category_id = $_POST['ordering_category_id'];
		$ordering_product_id = $_POST['ordering_product_id'];
		$ordering_product_position = $_POST['ordering_product_position'];
		if(!empty($ordering_product_id) && !empty($ordering_product_position)) {
			if(empty($ordering_category_id)) {
				$ordering_error = "Category ID is missing";
			}
			for($i = 0; $i < count($ordering_product_id); $i++) {
				if(!empty($ordering_product_id[$i])) {
					if(!empty($ordering_product_position[$i])) {
						if(preg_match("/^\d+$/", $ordering_product_position[$i])) {
							if(!in_array($ordering_product_position[$i], $ordering_positions)) {
								$ordering_positions[] = $ordering_product_position[$i];
							}
							else {
								$ordering_error = "Repeating Positions";
							}
						}
						else {
							$ordering_error = "Invalid Position";
						}
					}
					else {
						$ordering_error = "Empty position";
					}
				}
				else {
					$ordering_error = "Product ID is missing";
				}
			}
			$result = "";
			if(empty($ordering_error)) {
				if(!empty($ordering_category_id) && !empty($ordering_product_id) && !empty($ordering_product_position)) {
					$success = 0;
					for($i = 0; $i < count($ordering_product_id); $i++) {
						$product_id = ""; $position = "";
						if(!empty($ordering_product_id[$i])) {
							$product_id = $ordering_product_id[$i];
						}
						if(!empty($ordering_product_position[$i])) {
							$position = $ordering_product_position[$i];
						}
						if(!empty($product_id) && !empty($position)) {
							$getUniqueID = "";
							$getUniqueID = $obj->getTableColumnValue($GLOBALS['product_table'], 'product_id', $product_id, 'id');
							if(preg_match("/^\d+$/", $getUniqueID)) {
								$product_code = "";
								$product_code = $obj->getTableColumnValue($GLOBALS['product_table'], 'product_id', $product_id, 'product_code');

								$name = "";
								$name = $obj->getTableColumnValue($GLOBALS['product_table'], 'product_id', $product_id, 'name');

								$action = "";
								if(!empty($name)) {
									$action = "Product Position Updated. Code - ".$obj->encode_decode('decrypt', $product_code)." Name - ".str_replace("$", '"', $obj->encode_decode('decrypt', $name));
								}
							
								$product_update_id = ""; $columns = array(); $values = array();						
								$columns = array('ordering');
								$values = array("'".$position."'");
								$product_update_id = $obj->UpdateSQL($GLOBALS['product_table'], $getUniqueID, $columns, $values, $action);
								if(preg_match("/^\d+$/", $product_update_id)) {
									$success++;					
								}						
							}
						}
					}
					if(!empty($success) && $success == count($ordering_product_id)) {
						$result = array('number' => '1', 'msg' => 'Updated Successfully');
					}
					else {
						$result = array('number' => '2', 'msg' => 'Some product positions are not updated');
					}
				}		
			}
			else {
				$result = array('number' => '2', 'msg' => $ordering_error);
			}
			if(!empty($result)) {
				$result = json_encode($result);
			}
			echo $result; exit;
		}
	}

	if(isset($_REQUEST['update_product_price'])) {
		$update_product_price = $_REQUEST['update_product_price'];
		$product_category_id = $_REQUEST['product_category_id'];
		if(!empty($update_product_price) && $update_product_price == 1) {
			$product_list = array();
			if(!empty($product_category_id)) {
				$product_list = $obj->DisplayCategoryProductsByOrder($product_category_id);
			}
?>
			<form class="py-4 poppins pd-20 col-xl-8 mx-auto" name="update_product_price_form" method="POST">
				<div class="row">
					<div class="form-group col-sm-6">
						<div class="form-label-group in-border mb-0">
							<input type="text" name="update_value" value="" class="form-control shadow-none" placeholder="Value" onKeyup="Javascript:UpdatePrice();">
							<label>Value *</label>
						</div>
					</div>
					<div class="form-group col-sm-6">
						<div class="form-label-group in-border mb-0 update_option">
							<select name="update_option" class="form-control" onChange="Javascript:UpdatePrice();">
								<option value="">Select Option</option>
								<option value="+">+</option>
								<option value="-">-</option>
								<option value="x">x</option>
								<option value="%+">%+</option>
								<option value="%-">%-</option>
							</select>
							<label>Update Option *</label>
						</div>
					</div>
					<div class="form-group col-12">
						<input type="hidden" name="product_category_id" class="form-control" value="<?php if(!empty($product_category_id)) { echo $product_category_id; } ?>">
						<table class="data-table table nowrap tablefont ordering_product_table" style="margin: auto;">
                            <thead class="thead-dark">
                                <tr>
                                    <th style="text-align: center; width: 50px;">S.No</th>
                                    <th style="text-align: center;">Product Name</th>
                                    <th style="text-align: center; width: 125px;">Old Price</th>
									<th style="text-align: center; width: 125px;">New Price</th>
                                </tr>
								<?php
									if(!empty($product_list)) {
										foreach($product_list as $key => $data) {
											if(!empty($data['product_id'])) {
								?>
												<tr>
													<td style="text-align: center; width: 50px;"><?php echo $key + 1; ?></td>
													<td>
														<?php
															if(!empty($data['name'])) {
																$data['name'] = $obj->encode_decode('decrypt', $data['name']);
																$data['name'] = str_replace("$", '"', $data['name']);
																$data['name'] = str_replace("'''", '"', $data['name']);
																echo $data['name'];
															}
														?>
														<input type="hidden" name="price_update_product_id[]" class="form-control" value="<?php echo $data['product_id']; ?>">
													</td>
													<td class="product_price" style="text-align: center; width: 100px;">
														<?php if(!empty($data['price'])) { echo number_format($data['price'], 2); } ?>
													</td>
													<td class="new_price" style="text-align: center; width: 100px;"></td>
												</tr>
								<?php				
											}
										}
									}
									else {
								?>
									<tr>
										<td colspan="4" class="text-center">Sorry! No records found</td>
									</tr>
								<?php } ?>
                            </thead>
						</table>	
					</div>
					<div class="col-md-12 pt-3 text-center">
						<button class="btn btn-primary btnwidth submit_button" type="button" onClick="Javascript:UpdateCategoryProductPrice('update_product_price_form');">Update</button>
					</div>
				</div>
				<script type="text/javascript">
					jQuery(document).ready(function(){
						jQuery('form[name="update_product_price_form"]').find('select').select2();
					});    
				</script>
			</form>
<?php			
		}
	}

	if(isset($_POST['product_category_id'])) {
		$product_category_id = ""; $update_value = ""; $update_value_error = ""; $update_option = ""; $update_option_error = "";
		$price_update_product_id = array(); $product_error = "";

		$valid_update = ""; $form_name = "update_product_price_form";
	
        $product_category_id = $_POST['product_category_id'];
		$product_category_id = trim($product_category_id);
		if(empty($product_category_id)) {
			$product_error = "Category ID is missing";
		}

		$update_value = $_POST['update_value'];
		$update_value_error = $valid->valid_price($update_value, "Update Value", 1);
		if(!empty($update_value_error)) {
			$valid_update = $valid->error_display($form_name, "update_value", $update_value_error, 'text');			
		}

		$update_option = $_POST['update_option'];
		$update_option = trim($update_option);
		if(!empty($update_option)) {
			$options = array('+', '-', 'x', '%+', '%-');
			if(!in_array($update_option, $options)) {
				$update_option_error = "Select update option";
			}
		}
		else {
			$update_option_error = "Select update option";
		}
		if(!empty($update_option_error)) {
			if(!empty($valid_update)) {
				$valid_update = $valid_update." ".$valid->error_display($form_name, "update_option", $update_option_error, 'select');
			}
			else {
				$valid_update = $valid->error_display($form_name, "update_option", $update_option_error, 'select');
			}
		}

		$price_update_product_id = $_POST['price_update_product_id'];
		if(!empty($price_update_product_id)) {
			for($p = 0; $p < count($price_update_product_id); $p++) {
				if(empty($price_update_product_id[$p])) {
					$product_error = "Product ID is missing";
				}
			}
		}

		$result = "";

		if(empty($valid_update) && empty($product_error)) {
			if(!empty($product_category_id) && !empty($price_update_product_id)) {
				$success = 0;
				for($i = 0; $i < count($price_update_product_id); $i++) {
					$product_id = "";
					if(!empty($price_update_product_id[$i])) {
						$product_id = $price_update_product_id[$i];
					}
					if(!empty($product_id)) {
						$getUniqueID = "";
						$getUniqueID = $obj->getTableColumnValue($GLOBALS['product_table'], 'product_id', $product_id, 'id');
						if(preg_match("/^\d+$/", $getUniqueID)) {
							$name = "";
							$name = $obj->getTableColumnValue($GLOBALS['product_table'], 'product_id', $product_id, 'name');

							$product_code = "";
							$product_code = $obj->getTableColumnValue($GLOBALS['product_table'], 'product_id', $product_id, 'product_code');

							$action = "";
							if(!empty($name)) {
								$action = "Product Price Updated. Code - ".$obj->encode_decode('decrypt', $product_code)." Name - ".str_replace("$", '"', $obj->encode_decode('decrypt', $name));
							}

							$price = ""; $new_price = "";
							$price = $obj->getTableColumnValue($GLOBALS['product_table'], 'product_id', $product_id, 'price');
							if(preg_match("/^[0-9]+(\\.[0-9]+)?$/", $price)) {
								if(!empty($update_option) && !empty($update_value)) {
									if($update_option == "+") {
										$new_price = $price + $update_value;
									}
									else if($update_option == "-") {
										$new_price = $price - $update_value;
									}
									else if($update_option == "x") {
										$new_price = $price * $update_value;
									}
									else if($update_option == "%+") {
										$discount_value = "";
										$discount_value = ($price * $update_value) / 100;
										if(!empty($discount_value)) {
											$discount_value = number_format($discount_value, 2);
											$discount_value = str_replace(",", "", $discount_value);
											$new_price = $price + $discount_value;
										}
									}
									else if($update_option == "%-") {
										$discount_value = "";
										$discount_value = ($price * $update_value) / 100;
										if(!empty($discount_value)) {
											$discount_value = number_format($discount_value, 2);
											$discount_value = str_replace(",", "", $discount_value);
											$new_price = $price - $discount_value;
										}
									}

									if(!empty($new_price) && preg_match("/^[0-9]+(\\.[0-9]+)?$/", $new_price)) {
										$product_update_id = ""; $columns = array(); $values = array();						
										$columns = array('price');
										$values = array("'".$new_price."'");
										$product_update_id = $obj->UpdateSQL($GLOBALS['product_table'], $getUniqueID, $columns, $values, $action);
										if(preg_match("/^\d+$/", $product_update_id)) {
											$success++;					
										}
									}
								}
							}					
						}
					}
				}
				if(!empty($success) && $success == count($price_update_product_id)) {
					$result = array('number' => '1', 'msg' => 'Updated Successfully');
				}
				else {
					$result = array('number' => '2', 'msg' => 'Some product price are not updated');
				}
			}
		}
		else {
			if(!empty($valid_update)) {
				$result = array('number' => '3', 'msg' => $valid_update);
			}
			else if(!empty($product_error)) {
				$result = array('number' => '2', 'msg' => $product_error);
			}
		}

		if(!empty($result)) {
			$result = json_encode($result);
		}
		echo $result; exit;

	}

	if(isset($_REQUEST['price_change_product_id'])) {
		$price_change_product_id = $_REQUEST['price_change_product_id'];
		$change_price = $_REQUEST['change_price'];
		$change_price = trim(str_replace(",", "", $change_price));
		$change_price = trim($change_price);
		$msg = "";
		if(!empty($price_change_product_id) && !empty($change_price)) {
			if(preg_match("/^[0-9]+(\\.[0-9]+)?$/", $change_price)) {
				$product_unique_id = "";
				$product_unique_id = $obj->getTableColumnValue($GLOBALS['product_table'], 'product_id', $price_change_product_id, 'id');
				if(preg_match("/^\d+$/", $product_unique_id)) {
					$product_code = "";
					$product_code = $obj->getTableColumnValue($GLOBALS['product_table'], 'product_id', $price_change_product_id, 'product_code');

					$name = "";
					$name = $obj->getTableColumnValue($GLOBALS['product_table'], 'product_id', $price_change_product_id, 'name');
				
					$action = "";
					if(!empty($product_code) && !empty($name)) {
						$action = "Product price is changed. Code - ".$obj->encode_decode('decrypt', $product_code)." Name - ".str_replace("$", '"', $obj->encode_decode('decrypt', $name));						
					}
				
					$columns = array(); $values = array();						
					$columns = array('price');
					$values = array("'".$change_price."'");
					$msg = $obj->UpdateSQL($GLOBALS['product_table'], $product_unique_id, $columns, $values, $action);
				}
				else {
					$msg = "Invalid Product";
				}
			}
			else {
				$msg = "Invalid Price";
			}
		}
		echo $msg;
		exit;
	}

	if(isset($_REQUEST['change_product_id'])) {
		$change_product_id = $_REQUEST['change_product_id'];
		$change_product_name = $_REQUEST['change_product_name'];
		$msg = "";
		if(!empty($change_product_id) && !empty($change_product_name)) {
			$change_product_name = str_replace("AND_SYMBOL", "&", $change_product_name);
			// if(preg_match("/^[a-zA-Z]+[a-zA-Z0-9._]+$/", $change_product_name)) {
				$product_unique_id = "";
				$product_unique_id = $obj->getTableColumnValue($GLOBALS['product_table'], 'product_id', $change_product_id, 'id');
				if(preg_match("/^\d+$/", $product_unique_id)) {
					$product_code = "";
					$product_code = $obj->getTableColumnValue($GLOBALS['product_table'], 'product_id', $change_product_id, 'product_code');

					$name = "";
					$name = $obj->getTableColumnValue($GLOBALS['product_table'], 'product_id', $change_product_id, 'name');
				
					$action = "";
					if(!empty($product_code) && !empty($name)) {
						$action = "Product price is changed. Code - ".$obj->encode_decode('decrypt', $product_code)." Name - ".str_replace("$", '"', $obj->encode_decode('decrypt', $name));						
					}
					$change_product_name = $obj->encode_decode('encrypt',$change_product_name);
					$columns = array(); $values = array();						
					$columns = array('name');
					$values = array("'".$change_product_name."'");
					$msg = $obj->UpdateSQL($GLOBALS['product_table'], $product_unique_id, $columns, $values, $action);
				}
				else {
					$msg = "Invalid Product";
				}
			// }
			// else {
			// 	$msg = "Invalid Product";
			// }
		}
		echo $msg;
		exit;
	}

	if(isset($_REQUEST['show_hide_product_id'])) {
		$show_hide_product_id = $_REQUEST['show_hide_product_id'];
		$show_frontend = $_REQUEST['show_frontend'];
		$msg = "";
		if(!empty($show_hide_product_id)) {
			$product_unique_id = "";
			$product_unique_id = $obj->getTableColumnValue($GLOBALS['product_table'], 'product_id', $show_hide_product_id, 'id');
            if(preg_match("/^\d+$/", $product_unique_id)) {
                $product_code = "";
                $product_code = $obj->getTableColumnValue($GLOBALS['product_table'], 'product_id', $show_hide_product_id, 'product_code');

				$name = "";
                $name = $obj->getTableColumnValue($GLOBALS['product_table'], 'product_id', $show_hide_product_id, 'name');
            
                $action = "";
                if(!empty($name)) {
					if(!empty($show_frontend)) {
						$action = "Product Show in Frontend. Change to OFF. Code - ".$obj->encode_decode('decrypt', $product_code)." Name - ".str_replace("$", '"', $obj->encode_decode('decrypt', $name));
					}
                    else {
						$action = "Product Show in Frontend. Change to ON. Code - ".$obj->encode_decode('decrypt', $product_code)." Name - ".str_replace("$", '"', $obj->encode_decode('decrypt', $name));
					}
                }
            
                $columns = array(); $values = array();						
                $columns = array('show_frontend');
                $values = array("'".$show_frontend."'");
                $msg = $obj->UpdateSQL($GLOBALS['product_table'], $product_unique_id, $columns, $values, $action);
            }
		}
		echo $msg;
		exit;
	}
	
	if(isset($_REQUEST['delete_product_id'])) {
		$delete_product_id = $_REQUEST['delete_product_id'];
		$msg = "";
		if(!empty($delete_product_id)) {	
			$product_unique_id = "";
			$product_unique_id = $obj->getTableColumnValue($GLOBALS['product_table'], 'product_id', $delete_product_id, 'id');
            if(preg_match("/^\d+$/", $product_unique_id)) {
                $product_code = "";
                $product_code = $obj->getTableColumnValue($GLOBALS['product_table'], 'product_id', $delete_product_id, 'product_code');

				$name = "";
                $name = $obj->getTableColumnValue($GLOBALS['product_table'], 'product_id', $delete_product_id, 'name');
            
                $action = "";
                if(!empty($name)) {
                    $action = "Product Deleted. Code - ".$obj->encode_decode('decrypt', $product_code)." Name - ".str_replace("$", '"', $obj->encode_decode('decrypt', $name));
                }
            
                $columns = array(); $values = array();						
                $columns = array('deleted');
                $values = array("'1'");
                $msg = $obj->UpdateSQL($GLOBALS['product_table'], $product_unique_id, $columns, $values, $action);
            }
		}
		echo $msg;
		exit;	
	}
?>