<?php

    include("../include.php");
    include("../include/number2words.php");

    $view_receipt_id = "";
    if(isset($_REQUEST['view_receipt_id'])) {
        $view_receipt_id = $_REQUEST['view_receipt_id'];
    }
    else {
        header("Location: ../receipt.php");
        exit;
    }

    if(!empty($view_receipt_id)) {
        $view_receipt_id = $_REQUEST['view_receipt_id'];

        $receipt_date = date("d-m-Y"); $payment_mode = ""; $narration = ""; $receipter_details = ""; $due_count = 0; $pending_due_count = 0;

		$customer_list = array();
		$customer_list = $obj->getTableRecords($GLOBALS['customer_table'], '','');

        $customer_chit_details = "";
        if(!empty($view_receipt_id)) {
            $receipt_list = array(); $transaction_id = ""; $total_amount = 0; $penalty_amount = 0; $amount = 0;
			$receipt_list = $obj->getTableRecords($GLOBALS['receipt_table'], 'receipt_id', $view_receipt_id);
            if(!empty($receipt_list)) {
                foreach($receipt_list as $data) {
                    if(!empty($data['customer_id'])) {
                        $customer_id = $data['customer_id'];
					}
                    if(!empty($data['transaction_id']) && $data['transaction_id'] != $GLOBALS['null_value']) {
                        $transaction_id = $obj->encode_decode('decrypt', $data['transaction_id']);
					}
                    if(!empty($data['agent_id'])) {
                        $agent_id = $data['agent_id'];
					}
					if(!empty($data['amount'])) {
                        $amount = $data['amount'];
					}
                    if(!empty($data['total_amount'])) {
                        $total_amount = $data['total_amount'];
					}
                    if(!empty($data['penalty_amount'])) {
                        $penalty_amount = $data['penalty_amount'];
					}
					if(!empty($data['payment_mode'])) {
                        $payment_mode = $obj->encode_decode('decrypt', $data['payment_mode']);
					}
					if(!empty($data['narration'])) {
                        $narration = $obj->encode_decode('decrypt', $data['narration']);
                    }
                    if(!empty($data['receipt_date'])) {
                        $receipt_date = $data['receipt_date'];
                    }
                    if(!empty($data['receipt_unique_number'])) {
                        $receipt_unique_number = $obj->encode_decode('decrypt', $data['receipt_unique_number']);
                    }
                    if(!empty($data['customer_chit_details'])) {
                        $customer_chit_details = $obj->encode_decode('decrypt', $data['customer_chit_details']);
                        $customer_chit_details = str_replace("<br>"," ",$customer_chit_details);
                    }
                    if(!empty($data['receipter_details'])) {
                        $receipter_details = $obj->encode_decode('decrypt', $data['receipter_details']);
                    }
                    if(!empty($data['due_count'])) {
                        $due_count = $data['due_count'];
                    }
                    if(!empty($data['pending_due_count'])) {
                        $pending_due_count = $data['pending_due_count'];
                    }
                }
            }
		}
    }

    require_once('../fpdf/fpdf.php');
    $pdf = new FPDF('L','mm','A5');
	$pdf->AliasNbPages(); 
	$pdf->AddPage();
	$pdf->SetAutoPageBreak(false);
	$pdf->SetTitle('Receipt');
    $pdf->SetFont('Arial','B',10);
	$pdf->SetY(5);

    $company_name = "";
    $company_name = $obj->getTableColumnValue($GLOBALS['company_table'], 'id', '1', 'name');

    $pdf->Cell(0,5,$obj->encode_decode('decrypt',$company_name),1,1,'C',0);
    $pdf->Cell(0,5,'Receipt - '.$customer_chit_details,1,1,'C',0);
    $pdf->SetFont('Arial','B',9);
    $y=$pdf->GetY();
    $pdf->Cell(0,5,'',1,1,'C',0);
    $pdf->SetY($y);
    $pdf->Cell(0,5,'Date : '.date('d-m-Y',strtotime($receipt_date)),0,0,'L',0);
    $pdf->Cell(0,5,'Receipt Number : '.$receipt_unique_number,0,1,'R',0);
    $pdf->SetFont('Arial','B',8);
    $y = $pdf->GetY();
    $pdf->Cell(0,2,'',0,1,'L',0);
    $pdf->Cell(0,5,'To',0,1,'L',0);
    
    $pdf->SetX(15);
    $pdf->SetFont('Arial','',8);
    if(!empty($receipter_details)) {
        $receipter_details = explode("<br>", $receipter_details);
        for($i = 0; $i < count($receipter_details); $i++) {
            if(!empty($receipter_details[$i])) {
                $pdf->SetX(15);
                $pdf->Cell(0,5,$receipter_details[$i],0,1,'L',0);
            }
        }
    }

    $pdf->Cell(0,10,'',0,1,'L',0);

    $y1 = $pdf->GetY();

    $pdf->SetY($y);
    $pdf->Cell(0,$y1-$y,'',1,1,'L',0);

    $y = $pdf -> GetY();
    $pdf->SetFont('Arial','B',8);
    $pdf->Cell(0,10,'Amount In Words  ',0,0,'L',0);

    $pdf->SetX(40);
    $pdf->Cell(0,10,':     '.getIndianCurrency($total_amount),0,1,'L',0);

    $pdf->SetY($y);
    $pdf->Cell(0,10,'',1,1,'L',0);

    $y = $pdf -> GetY();
    $pdf->SetFont('Arial','B',8);
    $pdf->Cell(0,10,'Amount',0,0,'L',0);

    $pdf->SetX(40);
    $pdf->Cell(0,10,':     Rs. '.number_format($total_amount,2),0,0,'L',0);

    $pdf->SetX(10);
    $pdf->Cell(0,10,'Payment Type : '.$payment_mode,0,1,'R',0);

    $pdf->SetY($y);
    $pdf->Cell(0,10,'',1,1,'L',0);

    $pdf->Cell(0,10,'Due Count',0,0,'L',0);
    $pdf->SetX(40);
    $pdf->Cell(0,10,':    '.$due_count,0,0,'L',0);
    $pdf->SetX(10);
    $pdf->Cell(0,10,'Pending Due : '.$pending_due_count,1,1,'R',0);

    $y = $pdf -> GetY();

    $pdf->SetY($y);
    
    $pdf->SetFont('Arial','B',8);
    $pdf->Cell(0,10,'Remarks  ',0,0,'L',0);
    
    $display = "";
    if(!empty($penalty_amount)){
        $display = "Amount : Rs. ".number_format($amount,2).'   Penalty : Rs. '.number_format($penalty_amount,2);
    }
    if(!empty($transaction_id)){
        $display .= "Transaction ID : ".$transaction_id;
    }
    $pdf->SetX(40);
    $pdf->Cell(0,10,':     '.$display,0,1,'L',0);

    $pdf->SetY($y);
    $pdf->Cell(0,10,'',1,1,'L',0);

    $y = $pdf -> GetY();
    $pdf->SetFont('Arial','B',8);
    $pdf->Cell(0,30,'(Verified) ',0,0,'L',0);
    $pdf->Cell(0,30,'Signature  ',0,0,'R',0);

    $pdf->SetY($y);
    $pdf->Cell(0,30,'',1,1,'L',0);

    $pdf->Output();
?>