<?php
	include("include.php");
	
	if(isset($_POST['page_number'])) {
		$page_number = $_POST['page_number'];
		$page_limit = $_POST['page_limit'];
		$page_title = $_POST['page_title'];

		$search_text = "";
		if(isset($_POST['search_text'])) {
			$search_text = $_POST['search_text'];
		}

		$total_records_list = array();
		$total_records_list = $obj->getTableRecords($GLOBALS['enquiry_customer_table'], '', '');

		if(!empty($search_text)) {
			$search_text = strtolower($search_text);
			$list = array();
			if(!empty($total_records_list)) {
				foreach($total_records_list as $val) {
					if(strpos(strtolower($obj->encode_decode('decrypt', $val['name'])), $search_text) !== false || strpos(strtolower($obj->encode_decode('decrypt', $val['mobile_number'])), $search_text) !== false) {
						$list[] = $val;
					}
				}
			}
			$total_records_list = $list;
		}
		
		$total_pages = 0;
		if(!empty($total_records_list)) {
			$total_pages = count($total_records_list);
		}
		
		$page_start = 0; $page_end = 0;
		if(!empty($page_number) && !empty($page_limit) && !empty($total_pages)) {
			if($total_pages > $page_limit) {
				if($page_number) {
					$page_start = ($page_number - 1) * $page_limit;
					$page_end = $page_start + $page_limit;
				}
			}
			else {
				$page_start = 0;
				$page_end = $page_limit;
			}
		}

		$show_records_list = array();
        if(!empty($total_records_list)) {
            foreach($total_records_list as $key => $val) {
                if($key >= $page_start && $key < $page_end) {
                    $show_records_list[] = $val;
                }
            }
        }
?>
        
		<?php if($total_pages > $page_limit) { ?>
			<div class="pagination_cover mt-3"> 
				<?php
					include("pagination.php");
				?> 
			</div> 
		<?php } ?>

		<table class="table nowrap show_frontend_table">
            <thead>
                <tr>
					<th class="text-center px-2 py-2">S.No</th>
                    <!--<th class="text-center px-2 py-2">Date & Time</th>-->
                    <th class="text-center px-2 py-2">Customer Name</th>
					<th class="text-center px-2 py-2">Mobile Number</th>
					<th class="text-center px-2 py-2">Login</th>
					<th class="text-center px-2 py-2">Action</th>
                </tr>
            </thead>
            <tbody>
                <?php
                    if(!empty($show_records_list)) {
                        foreach($show_records_list as $key => $data) {
                ?>
							<tr>
								<td class="text-center px-2 py-2"><?php echo $key + 1; ?></td>
								<td class="text-center px-2 py-2">
									<?php 
										/*if(!empty($data['created_date_time']) && $data['created_date_time'] != "0000-00-00 00:00:00") { 
											echo date("d-m-Y h:i:s A", strtotime($data['created_date_time'])); 
										}*/ 
									?>
								</td>
								<td class="px-2 py-2">
									<div class="w-100">
										<?php
											if(!empty($data['name'])) {
												$data['name'] = $obj->encode_decode('decrypt', $data['name']);
												echo $data['name'];
											}
										?>
									</div>
									
									<?php
										if(!empty($data['creator_name'])) {
											$data['creator_name'] = $obj->encode_decode('decrypt', $data['creator_name']);
									?>
											<small><?php echo "creator : ".$data['creator_name']; ?></small>
									<?php		
										}
									?>
								</td>
								<td class="text-center px-2 py-2">
                                    <?php
                                        if(!empty($data['mobile_number'])) {
                                            $data['mobile_number'] = $obj->encode_decode('decrypt', $data['mobile_number']);
                                            echo $data['mobile_number'];
                                        }
                                    ?>
								</td>
								<td class="text-center px-2 py-2">
									<div class="w-100 mb-2" style="display: inline-block;">
										<div class="custom-control custom-switch">
											<input type="checkbox" class="custom-control-input" id="login_<?php if(!empty($data['customer_id'])) { echo $data['customer_id']; } ?>" <?php if(empty($data['login'])) { ?> checked <?php } ?> >
											<label class="custom-control-label" onClick="Javascript:DisableLogin(this, '<?php if(!empty($data['customer_id'])) { echo $data['customer_id']; } ?>');" for="login_<?php if(!empty($data['customer_id'])) { echo $data['customer_id']; } ?>"></label>
										</div>
									</div>
								</td>
								<td class="text-center px-2 py-2">
									<div class="dropdown">
										<a class="btn btn-dark poppins px-3" href="#" role="button" data-toggle="dropdown">
											<i class="fa fa-ellipsis-v text-white"></i>
										</a>
										<div class="dropdown-menu dropdown-menu-right dropdown-menu-icon-list">
											<a class="dropdown-item" href="Javascript:DeleteModalContent('<?php if(!empty($page_title)) { echo $page_title; } ?>', '<?php if(!empty($data['customer_id'])) { echo $data['customer_id']; } ?>');"><i class="fa fa-trash"></i> &ensp; Delete</a>
										</div>
									</div>
								</td>
							</tr>
                <?php
                        }
                    }
                    else {
                ?>
                        <tr>
                            <td colspan="6" class="text-center">Sorry! No records found</td>
                        </tr>
                <?php } ?>
            </tbody>
        </table>
<?php	
	}

	if(isset($_REQUEST['disable_customer_id'])) {
		$disable_customer_id = $_REQUEST['disable_customer_id'];
		$login_option = $_REQUEST['login_option'];
		$msg = "";
		if(!empty($disable_customer_id)) {
			$unique_id = "";
			$unique_id = $obj->getTableColumnValue($GLOBALS['enquiry_customer_table'], 'customer_id', $disable_customer_id, 'id');
            if(preg_match("/^\d+$/", $unique_id)) {
                $customer_name = ""; $mobile_number = "";
                $customer_name = $obj->getTableColumnValue($GLOBALS['enquiry_customer_table'], 'customer_id', $disable_customer_id, 'name');
				$mobile_number = $obj->getTableColumnValue($GLOBALS['enquiry_customer_table'], 'customer_id', $disable_customer_id, 'mobile_number');
            
                $action = "";
                if(!empty($customer_name) && !empty($mobile_number)) {
					if(!empty($login_option)) {
						$action = "Login Disabled. Customer Name - ".$obj->encode_decode('decrypt', $customer_name).", Mobile - ".$obj->encode_decode('decrypt', $mobile_number);
					}
                    else {
						$action = "Login Enabled. Customer Name - ".$obj->encode_decode('decrypt', $customer_name).", Mobile - ".$obj->encode_decode('decrypt', $mobile_number);
					}
                }
            
                $columns = array(); $values = array();						
                $columns = array('login');
                $values = array("'".$login_option."'");
                $msg = $obj->UpdateSQL($GLOBALS['enquiry_customer_table'], $unique_id, $columns, $values, $action);
            }
		}
		echo $msg;
		exit;
	}

	if(isset($_REQUEST['delete_enquiry_customer_id'])) {
		$delete_enquiry_customer_id = $_REQUEST['delete_enquiry_customer_id'];
		$msg = "";
		if(!empty($delete_enquiry_customer_id)) {	
			$customer_unique_id = "";
			$customer_unique_id = $obj->getTableColumnValue($GLOBALS['enquiry_customer_table'], 'customer_id', $delete_enquiry_customer_id, 'id');
            if(preg_match("/^\d+$/", $customer_unique_id)) {
                $name = "";
                $name = $obj->getTableColumnValue($GLOBALS['enquiry_customer_table'], 'customer_id', $delete_enquiry_customer_id, 'name');
            
                $action = "";
                if(!empty($name)) {
                    $action = "Category Deleted. Name - ".$obj->encode_decode('decrypt', $name);
                }
            
                $columns = array(); $values = array();						
                $columns = array('deleted');
                $values = array("'1'");
                $msg = $obj->UpdateSQL($GLOBALS['enquiry_customer_table'], $customer_unique_id, $columns, $values, $action);
            }
		}
		echo $msg;
		exit;	
	}
?>