<?php 
include("../include_user_check_and_files.php");
include("../include/number2words.php");
include("../include/billing_functions.php");

$filter_member_id = "";
if(isset($_REQUEST['filter_member_id'])) {
    $filter_member_id = $_REQUEST['filter_member_id'];
}
else {
    header("Location: ../member_report.php");
    exit;
}  

$total_records_list = array();
$total_records_list = $obj->getMemberReportDetails($filter_member_id);

require_once('../fpdf/fpdf.php');
    $pdf = new FPDF('L','mm','A4');
    $pdf->AliasNbPages(); 
    $pdf->AddPage();
    $pdf->SetAutoPageBreak(false);
    $pdf->SetTitle('Member Report');
    $pdf->SetFont('Arial','B',10);
    $pdf->SetY(7);
    $pdf->Cell(0,10,'Member Report',0,1,'C',0);
    $pdf->SetFont('Arial','B',9);

    $pdf->SetX(10);
    $pdf->Cell(10,10,'S.No.',1,0,'C',0);
    $pdf->SetX(20);
    $pdf->Cell(25,10,'Created Date',1,0,'C',0);
    $pdf->SetX(45);
    $pdf->Cell(40,10,'Member Id',1,0,'C',0);
    $pdf->SetX(85);
    $pdf->Cell(45,10,'Member Name',1,0,'C',0);
    $pdf->SetX(130);
    $pdf->Cell(27,10,'Member Number',1,0,'C',0);
    $pdf->SetX(157);
    $pdf->Cell(40,10,'Manager Id',1,0,'C',0);
    $pdf->SetX(197);
    $pdf->Cell(45,10,'Manager Name',1,0,'C',0);
    $pdf->SetX(242);
    $pdf->Cell(27,10,'Manager Number',1,0,'C',0);
    $pdf->setX(269);
    $pdf->Cell(26,10,'Plan Name',1,1,'C',0);
    $pdf->SetFont('Arial','',8);

    $index = 0; $created_date = ""; $member_name = ""; $member_id = ""; $mobile_number = ""; $plan_name = "";
    if(!empty($total_records_list)) {
        $edit_action = $obj->encode_decode('encrypt', 'edit_action');
        $product_count = 0; $quantity = ""; $grand_amount = 0; $grand_quantity = 0;
        foreach($total_records_list as $key => $data) {
            if($pdf->GetY()>250){
                $pdf->AddPage();
                $pdf->SetTitle('Member Report');
                $pdf->SetFont('Arial','B',10);
                $pdf->SetY(7);
                $pdf->Cell(0,10,'Member Report',0,1,'C',0);
                $pdf->SetFont('Arial','B',9);

                $pdf->SetX(10);
                $pdf->Cell(10,10,'S.No.',1,0,'C',0);
                $pdf->SetX(20);
                $pdf->Cell(25,10,'Created Date',1,0,'C',0);
                $pdf->SetX(45);
                $pdf->Cell(40,10,'Member Id',1,0,'C',0);
                $pdf->SetX(85);
                $pdf->Cell(45,10,'Member Name',1,0,'C',0);
                $pdf->SetX(130);
                $pdf->Cell(27,10,'Member Number',1,0,'C',0);
                $pdf->SetX(157);
                $pdf->Cell(40,10,'Manager Id',1,0,'C',0);
                $pdf->SetX(197);
                $pdf->Cell(45,10,'Manager Name',1,0,'C',0);
                $pdf->SetX(242);
                $pdf->Cell(27,10,'Manager Number',1,0,'C',0);
                $pdf->setX(269);
                $pdf->Cell(26,10,'Plan Name',1,1,'C',0);
                $pdf->SetFont('Arial','',8);
            }
            $index = $key + 1; 
            
            if(!empty($index)) {
                $pdf->SetX(10);
                $pdf->Cell(10,10,$index,1,0,'C',0);
            }

            $pdf->setX(20);
            if(!empty($data['created_date_time']) && $data['created_date_time'] != "0000-00-00 00:00:00") { 
                $created_date = date("d-m-Y", strtotime($data['created_date_time'])); 
            } 
            $pdf->Cell(25,10,$created_date,1,0,'C',0);

            $pdf->setX(45);
            if(!empty($data['member_unique_id'])) {
                $member_id = $obj->encode_decode("decrypt", $data['member_unique_id']);
            }
            $pdf->Cell(40,10,$member_id,1,0,'C',0);

            $pdf->SetX(85);
            if(!empty($data['member_name'])) {
                $member_name = $obj->encode_decode("decrypt", $data['member_name']);
            }
            $pdf->Cell(45,10,$member_name,1,0,'C',0);

            $pdf->SetX(130);
            if(!empty($data['mobile_number'])) {
                $mobile_number = $obj->encode_decode("decrypt", $data['mobile_number']);
            }
            $pdf->Cell(27,10,$mobile_number,1,0,'C',0);

            if(!empty($data['manager_id'])) {
                
                $manager_mbno = $obj->getTableColumnValue($GLOBALS['manager_table'], 'manager_unique_id', $data['manager_id'], 'mobile_number');
                $obj->encode_decode("decrypt", $manager_mbno);
                $manager_name = $obj->getTableColumnValue($GLOBALS['manager_table'], 'manager_unique_id', $data['manager_id'], 'manager_name');
            }

            $pdf->SetX(157);
            $pdf->Cell(40,10,$obj->encode_decode("decrypt", $data['manager_id']),1,0,'C',0);
            $pdf->SetX(197);
            $pdf->Cell(45,10,$obj->encode_decode("decrypt", $manager_mbno),1,0,'C',0);
            $pdf->SetX(242);
            $pdf->Cell(27,10,$obj->encode_decode("decrypt", $manager_name),1,0,'C',0);
            $pdf->setX(269); 
            if(!empty($data['plan_id'])) {
                $plan_name = $obj->getTableColumnValue($GLOBALS['plan_table'], 'plan_id', $data['plan_id'], 'plan_name');
                $plan_name = $obj->encode_decode("decrypt", $plan_name);
            }
            $pdf->Cell(26,10,$plan_name,1,1,'C',0);

        }           
            
    }

    $pdf->Output();