<?php

    include("../include_user_check_and_files.php");
    include("../include/number2words.php");
    include("../include/billing_functions.php");

    $view_receipt_id = "";
    if(isset($_REQUEST['view_receipt_id'])) {
        $view_receipt_id = $_REQUEST['view_receipt_id'];
    }
    else {
        header("Location: ../receipt.php");
        exit;
    }

    $receipt_date = date("d-m-Y"); $receipt_type = ""; $narration = ""; $receipt_mode = array(); $total_amount = 0; $amount = array(); $receipt_number = ""; $member_unique_id = ""; $receipt_query = ""; $deleted = 0; $view_type = "";

    if(!empty($view_receipt_id)) {
        $view_receipt_id = $_REQUEST['view_receipt_id'];        

		$member_list = array();
		$member_list = $obj->getTableRecords($GLOBALS['member_table'], '','');

        if(!empty($view_receipt_id)) {
            $receipt_list = array();
			$receipt_list = $obj->getReceiptWholeList($view_receipt_id);
            if(!empty($receipt_list)) {
                foreach($receipt_list as $data) {
                    if(!empty($data['member_id'])) {
                        $member_unique_id = $data['member_id'];
					}
					if(!empty($data['amount'])) {
                        $total_amount = $data['amount'];
					}
                    if(!empty($data['view_type'])) {
                        $view_type = $data['view_type'];
					}
					if(!empty($data['receipt_type'])) {
                        // echo $data['receipt_type'];
                        // echo $obj->encode_decode('decrypt' , $data['receipt_type']);
                        $display = "";
                        $receipt_type = $data['receipt_type'];

                        if($receipt_type == "1"){
                            $display = "Google Pay";
                        }
                        else if($receipt_type == "2"){
                            $display = "Cash";
                        }
                        else if($receipt_type == "3"){
                            $display = "Phone Pay";
                        }
					}
                   
					if(!empty($data['narration'])) {
                        $narration = $obj->encode_decode('decrypt', $data['narration']);
                    }
                    if(!empty($data['receipt_date'])) {
                        $receipt_date = $data['receipt_date'];
                    }
                    if(!empty($data['receipt_number'])) {
                        $receipt_number = $obj->encode_decode('decrypt', $data['receipt_number']);
                    }
                    if(!empty($data['deleted'])) {
                        $deleted = $data['deleted'];
                    } 
                }
            }
		}
    }

    // require_once('../fpdf/fpdf.php');
    require_once('../fpdf/AlphaPDF.php');
    $pdf = new AlphaPDF('L','mm','A5');
	$pdf->AliasNbPages(); 
	$pdf->AddPage();
	$pdf->SetAutoPageBreak(false);
	$pdf->SetTitle('Receipt');
    $pdf->SetFont('Arial','B',10);
	$pdf->SetY(5);

    $company_name = "";
    // $company_name = $obj->getTableColumnValue($GLOBALS['company_table'], 'company_id', $GLOBALS['bill_company_id'], 'name');
    $company_list = $obj->getTableRecords($GLOBALS['company_table'], '', '');
    if(!empty($company_list)) {
        foreach($company_list as $list) {
            $company_name = $list['name'];
        }
    }

    $pdf->SetY(10);
    $pdf->Cell(0,10,$obj->encode_decode('decrypt',$company_name),1,1,'C',0);
    if($deleted == 0) {
        $pdf->Cell(0,10,'Receipt',1,1,'C',0);
    }
    else {
        $pdf->Cell(0,10,'Cancelled Receipt',1,1,'C',0);
    }
    $pdf->SetFont('Arial','B',9);
    $y=$pdf->GetY();
    $pdf->Cell(0,10,'',1,1,'C',0);
    $pdf->SetY($y);
    $pdf->Cell(0,10,'Date : '.date('d-m-Y',strtotime($receipt_date)),0,0,'L',0);
    $pdf->Cell(0,10,'Receipt Number : '.$receipt_number,0,1,'R',0);
    $pdf->SetFont('Arial','B',8);
    $y = $pdf->GetY();
    $pdf->Cell(0,2,'',0,1,'L',0);
    $pdf->Cell(0,5,'To',0,1,'L',0);
    $member_name = ""; $member_city = ""; $member_mobile_no = "";

    if($view_type == 1) {
        $member_name = $obj->getTableColumnValue($GLOBALS['manager_table'], 'manager_unique_id', $member_unique_id, 'manager_name');     
        $member_city = $obj->getTableColumnValue($GLOBALS['manager_table'], 'manager_unique_id', $member_unique_id, 'city'); 
        $member_mobile_no = $obj->getTableColumnValue($GLOBALS['manager_table'], 'manager_unique_id', $member_unique_id, 'mobile_number'); 
    } else {
        $member_name = $obj->getTableColumnValue($GLOBALS['member_table'], 'member_unique_id', $member_unique_id, 'member_name');     
        $member_city = $obj->getTableColumnValue($GLOBALS['member_table'], 'member_unique_id', $member_unique_id, 'city'); 
        $member_mobile_no = $obj->getTableColumnValue($GLOBALS['member_table'], 'member_unique_id', $member_unique_id, 'mobile_number'); 
    }

    $pdf->SetAlpha(0.4);
    if($deleted == 1) {
        
        $pdf->Image('../include/images/upload/cancelled-stamp-1.png',35,30,150,100);
    }

    $pdf->SetAlpha(1);
    $pdf->SetX(15);
    $pdf->SetFont('Arial','',8);
    $pdf->Cell(0,5,$obj -> encode_decode('decrypt',$member_name),0,1,'L',0);
    if(!empty($member_city)) {
        $pdf->SetX(15);
        $pdf->SetFont('Arial','',8);
        $pdf->Cell(0,5,$obj -> encode_decode('decrypt',$member_city),0,1,'L',0);
    }

    $pdf->SetX(15);
    $pdf->SetFont('Arial','',8);
    $pdf->Cell(0,5,$obj -> encode_decode('decrypt',$member_mobile_no),0,1,'L',0);

    $pdf->Cell(0,10,'',0,1,'L',0);

    $y1 = $pdf->GetY();

    $pdf->SetY($y);
    $pdf->Cell(0,$y1-$y,'',1,1,'L',0);

    $y = $pdf -> GetY();
    $pdf->SetFont('Arial','B',8);
    $pdf->Cell(0,10,'Amount In Words  ',0,0,'L',0);

    $pdf->SetX(40);
    $pdf->Cell(0,10,':     '.getIndianCurrency($total_amount). 'Only',0,1,'L',0);

    $pdf->SetY($y);
    $pdf->Cell(0,10,'',1,1,'L',0);

    $y = $pdf -> GetY();
    $pdf->SetFont('Arial','B',8);
    $pdf->Cell(0,10,'Amount',0,0,'L',0);

    $pdf->SetX(40);
    $pdf->Cell(0,10,':     Rs. '.number_format($total_amount,2),0,0,'L',0);

    $pdf->SetX(10);
    $pdf->Cell(0,10,'Payment Type : '.$display,0,1,'R',0);

    $pdf->SetY($y);
    $pdf->Cell(0,10,'',1,1,'L',0);

    $y = $pdf -> GetY();
    $pdf->SetFont('Arial','B',8);
    $pdf->Cell(0,10,'Remarks  ',0,0,'L',0);

    $pdf->SetX(40);
    $pdf->Cell(0,10,':     '.$narration,0,1,'L',0);

    $pdf->SetY($y);
    $pdf->Cell(0,10,'',1,1,'L',0);

    $y = $pdf -> GetY();
    $pdf->SetFont('Arial','B',8);
    $pdf->Cell(0,35,'(Verified) ',0,0,'L',0);
    $pdf->Cell(0,35,'Signature  ',0,0,'R',0);

    $pdf->SetY($y);
    $pdf->Cell(0,35,'',1,1,'L',0);

    $pdf->Output();
?>