<?php 
    include("include_user_check.php");

	$page_title = "Terminate Customer Chit";

    $terminate_customer_chit_list = array();
    $terminate_customer_chit_list = $obj->getTerminateCustomerChitList();
?>
<!DOCTYPE html>
<html lang="en">
<head>
	<title> <?php if(!empty($project_title)) { echo $project_title; } ?> - <?php if(!empty($page_title)) { echo $page_title; } ?> </title>
	<?php include "link_style_script.php"; ?>
</head>
<body>
	<?php include "header.php";  ?>
	<!-- sidebar-wrapper  -->          
	<div class="page-wrapper chiller-theme toggled">
		<main class="page-content">
			<div class="container-fluid px-lg-5">

				<div class="border card-box">
					<div class="card-header">
						<div class="row">
							<div class="col-6"><?php if(!empty($page_title)) { echo $page_title; } ?></div>
							<div class="col-6 text-right">
								<a class="btn btn-success poppins" style="font-size:11px;" href="reports/rpt_customer_chit_terminate.php" target="_blank"> <i class="fa fa-file-pdf-o"></i> &ensp; PDF </a>
							</div>
						</div>
					</div>
					<div class="w-100">
					<?php //print_r($terminate_customer_chit_list); ?>

						<div id="table_listing_records" class="table-responsive poppins">
						<table cellpadding="0" cellspacing="0" class="table" style="width: 1100px;">
							<tr>
								<th class="text-center px-2 py-2" style="width: 25px;">S.No</th>
								<th class="text-center px-2 py-2" style="width: 150px;">Agent</th>
								<th class="text-center px-2 py-2" style="width: 150px;">Customer</th>
								<th class="text-center px-2 py-2" style="width: 150px;">Chit ID</th>
								<th class="text-center px-2 py-2" style="width: 150px;">Chit Name</th>
								<th class="text-center px-2 py-2" style="width: 125px;">Wallet</th>
								<th class="text-center px-2 py-2" style="width: 125px;">Last Paid Date</th>
								<th class="text-center px-2 py-2" style="width: 125px;">Cancel Date</th>
								<th class="text-center px-2 py-2" style="width: 100px;">No.of Days</th>
							</tr>
							<?php
								if(!empty($terminate_customer_chit_list)) {
									foreach($terminate_customer_chit_list as $key => $data) {
										if(!empty($data['customer_chit_id'])) {
											$index = $key + 1;

											$numOfDays = 0;
											if(!empty($data['last_paid_date']) && $data['last_paid_date'] != "0000-00-00") {
												if(!empty($data['cancel_date']) && $data['cancel_date'] != "0000-00-00") {
													$dateDiff   = strtotime($data['cancel_date']) - strtotime($data['last_paid_date']);							
													$numOfDays  = $dateDiff / 86400;
												}
											}
							?>
											<tr>
												<td class="text-center px-2 py-2" style="width: 75px;"><?php echo $index; ?></td>
												<td class="text-center px-2 py-2">
													<?php
														if(!empty($data['agent_details']) && $data['agent_details'] != $GLOBALS['null_value']) {
															$data['agent_details'] = $obj->encode_decode('decrypt', $data['agent_details']);
															echo $data['agent_details'];
														}
													?>
												</td>
												<td class="text-center px-2 py-2">
													<?php
														if(!empty($data['customer_details']) && $data['customer_details'] != $GLOBALS['null_value']) {
															$data['customer_details'] = $obj->encode_decode('decrypt', $data['customer_details']);
															$data['customer_details'] = str_replace("$$$", "<br>", $data['customer_details']);
															echo $data['customer_details'];
														}
													?>
												</td>
												<td class="text-center px-2 py-2">
													<?php
														if(!empty($data['customer_chit_unique_number'])) {
															$data['customer_chit_unique_number'] = $obj->encode_decode('decrypt', $data['customer_chit_unique_number']);
															echo $data['customer_chit_unique_number'];
														}
													?>
												</td>
												<td class="px-2 py-2">
													<div class="w-100">
														<?php
															if(!empty($data['chit_details'])) {
																$data['chit_details'] = $obj->encode_decode('decrypt', $data['chit_details']);
																echo $data['chit_details'];
															}
														?>
													</div>
												</td>
												<td class="text-center px-2 py-2">
													<?php if(!empty($data['amount_to_use_order_customer'])) { ?>
													<div class="w-100">
														<?php
															$data['amount_to_use_order_customer'] = $obj->truncate_number($data['amount_to_use_order_customer'], 2);
															echo $data['amount_to_use_order_customer'];
														?>
													</div>
													<?php } else if(!empty($data['amount_to_use_order_agent'])) { ?>
													<div class="w-100">
														<?php
															$data['amount_to_use_order_agent'] = $obj->truncate_number($data['amount_to_use_order_agent'], 2);
															echo $data['amount_to_use_order_agent'];
														?>
													</div>
													<?php } ?>
												</td>
												<td class="text-center px-2 py-2">
													<?php
														if(!empty($data['last_paid_date']) && $data['last_paid_date'] != "0000-00-00") {
															echo date("d-m-Y", strtotime($data['last_paid_date']));
														}
													?>
												</td>
												<td class="text-center px-2 py-2">
													<?php
														if(!empty($data['cancel_date']) && $data['cancel_date'] != "0000-00-00") {
															echo date("d-m-Y", strtotime($data['cancel_date']));
														}
													?>
												</td>
												<td class="text-center px-2 py-2">
													<?php if(!empty($numOfDays)) { echo $numOfDays; } ?>
												</td>
											</tr>
							<?php
										}
									}
								}
								else {
							?>
									<tr>
										<td colspan="8" class="text-center px-2 py-2">Sorry! No Chits Found</td>
									</tr>
							<?php } ?>
						</table>
						</div>

					</div>

				</div>
				
			</div>
		</main>
	</div>  
	<!-- page-wrapper -->

	<?php include "footer.php"; ?>

	<script>
		jQuery(document).ready(function(){
			jQuery("#terminate_customer_chitsactive").addClass("active");			
		});		
	</script>
	
    </body>
</html>