<?php 
    include("include_user_check.php");

	$page_title = "Dashboard";

	$current_year_diwali_date = "";	
    $settings_list = array();
    $settings_list = $obj->getTableRecords($GLOBALS['settings_table'], '', '');
    if(!empty($settings_list)) {
        foreach($settings_list as $data) {
            if( (!empty($data['name']) && $data['name'] == "current_year_diwali_date") && (!empty($data['value']) && $data['value'] != '0000-00-00') ) {
                $current_year_diwali_date = $data['value'];
            }
        }
    }

	$recent_receipt_list = array();
	$recent_receipt_list = $obj->getRecentReceiptList();

	$pending_due_customer_list = array();
	$pending_due_customer_list = $obj->getPandingDueCustomerList();
?>
<!DOCTYPE html>
<html lang="en">
<head>
	<title> <?php if(!empty($project_title)) { echo $project_title; } ?> - <?php if(!empty($page_title)) { echo $page_title; } ?> </title>
	<?php include "link_style_script.php"; ?>

	<script type="text/javascript" src="include/js/common.js"></script>
</head>
<body>
	<?php include "header.php";  ?>
	<!-- sidebar-wrapper  -->          
	<div class="page-wrapper chiller-theme toggled">
		<main class="page-content">
			<div class="container-fluid px-lg-5">
				<div class="w-100">

					<div class="row">
						<?php if(empty($current_year_diwali_date)) { ?>
							<div class="col-xl-4">
								<span class="glow">Please select upcoming diwali date</span>
							</div>
						<?php } ?>
						<div class="col-xl-8"> 
							<div class="border card-box form-group">
								<div class="card-header">Recent Payments</div>
								<div id="dashboard_recent_receipts_cover" class="card-body py-3 table-responsive">
									<table class="table">
										<thead class="thead-dark">
											<tr>
												<th class="text-center px-2 py-2" style="width: 25px;">S.no</th>
												<th class="text-center px-2 py-2" style="width: 225px;">Agent / Customer</th>
												<th class="text-center px-2 py-2">Chit</th>
												<th class="text-center px-2 py-2" style="width: 125px;">Receipt No & Date</th>
												<th class="text-center px-2 py-2" style="width: 125px;">Amount<th>
											</tr>
										</thead>
										<tbody>
											<?php
												$index = 1;
												if(!empty($recent_receipt_list)) {
													foreach($recent_receipt_list as $data) {
														if(!empty($data['receipt_id'])) {
											?>
															<tr>
																<td class="text-center px-2 py-2"><?php if(!empty($index)) { echo $index; } ?></td>
																<td class="text-center px-2 py-2">
																	<?php
																		if(!empty($data['customer_details']) && $data['customer_details'] != $GLOBALS['null_value']) {
																			$data['customer_details'] = $obj->encode_decode('decrypt', $data['customer_details']);
																			$data['customer_details'] = str_Replace("$$$", "<br>", $data['customer_details']);
																			echo $data['customer_details'];
																		}
																		else if(!empty($data['agent_details']) && $data['agent_details'] != $GLOBALS['null_value']) {
																			$data['agent_details'] = $obj->encode_decode('decrypt', $data['agent_details']);
																			echo $data['agent_details'];
																		}
																	?>
																</td>
																<td class="text-center px-2 py-2">
																	<?php
																		if(!empty($data['customer_chit_details'])) {
																			$data['customer_chit_details'] = $obj->encode_decode('decrypt', $data['customer_chit_details']);
																			echo $data['customer_chit_details'];
																		}
																	?>
																</td>
																<td class="text-center px-2 py-2">
																	<?php 
																		if(!empty($data['receipt_unique_number'])) {
																			$data['receipt_unique_number'] = $obj->encode_decode('decrypt', $data['receipt_unique_number']);
																			echo $data['receipt_unique_number'];
																			
																			if(!empty($data['receipt_date']) && $data['receipt_date'] != "0000-00-00") { 
																				echo "<br>".date("d-m-Y", strtotime($data['receipt_date'])); 
																			} 
																		}
																	?>
																</td>
																<td class="text-center px-2 py-2">
																	<?php
																		if(!empty($data['amount'])) {
																			$data['amount'] = $obj->truncate_number($data['amount'], 2);
																			echo $data['amount'];
																		}
																	?>
																<td>
															</tr>
											<?php
															$index++;
														}
													}
												}
												else {
											?>
													<tr>
														<td colspan="5" class="text-center">Sorry! No Receipts Found</td>
													</tr>
											<?php
												}
											?>
										</tbody>
									</table>	
								</div>
							</div>	
						</div>
						<div class="col-12">
							<div class="border card-box form-group">
								<div class="card-header">Pending Due</div>
								<div id="dashboard_pending_due_cover" class="card-body py-3 table-responsive">
									<table class="table">
										<thead class="thead-dark">
											<tr>
												<th class="text-center px-2 py-2" style="width: 50px;">S.no</th>
												<th class="text-center px-2 py-2" style="width: 225px;">Agent</th>
												<th class="text-center px-2 py-2" style="width: 225px;">Customer</th>
												<th class="text-center px-2 py-2">Chit</th>
												<th class="text-center px-2 py-2" style="width: 125px;">Last Paid Date</th>
												<th class="text-center px-2 py-2" style="width: 125px;">Next Due Date</th>
												<th class="text-center px-2 py-2" style="width: 50px;">Days<th>
											</tr>
										</thead>
										<tbody>
											<?php
												$index = 1;
												if(!empty($pending_due_customer_list)) {
													foreach($pending_due_customer_list as $data) {
														if(!empty($data['customer_chit_id'])) {

															$target_date = date('Y-m-d'); $date1 = ""; $total_diff = "";
															if(!empty($data['next_due_date']) && $data['next_due_date'] != "0000-00-00") { 
																$date2 = date_create($data['next_due_date']); 
																$date1 = date_create($target_date);
																$diff = date_diff($date2, $date1);
																$total_diff = $diff->format("%R%a");
															}
															if($total_diff > 0) {
											?>
															<tr>
																<td class="text-center px-2 py-2"> <?php if(!empty($index)) { echo $index; } ?> </td>
																<td class="text-center px-2 py-2">
																	<?php
																		if(!empty($data['agent_details']) && $data['agent_details'] != $GLOBALS['null_value']) {
																			$data['agent_details'] = $obj->encode_decode('decrypt', $data['agent_details']);
																			echo $data['agent_details'];
																		}
																	?>
																</td>
																<td class="text-center px-2 py-2">
																	<?php
																		if(!empty($data['customer_name']) && $data['customer_name'] != $GLOBALS['null_value']) {
																			$data['customer_name'] = $obj->encode_decode('decrypt', $data['customer_name']);
																			echo $data['customer_name'];
																			if(!empty($data['customer_mobile_number'])) {
																				$data['customer_mobile_number'] = $obj->encode_decode('decrypt', $data['customer_mobile_number']);
																				echo " (".$data['customer_mobile_number'].")";
																			}
																		}
																	?>
																</td>
																<td class="text-center px-2 py-2">
																	<?php
																		if(!empty($data['customer_chit_unique_number'])) {
																			$data['customer_chit_unique_number'] = $obj->encode_decode('decrypt', $data['customer_chit_unique_number']);
																			echo $data['customer_chit_unique_number'];
																			if(!empty($data['chit_details'])) {
																				$data['chit_details'] = $obj->encode_decode('decrypt', $data['chit_details']);
																				echo "<br>".$data['chit_details'];
																			}
																		}
																	?>
																</td>
																<td class="text-center px-2 py-2">
																	<?php 
																		if(!empty($data['last_paid_date']) && $data['last_paid_date'] != "0000-00-00") { 
																			echo date("d-m-Y", strtotime($data['last_paid_date'])); 
																		} 
																	?>
																</td>
																<td class="text-center px-2 py-2">
																	<?php 
																		if(!empty($data['next_due_date']) && $data['next_due_date'] != "0000-00-00") { 
																			echo date("d-m-Y", strtotime($data['next_due_date'])); 
																		} 
																	?>
																</td>
																<td class="text-center px-2 py-2">
																	<?php echo $total_diff; ?>
																</td>
															</tr>
											<?php
																$index++;
															}
														}
													}
												}
												else {
											?>
													<tr>
														<td colspan="7" class="text-center">Sorry! No Records Found</td>
													</tr>
											<?php
												}
											?>
										</tbody>
									</table>	
								</div>
							</div>	
						</div>
					</div>

				</div>
			</div>
		</main>
	</div>  
	<!-- page-wrapper -->

	<?php include "footer.php"; ?>

	<script>
		jQuery(document).ready(function(){
			jQuery("#dashboardactive").addClass("active");			
		});		
	</script>

	<script type="text/javascript" src="include/js/bootstrap-datepicker.min.js"></script>
	<script type="text/javascript">
		jQuery(document).ready(function(){
			if(jQuery('.date_field').length > 0) {
				jQuery('.date_field').datepicker({
					format: "dd-mm-yyyy",
					autoclose: true
				});
			}
		});  
	</script>
	
    </body>
</html>