<?php
    class Agent_Functions extends User_Functions {
        // get agent allow chit list
		public function getAgentAllowChitList($agent_id) {
            $select_query = ""; $list = array(); $current_date = date("Y-m-d");

            if(!empty($agent_id)) {
                $chit_ids = "";
                $chit_ids = $this->getTableColumnValue($GLOBALS['agent_table'], 'agent_id', $agent_id, 'chit_id');
                if(!empty($chit_ids)) {
                    $where = "FIND_IN_SET(chit_id, '".$chit_ids."')";
                }
            }
            else {
                $where = "allow_agent = '1'";
                if(!empty($current_date)) {
                    if(!empty($where)) {
                        $where = $where." AND '".$current_date."' <= DATE(end_date)";
                    }
                    else {
                        $where = "'".$current_date."' <= DATE(end_date)";
                    }
                }
            }

            if(!empty($where)) {
                $select_query = "SELECT * FROM ".$GLOBALS['chit_table']." WHERE ".$where." AND deleted = '0' ORDER BY id ASC";
            }
            if(!empty($select_query)) {
                $list = $this->getQueryRecords($GLOBALS['chit_table'], $select_query);
            }
			return $list;
        }

        // get chit list by agent
		public function getChitlistByAgent($agent_id) {
            $select_query = ""; $list = array(); $where = "";
            if(!empty($agent_id)) {
                $where = "agent_id = '".$agent_id."' AND customer_id = '".$GLOBALS['null_value']."'";
            }
            if(!empty($where)) {
                $select_query = "SELECT * FROM ".$GLOBALS['customer_chit_table']." WHERE ".$where." AND completed_date = '0000-00-00' 
                                    AND admin_approval = '1' AND cancelled = '0' AND deleted = '0' ORDER BY id DESC";
            }
            if(!empty($select_query)) {
                $list = $this->getQueryRecords($GLOBALS['customer_chit_table'], $select_query);
            }
			return $list;
        }

        // get agent customer chit list by agent
		public function getAgentCustomerChitlist($agent_id) {
            $select_query = ""; $list = array(); $where = "";
            if(!empty($agent_id)) {
                $where = "agent_id = '".$agent_id."' AND customer_id != '".$GLOBALS['null_value']."'";
            }
            if(!empty($where)) {
                $select_query = "SELECT * FROM ".$GLOBALS['customer_chit_table']." WHERE ".$where." AND completed_date = '0000-00-00' 
                                    AND admin_approval = '1' AND cancelled = '0' AND deleted = '0' ORDER BY id DESC";
            }
            if(!empty($select_query)) {
                $list = $this->getQueryRecords($GLOBALS['customer_chit_table'], $select_query);
            }
			return $list;
        }

        // update agent wallet
		public function UpdateAgentWallet($agent_id) {
            $update_id = 0; $fund_wallet = 0; $commission_wallet = 0; $merge_wallet = 0; $order_fund_wallet = 0; $order_commission_wallet = 0; $order_merge_wallet = 0;
            $where = ""; $select_query = ""; $list = array();

            if(!empty($agent_id)) {

                // commission
                $select_query = "SELECT customer_chit_id, payable_amount, maturity_value FROM ".$GLOBALS['customer_chit_table']." WHERE agent_id = '".$agent_id."' 
                                    AND customer_id != '".$GLOBALS['null_value']."' AND cancelled = '0' AND admin_approval = '1' AND cancelled = '0' AND deleted = '0'";
                $list = $this->getQueryRecords($GLOBALS['receipt_table'], $select_query);
                if(!empty($list)) {
                    foreach($list as $data) {
                        $customer_chit_id = ""; $payable_amount = 0; $maturity_value = 0;
                        if(!empty($data['customer_chit_id'])) {
                            $customer_chit_id = $data['customer_chit_id'];

                            if(!empty($data['payable_amount'])) {
                                $payable_amount = $data['payable_amount'];
                            }

                            if(!empty($data['maturity_value'])) {
                                $maturity_value = $data['maturity_value'];
                            }

                            $receipt_amount = 0; $order_amount = 0;

                            $select_query = "SELECT SUM(agent_commission) as receipt_amount FROM ".$GLOBALS['receipt_table']." WHERE agent_id = '".$agent_id."' 
                                                AND customer_id != '".$GLOBALS['null_value']."' AND customer_chit_id = '".$customer_chit_id."' AND 
                                                admin_approval = '1' AND deleted = '0' GROUP BY agent_id, customer_chit_id";
                            $list = $this->getQueryRecords($GLOBALS['receipt_table'], $select_query);
                            if(!empty($list)) {
                                foreach($list as $data) {
                                    if(!empty($data['receipt_amount'])) {
                                        $receipt_amount = $data['receipt_amount'];
                                    }
                                }
                            }

                           $select_query = "SELECT o.customer_chit_ids,
                                                (SELECT SUM(amount) FROM ".$GLOBALS['order_chit_table']." as ot 
                                                WHERE ot.customer_chit_id = '".$customer_chit_id."' 
                                                GROUP BY customer_chit_id) as order_amount 
                                                FROM ".$GLOBALS['order_table']." as o 
                                                WHERE 
                                                FIND_IN_SET('".$customer_chit_id."', o.customer_chit_ids) 
                                                AND o.confirmed = '1' AND o.deleted = '0'";
                            $list = $this->getQueryRecords($GLOBALS['order_table'], $select_query);
                            if(!empty($list)) {
                                foreach($list as $data) {
                                    if(!empty($data['order_amount'])) {
                                        $order_amount = $data['order_amount'];
                                    }
                                }
                            }

                            $balance_amount = 0;
                            if(!empty($receipt_amount)) {
                                $commission_wallet = $commission_wallet + $receipt_amount;
                                $balance_amount = $receipt_amount;
                            }
                            if(!empty($order_amount)) {
                                $order_commission_wallet = $order_commission_wallet + $order_amount;

                                $balance_amount = $balance_amount - $order_amount;
                                if($balance_amount < 0) {
                                    $balance_amount = 0;
                                }
                            }

                            $customer_chit_unique_id = "";
                            $customer_chit_unique_id = $this->getTableColumnValue($GLOBALS['customer_chit_table'], 'customer_chit_id', $customer_chit_id, 'id');
                            if(!empty($customer_chit_unique_id) && preg_match("/^\d+$/", $customer_chit_unique_id)) {
                                $columns = array(); $values = array();
                                $columns = array('commission', 'amount_to_use_order_agent');
                                $values = array("'".$receipt_amount."'", "'".$balance_amount."'");
                                $update_id = $this->UpdateSQL($GLOBALS['customer_chit_table'], $customer_chit_unique_id, $columns, $values, '');
                            }
                        }
                    }
                }

                // fund
                $select_query = "SELECT customer_chit_id, payable_amount, maturity_value FROM ".$GLOBALS['customer_chit_table']."  WHERE agent_id = '".$agent_id."'
                                    AND customer_id = '".$GLOBALS['null_value']."' AND cancelled = '0' AND admin_approval = '1' AND deleted = '0'";
                $list = $this->getQueryRecords($GLOBALS['receipt_table'], $select_query);
                if(!empty($list)) {
                    foreach($list as $data) {
                        $customer_chit_id = ""; $payable_amount = 0; $maturity_value = 0;
                        if(!empty($data['customer_chit_id'])) {
                            $customer_chit_id = $data['customer_chit_id'];

                            if(!empty($data['payable_amount'])) {
                                $payable_amount = $data['payable_amount'];
                            }

                            if(!empty($data['maturity_value'])) {
                                $maturity_value = $data['maturity_value'];
                            }

                            $receipt_amount = 0; $order_amount = 0;

                            $select_query = "SELECT SUM(amount) as receipt_amount FROM ".$GLOBALS['receipt_table']." WHERE agent_id = '".$agent_id."' 
                                                AND customer_id = '".$GLOBALS['null_value']."' AND customer_chit_id = '".$customer_chit_id."' AND 
                                                admin_approval = '1' AND deleted = '0' GROUP BY agent_id, customer_chit_id";
                            $list = $this->getQueryRecords($GLOBALS['receipt_table'], $select_query);
                            if(!empty($list)) {
                                foreach($list as $data) {
                                    if(!empty($data['receipt_amount'])) {
                                        $receipt_amount = $data['receipt_amount'];
                                    }
                                }
                            }

                            if(!empty($receipt_amount) && !empty($payable_amount) && !empty($maturity_value)) {
                                if($receipt_amount == $payable_amount) {
                                    $receipt_amount = $maturity_value;
                                }
                            }

                            $select_query = "SELECT o.customer_chit_ids,
                                                (SELECT SUM(amount) FROM ".$GLOBALS['order_chit_table']." as ot 
                                                WHERE ot.customer_chit_id = '".$customer_chit_id."' 
                                                GROUP BY customer_chit_id) as order_amount 
                                                FROM ".$GLOBALS['order_table']." as o 
                                                WHERE 
                                                FIND_IN_SET('".$customer_chit_id."', o.customer_chit_ids) 
                                                AND o.confirmed = '1' AND o.deleted = '0'";
                            $list = $this->getQueryRecords($GLOBALS['order_table'], $select_query);
                            if(!empty($list)) {
                                foreach($list as $data) {
                                    if(!empty($data['order_amount'])) {
                                        $order_amount = $data['order_amount'];
                                    }
                                }
                            }

                            $balance_amount = 0;
                            if(!empty($receipt_amount)) {
                                $fund_wallet = $fund_wallet + $receipt_amount;
                                $balance_amount = $receipt_amount;
                            }
                            if(!empty($order_amount)) {
                                $order_fund_wallet = $order_fund_wallet + $order_amount;

                                $balance_amount = $balance_amount - $order_amount;
                                if($balance_amount < 0) {
                                    $balance_amount = 0;
                                }
                            }

                            $customer_chit_unique_id = "";
                            $customer_chit_unique_id = $this->getTableColumnValue($GLOBALS['customer_chit_table'], 'customer_chit_id', $customer_chit_id, 'id');
                            if(!empty($customer_chit_unique_id) && preg_match("/^\d+$/", $customer_chit_unique_id)) {
                                $columns = array(); $values = array();
                                $columns = array('wallet', 'amount_to_use_order_agent');
                                $values = array("'".$balance_amount."'", "'".$balance_amount."'");
                                $update_id = $this->UpdateSQL($GLOBALS['customer_chit_table'], $customer_chit_unique_id, $columns, $values, '');
                            }
                        }
                    }
                }

                // merge
                $select_query = "SELECT cc.customer_chit_id, cc.wallet as merge_chit_wallet FROM ".$GLOBALS['customer_chit_merge_table']." as cc 
                                    INNER JOIN ".$GLOBALS['customer_chit_table']." as c ON c.customer_chit_id = cc.customer_chit_id
                                    WHERE c.admin_approval = '1' AND cc.admin_approval = '1' AND cc.creator = '".$agent_id."' 
                                    AND c.account_merger_id = cc.creator ORDER BY cc.id ASC";
                $list = $this->getQueryRecords($GLOBALS['customer_chit_merge_table'], $select_query);
                if(!empty($list)) {
                    foreach($list as $row) {
                        $customer_chit_id = ""; $merge_chit_wallet = 0;
                        if(!empty($row['customer_chit_id'])) {
                            $customer_chit_id = $row['customer_chit_id'];
                        }
                        if(!empty($row['merge_chit_wallet'])) {
                            $merge_chit_wallet = $row['merge_chit_wallet'];
                        }

                        $select_query = "SELECT o.customer_chit_ids, 
                                                (SELECT SUM(amount) FROM ".$GLOBALS['order_chit_table']." as ot 
                                                WHERE ot.customer_chit_id = '".$customer_chit_id."' 
                                                GROUP BY customer_chit_id) as order_amount 
                                                FROM ".$GLOBALS['order_table']." as o 
                                                WHERE 
                                                FIND_IN_SET('".$customer_chit_id."', o.customer_chit_ids) 
                                                AND o.confirmed = '1' AND o.deleted = '0'";
                        $list = $this->getQueryRecords($GLOBALS['order_table'], $select_query);
                        if(!empty($list)) {
                            foreach($list as $data) {
                                if(!empty($data['order_amount'])) {
                                    $order_amount = $data['order_amount'];
                                }
                            }
                        }

                        //echo $select_query."<br>";

                        $balance_amount = 0;
                        if(!empty($merge_chit_wallet)) {
                            $merge_wallet = $merge_wallet + $merge_chit_wallet;
                            $balance_amount = $merge_chit_wallet;
                        }
                        if(!empty($order_amount)) {
                            $order_merge_wallet = $order_merge_wallet + $order_amount;
                            $balance_amount = $balance_amount - $order_amount;
                            if($balance_amount < 0) {
                                $balance_amount = 0;
                            }
                        }

                    }
                }
            }

            if(!empty($agent_id)) {
                $total_wallet = 0;
                $total_wallet = $fund_wallet + $commission_wallet + $merge_wallet;

                $order_total_wallet = 0;
                $order_total_wallet = $order_fund_wallet + $order_commission_wallet + $order_merge_wallet;

                $balance_total_wallet = 0;
                if(!empty($total_wallet)) {
                    $balance_total_wallet = $total_wallet;
                }
                if(!empty($balance_total_wallet) && !empty($order_total_wallet)) {
                    $balance_total_wallet = $balance_total_wallet - $order_total_wallet;
                }
                if($balance_total_wallet < 0) {
                    $balance_total_wallet = 0;
                }

                //echo "total_wallet - ".$total_wallet.", order_total_wallet - ".$order_total_wallet.", balance_total_wallet - ".$balance_total_wallet; exit;

                $agent_unique_id = "";
                $agent_unique_id = $this->getTableColumnValue($GLOBALS['agent_table'], 'agent_id', $agent_id, 'id');
                if(!empty($agent_unique_id) && preg_match("/^\d+$/", $agent_unique_id)) {
                    $columns = array(); $values = array();
                    $columns = array('fund_wallet', 'commission_wallet', 'merge_wallet', 'total_wallet');
                    $values = array("'".$fund_wallet."'", "'".$commission_wallet."'", "'".$merge_wallet."'", "'".$balance_total_wallet."'");
                    $update_id = $this->UpdateSQL($GLOBALS['agent_table'], $agent_unique_id, $columns, $values, '');
                }
            }

            return $update_id;
        }

        // get agent voucher list by filters
		public function getAgentVoucherListByFilter($from_date, $to_date, $agent_id, $chit_id) {
            $where = ""; $select_query = ""; $list = array();

            if(!empty($from_date)) {
                $from_date = date("Y-m-d", strtotime($from_date));
                $where = "DATE(voucher_date) >= '".$from_date."'";
            }
            if(!empty($to_date)) {
                $to_date = date("Y-m-d", strtotime($to_date));
                if(!empty($where)) {
                    $where = $where." AND DATE(voucher_date) <= '".$to_date."'";
                }
                else {
                    $where = "DATE(voucher_date) <= '".$to_date."'";
                }
            }
            if(!empty($agent_id)) {
                if(!empty($where)) {
                    $where = $where." AND agent_id = '".$agent_id."'";
                }
                else {
                    $where = "agent_id = '".$agent_id."'";
                }
            }
            if(!empty($chit_id)) {
                if(!empty($where)) {
                    $where = $where." AND customer_chit_id = '".$chit_id."'";
                }
                else {
                    $where = "customer_chit_id = '".$chit_id."'";
                }
            }

            if(!empty($where)) {
                $select_query = "SELECT * FROM ".$GLOBALS['voucher_table']." WHERE ".$where." AND deleted = '0' ORDER BY id DESC";
            }
            else {
                $select_query = "SELECT * FROM ".$GLOBALS['voucher_table']." WHERE deleted = '0' ORDER BY id DESC";
            } 
            if(!empty($select_query)) {
                $list = $this->getQueryRecords($GLOBALS['voucher_table'], $select_query);
            }

            return $list;
        }

    }
?>