<?php
    class Chit_Functions extends SMS_Functions {
        // update chit params
		public function UpdateChitParams($chit_id) {
            $updated = 0;
            if(!empty($chit_id)) {
                $customer_chit_list = array();
                $select_query = "SELECT * FROM ".$GLOBALS['customer_chit_table']." WHERE chit_id = '".$chit_id."' AND admin_approval = '1'  AND cancelled = '0' AND deleted = '0'";
                $customer_chit_list = $this->getQueryRecords($GLOBALS['customer_chit_table'], $select_query);
                if(!empty($customer_chit_list)) {
                    foreach($customer_chit_list as $data) {
                        if(!empty($data['id'])) {
                            $chit_name = ""; $maturity_value = 0; $chit_type = ""; $due_amount = 0; $due_duration = 0; $due_days = 0; $due_reminder_days = 0;
                            $payable_amount = 0; $start_date = ""; $end_date = ""; $booking_open_date = ""; $penalty_duration = 0; $penalty_value = 0;
                            $min_value = 0; $max_value = 0;
                            
                            $allow_split_up_due_payment = 2; $accept_advance_amount = 2; $accept_previous_due = 2; $allow_termination = 2; $termination_days = 0;
                            $allow_agent = 2; $add_transport_charges = 2; $allow_merge_completed_wallet = 2; $add_due_without_penalty = 2;

                            $chit_name = $this->getTableColumnValue($GLOBALS['chit_table'], 'chit_id', $chit_id, 'chit_name');
                            $maturity_value = $this->getTableColumnValue($GLOBALS['chit_table'], 'chit_id', $chit_id, 'maturity_value');
                            $chit_type = $this->getTableColumnValue($GLOBALS['chit_table'], 'chit_id', $chit_id, 'type');
                            $due_amount = $this->getTableColumnValue($GLOBALS['chit_table'], 'chit_id', $chit_id, 'due_amount');
                            $due_duration = $this->getTableColumnValue($GLOBALS['chit_table'], 'chit_id', $chit_id, 'due_duration');
                            $due_days = $this->getTableColumnValue($GLOBALS['chit_table'], 'chit_id', $chit_id, 'due_days');
                            $due_reminder_days = $this->getTableColumnValue($GLOBALS['chit_table'], 'chit_id', $chit_id, 'due_reminder_days');
                            $payable_amount = $this->getTableColumnValue($GLOBALS['chit_table'], 'chit_id', $chit_id, 'payable_amount');

                            $start_date = $this->getTableColumnValue($GLOBALS['chit_table'], 'chit_id', $chit_id, 'start_date');
                            $end_date = $this->getTableColumnValue($GLOBALS['chit_table'], 'chit_id', $chit_id, 'end_date');
                            $booking_open_date = $this->getTableColumnValue($GLOBALS['chit_table'], 'chit_id', $chit_id, 'booking_open_date');

                            $penalty_duration = $this->getTableColumnValue($GLOBALS['chit_table'], 'chit_id', $chit_id, 'penalty_duration');
                            $penalty_value = $this->getTableColumnValue($GLOBALS['chit_table'], 'chit_id', $chit_id, 'penalty_value');
                            $min_value = $this->getTableColumnValue($GLOBALS['chit_table'], 'chit_id', $chit_id, 'min_value');
                            $max_value = $this->getTableColumnValue($GLOBALS['chit_table'], 'chit_id', $chit_id, 'max_value');

                            $allow_split_up_due_payment = $this->getTableColumnValue($GLOBALS['chit_table'], 'chit_id', $chit_id, 'allow_split_up_due_payment');
                            $accept_advance_amount = $this->getTableColumnValue($GLOBALS['chit_table'], 'chit_id', $chit_id, 'accept_advance_amount');
                            $accept_previous_due = $this->getTableColumnValue($GLOBALS['chit_table'], 'chit_id', $chit_id, 'accept_previous_due');

                            $allow_termination = $this->getTableColumnValue($GLOBALS['chit_table'], 'chit_id', $chit_id, 'allow_termination');
                            $termination_days = $this->getTableColumnValue($GLOBALS['chit_table'], 'chit_id', $chit_id, 'termination_days');
                            $allow_agent = $this->getTableColumnValue($GLOBALS['chit_table'], 'chit_id', $chit_id, 'allow_agent');
                            $add_transport_charges = $this->getTableColumnValue($GLOBALS['chit_table'], 'chit_id', $chit_id, 'add_transport_charges');
                            $allow_merge_completed_wallet = $this->getTableColumnValue($GLOBALS['chit_table'], 'chit_id', $chit_id, 'allow_merge_completed_wallet');
                            $add_due_without_penalty = $this->getTableColumnValue($GLOBALS['chit_table'], 'chit_id', $chit_id, 'add_due_without_penalty');

                            $columns = array(); $values = array(); $update_id = "";
                            $columns = array('chit_details', 'maturity_value', 'chit_type', 'due_amount', 'due_duration', 'due_days', 'due_reminder_days', 'payable_amount', 'start_date', 'end_date', 'booking_open_date', 'penalty_duration', 'penalty_value', 'min_value', 'max_value', 'allow_split_up_due_payment', 'accept_advance_amount', 'accept_previous_due', 'allow_termination', 'termination_days', 'allow_agent', 'add_transport_charges', 'allow_merge_completed_wallet', 'add_due_without_penalty');
							$values = array("'".$chit_name."'", "'".$maturity_value."'", "'".$chit_type."'", "'".$due_amount."'", "'".$due_duration."'", "'".$due_days."'", "'".$due_reminder_days."'", "'".$payable_amount."'", "'".$start_date."'", "'".$end_date."'", "'".$booking_open_date."'", "'".$penalty_duration."'", "'".$penalty_value."'", "'".$min_value."'", "'".$max_value."'", "'".$allow_split_up_due_payment."'", "'".$accept_advance_amount."'", "'".$accept_previous_due."'",  "'".$allow_termination."'", "'".$termination_days."'", "'".$allow_agent."'", "'".$add_transport_charges."'", "'".$allow_merge_completed_wallet."'", "'".$add_due_without_penalty."'");
							$update_id = $this->UpdateSQL($GLOBALS['customer_chit_table'], $data['id'], $columns, $values, '');
                        }
                    }
                }
            }
            return $updated;
        }

        // get customer count by chit
		public function getChitUsersCount($chit_id) {
            $customer_count = 0; $select_query = ""; $list = array(); $where = "";
            if(!empty($chit_id)) {
                $where = "chit_id = '".$chit_id."'";
            }
            if(!empty($where)) {
                $select_query = "SELECT COUNT(id) as customer_count FROM ".$GLOBALS['customer_chit_table']." WHERE ".$where." AND admin_approval = '1' AND cancelled = '0' AND deleted = '0' GROUP BY chit_id";
            }
            if(!empty($select_query)) {
                $list = $this->getQueryRecords($GLOBALS['customer_chit_table'], $select_query);
                if(!empty($list)) {
                    foreach($list as $data) {
                        if(!empty($data['customer_count'])) {
                            $customer_count = $data['customer_count'];
                        }
                    }
                }
            }
            return $customer_count;
        }

        // get state list
		public function getStateList($state) {
            $select_query = ""; $list = array();
            if(!empty($state)) {
                $select_query = "SELECT * FROM ".$GLOBALS['state_table']." WHERE state_name = '".$state."' AND deleted = '0' ORDER BY state_name ASC";
            }
            else {
                $select_query = "SELECT * FROM ".$GLOBALS['state_table']." WHERE deleted = '0' ORDER BY state_name ASC";
            }
            if(!empty($select_query)) {
                $list = $this->getQueryRecords($GLOBALS['state_table'], $select_query);
            }
			return $list;
        }

        // get city list
		public function getCityList($state) {
            $select_query = ""; $list = array();
            if(!empty($state)) {
                $select_query = "SELECT * FROM ".$GLOBALS['city_table']." WHERE state_name = '".$state."' AND deleted = '0' ORDER BY city_name ASC";
            }
            else {
                $select_query = "SELECT * FROM ".$GLOBALS['city_table']." WHERE deleted = '0' ORDER BY city_name ASC";
            }
            if(!empty($select_query)) {
                $list = $this->getQueryRecords($GLOBALS['city_table'], $select_query);
            }
			return $list;
        }

        // get customer chit unique id
		public function getCustomerChitUniqueID($agent_id, $customer_id, $chit_id) {
            $unique_id = ""; $where = ""; $select_query = ""; $list = array();

            if(!empty($agent_id)) {
                $where = "agent_id = '".$agent_id."'";
            }
            if(!empty($customer_id)) {
                if(!empty($where)) {
                    $where = $where." AND customer_id = '".$customer_id."'";
                }
                else {
                    $where = "customer_id = '".$customer_id."'";
                }
            }
            if(!empty($chit_id)) {
                if(!empty($where)) {
                    $where = $where." AND customer_chit_id = '".$chit_id."'";
                }
                else {
                    $where = "customer_chit_id = '".$chit_id."'";
                }
            }

            if(!empty($where)) {
                $select_query = "SELECT id FROM ".$GLOBALS['customer_chit_table']." WHERE ".$where." AND cancelled = '0' AND deleted = '0'";
                $list = $this->getQueryRecords($GLOBALS['customer_chit_table'], $select_query);
                if(!empty($list)) {
                    foreach($list as $data) {
                        if(!empty($data['id'])) {
                            $unique_id = $data['id'];
                        }
                    }
                }
            }

            return $unique_id;
        }

        // get customer chit payable amount
		public function getCustomerChitPayableAmount($agent_id, $customer_id, $chit_id) {
            $payable_amount = ""; $where = ""; $select_query = ""; $list = array();

            if(!empty($agent_id)) {
                $where = "agent_id = '".$agent_id."'";
            }
            if(!empty($customer_id)) {
                if(!empty($where)) {
                    $where = $where." AND customer_id = '".$customer_id."'";
                }
                else {
                    $where = "customer_id = '".$customer_id."'";
                }
            }
            if(!empty($chit_id)) {
                if(!empty($where)) {
                    $where = $where." AND customer_chit_id = '".$chit_id."'";
                }
                else {
                    $where = "customer_chit_id = '".$chit_id."'";
                }
            }

            if(!empty($where)) {
                $select_query = "SELECT payable_amount FROM ".$GLOBALS['customer_chit_table']." WHERE ".$where." AND admin_approval = '1' AND cancelled = '0' AND deleted = '0'";
                $list = $this->getQueryRecords($GLOBALS['customer_chit_table'], $select_query);
                if(!empty($list)) {
                    foreach($list as $data) {
                        if(!empty($data['payable_amount'])) {
                            $payable_amount = $data['payable_amount'];
                        }
                    }
                }
            }

            return $payable_amount;
        }

        // check customer exist in chit
		public function CheckCustomerExistsInChit($agent_id, $customer_id, $chit_id) {
            $customer_chit_id = ""; $where = ""; $select_query = ""; $list = array();

            if(!empty($customer_id)) {
                $where = "customer_id = '".$customer_id."'";
            }
            else if(!empty($agent_id)) {
                if(!empty($where)) {
                    $where = $where." AND agent_id = '".$agent_id."' AND customer_id = '".$GLOBALS['null_value']."'";
                }
                else {
                    $where = "agent_id = '".$agent_id."' AND customer_id = '".$GLOBALS['null_value']."'";
                }
            }
            if(!empty($chit_id)) {
                if(!empty($where)) {
                    $where = $where." AND chit_id = '".$chit_id."'";
                }
                else {
                    $where = "chit_id = '".$chit_id."'";
                }
            }

            if(!empty($where)) {
                $select_query = "SELECT customer_chit_id FROM ".$GLOBALS['customer_chit_table']." WHERE ".$where." AND cancelled = '0' AND deleted = '0'";
                $list = $this->getQueryRecords($GLOBALS['customer_chit_table'], $select_query);
                if(!empty($list)) {
                    foreach($list as $data) {
                        if(!empty($data['customer_chit_id'])) {
                            $customer_chit_id = $data['customer_chit_id'];
                        }
                    }
                }
            }

            return $customer_chit_id;
        } 
        
        // get customer order chit list
		public function getCustomerOrderChits($agent_id, $customer_id) {
            $where = ""; $select_query = ""; $list = array(); $customer_chit_ids = array();

            if(!empty($agent_id)) {
                $where = "(agent_id = '".$agent_id."' OR account_merger_id = '".$agent_id."') AND amount_to_use_order_agent != '0'";
            }
            if(!empty($customer_id)) {
                $where = "(customer_id = '".$customer_id."' OR account_merger_id = '".$customer_id."') AND amount_to_use_order_customer != '0'";
            }

            if(!empty($where)) {
               $select_query = "SELECT customer_chit_id FROM ".$GLOBALS['customer_chit_table']." WHERE ".$where." AND admin_approval = '1' AND cancelled = '0' AND deleted = '0' ORDER BY id DESC";
            }
            if(!empty($select_query)) {
                $list = $this->getQueryRecords($GLOBALS['customer_chit_table'], $select_query);
                if(!empty($list)) {
                    foreach($list as $row) {
                        if(!empty($row['customer_chit_id'])) {
                            $customer_chit_ids[] = $row['customer_chit_id'];
                        }
                    }
                }
            }

            return $customer_chit_ids;
        }

        // get customer chit list by filters
		public function getCustomerChitListByFilter($from_date, $to_date, $agent_id, $customer_id, $chit_id) {
            $where = ""; $select_query = ""; $list = array();

            if(!empty($from_date)) {
                $from_date = date("Y-m-d", strtotime($from_date));
                $where = "DATE(created_date_time) >= '".$from_date."'";
            }
            if(!empty($to_date)) {
                $to_date = date("Y-m-d", strtotime($to_date));
                if(!empty($where)) {
                    $where = $where." AND DATE(created_date_time) <= '".$to_date."'";
                }
                else {
                    $where = "DATE(created_date_time) <= '".$to_date."'";
                }
            }
            if(!empty($agent_id)) {
                if(!empty($where)) {
                    $where = $where." AND agent_id = '".$agent_id."'";
                }
                else {
                    $where = "agent_id = '".$agent_id."'";
                }
            }
            if(!empty($customer_id)) {
                if(!empty($where)) {
                    $where = $where." AND customer_id = '".$customer_id."'";
                }
                else {
                    $where = "customer_id = '".$customer_id."'";
                }
            }
            if(!empty($chit_id)) {
                if(!empty($where)) {
                    $where = $where." AND chit_id = '".$chit_id."'";
                }
                else {
                    $where = "chit_id = '".$chit_id."'";
                }
            }

            if(!empty($where)) {
                $select_query = "SELECT * FROM ".$GLOBALS['customer_chit_table']." WHERE ".$where." AND admin_approval = '1' AND cancelled = '0' AND deleted = '0' ORDER BY id DESC";
            }
            else {
                $select_query = "SELECT * FROM ".$GLOBALS['customer_chit_table']." WHERE admin_approval = '1' AND cancelled = '0' AND deleted = '0' ORDER BY id DESC";
            }
            if(!empty($select_query)) {
                $list = $this->getQueryRecords($GLOBALS['customer_chit_table'], $select_query);
            }

            return $list;
        }

        // get request customer chit list by filters
		public function getRequestCustomerChitList($agent_id, $customer_id, $chit_id) {
            $where = ""; $select_query = ""; $list = array();

            if(!empty($agent_id)) {
                $where = "agent_id = '".$agent_id."'";
            }
            if(!empty($customer_id)) {
                if(!empty($where)) {
                    $where = $where." AND customer_id = '".$customer_id."'";
                }
                else {
                    $where = "customer_id = '".$customer_id."'";
                }
            }
            if(!empty($chit_id)) {
                if(!empty($where)) {
                    $where = $where." AND chit_id = '".$chit_id."'";
                }
                else {
                    $where = "chit_id = '".$chit_id."'";
                }
            }

            if(!empty($where)) {
                $select_query = "SELECT * FROM ".$GLOBALS['customer_chit_table']." WHERE ".$where." AND cancelled = '0' AND deleted = '0' ORDER BY id DESC";
            }
            else {
                $select_query = "SELECT * FROM ".$GLOBALS['customer_chit_table']." WHERE cancelled = '0' AND deleted = '0' ORDER BY id DESC";
            }
            if(!empty($select_query)) {
                $list = $this->getQueryRecords($GLOBALS['customer_chit_table'], $select_query);
            }

            return $list;
        }

        // get my scheme list
		public function getMySchemeList($agent_id, $customer_id, $chit_id) {
            $where = ""; $select_query = ""; $list = array();

            if(!empty($customer_id)) {
                $where = "customer_id = '".$customer_id."'";
            }
            else if(!empty($agent_id)) {
                if(!empty($where)) {
                    $where = $where." AND agent_id = '".$agent_id."' AND customer_id = '".$GLOBALS['null_value']."'";
                }
                else {
                    $where = "agent_id = '".$agent_id."' AND customer_id = '".$GLOBALS['null_value']."'";
                }
            }

            if(!empty($chit_id)) {
                if(!empty($where)) {
                    $where = $where." AND customer_chit_id = '".$chit_id."'";
                }
                else {
                    $where = "customer_chit_id = '".$chit_id."'";
                }
            }

            if(!empty($where)) {
                $select_query = "SELECT * FROM ".$GLOBALS['customer_chit_table']." WHERE ".$where." AND admin_approval = '1' AND cancelled = '0' AND deleted = '0' ORDER BY id DESC";
            }
            else {
                $select_query = "SELECT * FROM ".$GLOBALS['customer_chit_table']." WHERE admin_approval = '1' AND cancelled = '0' AND deleted = '0' ORDER BY id DESC";
            }
            if(!empty($select_query)) {
                $list = $this->getQueryRecords($GLOBALS['customer_chit_table'], $select_query);
            }

            return $list;
        }

        // get agent / customer receipt total amount
		public function getAgentCustomerReceiptTotalAmount($agent_id, $customer_id, $chit_id) {
            $where = ""; $select_query = ""; $list = array(); $total_amount = 0;

            if(!empty($agent_id)) {
                $where = "agent_id = '".$agent_id."'";
            }
            if(!empty($customer_id)) {
                if(!empty($where)) {
                    $where = $where." AND customer_id = '".$customer_id."'";
                }
                else {
                    $where = "customer_id = '".$customer_id."'";
                }
            }
            if(!empty($chit_id)) {
                if(!empty($where)) {
                    $where = $where." AND customer_chit_id = '".$chit_id."'";
                }
                else {
                    $where = "customer_chit_id = '".$chit_id."'";
                }
            }

            if(!empty($where)) {
                $select_query = "SELECT SUM(amount) as total_amount FROM ".$GLOBALS['receipt_table']." WHERE ".$where." AND admin_approval = '1' AND deleted = '0' GROUP BY agent_id, customer_id, customer_chit_id";
            }
            if(!empty($select_query)) {
                $list = $this->getQueryRecords($GLOBALS['receipt_table'], $select_query);
                if(!empty($list)) {
                    foreach($list as $row) {
                        if(!empty($row['total_amount'])) {
                            $total_amount = $row['total_amount'];
                        }
                    }
                }
            }

            return $total_amount;
        }

        // get penalty amount by chit
		public function getPenaltyAmountByChit($chit_id, $receipt_id) {
            $penalty_amount = 0;

            if(!empty($chit_id)) {
                $penalty_duration = 0;
                $penalty_duration = $this->getTableColumnValue($GLOBALS['customer_chit_table'], 'customer_chit_id', $chit_id, 'penalty_duration');
                if(!empty($penalty_duration)) {
                    $penalty_value = "";
                    $penalty_value = $this->getTableColumnValue($GLOBALS['customer_chit_table'], 'customer_chit_id', $chit_id, 'penalty_value');

                    $agent_id = "";
                    $agent_id = $this->getTableColumnValue($GLOBALS['customer_chit_table'], 'customer_chit_id', $chit_id, 'agent_id');
                    $customer_id = "";
                    $customer_id = $this->getTableColumnValue($GLOBALS['customer_chit_table'], 'customer_chit_id', $chit_id, 'customer_id');
                    $due_amount = 0;
                    $due_amount = $this->getTableColumnValue($GLOBALS['customer_chit_table'], 'customer_chit_id', $chit_id, 'due_amount');

                    $current_due_by_chit = 0;
                    $current_due_by_chit = $this->getCurrentDueByChit($chit_id);

                    $current_due_by_customer = 0;
                    $current_due_by_customer = $this->getCurrentDueByUser($agent_id, $customer_id, $chit_id, $receipt_id);
                    if(!empty($current_due_by_customer)) {
                        $current_due_by_customer = $current_due_by_customer - 1;
                    }
                   
                    $last_paid_date = "";
                    $last_paid_date = $this->getLastPaidDateByChit($agent_id, $customer_id, $chit_id, $receipt_id);

                    $next_due_date = "";
                    $next_due_date = $this->getNextDueDateByChit($agent_id, $customer_id, $chit_id);

                    //echo "last_paid_date - ".$last_paid_date.", next_due_date - ".$next_due_date."<br>";

                    $current_date = date("d-m-Y");
                    if(!empty($next_due_date)) {
                        $additional_days = 0;
                        $datediff = strtotime($current_date) - strtotime($next_due_date);
                        $additional_days = round($datediff / (60 * 60 * 24));
                        //echo "current_date = ".$current_date.", additional_days - ".$additional_days.", penalty_duration - ".$penalty_duration."<br>";
                        if(!empty($additional_days) && $additional_days > $penalty_duration) {
                            $due_count = 0;
                            $due_count = $current_due_by_chit - $current_due_by_customer;
                            if(!empty($due_count) && !empty($due_amount)) {
                                $due_amount = $due_amount * $due_count;
                                if(!empty($penalty_value)) {
                                    if (strpos($penalty_value, "%") !== false) {
                                        $penalty_value = trim(str_replace("%", "", $penalty_value));
                                        $penalty_amount = ( $due_amount * $penalty_value ) / 100;
                                        if(!empty($penalty_amount)) {
                                            $penalty_amount = $this->truncate_number($penalty_amount, 2);
                                            $penalty_amount = str_replace(",", "", $penalty_amount);
                                        }
                                    }
                                    else {
                                        $penalty_amount = $penalty_value * $due_count;
                                    }
                                }
                            }
                        }
                    }
                }

                $prev_penalty_amount = 0;
                $prev_penalty_amount = $this->getTableColumnValue($GLOBALS['customer_chit_table'], 'customer_chit_id', $chit_id, 'penalty_amount');
                if(!empty($prev_penalty_amount)) {
                    $penalty_amount = $penalty_amount + $prev_penalty_amount;
                }
            }

            return $penalty_amount;
        }

        // get current due by chit
		public function getCurrentDueByChit($chit_id) {
            $current_due = 0; $due_count = 0;
            if(!empty($chit_id)) {
                $due_count = $this->getTableColumnValue($GLOBALS['customer_chit_table'], 'customer_chit_id', $chit_id, 'due_count');
                if(!empty($due_count)) {
                    $current_due = $due_count + 1;
                }
                else {
                    $current_due = 1;
                }
            }
            return $current_due;
        }

        // get current due by customer
		public function getCurrentDueByUser($agent_id, $customer_id, $chit_id, $receipt_id) {
            $current_due = 0; $where = ""; $select_query = ""; $list = array();

            if(!empty($agent_id)) {
                $where = "agent_id = '".$agent_id."'";
            }
            if(!empty($customer_id)) {
                if(!empty($where)) {
                    $where = $where." AND customer_id = '".$customer_id."'";
                }
                else {
                    $where = "customer_id = '".$customer_id."'";
                }
            }
            if(!empty($chit_id)) {
                if(!empty($where)) {
                    $where = $where." AND customer_chit_id = '".$chit_id."'";
                }
                else {
                    $where = "customer_chit_id = '".$chit_id."'";
                }
            }
            if(!empty($receipt_id)) {
                if(!empty($where)) {
                    $where = $where." AND receipt_id != '".$receipt_id."'";
                }
                else {
                    $where = "receipt_id != '".$receipt_id."'";
                }
            }

            if(!empty($where)) {
                $select_query = "SELECT SUM(chit_due_count) as current_due FROM ".$GLOBALS['receipt_table']." WHERE ".$where." AND deleted = '0'";
                $list = $this->getQueryRecords($GLOBALS['customer_chit_table'], $select_query);
                if(!empty($list)) {
                    foreach($list as $data) {
                        if(!empty($data['current_due'])) {
                            $current_due = $data['current_due'];
                        }
                    }
                }
            }
            if(!empty($current_due)) { $current_due = $current_due + 1; }
            else { $current_due = 1; }

            return $current_due;
        }

        // get last paid date by chit
		public function getLastPaidDateByChit($agent_id, $customer_id, $chit_id, $receipt_id) {
            $last_paid_date = ""; $where = ""; $select_query = ""; $list = array();

            if(!empty($agent_id)) {
                $where = "agent_id = '".$agent_id."'";
            }
            if(!empty($customer_id)) {
                if(!empty($where)) {
                    $where = $where." AND customer_id = '".$customer_id."'";
                }
                else {
                    $where = "customer_id = '".$customer_id."'";
                }
            }
            if(!empty($chit_id)) {
                if(!empty($where)) {
                    $where = $where." AND customer_chit_id = '".$chit_id."'";
                }
                else {
                    $where = "customer_chit_id = '".$chit_id."'";
                }
            }
            if(!empty($receipt_id)) {
                if(!empty($where)) {
                    $where = $where." AND receipt_id != '".$receipt_id."'";
                }
                else {
                    $where = "receipt_id != '".$receipt_id."'";
                }
            }

            if(!empty($where)) {
                $select_query = "SELECT receipt_date as last_paid_date FROM ".$GLOBALS['receipt_table']." WHERE ".$where." AND admin_approval = '1' AND deleted = '0' ORDER BY id DESC LIMIT 1";
                $list = $this->getQueryRecords($GLOBALS['receipt_table'], $select_query);
                if(!empty($list)) {
                    foreach($list as $data) {
                        if(!empty($data['last_paid_date']) && $data['last_paid_date'] != "0000-00-00") {
                            $last_paid_date = $data['last_paid_date'];
                        }
                    }
                }
            }

            return $last_paid_date;
        }

        // get last paid amount by chit
		public function getLastPaidAmountByChit($agent_id, $customer_id, $chit_id, $receipt_id) {
            $last_paid_amount = ""; $where = ""; $select_query = ""; $list = array();

            if(!empty($agent_id)) {
                $where = "agent_id = '".$agent_id."'";
            }
            if(!empty($customer_id)) {
                if(!empty($where)) {
                    $where = $where." AND customer_id = '".$customer_id."'";
                }
                else {
                    $where = "customer_id = '".$customer_id."'";
                }
            }
            if(!empty($chit_id)) {
                if(!empty($where)) {
                    $where = $where." AND customer_chit_id = '".$chit_id."'";
                }
                else {
                    $where = "customer_chit_id = '".$chit_id."'";
                }
            }
            if(!empty($receipt_id)) {
                if(!empty($where)) {
                    $where = $where." AND receipt_id != '".$receipt_id."'";
                }
                else {
                    $where = "receipt_id != '".$receipt_id."'";
                }
            }

            if(!empty($where)) {
                $select_query = "SELECT amount as last_paid_amount FROM ".$GLOBALS['receipt_table']." WHERE ".$where." AND admin_approval = '1' AND deleted = '0' ORDER BY id DESC LIMIT 1";
                $list = $this->getQueryRecords($GLOBALS['receipt_table'], $select_query);
                if(!empty($list)) {
                    foreach($list as $data) {
                        if(!empty($data['last_paid_amount'])) {
                            $last_paid_amount = $data['last_paid_amount'];
                        }
                    }
                }
            }

            return $last_paid_amount;
        }

        // get next due date by chit
		public function getNextDueDateByChit($agent_id, $customer_id, $chit_id) {
            $next_due_date = "";

            $chit_type = "";
            if(!empty($chit_id)) {
                $chit_type = $this->getTableColumnValue($GLOBALS['customer_chit_table'], 'customer_chit_id', $chit_id, 'chit_type');

                $last_paid_date = "";
                $last_paid_date = $this->getLastPaidDateByChit($agent_id, $customer_id, $chit_id, '');
    
                $next_due_date = "";
                if(!empty($last_paid_date) && !empty($chit_type)) {
                    $chit_type = $this->encode_decode('decrypt', $chit_type);

                    if($chit_type == $GLOBALS['chit_type_monthly']) {                         
                        $next_due_date = date('Y-m-d', strtotime('+1 month', strtotime($last_paid_date)));
                    }
                    else if($chit_type == $GLOBALS['chit_type_weekly']) {
                        $next_due_date = date('Y-m-d', strtotime('+7 days', strtotime($last_paid_date)));
                    }
                }
            }

            return $next_due_date;
        }

        // update customer due count
		public function UpdateUserDueCount($agent_id, $customer_id, $chit_id) {
            $update_id = 0; $due_count = 0; $wallet_amount = 0; $where = ""; $select_query = ""; $list = array();

            if(!empty($agent_id)) {
                $where = "agent_id = '".$agent_id."'";
            }
            if(!empty($customer_id)) {
                if(!empty($where)) {
                    $where = $where." AND customer_id = '".$customer_id."'";
                }
                else {
                    $where = "customer_id = '".$customer_id."'";
                }
            }
            if(!empty($chit_id)) {
                if(!empty($where)) {
                    $where = $where." AND customer_chit_id = '".$chit_id."'";
                }
                else {
                    $where = "customer_chit_id = '".$chit_id."'";
                }
            }

            if(!empty($where)) {
                $select_query = "SELECT SUM(amount) as wallet_amount FROM ".$GLOBALS['receipt_table']." WHERE ".$where." AND deleted = '0'";
                $list = $this->getQueryRecords($GLOBALS['receipt_table'], $select_query);
                if(!empty($list)) {
                    foreach($list as $data) {
                        if(!empty($data['wallet_amount'])) {
                            $wallet_amount = $data['wallet_amount'];
                        }
                    }
                }
                if(!empty($chit_id) && !empty($wallet_amount)) {
                    $chit_due_amount = 0;
                    $chit_due_amount = $this->getTableColumnValue($GLOBALS['customer_chit_table'], 'customer_chit_id', $chit_id, 'due_amount');
                    if(!empty($chit_due_amount)) {
                        $due_count = $wallet_amount / $chit_due_amount;
                    }
                }
                if(!empty($due_count)) {
                    $customer_chit_unique_id = "";
					$customer_chit_unique_id = $this->getCustomerChitUniqueID($agent_id, $customer_id, $chit_id);
                    if(!empty($customer_chit_unique_id) && preg_match("/^\d+$/", $customer_chit_unique_id)) {
                        $payable_amount = 0;
                        $payable_amount = $this->getCustomerChitPayableAmount($agent_id, $customer_id, $chit_id);

                        $total_amount = 0; $completed_date = "0000-00-00";
                        $total_amount = $this->getAgentCustomerReceiptTotalAmount($agent_id, $customer_id, $chit_id);
                        if(!empty($payable_amount) && !empty($total_amount) && $total_amount == $payable_amount) {
                            $completed_date = $this->getLastPaidDateByChit($agent_id, $customer_id, $chit_id, '');
                        }

                        $columns = array(); $values = array();
                        $columns = array('completed_date', 'due_count');
                        $values = array("'".$completed_date."'", "'".$due_count."'");
                        $update_id = $this->UpdateSQL($GLOBALS['customer_chit_table'], $customer_chit_unique_id, $columns, $values, '');
                    }
                }
            }

            return $update_id;
        }    

        // get customer receipt list by filters
		public function getCustomerReceiptListByFilter($from_date, $to_date, $agent_id, $customer_id, $chit_id){
            $where = "admin_approval = '1'"; $select_query = ""; $list = array();

            if(!empty($from_date)) {
                $from_date = date("Y-m-d", strtotime($from_date));
                $where = "DATE(receipt_date) >= '".$from_date."'";
            }
            if(!empty($to_date)) {
                $to_date = date("Y-m-d", strtotime($to_date));
                if(!empty($where)) {
                    $where = $where." AND DATE(receipt_date) <= '".$to_date."'";
                }
                else {
                    $where = "DATE(receipt_date) <= '".$to_date."'";
                }
            }
            if(!empty($agent_id)) {
                if(!empty($where)) {
                    $where = $where." AND agent_id = '".$agent_id."'";
                }
                else {
                    $where = "agent_id = '".$agent_id."'";
                }
            }
            if(!empty($customer_id)) {
                if(!empty($where)) {
                    $where = $where." AND customer_id = '".$customer_id."'";
                }
                else {
                    $where = "customer_id = '".$customer_id."'";
                }
            }
            if(!empty($chit_id)) {
                if(!empty($where)) {
                    $where = $where." AND customer_chit_id = '".$chit_id."'";
                }
                else {
                    $where = "customer_chit_id = '".$chit_id."'";
                }
            }

            if(!empty($where)) {
                $select_query = "SELECT * FROM ".$GLOBALS['receipt_table']." WHERE ".$where." AND deleted = '0' ORDER BY id DESC";
            }
            else {
                $select_query = "SELECT * FROM ".$GLOBALS['receipt_table']." WHERE deleted = '0' ORDER BY id DESC";
            } 
            if(!empty($select_query)) {
                $list = $this->getQueryRecords($GLOBALS['receipt_table'], $select_query);
            }

            return $list;
        }

        // get customer payment list by filters
		public function getCustomerAllPaymentListByFilter($agent_id, $customer_id, $chit_id){
            $where = ""; $select_query = ""; $list = array();

            if(!empty($agent_id)) {
                $where = "agent_id = '".$agent_id."'";
            }
            if(!empty($customer_id)) {
                if(!empty($where)) {
                    $where = $where." AND customer_id = '".$customer_id."'";
                }
                else {
                    $where = "customer_id = '".$customer_id."'";
                }
            }
            if(!empty($chit_id)) {
                if(!empty($where)) {
                    $where = $where." AND customer_chit_id = '".$chit_id."'";
                }
                else {
                    $where = "customer_chit_id = '".$chit_id."'";
                }
            }

            if(!empty($where)) {
                $select_query = "SELECT * FROM ".$GLOBALS['receipt_table']." WHERE ".$where." AND deleted = '0' ORDER BY id ASC";
            }
            else {
                $select_query = "SELECT * FROM ".$GLOBALS['receipt_table']." WHERE deleted = '0' ORDER BY id ASC";
            } 
            if(!empty($select_query)) {
                $list = $this->getQueryRecords($GLOBALS['receipt_table'], $select_query);
            }

            return $list;
        }

        // get approval pending customer chit
		public function getApprovalPendingCustomerChitList() {
            $select_query = ""; $list = array();
            $select_query = "SELECT * FROM ".$GLOBALS['customer_chit_table']." WHERE admin_approval = '0' AND cancelled = '0' AND deleted = '0' ORDER BY id DESC";
            $list = $this->getQueryRecords($GLOBALS['customer_chit_table'], $select_query);
            return $list;
        }

        // get approval pending customer chit merge
		public function getApprovalPendingCustomerChitMergeList() {
            $select_query = ""; $list = array();
            $select_query = "SELECT * FROM ".$GLOBALS['customer_chit_merge_table']." WHERE admin_approval = '0' AND deleted = '0' ORDER BY id DESC";
            $list = $this->getQueryRecords($GLOBALS['customer_chit_merge_table'], $select_query);
            return $list;
        }

        // get approval pending receipt
		public function getApprovalPendingReceiptList() {
            $select_query = ""; $list = array();
            $select_query = "SELECT * FROM ".$GLOBALS['receipt_table']." WHERE admin_approval = '0' AND deleted = '0' ORDER BY id DESC";
            $list = $this->getQueryRecords($GLOBALS['receipt_table'], $select_query);
            return $list;
        }

        // get chit commission
		public function getChitCommissionAmount($agent_id, $customer_id, $chit_id) {
           $commission_amount = 0; $where = ""; $select_query = ""; $list = array();

            if(!empty($agent_id)) {
                $where = "agent_id = '".$agent_id."'";
            }
            if(!empty($customer_id)) {
                if(!empty($where)) {
                    $where = $where." AND customer_id = '".$customer_id."'";
                }
                else {
                    $where = "customer_id = '".$customer_id."'";
                }
            }
            if(!empty($chit_id)) {
                if(!empty($where)) {
                    $where = $where." AND customer_chit_id = '".$chit_id."'";
                }
                else {
                    $where = "customer_chit_id = '".$chit_id."'";
                }
            }

            if(!empty($where)) {
                $select_query = "SELECT commission FROM ".$GLOBALS['customer_chit_table']." WHERE ".$where." AND admin_approval = '1' AND cancelled = '0' AND deleted = '0'";
                $list = $this->getQueryRecords($GLOBALS['customer_chit_table'], $select_query);
                if(!empty($list)) {
                    foreach($list as $data) {
                        if(!empty($data['commission'])) {
                            $commission_amount = $data['commission'];
                        }
                    }
                }
            }

            return $commission_amount;
        }

        // get chit commission unique id
		public function getChitCommissionUniqueID($agent_id, $customer_id, $chit_id) {
            $unique_id = 0; $where = ""; $select_query = ""; $list = array();
 
             if(!empty($agent_id)) {
                 $where = "agent_id = '".$agent_id."'";
             }
             if(!empty($customer_id)) {
                 if(!empty($where)) {
                     $where = $where." AND customer_id = '".$customer_id."'";
                 }
                 else {
                     $where = "customer_id = '".$customer_id."'";
                 }
             }
             if(!empty($chit_id)) {
                 if(!empty($where)) {
                     $where = $where." AND customer_chit_id = '".$chit_id."'";
                 }
                 else {
                     $where = "customer_chit_id = '".$chit_id."'";
                 }
             }
 
             if(!empty($where)) {
                 $select_query = "SELECT id FROM ".$GLOBALS['customer_chit_table']." WHERE ".$where." AND admin_approval = '1' AND cancelled = '0' AND deleted = '0'";
                 $list = $this->getQueryRecords($GLOBALS['customer_chit_table'], $select_query);
                 if(!empty($list)) {
                     foreach($list as $data) {
                         if(!empty($data['id'])) {
                             $unique_id = $data['id'];
                         }
                     }
                 }
             }
 
             return $unique_id;
         }

        // get chit wallet
		public function getChitWalletAmount($agent_id, $customer_id, $chit_id) {
           $wallet_amount = 0; $where = ""; $select_query = ""; $list = array();

            if(!empty($agent_id)) {
                $where = "agent_id = '".$agent_id."'";
            }
            if(!empty($customer_id)) {
                if(!empty($where)) {
                    $where = $where." AND customer_id = '".$customer_id."'";
                }
                else {
                    $where = "customer_id = '".$customer_id."'";
                }
            }
            if(!empty($chit_id)) {
                if(!empty($where)) {
                    $where = $where." AND customer_chit_id = '".$chit_id."'";
                }
                else {
                    $where = "customer_chit_id = '".$chit_id."'";
                }
            }

            if(!empty($where)) {
                $select_query = "SELECT wallet FROM ".$GLOBALS['customer_chit_table']." WHERE ".$where." AND admin_approval = '1' AND cancelled = '0' AND deleted = '0'";
                $list = $this->getQueryRecords($GLOBALS['customer_chit_table'], $select_query);
                if(!empty($list)) {
                    foreach($list as $data) {
                        if(!empty($data['wallet'])) {
                            $wallet_amount = $data['wallet'];
                        }
                    }
                }
            }

            return $wallet_amount;
        }

        // get chit amount to use order
		public function getChitAmountToUseOrder($order_agent_id, $order_customer_id, $agent_id, $customer_id, $chit_id) {
            $amount_to_use_order = 0; $where = ""; $select_query = ""; $list = array();
 
             if(!empty($agent_id)) {
                 $where = "agent_id = '".$agent_id."'";
             }
             if(!empty($customer_id)) {
                 if(!empty($where)) {
                     $where = $where." AND customer_id = '".$customer_id."'";
                 }
                 else {
                     $where = "customer_id = '".$customer_id."'";
                 }
             }
             if(!empty($chit_id)) {
                 if(!empty($where)) {
                     $where = $where." AND customer_chit_id = '".$chit_id."'";
                 }
                 else {
                     $where = "customer_chit_id = '".$chit_id."'";
                 }
             }
 
             if(!empty($where)) {
                $column_name = "";
                if(!empty($order_customer_id) && $order_customer_id != $GLOBALS['null_value']) {
                    $column_name = "amount_to_use_order_customer";
                }    
                else if(!empty($order_agent_id) && $order_agent_id != $GLOBALS['null_value']) {
                    $column_name = "amount_to_use_order_agent";
                }
                $select_query = "SELECT ".$column_name." FROM ".$GLOBALS['customer_chit_table']." WHERE ".$where." AND admin_approval = '1' AND cancelled = '0' AND deleted = '0'";   
                $list = $this->getQueryRecords($GLOBALS['customer_chit_table'], $select_query);
                 if(!empty($list)) {
                     foreach($list as $data) {
                         if(!empty($data[$column_name])) {
                             $amount_to_use_order = $data[$column_name];
                         }
                     }
                 }
             }
 
             return $amount_to_use_order;
         }

        // get recent receipt list
		public function getRecentReceiptList() {
            $select_query = ""; $list = array();
            $select_query = "SELECT * FROM ".$GLOBALS['receipt_table']." WHERE deleted = '0' ORDER BY id DESC LIMIT 15";
            $list = $this->getQueryRecords($GLOBALS['receipt_table'], $select_query);
            return $list;
        }

        // get pending due customer list
		public function getPandingDueCustomerList() {
            $select_query = ""; $list = array();
            $select_query = "SELECT * FROM ".$GLOBALS['customer_chit_table']." WHERE last_paid_date != '0000-00-00' AND admin_approval = '1' AND cancelled = '0' AND deleted = '0' ORDER BY id DESC";
            $list = $this->getQueryRecords($GLOBALS['customer_chit_table'], $select_query);
            return $list;
        }

        // get monthly chit due date list
		public function getMonthlyCustomreChitDueDateList($agent_id, $customer_id) {
            $where = "DATE(next_due_date) >= '".date("Y-m-01")."' AND DATE(next_due_date) <= '".date("Y-m-t")."'"; $select_query = ""; $list = array();
            if(!empty($agent_id)) {
                $where = "agent_id = '".$agent_id."'";
            }
            if(!empty($customer_id)) {
                if(!empty($where)) {
                    $where = $where." AND customer_id = '".$customer_id."'";
                }
                else {
                    $where = "customer_id = '".$customer_id."'";
                }
            }
            if(!empty($where)) {
                $select_query = "SELECT * FROM ".$GLOBALS['customer_chit_table']." WHERE ".$where." AND admin_approval = '1' AND cancelled = '0' AND deleted = '0'";
                $list = $this->getQueryRecords($GLOBALS['customer_chit_table'], $select_query);
            }
            return $list;
        }

        // get monthly receipt list
		public function getMonthlyReceiptList($agent_id, $customer_id, $from_date, $end_date) {
            $where = ""; $select_query = ""; $list = array();
            if(!empty($agent_id)) {
                $where = "agent_id = '".$agent_id."'";
            }
            if(!empty($customer_id)) {
                if(!empty($where)) {
                    $where = $where." AND customer_id = '".$customer_id."'";
                }
                else {
                    $where = "customer_id = '".$customer_id."'";
                }
            }
            if(!empty($from_date)) {
                $from_date = date("Y-m-d", strtotime($from_date));
                if(!empty($where)) {
                    $where = $where." AND DATE(receipt_date) >= '".$from_date."'";
                }
                else {
                    $where = "DATE(receipt_date) >= '".$from_date."'";
                }
            }
            if(!empty($end_date)) {
                $end_date = date("Y-m-d", strtotime($end_date));
                if(!empty($where)) {
                    $where = $where." AND DATE(receipt_date) <= '".$end_date."'";
                }
                else {
                    $where = "DATE(receipt_date) <= '".$end_date."'";
                }
            }
            if(!empty($where)) {
                $select_query = "SELECT * FROM ".$GLOBALS['receipt_table']." WHERE ".$where." AND deleted = '0'";
                $list = $this->getQueryRecords($GLOBALS['receipt_table'], $select_query);
            }
            return $list;
        }

        // check already merge requested
		public function CheckAlreadyMergeRequested($login_user_id, $merge_chit_id) {
            $where = ""; $select_query = ""; $list = array(); $merge_request_id = "";
            $select_query = "SELECT * FROM ".$GLOBALS['customer_chit_merge_table']." 
                                WHERE (creator = '".$login_user_id."' OR customer_chit_unique_number = '".$merge_chit_id."') AND deleted = '0' ORDER BY id DESC";
            if(!empty($select_query)) {
                $list = $this->getQueryRecords($GLOBALS['customer_chit_merge_table'], $select_query);
                if(!empty($list)) {
                    foreach($list as $row) {
                        if(!empty($row['merge_request_id'])) {
                            $merge_request_id = $row['merge_request_id'];
                        }
                    }
                }
            }

            return $merge_request_id;
        }

        // get merge requested customer chit list
		public function getMergeRequestedCustomerChitlist() {
            $select_query = ""; $list = array();
            $select_query = "SELECT m.*, c.chit_details, c.wallet as chit_wallet, cr.name as customer_name, cr.mobile_number as customer_mobile_number,
                                ag.name as agent_name, ag.mobile_number as agent_mobile_number
                                FROM ".$GLOBALS['customer_chit_merge_table']." as m 
                                LEFT JOIN ".$GLOBALS['customer_table']." as cr ON cr.customer_id = m.creator
                                LEFT JOIN ".$GLOBALS['agent_table']." as ag ON ag.agent_id = m.creator
                                INNER JOIN ".$GLOBALS['customer_chit_table']." as c ON c.customer_chit_unique_number = m.customer_chit_unique_number
                            WHERE m.admin_approval = '0' AND m.cancelled = '0' AND m.deleted = '0' ORDER BY m.id DESC";
            if(!empty($select_query)) {
                $list = $this->getQueryRecords($GLOBALS['customer_chit_merge_table'], $select_query);
            }
            return $list;
        }

        // get user have completed chits
		public function CheckUserHaveCompletedChit($login_user_id) {
            $where = ""; $select_query = ""; $customer_have_completed_chits = 0; $chit_count = 0; $completed_chit_count = 0;
            if(!empty($login_user_id)) {
                $customer_unique_id = "";
                $customer_unique_id = $this->getTableColumnValue($GLOBALS['customer_table'], 'customer_id', $login_user_id, 'id');
                if(!empty($customer_unique_id) && preg_match("/^\d+$/", $customer_unique_id)) {
                    $where = "customer_id = '".$login_user_id."'";
                }
                else {
                    $agent_unique_id = "";
                    $agent_unique_id = $this->getTableColumnValue($GLOBALS['agent_table'], 'agent_id', $login_user_id, 'id');
                    if(preg_match("/^\d+$/", $agent_unique_id)) {
                        $where = "agent_id = '".$login_user_id."' AND customer_id = '".$GLOBALS['null_value']."'";
                    }
                }
            }

            if(!empty($where)) {
                $completed_select_query = "SELECT COUNT(id) as completed_chit_count FROM ".$GLOBALS['customer_chit_table']." 
                                    WHERE ".$where." AND completed_date != '0000-00-00' AND order_id = '".$GLOBALS['null_value']."' 
                                    AND admin_approval = '1' AND cancelled = '0' AND deleted = '0'";
            }
			if(!empty($completed_select_query)) {
				$list = $this->getQueryRecords($GLOBALS['customer_chit_table'], $completed_select_query);
				if(!empty($list)) {
					foreach($list as $data) {
						if(!empty($data['completed_chit_count'])) {
							$completed_chit_count = $data['completed_chit_count'];
						}
					}
				}
			}

            $select_query = "";
            if(!empty($where)) {
                $select_query = "SELECT COUNT(id) as chit_count FROM ".$GLOBALS['customer_chit_table']." 
                                        WHERE ".$where." AND order_id = '".$GLOBALS['null_value']."' AND admin_approval = '1' AND cancelled = '0' AND deleted = '0'";
            }
            if(!empty($select_query)) {
                $list = $this->getQueryRecords($GLOBALS['customer_chit_table'], $select_query);
                if(!empty($list)) {
                    foreach($list as $data) {
                        if(!empty($data['chit_count'])) {
                            $chit_count = $data['chit_count'];
                        }
                    }
                }
            }

            //echo "completed_chit_count - ".$completed_chit_count.", chit_count - ".$chit_count; exit;

            if(!empty($completed_chit_count) && !empty($chit_count) && $completed_chit_count == $chit_count) {
				$customer_have_completed_chits = 1;
			}

			return $customer_have_completed_chits;
		}

        // get terminate customer chit list
		public function getTerminateCustomerChitList() {
            $list = array();
            $select_query = "SELECT c.*, (SELECT receipt_date FROM ".$GLOBALS['receipt_table']." as r 
                            WHERE r.customer_chit_id = c.customer_chit_id AND r.deleted = '0' GROUP BY r.customer_chit_id ORDER BY r.id DESC LIMIT 1) 
                            as last_paid_date FROM ".$GLOBALS['customer_chit_table']." as c
                            WHERE c.cancelled = '1' AND c.cancel_date != '0000-00-00' AND c.deleted = '0' ORDER BY c.cancel_date ASC";
            $list = $this->getQueryRecords($GLOBALS['customer_chit_table'], $select_query);
            return $list;
        }
    }
?>