<?php 
	include("include_user_check.php");
    
	$project_title = "";
	$project_title = $obj->getProjectTitle();

    $page_title = "Product Pricelist";

    $pricelist = array();
    $pricelist = $obj->ProductPricelist('1');
?>
<!DOCTYPE html>
<html lang="en">
    <script type="text/javascript" src="include/js/xlsx.full.min.js"></script>
    <head>
        <title> <?php if(!empty($project_title)) { echo $project_title; } ?> - <?php if(!empty($page_title)) { echo $page_title; } ?> </title>
        <?php include "link_style_script.php"; ?>
    </head>
    <body>
	<?php include "header.php";  ?>
	<!-- sidebar-wrapper  -->          
	<div class="page-wrapper chiller-theme toggled">
		<main class="page-content">
			<div class="container-fluid px-lg-5">
				<div class="border card-box">

                    <div class="card-header">              
                        <div class="row">
                            <div class="col-sm-5 text-center text-sm-left">
                                <h5 class="headfnt"><?php if(!empty($page_title)) { echo $page_title; } ?></h5>
                            </div>
                            <div class="col-sm-4 search_text"></div>
                            <div class="col-sm-3 text-center text-sm-right">
                                <button class="btn btn-dark poppins" style="font-size:11px;" type="button" onClick="table2excel('table2excel_table','Price List')"> <i class="fa fa-download"></i> &ensp; Download</button>
                                &nbsp; <a class="btn btn-danger poppins" style="font-size:11px;" href="product.php">Back</a>
                            </div>
                        </div>
                    </div>
					
					<div class="table-responsive px-3 py-3">
                        <table id="table2excel_table" cellpadding="0" cellspacing="0" class="report_table" style="width: 100%;">
                            <tbody>
                                <?php
                                    if(!empty($pricelist)) {
                                        foreach($pricelist as $data) {
                                            if(!empty($data['category_name'])) { ?>
                                                <tr>
                                                    <td style="padding: 5px; border: 1px solid #000; text-align: center; width: 100px; font-size: 12px;"></td>
                                                    <td style="padding: 5px 10px; border: 1px solid #000; border-left: none; font-size: 12px; text-transform: uppercase;">
                                                        <?php
                                                            if(!empty($data['category_name'])) {
                                                                $data['category_name'] = $obj->encode_decode('decrypt', $data['category_name']);
                                                                echo $data['category_name'];
                                                            }
                                                        ?>
                                                    </td>
                                                    <td style="padding: 5px; border: 1px solid #000; border-left: none; text-align: center; width: 100px; font-size: 12px;"></td>
                                                    <td style="padding: 5px; border: 1px solid #000; border-left: none; text-align: center; width: 125px; font-size: 12px;"></td>
                                                </tr>
                                                <?php          
                                                if(!empty($data['product_list'])) {
                                                    foreach($data['product_list'] as $key => $product) {
                                                        if(!empty($product['name'])) { ?>
                                                            <tr>
                                                                <td style="padding: 5px; border: 1px solid #000; text-align: center; width: 100px; font-size: 12px;">
                                                                    <?php
                                                                        if(!empty($product['product_code'])) {
                                                                            $product['product_code'] = $obj->encode_decode('decrypt', $product['product_code']);
                                                                            echo $product['product_code'];
                                                                        }
                                                                    ?>
                                                                </td>
                                                                <td style="padding: 5px 10px; border: 1px solid #000; border-left: none; font-size: 12px;">
                                                                    <?php
                                                                        if(!empty($product['name'])) {
                                                                            $product['name'] = $obj->encode_decode('decrypt', $product['name']);
                                                                            $product['name'] = str_replace("$", '"', $product['name']);
                                                                            echo $product['name'];
                                                                        }
                                                                    ?>
                                                                </td>
                                                                <td style="padding: 5px; border: 1px solid #000; border-left: none; text-align: center; width: 100px; font-size: 12px;">
                                                                    <?php
                                                                        if(!empty($product['product_content'])) {
                                                                            $product['product_content'] = $obj->encode_decode('decrypt', $product['product_content']);
                                                                            echo $product['product_content'];
                                                                        }
                                                                    ?>
                                                                </td>
                                                                <td style="padding: 5px; border: 1px solid #000; border-left: none; text-align: center; width: 125px; font-size: 12px;">
                                                                    <?php if(!empty($product['price'])) { echo number_format($product['price'], 2); } ?>
                                                                </td>
                                                            </tr>
                                                            <?php                            
                                                        }
                                                    }
                                                }      
                                            }
                                        }
                                    }
                                    else { ?>
                                        <tr>
                                            <td colspan="4" style="padding: 5px; border: 1px solid #000; text-align: center;">Sorry! No products found</td>
                                        </tr>
                                        <?php        
                                    }
                                ?>
                            </tbody>
                        </table>
                    </div>

				</div>
			</div>
		</main>
	</div>  
	<!-- page-wrapper -->

	<script>
		jQuery(document).ready(function(){
			jQuery("#productactive").addClass("active");
		});
	</script>
    <script type="text/javascript">		
		function print_preview_content() {
			prepare_report_preview();
		}
		
		function table2excel(table, name) {
            var uri = 'data:application/vnd.ms-excel;base64,'
                ,
                template = '<html xmlns:o="urn:schemas-microsoft-com:office:office" xmlns:x="urn:schemas-microsoft-com:office:excel" xmlns="http://www.w3.org/TR/REC-html40"><meta http-equiv="content-type" content="application/vnd.ms-excel; charset=UTF-8"><head><!--[if gte mso 9]><xml><x:ExcelWorkbook><x:ExcelWorksheets><x:ExcelWorksheet><x:Name>{worksheet}</x:Name><x:WorksheetOptions><x:DisplayGridlines/></x:WorksheetOptions></x:ExcelWorksheet></x:ExcelWorksheets></x:ExcelWorkbook></xml><![endif]--></head><body><table>{table}</table></body></html>'
                , base64 = function (s) {
                    return window.btoa(unescape(encodeURIComponent(s)))
                }
                , format = function (s, c) {
                    return s.replace(/{(\w+)}/g, function (m, p) {
                        return c[p];
                    })
                }
            if (!table.nodeType) table = document.getElementById(table)
            var ctx = {worksheet: name || 'Worksheet', table: table.innerHTML}
            var a = document.createElement('a');
            a.href = uri + base64(format(template, ctx))
            a.download = name+'.xls';
            //triggering the function
            a.click();
		}
        // function ExportToExcel(type, fn, dl) {
        //     var elt = document.getElementById('table2excel_table');
        //     var wb = XLSX.utils.table_to_book(elt, { sheet: "sheet1" });
        //     return dl ?
        //         XLSX.write(wb, { bookType: type, bookSST: true, type: 'base64' }):
        //         XLSX.writeFile(wb, fn || ('price_list.' + (type || 'xlsx')));
        // }
	</script>

	<?php include "footer.php"; ?>

    </body>
</html>