var price_regex = /^(\d*\.)?\d+$/;
var numbers_regex = /^\d+$/;

function CheckDecimal(check_number) {
	if(check_number != '' && check_number != 0) {				
		var decimal = ""; var numbers = "";
		numbers = check_number.toString().split('.');							
		if( typeof numbers[1] != 'undefined') {
			decimal = numbers[1];
			if(decimal != "" && decimal != 00) {						
				if(decimal.length == 1) {
					decimal = decimal+'0';
					check_number = numbers[0]+'.'+decimal;
				}
				if(decimal.length > 2) {
					check_number = check_number.toFixed(2);
				}
			}
			else {
				check_number = numbers[0]+'.00';
			}
		}
	}
	return check_number;
}

function CalProductAmount(product_id, quantity, add) {
    var all_errors_check = 1;

    if(add == ""){
        var selected_quantity = "";
        selected_quantity = quantity;
        selected_quantity = selected_quantity.replace(/ /g,'');
        jQuery('.qty_box_'+product_id).val(selected_quantity);
        selected_quantity = selected_quantity.trim();
        if(selected_quantity.charAt(0) == 0) {
            selected_quantity = selected_quantity.slice(1);
            selected_quantity = selected_quantity.trim();
        }
    }
	else{
        selected_quantity = 1;
        jQuery(".add_button_"+product_id).addClass('d-none');
        jQuery(".quantity_box_"+product_id).removeClass('d-none');
        jQuery('.qty_box_'+product_id).val("1");
    }
    
    if (typeof selected_quantity != "undefined" && selected_quantity != "" && selected_quantity != 0) {
        if(numbers_regex.test(selected_quantity) == false) {
            all_errors_check = 0;
        }
        else {
            if(parseInt(selected_quantity) >= 10000) {
                selected_quantity = 1;
            }
        }
    }
    else {
        all_errors_check = 0;
    }
    
    if(all_errors_check == 1) {
        if((parseInt(selected_quantity) > 0 && numbers_regex.test(selected_quantity) == true)) {
            if(jQuery('.product_name_'+product_id).length > 0) {
                if(typeof product_id != "undefined" && product_id != "") {
                    if(jQuery('form[name="order_form"]').find('.product'+product_id).length > 0) {
                        jQuery('form[name="order_form"]').find('.product'+product_id).val(product_id+'/'+selected_quantity);
                    }
                    else {
                        jQuery('form[name="order_form"]').append('<input type="hidden" name="product_quantity[]" class="product_quantity product'+product_id+'" value="'+product_id+'/'+selected_quantity+'"> ');
                    } 
                    
                };
            }
        }
        else {
            if(jQuery('.product_name_'+product_id).length > 0) {
                var product_id = "";
                product_id = jQuery('.product_name_'+product_id).attr('id');
                if(typeof product_id != "undefined" && product_id != "") {
                    if(jQuery('.quantity_'+product_id).length > 0) {
                        jQuery('.quantity_'+product_id).html('');
                    }
                    if(jQuery('.product'+product_id).length > 0) {
                        jQuery('.product'+product_id).remove();
                    }
                }
            }    
        }
    }
    else {
        if(jQuery('.product_name_'+product_id).length > 0) {
            var product_id = "";
            product_id = jQuery('.product_name_'+product_id).attr('id');
            if(typeof product_id != "undefined" && product_id != "") {
                if(jQuery('.amount_'+product_id).length > 0) {
                    jQuery('.amount_'+product_id).find('input[type="text"]').val('');
                }
                if(jQuery('.quantity_'+product_id).length > 0) {
                    jQuery('.quantity_'+product_id).html('');
                }
                if(jQuery('.product'+product_id).length > 0) {
                    jQuery('.product'+product_id).remove();
                }
            }
        }
    }   
    
    calOverallTotal();
}

function calOverallTotal() {
	var net_total=0; var product_count = 0;
	
    if(jQuery('.product_row').length > 0) {
        var i = 1;
		jQuery('.product_row').each(function(){
            var product_id = "";
            product_id = jQuery('#product_name_'+i).val();
            var actual_price = "";
            jQuery(this).removeClass('card-highlight')
            if(jQuery(this).find('.price').length > 0) {
                actual_price = jQuery(this).find('.price').html();
                actual_price = actual_price.replace(/ /g,'');
                actual_price = actual_price.replace(/,/g,'');
                actual_price = actual_price.trim();
                if(price_regex.test(actual_price) != false) {
                    actual_price = actual_price;
                }
            }

            var qty = "";
            if(jQuery('.qty_box_'+product_id).length > 0 && jQuery(".add_button_"+product_id).hasClass('d-none')) {
                qty = jQuery('.qty_box_'+product_id).val();
                qty = qty.replace(/ /g,'');
                qty = qty.replace(/,/g,'');
                qty = qty.trim();
                if(price_regex.test(qty) != false) {
                    net_amount = parseFloat(actual_price) * parseFloat(qty);
                    net_total = parseFloat(net_total) + parseFloat(net_amount);
                    product_count++;
                }
            }
            i++;            
        });
        if(jQuery('.net_total').length > 0) {
            net_total = CheckDecimal(net_total);
            jQuery('.net_total').html('Rs.'+net_total);
        }
        if(jQuery('.total_price').length > 0) {
            net_total = CheckDecimal(net_total);
            jQuery('.total_price').html('Rs.'+net_total);
        }
        if(jQuery('.product_count').length > 0) {
            jQuery('.product_count').html(product_count);
            jQuery('.span_product_count').html(product_count)
        }
    }

    var selected_product = '';
    jQuery('form[name="order_form"]').find('.product_quantity').each(function(){
        if(selected_product == ""){
            selected_product = jQuery(this).val();
        }else{
            selected_product = selected_product+'$$$'+jQuery(this).val();
        }
    });

    if(i == 1){
        selected_product = "";
    }

    var post_url = "cart_changes.php?selected_product="+selected_product;
    jQuery.ajax({url: post_url, success: function(result){
        if(result != '')
        success = 1;
    }});
}

function add_quantity(product_id){
    if(jQuery('input[name="'+product_id+'"]').length > 0) {
        product_quantity = jQuery('input[name="'+product_id+'"]').val();
        jQuery('input[name="'+product_id+'"]').val(parseInt(product_quantity)+1);
        CalProductAmount(product_id,jQuery('input[name="'+product_id+'"]').val(),'');
    }
}

function remove_quantity(product_id){
    if(jQuery('input[name="'+product_id+'"]').length > 0) {
        product_quantity = jQuery('input[name="'+product_id+'"]').val();
        if(product_quantity > 0){
            jQuery('input[name="'+product_id+'"]').val(parseInt(product_quantity)-1);
        }
        product_quantity = jQuery('input[name="'+product_id+'"]').val()
        if(product_quantity == 0) {
            jQuery('input[name="'+product_id+'"]').val('');
            jQuery(".add_button_"+product_id).removeClass('d-none');
            jQuery(".quantity_box_"+product_id).addClass('d-none');
        }

        var product_count = 0;
        if(jQuery('.product-box').length > 0) {
            product_count = jQuery('.product-box').length;
        }
        if(jQuery('.product_count').length > 0) {
            jQuery('.product_count').html(product_count);
            jQuery('.span_product_count').html(product_count)
        }

        CalProductAmount(product_id,jQuery('input[name="'+product_id+'"]').val(),'');
    }
}

function view_cart(type){
    var post_url = "cart_changes.php?add_cart=1&type="+type;
    jQuery.ajax({url: post_url, success: function(result){
        if(result != ''){
            if($("#"+type+"_navigation").length > 0) {
                $("#"+type+"_navigation").html(result);
            }
        }
    }});
}

function remove_product(product_id){
    if(jQuery('input[name="'+product_id+'"]').length > 0) {
        
        $(".product_row_"+product_id).remove();
        jQuery('input[name="'+product_id+'"]').val(0);

        if(jQuery('.quantity_'+product_id).length > 0) {
            jQuery('.quantity_'+product_id).html('');
        }
        if(jQuery('.product'+product_id).length > 0) {
            jQuery('.product'+product_id).remove();
        }

        remove_quantity(product_id);
        // calOverallTotal();
    }
}

function SaveOrder(event) {
    event.preventDefault();
    var form_name = "order_form";
    SubmitOrder(form_name);
}

function SubmitOrder(form_name) {    
    if(jQuery('div.alert').length > 0) {
        jQuery('div.alert').remove();
    }
    if(jQuery('span.infos').length > 0) {
        jQuery('span.infos').each(function(){ jQuery(this).remove(); });
    }
    jQuery('form[name="'+form_name+'"]').find('.row:first').before('<div class="alert alert-danger mb-3"> <button type="button" class="close" data-dismiss="alert">&times;</button> Processing </div>');
    if(jQuery('form[name="'+form_name+'"]').find('.submit_button').length > 0) {
        jQuery('form[name="'+form_name+'"]').find('.submit_button').attr('disabled', true);
    }
    if(jQuery('.grid_products').length > 0) {
        jQuery('#navigation').animate({
            scrollTop: (jQuery('body').offset().top)
        }, 500);
    }
    else {
        jQuery('html, body').animate({
            scrollTop: (jQuery('form[name="'+form_name+'"]').offset().top)
        }, 500);
    }

    jQuery.ajax({
        url: 'order_changes.php',
        type: "post",
        async: true,
        data: jQuery('form[name="'+form_name+'"]').serialize(),
        dataType: 'html',
        contentType: 'application/x-www-form-urlencoded; charset=UTF-8',
        success: function(data) {
            //console.log(data);
            try {
                var x = JSON.parse(data);
            } catch (e) {
                return false;
            }
            //console.log(x);
            
            if(jQuery('span.infos').length > 0) {
                jQuery('span.infos').remove();
            }
            if(jQuery('.valid_error').length > 0) {
                jQuery('.valid_error').remove();
            }
            if(jQuery('div.alert').length > 0) {
                jQuery('div.alert').remove();
            }
            
            if(x.number == '1') {
                jQuery('form[name="'+form_name+'"]').find('.row:first').before('<div class="alert alert-success"> <button type="button" class="close" data-dismiss="alert">&times;</button> '+x.msg+' </div>');
                setTimeout(function(){
                    window.location = "booking.php";
                }, 1000);
            }
            
            if(x.number == '2') {
                jQuery('form[name="'+form_name+'"]').find('.row:first').before('<div class="alert alert-danger"> <button type="button" class="close" data-dismiss="alert">&times;</button> '+x.msg+' </div>');
                if(jQuery('form[name="'+form_name+'"]').find('.submit_button').length > 0) {
                    jQuery('form[name="'+form_name+'"]').find('.submit_button').attr('disabled', false);
                }
            }
            
            if(x.number == '3') {
                jQuery('form[name="'+form_name+'"]').append('<div class="valid_error"> <script type="text/javascript"> '+x.msg+' </script> </div>');
                if(jQuery('form[name="'+form_name+'"]').find('.submit_button').length > 0) {
                    jQuery('form[name="'+form_name+'"]').find('.submit_button').attr('disabled', false);
                }
            }
        },
        error: function(jqXHR, textStatus, errorThrown) {
            console.log(textStatus, errorThrown);
        }
    });
}

function category_mobile_scroll(category_id){
    jQuery("input[id = 'search_text']").val('');
    search_mobile_product('');
    jQuery('#show_products').removeClass('d-none');
    jQuery('html, body').animate({
        scrollTop: (jQuery('div[id="mobile_'+category_id+'"]').offset().top)
    }, 500);
    $(".close_modal").click();
}

function category_tab_scroll(category_id){
    jQuery("input [name = 'search_text']").val('');
    jQuery('html, body').animate({
        scrollTop: (jQuery('div[id="tab_'+category_id+'"]').offset().top)
    }, 500);
    $(".close_modal").click();
}

function category_scroll(category_id){
    jQuery("input [name = 'search_text']").val('');
    jQuery('html, body').animate({
        scrollTop: (jQuery('div[id="'+category_id+'"]').offset().top)
    }, 500);
    $(".close_modal").click();
}

function search_product(filter){
    jQuery('#show_products').removeClass('d-none');
    jQuery('.product_row').each(function(){
        var product_name = "";
        product_name = jQuery(this).find('#product_name').val();
        if (product_name.toUpperCase().indexOf(filter.toUpperCase()) > -1) {
            jQuery(this).addClass('card-highlight')
            jQuery('html, body').animate({
                scrollTop: (jQuery(this).offset().top)
            }, 500);
        }
        else{
            jQuery(this).removeClass('card-highlight')
        }
    });

    if(filter!=''){
        $(".visible_tooltip").addClass('d-none');
        $(".search_text").val("");
        // $("#show_product_list").hide()
        if(jQuery('.mobile').is(":visible")){
            if($(".category_box").length > 0){
                $(".category_box").addClass('d-none')
            }
        }
    }
    else{
        if($(".category_box").length > 0){
            $(".category_box").removeClass('d-none')
        }
    }
}

function search_mobile_product(filter){
    jQuery('#show_products').removeClass('d-none');
    jQuery('.product_row').each(function(){
        var product_name = "";
        product_name = jQuery(this).find('#product_name').val();
        if (product_name.toUpperCase().indexOf(filter.toUpperCase()) > -1) {
            jQuery(this).removeClass('d-none')
        }
        else{
            jQuery(this).addClass('d-none')
        }
    });

    if(filter!=''){
        $(".visible_tooltip").addClass('d-none');
        $(".search_text").val("");
        // $("#show_product_list").hide()
        if(jQuery('.mobile').is(":visible")){
            if($(".category_box").length > 0){
                $(".category_box").addClass('d-none')
            }
        }
    }
    else{
        if($(".category_box").length > 0){
            $(".category_box").removeClass('d-none')
        }
    }
}

function trigger_search_box(){
    if($("#search_span").hasClass('visibletooltip')){
        $("#search_box").removeClass('visibletooltip');
    }
    else{
        $("#search_box").addClass('visibletooltip');
    }
}

function ShowProductImageVideo(obj, view_type) {
    var img_src = ""; var img_title = ""; var video_id = "";
    img_src = jQuery(obj).attr('src');
    img_title = jQuery(obj).attr('title');
    img_title = img_title.trim();
    
    video_id = jQuery(obj).parent().find('input[id="product_video"]').val();
    video_id = video_id.trim();
    if(typeof img_src != "undefined" && img_src != "") {
        if(typeof img_title != "undefined" && img_title != "") {
            if(jQuery('#'+view_type+'_image_modal').length > 0) {
                if(jQuery('#'+view_type+'_image_modal').find('.modal-header').find('h4').length > 0) {
                    jQuery('#'+view_type+'_image_modal').find('.modal-header').find('h4').html(img_title);
                }
                if(jQuery('#'+view_type+'_image_modal').find('.modal-body').find('.image_video').length > 0) {
                    jQuery('#'+view_type+'_image_modal').find('.modal-body').find('.image_video').html('<img src="'+img_src+'" class="img-fluid">');
                }
                if(jQuery('#'+view_type+'_image_modal').find('.modal-body').find('.image_column').find('img').length > 0) {
                    jQuery('#'+view_type+'_image_modal').find('.modal-body').find('.image_column').find('img').attr('src', img_src);
                }

                if(jQuery('.sub_image_row').length > 0) {
                    jQuery('.sub_image_row').each(function() {
                        jQuery(this).remove();
                    });
                }

                if(jQuery(obj).parent().find('input[name="sub_images"]').length > 0) {
                    if(jQuery('#'+view_type+'_image_modal').find('.modal-body').find('.image_video').length > 0) {
                        jQuery('#'+view_type+'_image_modal').find('.modal-body').find('.image_video').attr('colspan', '4');
                    }
                    jQuery(obj).parent().find('input[name="sub_images"]').each(function(){
                        var sub_image = "";
                        sub_image = jQuery(this).val();
                        sub_image = jQuery.trim(sub_image);
                        if(typeof sub_image != "undefined" && sub_image != null && sub_image != "") {
                            if(jQuery('#'+view_type+'_image_modal').find('.modal-body').find('.image_column').length > 0) {
                                jQuery('#'+view_type+'_image_modal').find('.modal-body').find('.image_column:last').after('<td class="text-center sub_image_row image_column" style="width: 25%; height: 100px; padding: 5px; cursor: pointer;"><img src="'+sub_image+'" class="img-fluid" alt="Crackers" title="Crackers" onClick="Javascript:ShowProductImage(this);"></td>');
                            } 
                        }
                    });
                }

                if(typeof video_id != "undefined" && video_id != "") {
                    if(jQuery('#'+view_type+'_image_modal').find('.modal-body').find('.video_column').length > 0) {
                        jQuery('#'+view_type+'_image_modal').find('.modal-body').find('.video_column').css({'display' : "table-cell"});
                    }
                    if(jQuery('#'+view_type+'_image_modal').find('.modal-body').find('.video_column').find('img').length > 0) {
                        jQuery('#'+view_type+'_image_modal').find('.modal-body').find('.video_column').find('img').attr('id', video_id);
                    }
                }
                // else {
                //     if(jQuery('#'+view_type+'_image_modal').find('.modal-body').find('.video_column').length > 0) {
                //         jQuery('#'+view_type+'_image_modal').find('.modal-body').find('.video_column').css({'display' : "none"});
                //     }
                //     if(jQuery('#'+view_type+'_image_modal').find('.modal-body').find('.video_column').find('img').length > 0) {
                //         jQuery('#'+view_type+'_image_modal').find('.modal-body').find('.video_column').find('img').attr('id', '');
                //     }
                // }

                if(jQuery('.'+view_type+'_image_video_popup').length > 0) {
                    jQuery('.'+view_type+'_image_video_popup').trigger('click');
                }
            }
        }
    }
}

function ShowProductImage(obj,view_type) {
    var img_src = "";
    img_src = jQuery(obj).attr('src');
    if(typeof img_src != "undefined" && img_src != "") {
        if(jQuery('#'+view_type+'_image_modal').length > 0) {
            if(jQuery('#'+view_type+'_image_modal').find('.modal-body').find('.image_video').length > 0) {
                jQuery('#'+view_type+'_image_modal').find('.modal-body').find('.image_video').html('<img src="'+img_src+'" class="img-fluid">');
            }
        }
    }
}
function ShowProductVideo(obj,view_type) {
    var video_id = "";
    video_id = jQuery(obj).attr('id');
    video_id = video_id.trim();
    if(typeof video_id != "undefined" && video_id != "") {
        if(jQuery('#'+view_type+'_image_modal').find('.modal-body').find('.image_video').length > 0) {
            jQuery('#'+view_type+'_image_modal').find('.modal-body').find('.image_video').html('<iframe width="100%" height="300" src="https://www.youtube.com/embed/'+video_id+'" title="YouTube video player" frameborder="0" allow="accelerometer; autoplay; clipboard-write; encrypted-media; gyroscope; picture-in-picture" allowfullscreen></iframe>');
        }
    }
}

function CloseImageVideoPopup(view_type) {
    if(jQuery('#'+view_type+'_image_modal').find('.modal-body').find('.image_video').length > 0) {
        jQuery('#'+view_type+'_image_modal').find('.modal-body').find('.image_video').html('');
    }
    if(jQuery('#'+view_type+'_image_modal').find('.modal-header').find('button.close').length > 0) {
        jQuery('#'+view_type+'_image_modal').find('.modal-header').find('button.close').trigger('click');
    }
}

function show_search_box(type){
    $(".visible_tooltip").removeClass('d-none');
    jQuery('#show_'+type+'_product_list').hide();
}

function show_products_filter(filter_value, view_type) {
    var filter = "";
	filter = filter_value.toUpperCase();
    if(filter != '') {
		jQuery('#show_'+view_type+'_product_list').show();
		div = document.getElementById("show_"+view_type+"_product_list");
		li = document.getElementsByClassName('search_product');
        var search_product = jQuery('.search_product');

        jQuery('.search_product').each(function(){
            var a = jQuery(this).find('.filtered_product').html();
            if (a.toUpperCase().indexOf(filter.toUpperCase()) > -1) {
                this.classList.remove("d-none")
                this.classList.add("d-flex")
			} else {
                this.classList.add("d-none")
                this.classList.remove("d-flex")
			}
        });
	}
	else
		jQuery('#show_'+view_type+'_product_list').hide();
}

function close_cart_modal(){
    jQuery('body').removeClass('nav-open');
}

function show_wallet(){
    $(".wallet_div").show();
}