var price_regex = /^(\d*\.)?\d+$/;
var numbers_regex = /^\d+$/;

function AddCity() {
	if(jQuery('#CityModal .modal-body').find('.infos').length > 0) {
		jQuery('#CityModal .modal-body').find('.infos').remove();
	}
	if(jQuery('#CityModal .modal-body').find('.alert').length > 0) {
		jQuery('#CityModal .modal-body').find('.alert').remove();
	}

	if(jQuery('input[name="city_name"]').length > 0) {
		jQuery('input[name="city_name"]').val('');
	}
	if(jQuery('.state_name').length > 0) {
		jQuery('.state_name').html('');
	}
	if(jQuery('input[name="state_name"]').length > 0) {
		jQuery('input[name="state_name"]').val('');
	}
	if(jQuery('select[name="state"]').length > 0) {
		state_name = jQuery('select[name="state"]').val();
		state_name = jQuery.trim(state_name);
		if(jQuery('.state_name').length > 0) {
			jQuery('.state_name').html(state_name);
		}
		if(jQuery('input[name="state_name"]').length > 0) {
			jQuery('input[name="state_name"]').val(state_name);
		}
	}
	if(jQuery('.city_modal_button').length > 0) {
		jQuery('.city_modal_button').trigger('click');
	}
}
function SaveCity() {

	if(jQuery('#CityModal .modal-body').find('.infos').length > 0) {
		jQuery('#CityModal .modal-body').find('.infos').remove();
	}
	if(jQuery('#CityModal .modal-body').find('.alert').length > 0) {
		jQuery('#CityModal .modal-body').find('.alert').remove();
	}

	jQuery.ajax({
		url: 'action_changes.php',
		type: "post",
		async: true,
		data: jQuery('form[name="city_form"]').serialize(),
		dataType: 'html',
		contentType: 'application/x-www-form-urlencoded; charset=UTF-8',
		success: function(result) {
			jQuery('#CityModal .modal-content').animate({ scrollTop: 0 }, 500);
			if(numbers_regex.test(result) == true) {
				jQuery('#CityModal .modal-body').append('<div class="alert alert-success"> <button type="button" class="close" data-dismiss="alert">&times;</button> Successfully Updated </div>');
				setTimeout(function(){ 
					jQuery('#CityModal .modal-header .close').trigger("click");

					var state_name = "";
					if(jQuery('select[name="state"]').length > 0) {
						state_name = jQuery('select[name="state"]').val();
						state_name = jQuery.trim(state_name);					
					}
					if(jQuery('input[name="city_insert_id"]').length > 0) {
						jQuery('input[name="city_insert_id"]').val(result);
					}
					ReloadCity(state_name);
					
				}, 1000);
				
			}
			else {
				jQuery('#CityModal .modal-body').append('<span class="infos w-100 text-center" style="font-size: 15px; font-weight: bold;">'+result+'</span>');
			}
		},
		error: function(jqXHR, textStatus, errorThrown) {
			console.log(textStatus, errorThrown);
		}
	});
}
function ReloadCity(state_name) {
	if(jQuery('#CityModal .modal-body').find('.infos').length > 0) {
		jQuery('#CityModal .modal-body').find('.infos').remove();
	}
	if(jQuery('#CityModal .modal-body').find('.alert').length > 0) {
		jQuery('#CityModal .modal-body').find('.alert').remove();
	}

	var city_insert_id = "";
	if(jQuery('input[name="city_insert_id"]').length > 0) {
		city_insert_id = jQuery('input[name="city_insert_id"]').val();
	}

	var post_url = "action_changes.php?reload_city_id="+city_insert_id+"&reload_state_name="+state_name;	
	jQuery.ajax({url: post_url, success: function(result){
		if(jQuery('#city_list_cover').length > 0) {
			jQuery('#city_list_cover').html(result);
		}
	}});
}
function CancelCity() {
	if(jQuery('#CityModal .modal-body').find('.infos').length > 0) {
		jQuery('#CityModal .modal-body').find('.infos').remove();
	}
	if(jQuery('#CityModal .modal-body').find('.alert').length > 0) {
		jQuery('#CityModal .modal-body').find('.alert').remove();
	}
	
	jQuery('#CityModal .modal-header .close').trigger("click"); 
}

function getMonthlyReceiptsByCalendar() {
    var check_login_session = 1;
    var post_url = "dashboard_changes.php?check_login_session=1";	
    jQuery.ajax({url: post_url, success: function(check_login_session){
        if(check_login_session == 1) {
            jQuery('#monthly_receipts_cover').fullCalendar('removeEvents');

            var calendar_month_year = "";
            if(jQuery('.fc-toolbar').find('.fc-left').find('h2').length > 0) {
                calendar_month_year = jQuery('.fc-toolbar').find('.fc-left').find('h2').html();
                calendar_month_year = jQuery.trim(calendar_month_year);
            }

            var post_url = "dashboard_changes.php?get_monthly_receipts=1&calendar_month_year="+calendar_month_year;
            jQuery.ajax({url: post_url, success: function(monthly_receipts){
                monthly_receipts = jQuery.trim(monthly_receipts);
                if(typeof monthly_receipts != "undefined" && monthly_receipts != null && monthly_receipts != "") {
                    monthly_receipts = JSON.parse(monthly_receipts);
                    if(monthly_receipts.length > 0) {              
                        jQuery.each(monthly_receipts, function(index, row) {
                            //console.log(row.title);
                            if(typeof row.title != "undefined" && row.title != null && row.title != "") {
                                if(typeof row.start != "undefined" && row.start != null && row.start != "") {
									if(typeof row.backgroundColor != "undefined" && row.backgroundColor != null && row.backgroundColor != "") {
										if(typeof row.receipt_id != "undefined" && row.receipt_id != null && row.receipt_id != "") {
											receipt = {title: row.title, start: row.start, backgroundColor: row.backgroundColor, receipt_id:row.receipt_id};
											//console.log(receipt);
											$('#monthly_receipts_cover').fullCalendar( 'renderEvent', receipt, true);
										}
									}
                                }
                            }
                        });
                    }
                }

            }});
        }
        else {
            window.location.reload();
        }
    }});
}

function MakePaymentAll(payment_customer_chit_id) {
	if(typeof payment_customer_chit_id != "undefined" && payment_customer_chit_id != null && payment_customer_chit_id != "") {
		if(jQuery('#collapse'+payment_customer_chit_id).length > 0) {
			//console.log('checkbox length - '+jQuery('#collapse'+payment_customer_chit_id).find('input[name="payment_checkbox"]').length);
			if(jQuery('#collapse'+payment_customer_chit_id).find('input[name="payment_checkbox"]').not(':disabled').length > 0) {
				var numberOfChecked = 0;
				numberOfChecked = jQuery('#collapse'+payment_customer_chit_id).find('input[name="payment_checkbox"]:checked').not(':disabled').length;
				//console.log('numberOfChecked - '+numberOfChecked);
				MakePayment(numberOfChecked, payment_customer_chit_id);
			}
		}
	}
}

function MakePayment(due_count, customer_chit_id) {
	jQuery('#PaymentModal .modal-body').html('');
	var check_login_session = 1;
	var post_url = "dashboard_changes.php?check_login_session=1";	
	jQuery.ajax({url: post_url, success: function(check_login_session){
		if(check_login_session == 1) {
			if(numbers_regex.test(due_count) == true) {
				if(typeof customer_chit_id != "undefined" && customer_chit_id != null && customer_chit_id != "") {

					var agent_customer_id = "";
					if(jQuery('select[name="agent_customer_id"]').length > 0) {
						agent_customer_id = jQuery('select[name="agent_customer_id"]').val();
						agent_customer_id = jQuery.trim(agent_customer_id);
					}

					var post_url = "action_changes.php?payment_due_count="+due_count+"&payment_customer_chit_id="+customer_chit_id+"&payment_customer_id="+agent_customer_id;	
					jQuery.ajax({url: post_url, success: function(result){
						jQuery('#PaymentModal .modal-body').html(result);
						jQuery('.payment_modal_button').trigger('click');
					}});
				}
			}
		}
		else {
			window.location.reload();
		}
	}}); 
}
function getTransferDetails() {
	if(jQuery('#transaction_details').length > 0) {
		jQuery('#transaction_details').addClass('d-none');
	}
	if(jQuery('select[name="payment_mode"]').length > 0) {
		var payment_mode = "";
		payment_mode = jQuery('select[name="payment_mode"]').find('option:selected').text();
		payment_mode = jQuery.trim(payment_mode);
		if(typeof payment_mode != "undefined" && payment_mode != null && payment_mode != "" && payment_mode != "Select") {
			if(payment_mode != "Cash") {
				if(jQuery('#transaction_details').length > 0) {
					jQuery('#transaction_details').removeClass('d-none');
				}
			}
		}
	}
}
function ChangePaymentOption(obj) {
	var payment_option = "";
	if(jQuery(obj).find('input[type="radio"]').length > 0) {
		payment_option = jQuery(obj).find('input[type="radio"]').val();
		payment_option = jQuery.trim(payment_option);
	}
	if(numbers_regex.test(payment_option) == false) {
		payment_option = 1;
	}
	var due_amount = ""; var penalty_amount = ""; var receipt_amount = "";
	if(jQuery('.due_amount').length > 0) {
		due_amount = jQuery('.due_amount').html();
		due_amount = jQuery.trim(due_amount);
	}	
	if(jQuery('.penalty_amount').length > 0) {
		penalty_amount = jQuery('.penalty_amount').html();
		penalty_amount = jQuery.trim(penalty_amount);
	}
	if(parseInt(payment_option) == 1) {
		if( (numbers_regex.test(due_amount) == true) && price_regex.test(penalty_amount) == true) {
			receipt_amount = parseInt(due_amount) + parseFloat(penalty_amount);
			if(jQuery('input[name="receipt_amount"]').length > 0) {
				jQuery('input[name="receipt_amount"]').val(receipt_amount);
			}
			else {
				if(jQuery('.receipt_amount').length > 0) {
					jQuery('.receipt_amount').html(receipt_amount);
				}
			}
		}
	}
	else if(parseInt(payment_option) == 2) {
		if(numbers_regex.test(due_amount) == true) {
			receipt_amount = parseInt(due_amount);
			if(jQuery('input[name="receipt_amount"]').length > 0) {
				jQuery('input[name="receipt_amount"]').val(receipt_amount);
			}
			else {
				if(jQuery('.receipt_amount').length > 0) {
					jQuery('.receipt_amount').html(receipt_amount);
				}
			}
		}
	}
}
function SavePayment() {
	if(jQuery('#PaymentModal .modal-body').find('.infos').length > 0) {
		jQuery('#PaymentModal .modal-body').find('.infos').remove();
	}
	jQuery.ajax({
		url: 'receipt_changes.php',
		type: "post",
		async: true,
		data: jQuery('form[name="payment_form"]').serialize(),
		dataType: 'html',
		contentType: 'application/x-www-form-urlencoded; charset=UTF-8',
		success: function(result) {
			jQuery('#PaymentModal .modal-content').animate({ scrollTop: 0 }, 500);
			if(numbers_regex.test(result) == true) {
				jQuery('#PaymentModal .modal-body').append('<div class="alert alert-success"> <button type="button" class="close" data-dismiss="alert">&times;</button> Successfully Updated </div>');
				setTimeout(function(){ 
					var payment_customer_chit_id = "";
					if(jQuery('input[name="payment_customer_chit_id"]').length > 0) {
						payment_customer_chit_id = jQuery('input[name="payment_customer_chit_id"]').val();
						payment_customer_chit_id = jQuery.trim(payment_customer_chit_id);
					}
					if(typeof payment_customer_chit_id != "undefined" && payment_customer_chit_id != null && payment_customer_chit_id != "") {
						jQuery('#PaymentModal .modal-header .close').trigger("click");
						loadChitPayment(payment_customer_chit_id);
					}
				}, 1000);
				
			}
			else {
				jQuery('#PaymentModal .modal-body').append('<span class="infos w-100 text-center" style="font-size: 15px; font-weight: bold;">'+result+'</span>');
			}
		},
		error: function(jqXHR, textStatus, errorThrown) {
			console.log(textStatus, errorThrown);
		}
	});
}
function loadChitPayment(payment_customer_chit_id) {
	var check_login_session = 1;
	var post_url = "dashboard_changes.php?check_login_session=1";	
	jQuery.ajax({url: post_url, success: function(check_login_session){
		if(check_login_session == 1) {

			var agent_customer_id = "";
			if(jQuery('select[name="agent_customer_id"]').length > 0) {
				agent_customer_id = jQuery('select[name="agent_customer_id"]').val();
				agent_customer_id = jQuery.trim(agent_customer_id);
			}

			if(typeof payment_customer_chit_id != "undefined" && payment_customer_chit_id != null && payment_customer_chit_id != "") {
				if(jQuery('#collapse'+payment_customer_chit_id).length > 0) {
					jQuery('#collapse'+payment_customer_chit_id).find('.card-body').html('<div class="alert alert-success my-3 mx-3"> Loading... </div>');
				}
				var post_url = "dashboard_changes.php?load_payment_chit_id="+payment_customer_chit_id+"&load_payment_chit_customer_id="+agent_customer_id;	
				jQuery.ajax({url: post_url, success: function(result){
					if(jQuery('#collapse'+payment_customer_chit_id).length > 0) {
						jQuery('#collapse'+payment_customer_chit_id).find('.card-body').html(result);
						getMonthlyReceiptsByCalendar();
					}
				}});
			}
			else {
				if(jQuery('#my_schemes_cover').length > 0) {
					jQuery('#my_schemes_cover').html('<div class="alert alert-success my-3 mx-3"> Loading... </div>');
				}
				var post_url = "dashboard_changes.php?load_payment_chit_id="+payment_customer_chit_id+"&load_payment_chit_customer_id="+agent_customer_id;	
				jQuery.ajax({url: post_url, success: function(result){
					if(jQuery('#my_schemes_cover').length > 0) {
						jQuery('#my_schemes_cover').html(result);
					}
				}});
			}
		}
		else {
			window.location.reload();
		}
	}}); 
}
function CancelPayment() {
	var check_login_session = 1;
	var post_url = "dashboard_changes.php?check_login_session=1";	
	jQuery.ajax({url: post_url, success: function(check_login_session){
		if(check_login_session == 1) {
			jQuery('#PaymentModal .modal-header .close').trigger("click");
		}
		else {
			window.location.reload();
		}
	}}); 
}

function AddToChit(chit_id) {
	var check_login_session = 1;
	var post_url = "dashboard_changes.php?check_login_session=1";	
	jQuery.ajax({url: post_url, success: function(check_login_session){
		if(check_login_session == 1) {	
			if(jQuery('#ChitRequestModal .modal-body').find('.infos').length > 0) {
                jQuery('#ChitRequestModal .modal-body').find('.infos').remove();
            }
			if(jQuery('#ChitRequestModal .modal-body').find('.alert').length > 0) {
                jQuery('#ChitRequestModal .modal-body').find('.alert').remove();
            }
			
			jQuery('.chit_request_modal_button').trigger("click");	

			var chit_name = "";
			if(jQuery('#add_to_chit_cover_'+chit_id).find('.card-title').length > 0) {
				chit_name = jQuery('#add_to_chit_cover_'+chit_id).find('.card-title').html();
				chit_name = jQuery.trim(chit_name);
				if(typeof chit_name != "undefined" && chit_name != null && chit_name != "") {
					if(jQuery('#ChitRequestModal').find('.chit_name').length > 0 ) {
						jQuery('#ChitRequestModal').find('.chit_name').html(chit_name);
					}
				}
			}
			
			jQuery('#ChitRequestModal .modal-footer .yes').attr('id', chit_id);
			jQuery('#ChitRequestModal .modal-footer .no').attr('id', chit_id); 
		}
		else {
			window.location.reload();
		}
	}});
}

function ConfirmChitRequest(obj) {
	var check_login_session = 1;
	var post_url = "dashboard_changes.php?check_login_session=1";	
	jQuery.ajax({url: post_url, success: function(check_login_session){
		if(check_login_session == 1) {

			if(jQuery('#ChitRequestModal .modal-body').find('.infos').length > 0) {
                jQuery('#ChitRequestModal .modal-body').find('.infos').remove();
            }
			if(jQuery('#ChitRequestModal .modal-body').find('.alert').length > 0) {
                jQuery('#ChitRequestModal .modal-body').find('.alert').remove();
            }

			var chit_id = jQuery('#ChitRequestModal .modal-footer .yes').attr('id')
			var post_url = "action_changes.php?add_to_chit_id="+chit_id;
			jQuery.ajax({url: post_url, success: function(result){
				jQuery('#ChitRequestModal .modal-content').animate({ scrollTop: 0 }, 500);

				var intRegex = /^\d+$/;
				if(intRegex.test(result) == true) {
					jQuery('#ChitRequestModal .modal-body').append('<div class="alert alert-success my-2 px-2 py-2"> <button type="button" class="close" data-dismiss="alert">&times;</button> Successfully sent the chit request </div>');
					setTimeout(function(){ 
						jQuery('#ChitRequestModal .modal-header .close').trigger("click");
						window.location.reload(); 
					}, 1000);
					
				}
				else {
					jQuery('#ChitRequestModal .modal-body').append('<span class="infos w-100 text-center" style="font-size: 15px; font-weight: bold;">'+result+'</span>');
				}
			}});
		}
		else {
			window.location.reload();
		}
	}});
}
function CancelChitRequest(obj) {
	var check_login_session = 1;
	var post_url = "dashboard_changes.php?check_login_session=1";	
	jQuery.ajax({url: post_url, success: function(check_login_session){
		if(check_login_session == 1) {
			jQuery('#ChitRequestModal .modal-header .close').trigger("click");
		}
		else {
			window.location.reload();
		}
	}}); 
}

function ClearShippingAddress() {
    if(jQuery('.shipping_form_cover').find('input[type="text"]').length > 0) {
        jQuery('.shipping_form_cover').find('input[type="text"]').each(function(){
            jQuery(this).val('');
        });
    }
    if(jQuery('.shipping_form_cover').find('textarea').length > 0) {
        jQuery('.shipping_form_cover').find('textarea').each(function(){
            jQuery(this).val('');
        });
    }
    //if(jQuery('.shipping_form_cover').hasClass('show') == false) {
        jQuery('.shipping_form_button').trigger('click');
    //}
}
function SaveShippingAddress(form_name, post_send_file, redirection_file) {

	if(jQuery('span.infos').length > 0) {
		jQuery('span.infos').remove();
	}
	if(jQuery('.valid_error').length > 0) {
		jQuery('.valid_error').remove();
	}
	if(jQuery('div.alert').length > 0) {
		jQuery('div.alert').remove();
	}

	jQuery.ajax({
		url: post_send_file,
		type: "post",
		async: true,
		data: jQuery('form[name="'+form_name+'"]').serialize(),
		dataType: 'html',
		contentType: 'application/x-www-form-urlencoded; charset=UTF-8',
		success: function(data) {
			//console.log(data);
			if(typeof data == "undefined" || data == "" || data == null) {
				if(jQuery('form[name="'+form_name+'"]').find('.submit_button').length > 0) {
					jQuery('form[name="'+form_name+'"]').find('.submit_button').attr('disabled', false);
				}
				if(jQuery('div.alert').length > 0) {
					jQuery('div.alert').remove();
				}
			}

			try {
				var x = JSON.parse(data);
			} catch (e) {
				return false;
			}
			//console.log(x);
			
			if(x.number == '1') {
				jQuery('form[name="'+form_name+'"]').find('.row:first').before('<div class="alert alert-success"> <button type="button" class="close" data-dismiss="alert">&times;</button> '+x.msg+' </div>');
				setTimeout(function(){ 
					ClearShippingAddress();
					if(typeof x.update_shipping_address_id != "undefined" && x.update_shipping_address_id != null && x.update_shipping_address_id != "") {
						var post_url = "shipping_address_changes.php?update_shipping_address_id="+x.update_shipping_address_id;	
						jQuery.ajax({url: post_url, success: function(result){
							if(jQuery('#shipping_'+update_shipping_address_id).length > 0) {
								jQuery('#shipping_'+update_shipping_address_id).html('');
								jQuery('#shipping_'+update_shipping_address_id).html(result);
							}
							else {
								if(jQuery('#address_row_cover').length > 0) {
									jQuery('#address_row_cover').append('<div class="col-sm-6 pb-3">'+result+'</div>');
								}
							}
						}});	
					}
				}, 1000);
			}
			
			if(x.number == '2') {
				jQuery('form[name="'+form_name+'"]').find('.row:first').before('<div class="alert alert-danger"> <button type="button" class="close" data-dismiss="alert">&times;</button> '+x.msg+' </div>');
				if(jQuery('form[name="'+form_name+'"]').find('.submit_button').length > 0) {
					jQuery('form[name="'+form_name+'"]').find('.submit_button').attr('disabled', false);
				}
			}
			
			if(x.number == '3') {
				jQuery('form[name="'+form_name+'"]').append('<div class="valid_error"> <script type="text/javascript"> '+x.msg+' </script> </div>');
				if(jQuery('form[name="'+form_name+'"]').find('.submit_button').length > 0) {
					jQuery('form[name="'+form_name+'"]').find('.submit_button').attr('disabled', false);
				}
			}
		},
		error: function(jqXHR, textStatus, errorThrown) {
			console.log(textStatus, errorThrown);
		}
	});
}

function CheckRadioBox(obj) {
	if(jQuery(obj).find('input[type="radio"]').length > 0) {
		jQuery(obj).find('input[type="radio"]').prop('checked', true);
	}
}

function CheckedCheckboxBox(obj) {
	if(jQuery(obj).find('input[type="checkbox"]').length > 0) {
		if(jQuery(obj).find('input[type="checkbox"]').is(':checked') == false) {
			jQuery(obj).find('input[type="checkbox"]').prop('checked', true);
			exit;
		} 
		if(jQuery(obj).find('input[type="checkbox"]').is(':checked') == true) {
			jQuery(obj).find('input[type="checkbox"]').prop('checked', false);
			exit;
		}
	}
}

function EditShippingAddress(update_shipping_address_id) {
	if(jQuery('#shipping_form_cover').length > 0) {
		jQuery('#shipping_form_cover').html('');
	}
	var check_login_session = 1;
    var post_url = "dashboard_changes.php?check_login_session=1";	
    jQuery.ajax({url: post_url, success: function(check_login_session){
        if(check_login_session == 1) {	
            var post_url = "shipping_address_changes.php?edit_shipping_address_id="+update_shipping_address_id;
            jQuery.ajax({url: post_url, success: function(result){
                if(jQuery('.shipping_form_cover').length > 0) {
					jQuery('.shipping_form_cover').html(result);
				}
				if(typeof update_shipping_address_id != "undefined" && update_shipping_address_id != null && update_shipping_address_id != "") {
					jQuery('.shipping_form_button').trigger('click');
				}
            }});
        }
        else {
            window.location.reload();
        }
    }});
}

function MergeChitAccount() {
	var check_login_session = 1;
	var post_url = "dashboard_changes.php?check_login_session=1";	
	jQuery.ajax({url: post_url, success: function(check_login_session){
		if(check_login_session == 1) {	
			if(jQuery('#MergeChitModal .modal-body').find('.infos').length > 0) {
                jQuery('#MergeChitModal .modal-body').find('.infos').remove();
            }
			if(jQuery('#MergeChitModal .modal-body').find('.alert').length > 0) {
                jQuery('#MergeChitModal .modal-body').find('.alert').remove();
            }

			if(jQuery('#MergeChitModal .modal-body').find('input[type="text"]').length > 0) {
                jQuery('#MergeChitModal .modal-body').find('input[type="text"]').val('');
            }
			jQuery('.merge_chit_modal_button').trigger("click");
		}
		else {
			window.location.reload();
		}
	}});
}

function ConfirmToMerge(obj) {
	var check_login_session = 1;
	var post_url = "dashboard_changes.php?check_login_session=1";	
	jQuery.ajax({url: post_url, success: function(check_login_session){
		if(check_login_session == 1) {

            if(jQuery('#MergeChitModal .modal-body').find('.infos').length > 0) {
                jQuery('#MergeChitModal .modal-body').find('.infos').remove();
            }
			if(jQuery('#MergeChitModal .modal-body').find('.alert').length > 0) {
                jQuery('#MergeChitModal .modal-body').find('.alert').remove();
            }

			jQuery.ajax({
				url: 'action_changes.php',
				type: "post",
				async: true,
				data: jQuery('form[name="merge_chit_form"]').serialize(),
				dataType: 'html',
				contentType: 'application/x-www-form-urlencoded; charset=UTF-8',
				success: function(result) {
					jQuery('#MergeChitModal .modal-content').animate({ scrollTop: 0 }, 500);
					var intRegex = /^\d+$/;
					if(intRegex.test(result) == true) {
						jQuery('#MergeChitModal .modal-body').append('<div class="alert alert-success my-2 px-2 py-2"> <button type="button" class="close" data-dismiss="alert">&times;</button> Successfully sent the merge request </div>');
						setTimeout(function(){ 
							jQuery('#MergeChitModal .modal-header .close').trigger("click");
							window.location.reload(); 
						}, 1000);
						
					}
					else {
						jQuery('#MergeChitModal .modal-body').append('<span class="infos w-100 text-center" style="font-size: 15px; font-weight: bold;">'+result+'</span>');
					}
				}
			});
		}
		else {
			window.location.reload();
		}
	}});
}
function CancelMerge(obj) {
	var check_login_session = 1;
	var post_url = "dashboard_changes.php?check_login_session=1";	
	jQuery.ajax({url: post_url, success: function(check_login_session){
		if(check_login_session == 1) {
			jQuery('#MergeChitModal .modal-header .close').trigger("click");
		}
		else {
			window.location.reload();
		}
	}}); 
}