<?php 
	$access_page = "Direct Order";
    include("include_user_check.php");

    include("permission_check.php");

?>
<!DOCTYPE html>
<html lang="en">
<head>
	<title> <?php if(!empty($project_title)) { echo $project_title; } ?> - Enquiry View </title>
	<?php include "link_style_script.php"; ?>
    <script type="text/javascript" src="include/js/common.js"></script>
    <script type="text/javascript" src="include/js/direct_order.js"></script>
</head>
<body>
	<?php include "header.php";  ?>
	<!-- sidebar-wrapper  -->          
	<div class="page-wrapper chiller-theme toggled">
		<main class="page-content">
			<div class="container-fluid px-lg-5">

                <?php
                    if(isset($_REQUEST['view_order_id'])) {
                        $view_order_id = $_REQUEST['view_order_id'];
                        $order_unique_id = "";
                        if(!empty($view_order_id)) {
                            $view_orders = array();
                            $view_orders = $obj->getTableRecords($GLOBALS['order_table'], 'order_id', $view_order_id);
                            if(!empty($view_orders)) {
                                foreach($view_orders as $data) {
                                    if(!empty($data['id'])) {
                                        $order_unique_id = $data['id'];
                                    }
                                    if(!empty($data['product_id'])) {
                                        $product_ids = explode(",", $data['product_id']);
                                    }
                                }
                            }
                            if(preg_match("/^\d+$/", $order_unique_id)) {

                                $columns = array(); $values = array(); $order_update_id = "";				
                                $columns = array('new_order');
                                $values = array("'0'");
                                $order_update_id = $obj->UpdateSQL($GLOBALS['order_table'], $order_unique_id, $columns, $values, '');
        
                                $customer_id = "";
                                $customer_id = $obj->getTableColumnValue($GLOBALS['order_table'], 'order_id', $view_order_id, 'customer_id');                   
                                $total_amount = $obj->getTableColumnValue($GLOBALS['order_table'], 'order_id', $view_order_id, 'total_amount');
        
                                if(!empty($customer_id)) {						
                                    $customer_name = $obj->getTableColumnValue($GLOBALS['customer_table'], 'customer_id', $customer_id, 'name');
                                    if(!empty($customer_name)) {
                                        $customer_name = $obj->encode_decode('decrypt', $customer_name);
                                    }						
                                    $customer_mobile_number = $obj->getTableColumnValue($GLOBALS['customer_table'], 'customer_id', $customer_id, 'mobile_number');
                                    if(!empty($customer_mobile_number)) {
                                        $customer_mobile_number = $obj->encode_decode('decrypt', $customer_mobile_number);
                                    }
                                    $customer_email = $obj->getTableColumnValue($GLOBALS['customer_table'], 'customer_id', $customer_id, 'email');
                                    if(!empty($customer_email) && $customer_email != $GLOBALS['null_value']) {
                                        $customer_email = $obj->encode_decode('decrypt', $customer_email);
                                    }
                                }
                                
                                $company_list = array();
                                $company_list = $obj->getTableRecords($GLOBALS['company_table'], '', '');
                                if(!empty($company_list)) {
                                    foreach($company_list as $data) {
                                        if(!empty($data['mobile_number']) && $data['mobile_number'] != $GLOBALS['null_value']) {
                                            $company_mobile_number = $obj->encode_decode('decrypt', $data['mobile_number']);
                                        }
                                        if(!empty($data['email']) && $data['email'] != $GLOBALS['null_value']) {
                                            $company_email = $obj->encode_decode('decrypt', $data['email']);
                                        }
                                    }
                                }
                                $paper_size = ""; 
                ?>
                                <div class="table-responsive">
                                    <div class="card border">
                                        <div class="card-header">
                                            <div class="row">
                                                <div class="col-3 text-center text-sm-left">
                                                    <h5 class="headfnt">Enquiry Preview</h5>
                                                </div>
                                                <div class="col-sm-3">
                                                    <select name="paper_size" id="paper_size" class="form-control" onchange="Javascript:show_pdf(this.value);">
                                                        <option value="">Select Paper Size</option>
                                                        <option value="a4" <?php if($paper_size == "a4"){ ?> selected <?php } ?>>A4</option>
                                                        <?php if(count($product_ids)<=15){ ?><option value="a5" <?php if($paper_size == "a5"){ ?> selected <?php } ?>>A5</option><?php } ?>
                                                        <option value="thermal" <?php if($paper_size == "thermal"){ ?> selected <?php } ?> >2 Inch</option>
                                                        <option value="3inch" <?php if($paper_size == "3inch"){ ?> selected <?php } ?> >3 Inch</option>
                                                    </select>
                                                </div>
                                                <div class="col-6 text-center text-sm-right">
                                                    <div class="row">
                                                        <div class="col-md-4">
                                                            <div class="form-group">
                                                                <button class="btn btn-dark poppins" style="font-size:11px;" type="button" id='btn_format1' onClick="window.open('reports/rpt_orders_format1.php?print_order_id=<?php echo $view_order_id; ?>&paper_size='+document.getElementById('paper_size').value,'_blank')"> <i class="fa fa-print"></i> &ensp; PDF Format 1</button>
                                                            </div>
                                                        </div>
                                                        <div class="col-md-4">
                                                            <div class="form-group">
                                                                <button class="btn btn-dark poppins" style="font-size:11px;" type="button" id='btn_format2' onClick="window.open('reports/rpt_orders_format2.php?print_order_id=<?php echo $view_order_id; ?>&paper_size='+document.getElementById('paper_size').value,'_blank')"> <i class="fa fa-print"></i> &ensp; PDF Format 2</button>
                                                            </div>
                                                        </div>
                                                        <div class="col-md-4">
                                                            <div class="form-group">
                                                                <button class="btn btn-dark poppins" style="font-size:11px;display:none" type="button" id='btn_thermal' onClick="window.open('reports/rpt_orders_format3.php?print_order_id=<?php echo $view_order_id; ?>&paper_size=','_blank')"> <i class="fa fa-print"></i> &ensp; PDF</button>
                                                                &nbsp; <button class="btn btn-dark poppins" style="font-size:11px;display:none" type="button" id='btn_3inch' onClick="window.open('reports/rpt_orders_format4.php?print_order_id=<?php echo $view_order_id; ?>&paper_size=','_blank')"> <i class="fa fa-print"></i> &ensp; PDF</button>
                                                                &nbsp; <button class="btn btn-danger poppins" style="font-size:11px;" type="button" onClick="window.open('order.php','_self')">Back</button>
                                                            </div>
                                                        </div>
                                                    </div>
                                                </div>	
                                            </div>
                                        </div>
                                        <div class="px-2 py-2 text-center">
                                            <script type="text/javascript" src="include/print_pdf/jspdf.min.js"></script>
                                            <script type="text/javascript" src="include/print_pdf/html2canvas.js"></script>
                                            <script type="text/javascript" src="include/print_pdf/print_pdf.js"></script>

                                            <?php 
                                                include("../order/order_print.php"); 
                                            ?>

                                            <script>
                                                jQuery(document).ready(function() {
                                                    prepare_print_view();        
                                                });
                                            </script>
                                        </div>
                                    </div>
                                </div>    
                <?php
                            }
                        }
                    }
                ?>

			</div>
		</main>
	</div>  
	<!-- page-wrapper -->

	<script>
		jQuery(document).ready(function(){
			jQuery("#direct_orderactive").addClass("active");
		});
	</script>

	<?php include "footer.php"; ?>

    </body>
</html>