<?php
    include("include_user_check.php");
	
    $page_title = "Chit"; $page_number = $GLOBALS['page_number']; $page_limit = $GLOBALS['page_limit'];

	if(isset($_SESSION[$GLOBALS['site_name_user_prefix'].'_user_type']) && !empty($_SESSION[$GLOBALS['site_name_user_prefix'].'_user_type'])) {
		if($_SESSION[$GLOBALS['site_name_user_prefix'].'_user_type'] != $GLOBALS['admin_user_type']) {
			header("Location:dashboard.php");
			exit;
		}
	}

?>
<!DOCTYPE html>
<html lang="en">
<head>
	<title> <?php if(!empty($project_title)) { echo $project_title; } ?> - <?php if(!empty($page_title)) { echo $page_title; } ?> </title>
	<?php include "link_style_script.php"; ?>
	<script type="text/javascript" src="include/js/common.js"></script>
	<script type="text/javascript" src="include/js/chit.js"></script>
</head>
<body>
	<?php include "header.php";  ?>
	<!-- sidebar-wrapper  -->          
	<div class="page-wrapper chiller-theme toggled">
		<main class="page-content">
			<div class="container-fluid px-lg-5">
				<div class="border card-box">

					<div class="card-header">
						<div class="row">
							<div class="col-sm-6 text-center text-sm-left">
								<h5 class="headfnt edit_title"><?php if(!empty($page_title)) { echo $page_title." List"; } ?></h5>
							</div>
							<div class="col-sm-6 text-center text-sm-right">
								<a href="reports/rpt_chit.php" target="_blank" class="btn btn-success"><i class="fa fa-file-pdf-o"></i> &ensp; PDF</a> &nbsp;
								<button class="btn btn-dark poppins" style="font-size:11px;" type="button" onClick="Javascript:ShowModalContent('<?php if(!empty($page_title)) { echo $page_title; } ?>', '');"> <i class="fa fa-plus-circle"></i> &ensp; Add <?php if(!empty($page_title)) { echo $page_title; } ?> </button>
							</div>
						</div>
					</div>

					<div class="add_update_form_content"></div>

					<div id="table_records_cover">
						<form name="table_listing_form" method="post">
							<div class="row mt-3 mx-0">
								<div class="col-sm-4 form-group">
								</div>
								<div class="col-sm-4 form-group">
								</div>
								<div class="col-sm-4 form-group">
									<input type="hidden" name="page_number" value="<?php if(!empty($page_number)) { echo $page_number; } ?>">
									<input type="hidden" name="page_limit" value="<?php if(!empty($page_limit)) { echo $page_limit; } ?>">
									<input type="hidden" name="page_title" value="<?php if(!empty($page_title)) { echo $page_title; } ?>">
									<input type="text" name="search_text" class="form-control" onKeyUp="Javascript:table_listing_records_filter();" value="" placeholder="Search By Chit Name">
								</div>	
							</div>
						</form>
						<div id="table_listing_records" class="table-responsive poppins"></div>
					</div>

				</div>
			</div>
		</main>
	</div>  
	<!-- page-wrapper -->

	<script>
		jQuery(document).ready(function(){
			jQuery("#chitactive").addClass("active");
		});

		table_listing_records_filter();

		function BonusChit(chit_id) {
			var check_login_session = 1;
			var post_url = "dashboard_changes.php?check_login_session=1";	
			jQuery.ajax({url: post_url, success: function(check_login_session){
				if(check_login_session == 1) {

					var post_url = "chit_changes.php?bonus_chit_id="+chit_id;	
					jQuery.ajax({url: post_url, success: function(result){
						if(jQuery('.add_update_form_content').length > 0) {
							jQuery('.add_update_form_content').html("");
							jQuery('.add_update_form_content').html(result);
						}
						jQuery('.edit_title').html('Bonus Details');
						jQuery('html, body').animate({
							scrollTop: (jQuery('.add_update_form_content').parent().parent().offset().top)
						}, 500);
					}});

				}
				else {
					window.location.reload();
				}
			}});
		}
	</script>

	<?php include "footer.php"; ?>
    </body>
</html>