<?php 
    include("include_user_check.php");

    if(!empty($project_allow_booking) && $project_allow_booking == 2) {
		header("Location:dashboard.php");
		exit;
	}

    $page_title = "Product Pricelist";

    $pricelist = array();
    $pricelist = $obj->ProductPricelist('1');
?>
<!DOCTYPE html>
<html lang="en">
<head>
	<title> <?php if(!empty($project_title)) { echo $project_title; } ?> - <?php if(!empty($page_title)) { echo $page_title; } ?> </title>
	<?php include "link_style_script.php"; ?>
	<script type="text/javascript" src="include/print_pdf/jspdf.min.js"></script>
    <script type="text/javascript" src="include/print_pdf/html2canvas.js"></script>
    <script type="text/javascript" src="include/print_pdf/print_pdf.js"></script>
</head>
<body>
	<?php include "header.php";  ?>
	<!-- sidebar-wrapper  -->          
	<div class="page-wrapper chiller-theme toggled">
		<main class="page-content">
			<div class="container-fluid px-lg-5">
				<div class="border card-box">

                    <div class="card-header">              
                        <div class="row">
                            <div class="col-sm-5 text-center text-sm-left">
                                <h5 class="headfnt"><?php if(!empty($page_title)) { echo $page_title; } ?></h5>
                            </div>
                            <div class="col-sm-3 search_text"></div>
                            <div class="col-sm-4 text-center text-sm-right">
                                <button class="btn btn-dark poppins" style="font-size:11px;" type="button" onClick="window.open('reports/rpt_price_list.php')"> <i class="fa fa-print"></i> &ensp; PDF</button>
                                &nbsp; <a class="btn btn-danger poppins" style="font-size:11px;" href="product.php">Back</a>
                            </div>
                        </div>
                    </div>
					
					<div class="table-responsive px-3 py-3">
                        <div id="report_area" class="w-100">
                            <table cellpadding="0" cellspacing="0" class="report_table print_order" style="width: 100%;">
                                <thead>
                                    <tr>
                                        <th colspan="6" style="padding: 5px; border: 1px solid #000; text-align: center; font-size: 15px;">Pricelist</th>
                                    </tr>
                                    <tr>
                                        <th style="padding: 5px; border: 1px solid #000; text-align: center; width: 50px; font-size: 12px;">Product Code</th>
                                        <th style="padding: 5px; border: 1px solid #000; border-left: none; text-align: center; font-size: 12px;">Product Name</th>
                                        <th style="padding: 5px; border: 1px solid #000; border-left: none; text-align: center; width: 100px; font-size: 12px;">Content</th>
                                        <th style="padding: 5px; border: 1px solid #000; border-left: none; text-align: center; width: 100px; font-size: 12px;">Quantity</th>
                                        <th style="padding: 5px; border: 1px solid #000; border-left: none; text-align: center; width: 100px; font-size: 12px;">Price</th>
                                        <th style="padding: 5px; border: 1px solid #000; border-left: none; text-align: center; width: 125px; font-size: 12px;">Amount</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <?php
                                        if(!empty($pricelist)) {
                                            $sno = 1;
                                            foreach($pricelist as $data) {
                                                if(!empty($data['category_name'])) {
                                    ?>
                                                    <tr>
                                                        <td colspan="6" style="padding: 5px; border: 1px solid #000; text-align: center; text-transform: uppercase; font-size: 12px;">
                                                            <?php
                                                                if(!empty($data['category_name'])) {
                                                                    $data['category_name'] = $obj->encode_decode('decrypt', $data['category_name']);
                                                                    echo $data['category_name'];
                                                                }
                                                            ?>
                                                        </td>
                                                    </tr>
                                    <?php          
                                                    if(!empty($data['product_list'])) {
                                                        foreach($data['product_list'] as $product) {
                                                            if(!empty($product['name'])) {
                                    ?>
                                                                <tr>
                                                                    <td style="padding: 5px; border: 1px solid #000; text-align: center; width: 100px; font-size: 12px;">
                                                                        <?php
                                                                            if(!empty($product['product_code'])) {
                                                                                $product['product_code'] = $obj->encode_decode('decrypt', $product['product_code']);
                                                                                echo $product['product_code'];
                                                                            }
                                                                        ?>
                                                                    </td>
                                                                    <td style="padding: 5px 10px; border: 1px solid #000; border-left: none; font-size: 12px;">
                                                                        <?php
                                                                            if(!empty($product['name'])) {
                                                                                $product['name'] = $obj->encode_decode('decrypt', $product['name']);
                                                                                $product['name'] = str_replace("$", '"', $product['name']);
                                                                                echo $product['name'];
                                                                            }
                                                                        ?>
                                                                    </td>
                                                                    <td style="padding: 5px; border: 1px solid #000; border-left: none; text-align: center; width: 100px; font-size: 12px;">
                                                                        <?php
                                                                            if(!empty($product['product_content'])) {
                                                                                $product['product_content'] = $obj->encode_decode('decrypt', $product['product_content']);
                                                                                echo $product['product_content'];
                                                                            }
                                                                        ?>
                                                                    </td>
                                                                    <td style="padding: 5px; border: 1px solid #000; border-left: none; text-align: center; width: 100px; font-size: 12px;">
                                                                    </td>
                                                                    <td style="padding: 5px; border: 1px solid #000; border-left: none; text-align: center; width: 100px; font-size: 12px;">
                                                                        <?php if(!empty($product['price'])) { echo number_format($product['price'], 2); } ?>
                                                                    </td>
                                                                    <td style="padding: 5px; border: 1px solid #000; border-left: none; text-align: center; width: 125px; font-size: 12px;">
                                                                        
                                                                    </td>
                                                                </tr>
                                    <?php                  
                                                                $sno = $sno + 1;          
                                                            }
                                                        }
                                                    }      
                                                }
                                            }
                                        }
                                        else {
                                    ?>
                                            <tr>
                                                <td colspan="6" style="padding: 5px; border: 1px solid #000; text-align: center;">Sorry! No products found</td>
                                            </tr>
                                    <?php        
                                        }
                                    ?>
                                </tbody>
                            </table>
                        </div>
                    </div>

				</div>
			</div>
		</main>
	</div>  
	<!-- page-wrapper -->

	<script>
		jQuery(document).ready(function(){
			jQuery("#productactive").addClass("active");
            prepare_print_view();
		});
	</script>

	<?php include "footer.php"; ?>

    </body>
</html>