<?php
    include("include_user_check.php");

    if(isset($_SESSION[$GLOBALS['site_name_user_prefix'].'_user_type']) && !empty($_SESSION[$GLOBALS['site_name_user_prefix'].'_user_type'])) {
		if($_SESSION[$GLOBALS['site_name_user_prefix'].'_user_type'] != $GLOBALS['admin_user_type']) {
			header("Location:dashboard.php");
			exit;
		}
	}
	
    $page_title = "Settings"; $allow_booking = 2; $allow_discount = 2; $allow_sms = 2; $sms_count = 0; $due_reminder_secret_key = "";

    $settings_list = array();
    $settings_list = $obj->getTableRecords($GLOBALS['private_settings_table'], '', '');
    if(!empty($settings_list)) {
        foreach($settings_list as $data) {
            if( (!empty($data['name']) && $data['name'] == "allow_booking") && (!empty($data['value']) && $data['value'] != $GLOBALS['null_value']) ) {
                $allow_booking = $data['value'];
            }
            if( (!empty($data['name']) && $data['name'] == "allow_discount") && (!empty($data['value']) && $data['value'] != $GLOBALS['null_value']) ) {
                $allow_discount = $data['value'];
            }
            if( (!empty($data['name']) && $data['name'] == "allow_sms") && (!empty($data['value']) && $data['value'] != $GLOBALS['null_value']) ) {
                $allow_sms = $data['value'];
            }
            if( (!empty($data['name']) && $data['name'] == "sms_count") && (!empty($data['value']) && $data['value'] != $GLOBALS['null_value']) ) {
                $sms_count = $data['value'];
            }
            if( (!empty($data['name']) && $data['name'] == "due_reminder_secret_key") && (!empty($data['value']) && $data['value'] != $GLOBALS['null_value']) ) {
                $due_reminder_secret_key = $data['value'];
                if(!empty($due_reminder_secret_key)) {
                    $due_reminder_secret_key = $obj->encode_decode('decrypt', $due_reminder_secret_key);
                }
            }
        }
    }  


?>
<!DOCTYPE html>
<html lang="en">
<head>
	<title> <?php if(!empty($project_title)) { echo $project_title; } ?> - <?php if(!empty($page_title)) { echo $page_title; } ?> </title>
	<?php include "link_style_script.php"; ?>
	<script type="text/javascript" src="include/js/common.js"></script>
</head>
<body>
	<?php include "header.php";  ?>
	<!-- sidebar-wrapper  -->          
	<div class="page-wrapper chiller-theme toggled">
		<main class="page-content">
			<div class="container-fluid px-lg-5">
				<div class="border card-box">

					<div class="card-header">
						Settings
					</div>

					<div class="add_update_form_content">
                        <form class="py-4 poppins pd-20 redirection_form" name="private_settings_form" method="POST">
                            <input type="hidden" name="settings_page" value="1">
                            <div class="row">
                                <div class="col-sm-3 pl-0">
                                    <div class="form-group">
                                        <div class="form-check">
                                            <input class="form-check-input" type="checkbox" name="allow_booking" value="<?php if(!empty($allow_booking)) { echo $allow_booking; } ?>" id="allow_booking" <?php if(!empty($allow_booking) && $allow_booking == 1) { ?> checked <?php } ?> />
                                            <label class="form-check-label" for="allow_booking" onClick="Javascript:CustomCheckboxToggle(this, 'allow_booking');">Allow Booking</label>
                                        </div>
                                    </div>
                                    <div class="form-group">
                                        <div class="form-check">
                                            <input class="form-check-input" type="checkbox" name="allow_discount" value="<?php if(!empty($allow_discount)) { echo $allow_discount; } ?>" id="allow_discount" <?php if(!empty($allow_discount) && $allow_discount == 1) { ?> checked <?php } ?> />
                                            <label class="form-check-label" for="allow_discount" onClick="Javascript:CustomCheckboxToggle(this, 'allow_discount');">Allow Discount</label>
                                        </div>
                                    </div>
                                    <div class="form-group">
                                        <div class="form-check">
                                            <input class="form-check-input" type="checkbox" name="allow_sms" value="<?php if(!empty($allow_sms)) { echo $allow_sms; } ?>" id="allow_sms" <?php if(!empty($allow_sms) && $allow_sms == 1) { ?> checked <?php } ?> />
                                            <label class="form-check-label" for="allow_sms" onClick="Javascript:CustomCheckboxToggle(this, 'allow_sms');">Allow SMS</label>
                                        </div>
                                    </div>
                                    <div id="allow_sms_cover" class="row <?php if($allow_sms != 1) { ?>d-none<?php } ?>">
                                        <div class="col-4 pl-0">
                                            <div class="form-group">
                                                <label class="form-control-label">SMS Count</label>
                                                <div class="w-100">
                                                    <input type="text" name="sms_count" placeholder="SMS Count" class="form-control" value="<?php if(!empty($sms_count)) { echo $sms_count; } ?>">
                                                </div>
                                            </div>
                                        </div>
                                        <div class="col-8 pl-0">
                                            <div class="form-group">
                                                <label class="form-control-label">Due Remin Secret Key</label>
                                                <div class="w-100">
                                                    <input type="text" name="due_reminder_secret_key" class="form-control" value="<?php if(!empty($due_reminder_secret_key)) { echo $due_reminder_secret_key; } ?>">
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>

                                <div class="col-md-12 pt-3 text-center">
                                    <button class="btn btn-primary btnwidth submit_button" type="button" onClick="Javascript:SaveModalContent(event, 'private_settings_form', 'private_settings_changes.php', 'private_settings.php');">Submit</button>
                                </div>
                            </div>
                        </form>
                    </div>

				</div>
			</div>
		</main>
	</div>  
	<!-- page-wrapper -->

	<script>
		jQuery(document).ready(function(){
			jQuery("#settingsactive").addClass("active");
		});
	</script>

	<?php include "footer.php"; ?>

<?php $diwali_start_date = date("15-9-Y"); $diwali_end_date = date("t-11-Y"); ?>

<script type="text/javascript" src="include/js/bootstrap-datepicker.min.js"></script>
<script type="text/javascript">
    jQuery(document).ready(function(){
        if(jQuery('.diwali_date_field').length > 0) {
            jQuery('.diwali_date_field').datepicker({
                format: "dd-mm-yyyy",
                autoclose: true,
                startDate: '<?php if(!empty($diwali_start_date)) { echo $diwali_start_date; } ?>',
                endDate: '<?php if(!empty($diwali_end_date)) { echo $diwali_end_date; } ?>'
            });
        }

        if(jQuery('.date_field').length > 0) {
            jQuery('.date_field').datepicker({
                format: "dd-mm-yyyy",
                autoclose: true
            });
        }
    });   
</script>

    </body>
</html>