<?php
    include("include_user_check.php");

    if(empty($login_user_id)) {
        header("Location:index.php");
        exit;
    }

    $page_title = "Fund Schemes";

    $filter_agent_id = ""; $filter_customer_id = "";
    if(!empty($login_user_id)) {
        if(!empty($agent_user) && $agent_user == 1) {
            $filter_agent_id = $login_user_id;
        }
        else {
            $filter_customer_id = $login_user_id;
        }
    }

    $chit_list = array();
	$chit_list = $obj->getCustomerAllowChitList('');

?>
<!DOCTYPE html>
<html lang="en">
<head>
	<title><?php if(!empty($project_title)) { echo $project_title; } ?> - <?php if(!empty($page_title)) { echo $page_title; } ?></title>
	<?php include("link_style_script.php"); ?>
</head>
<body>
<!--Navigation-->
	<?php include("header.php"); ?>
<!--Navigation End-->
<div class="container-fluid">
    <div class="row">
        <div class="col-12 justify-content-center">
            <div class="w-100 py-3">
                <h5 class="medium mb-3"><?php if(!empty($page_title)) { echo $page_title; } ?></h5>
                <div class="row">
                    <?php
                        if(!empty($chit_list)) {
                            foreach($chit_list as $data) {
                                if(!empty($data['chit_id'])) {
                                    $name = ""; $due_amount = 0; $description = ""; $terms_conditions = ""; $chit_image = ""; $no_of_users = 0;
                                    if(!empty($data['name'])) {
                                        $name = $obj->encode_decode('decrypt', $data['name']);
                                    }
                                    if(!empty($data['due_amount'])) {
                                        $due_amount = $data['due_amount'];
                                    }
                                    if(!empty($data['chit_description']) && $data['chit_description'] != $GLOBALS['null_value']) {
                                        $description = $obj->encode_decode('decrypt', $data['chit_description']);
                                        $description = html_entity_decode($description);
                                        $description = html_entity_decode($description);
                                    }
                                    if(!empty($data['terms_conditions']) && $data['terms_conditions'] != $GLOBALS['null_value']) {
                                        $terms_conditions = $obj->encode_decode('decrypt', $data['terms_conditions']);
                                        $terms_conditions = html_entity_decode($terms_conditions);
                                        $terms_conditions = html_entity_decode($terms_conditions);
                                    }
                                    if(!empty($data['chit_image']) && $data['chit_image'] != $GLOBALS['null_value']) {
                                        $chit_image = $data['chit_image'];
                                    }
                                    if(!empty($data['no_of_users'])) {
                                        $no_of_users = $data['no_of_users'];
                                    }

                                    $last_date_to_join = ""; $allow_to_join = 1; $current_date = date("d-m-Y");
                                    if(!empty($data['last_date_to_join']) && $data['last_date_to_join'] != "0000-00-00") {
                                        $last_date_to_join = date("d-m-Y", strtotime($data['last_date_to_join']));
                                        if(strtotime($current_date) > strtotime($last_date_to_join)) {
                                            $allow_to_join = 2;
                                        }
                                    }

                                    $percentage = 0; $chit_user_count = 0;
                                    if(!empty($allow_to_join) && $allow_to_join == 1) {
                                        if(!empty($no_of_users)) {                                            
                                            $chit_user_count = $obj->getChitUsersCount($data['chit_id']);
                                            if(!empty($chit_user_count)) {
                                                $chit_user_count = $chit_user_count - 1;
                                            }
                                            if($chit_user_count == $no_of_users) {
                                                $allow_to_join = 2;
                                            }

                                            if($chit_user_count <= $no_of_users) {
                                                $percentage = ($chit_user_count / $no_of_users) * 100;
                                            }
                                        }

                                        /*$customer_chit_id = "";
                                        $customer_chit_id = $obj->CheckCustomerExistsInChit($filter_agent_id, $filter_customer_id, $data['chit_id']);
                                        if(!empty($customer_chit_id)) {
                                            $allow_to_join = 2;
                                        }*/

                                        $customer_chit_list = array(); $customer_chit_count = 0;
		                                $customer_chit_list = $obj->getRequestCustomerChitList($filter_agent_id, $filter_customer_id, $data['chit_id']);
                                        if(!empty($customer_chit_list)) {
                                            $customer_chit_count = count($customer_chit_list);
                                            //$allow_to_join = 2;
                                        }
                                    }
                    ?>
                                    <div class="col-lg-3 col-md-6 col-12 pt-4 padht">
                                        <div id="add_to_chit_cover_<?php echo $data['chit_id']; ?>" class="one-column text-center">
                                        <?php if(!empty($chit_image) && file_exists($target_dir.$chit_image)) { ?>
                                                <img src="<?php echo $target_dir.$chit_image; ?>" class="img-fluid pb-3" alt="Fund" title="Fund">
                                            <?php } else if(!empty($description)) { ?>
                                            <div class="medium paraclr smallfnt chit_desc_fund">
                                                <?php if(!empty($description)) { echo $description; } ?>
                                            </div>
                                            <?php } else { ?>
                                                <img src="images/no-image.jpg" class="img-fluid pb-3" alt="Fund" title="Fund">
                                            <?php } ?>

                                            <?php if(!empty($name)) { ?>
                                            <div class="bold heading5 clr2"><?php echo $name; ?></div>
                                            <?php } ?>

                                            <?php if(!empty($terms_conditions)) { ?>
                                            <div class="medium paraclr smallfnt chit_desc" <?php if(strlen($terms_conditions) > 200) { ?> style="overflow-y: scroll; scrollbar-width: thin;" <?php } ?>> 
                                                <?php if(!empty($terms_conditions)) { echo $terms_conditions; } ?> 
                                            </div>
                                            <?php } ?>

                                            <?php if(!empty($due_amount)) { ?>
                                            <div class="bold heading6 clr2 mb-3 pt-4">( <i class="fa fa-inr"></i> <?php echo $due_amount; ?> )</div>
                                            <?php } ?>

                                            <?php if(!empty($customer_chit_count)) { ?>
                                                <p class="medium paraclr smallfnt customer_chit_count">Active In (<?php echo $customer_chit_count; ?>)</p>
                                            <?php } else { ?>
                                                <p class="medium paraclr smallfnt customer_chit_count">&nbsp;</p>
                                            <?php } ?>

                                            <a href="Javascript:AddToChit('<?php echo $data['chit_id']; ?>');" class="nav-btn medium add_to_chit_button">JOIN NOW</a>
                                        </div>
                                    </div>
                    <?php
                                }
                            }
                        }
                    ?>
                </div>

            </div> 
        </div>

    </div>
    <?php include("footer.php"); ?>
</div>
</body>
</html>