<?php
    include("include.php");

    if(isset($_SESSION) && !empty($_SESSION)) {
        session_destroy();
    }

    $page_title = "Account Registration";

    $settings_list = array(); $customer_register_otp_sms = 2;
    $settings_list = $obj->getTableRecords($GLOBALS['settings_table'], '', '');
    if(!empty($settings_list)) {
        foreach($settings_list as $sidebar) {
            if( (!empty($sidebar['name']) && $sidebar['name'] == "customer_register_otp_sms") && (!empty($sidebar['value']) && $sidebar['value'] != $GLOBALS['null_value']) ) {
                $customer_register_otp_sms = $sidebar['value'];
            }
        }
    }

    if($customer_register_otp_sms != 1) {
        header("Location:index.php");
        exit;
    }

    $proof_type_list = array();
	$proof_type_list = $GLOBALS['customer_proof_type_list'];

    $state_list = array();
	$state_list = $obj->getStateList('');

    $city_list = array();
	$city_list = $obj->getCityList('');
?>
<!DOCTYPE html>
<html lang="en">
<head>
	<title><?php if(!empty($project_title)) { echo $project_title; } ?> - <?php if(!empty($page_title)) { echo $page_title; } ?></title>
	<?php include("link_style_script.php"); ?>
</head>
<body>
<!--Navigation-->
	<?php include("header.php"); ?>
<!--Navigation End-->
<div class="container-fluid py-5">
    <div class="row">
        <div class="col-12 justify-content-center">
            <div class="w-100">
                <h5 class="medium mb-3"><?php if(!empty($page_title)) { echo $page_title; } ?></h5>
                <form class="box w-100 border px-3 py-3 redirection_form" name="register_form" method="POST">
                    <?php $otp_number = $GLOBALS['null_value']; ?>
					<input type="hidden" name="otp_number" class="form-control" value="<?php if(!empty($otp_number)) { echo $otp_number; } ?>">
					<div id="otp_form_cover" class="row mx-0">
                        <div class="col-lg-6">

                            <div class="row">
                                <div class="col-lg-8 pt-3">
                                    <label class="medium login-label">Name *</label>
                                    <div class="w-100">
                                        <input type="text" class="form-control medium smallfnt" name="name" value="<?php if(!empty($name)) { echo $name; } ?>" placeholder="Enter Your Name">
                                    </div>
                                </div>
                                <div class="col-lg-4 pt-3">
                                    <label class="medium login-label">Mobile Number *</label>
                                    <div class="w-100">
                                        <input type="text" class="form-control medium smallfnt" name="mobile_number" value="<?php if(!empty($mobile_number)) { echo $mobile_number; } ?>" placeholder="Enter Your Mobile Number">
                                    </div>
                                </div>
                                <div class="col-lg-6 pt-3">
                                    <label class="medium login-label">Address 1 *</label>
                                    <div class="w-100">
                                        <input type="text" class="form-control medium smallfnt" name="address1" value="<?php if(!empty($address1)) { echo $address1; } ?>" placeholder="Address 1">
                                    </div>
                                </div>
                                <div class="col-lg-6 pt-3">
                                    <label class="medium login-label">Address 2</label>
                                    <div class="w-100">
                                        <input type="text" class="form-control medium smallfnt" name="address2" value="<?php if(!empty($address2)) { echo $address2; } ?>" placeholder="Address 2">
                                    </div>
                                </div>
                                <div class="col-lg-6 pt-3">
                                    <label class="medium login-label">State *</label>
                                    <div class="w-100">
                                        <select name="state" class="form-control" onChange="Javascript:ReloadCity(this.value);">
                                            <option value="">Select</option>
                                            <?php
                                                if(!empty($state_list)) {
                                                    foreach($state_list as $data) {
                                                        if(!empty($data['state_name'])) {
                                            ?>
                                                            <option value="<?php echo $data['state_name']; ?>"> 
                                                                <?php echo $data['state_name']; ?> 
                                                            </option>
                                            <?php
                                                        }
                                                    }
                                                }
                                            ?>
                                        </select>
                                    </div>
                                </div>
                                <div class="col-lg-6 pt-3">
                                    <label class="medium login-label">City *</label>
                                    <div id="city_list_cover" class="w-100">
                                        <div class="input-group" style="position:initial;">
                                            <select name="city" class="form-control">
                                                <option value="">Select</option>
                                                <?php
                                                    if(!empty($city_list)) {
                                                        foreach($city_list as $data) {
                                                            if(!empty($data['city_name'])) {
                                                ?>
                                                                <option value="<?php echo $data['city_name']; ?>"> 
                                                                    <?php echo $data['city_name']; ?> 
                                                                </option>
                                                <?php
                                                            }
                                                        }
                                                    }
                                                ?>
                                            </select>
                                            <div style="position: inherit; top: 0px; width: 50px;" class="input-group-append">
                                                <button type="button" class="btn btn-dark px-3 py-2" onClick="Javascript:AddCity();"> <i class="fa fa-plus"></i> </button>
                                            </div>
                                        </div>
                                    </div>
                                </div>

                                <div class="col-lg-6 pt-3">
                                    <label class="medium login-label">User Name *</label>
                                    <div class="w-100">
                                        <input type="text" class="form-control medium smallfnt" name="login_user_name" value="<?php if(!empty($login_user_name)) { echo $login_user_name; } ?>">
                                    </div>
                                </div>
                                <div class="col-lg-6 pt-3">
                                    <label class="medium login-label">Password *</label>
                                    <div class="w-100">
                                        <div class="input-group" style="position:initial;">
                                            <input type="password" class="form-control shadow-none login_controls" onkeyup="Javascript:CheckPassword('password');" id="password" name="password" value="<?php if(!empty($password)) { echo $password; } ?>">
                                            <div style="position: inherit; top: 0px;" class="input-group-append">
                                                <button class="btn btn-secondary px-2 py-2" type="button" id="passwordBtn" data-toggle="button" aria-pressed="false"><i class="fa fa-eye"></i></button>
                                            </div>
                                        </div>
                                    </div>
                                    <div id="password_cover">                                          
                                        <div class="col-lg-12 pb-1">
                                            <div class="smallfnt fw-400 p-gray pb-1">Password must include:</div>
                                            <div class="form-check">
                                                <input class="form-check-input" type="checkbox" name="length_check" value="" id="defaultCheck1">
                                                <label class="form-check-label smallfnt fw-400 checkbox" for="defaultCheck1">
                                                    8 - 20 characters
                                                </label>
                                            </div>
                                        </div>
                                        <div class="col-lg-12 pb-1">
                                            <div class="form-check">
                                                <input class="form-check-input" type="checkbox" name="letter_check" value="" id="defaultCheck1">
                                                <label class="form-check-label smallfnt fw-400 checkbox" for="defaultCheck1">
                                                    Atleast one upper case and lower case letter
                                                </label>
                                            </div>
                                        </div>
                                        <div class="col-lg-12 pb-1">
                                            <div class="form-check">
                                                <input class="form-check-input" type="checkbox" name="number_symbol_check" value="" id="defaultCheck1">
                                                <label class="form-check-label smallfnt fw-400 checkbox" for="defaultCheck1">
                                                    Atleast one number and one symbol
                                                </label>
                                            </div>
                                        </div>
                                        <div class="col-lg-12 pb-4">
                                            <div class="form-check">
                                                <input class="form-check-input" type="checkbox" name="space_check" value="" id="defaultCheck1">
                                                <label class="form-check-label smallfnt fw-400 checkbox" for="defaultCheck1">
                                                    No space
                                                </label>
                                            </div>
                                        </div>
                                    </div>
                                </div>

                            </div>
                        </div>
                        <div class="col-lg-6">

                            <div class="row">
                                <div class="col-lg-6 pt-3">
                                    <label class="medium login-label">Proof Type</label>
                                    <div class="w-100">
                                        <select name="proof_type" class="form-control">
                                            <option value="">Select</option>
                                            <?php
                                                if(!empty($proof_type_list)) {
                                                    foreach($proof_type_list as $type) {
                                                        if(!empty($type)) {
                                                            $type_encrypted = $obj->encode_decode('encrypt', $type);
                                            ?>
                                                            <option value="<?php echo $type_encrypted; ?>" <?php if(!empty($proof_type) && $type_encrypted == $proof_type) { ?> selected="selected" <?php } ?> >
                                                                <?php echo $type; ?>
                                                            </option>
                                            <?php
                                                        }
                                                    }
                                                }
                                            ?>
                                        </select>
                                    </div>
                                </div>
                                <div class="col-lg-6 pt-3">
                                    <label class="medium login-label">Proof Number</label>
                                    <div class="w-100">
                                        <input type="text" class="form-control medium smallfnt" name="proof_number" value="<?php if(!empty($proof_number)) { echo $proof_number; } ?>" placeholder="Enter Your proof number">
                                    </div>
                                </div>                             
                                <div class="col-12 pt-3">
                                    <div id="proof_image_cover" class="form-group">
                                        <h6 class="w-100 text-center">Proof Image Max.Upload Size - 2 MB</h6> 
                                        <div class="image-upload text-center">
                                            <label for="proof_image">   
                                                <div class="proof_image_list row">
                                                    <div class="col-12">
                                                        <div class="cover">
                                                            <?php if(!empty($proof_image) && file_exists($target_dir.$proof_image)) { ?>
                                                                <button type="button" onclick="Javascript:delete_upload_image_before_save(this, 'proof_image', '<?php if(!empty($proof_image)) { echo $proof_image; } ?>');" class="btn btn-danger"><i class="fa fa-close"></i></button>
                                                                <img id="proof_image_preview" src="<?php echo $target_dir.$proof_image; ?>" style="max-width: 100%; max-height: 200px;" />
                                                                <input type="hidden" name="proof_image_name[]" value="<?php if(!empty($proof_image)) { echo $proof_image; } ?>">
                                                            <?php } else { ?>
                                                                <img id="proof_image_preview" src="images/upload_image.png" style="max-width: 100px;" />
                                                            <?php } ?>
                                                        </div>
                                                    </div>        
                                                </div>
                                                <input type="file" name="proof_image" id="proof_image" style="display: none;" accept="image/*" />
                                            </label>
                                        </div>
                                        
                                        <div class="proof_image_container" style="display: none;">
                                            <canvas id="proof_image_canvas"></canvas>
                                        </div>
                                    </div>
                                </div>
                            </div>

                        </div>
                        <div class="col-12 text-center">
                            <button type="button" class="loginbtn medium submit_button default_button_css" onClick="Javascript:SaveModalContent(event, 'register_form', 'register_changes.php', 'login.php');"> Register</button>
                        </div>
                    </div>
                    <script type="text/javascript" src="js/image_upload.js"></script>

                    <script type="text/javascript">
                        jQuery(document).ready(function(){
                            jQuery('form[name="customer_profile_form"]').find('select').select2();
                        }); 
                    </script>

                    <script type="text/javascript" src="select2/js/select2.min.js"></script>
                    <script type="text/javascript" src="select2/js/select.js"></script>
                </form>
            </div> 
        </div>

    </div>
</div>
<?php include("modal_content.php"); ?>
<script>
$(document).ready(function() {
  $(function() {
    $('[data-toggle="tooltip"]').tooltip();
  });

  const passBtn = $("#passwordBtn");

  passBtn.click(togglePassword);

  function togglePassword() {
    const passInput = $("#password");
    if (passInput.attr("type") === "password") {
      passInput.attr("type", "text");
    } else {
      passInput.attr("type", "password");
    }
  }

  jQuery('.login_controls').on("keypress", function(e) {
    if (e.keyCode == 13) {
        SaveModalContent(event, 'login_form', 'customer_changes.php', 'dashboard.php');
        return false;
    }
});
});
</script>
</body>
</html>