<?php
	include("include.php");
	
	if(isset($_REQUEST['show_company_id'])) {
        $show_company_id = $_REQUEST['show_company_id'];

        $name = ""; $logo = ""; $address = ""; $address1 = ""; $address2 = ""; $city = ""; $pincode = ""; $state = ""; $mobile_number = ""; $email = ""; $gst_number = "";

        if(!empty($show_company_id)) {
            $company_list = array();
			$company_list = $obj->getTableRecords($GLOBALS['company_table'], 'company_id', $show_company_id);
            if(!empty($company_list)) {
                foreach($company_list as $data) {
                    if(!empty($data['name'])) {
                        $name = $obj->encode_decode('decrypt', $data['name']);
					}
					if(!empty($data['logo']) && $data['logo'] != $GLOBALS['null_value']) {
                        $logo = $data['logo'];
					}
					if(!empty($data['address'])) {
                        $address = $obj->encode_decode('decrypt', $data['address']);
						if(!empty($address)) {
							$address = explode("$$$", $address);
							if(!empty($address['0'])) {
								$address1 = $address['0'];
							}
							if(!empty($address['1'])) {
								$address2 = $address['1'];
							}
						}
					}
					if(!empty($data['city'])) {
                        $city = $obj->encode_decode('decrypt', $data['city']);
					}
					if(!empty($data['pincode'])) {
                        $pincode = $obj->encode_decode('decrypt', $data['pincode']);
					}
					if(!empty($data['state'])) {
                        $state = $obj->encode_decode('decrypt', $data['state']);
					}
					if(!empty($data['mobile_number'])) {
                        $mobile_number = $obj->encode_decode('decrypt', $data['mobile_number']);
					}
					if(!empty($data['email']) && $data['email'] != $GLOBALS['null_value']) {
                        $email = $obj->encode_decode('decrypt', $data['email']);
					}
					if(!empty($data['gst_number']) && $data['gst_number'] != $GLOBALS['null_value']) {
                        $gst_number = $obj->encode_decode('decrypt', $data['gst_number']);
					}
                }
            }
		}

		$target_dir = $obj->image_directory();
		if(!empty($target_dir)) {
			$target_dir = str_replace("include/", "../", $target_dir);
		}
?>
        <form class="py-4 poppins pd-20 redirection_form" name="company_form" method="POST">
            <input type="hidden" name="edit_id" value="<?php if(!empty($show_company_id)) { echo $show_company_id; } ?>">

			<div class="row">
				<div class="col-xl-6">
					<div class="form-group">
						<label class="form-control-label">Company Name *</label>
						<div class="w-100">
							<input type="text" class="form-control" name="name" value="<?php if(!empty($name)) { echo $name; } ?>" placeholder="Ex: A. bcd efg">
						</div>
					</div>
					<div class="form-group">
						<label class="form-control-label">Address 1 *</label>
						<div class="w-100">
							<input type="text" name="address1" value="<?php if(!empty($address1)) { echo $address1; } ?>" class="form-control shadow-none">
						</div>
					</div>
					<div class="form-group">
						<label class="form-control-label">Address 2</label>
						<div class="w-100">
							<input type="text" name="address2" value="<?php if(!empty($address2)) { echo $address2; } ?>" class="form-control shadow-none">
						</div>
					</div>
					<div class="form-group">
						<label class="form-control-label">City & Pincode *</label>
						<div class="w-100">
							<div class="input-group" style="position:initial;">
								<input type="text" name="city" class="form-control" value="<?php if(!empty($city)) { echo $city; } ?>">
								<div style="position: inherit; top: 0px;" class="input-group-append">
									<input type="text" class="form-control shadow-none" style="width: 100px;" size="6" maxlength="6" name="pincode" value="<?php if(!empty($pincode)) { echo $pincode; } ?>" placeholder="Ex: 666666">
								</div>
							</div>
						</div>
					</div>
					<div class="form-group">
						<label class="form-control-label">State *</label>
						<div class="w-100">
							<select name="state" class="form-control"></select>
						</div>
					</div>
				</div>
				<div class="col-xl-6">
					<div id="logo_cover" class="form-group">
						<h6 class="w-100 text-center">Max.Upload Size - 2 MB</h6> 
						<div class="image-upload text-center">
							<label for="logo">   
								<div class="logo_list row">
									<div class="col-12">
										<div class="cover">
											<?php if(!empty($logo) && file_exists($target_dir.$logo)) { ?>
												<button type="button" onclick="Javascript:delete_upload_image_before_save(this, 'logo', '<?php if(!empty($logo)) { echo $logo; } ?>');" class="btn btn-danger"><i class="fa fa-close"></i></button>
												<img id="logo_preview" src="<?php echo $target_dir.$logo; ?>" style="max-width: 100%; max-height: 150px;" />
												<input type="hidden" name="logo_name[]" value="<?php if(!empty($logo)) { echo $logo; } ?>">
											<?php } else { ?>
												<img id="logo_preview" src="include/images/upload_image.png" style="max-width: 150px;" />
											<?php } ?>
										</div>
									</div>        
								</div>
								<input type="file" name="logo" id="logo" style="display: none;" accept="image/*" />
							</label>
						</div>
						
						<div class="logo_container" style="display: none;">
							<canvas id="logo_canvas"></canvas>
						</div>
					</div>

					<div class="row">
						<div class="col-sm-4">
							<div class="form-group">
								<label class="form-control-label">Mobile Number *</label>
								<div class="w-100">
									<input type="text" class="form-control" name="mobile_number" value="<?php if(!empty($mobile_number)) { echo $mobile_number; } ?>" placeholder="Ex: 99999 99999,99999 99999">
								</div>
							</div>
						</div>
						<div class="col-sm-8">
							<div class="form-group">
								<label class="form-control-label">Email</label>
								<div class="w-100">
									<input type="text" class="form-control" name="email" value="<?php if(!empty($email)) { echo $email; } ?>" placeholder="abc@gmail.com">
								</div>
							</div>
						</div>
						<div class="col-sm-6">
							<div class="form-group">
								<label class="form-control-label">GST Number</label>
								<div class="w-100">
									<input type="text" class="form-control" name="gst_number" value="<?php if(!empty($gst_number)) { echo $gst_number; } ?>" placeholder="Ex: 99AAAAA9999A9AA">
								</div>
							</div>
						</div>
					</div>

				</div>
			</div>

			<div class="w-100 text-center">
				<button class="btn btn-primary btnwidth submit_button" type="button" onClick="Javascript:SaveModalContent(event, 'company_form', 'company_changes.php', 'company.php');">Submit</button>
				&nbsp; <a href="company.php" class="btn btn-danger">Back</a>
			</div>

			<script type="text/javascript" src="include/js/image_upload.js"></script>
			<script type="text/javascript" src="include/js/state.js"></script>
			<script type="text/javascript">
				jQuery(document).ready(function(){
					jQuery('form[name="company_form"]').find('select').select2();

					DisplayCustomerState('<?php if(!empty($state)) { echo $state; } ?>');
				}); 
			</script>
        </form>
<?php        
    }

    if(isset($_POST['name'])) {	
		$name = ""; $name_error = ""; $logo_name = array(); $logo = ""; $address1 = ""; $address2 = ""; $address = ""; $address_error = ""; $city = ""; $pincode = "";
		$city_pincode_error = ""; $state = ""; $state_error = ""; $mobile_number = ""; $mobile_number_error = ""; $email = ""; $email_error = ""; $gst_number = "";
		$gst_number_error = "";

		$valid_company = ""; $form_name = "company_form";
	
        $name = $_POST['name'];
		$name = trim($name);
        $name_error = $valid->common_validation($name, "name", "text");
		if(!empty($name_error)) {
			$valid_company = $valid->error_display($form_name, "name", $name_error, 'text');			
		}

		if(isset($_POST['logo_name'])) {
            $logo_name = $_POST['logo_name'];	
        }

		$address1 = $_POST['address1'];
		$address1 = trim($address1);
		$address_error = $valid->common_validation($address1, "Address 1", "text");
		if(!empty($address_error)) {
			if(!empty($valid_company)) {
				$valid_company = $valid_company." ".$valid->error_display($form_name, "address1", $address_error, 'text');
			}
			else {
				$valid_company = $valid->error_display($form_name, "address1", $address_error, 'text');
			}
		}
		else {
			if(isset($_POST['address2'])) {
				$address2 = $_POST['address2'];
				$address2 = trim($address2);
				if(!empty($address2)) {
					$address_error = $valid->common_validation($address2, "Address 2", "text");
					if(!empty($address_error)) {
						if(!empty($valid_company)) {
							$valid_company = $valid_company." ".$valid->error_display($form_name, "address2", $address_error, 'text');
						}
						else {
							$valid_company = $valid->error_display($form_name, "address2", $address_error, 'text');
						}
					}
				}
			}
		}

		if(!empty($address1) && empty($address_error)) {
			$address = $address1;
			if(!empty($address2)) {
				$address = $address."$$$".$address2;
			}
		}

		if(isset($_POST['city'])) {
			$city = $_POST['city'];
			$city = trim($city);
		}

		if(isset($_POST['pincode'])) {
			$pincode = $_POST['pincode'];
			$pincode = trim($pincode);
		}

		$city_pincode_error = $valid->valid_city_pincode($city, $pincode);
		if(!empty($city_pincode_error)) {
			if(!empty($valid_company)) {
				$valid_company = $valid_company." ".$valid->error_display($form_name, "city", $city_pincode_error, 'input_group');
			}
			else {
				$valid_company = $valid->error_display($form_name, "city", $city_pincode_error, 'input_group');
			}
		}

		$state = $_POST['state'];
		$state = trim($state);
		$state_error = $valid->common_validation($state, "State", "select");
		if(!empty($state_error)) {
			if(!empty($valid_company)) {
				$valid_company = $valid_company." ".$valid->error_display($form_name, "state", $state_error, 'select');
			}
			else {
				$valid_company = $valid->error_display($form_name, "state", $state_error, 'select');
			}
		}

		$mobile_number = $_POST['mobile_number'];
        $mobile_number = trim($mobile_number);
        if(!empty($mobile_number)) {
            $mobile_number = explode(",", $mobile_number);
            for($m = 0; $m < count($mobile_number); $m++) {
                $mobile_number_error = $valid->valid_mobile_number($mobile_number[$m], "Mobile Number", "1");
            }
        }
        else {
            $mobile_number_error = "Enter the mobile number";
        }
		if(!empty($mobile_number_error)) {
			if(!empty($valid_company)) {
				$valid_company = $valid_company." ".$valid->error_display($form_name, "mobile_number", $mobile_number_error, 'text');
			}
			else {
				$valid_company = $valid->error_display($form_name, "mobile_number", $mobile_number_error, 'text');
			}
		}

		$email = $_POST['email'];
		$email = trim($email);
		if(!empty($email)) {
			$email_error = $valid->valid_email($email, "Email", "1");
			if(!empty($email_error)) {
				if(!empty($valid_company)) {
					$valid_company = $valid_company." ".$valid->error_display($form_name, "email", $email_error, 'text');
				}
				else {
					$valid_company = $valid->error_display($form_name, "email", $email_error, 'text');
				}
			}
		}

		$gst_number = $_POST['gst_number'];
		$gst_number = trim($gst_number);
		if(!empty($gst_number)) {
			$gst_number_error = $valid->valid_gst_number($gst_number, "GST Number", "text");
			if(!empty($gst_number_error)) {
				if(!empty($valid_company)) {
					$valid_company = $valid_company." ".$valid->error_display($form_name, "gst_number", $gst_number_error, 'text');
				}
				else {
					$valid_company = $valid->error_display($form_name, "gst_number", $gst_number_error, 'text');
				}
			}
		}

		if(isset($_POST['edit_id'])) {
			$edit_id = $_POST['edit_id'];
		}

		if(empty($edit_id) && empty($valid_company)) {
			$max_company_count = 1; $company_count = 0;
			$company_list = array();
			$company_list = $obj->getTableRecords($GLOBALS['company_table'], '', '');
			if(!empty($company_list)) {
				$company_count = count($company_list);
			}
			if(!empty($company_count) && $company_count == 1) {
				$name_error = "Max Company Count : 1";
				if(!empty($name_error)) {
					$valid_company = $valid->error_display($form_name, "name", $name_error, 'text');			
				}
			}
		}
		
		$result = "";
		
		if(empty($valid_company)) {
			$check_user_id_ip_address = "";
			$check_user_id_ip_address = $obj->check_user_id_ip_address();	
			if(preg_match("/^\d+$/", $check_user_id_ip_address)) {

				if(!empty($logo_name) && is_array($logo_name)) {
                    $logo = implode("$$$", $logo_name);
                }
                if(empty($logo)) {
                    $logo = $GLOBALS['null_value'];
                }

				if(!empty($mobile_number) && is_array($mobile_number)) {
                    $mobile_number = implode(", ", $mobile_number);
                }

				$image_copy = 0; $prev_logo = "";
                if(!empty($edit_id)) {		
					$prev_logo = $obj->getTableColumnValue($GLOBALS['company_table'], 'company_id', $edit_id, 'logo');
                }
				
				$lower_case_name = "";
				if(!empty($name)) {
					$lower_case_name = strtolower($name);
					$lower_case_name = $obj->encode_decode('encrypt', $lower_case_name);
					$name = $obj->encode_decode('encrypt', $name);
				}
				if(!empty($address)) {
					$address = $obj->encode_decode('encrypt', $address);
				}
				if(!empty($city)) {
					$city = $obj->encode_decode('encrypt', $city);
				}
				if(!empty($pincode)) {
					$pincode = $obj->encode_decode('encrypt', $pincode);
				}
				if(!empty($state)) {
					$state = $obj->encode_decode('encrypt', $state);
				}
				if(!empty($mobile_number)) {
					$mobile_number = $obj->encode_decode('encrypt', $mobile_number);
				}
				if(!empty($email)) {
					$email = $obj->encode_decode('encrypt', $email);
				}
				else {
					$email = $GLOBALS['null_value'];
				}
				if(!empty($gst_number)) {
					$gst_number = $obj->encode_decode('encrypt', $gst_number);
				}
				else {
					$gst_number = $GLOBALS['null_value'];
				}
				
				$prev_company_id = ""; $company_error = "";			
				if(!empty($lower_case_name)) {
					$prev_company_id = $obj->getTableColumnValue($GLOBALS['company_table'], 'lower_case_name', $lower_case_name, 'company_id');
					if(!empty($prev_company_id)) {
                        $company_error = "This name is already exist";
                    }
                }
				$gst_company_id = ""; $gst_number_error = "";
                if((!empty($gst_number) && $gst_number != $GLOBALS['null_value'])) {
					$gst_company_id = $obj->getTableColumnValue($GLOBALS['company_table'], 'gst_number', $gst_number, 'company_id');
					if(!empty($gst_company_id)) {
                        $gst_number_error = "This GST number is already exist";
                    }
                }

				$created_date_time = $GLOBALS['create_date_time_label']; $creator = $GLOBALS['creator'];
				$creator_name = $obj->encode_decode('encrypt', $GLOBALS['user_name']);

				$company_mobile_number = "";
				
				if(empty($edit_id)) {
					if(empty($prev_company_id)) {		
						if(empty($gst_company_id)) {				
							$action = "";
							if(!empty($name)) {
								$action = "New Company Created. Name - ".$obj->encode_decode('decrypt', $name);
							}

							$null_value = $GLOBALS['null_value'];
							$columns = array('created_date_time', 'creator', 'creator_name', 'company_id', 'name', 'lower_case_name', 'logo', 'address', 'city', 'pincode', 'state', 'mobile_number', 'email', 'gst_number', 'deleted');
							$values = array("'".$created_date_time."'", "'".$creator."'", "'".$creator_name."'", "'".$null_value."'", "'".$name."'", "'".$lower_case_name."'", "'".$logo."'", "'".$address."'", "'".$city."'", "'".$pincode."'", "'".$state."'", "'".$mobile_number."'", "'".$email."'", "'".$gst_number."'", "'0'");
							$company_insert_id = $obj->InsertSQL($GLOBALS['company_table'], $columns, $values, $action);						
							if(preg_match("/^\d+$/", $company_insert_id)) {
								$company_id = "";
								if($company_insert_id < 10) {
									$company_id = "company_".date("dmYhis")."_0".$company_insert_id;
								}
								else {
									$company_id = "company_".date("dmYhis")."_".$company_insert_id;
								}
								if(!empty($company_id)) {
									$company_id = $obj->encode_decode('encrypt', $company_id);
								}
								$columns = array(); $values = array();						
								$columns = array('company_id');
								$values = array("'".$company_id."'");
								$company_update_id = $obj->UpdateSQL($GLOBALS['company_table'], $company_insert_id, $columns, $values, '');
								if(preg_match("/^\d+$/", $company_update_id)) {
									$image_copy = 1; $company_mobile_number = $mobile_number;
									$result = array('number' => '1', 'msg' => 'Company Successfully Created');					
								}
								else {
									$result = array('number' => '2', 'msg' => $company_update_id);
								}
							}
							else {
								$result = array('number' => '2', 'msg' => $company_insert_id);
							}
						}
						else {
                            $result = array('number' => '2', 'msg' => $gst_number_error);
                        }	
					}
					else {
						$result = array('number' => '2', 'msg' => $company_error);
					}
				}
				else {
					if(empty($prev_company_id) || $prev_company_id == $edit_id) {
						if(empty($gst_company_id) || $gst_company_id == $edit_id) {
							$getUniqueID = "";
							$getUniqueID = $obj->getTableColumnValue($GLOBALS['company_table'], 'company_id', $edit_id, 'id');
							if(preg_match("/^\d+$/", $getUniqueID)) {
								$action = "";
								if(!empty($name)) {
									$action = "Company Updated. Name - ".$obj->encode_decode('decrypt', $name);
								}
							
								$columns = array(); $values = array();						
								$columns = array('creator_name', 'name', 'lower_case_name', 'logo', 'address', 'city', 'pincode', 'state', 'mobile_number', 'email', 'gst_number');
								$values = array("'".$creator_name."'", "'".$name."'", "'".$lower_case_name."'", "'".$logo."'", "'".$address."'", "'".$city."'", "'".$pincode."'", "'".$state."'", "'".$mobile_number."'", "'".$email."'", "'".$gst_number."'");
								$company_update_id = $obj->UpdateSQL($GLOBALS['company_table'], $getUniqueID, $columns, $values, $action);
								if(preg_match("/^\d+$/", $company_update_id)) {
									$image_copy = 1; $company_mobile_number = $mobile_number;
									$result = array('number' => '1', 'msg' => 'Updated Successfully');						
								}
								else {
									$result = array('number' => '2', 'msg' => $company_update_id);
								}							
							}
						}
						else {
                            $result = array('number' => '2', 'msg' => $gst_number_error);
                        }	
					}
					else {
						$result = array('number' => '2', 'msg' => $company_error);
					}
                }

				if(!empty($image_copy) && $image_copy == 1) {
					$target_dir = $obj->image_directory();
					if(!empty($target_dir)) {
						$target_dir = str_replace("include/", "../", $target_dir);
					}

					$temp_dir = $obj->temp_image_directory();
					if(!empty($temp_dir)) {
						$temp_dir = str_replace("include/", "../", $temp_dir);
					}
					if(!empty($logo)) {				
						if(file_exists($temp_dir.$logo)) {   
							if(!empty($prev_logo)) {		
								if(file_exists($target_dir.$prev_logo)) {   
									unlink($target_dir.$prev_logo);
								}
							}
							copy($temp_dir.$logo, $target_dir.$logo);
						}
						else {
							if($logo == $GLOBALS['null_value']) {
								if(!empty($prev_logo) && file_exists($target_dir.$prev_logo)) {   
									unlink($target_dir.$prev_logo);
								}
							}
						}
					}
					$obj->clear_temp_image_directory();
				}

			}
			else {
				$result = array('number' => '2', 'msg' => 'Invalid IP');
			}
		}
		else {
			if(!empty($valid_company)) {
				$result = array('number' => '3', 'msg' => $valid_company);
			}
		}
		
		if(!empty($result)) {
			$result = json_encode($result);
		}
		echo $result; exit;
	}
	
	if(isset($_POST['page_number'])) {
		$page_number = $_POST['page_number'];
		$page_limit = $_POST['page_limit'];
		$page_title = $_POST['page_title'];

		$search_text = "";
		if(isset($_POST['search_text'])) {
			$search_text = $_POST['search_text'];
		}

		$total_records_list = array();
		$total_records_list = $obj->getTableRecords($GLOBALS['company_table'], '', '');

		if(!empty($search_text)) {
			$search_text = strtolower($search_text);
			$list = array();
			if(!empty($total_records_list)) {
				foreach($total_records_list as $val) {
					if( (strpos(strtolower($obj->encode_decode('decrypt', $val['name'])), $search_text) !== false) ) {
						$list[] = $val;
					}
				}
			}
			$total_records_list = $list;
		}
		
		$total_pages = 0;
		if(!empty($total_records_list)) {
			$total_pages = count($total_records_list);
		}
		
		$page_start = 0; $page_end = 0;
		if(!empty($page_number) && !empty($page_limit) && !empty($total_pages)) {
			if($total_pages > $page_limit) {
				if($page_number) {
					$page_start = ($page_number - 1) * $page_limit;
					$page_end = $page_start + $page_limit;
				}
			}
			else {
				$page_start = 0;
				$page_end = $page_limit;
			}
		}

		$show_records_list = array();
        if(!empty($total_records_list)) {
            $show_records_list = array_slice($total_records_list, $page_start, $page_limit);
        }
?>
        
		<?php if($total_pages > $page_limit) { ?>
			<div class="pagination_cover mt-3"> 
				<?php
					include("pagination.php");
				?> 
			</div> 
		<?php } ?>

		<table class="table nowrap">
			<thead class="thead-dark">
                <tr>
					<th class="text-center px-2 py-2" style="width: 75px;">S.No</th>
                    <th class="text-center px-2 py-2" style="width: 125px;">Created Date</th>
                    <th class="text-center px-2 py-2">Name</th>
					<th class="text-center px-2 py-2" style="width: 150px;">Mobile Number</th>
                    <th class="text-center px-2 py-2" style="width: 100px;">Action</th>
                </tr>
            </thead>
            <tbody>
				<?php
					if(!empty($show_records_list)) {
						foreach($show_records_list as $key => $data) {
							$index = $key + 1;
							if(!empty($page_number) && $page_number > 1) {
								$prefix = 0;
								$prefix = ($page_number * $page_limit) - $page_limit;
								if(!empty($prefix)) {
									$index = $prefix + $index;
								}
							}
				?>
							<tr>
								<td class="text-center px-2 py-2" style="width: 75px;"><?php echo $index; ?></td>
								<td class="text-center px-2 py-2">
									<?php if(!empty($data['created_date_time']) && $data['created_date_time'] != "0000-00-00 00:00:00") { echo date("d-m-Y", strtotime($data['created_date_time'])); } ?>
								</td>
								<td class="px-2 py-2">
									<div class="w-100">
										<?php
											if(!empty($data['name'])) {
												$data['name'] = $obj->encode_decode('decrypt', $data['name']);
												echo $data['name'];
											}
										?>
									</div>
									
									<?php
										if(!empty($data['creator_name'])) {
											$data['creator_name'] = $obj->encode_decode('decrypt', $data['creator_name']);
									?>
											<small><?php echo "Last Opened : ".$data['creator_name']; ?></small>
									<?php		
										}
									?>
								</td>
								<td class="text-center px-2 py-2">
									<?php
										if(!empty($data['mobile_number'])) {
											$data['mobile_number'] = $obj->encode_decode('decrypt', $data['mobile_number']);
											echo $data['mobile_number'];
										}
									?>
								</td>
								<td class="text-center px-2 py-2">
									<div class="dropdown">
										<a class="btn btn-dark poppins px-3" href="#" role="button" data-toggle="dropdown">
											<i class="fa fa-ellipsis-v text-white"></i>
										</a>
										<div class="dropdown-menu dropdown-menu-right dropdown-menu-icon-list">
											<a class="dropdown-item" href="Javascript:ShowModalContent('<?php if(!empty($page_title)) { echo $page_title; } ?>', '<?php if(!empty($data['company_id'])) { echo $data['company_id']; } ?>');"><i class="fa fa-pencil"></i> &ensp; View / Edit</a>
											<?php /* ?><a class="dropdown-item" href="Javascript:DeleteModalContent('<?php if(!empty($page_title)) { echo $page_title; } ?>', '<?php if(!empty($data['company_id'])) { echo $data['company_id']; } ?>');"><i class="fa fa-trash"></i> &ensp; Delete</a> <?php */ ?>
										</div>
									</div>
								</td>
							</tr>
                <?php
                        }
                    }
                    else {
                ?>
                        <tr>
                            <td colspan="5" class="text-center">Sorry! No records found</td>
                        </tr>
                <?php } ?>
            </tbody>
        </table>
<?php	
	}
	
	/*if(isset($_REQUEST['delete_company_id'])) {
		$delete_company_id = $_REQUEST['delete_company_id'];
		$msg = "";
		if(!empty($delete_company_id)) {
			$company_unique_id = "";
			$company_unique_id = $obj->getTableColumnValue($GLOBALS['company_table'], 'company_id', $delete_company_id, 'id');
			if(preg_match("/^\d+$/", $company_unique_id)) {
				$name = "";
				$name = $obj->getTableColumnValue($GLOBALS['company_table'], 'company_id', $delete_company_id, 'name');
			
				$action = "";
				if(!empty($name)) {
					$action = "Company Deleted. Name - ".$obj->encode_decode('decrypt', $name);
				}
			
				$columns = array(); $values = array();						
				$columns = array('deleted');
				$values = array("'1'");
				$msg = $obj->UpdateSQL($GLOBALS['company_table'], $company_unique_id, $columns, $values, $action);
			}
		}
		echo $msg;
		exit;	
	}*/
?>