<?php 
    include("include_user_check.php");

	$page_title = "Direct Booking"; $order_date = date("d-m-Y");

    $agent_list = array();
	$agent_list = $obj->getTableRecords($GLOBALS['agent_table'], '', '');

	$customer_list = array();
	$customer_list = $obj->getTableRecords($GLOBALS['customer_table'], '', '');

    $product_list = array();
    $product_list = $obj->getTableRecords($GLOBALS['product_table'], '', '');
?>
<!DOCTYPE html>
<html lang="en">
<head>
	<title> <?php if(!empty($project_title)) { echo $project_title; } ?> - <?php if(!empty($page_title)) { echo $page_title; } ?> </title>
	<?php include "link_style_script.php"; ?>

	<script type="text/javascript" src="include/js/direct_booking.js"></script>
</head>
<body>
	<?php include "header.php";  ?>
	<!-- sidebar-wrapper  -->          
	<div class="page-wrapper chiller-theme toggled">
		<main class="page-content">
			<div class="container-fluid px-lg-5">
				<div class="w-100">

                    <div class="border card-box">
                        <div class="card-header">
                            <div class="row">
                                <div class="col-sm-4 text-center text-sm-left"><?php if(!empty($page_title)) { echo $page_title; } ?></div>
                                <div class="col-sm-4 text-center"> <?php if(!empty($order_date)) { echo "Order Date : ".$order_date; } ?> </div>
                                <div class="col-sm-4 text-center text-sm-right">
                                    <button class="btn btn-primary btnwidth submit_button" type="button" onClick="Javascript:SaveOrder('direct_order_form');">Submit</button>
                                </div>
                            </div>
                        </div>
                        <div class="card-body add_update_form_content">
                            <form name="direct_order_form" method="post">
                                <div class="row">
                                    <div class="col-sm-4">
                                        <div class="form-group">
                                            <div class="w-100">
                                                <select name="agent_id" class="form-control" fieldindex='1' tabindex='1' onChange="Javascript:getAgentCustomerList(this.value);">
                                                    <option value="">Select Agent</option>
                                                    <?php
                                                        if(!empty($agent_list)) {
                                                            foreach($agent_list as $data) {
                                                                if(!empty($data['agent_id'])) {
                                                    ?>
                                                                    <option value="<?php echo $data['agent_id']; ?>">
                                                                        <?php
                                                                            if(!empty($data['name'])) {
                                                                                $data['name'] = $obj->encode_decode('decrypt', $data['name']);
                                                                                echo $data['name'];
                                                                                if(!empty($data['mobile_number'])) {
                                                                                    $data['mobile_number'] = $obj->encode_decode('decrypt', $data['mobile_number']);
                                                                                    echo " (".$data['mobile_number'].")";
                                                                                }
                                                                            }
                                                                        ?>
                                                                    </option>
                                                    <?php
                                                                }
                                                            }
                                                        }
                                                    ?>
                                                </select>
                                            </div>
                                        </div>
                                        <div class="form-group">
                                            <div id="agent_customer_cover" class="w-100">
                                                <select name="customer_id" class="form-control" fieldindex='2' tabindex='2' onChange="Javascript:getShippingAddressList();">
                                                    <option value="">Select Customer</option>
                                                    <?php
                                                        if(!empty($customer_list)) {
                                                            foreach($customer_list as $data) {
                                                                if(!empty($data['customer_id'])) {
                                                    ?>
                                                                    <option value="<?php echo $data['customer_id']; ?>">
                                                                        <?php
                                                                            if(!empty($data['name'])) {
                                                                                $data['name'] = $obj->encode_decode('decrypt', $data['name']);
                                                                                echo $data['name'];
                                                                                if(!empty($data['mobile_number'])) {
                                                                                    $data['mobile_number'] = $obj->encode_decode('decrypt', $data['mobile_number']);
                                                                                    echo " (".$data['mobile_number'].")";
                                                                                }
                                                                            }
                                                                        ?>
                                                                    </option>
                                                    <?php
                                                                }
                                                            }
                                                        }
                                                    ?>
                                                </select>
                                            </div>
                                        </div>                                        
                                        <div class="form-group wallet_amount_cover d-none">
                                            <div class="row">
                                                <div class="col-6 text-left">Wallet Amount</div>
                                                <div class="col-6 text-right wallet_amount" style="font-weight: bold;"></div>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="col-sm-4">
                                        <div class="row">
                                            <div class="col-lg-12 pb-3">
                                                <div class="row">
                                                    <div class="col-8">
                                                        <div class="medium fnt1 font-weight-bold"> Shipping Address </div>
                                                    </div>
                                                    <div class="col-4 text-right">
                                                        <a class="medium fnt1 font-weight-bold text-dark" href="Javascript:ClearShippingAddress();">
                                                            <i class="fa fa-plus-circle"></i> &nbsp; Add
                                                        </a>
                                                        <button class="d-none shipping_form_button" type="button" data-toggle="collapse" data-target="#shipping_form_cover" aria-expanded="false" aria-controls="shipping_form_cover"></button>
                                                    </div>
                                                </div>
                                                <div class="collapse shipping_form_cover col-12 mb-3" id="shipping_form_cover">
                                                    <script type="text/javascript">
                                                        EditShippingAddress('');
                                                    </script>
                                                </div>
                                            </div>
                                        </div>
                                        <div class="shipping_address_cover mb-3">

                                        </div>
                                    </div>
                                    <div class="col-sm-4">
                                        <div class="form-group">
                                            <div class="row">
                                                <div class="col-6 text-left">Sub Total</div>
                                                <div class="col-6 text-right sub_total"></div>
                                            </div>
                                        </div>
                                        <div class="form-group <?php if($project_allow_discount != 1) { echo "d-none"; } ?>">
                                            <div class="row">
                                                <div class="col-4 text-left">Discount</div>
                                                <div class="col-4">
                                                    <div class="input-group">
                                                        <input type="text" name="top_discount" class="form-control" tabindex='8' value="<?php if(!empty($discount)) { echo $discount; } ?>" onChange="Javascript:TopDiscount();">
                                                        <div style="position: inherit;" class="input-group-append">
                                                            <span class="btn btn-secondary py-1"><i class="fa fa-percent"></i></span>
                                                        </div>
                                                    </div>
                                                </div>
                                                <div class="col-4 text-right discount_value"></div>
                                            </div>
                                        </div>
                                        <div class="form-group <?php if($project_allow_discount != 1) { echo "d-none"; } ?>">
                                            <div class="row">
                                                <div class="col-6 text-left">Total</div>
                                                <div class="col-6 text-right net_total"></div>
                                            </div>
                                        </div>
                                        <div class="form-group">
                                            <div class="row">
                                                <div class="col-5 text-left">Packing Charges</div>
                                                <div class="col-3">
                                                    <input type="text" class="form-control transport_charges shadow-none" tabindex='<?php if($project_allow_discount == 1) { echo "9";  } else { echo "8"; } ?>' name="top_packing_charges" value="<?php if(!empty($packing_charges)) { echo $packing_charges; } ?>" onChange="Javascript:TopPackingCharges();">
                                                </div>
                                                <div class="col-4 text-right packing_charges_value"></div>
                                            </div>
                                        </div>
                                        <div class="form-group">
                                            <div class="row">
                                                <div class="col-6 text-left">Grand Total</div>
                                                <div class="col-6 text-right grand_total"></div>
                                            </div>
                                        </div>
                                        <div class="form-group">
                                            <div class="row">
                                                <div class="col-6 text-left">Round OFF</div>
                                                <div class="col-6 text-right round_off"></div>
                                            </div>
                                        </div>
                                        <div class="form-group">
                                            <div class="row">
                                                <div class="col-6 text-left">Overall Total</div>
                                                <div class="col-6 text-right overall_total"></div>
                                            </div>
                                        </div>
                                    </div>
                                </div>

                                <div class="col-12">
                                    <div class="row">
                                        <div class="col-xl-5">
                                            <div class="form-group">
                                                <div class="form-label-group in-border mb-0">
                                                    <div class="input-group">
                                                        <select name="selected_product_id" class="form-control" fieldindex='3' tabindex='3' onChange="javascript:getProductDetails(this.value);">
                                                            <option value="">Select Product</option>
                                                            <?php
                                                                if(!empty($product_list)) {
                                                                    foreach($product_list as $data) {
                                                                        if(!empty($data['product_id'])) {
                                                            ?>
                                                                            <option value="<?php if(!empty($data['product_id'])) { echo $data['product_id']; } ?>">
                                                                                <?php
                                                                                    if(!empty($data['product_code'])) {
                                                                                        $data['product_code'] = $obj->encode_decode('decrypt', $data['product_code']);
                                                                                        echo $data['product_code'];
                                                                                        if(!empty($data['name'])) {
                                                                                            $data['name'] = $obj->encode_decode('decrypt', $data['name']);
                                                                                            $data['name'] = str_replace("$", '"', $data['name']);
                                                                                            $data['name'] = str_replace("'''", '"', $data['name']);
                                                                                            echo " - ".$data['name'];
                                                                                        }
                                                                                    }
                                                                                ?>
                                                                            </option>
                                                            <?php     
                                                                        }       
                                                                    }
                                                                }
                                                            ?>
                                                        </select>
                                                        <div style="position: inherit;" class="input-group-append">
                                                            <button class="btn btn-dark poppins" tabindex='4' style="font-size:11px;" type="button" onClick="javascript:AddCustomRow();"><i class="fa fa-file"></i></button>
                                                        </div>
                                                    </div>                                            
                                                </div>
                                            </div>
                                        </div>  
                                        <div class="col-sm-6 col-xl-2">
                                            <div class="form-group">
                                                <div class="form-label-group in-border mb-0">
                                                    <input type="number" name="selected_quantity" tabindex='5' class="form-control" value="" placeholder="Quantity" onKeyup="Javascript:CalProductAmount();">
                                                    <label>Quantity (*)</label>
                                                </div>                                        
                                            </div>
                                        </div>
                                        <div class="col-sm-6 col-xl-2">
                                            <div class="form-group">
                                                <div class="form-label-group in-border mb-0">
                                                    <input type="text" name="selected_rate" class="form-control" tabindex='6' value="" placeholder="Rate" onKeyup="Javascript:CalProductAmount();">
                                                    <label>Rate (*)</label>
                                                </div>
                                                <div class="selected_product_content w-100 text-center mt-1" style="font-size: 13px;"></div>
                                            </div>
                                        </div>
                                        <div class="col-xl-3">
                                            <div class="form-group">
                                                <div class="form-label-group in-border mb-0">
                                                    <div class="input-group">
                                                        <input type="text" name="selected_amount" class="form-control" disabled value="" placeholder="Amount">
                                                        <label style="z-index:999;">Amount</label>
                                                        <div style="position: inherit;" class="input-group-append">
                                                            <button class="btn btn-dark poppins add_details_buttton" tabindex='7' style="font-size:11px;" type="button" onClick="javascript:AddDetails();"><i class="fa fa-plus-circle"></i> &ensp; Add</button>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <div class="col-12">
                                    <div class="table-responsive">
                                        <input type="hidden" name="product_count" value="<?php if(!empty($edit_order_id) && !empty($product_ids)) { echo count($product_ids); } else { echo "0"; } ?>">
                                        <table class="data-table table nowrap tablefont order_products_table" style="margin: auto; min-width: 650px;">
                                            <thead class="thead-dark">
                                                <tr>
                                                    <th style="text-align: center; width: 10px; padding: 5px;">S.No</th>
                                                    <th style="text-align: center;">Product Name</th>
                                                    <th style="text-align: center; width: 75px;">Quantity</th>
                                                    <th style="text-align: center; width: 100px;">Price</th>
                                                    <th style="text-align: center; width: 100px;">Amount</th>
                                                    <th style="text-align: center; width: 50px;">Delete</th>
                                                </tr>
                                            </thead>
                                            <tbody>                                                
                                            </tbody>   
                                            <tfoot>
                                                <td colspan="6" style="padding: 0;">
                                                    <table class="bill_table" cellpadding="0" cellspacing="0" style="float: right; font-size: 15px; width: 100%;">
                                                        <thead>
                                                            <tr>
                                                                <td colspan="2" style="white-space: nowrap; text-align: right; border-top: none;">
                                                                    Sub Total
                                                                </td>
                                                                <td class="sub_total" style="width: 20%; border-top: none; text-align: right;"></td>
                                                                <td style="width: 70px; border-top: none;"></td>
                                                            </tr>
                                                            <tr <?php if($project_allow_discount != 1) { ?> class="d-none" <?php } ?>>
                                                                <td style="white-space: nowrap; text-align: right; border-top: none;">
                                                                    Discount
                                                                </td>
                                                                <td style="width: 150px; border-top: none;">
                                                                    <div class="input-group">
                                                                        <input type="text" name="bottom_discount" class="form-control" tabindex='10' value="" onChange="Javascript:BottomDiscount();">
                                                                        <div style="position: inherit;" class="input-group-append">
                                                                            <span class="btn btn-secondary py-1"><i class="fa fa-percent"></i></span>
                                                                        </div>
                                                                    </div>
                                                                </td>
                                                                <td class="discount_value" style="width: 20%; border-top: none; text-align: right;"></td>
                                                                <td style="width: 70px; border-top: none;"></td>
                                                            </tr>
                                                            <tr <?php if($project_allow_discount != 1) { ?> class="d-none" <?php } ?>>
                                                                <td colspan="2" style="white-space: nowrap; text-align: right; border-top: none;">
                                                                    Total
                                                                </td>
                                                                <td class="net_total" style="width: 20%; border-top: none; text-align: right;"></td>
                                                                <td style="width: 70px; border-top: none;"></td>
                                                            </tr>
                                                            <tr>
                                                                <td style="white-space: nowrap; text-align: right; border-top: none;">
                                                                    Packing Charges
                                                                </td>
                                                                <td style="width: 100px; border-top: none;">
                                                                    <input type="text" class="form-control transport_charges shadow-none" tabindex='<?php if($project_allow_discount == 1) { echo "11";  } else { echo "9"; } ?>' name="bottom_packing_charges" value="" onChange="Javascript:BottomPackingCharges();">
                                                                </td>
                                                                <td class="packing_charges_value" style="width: 20%; border-top: none; text-align: right;"></td>
                                                                <td style="width: 70px; border-top: none;"></td>
                                                            </tr>
                                                            <tr>
                                                                <td colspan="2" style="white-space: nowrap; text-align: right; border-top: none;">
                                                                    Grand Total
                                                                </td>
                                                                <td class="grand_total" style="width: 20%; border-top: none; text-align: right;"></td>
                                                                <td style="width: 70px; border-top: none;"></td>
                                                            </tr>
                                                            <tr>
                                                                <td colspan="2" style="white-space: nowrap; text-align: right; border-top: none;">
                                                                    Round OFF
                                                                </td>
                                                                <td class="round_off" style="width: 20%; border-top: none; text-align: right;"></td>
                                                                <td style="width: 70px; border-top: none;"></td>
                                                            </tr>
                                                            <tr>
                                                                <td colspan="2" style="white-space: nowrap; text-align: right; border-top: none;">
                                                                    Overall Total
                                                                    <input type="hidden" name="discount" value="">
                                                                    <input type="hidden" name="packing_charges" value="">
                                                                </td>
                                                                <td class="overall_total" style="width: 20%; border-top: none; text-align: right;"></td>
                                                                <td style="width: 70px; border-top: none;"></td>
                                                            </tr>
                                                        </thead>
                                                    </table>    
                                                </td>
                                            </tfoot>                                   
                                        </table>
                                    </div>
                                </div>                                
                            </form>
                        </div>
                    </div>
					
				</div>
			</div>
		</main>
	</div>  
	<!-- page-wrapper -->

	<?php include "footer.php"; ?>

	<script>
		jQuery(document).ready(function(){
			jQuery("#bookingactive").addClass("active");
            jQuery("#direct_bookingactive").addClass("active");			
		});		
	</script>
	
    </body>
</html>