function getAgentCustomerList(agent_id) {
	if(jQuery('#shipping_form_cover').hasClass('show')) {
		ClearShippingAddress();
	}
    if(jQuery('.shipping_address_cover').length > 0) {
        jQuery('.shipping_address_cover').html('');
    }
    if(jQuery('.wallet_amount').length > 0) {
        jQuery('.wallet_amount').html('');
    }
    if(jQuery('.wallet_amount_cover').length > 0) {
        jQuery('.wallet_amount_cover').addClass('d-none');
    }

    var check_login_session = 1;
    var post_url = "dashboard_changes.php?check_login_session=1";	
    jQuery.ajax({url: post_url, success: function(check_login_session){
        if(check_login_session == 1) {	
            var post_url = "direct_booking_changes.php?get_customer_list_by_agent_id="+agent_id;
            jQuery.ajax({url: post_url, success: function(result){
                if(jQuery('#agent_customer_cover').length > 0) {
					jQuery('#agent_customer_cover').html(result);
				}
                getShippingAddressList();
            }});
        }
        else {
            window.location.reload();
        }
    }});
}

function getShippingAddressList() {
	if(jQuery('#shipping_form_cover').hasClass('show')) {
		ClearShippingAddress();
	}
    if(jQuery('.shipping_address_cover').length > 0) {
        jQuery('.shipping_address_cover').html('');
    }
    if(jQuery('.wallet_amount').length > 0) {
        jQuery('.wallet_amount').html('');
    }
    if(jQuery('.wallet_amount_cover').length > 0) {
        jQuery('.wallet_amount_cover').addClass('d-none');
    }

    var agent_id = "";
    if(jQuery('select[name="agent_id"]')) {
        agent_id = jQuery('select[name="agent_id"]').val();
        agent_id = jQuery.trim(agent_id);
    }
    var customer_id = "";
    if(jQuery('select[name="customer_id"]')) {
        customer_id = jQuery('select[name="customer_id"]').val();
        customer_id = jQuery.trim(customer_id);
    }

    if(typeof customer_id != "undefined" && customer_id != null && customer_id != "") {
        var post_url = "direct_booking_changes.php?get_wallet_amount_customer_id="+customer_id;
        jQuery.ajax({url: post_url, success: function(result){
            if(jQuery('.wallet_amount').length > 0) {
                jQuery('.wallet_amount').html(result);
            }
            if(jQuery('.wallet_amount_cover').length > 0) {
                jQuery('.wallet_amount_cover').removeClass('d-none');
            }
            var post_url = "direct_booking_changes.php?shipping_agent_id="+agent_id+"&shipping_customer_id="+customer_id;
            jQuery.ajax({url: post_url, success: function(result){
                if(jQuery('.shipping_address_cover').length > 0) {
                    jQuery('.shipping_address_cover').html(result);
                }
                getPackingCharges();
            }});
        }});
    }
    else if(typeof agent_id != "undefined" && agent_id != null && agent_id != "") {
        var post_url = "direct_booking_changes.php?get_wallet_amount_agent_id="+agent_id;
        jQuery.ajax({url: post_url, success: function(result){
            if(jQuery('.wallet_amount').length > 0) {
                jQuery('.wallet_amount').html(result);
            }
            if(jQuery('.wallet_amount_cover').length > 0) {
                jQuery('.wallet_amount_cover').removeClass('d-none');
            }
            var post_url = "direct_booking_changes.php?shipping_agent_id="+agent_id+"&shipping_customer_id="+customer_id;
            jQuery.ajax({url: post_url, success: function(result){
                if(jQuery('.shipping_address_cover').length > 0) {
                    jQuery('.shipping_address_cover').html(result);
                }
                getPackingCharges();
            }});
        }});
    }
}

function getPackingCharges() {
    if(jQuery('.transport_charges').length > 0) {
        jQuery('.transport_charges').each(function() { jQuery(this).val(''); } );
    }
    if(jQuery('input[name="packing_charges"]').length > 0) {
        jQuery('input[name="packing_charges"]').val('');
    }

    if(jQuery('input[name="delivery_address"]:checked').length > 0) {
        delivery_address = jQuery('input[name="delivery_address"]:checked').val();
        delivery_address = jQuery.trim(delivery_address);

        var check_login_session = 1;
        var post_url = "dashboard_changes.php?check_login_session=1";	
        jQuery.ajax({url: post_url, success: function(check_login_session){
            if(check_login_session == 1) {	
                var post_url = "direct_booking_changes.php?transport_charges_address_id="+delivery_address;
                jQuery.ajax({url: post_url, success: function(result){
                    if(jQuery('.transport_charges').length > 0) {
                        jQuery('.transport_charges').each(function() { jQuery(this).val(result); } );
                    }
                    if(jQuery('input[name="packing_charges"]').length > 0) {
                        jQuery('input[name="packing_charges"]').val(result);
                    }    
                }});
            }
            else {
                window.location.reload();
            }
        }});
    }
}

function EditShippingAddress(update_shipping_address_id) {
	if(jQuery('#shipping_form_cover').length > 0) {
		jQuery('#shipping_form_cover').html('');
	}
	var check_login_session = 1;
    var post_url = "dashboard_changes.php?check_login_session=1";	
    jQuery.ajax({url: post_url, success: function(check_login_session){
        if(check_login_session == 1) {	
            var post_url = "shipping_address_changes.php?edit_shipping_address_id="+update_shipping_address_id;
            jQuery.ajax({url: post_url, success: function(result){
                if(jQuery('.shipping_form_cover').length > 0) {
					jQuery('.shipping_form_cover').html(result);
				}
				if(typeof update_shipping_address_id != "undefined" && update_shipping_address_id != null && update_shipping_address_id != "") {
					jQuery('.shipping_form_button').trigger('click');
				}
            }});
        }
        else {
            window.location.reload();
        }
    }});
}
function ClearShippingAddress() {
    if(jQuery('.shipping_form_cover').find('span.infos').length > 0) {
		jQuery('.shipping_form_cover').find('span.infos').remove();
	}
	if(jQuery('.shipping_form_cover').find('.valid_error').length > 0) {
		jQuery('.shipping_form_cover').find('.valid_error').remove();
	}
	if(jQuery('.shipping_form_cover').find('div.alert').length > 0) {
		jQuery('.shipping_form_cover').find('div.alert').remove();
	}

    if(jQuery('.shipping_form_cover').find('input[type="text"]').length > 0) {
        jQuery('.shipping_form_cover').find('input[type="text"]').each(function(){
            jQuery(this).val('');
        });
    }
    if(jQuery('.shipping_form_cover').find('textarea').length > 0) {
        jQuery('.shipping_form_cover').find('textarea').each(function(){
            jQuery(this).val('');
        });
    }
    //if(jQuery('.shipping_form_cover').hasClass('show') == false) {
        jQuery('.shipping_form_button').trigger('click');
    //}
}
function SaveShippingAddress(event, form_name, post_send_file) {
    event.preventDefault();

	if(jQuery('span.infos').length > 0) {
		jQuery('span.infos').remove();
	}
	if(jQuery('.valid_error').length > 0) {
		jQuery('.valid_error').remove();
	}
	if(jQuery('div.alert').length > 0) {
		jQuery('div.alert').remove();
	}

    var agent_id = "";
    if(jQuery('select[name="agent_id"]')) {
        agent_id = jQuery('select[name="agent_id"]').val();
        agent_id = jQuery.trim(agent_id);
        if(jQuery('form[name="'+form_name+'"]').find('input[name="agent_id"]').length > 0) {
            jQuery('form[name="'+form_name+'"]').find('input[name="agent_id"]').val(agent_id);
        }
    }
    var customer_id = "";
    if(jQuery('select[name="customer_id"]')) {
        customer_id = jQuery('select[name="customer_id"]').val();
        customer_id = jQuery.trim(customer_id);
        if(jQuery('form[name="'+form_name+'"]').find('input[name="customer_id"]').length > 0) {
            jQuery('form[name="'+form_name+'"]').find('input[name="customer_id"]').val(customer_id);
        }
    }

	jQuery.ajax({
		url: post_send_file,
		type: "post",
		async: true,
		data: jQuery('form[name="'+form_name+'"]').serialize(),
		dataType: 'html',
		contentType: 'application/x-www-form-urlencoded; charset=UTF-8',
		success: function(data) {
			//console.log(data);
			if(typeof data == "undefined" || data == "" || data == null) {
				if(jQuery('form[name="'+form_name+'"]').find('.submit_button').length > 0) {
					jQuery('form[name="'+form_name+'"]').find('.submit_button').attr('disabled', false);
				}
				if(jQuery('div.alert').length > 0) {
					jQuery('div.alert').remove();
				}
			}

			try {
				var x = JSON.parse(data);
			} catch (e) {
				return false;
			}
			//console.log(x);
			
			if(x.number == '1') {
				jQuery('form[name="'+form_name+'"]').find('.row:first').before('<div class="alert alert-success"> <button type="button" class="close" data-dismiss="alert">&times;</button> '+x.msg+' </div>');
				setTimeout(function(){		
                    ClearShippingAddress();			
					if(typeof x.update_shipping_address_id != "undefined" && x.update_shipping_address_id != null && x.update_shipping_address_id != "") {
						var post_url = "shipping_address_changes.php?update_shipping_address_id="+x.update_shipping_address_id;	
						jQuery.ajax({url: post_url, success: function(result){
							if(jQuery('#shipping_'+x.update_shipping_address_id).length > 0) {
								jQuery('#shipping_'+x.update_shipping_address_id).html('');
                                jQuery('#shipping_'+x.update_shipping_address_id).html(result);
							}
							else {
								if(jQuery('#address_row_cover').length > 0) {
									jQuery('#address_row_cover').append('<div class="col-12 pb-3 px-1">'+result+'</div>');
								}
							}                            
						}});	
					}
				}, 1000);
			}
			
			if(x.number == '2') {
				jQuery('form[name="'+form_name+'"]').find('.row:first').before('<div class="alert alert-danger"> <button type="button" class="close" data-dismiss="alert">&times;</button> '+x.msg+' </div>');
				if(jQuery('form[name="'+form_name+'"]').find('.submit_button').length > 0) {
					jQuery('form[name="'+form_name+'"]').find('.submit_button').attr('disabled', false);
				}
			}
			
			if(x.number == '3') {
				jQuery('form[name="'+form_name+'"]').append('<div class="valid_error"> <script type="text/javascript"> '+x.msg+' </script> </div>');
				if(jQuery('form[name="'+form_name+'"]').find('.submit_button').length > 0) {
					jQuery('form[name="'+form_name+'"]').find('.submit_button').attr('disabled', false);
				}
			}
		},
		error: function(jqXHR, textStatus, errorThrown) {
			console.log(textStatus, errorThrown);
		}
	});
}

function valid_number(value) {
	var success = 0;
	//value = clean_value(value);
	var numbers_regex = /^\d+$/;
	if(numbers_regex.test(value) == true) {
		success = 1;
	}
	return success;
}

function valid_price(value) {
	var success = 0;
	//value = clean_value(value);
	var price_regex = /^(\d*\.)?\d+$/;
	if(price_regex.test(value) == true) {
		success = 1;
	}
	return success;
}

function check_decimal(check_number) {
    if(check_number != '' && check_number != 0) {				
        var decimal = ""; var numbers = "";
        numbers = check_number.toString().split('.');							
        if( typeof numbers[1] != 'undefined') {
            decimal = numbers[1];
        }
        if(decimal != "" && decimal != 00) {						
            if(decimal.length == 1) {
                decimal = decimal+'0';
                check_number = numbers[0]+'.'+decimal;
            }
            if(decimal.length > 2) {
                check_number = check_number.toFixed(2);
            }
        }
        else {
            check_number = numbers[0]+'.00';
        }
    }
    return check_number;
}

function getProductDetails(product_id) {
    if(typeof product_id != "undefined" && product_id != "") {
        var check_login_session = 1;
        var post_url = "dashboard_changes.php?check_login_session=1";	
        jQuery.ajax({url: post_url, success: function(check_login_session){
            if(check_login_session == 1) {	
                var post_url = "direct_booking_changes.php?price_content_product_id="+product_id;
                jQuery.ajax({url: post_url, success: function(result){
                    var data = JSON.parse(result);
                    if(typeof data.product_content != "undefined" && data.product_content != "") {
                        if(jQuery('.selected_product_content').length > 0) {
                            jQuery('.selected_product_content').html("");
                            jQuery('.selected_product_content').html(data.product_content);
                        }
                    }
                    if(typeof data.price != "undefined" && data.price != "") {
                        if(jQuery('input[name="selected_rate"]').length > 0) {
                            jQuery('input[name="selected_rate"]').val("");
                            jQuery('input[name="selected_rate"]').val(data.price);
                        }
                    }
                }});
            }
            else {
                window.location.reload();
            }
        }});
    }
    else {
        if(jQuery('input[name="selected_rate"]').length > 0) {
            jQuery('input[name="selected_rate"]').val("");
        }
        if(jQuery('.selected_product_content').length > 0) {
            jQuery('.selected_product_content').html("");
        }
    }
}

function CalProductAmount() {
	var check_login_session = 1;
	var post_url = "dashboard_changes.php?check_login_session=1";	
	jQuery.ajax({url: post_url, success: function(check_login_session){
		if(check_login_session == 1) {
			var all_errors_check = 1;

			var selected_quantity = "";
			if(jQuery('input[name="selected_quantity"]').length > 0) {
				selected_quantity = jQuery('input[name="selected_quantity"]').val();
				selected_quantity = jQuery.trim(selected_quantity);	
				var number_validation = 0;
                number_validation = valid_number(selected_quantity);
                if(number_validation == 1) {
					jQuery('input[name="selected_quantity"]').val(selected_quantity);
				}
				else {
					jQuery('input[name="selected_quantity"]').val('');
					all_errors_check = 0;
				}
			}
			
			var selected_rate = "";
			if(jQuery('input[name="selected_rate"]').length > 0) {
				selected_rate = jQuery('input[name="selected_rate"]').val();
				selected_rate = jQuery.trim(selected_rate);
				var price_validation = 0;
				price_validation = valid_price(selected_rate);
        		if(price_validation == 1) {
					jQuery('input[name="selected_rate"]').val(selected_rate);
				}
				else {
					all_errors_check = 0;
				}
			}
			
			if(all_errors_check == 1) {
				var selected_amount = parseInt(selected_quantity) * parseFloat(selected_rate);
				selected_amount = check_decimal(selected_amount);
				if(jQuery('input[name="selected_amount"]').length > 0) {
					jQuery('input[name="selected_amount"]').val(selected_amount);
				}
			}
			else {
				if(jQuery('input[name="selected_amount"]').length > 0) {
					jQuery('input[name="selected_amount"]').val('');
				}
			}
		}
		else {
			window.location.reload();
		}
	}});        
}

function AddCustomRow() {
	var product_count = jQuery('input[name="product_count"]').val();
	product_count = parseInt(product_count) + 1;
	jQuery('input[name="product_count"]').val(product_count);
	
	var post_url = "direct_booking_changes.php?custom_product_row_index="+product_count;
	jQuery.ajax({url: post_url, success: function(result){	
		if(jQuery('.order_products_table tbody').find('.product_row').length > 0) {
			jQuery('.order_products_table tbody').find('.product_row:first').before(result);
		}
		else {
			jQuery('.order_products_table tbody').append(result);
		}

		if(jQuery('.sno').length > 0 ) {
			var sno = 1;
			jQuery('.sno').each(function(){
				jQuery(this).html(sno);
				sno = parseInt(sno) + 1;
			});
		}				
		
		if(jQuery('select[name="selected_product_id"]').length > 0) {
			jQuery('select[name="selected_product_id"]').val('').trigger("change");
		}
		if(jQuery('input[name="selected_quantity"]').length > 0) {
			jQuery('input[name="selected_quantity"]').val('');
		}
		if(jQuery('input[name="selected_rate"]').length > 0) {
			jQuery('input[name="selected_rate"]').val('');
		}
		if(jQuery('input[name="selected_amount"]').length > 0) {
			jQuery('input[name="selected_amount"]').val('');
		}
	}});
}

function AddDetails() {
	var check_login_session = 1;
	var post_url = "dashboard_changes.php?check_login_session=1";	
	jQuery.ajax({url: post_url, success: function(check_login_session){
		if(check_login_session == 1) {
			if(jQuery('.infos').length > 0) {
				jQuery('.infos').each(function(){ jQuery(this).remove(); });
			}		
			if(jQuery('.add_details_buttton').length > 0) {
				jQuery('.add_details_buttton').attr('disabled', true);
			}
			
			var all_errors_check = 1;
			
			var selected_product_id = "";
			if(jQuery('select[name="selected_product_id"]').length > 0) {
				selected_product_id = jQuery('select[name="selected_product_id"]').val();
				selected_product_id = jQuery.trim(selected_product_id);
				if (typeof selected_product_id == "undefined" || selected_product_id == "") {
					all_errors_check = 0;
				}
			}
		
			var selected_quantity = "";
			if(jQuery('input[name="selected_quantity"]').length > 0) {
				selected_quantity = jQuery('input[name="selected_quantity"]').val();
				selected_quantity = jQuery.trim(selected_quantity);	
				var number_validation = 0;
                number_validation = valid_number(selected_quantity);
                if(number_validation == 1) {
					jQuery('input[name="selected_quantity"]').val(selected_quantity);
				}
				else {
					jQuery('input[name="selected_quantity"]').after('<span class="infos">Invalid Quanity</span>');
					all_errors_check = 0;
				}
			}
			
			var selected_rate = "";
			if(jQuery('input[name="selected_rate"]').length > 0) {
				selected_rate = jQuery('input[name="selected_rate"]').val();
				selected_rate = jQuery.trim(selected_rate);
				var price_validation = 0;
				price_validation = valid_price(selected_rate);
        		if(price_validation == 1) {
					jQuery('input[name="selected_rate"]').val(selected_rate);
				}
				else {
					all_errors_check = 0;
					jQuery('input[name="selected_rate"]').after('<span class="infos">Invalid Rate</span>');
				}
			}
			
			if(all_errors_check == 1) {		
				var add = 1;
				if(selected_product_id != "") {
					if(jQuery('input[name="product_id[]"]').length > 0) {
						jQuery('.order_products_table tbody').find('tr').each(function(){
							var prev_product_id = jQuery(this).find('input[name="product_id[]"]').val();
							if(prev_product_id == selected_product_id) {
								add = 0;
							}
						});
					}
				}
				
				if(add == 1) {
					var product_count = jQuery('input[name="product_count"]').val();
					product_count = parseInt(product_count) + 1;
					jQuery('input[name="product_count"]').val(product_count);
					
					var post_url = "direct_booking_changes.php?product_row_index="+product_count+"&selected_product_id="+selected_product_id+"&selected_quantity="+selected_quantity+"&selected_rate="+selected_rate;
					jQuery.ajax({url: post_url, success: function(result){	
						if(jQuery('.order_products_table tbody').find('.product_row').length > 0) {
							jQuery('.order_products_table tbody').find('.product_row:first').before(result);
						}
						else {
							jQuery('.order_products_table tbody').append(result);
						}

						if(jQuery('.sno').length > 0 ) {
							var sno = 1;
							jQuery('.sno').each(function(){
								jQuery(this).html(sno);
								sno = parseInt(sno) + 1;
							});
						}				
						
						if(jQuery('select[name="selected_product_id"]').length > 0) {
							jQuery('select[name="selected_product_id"]').val('').trigger("change");
							//jQuery('select[name="selected_product_id"]').focus();
								jQuery('select[name="selected_product_id"]').select2('open');
						}
						if(jQuery('input[name="selected_quantity"]').length > 0) {
							jQuery('input[name="selected_quantity"]').val('');
						}
						if(jQuery('input[name="selected_rate"]').length > 0) {
							jQuery('input[name="selected_rate"]').val('');
						}
						if(jQuery('input[name="selected_amount"]').length > 0) {
							jQuery('input[name="selected_amount"]').val('');
						}
		
						if(jQuery('.add_details_buttton').length > 0) {
							jQuery('.add_details_buttton').attr('disabled', false);
						}

						calOverallTotal();
					}});
				}
				else {
					jQuery('.order_products_table').before('<span class="infos w-100 text-center mb-3" style="font-size: 15px;">Product already Exists</span>');
		
					if(jQuery('.add_details_buttton').length > 0) {
						jQuery('.add_details_buttton').attr('disabled', false);
					}
				}		
			}
			else {
				jQuery('.order_products_table').before('<span class="infos w-100 text-center mb-3" style="font-size: 15px;">Please check all field values</span>');
				if(jQuery('.add_details_buttton').length > 0) {
					jQuery('.add_details_buttton').attr('disabled', false);
				}
			}
		}
		else {
			window.location.reload();
		}
	}});
}

function ProductRowCheck(obj) {
	var check_login_session = 1;
	var post_url = "dashboard_changes.php?check_login_session=1";	
	jQuery.ajax({url: post_url, success: function(check_login_session){
		if(check_login_session == 1) {
			if(jQuery('.infos').length > 0) {
				jQuery('.infos').each(function(){ jQuery(this).remove(); });
			}
			
			var all_errors_check = 1;
			
			var selected_product_id = "";
			if(jQuery(obj).parent().parent().find('input[name="product_id[]"]').length > 0) {
				selected_product_id = jQuery(obj).parent().parent().find('input[name="product_id[]"]').val();
				selected_product_id = jQuery.trim(selected_product_id);
				if (typeof selected_product_id == "undefined" || selected_product_id == "") {
					all_errors_check = 0;
				}
			}
			var selected_product_code = "";
			if(jQuery(obj).parent().parent().find('input[name="product_code[]"]').length > 0) {
				selected_product_code = jQuery(obj).parent().parent().find('input[name="product_code[]"]').val();
				selected_product_code = jQuery.trim(selected_product_code);
				if (typeof selected_product_code == "undefined" || selected_product_code == "") {
					all_errors_check = 0;
				}
			}
		
			var selected_quantity = "";
			if(jQuery(obj).parent().parent().find('input[name="quantity[]"]').length > 0) {
				selected_quantity = jQuery(obj).parent().parent().find('input[name="quantity[]"]').val();
				selected_quantity = jQuery.trim(selected_quantity);	
				if (typeof selected_quantity != "undefined" && selected_quantity != "") {
					var number_validation = 0;
					number_validation = valid_number(selected_quantity);
					if(number_validation == 1) {
						jQuery(obj).parent().parent().find('input[name="quantity[]"]').val(selected_quantity);
					}
					else {
						jQuery(obj).parent().parent().find('input[name="quantity[]"]').after('<span class="infos">Invalid Quantity</span>');
						all_errors_check = 0;
					}
				}
			}
		
			var selected_rate = "";
			if(jQuery(obj).parent().parent().find('input[name="rate[]"]').length > 0) {
				selected_rate = jQuery(obj).parent().parent().find('input[name="rate[]"]').val();
				selected_rate = jQuery.trim(selected_rate);
				if (typeof selected_rate != "undefined" && selected_rate != "") {
					var price_validation = 0;
					price_validation = valid_price(selected_rate);
					if(price_validation == 1) {
						jQuery(obj).parent().parent().find('input[name="rate[]"]').val(selected_rate);
					}
					else {
						all_errors_check = 0;
						jQuery(obj).parent().parent().find('input[name="rate[]"]').after('<span class="infos">Invalid Rate</span>');
					}
				}
			}
		
			if(all_errors_check == 1) {
				if (typeof selected_quantity != "undefined" && selected_quantity != "") {
					if (typeof selected_rate != "undefined" && selected_rate != "") {
						var number_validation = 0;
						number_validation = valid_number(selected_quantity);
						if(number_validation == 1) {
							var price_validation = 0;
							price_validation = valid_price(selected_rate);
							if(price_validation == 1) {
								var selected_amount = parseInt(selected_quantity) * parseFloat(selected_rate);
								selected_amount = check_decimal(selected_amount);
								if(jQuery(obj).parent().parent().find('.amount').length > 0) {
									jQuery(obj).parent().parent().find('.amount').html(selected_amount);
									calOverallTotal();
								}
							}
						}
					}
				}
			}
			else {	
				if(jQuery(obj).parent().parent().find('.amount').length > 0) {
					jQuery(obj).parent().parent().find('.amount').html('');
					calOverallTotal();
				}
				jQuery('.order_products_table').before('<span class="infos w-100 text-center mb-3" style="font-size: 15px;">Please check all field values</span>');
			}
		}
		else {
			window.location.reload();
		}
	}});
}

function DeleteProductRow(row_index) {
	var check_login_session = 1;
	var post_url = "dashboard_changes.php?check_login_session=1";	
	jQuery.ajax({url: post_url, success: function(check_login_session){
		if(check_login_session == 1) {
			if(jQuery('#product_row'+row_index).length > 0) {
				jQuery('#product_row'+row_index).remove();
			}
			if(jQuery('.sno').length > 0 ) {
				var sno = 1;
				jQuery('.sno').each(function(){
					jQuery(this).html(sno);
					sno = parseInt(sno) + 1;
				});
			}
			calOverallTotal();
		}
		else {
			window.location.reload();
		}
	}});
}

function TopDiscount() {
	if(jQuery('input[name="top_discount"]').length > 0) {
		discount = jQuery('input[name="top_discount"]').val();
		discount = jQuery.trim(discount);
		if(typeof discount != "undefined" && discount != "" && discount != 0) {
			var check_discount = discount;
			if(check_discount.indexOf('%') != -1) {
				check_discount = check_discount.replace("%", "");
				check_discount = check_discount.trim();
			}
			var discount_validation = 0;
			discount_validation = valid_price(check_discount);
			if(discount_validation == 1) {
				if(jQuery('input[name="bottom_discount"]').length > 0) {
					jQuery('input[name="bottom_discount"]').val(discount);					
				}
				if(jQuery('input[name="discount"]').length > 0) {
					jQuery('input[name="discount"]').val(discount);
				}
				calOverallTotal();
			}
		}
	}
}

function BottomDiscount() {
	if(jQuery('input[name="bottom_discount"]').length > 0) {
		discount = jQuery('input[name="bottom_discount"]').val();
		discount = jQuery.trim(discount);
		if(typeof discount != "undefined" && discount != "" && discount != 0) {
			var check_discount = discount;
			if(check_discount.indexOf('%') != -1) {
				check_discount = check_discount.replace("%", "");
				check_discount = check_discount.trim();
			}
			var discount_validation = 0;
			discount_validation = valid_price(check_discount);
			if(discount_validation == 1) {
				if(jQuery('input[name="top_discount"]').length > 0) {
					jQuery('input[name="top_discount"]').val(discount);					
				}
				if(jQuery('input[name="discount"]').length > 0) {
					jQuery('input[name="discount"]').val(discount);
				}
				calOverallTotal();
			}
		}
	}
}


function TopPackingCharges() {
    if(jQuery('input[name="packing_charges"]').length > 0) {
        jQuery('input[name="packing_charges"]').val('');
    }
	if(jQuery('input[name="top_packing_charges"]').length > 0) {
		packing_charges = jQuery('input[name="top_packing_charges"]').val();
		packing_charges = jQuery.trim(packing_charges);
		if(typeof packing_charges != "undefined" && packing_charges != "" && packing_charges != 0) {
			var check_packing_charges = packing_charges;
			if(check_packing_charges.indexOf('%') != -1) {
				check_packing_charges = check_packing_charges.replace("%", "");
				check_packing_charges = check_packing_charges.trim();
			}
			var packing_charges_validation = 0;
			packing_charges_validation = valid_price(check_packing_charges);
			if(packing_charges_validation == 1) {
				if(jQuery('input[name="bottom_packing_charges"]').length > 0) {
					jQuery('input[name="bottom_packing_charges"]').val(packing_charges);					
				}
				if(jQuery('input[name="packing_charges"]').length > 0) {
					jQuery('input[name="packing_charges"]').val(packing_charges);
				}				
			}
		}
        else {
            if(jQuery('input[name="bottom_packing_charges"]').length > 0) {
                jQuery('input[name="bottom_packing_charges"]').val('');
            }    
        }
	}
    calOverallTotal();
}
function BottomPackingCharges() {
    if(jQuery('input[name="packing_charges"]').length > 0) {
        jQuery('input[name="packing_charges"]').val('');
    }
	if(jQuery('input[name="bottom_packing_charges"]').length > 0) {
		packing_charges = jQuery('input[name="bottom_packing_charges"]').val();
		packing_charges = jQuery.trim(packing_charges);
		if(typeof packing_charges != "undefined" && packing_charges != "" && packing_charges != 0) {
			var check_packing_charges = packing_charges;
			if(check_packing_charges.indexOf('%') != -1) {
				check_packing_charges = check_packing_charges.replace("%", "");
				check_packing_charges = check_packing_charges.trim();
			}
			var packing_charges_validation = 0;
			packing_charges_validation = valid_price(check_packing_charges);
			if(packing_charges_validation == 1) {
				if(jQuery('input[name="top_packing_charges"]').length > 0) {
					jQuery('input[name="top_packing_charges"]').val(packing_charges);					
				}
				if(jQuery('input[name="packing_charges"]').length > 0) {
					jQuery('input[name="packing_charges"]').val(packing_charges);
				}
			}
		}
        else {
            if(jQuery('input[name="top_packing_charges"]').length > 0) {
                jQuery('input[name="top_packing_charges"]').val('');
            }    
        }
	}
    calOverallTotal();
}

function calOverallTotal() {
	var sub_total = 0; var discount = 0; var discount_value = 0; var extra_discount = 0; var extra_discount_value = 0; var packing_charges = 0;
	var packing_charges_value = 0; var total = 0;

	if(jQuery('.sub_total').length > 0) {
		jQuery('.sub_total').html('');
	}
	if(jQuery('.discount_value').length > 0) {
		jQuery('.discount_value').html('');
	}
	if(jQuery('.net_total').length > 0) {
		jQuery('.net_total').html('');
	}
	if(jQuery('.packing_charges_value').length > 0) {
		jQuery('.packing_charges_value').html('');
	}
	if(jQuery('.grand_total').length > 0) {
		jQuery('.grand_total').html('');
	}
	if(jQuery('.round_off').length > 0) {
		jQuery('.round_off').html('');
	}
	if(jQuery('.overall_total').length > 0) {
		jQuery('.overall_total').html('');
	}
	if(jQuery('.product_row').length > 0) {

		if(jQuery('input[name="discount"]').length > 0) {
			discount = jQuery('input[name="discount"]').val();
			discount = jQuery.trim(discount);
			if(typeof discount != "undefined" && discount != "" && discount != 0) {
				var check_discount = discount;
				if(check_discount.indexOf('%') != -1) {
					check_discount = check_discount.replace("%", "");
					check_discount = check_discount.trim();
				}
				var discount_validation = 0;
				discount_validation = valid_price(check_discount);
				if(discount_validation == 1) {
					if(jQuery('.custom_product_row').find('.custom_discount').length > 0) {
						jQuery('.custom_product_row').find('.custom_discount').each(function(){
							var custom_discount = "";
							custom_discount = jQuery(this).val();
							custom_discount = jQuery.trim(custom_discount);
							if(custom_discount == "Y" || custom_discount == "y") {
								if(jQuery(this).parent().find('.product_discount').length > 0) {
									jQuery(this).parent().find('.product_discount').val(discount);
								}
							}
							else {
								jQuery(this).val('N');
								if(jQuery(this).parent().find('.product_discount').length > 0) {
									jQuery(this).parent().find('.product_discount').val('');
								}
							}
						});
					}
				}
			}
		}

		var discount_value_total = 0; var intRegex = /^\d+$/;
		jQuery('.product_row').each(function(){
			var amount = 0;
			amount = jQuery(this).find('.amount').html();
			amount = amount.replaceAll(",","");
			amount = jQuery.trim(amount);
			sub_total = parseFloat(sub_total) + parseFloat(amount);

			if(discount.indexOf('%') == -1) {
				discount = discount+'%';
			}

			var check_discount = discount;
			if(check_discount.indexOf('%') != -1) {
				check_discount = check_discount.replace("%", "");
				check_discount = check_discount.trim();
			}

			var discount_validation = 0; var product_discount = 0;
			discount_validation = valid_price(check_discount);
			if(discount_validation == 1) {
				product_discount = jQuery(this).find('.product_discount').val();
				product_discount = jQuery.trim(product_discount);
				if(product_discount.indexOf('%') != -1) {
					product_discount = product_discount.replace("%", "");
					product_discount = product_discount.trim();
				}
				var discount_validation = 0;
				discount_validation = valid_price(product_discount);
				if(parseInt(product_discount) > 0 && discount_validation == 1) {

					var discount_value = 0;
					if(discount.indexOf('%') != -1) {
						discount_value = (parseFloat(amount) * parseFloat(check_discount)) / 100;
					}
					discount_value = check_decimal(discount_value);

					var discount_value_validation = 0; 
					discount_value_validation = valid_price(discount_value);
					if(discount_value_validation == 1) {
						discount_value_total = parseFloat(discount_value_total) + parseFloat(discount_value);
					}
					
				}
			}
			
		});

		if(typeof sub_total != "undefined" && sub_total != "" && sub_total != 0) {
			sub_total = check_decimal(sub_total);
			total = sub_total;
			if(jQuery('.sub_total').length > 0) {
				jQuery('.sub_total').html('Rs.'+sub_total);
			}
		}
		if(typeof discount_value_total != "undefined" && discount_value_total != "" && discount_value_total != 0) {			
			total = parseFloat(total) - parseFloat(discount_value_total);
			if(jQuery('.discount_value').length > 0) {
				jQuery('.discount_value').html('Rs.'+discount_value_total);
			}
		}

		if(typeof total != "undefined" && total != "" && total != 0) {
			total = check_decimal(total);
			if(jQuery('.net_total').length > 0) {
				jQuery('.net_total').html('Rs.'+total);
			}
		}
		
		if(jQuery('input[name="packing_charges"]').length > 0) {
			packing_charges = jQuery('input[name="packing_charges"]').val();
			packing_charges = jQuery.trim(packing_charges);
			if(typeof packing_charges != "undefined" && packing_charges != "" && packing_charges != 0) {

				if(packing_charges.indexOf('%') != -1) {
					packing_charges = packing_charges.replace("%", "");
					packing_charges = packing_charges.trim();
					var price_validation = 0;
					price_validation = valid_price(packing_charges);
					if(price_validation == 1) {
						packing_charges_value = (parseFloat(total) * parseFloat(packing_charges)) / 100;
						packing_charges_value = check_decimal(packing_charges_value);
					}
				}
				else {
					var price_validation = 0;
					price_validation = valid_price(packing_charges);
					if(price_validation == 1) {
						packing_charges_value = packing_charges;
						packing_charges_value = check_decimal(packing_charges_value);
					}
				}

				if(typeof packing_charges_value != "undefined" && packing_charges_value != "" && packing_charges_value != 0) {
					total = parseFloat(total) + parseFloat(packing_charges_value);
					if(jQuery('.packing_charges_value').length > 0) {
						jQuery('.packing_charges_value').html('Rs.'+packing_charges_value);
					}
				}
			}
		}

		if(typeof total != "undefined" && total != "" && total != 0) {
			total = check_decimal(total);
			if(jQuery('.grand_total').length > 0) {
				jQuery('.grand_total').html('Rs.'+total);
			}
		}

		if(typeof total != "undefined" && total != "" && total != 0) {
			total = check_decimal(total);
			if(jQuery('.overall_total').length > 0) {
				var decimal = ""; var round_off = '';
                var numbers = total.toString().split('.');							
                if( typeof numbers[1] != 'undefined') {
                    decimal = numbers[1];
                }
                if(decimal != "" && decimal != 00) {
					console.log('decimal - '+decimal);
                    if(decimal.length == 1) {
                        decimal = decimal+'0';
                    }

					var round_off = "";
                    if(parseFloat(decimal) >= 50) {
                        round_off = 100 - parseFloat(decimal);
						round_off = jQuery.trim(round_off);
                        if(round_off.length == 1) {
                            round_off = "0.0"+round_off;
                        }
                        else {
                            round_off = "0."+round_off;
                        }
                        total = parseFloat(total) + parseFloat(round_off);
                        if( typeof round_off != 'undefined' && round_off != '') {
                            jQuery('.round_off').html(round_off);
                        }
                    }
                    else {
                        round_off = decimal;
						round_off = jQuery.trim(round_off);
                        if(round_off.length == 1) {
                            round_off = "0.0"+round_off;
                        }
                        else {
                            round_off = "0."+round_off;
                        }
                        total = parseFloat(total) - parseFloat(round_off);
                        if( typeof round_off != 'undefined' && round_off != '') {
                            jQuery('.round_off').html(" - "+round_off);
                        }
                    }
                }
				jQuery('.overall_total').html('Rs.'+total);
			}
		}
	}
}

function SaveOrder(form_name) {
    var check_login_session = 1;
    var post_url = "dashboard_changes.php?check_login_session=1";	
    jQuery.ajax({url: post_url, success: function(check_login_session){
        if(check_login_session == 1) {	
            if(jQuery('div.alert').length > 0) {
                jQuery('div.alert').remove();
            }
            jQuery('form[name="'+form_name+'"]').find('.row:first').before('<div class="alert alert-danger mb-3"> <button type="button" class="close" data-dismiss="alert">&times;</button> Processing </div>');
            if(jQuery('form[name="'+form_name+'"]').find('.submit_button').length > 0) {
                jQuery('form[name="'+form_name+'"]').find('.submit_button').attr('disabled', true);
            }
            jQuery('html, body').animate({
                scrollTop: (jQuery('.add_update_form_content').parent().parent().offset().top)
            }, 500);
            jQuery.ajax({
                url: 'direct_booking_changes.php',
                type: "post",
                async: true,
                data: jQuery('form[name="'+form_name+'"]').serialize(),
                dataType: 'html',
                contentType: 'application/x-www-form-urlencoded; charset=UTF-8',
                success: function(data) {
                    //console.log(data);
                    try {
                        var x = JSON.parse(data);
                    } catch (e) {
                        return false;
                    }
                    //console.log(x);
                    
                    if(jQuery('span.infos').length > 0) {
                        jQuery('span.infos').remove();
                    }
                    if(jQuery('.valid_error').length > 0) {
                        jQuery('.valid_error').remove();
                    }
                    if(jQuery('div.alert').length > 0) {
                        jQuery('div.alert').remove();
                    }
                    
                    if(x.number == '1') {
                        jQuery('form[name="'+form_name+'"]').find('.row:first').before('<div class="alert alert-success"> <button type="button" class="close" data-dismiss="alert">&times;</button> '+x.msg+' </div>');
                        setTimeout(function(){
							if(typeof x.order_id != "undefined" && x.order_id != null && x.order_id != "") {
                                if(typeof x.wallet_order_amount_error != "undefined" && x.wallet_order_amount_error != null && x.wallet_order_amount_error != "") {                                    
                                    CheckConfirmOrder(x.order_id);
                                }
                                else {
									if(typeof x.customer_chit_ids != "undefined" && x.customer_chit_ids != null && x.customer_chit_ids != "") {
										var post_url = "orders_changes.php?confirm_order_id="+x.order_id;
										jQuery.ajax({url: post_url, success: function(result){
											var intRegex = /^\d+$/;
											if(intRegex.test(result) == true) {
												var url = "reports/rpt_orders_format1.php?print_order_id="+x.order_id+"&paper_size=a4";    
												window.open(url, '_blank');                                        
											}
										}});
									}
									else {
										var url = "reports/rpt_orders_format1.php?print_order_id="+x.order_id+"&paper_size=a4";    
										window.open(url, '_blank');
									}
                                }
							}
                        }, 1000);
                    }
                    
                    if(x.number == '2') {
                        jQuery('form[name="'+form_name+'"]').find('.row:first').before('<div class="alert alert-danger"> <button type="button" class="close" data-dismiss="alert">&times;</button> '+x.msg+' </div>');
                        if(jQuery('form[name="'+form_name+'"]').find('.submit_button').length > 0) {
                            jQuery('form[name="'+form_name+'"]').find('.submit_button').attr('disabled', false);
                        }
                    }
                    
                    if(x.number == '3') {
                        jQuery('form[name="'+form_name+'"]').append('<div class="valid_error"> <script type="text/javascript"> '+x.msg+' </script> </div>');
                        if(jQuery('form[name="'+form_name+'"]').find('.submit_button').length > 0) {
                            jQuery('form[name="'+form_name+'"]').find('.submit_button').attr('disabled', false);
                        }
                    }
                },
                error: function(jqXHR, textStatus, errorThrown) {
                    console.log(textStatus, errorThrown);
                }
            });
        }
        else {
            window.location.reload();
        }
    }});
}

function CheckConfirmOrder(confirm_order_id) {
	var check_login_session = 1;
	var post_url = "dashboard_changes.php?check_login_session=1";	
	jQuery.ajax({url: post_url, success: function(check_login_session){
		if(check_login_session == 1) {	
			jQuery('.confirm_order_modal_button').trigger("click");	
			
			jQuery('#ConfirmOrderModal .modal-footer .yes').attr('id', confirm_order_id);
			jQuery('#ConfirmOrderModal .modal-footer .no').attr('id', confirm_order_id); 
		}
		else {
			window.location.reload();
		}
	}});
}
function ConfirmOrder(obj) {
	var check_login_session = 1;
	var post_url = "dashboard_changes.php?check_login_session=1";	
	jQuery.ajax({url: post_url, success: function(check_login_session){
		if(check_login_session == 1) {
            if(jQuery('#ConfirmOrderModal .modal-body').find('.infos').length > 0) {
                jQuery('#ConfirmOrderModal .modal-body').find('.infos').remove();
            }
			var confirm_order_id = jQuery(obj).attr('id');
			var post_url = "orders_changes.php?confirm_order_id="+confirm_order_id;
			jQuery.ajax({url: post_url, success: function(result){
				jQuery('#ConfirmOrderModal .modal-content').animate({ scrollTop: 0 }, 500);

				var intRegex = /^\d+$/;
				if(intRegex.test(result) == true) {
					jQuery('#ConfirmOrderModal .modal-body').append('<div class="alert alert-success"> <button type="button" class="close" data-dismiss="alert">&times;</button> Successfully Updated </div>');
					setTimeout(function(){ 
						var view_order_id = jQuery(obj).attr('id');
                        jQuery('#ConfirmOrderModal .modal-header .close').trigger("click");
                        if(typeof view_order_id != "undefined" && view_order_id != null && view_order_id != 0) {
                            window.location = "reports/rpt_orders_format1.php?print_order_id="+view_order_id+"&paper_size=a4";
                        }
					}, 1000);
					
				}
				else {
					jQuery('#ConfirmOrderModal .modal-body').append('<span class="infos w-100 text-center" style="font-size: 15px; font-weight: bold;">'+result+'</span>');
				}
			}});
		}
		else {
			window.location.reload();
		}
	}});
}
function CancelOrder(obj) {
	var check_login_session = 1;
	var post_url = "dashboard_changes.php?check_login_session=1";	
	jQuery.ajax({url: post_url, success: function(check_login_session){
		if(check_login_session == 1) {
            var view_order_id = jQuery(obj).attr('id');
			jQuery('#ConfirmOrderModal .modal-header .close').trigger("click");
            if(typeof view_order_id != "undefined" && view_order_id != null && view_order_id != 0) {
                window.location = "reports/rpt_orders_format1.php?print_order_id="+view_order_id+"&paper_size=a4";
            }
		}
		else {
			window.location.reload();
		}
	}}); 
}