<?php
    include("include_user_check.php");
	
    $page_title = "Orders";

    $view_order_id = "";
    if(isset($_REQUEST['view_order_id'])) {
        $view_order_id = $_REQUEST['view_order_id'];
    }

    $order_number = ""; $total_amount = 0; $customer_id = ""; $agent_id = ""; $customer_chit_ids = ""; $chit_list = array(); $wallet_amount = 0;
    $packing_charges_option = 0; $packing_charges = 0;
    if(!empty($view_order_id)) {
        $order_list = array();
		$order_list = $obj->getTableRecords($GLOBALS['order_table'], 'order_id', $view_order_id);
        if(!empty($order_list)) {
            foreach($order_list as $data) {
                if(!empty($data['order_number'])) {
                    $order_number = $obj->encode_decode('decrypt', $data['order_number']);
                }
                if(!empty($data['total_amount'])) {
                    $total_amount = $data['total_amount'];
                }
                if(!empty($data['agent_id']) && $data['agent_id'] != $GLOBALS['null_value']) {
                    $agent_id = $data['agent_id'];
                }
                if(!empty($data['customer_id']) && $data['customer_id'] != $GLOBALS['null_value']) {
                    $customer_id = $data['customer_id'];
                }
                if(!empty($data['customer_chit_ids'])) {
                    $customer_chit_ids = explode(",", $data['customer_chit_ids']);
                }
                if(!empty($data['packing_charges_option'])) {
                    $packing_charges_option = $data['packing_charges_option'];
                }
                if(!empty($data['packing_charges'])) {
                    $packing_charges = $data['packing_charges'];
                }
            }

            if(!empty($customer_id) && $customer_id != $GLOBALS['null_value']) {
                $wallet_amount = $obj->getTableColumnValue($GLOBALS['customer_table'], 'customer_id', $customer_id, 'total_wallet');
            }
            else if(!empty($agent_id) && $agent_id != $GLOBALS['null_value']) {
                $wallet_amount = $obj->getTableColumnValue($GLOBALS['agent_table'], 'agent_id', $agent_id, 'total_wallet');
            }

        }
    }

    if(!empty($packing_charges_option) && $packing_charges_option == 2) {
        if(!empty($packing_charges) && !empty($total_amount)) {
            $total_amount = $total_amount - $packing_charges;
        }
    }

?>
<!DOCTYPE html>
<html lang="en">
<head>
	<title> <?php if(!empty($project_title)) { echo $project_title; } ?> - <?php if(!empty($page_title)) { echo $page_title; } ?> </title>
	<?php include "link_style_script.php"; ?>
	<script type="text/javascript" src="include/js/common.js"></script>
	<script type="text/javascript" src="include/js/chit.js"></script>
    <script type="text/javascript" src="include/js/order.js"></script>
</head>
<body>
	<?php include "header.php";  ?>
	<!-- sidebar-wrapper  -->          
	<div class="page-wrapper chiller-theme toggled">
		<main class="page-content">
			<div class="container-fluid px-lg-5">
				<div class="border card-box">

					<div class="card-header">
                        <h5 class="headfnt edit_title"><?php if(!empty($page_title)) { echo $page_title." View"; } ?></h5>
					</div>

					<div id="order_view_cover" class="px-3 py-3 add_update_form_content">
                        <form name="confirm_order_form" method="post" class="redirection_form">
                            <input type="hidden" name="confirm_order_id" value="<?php if(!empty($view_order_id)) { echo $view_order_id; } ?>">
                            <div class="row mx-0">
                                <div class="col-sm-4">
                                    <div class="form-group">
                                        <label class="form-control-label">Order Number</label> <br>
                                        <?php if(!empty($order_number)) { echo $order_number; } ?>
                                    </div>
                                </div>
                                <div class="col-sm-4">
                                    <div class="form-group">
                                        <label class="form-control-label">Order Amount</label> <br>
                                        <?php if(!empty($total_amount)) { echo "Rs.".$obj->truncate_number($total_amount, 2); } ?>
                                    </div>
                                </div>
                                <div class="col-sm-4">
                                    <div class="form-group">
                                        <label class="form-control-label">Wallet Amount</label> <br>
                                        <?php if(!empty($wallet_amount)) { echo "Rs.".$obj->truncate_number($wallet_amount, 2); } ?>
                                    </div>
                                </div>
                                <div class="col-sm-4">
                                    <div class="form-group">
                                        <label class="form-control-label">Chit Wallet use</label>
                                        <div class="w-100">

                                            <?php
                                                if(!empty($customer_chit_ids)) {
                                                    $customer_chit_details = '<div class="customer_order_chit_details_table">';
                                                    foreach($customer_chit_ids as $customer_chit_id) {
                                                        if(!empty($customer_chit_id)) {
                                                            $chit_unique_id = "";
                                                            $chit_unique_id = $obj->getTableColumnValue($GLOBALS['customer_chit_table'], 'customer_chit_id', $customer_chit_id, 'id');
                                                            if(preg_match("/^\d+$/", $chit_unique_id)) {
                                            ?>
                                                                <input type="hidden" class="form-control" name="chit_wallet_use[]" value="<?php echo $customer_chit_id; ?>">
                                            <?php                    
                                                                $customer_chit_list = array();
                                                                $customer_chit_list = $obj->getTableRecords($GLOBALS['customer_chit_table'], 'customer_chit_id', $customer_chit_id);
                                                                if(!empty($customer_chit_list)) {
                                                                    foreach($customer_chit_list as $data) {
                                                                        $customer_chit_details = $customer_chit_details.'<div class="chit">';
                                                                        if(!empty($data['customer_chit_unique_number'])) {
                                                                            $customer_chit_details = $customer_chit_details.'<div>'.$obj->encode_decode('decrypt', $data['customer_chit_unique_number']).'</div>';
                                                                        }
                                                                        if(!empty($data['chit_details'])) {
                                                                            $customer_chit_details = $customer_chit_details.'<div>'.$obj->encode_decode('decrypt', $data['chit_details']).'</div>';
                                                                        }
                                                                        $customer_chit_details = $customer_chit_details."</div>";
                                                                    }
                                                                }
                                                            }
                                                        }
                                                    }
                                                    if(!empty($customer_chit_details)) {
                                                        $customer_chit_details = $customer_chit_details."</div>";
                                                        echo $customer_chit_details;
                                                    }
                                                }
                                            ?>
                                        </div>
                                    </div>
                                </div>
                                <div class="col-md-12 pt-3 text-center">
                                    <button class="btn btn-primary btnwidth submit_button" type="button" onClick="Javascript:SaveModalContent(event, 'confirm_order_form', 'orders_changes.php', 'orders.php');">Submit</button>
                                    &nbsp; <a href="orders.php" class="btn btn-danger">Back</a>
                                </div>
                            </div>
                        </form>
					</div>

				</div>
			</div>
		</main>
	</div>  
	<!-- page-wrapper -->

	<script>
		jQuery(document).ready(function(){
            jQuery("#bookingactive").addClass("active");
			jQuery("#ordersactive").addClass("active");
		});
	</script>

	<?php include "footer.php"; ?>

    </body>
</html>