<?php
    include("../include.php");

    $filter_from_date = "";
    if(isset($_POST['filter_from_date'])) {
        $filter_from_date = $_POST['filter_from_date'];
    }

    $filter_to_date = "";
    if(isset($_POST['filter_to_date'])) {
        $filter_to_date = $_POST['filter_to_date'];
    }

    $filter_agent_id = "";
    if(isset($_POST['filter_agent_id'])) {
        $filter_agent_id = $_POST['filter_agent_id'];
    }

    $filter_customer_id = "";
    if(isset($_POST['filter_customer_id'])) {
        $filter_customer_id = $_POST['filter_customer_id'];
    }

    $filter_chit_id = "";
    if(isset($_POST['filter_chit_id'])) {
        $filter_chit_id = $_POST['filter_chit_id'];
    }
	
	$chit_list = array();
	$chit_list = $obj->getAgentVoucherListByFilter($filter_from_date, $filter_to_date, $filter_agent_id, $filter_customer_id, $filter_chit_id);
    
    $company_list = array();
    $company_list = $obj->getTableRecords($GLOBALS['company_table'], '', '');

    foreach($company_list as $data){
        $company_name = ""; $company_address = ""; $company_mobile = ""; $company_email = ""; $logo = "";

        if(!empty($data['name'])) {
            $company_name = $obj->encode_decode('decrypt', $data['name']);
        }
        if(!empty($data['logo']) && $data['logo'] != $GLOBALS['null_value']) {
            $logo = $data['logo'];
        }
        if(!empty($data['address']) && $data['address'] != $GLOBALS['null_value']) {
            $company_address = $obj->encode_decode('decrypt', $data['address']);
            $company_address = str_replace("$$$", " ", $company_address);
        }
        if(!empty($data['mobile_number'])) {
            $company_mobile = $obj->encode_decode('decrypt', $data['mobile_number']);
        }
        if(!empty($data['email'])) {
            $company_email = $obj->encode_decode('decrypt', $data['email']);
        }
    }

    $target_dir = '../include/images/upload/';

    require_once('../fpdf/fpdf.php');
    $pdf = new FPDF('P','mm','A4');
    $pdf->AliasNbPages(); 
    $pdf->AddPage();
    $pdf->SetAutoPageBreak(true);
    $pdf->SetTitle('Voucher List');
    $pdf->SetFont('Arial','B',10);
    $pdf->SetY(10);
    $pdf->Cell(0,5,strtoupper($company_name),0,1,'C',0);
    $pdf->SetFont('Arial','',7);
    $pdf->Cell(0,4,$company_address,0,1,'C',0);
    $pdf->Cell(0,4,'E-mail : '.$company_email.'   Phone : '.$company_mobile,0,1,'C',0);
        
    if(!empty($logo) && file_exists($target_dir.$logo)){
        $pdf->Image($target_dir.$logo,10,7,25,20);
    }
    
    $pdf->SetY(7);
    $pdf->Cell(0,20,'',1,1,'L',0);
    $pdf->SetFont('Arial','B',9);
    $pdf->Cell(0,6,'Voucher List',1,1,'C',0);
    $pdf->SetFont('Arial','B',8);
    $pdf->SetX(10);
    $pdf->Cell(10,5,'S.No',1,0,'C',0);
    $pdf->SetX(20);
    $pdf->Cell(20,5,'Voucher Date',1,0,'C',0);
    $pdf->SetX(40);
    $pdf->Cell(25,5,'Agent',1,0,'C',0);
    $pdf->SetX(65);
    $pdf->Cell(25,5,'Customer',1,0,'C',0);
    $pdf->SetX(90);
    $pdf->Cell(60,5,'Chit Name',1,0,'C',0);
    $pdf->SetX(150);
    $pdf->Cell(25,5,'Voucher ID',1,0,'C',0);
    $pdf->SetX(175);
    $pdf->Cell(25,5,'Commission',1,1,'C',0);
    $pdf->SetFont('Arial','',8);

    if(!empty($chit_list)) {
        $sno = 1;
        foreach($chit_list as $data) {
            if($pdf->GetY()>260){
                $pdf->SetY(-10);
                $pdf->Cell(0, 5, "Page " . $pdf->PageNo() . "/{nb}", 0, 1,'C',0);
                $pdf->AddPage();
                $pdf->SetFont('Arial','B',10);
                $pdf->SetY(10);
                $pdf->Cell(0,5,strtoupper($company_name),0,1,'C',0);
                $pdf->SetFont('Arial','',7);
                $pdf->Cell(0,4,$company_address,0,1,'C',0);
                $pdf->Cell(0,4,'E-mail : '.$company_email.'   Phone : '.$company_mobile,0,1,'C',0);

                if(!empty($logo) && file_exists($target_dir.$logo)){
                    $pdf->Image($target_dir.$logo,10,7,25,20);
                }
                
                $pdf->SetY(7);
                $pdf->Cell(0,20,'',1,1,'L',0);
                $pdf->SetFont('Arial','B',9);
                $pdf->Cell(0,6,'Voucher List',1,1,'C',0);
                $pdf->SetFont('Arial','B',8);
                $pdf->SetX(10);
                $pdf->Cell(10,5,'S.No',1,0,'C',0);
                $pdf->SetX(20);
                $pdf->Cell(20,5,'Voucher Date',1,0,'C',0);
                $pdf->SetX(40);
                $pdf->Cell(25,5,'Agent',1,0,'C',0);
                $pdf->SetX(65);
                $pdf->Cell(25,5,'Customer',1,0,'C',0);
                $pdf->SetX(90);
                $pdf->Cell(60,5,'Chit Name',1,0,'C',0);
                $pdf->SetX(150);
                $pdf->Cell(25,5,'Voucher ID',1,0,'C',0);
                $pdf->SetX(175);
                $pdf->Cell(25,5,'Commission',1,1,'C',0);
                $pdf->SetFont('Arial','',8);
            }

            $voucher_date = ""; $agent_details = ""; $customer_details = ""; $voucher_unique_number = ""; $chit_details = ""; $total_amount = 0;

            if(!empty($data['voucher_date']) && $data['voucher_date'] != "0000-00-00 00:00:00") { 
                $voucher_date = date("d-m-Y", strtotime($data['voucher_date'])); 
            }
            if(!empty($data['agent_details']) && $data['agent_details'] != $GLOBALS['null_value']) {
                $agent_details = $obj->encode_decode('decrypt', $data['agent_details']);
            }
            if(!empty($data['customer_details']) && $data['customer_details'] != $GLOBALS['null_value']) {
                $customer_details = $obj->encode_decode('decrypt', $data['customer_details']);
            }
            if(!empty($data['customer_chit_details'])) {
                $chit_details = $obj->encode_decode('decrypt', $data['customer_chit_details']);
                $chit_details = str_replace("<br>", " - ", $chit_details);
            }
            if(!empty($data['voucher_unique_number'])) {
                $voucher_unique_number = $obj->encode_decode('decrypt', $data['voucher_unique_number']);
            }
            if(!empty($data['amount'])) {
                $total_amount = $data['amount'];
            }

            $yaxis = $pdf->GetY();
            $pdf->SetX(10);
            $pdf->Cell(10,5,$sno,0,0,'C',0);
            $pdf->SetX(20);
            $pdf->Cell(20,5,$voucher_date,0,0,'C',0);
            $pdf->SetX(40);
            $pdf->MultiCell(25,5,$agent_details,0,'C',0);
            $agent_height = $pdf->GetY();
            $pdf->SetY($yaxis);
            $pdf->SetX(65);
            $pdf->MultiCell(25,5,$customer_details,0,'C',0);
            $customer_height = $pdf->GetY();
            $pdf->SetY($yaxis);
            $pdf->SetX(90);
            $pdf->MultiCell(60,5,$chit_details,0,'C',0);
            $chit_height = $pdf->GetY();  
            $pdf->SetY($yaxis);
            $pdf->SetX(150);
            $pdf->Cell(25,5,$voucher_unique_number,0,0,'C',0);    
            $pdf->SetX(175);
            $pdf->MultiCell(25,5,$total_amount,0,'C',0);
            $balance_height = $pdf->GetY();

            if($agent_height >= $customer_height && $agent_height >= $chit_height && $agent_height >= $balance_height){
                $last_y = $agent_height;
            }
            else if($customer_height >= $agent_height && $customer_height >= $chit_height && $customer_height >= $balance_height){
                $last_y = $customer_height;
            }
            else if($chit_height >= $agent_height && $chit_height >= $customer_height && $chit_height >= $balance_height){
                $last_y = $chit_height;
            }
            else{
                $last_y = $balance_height;
            }

            $pdf->SetY($yaxis);
            $pdf->SetX(10);
            $pdf->Cell(10,$last_y-$yaxis,'',1,0,'C',0);
            $pdf->SetX(20);
            $pdf->Cell(20,$last_y-$yaxis,'',1,0,'C',0);
            $pdf->SetX(40);
            $pdf->Cell(25,$last_y-$yaxis,'',1,0,'C',0);
            $pdf->SetX(65);
            $pdf->Cell(25,$last_y-$yaxis,'',1,0,'C',0);
            $pdf->SetX(90);
            $pdf->Cell(60,$last_y-$yaxis,'',1,0,'C',0);
            $pdf->SetX(150);
            $pdf->Cell(25,$last_y-$yaxis,'',1,0,'C',0);
            $pdf->SetX(175);
            $pdf->Cell(0,$last_y-$yaxis,'',1,1,'L',0);

            $sno++;
        }
    }
    
    $pdf->SetY(-10);
    $pdf->Cell(0, 5, "Page " . $pdf->PageNo() . "/{nb}", 0, 1,'C',0);

    $pdf->Output();
?>