// UTILITY FUNCTIONS 

function IsNumeric(n) {
    return !isNaN(n);
}

function CommaFormatted(amount) {
    
	var delimiter = ","; 
	var i = parseInt(amount);
	
	if(isNaN(i)) { return ''; }
	
	i = Math.abs(i);
	
	var minus = '';
	if (i < 0) { minus = '-'; }
	
	var n = new String(i);
	var a = [];
	
	while(n.length > 3)
	{
		var nn = n.substr(n.length-3);
		a.unshift(nn);
		n = n.substr(0,n.length-3);
	}
	
	if (n.length > 0) { a.unshift(n); }
	
	n = a.join(delimiter);
	
	amount = "Rs." + minus + n;
	
	return amount;
	
}

// ORDER FORM UTILITY FUNCTIONS
function applyName(product_id, numPallets, rowTotal) {
    jQuery('.prodname'+product_id).attr("value", product_id+'-'+numPallets);    
}

function removeName(product_id) {    
    jQuery('.prodname'+product_id).attr("value", "");    
}

function calProductTotal()
{
	var sub_total = 0; var discounts = []; var selectedProducts = 0;
	var discount_rows = jQuery("#discount_rows").val();
	var bal_amount = 0;
	
	jQuery(".row-total-input").each(function(){
		var row_total = jQuery(this).val();
		var discount = jQuery(this).parent().parent().find(".discount-per-pallet").text();
		if(row_total != '') {
			selectedProducts++;	
			sub_total = parseFloat(sub_total) + parseFloat(row_total);
			discount = discount.trim();
			if(discount > 0) {
				var discount_value = (row_total * discount) / 100;
				discount_value = Math.round(discount_value);
				bal_amount = parseFloat(row_total) - parseFloat(discount_value);
			}
			else {
				discount_value = row_total;
				bal_amount = row_total;
			}				
			for(var d = 1; d <= discount_rows; d++) {
				var dis_id = "#discount"+d;
				var dis_value = jQuery(dis_id).val();
				if(dis_value == discount)
					discounts.push({discount : discount, row_total : row_total, discount_value : discount_value, bal_amount : bal_amount});
			}
		}
		
	});
	jQuery("#selected-product").val(selectedProducts);
	// discount total
	for(var d = 1; d <= discount_rows; d++) {
		var dis_id = "#discount"+d;
		var dis_value = jQuery(dis_id).val();
		var row_total = 0; var discount_total = 0; var balance_total = 0;
		for(var s = 0; s < discounts.length; s++) {
			if(discounts[s].discount == dis_value) {
				row_total = parseFloat(row_total) + parseFloat(discounts[s].row_total);
				discount_total = parseFloat(discount_total) + parseFloat(discounts[s].discount_value);
				balance_total = parseFloat(balance_total) + parseFloat(discounts[s].bal_amount);
			}
		}
		if(jQuery("#"+dis_value+"-discount_sub_total").length)
			jQuery("#"+dis_value+"-discount_sub_total").val(CommaFormatted(row_total));
		if(jQuery("#"+dis_value+"-discount_sub_total_top").length)	
			jQuery("#"+dis_value+"-discount_sub_total_top").val(CommaFormatted(row_total));
		if(jQuery("#"+dis_value+"-discount").length)	
			jQuery("#"+dis_value+"-discount").val(CommaFormatted(discount_total));
		if(jQuery("#"+dis_value+"-discount_top").length)	
		jQuery("#"+dis_value+"-discount_top").val(CommaFormatted(discount_total));
		if(jQuery("#"+dis_value+"-discount_payable_amounnt").length)
			jQuery("#"+dis_value+"-discount_payable_amounnt").val(CommaFormatted(balance_total));
		if(jQuery("#"+dis_value+"-discount_payable_amounnt_top").length)
			jQuery("#"+dis_value+"-discount_payable_amounnt_top").val(CommaFormatted(balance_total));
	}
	
	//overall total
	var pay_total = 0;
	for(var d = 1; d <= discount_rows; d++) {
		var dis_id = "#discount"+d;
		var discount = jQuery(dis_id).val();
		if(discount > 0) {			
			var discount_total = jQuery("#"+discount+"-discount_payable_amounnt").val();
			discount_total = discount_total.replace("Rs.","");	
			discount_total = discount_total.replace(/\,/g, '');
			if(pay_total > 0)
				pay_total = parseFloat(pay_total) + parseFloat(discount_total);
			else
				pay_total = parseFloat(discount_total);
		}	
		else {
			var discount_total = jQuery("#"+discount+"-discount").val();
			discount_total = discount_total.replace("Rs.","");	
			discount_total = discount_total.replace(/\,/g, '');
			if(pay_total > 0)
				pay_total = parseFloat(pay_total) + parseFloat(discount_total);
			else
				pay_total = parseFloat(discount_total);
		}
	}
	
	jQuery("#payable").val(CommaFormatted(pay_total));
	jQuery("#payable-amount").val(CommaFormatted(pay_total));
	var orderTotal = parseFloat(pay_total);	
	jQuery("#fc-price").attr("value", orderTotal);
	
}

function set_order_table_top(){
	var div = jQuery('#topfix').position();
	var div_height = jQuery('#topfix').height();
	var div_pos = parseInt(div.top) + parseInt(div_height);
	jQuery(window).scroll(function(){
		var win_top = jQuery(window).scrollTop();	
		if(win_top > div_pos)
		  jQuery('#topfix').addClass('shipping_table_fixed');
		else
		  jQuery('#topfix').removeClass('shipping_table_fixed');
	});
}

jQuery(window).resize(function(){
	set_order_table_top();
});

// DOM READY
jQuery(document).ready(function() {
    var inc = 1;
	
	set_order_table_top();
				
	jQuery(".mobile-nav").click(function(){
		jQuery(".collapse").toggle();
	});
	
	jQuery(".product_image > img").click(function(){
		var title = jQuery(this).attr('title');
		var src = jQuery(this).attr('src');
		if(src != '') {
			jQuery('#showModal .modal-title').html(title);
			jQuery('#showModal .modal-body').html('<img src="'+src+'">');
			jQuery('.show_popup_button').trigger("click");
		}
	});
	
	jQuery(".product_video > img").click(function() {
		var title = jQuery(this).attr('title');
		var video_id = jQuery(this).attr('rel');
		if(video_id != '') {
			jQuery('#showModal .modal-title').html(title);
			jQuery('#showModal .modal-body').html('<iframe src="https://www.youtube.com/embed/'+video_id+'" style="max-width: 100%; height: 300px;"></iframe>');
			jQuery('.show_popup_button').trigger("click");
		}
	});

    jQuery(".product_name").each(function() {        
		var product_id = jQuery(this).attr("id");
		jQuery("#foxycart-order-form").append("<input type='hidden' name='prodname[]' value='' class='prodname"+product_id+"' />");
    });
    
    // Reset form on page load, optional
    jQuery("#order-table input[type=text]:not('#product-subtotal')").val("");
    jQuery("#product-subtotal").val("Rs.0");
	jQuery("#product-subtotal-top").val("Rs.0");
	var discount_rows = jQuery("#discount_rows").val();
	for(var d = 1; d <= discount_rows; d++) {
		var dis_id = "#discount"+d;
		var dis_value = jQuery(dis_id).val();
		jQuery("#"+dis_value+"-discount_sub_total").val("Rs.0");
		jQuery("#"+dis_value+"-discount_sub_total_top").val("Rs.0");
		jQuery("#"+dis_value+"-discount").val("Rs.0");
		jQuery("#"+dis_value+"-discount_top").val("Rs.0");
		if(jQuery("#"+dis_value+"-discount_payable_amounnt").length)
			jQuery("#"+dis_value+"-discount_payable_amounnt").val("Rs.0");
		if(jQuery("#"+dis_value+"-discount_payable_amounnt_top").length)
			jQuery("#"+dis_value+"-discount_payable_amounnt_top").val("Rs.0");	
	}
    jQuery("#payable-amount").val("Rs.0");
	jQuery("#payable").val("Rs.0");
	
	var action = 0;
    var quantity = "";
    // "The Math" is performed pretty much whenever anything happens in the quanity inputs - focus blur change keyup
    jQuery('.num-pallets-input').bind("focus blur change keyup", function(){
    
        // Caching the selector for efficiency 
        var $el = jQuery(this);
    
        // Grab the new quantity the user entered
		var numPallets = $el.val();	
                
        // Find the pricing
        var multiplier = $el.parent().parent().find(".price-per-pallet").text();
        multiplier = multiplier.trim();
		multiplier = multiplier.replace("Rs.","");
		
        // If the quantity is empty, reset everything back to empty
        if ( (numPallets == '') || (numPallets <= 0) ) {			
           $el.parent().parent().find(".row-total input").val("");                
           var product_id = $el.parent().parent().find(".product_name").attr("id");            
           removeName(product_id);
        
        // If the quantity is valid, calculate the row total
        } else if ( (IsNumeric(numPallets)) && (numPallets != '') && (numPallets > 0) ) {
			quantity = numPallets;
			
			var multiple_of = $el.parent().parent().find(".multiple_of").val();			
			if(parseInt(multiple_of) != 0) {
				if( (parseInt(numPallets) % parseInt(multiple_of)) == 0 )
					action = 1;
				else
					action = 0;
			}
			if(parseInt(multiple_of) == 0)
				action = 1;
			
			if(action == 1) {	
				var product_id = $el.parent().parent().find(".product_name").attr("id");
				var numbers = /^\d+$/;
				if(product_id.match(numbers)) {
					var post_url = "admin/changes.php?order_product_id="+product_id;
					jQuery.ajax({url: post_url, success: function(product_stock){
						if(numPallets <= product_stock) {
							var rowTotal = numPallets * multiplier;
							$el.parent().parent().find("td.row-total input").val(rowTotal);
							applyName(product_id, numPallets, rowTotal);
						}
						else
							alert('The quantity value should be within '+product_stock);
					}});
				}
			}
        
        // If the quantity is invalid, let the user know with UI change                                    
        } else {
            $el.parent().parent().find("td.row-total input").val("");            
            var product_id = $el.parent().parent().find("td.product_name").attr("id");            
            removeName(product_id);      
        }
		
		if(action == 1)
			calProductTotal();
    
    });

});

function valid_order() {	
	var name = document.getElementById('name').value;
	if(name == "") {
		alert('Enter the customer name');
		document.getElementById('name').focus();
		return false;
	}		
	var address = document.getElementById('address').value;
	if(address == "") {
		alert('Enter the customer address');
		document.getElementById('address').focus();
		return false;
	}
	var mobile = document.getElementById('mobile').value;
	if(mobile == "") {
		alert('Enter the customer mobile');
		document.getElementById('mobile').focus();
		return false;
	}
	var phoneNum = /^\(?([0-9]{3})\)?[-. ]?([0-9]{3})[-. ]?([0-9]{4})$/;
	if (!mobile.match(phoneNum)) 
	{
		alert('Invalid phone number');
		document.getElementById('mobile').focus();
		return false;
	}
	var mail = document.getElementById('mail').value;
	if(mail == "") {
		alert('Enter the customer email');
		document.getElementById('mail').focus();
		return false;
	}
	var reg = /^([A-Za-z0-9_\-\.])+\@([A-Za-z0-9_\-\.])+\.([A-Za-z]{2,4})$/;
	if (reg.test(mail) == false) 
	{
		alert('Invalid Email Address');
		document.getElementById('mail').focus();
		return false;
	}
	
	var total = document.getElementById('payable').value;
	var minimum_amount = document.getElementById('minimum_amount').value;
	total = total.replace("Rs.","");
	total = total.replace(",","");
	
	if(minimum_amount != 0) {
		if(parseInt(total) <= parseInt(minimum_amount)) {
			alert('Minimum Order Value Must Be Rs.'+minimum_amount);
			return false;
		}
	}
	
	return true;
}

function showGridProducts(company_id, category_id) {
	var numbers = /^\d+$/;
	if(company_id.match(numbers)) {
		var post_url = "admin/changes.php?order_company_id="+company_id+"&order_category_id="+category_id;
		jQuery.ajax({url: post_url, success: function(result){
			jQuery('.grid_products').html(result);
			
			if(category_id != "" && category_id > 0) {
				jQuery('ul.category_list li').each(function(){
					if(jQuery(this).hasClass("active"))
						jQuery(this).removeClass('active');
				});
				
				jQuery('.category'+category_id).addClass('active');
			}
			
		}});
	}
}