<?php
	include("include_files.php");
    include("include/estimate_billing_functions.php");

	$permission_page = $GLOBALS['branch_module'];

	$sidebar_admin_user =  0;
	if(!empty($_SESSION[$GLOBALS['site_name_user_prefix'].'_user_type']) && isset($_SESSION[$GLOBALS['site_name_user_prefix'].'_user_type'])) {
		if($_SESSION[$GLOBALS['site_name_user_prefix'].'_user_type'] == $GLOBALS['admin_user_type']) {
			$sidebar_admin_user = 1;
		}
	}
	
	if(isset($_REQUEST['show_branch_id'])) { 
        $show_branch_id = $_REQUEST['show_branch_id'];

		$site_modules = $GLOBALS['site_modules'];

        $name = ""; $branch_contact_number = ""; $branch_address = ""; $branch_lr_prefix = ""; $city = ""; $branch_pincode = ""; $state = "";$district = "";
		$country = "India"; 
        if(!empty($show_branch_id)) {
            $branch_list = array();
			$branch_list = $obj->getTableRecords($GLOBALS['branch_table'], 'id', $show_branch_id);
            if(!empty($branch_list)) {
                foreach($branch_list as $data) {
                    if(!empty($data['name']) && $data['name'] != "NULL") {
                        $name = $obj->encode_decode('decrypt', $data['name']);
					}
					if(!empty($data['branch_contact_number']) && $data['branch_contact_number'] != "NULL") {
                        $branch_contact_number = $obj->encode_decode('decrypt', $data['branch_contact_number']);
					}
					if(!empty($data['branch_lr_prefix']) && $data['branch_lr_prefix'] != "NULL") {
                        $branch_lr_prefix = $obj->encode_decode('decrypt', $data['branch_lr_prefix']);
					}
					if(!empty($data['branch_address']) && $data['branch_address'] != "NULL") {
                        $branch_address = $obj->encode_decode('decrypt', $data['branch_address']);
					}
					if(!empty($data['branch_city'])  && $data['branch_city']  != 'NULL') {
						$city = html_entity_decode($obj->encode_decode('decrypt', $data['branch_city']));
					}
					if(!empty($data['district'])  && $data['district']  != 'NULL') {
						$district = html_entity_decode($obj->encode_decode('decrypt', $data['district']));
					}
					if(!empty($data['branch_pincode']) && $data['branch_pincode'] != "NULL") {
                        $branch_pincode = $obj->encode_decode('decrypt', $data['branch_pincode']);
					}
					if(!empty($data['state']) && $data['state'] != "NULL") {
                        $state = $obj->encode_decode('decrypt', $data['state']);
					}
                }
            }
		} ?>
        <form class="poppins pd-20" name="branch_form" method="POST">
			<div class="card-header">
				<div class="row">
					<div class="col-lg-8 col-md-8 col-8">
						<h5 class="text-white">Edit Branch</h5>
					</div>
					<div class="col-lg-4 col-md-4 col-4">
						<button class="btn btn-danger float-right" style="font-size:11px;" type="button" onclick="window.open('branch.php','_self')"> <i class="fa fa-arrow-circle-o-left"></i> &ensp; Back </button>
					</div>
				</div>
			</div>
			<div class="row p-3">
				<input type="hidden" name="edit_id" value="<?php if(!empty($show_branch_id)) { echo $show_branch_id; } ?>">
                <div class="col-lg-4 col-md-6 col-12 mb-3">
                    <div class="form-group mb-1">
                        <div class="form-label-group in-border pb-2">
                            <input type="text" id="branch_name" name="branch_name" class="form-control shadow-none" placeholder="Branch Name" value="<?php if(!empty($name)){ echo $name; }?>" onkeyup="Javascript:InputBoxColor(this,'text');" required>
                            <label>Branch Name(<span class="text-danger">*</span>)</label>
                        </div>
                    </div>
                </div>
                <div class="col-lg-4 col-md-6 col-12 mb-3">
                    <div class="form-group mb-1">
                        <div class="form-label-group in-border pb-2">
                            <input type="text" id="branch_contact_number" name="branch_contact_number" class="form-control shadow-none" placeholder="Branch Contact Number" value="<?php if(!empty($branch_contact_number)){ echo $branch_contact_number; }?>" onkeyup="Javascript:InputBoxColor(this,'text');" onfocus="Javascript:SpaceControl(this);MobileNoControl(this);" required>
                            <label>Branch Contact Number(<span class="text-danger">*</span>)</label>
                        </div>
                    </div>
                </div>
                <div class="col-lg-4 col-md-6 col-12 mb-3 d-none">
                    <div class="form-group mb-1">
                        <div class="form-label-group in-border pb-2">
                            <input type="text" id="branch_lr_prefix" name="branch_lr_prefix" class="form-control shadow-none" placeholder="Branch LR Prefix" value="<?php if(!empty($branch_lr_prefix)){ echo $branch_lr_prefix; }?>" onkeyup="Javascript:InputBoxColor(this,'text');ToUpper(this);" onfocus="Javascript:LRprefix(this);SpaceControl(this);" required>
                            <label>Branch LR Prefix(<span class="text-danger">*</span>)</label>
                        </div>
                    </div>
                </div>
                <div class="col-lg-4 col-md-6 col-12 mb-3">
                    <div class="form-group mb-1">
                        <div class="form-label-group in-border pb-2">
                            <input type="text" class="form-control shadow-none" id="branch_address" name="branch_address" placeholder="Branch Address" value="<?php if(!empty($branch_address)){ echo $branch_address; }?>" onkeyup="Javascript:InputBoxColor(this,'text');" required>
                            <label>Branch Address(<span class="text-danger">*</span>)</label>
                        </div>
                    </div>
                </div>
				
				<div class="col-lg-4 col-md-6 col-12 mb-3">
                    <div class="form-group mb-1">
                        <div class="form-label-group in-border pb-2">
							<div class="w-100" style="display: none;">
								<select name="country" class="form-control">
									<option value="">Select</option>
								</select>
							</div>
                            <select name="state" class="form-control shadow-none" id="state" onchange="Javascript:getStates('branch',this.value, '', '');">
                               <option value="">Select State</option>
                            </select>
                            <label>State (<span class="text-danger">*</span>)</label>
                        </div> 
                    </div>
                </div>
				<div class="col-lg-4 col-md-6 col-12 mb-3">
                    <div class="form-group mb-1">
                        <div class="form-label-group in-border pb-2">
                            <select name="district" class="form-control shadow-none" id="district" onchange="Javascript:getDistricts('branch', this.value, '');">
								<option value="">Select District</option>
                            </select>
                            <label>District (<span class="text-danger">*</span>)</label>
                        </div> 
                    </div>
                </div>
				<div class="col-lg-4 col-md-6 col-12 mb-3">
                    <div class="form-group mb-1">
                        <div class="form-label-group in-border pb-2">
                            <select name="city" class="form-control shadow-none" id="city" onchange="Javascript:getCities('branch', '', this.value);">
								<option value="">Select City</option>
                            </select>
                            <label>City (<span class="text-danger">*</span>)</label>
                        </div> 
                    </div>
                </div>
				<div class="col-lg-4 col-md-6 col-12 mb-3">
                    <div class="form-group mb-1">
                        <div class="form-label-group in-border pb-2">
                            <input type="text" class="form-control shadow-none" id="branch_pincode" name="branch_pincode" placeholder="Branch pincode" value="<?php if(!empty($branch_pincode)){ echo $branch_pincode; }?>" onkeyup="Javascript:InputBoxColor(this,'text');" onfocus="Javascript:SpaceControl(this);PincodeControl(this);" required>
                            <label>Branch pincode(<span class="text-danger">*</span>)</label>
                        </div>
                    </div>
                </div>
                <div class="col-md-12 pt-3 text-center">
                    <button class="btn btn-dark" type="button" onClick="Javascript:SaveModalContent('branch_form', 'branch_changes.php', 'branch.php');">
                        Submit
                    </button>
                </div>
			</div>
            <script type="text/javascript">
				jQuery(document).ready(function(){
					jQuery('form[name="branch_form"]').find('select').select2();
				}); 
			</script>
			<script src="include/js/countries.js"></script>
			<script src="include/js/district.js"></script>
			<script src="include/js/cities.js"></script>
			<script type="text/javascript">                
				jQuery(document).ready(function(){
					jQuery('select[name="state"]').select2();
					jQuery('select[name="district"]').select2();
					jQuery('select[name="city"]').select2();
					jQuery('.add_update_form_content').find('select').select2();
					getCountries('branch','<?php if(!empty($country)) { echo $country; } ?>', '<?php if(!empty($state)) { echo $state; } ?>', '<?php if(!empty($district)) { echo $district; } ?>', '<?php if(!empty($city)) { echo $city; } ?>');
				});
			</script>
        </form>
		<?php
    } 
    if(isset($_POST['branch_name'])) {	
		$name = ""; $branch_contact_number = ""; $branch_address = ""; $branch_lr_prefix = ""; $branch_city = ""; $branch_pincode = ""; $state = "";
		$name_error = ""; $branch_contact_number_error = ""; $branch_address_error = ""; $branch_lr_prefix_error = ""; $branch_city_error = ""; $branch_pincode_error = ""; $state_error = ""; $district = "";$district_error = "";
	
		$valid_branch = ""; $form_name = "branch_form"; 

		if(isset($_POST['edit_id'])) {
			$edit_id = $_POST['edit_id'];
		}

		// Name
		if(isset($_POST['branch_name'])){
			$name = $_POST['branch_name'];
			$name_error = $valid->valid_name($name,'branch name',"1");
			// if(empty($name)) {
			// 	$name_error = "Enter the name";
			// }
			if(!empty($name_error)) {
				$valid_branch = $valid->error_display($form_name, "branch_name", $name_error, 'text');			
			}
		}

		// Contact Number
		if(isset($_POST['branch_contact_number'])){
			$branch_contact_number = $_POST['branch_contact_number'];
			$branch_contact_number_error = $valid->valid_mobile_number($branch_contact_number, "Branch Contact Number", "1");
			if(!empty($branch_contact_number_error)) {
				if(!empty($valid_branch)) {
					$valid_branch = $valid_branch." ".$valid->error_display($form_name, "branch_contact_number", $branch_contact_number_error, 'text');
				}
				else {
					$valid_branch = $valid->error_display($form_name, "branch_contact_number", $branch_contact_number_error, 'text');
				}
			}
		}

		// LR prefix
		if(isset($_POST['branch_lr_prefix'])){
			$branch_lr_prefix = $_POST['branch_lr_prefix'];
			if(!empty($branch_lr_prefix)){
				$branch_lr_prefix = $valid->clean_value($branch_lr_prefix);
				$branch_lr_prefix_error = $valid->valid_lr_prefix($branch_lr_prefix,"Branch LR prefix","0");
				if(!empty($branch_lr_prefix_error)) {
					if(!empty($valid_branch)) {
						$valid_branch = $valid_branch." ".$valid->error_display($form_name, "branch_lr_prefix", $branch_lr_prefix_error, 'text');
					}
					else {
						$valid_branch = $valid->error_display($form_name, "branch_lr_prefix", $branch_lr_prefix_error, 'text');
					}
				}
			}
		}
		
		// Branch Address
		if(isset($_POST['branch_address'])){
			$branch_address = $_POST['branch_address'];
			$branch_address = $valid->clean_value($branch_address, "Branch address", "1");
			if(empty($branch_address))
			{
				$branch_address_error = "Enter the branch address";
			}
			if(!empty($branch_address_error)) {
				if(!empty($valid_branch)) {
					$valid_branch = $valid_branch." ".$valid->error_display($form_name, "branch_address", $branch_address_error, 'text');
				}
				else {
					$valid_branch = $valid->error_display($form_name, "branch_address", $branch_address_error, 'text');
				}
			}
		}

		// Branch Pincode
		if(isset($_POST['branch_pincode'])){
			$branch_pincode = $_POST['branch_pincode'];
			$branch_pincode_error = $valid->valid_pincode($branch_pincode,'branch pincode','1');
			if(!empty($branch_pincode_error)){
				if(!empty($valid_branch)) {
					$valid_branch = $valid_branch." ".$valid->error_display($form_name, "branch_pincode", $branch_pincode_error, 'text');
				}
				else {
					$valid_branch = $valid->error_display($form_name, "branch_pincode", $branch_pincode_error, 'text');
				}
			}
		}

		// State
		if(isset($_POST['state'])) {
			$state = $_POST['state'];
			$state = $valid->clean_value($state);
		}
		if(empty($state)) {
			$state_error = "Select the state";
			if(!empty($valid_branch)) {
				$valid_branch = $valid_branch." ".$valid->error_display($form_name, "state", $state_error, 'select');
			}
			else {
				$valid_branch = $valid->error_display($form_name, "state", $state_error, 'select');
			}
		}

		// City
        if(isset($_POST['city'])){
            $branch_city = $_POST['city'];
        }
		if(!empty($branch_city))
		{
			$branch_city = htmlentities($branch_city,ENT_QUOTES);
		}
		else{
			$branch_city_error = "Select City";
			if(!empty($branch_city_error)){
				if(!empty($valid_branch)){
					$valid_branch = $valid_branch." ".$valid->error_display($form_name,'city',$branch_city_error,'select');
				}
				else{
					$valid_branch = $valid->error_display($form_name,'city',$branch_city_error,'select');
				}
			}
		}

		// District
        if(isset($_POST['district'])){
            $district = $_POST['district'];
        }
		if(!empty($district))
		{
			$district = htmlentities($district,ENT_QUOTES);
		}
		else{
			$district_error = "Select District";
			if(!empty($district_error)){
				if(!empty($valid_branch)){
					$valid_branch = $valid_branch." ".$valid->error_display($form_name,'district',$district_error,'select');
				}
				else{
					$valid_branch = $valid->error_display($form_name,'district',$district_error,'select');
				}
			}
		}
		
		
		$result = "";
		$bill_company_id = $GLOBALS['bill_company_id'];
		if(empty($valid_branch)) {
			$check_user_id_ip_address = 0;
			$check_user_id_ip_address = $obj->check_user_id_ip_address();	
			if(preg_match("/^\d+$/", $check_user_id_ip_address)) {

				if(!empty($name)) {
					$name_array = "";
					$name_array = explode(" ", $name);
					if(is_array($name_array)) {
						for($n = 0; $n < count($name_array); $n++) {
							if(!empty($name_array[$n])) {
								$name_array[$n] = trim($name_array[$n]);
								$name_array[$n] = strtolower($name_array[$n]);
								$name_array[$n] = ucfirst($name_array[$n]);
							}
							else {
								unset($name_array[$n]);
							}
						}
						$name = implode(" ", $name_array);
					}    
				}
				
				$lower_case_name = "";
				if(!empty($name)) {
					$lower_case_name = strtolower($name);
					$name = $obj->encode_decode('encrypt', $name);
					$lower_case_name = $obj->encode_decode('encrypt', $lower_case_name);
				}
				$lower_case_city = "";
				if(!empty($branch_city)){
					$lower_case_city = strtolower($branch_city);
					$branch_city = $obj->encode_decode('encrypt', $branch_city);
					$lower_case_city = $obj->encode_decode('encrypt',$lower_case_city);
				}

				// Branch name and city name checking...If same name and city exists, show error //
				$prev_branch_name_id = ""; $prev_name_error = ""; $prev_branch_name = ""; $prev_branch_city1 = "";		
				if(!empty($lower_case_name) && !empty($lower_case_city)) {
					$prev_branch_name_id = $obj->CheckBranchNameAlreadyExists($lower_case_name,$lower_case_city);
					if(!empty($prev_branch_name_id)) {
						$prev_branch_name = $obj->getTableColumnValue($GLOBALS['branch_table'],'id',$prev_branch_name_id,'name');
						$prev_branch_city1 = $obj->getTableColumnValue($GLOBALS['branch_table'],'id',$prev_branch_name_id,'branch_city');
						$prev_name_error = "This Branch name and city is already exist in ".($obj->encode_decode('decrypt',$prev_branch_name))." - ".($obj->encode_decode('decrypt',$prev_branch_city1));
					}
                }

				// Branch LR checking
				$prev_branch_prefix_id = ""; $prev_lr_error = ""; $prev_branch_prefix = "";$prev_branch_city2 = "";
				if(!empty($branch_lr_prefix)) {
					$branch_lr_prefix = $obj->encode_decode('encrypt', $branch_lr_prefix);
					$prev_branch_prefix_id = $obj->CheckBranchLrAlreadyExists($branch_lr_prefix);
					if(!empty($prev_branch_prefix_id)){
						$prev_branch_prefix = $obj->getTableColumnValue($GLOBALS['branch_table'],'id',$prev_branch_prefix_id,'name');
						$prev_branch_city2 = $obj->getTableColumnValue($GLOBALS['branch_table'],'id',$prev_branch_prefix_id,'branch_city');
						$prev_lr_error = "This LR prefix is already exists in ".($obj->encode_decode('decrypt',$prev_branch_prefix))." - ".($obj->encode_decode('decrypt',$prev_branch_city2));
					}
				}

				// Branch Mobile no. Checking
				$prev_branch_mobile_id = ""; $prev_mobile_error = ""; $prev_branch_mobile = "";$prev_branch_city3 = "";
				if(!empty($branch_contact_number)){
					$branch_contact_number = $obj->encode_decode('encrypt', $branch_contact_number);
					$prev_branch_mobile_id = $obj->CheckBranchMobileAlreadyExists($branch_contact_number);
					if(!empty($prev_branch_mobile_id)){
						$prev_branch_mobile = $obj->getTableColumnValue($GLOBALS['branch_table'],'id',$prev_branch_mobile_id,'name');
						$prev_branch_city3 = $obj->getTableColumnValue($GLOBALS['branch_table'],'id',$prev_branch_mobile_id,'branch_city');
						$prev_mobile_error = "This Mobile Number already exists in ".($obj->encode_decode('decrypt',$prev_branch_mobile))." - ".($obj->encode_decode('decrypt',$prev_branch_city3));
					}
				}

				$update_branch_id = "";
				$created_date_time = $GLOBALS['create_date_time_label']; $creator = $GLOBALS['creator'];
				$creator_name = $obj->encode_decode('encrypt', $GLOBALS['creator_name']);

				
				if(!empty($branch_address)){
					$branch_address = $obj->encode_decode('encrypt', $branch_address);
				}
				if(!empty($branch_pincode)){
					$branch_pincode = $obj->encode_decode('encrypt', $branch_pincode);
				}
				if(!empty($state)){
					$state = $obj->encode_decode('encrypt',$state);
				}
				if(!empty($district)) {
                    $district = $obj->encode_decode('encrypt', $district);
                }
				else {
                    $district = $GLOBALS['null_value'];
                }

				
				if(empty($edit_id)) {
					if(empty($prev_name_error)){
						if(empty($prev_lr_error)) {		
							if(empty($prev_mobile_error)){				
								$action = "";
								if(!empty($name)) {
									$action = "New branch Created. Name - ".$obj->encode_decode('decrypt', $name);
								}
		
								$null_value = $GLOBALS['null_value'];
								$columns = array('created_date_time', 'creator', 'creator_name','bill_company_id','branch_id', 'name', 'branch_lr_prefix', 'branch_contact_number','lower_case_name','branch_address','branch_city','lower_case_city','district','branch_pincode','state','deleted');
								$values = array("'".$created_date_time."'", "'".$creator."'", "'".$creator_name."'", "'".$bill_company_id."'", "'".$null_value."'", "'".$name."'", "'".$branch_lr_prefix."'", "'".$branch_contact_number."'","'".$lower_case_name."'","'".$branch_address."'","'".$branch_city."'","'".$lower_case_city."'","'".$district."'","'".$branch_pincode."'","'".$state."'","'0'");

								$branch_insert_id = $obj->InsertSQL($GLOBALS['branch_table'], $columns, $values, $action);						
								if(preg_match("/^\d+$/", $branch_insert_id)) {
									$branch_id = "";
									if($branch_insert_id < 10) {
										$branch_id = "BRANCH_".date("dmYhis")."_0".$branch_insert_id;
									}
									else {
										$branch_id = "BRANCH_".date("dmYhis")."_".$branch_insert_id;
									}
									if(!empty($branch_id)) {
										$branch_id = $obj->encode_decode('encrypt', $branch_id);
									}
									$columns = array(); $values = array();						
									$columns = array('branch_id');
									$values = array("'".$branch_id."'");
									$branch_update_id = $obj->UpdateSQL($GLOBALS['branch_table'], $branch_insert_id, $columns, $values, '');
									if(preg_match("/^\d+$/", $branch_update_id)) {		
										$result = array('number' => '1', 'msg' => 'Branch Successfully Created');					
									}
									else {
										$result = array('number' => '2', 'msg' => $branch_update_id);
									}
								}
								else {
									$result = array('number' => '2', 'msg' => $branch_insert_id);
								}	
							}
							else if (!empty($prev_mobile_error)){
								$result = array('number' => '2', 'msg' => $prev_mobile_error);
							}
						}
						else if (!empty($prev_lr_error)){
							$result = array('number' => '2', 'msg' => $prev_lr_error);
						}
					}
					else if (!empty($prev_name_error)){
						$result = array('number' => '2', 'msg' => $prev_name_error);
					}
				}
				else {
					if(empty($prev_branch_name_id) || $prev_branch_name_id == $edit_id) {
						if(empty($prev_branch_prefix_id) || $prev_branch_prefix_id == $edit_id) {
							if(empty($prev_branch_mobile_id) || $prev_branch_mobile_id == $edit_id) {
								$getUniqueID = "";
								$getUniqueID = $edit_id;
								if(preg_match("/^\d+$/", $getUniqueID)) {
									$action = "";
									if(!empty($name)) {
										$action = "Branch Updated. Name - ".$obj->encode_decode('decrypt', $name);
									}
								
									$columns = array(); $values = array();
								
									$columns = array('created_date_time', 'creator', 'creator_name','name', 'branch_lr_prefix', 'branch_contact_number','lower_case_name','branch_address','branch_city','lower_case_city','district','branch_pincode','state');
									$values = array("'".$created_date_time."'", "'".$creator."'", "'".$creator_name."'", "'".$name."'", "'".$branch_lr_prefix."'", "'".$branch_contact_number."'","'".$lower_case_name."'","'".$branch_address."'","'".$branch_city."'","'".$lower_case_city."'","'".$district."'","'".$branch_pincode."'","'".$state."'");
									
									$branch_update_id = $obj->UpdateSQL($GLOBALS['branch_table'], $getUniqueID, $columns, $values, $action);
									if(preg_match("/^\d+$/", $branch_update_id)) {	
										$update_branch_id = $edit_id;
										$result = array('number' => '1', 'msg' => 'Updated Successfully');						
									}
									else {
										$result = array('number' => '2', 'msg' => $branch_update_id);
									}							
								}
							}
							else if (!empty($prev_mobile_error)){
								$result = array('number' => '2', 'msg' => $prev_mobile_error);
							}
						}
						else if (!empty($prev_lr_error)){
							$result = array('number' => '2', 'msg' => $prev_lr_error);
						}
					}
					else if (!empty($prev_name_error)){
						$result = array('number' => '2', 'msg' => $prev_name_error);
					}
				}
				
			}
			else {
				$result = array('number' => '2', 'msg' => 'Invalid IP');
			}
		}
		else {
			if(!empty($valid_branch)) {
				$result = array('number' => '3', 'msg' => $valid_branch);
			}
		}
		
		if(!empty($result)) {
			$result = json_encode($result);
		}
		echo $result; exit;
	}
    if(isset($_POST['page_number'])) {
		$page_number = $_POST['page_number'];
		$page_limit = $_POST['page_limit'];
		$page_title = $_POST['page_title']; 
        $login_staff_id = "";
		if($_SESSION[$GLOBALS['site_name_user_prefix'].'_user_type'] == $GLOBALS['staff_user_type']) {
			$login_staff_id =  $_SESSION[$GLOBALS['site_name_user_prefix'].'_user_id'];
		}
		
		$search_text = "";
		if(isset($_POST['search_text'])) {
			$search_text = $_POST['search_text'];
		}
		$total_records_list = array();
		if(!empty($_SESSION[$GLOBALS['site_name_user_prefix'].'_user_id']) && isset($_SESSION[$GLOBALS['site_name_user_prefix'].'_user_id'])) {
			if(!empty($_SESSION[$GLOBALS['site_name_user_prefix'].'_user_type']) && isset($_SESSION[$GLOBALS['site_name_user_prefix'].'_user_type'])) {
				if($_SESSION[$GLOBALS['site_name_user_prefix'].'_user_type'] == $GLOBALS['branch_staff_user_type']) {					
					$total_records_list = $obj->getTableRecords($GLOBALS['branch_table'], 'branch_id', $_SESSION[$GLOBALS['site_name_user_prefix'].'_user_id']);
				}
				else {
					$total_records_list = $obj->getTableRecords($GLOBALS['branch_table'], '', '');
				}
			}
		}

		if(!empty($search_text)) {
			$search_text = strtolower($search_text);
			$list = array();
			if(!empty($total_records_list)) {
				foreach($total_records_list as $val) {
					if( (strpos(strtolower($obj->encode_decode('decrypt', $val['name'])), $search_text) !== false) ) {
						$list[] = $val;
					}
				}
			}
			$total_records_list = $list;
		}
		
		$total_pages = 0;	
		$total_pages = count($total_records_list);
		
		$page_start = 0; $page_end = 0;
		if(!empty($page_number) && !empty($page_limit) && !empty($total_pages)) {
			if($total_pages > $page_limit) {
				if($page_number) {
					$page_start = ($page_number - 1) * $page_limit;
					$page_end = $page_start + $page_limit;
				}
			}
			else {
				$page_start = 0;
				$page_end = $page_limit;
			}
		}

		$show_records_list = array();
        if(!empty($total_records_list)) {
            foreach($total_records_list as $key => $val) {
                if($key >= $page_start && $key < $page_end) {
                    $show_records_list[] = $val;
                }
            }
        }
		
		$prefix = 0;
		if(!empty($page_number) && !empty($page_limit)) {
			$prefix = ($page_number * $page_limit) - $page_limit;
		} ?>
        
		<?php if($total_pages > $page_limit) { ?>
			<div class="pagination_cover mt-3"> 
				<?php
					include("pagination.php");
				?> 
			</div> 
		<?php } 
		$access_error = "";
        if(!empty($login_staff_id)) {
            $permission_module = $GLOBALS['branch_module'];
            $permission_action = $view_action;
            include('user_permission_action.php');
        }
		if(empty($access_error)) { ?>
        
		<table class="table nowrap cursor bg-white text-center">
            <thead class="bg-light">
                <tr>
                    <th>S.No</th>
                    <th>Branch Name</th>
                    <th>Contact Number</th>
                    <th>Action</th>
                </tr>
            </thead>
            <tbody>
            <?php
                if(!empty($show_records_list)) {
                    foreach($show_records_list as $key => $list) {
                        $index = $key + 1;
                        if(!empty($prefix)) { $index = $index + $prefix; }
                        
                        ?>
                        <tr>
                            <td onclick="Javascript:ShowModalContent('<?php if(!empty($page_title)) { echo $page_title; } ?>', '<?php if(!empty($list['user_id'])) { echo $list['user_id']; } ?>');"><?php echo $index; ?></td>
                            <td onclick="Javascript:ShowModalContent('<?php if(!empty($page_title)) { echo $page_title; } ?>', '<?php if(!empty($list['id'])) { echo $list['id']; } ?>');">
                                <div class="w-100">
                                    <?php
                                        if(!empty($list['name'])) {
                                            $list['name'] = $obj->encode_decode('decrypt', $list['name']);
											if(!empty($list['branch_city'])){
												$list['branch_city'] = $obj->encode_decode('decrypt',$list['branch_city']);
											}
											echo $list['name']." - ".$list['branch_city'];
                                        }
                                    ?>
                                </div>
                                                
                                <?php
                                    if(!empty($list['creator_name'])) {
                                        $list['creator_name'] = $obj->encode_decode('decrypt', $list['creator_name']);
                                ?>
                                        <small><?php echo "Last Opened : ".$list['creator_name']; ?></small>
                                <?php		
                                    }
                                ?>
                            </td>
							<td onclick="Javascript:ShowModalContent('<?php if(!empty($page_title)) { echo $page_title; } ?>', '<?php if(!empty($list['id'])) { echo $list['id']; } ?>');">
                                <?php
                                    if(!empty($list['branch_contact_number'])) {
                                        $list['branch_contact_number'] = $obj->encode_decode('decrypt', $list['branch_contact_number']);
                                        echo $list['branch_contact_number'];
                                    }
                                ?>
                            </td>
                            
                            <td>
                                <?php $access_error = "";
                                    if(!empty($login_staff_id)) {
                                        $permission_module = $GLOBALS['branch_module'];
                                        $permission_action = $edit_action;
                                        include('user_permission_action.php');

                                    }
                                    if(empty($access_error)) { ?>
                                        <a class="pr-2" href="#" onclick="Javascript:ShowModalContent('<?php if(!empty($page_title)) { echo $page_title; } ?>', '<?php if(!empty($list['id'])) { echo $list['id']; } ?>');"><i class="fa fa-pencil"></i></a>
                                <?php } ?>
                                <?php
                                    $access_error = "";
                                    if(!empty($login_staff_id)) {
                                        $permission_module = $GLOBALS['branch_module'];
                                        $permission_action = $delete_action;
                                        include('user_permission_action.php');

                                    }  
                                    if(empty($access_error)) {
                                        $hide_delete = 1;
                                        if(!empty($_SESSION[$GLOBALS['site_name_user_prefix'].'_user_type']) && $_SESSION[$GLOBALS['site_name_user_prefix'].'_user_type'] == $GLOBALS['admin_user_type']) {
                                            $hide_delete = 0;
                                        }
                                        if(empty($hide_delete) && empty($branch_receipt_id) && empty($branch_invoice_id)) {
                                    ?>
                                        <a class="pr-2" href="Javascript:DeleteModalContent('<?php if(!empty($page_title)) { echo $page_title; } ?>', '<?php if(!empty($list['branch_id'])) { echo $list['branch_id']; } ?>');"><i class="fa fa-trash"></i></a>
                                <?php 
                                        } 
                                    } 
                                ?>
                            </td>
                        </tr>
            <?php
                    }
                }
                else {
            ?>
            <tr>
                        <td colspan="6" class="text-center">Sorry! No records found</td>
                    </tr>
            <?php } ?>
            </tbody>
        </table>
                      
		<?php	
		}
	}
	if(isset($_REQUEST['delete_branch_id'])) {
		$delete_branch_id = $_REQUEST['delete_branch_id'];
		$msg = "";
		if(!empty($delete_branch_id)) {
			$branch_unique_id = "";
			$branch_unique_id = $obj->getTableColumnValue($GLOBALS['branch_table'], 'branch_id', $delete_branch_id, 'id');
			// $primary_branch = "";
			// $primary_branch = $obj->getTableColumnValue($GLOBALS['branch_table'], 'branch_id', $delete_branch_id, 'primary_branch');
			if(!empty($branch_unique_id)) {
				if(preg_match("/^\d+$/", $branch_unique_id)) {
					$name = "";
					$name = $obj->getTableColumnValue($GLOBALS['branch_table'], 'branch_id', $delete_branch_id, 'name');
				
					$action = "";
					if(!empty($name)) {
						$action = "Branch Deleted. Name - ".$obj->encode_decode('decrypt', $name);
					}

					$columns = array(); $values = array();						
					$columns = array('deleted');
					$values = array("'1'");
					$msg = $obj->UpdateSQL($GLOBALS['branch_table'], $branch_unique_id, $columns, $values, $action);
				}
			}
			else {
				$msg = "Unable to Delete";
			}
		}
		echo $msg;
		exit;	
	}
?>