

CREATE TABLE `test_mohan_account_party` (
  `id` int(100) NOT NULL AUTO_INCREMENT,
  `created_date_time` datetime NOT NULL,
  `creator` mediumtext NOT NULL,
  `creator_name` mediumtext NOT NULL,
  `account_party_id` mediumtext NOT NULL,
  `name` mediumtext NOT NULL,
  `address` mediumtext NOT NULL,
  `city` mediumtext NOT NULL,
  `district` mediumtext NOT NULL,
  `mobile_number` mediumtext NOT NULL,
  `landline_number` mediumtext NOT NULL,
  `state` mediumtext NOT NULL,
  `gst_number` mediumtext NOT NULL,
  `identification` mediumtext NOT NULL,
  `unit_id` mediumtext NOT NULL,
  `unit_name` mediumtext NOT NULL,
  `price_value` mediumtext NOT NULL,
  `opening_balance` mediumtext NOT NULL,
  `opening_balance_type` mediumtext NOT NULL,
  `cooly_value` mediumtext NOT NULL,
  `deleted` int(100) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=8 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;


INSERT INTO test_mohan_account_party (id, created_date_time, creator, creator_name, account_party_id, name, address, city, district, mobile_number, landline_number, state, gst_number, identification, unit_id, unit_name, price_value, opening_balance, opening_balance_type, cooly_value, deleted) VALUES ('1','2025-07-11 22:17:03','56564e46556c38784d5441334d6a41794e5441354e5445784d6c38774e673d3d','55334a706332396d64486468636d5636','51554e445545465356466c664d5445774e7a49774d6a55784d4445334d444e664d44453d','545339544c6c5a4654453156556c564851553467526b6c4f52534242556c5254','5645684a556c56515656493d','56476c796458423163673d3d','56476c79645842776458493d','4f4451344f546b794d6a51774d413d3d','','5647467461577767546d466b64513d3d','','NULL','5655354a564638774f5441334d6a41794e5441314e4467314e6c38774d513d3d','516d3934','80','','','','0');

INSERT INTO test_mohan_account_party (id, created_date_time, creator, creator_name, account_party_id, name, address, city, district, mobile_number, landline_number, state, gst_number, identification, unit_id, unit_name, price_value, opening_balance, opening_balance_type, cooly_value, deleted) VALUES ('2','2025-07-19 15:46:33','56564e46556c38774d513d3d','55334a706332396d64486468636d5636','51554e445545465356466c664d546b774e7a49774d6a55774d7a51324d7a4e664d44493d','5248567959576b3d','NULL','NULL','','4e6a63324e6a63324e6a63324e773d3d','','NULL','NULL','NULL','','','','','','','1');

INSERT INTO test_mohan_account_party (id, created_date_time, creator, creator_name, account_party_id, name, address, city, district, mobile_number, landline_number, state, gst_number, identification, unit_id, unit_name, price_value, opening_balance, opening_balance_type, cooly_value, deleted) VALUES ('3','2025-07-22 23:25:52','56564e46556c38774d513d3d','55334a706332396d64486468636d5636','51554e445545465356466c664d6a49774e7a49774d6a55784d5449314e544a664d444d3d','545339544c69424c556c416755464a4a546c51675545464453773d3d','NULL','NULL','','4f5451304d6a49314e4449784e413d3d','','NULL','NULL','NULL','','','','','','','0');

INSERT INTO test_mohan_account_party (id, created_date_time, creator, creator_name, account_party_id, name, address, city, district, mobile_number, landline_number, state, gst_number, identification, unit_id, unit_name, price_value, opening_balance, opening_balance_type, cooly_value, deleted) VALUES ('4','2025-07-28 17:01:02','56564e46556c38774d513d3d','55334a706332396d64486468636d5636','51554e445545465356466c664d6a67774e7a49774d6a55774e5441784d444a664d44513d','545339544946497555434167523046535455564f56464d3d','56456c535656425655673d3d','56476c796458423163673d3d','56476c79645842776458493d','4f44677a4f4441354d4459774f413d3d','','5647467461577767546d466b64513d3d','','564538675545465a','NULL','NULL','NULL','','','','0');

INSERT INTO test_mohan_account_party (id, created_date_time, creator, creator_name, account_party_id, name, address, city, district, mobile_number, landline_number, state, gst_number, identification, unit_id, unit_name, price_value, opening_balance, opening_balance_type, cooly_value, deleted) VALUES ('5','2025-07-28 17:12:39','56564e46556c38774d513d3d','55334a706332396d64486468636d5636','51554e445545465356466c664d6a67774e7a49774d6a55774e5445794d7a6c664d44553d','545339544c69424e515578425645684a494546485255354453555654','55306c575155744255306b3d','55326c325957746863326b3d','566d6c796457526f645735685a324679','4f5455344e54557a4d6a45794e673d3d','','5647467461577767546d466b64513d3d','','51554e445431564f5643425151564a5557513d3d','NULL','NULL','NULL','','','','0');

INSERT INTO test_mohan_account_party (id, created_date_time, creator, creator_name, account_party_id, name, address, city, district, mobile_number, landline_number, state, gst_number, identification, unit_id, unit_name, price_value, opening_balance, opening_balance_type, cooly_value, deleted) VALUES ('6','2025-07-30 20:23:03','56564e46556c38774d513d3d','55334a706332396d64486468636d5636','51554e445545465356466c664d7a41774e7a49774d6a55774f44497a4d444e664d44593d','545339544c69424e51556842566b56465569424e51564a4656456c4f52773d3d','55306c575155744255306b67','55326c325957746863326b3d','566d6c796457526f645735685a324679','4f5463344e7a55344f5463344d513d3d','','5647467461577767546d466b64513d3d','','','NULL','NULL','NULL','','0','NULL','0');

INSERT INTO test_mohan_account_party (id, created_date_time, creator, creator_name, account_party_id, name, address, city, district, mobile_number, landline_number, state, gst_number, identification, unit_id, unit_name, price_value, opening_balance, opening_balance_type, cooly_value, deleted) VALUES ('7','2025-07-30 20:28:13','56564e46556c38774d513d3d','55334a706332396d64486468636d5636','51554e445545465356466c664d7a41774e7a49774d6a55774f4449344d544e664d44633d','545339544c694256546b6c5749464242513142425130744252305654494368514b53424d5645513d','NULL','NULL','','4f5467304d7a45344e7a45304e513d3d','','NULL','NULL','NULL','','','','','','','0');


CREATE TABLE `test_mohan_bank` (
  `id` int(100) NOT NULL AUTO_INCREMENT,
  `created_date_time` datetime NOT NULL,
  `creator` mediumtext NOT NULL,
  `creator_name` mediumtext NOT NULL,
  `bill_company_id` mediumtext NOT NULL,
  `bank_id` mediumtext NOT NULL,
  `account_name` mediumtext NOT NULL,
  `account_number` mediumtext NOT NULL,
  `bank_name` mediumtext NOT NULL,
  `ifsc_code` mediumtext NOT NULL,
  `account_type` mediumtext NOT NULL,
  `bank_name_account_number` mediumtext NOT NULL,
  `branch` mediumtext NOT NULL,
  `payment_mode_id` mediumtext NOT NULL,
  `estimate_balance_date` mediumtext NOT NULL,
  `invoice_balance_date` mediumtext NOT NULL,
  `estimate_opening_balance` mediumtext NOT NULL,
  `invoice_opening_balance` mediumtext NOT NULL,
  `deleted` int(100) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;


INSERT INTO test_mohan_bank (id, created_date_time, creator, creator_name, bill_company_id, bank_id, account_name, account_number, bank_name, ifsc_code, account_type, bank_name_account_number, branch, payment_mode_id, estimate_balance_date, invoice_balance_date, estimate_opening_balance, invoice_opening_balance, deleted) VALUES ('1','2025-07-11 23:14:06','56564e46556c38774d513d3d','55334a706332396d64486468636d5636','54314a485155354a576b46555355394f587a45314d4455794d4449304d444d784e544935587a4178','516b464f533138784d5441334d6a41794e5445784d5451774e6c38774d513d3d','545539495155346756464a42546c4e5154314a55','4e5445774f5441354d4445774d4467314d444935','51306c5557534256546b6c50546942435155354c','51306c56516a41774d4441784d54513d','NULL','51306c5557534256546b6c50546942435155354c494367314d5441354d446b774d5441774f4455774d6a6b70','55306c575155744255306b3d','5547463562575675644639746232526c587a45334d4463794d4449314d5441774f545178587a4131,5547463562575675644639746232526c587a45314d4463794d4449314d5445314e544135587a4130,5547463562575675644639746232526c587a45784d4463794d4449314d5445774f544534587a4178','','','','','0');


CREATE TABLE `test_mohan_branch` (
  `id` int(100) NOT NULL AUTO_INCREMENT,
  `creator` mediumtext NOT NULL,
  `created_date_time` datetime NOT NULL,
  `creator_name` mediumtext NOT NULL,
  `bill_company_id` mediumtext NOT NULL,
  `branch_id` mediumtext NOT NULL,
  `name` mediumtext NOT NULL,
  `branch_contact_number` mediumtext NOT NULL,
  `branch_lr_prefix` mediumtext NOT NULL,
  `branch_address` mediumtext NOT NULL,
  `lower_case_name` mediumtext NOT NULL,
  `branch_city` mediumtext NOT NULL,
  `lower_case_city` mediumtext NOT NULL,
  `branch_pincode` mediumtext NOT NULL,
  `state` mediumtext NOT NULL,
  `district` mediumtext NOT NULL,
  `opening_balance` mediumtext NOT NULL,
  `opening_balance_type` mediumtext NOT NULL,
  `tax_opening_balance` mediumtext NOT NULL,
  `tax_opening_balance_type` mediumtext NOT NULL,
  `others_city` mediumtext NOT NULL,
  `deleted` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;


INSERT INTO test_mohan_branch (id, creator, created_date_time, creator_name, bill_company_id, branch_id, name, branch_contact_number, branch_lr_prefix, branch_address, lower_case_name, branch_city, lower_case_city, branch_pincode, state, district, opening_balance, opening_balance_type, tax_opening_balance, tax_opening_balance_type, others_city, deleted) VALUES ('1','56564e46556c38774d513d3d','2025-07-09 17:41:10','55334a706332396d64486468636d5636','54314a485155354a576b46555355394f587a45314d4455794d4449304d444d784e544935587a4178','516c4a42546b4e49587a41354d4463794d4449314d4455304d544577587a4178','55326c325957746863326b3d','4e7a4d334d7a67314e6a63334e773d3d','55315a4c','55326c325957746863326b675457467062673d3d','63326c325957746863326b3d','55326c325957746863326b3d','63326c325957746863326b3d','4e6a49324d546735','5647467461577767546d466b64513d3d','566d6c796457526f645735685a324679','NULL','NULL','NULL','NULL','','0');

INSERT INTO test_mohan_branch (id, creator, created_date_time, creator_name, bill_company_id, branch_id, name, branch_contact_number, branch_lr_prefix, branch_address, lower_case_name, branch_city, lower_case_city, branch_pincode, state, district, opening_balance, opening_balance_type, tax_opening_balance, tax_opening_balance_type, others_city, deleted) VALUES ('2','56564e46556c38774d513d3d','2025-07-09 17:42:58','55334a706332396d64486468636d5636','54314a485155354a576b46555355394f587a45314d4455794d4449304d444d784e544935587a4178','516c4a42546b4e49587a41354d4463794d4449314d4455304d6a5534587a4179','56476870636e56776458493d','4f5459314e54557a4d6a41304f413d3d','56464253','4e43387949464e42553152535353424f515564425569417352456842556b465156564a4254534253543046454c43424f5255465349456450566b5653546b3146546c51675345395455456c55515577734946524953564a5655465653','64476870636e56776458493d','56476c796458423163673d3d','64476c796458423163673d3d','4e6a51784e6a4130','5647467461577767546d466b64513d3d','56476c79645842776458493d','NULL','NULL','NULL','NULL','','0');

INSERT INTO test_mohan_branch (id, creator, created_date_time, creator_name, bill_company_id, branch_id, name, branch_contact_number, branch_lr_prefix, branch_address, lower_case_name, branch_city, lower_case_city, branch_pincode, state, district, opening_balance, opening_balance_type, tax_opening_balance, tax_opening_balance_type, others_city, deleted) VALUES ('3','56564e46556c38774d513d3d','2025-07-09 17:43:48','55334a706332396d64486468636d5636','54314a485155354a576b46555355394f587a45314d4455794d4449304d444d784e544935587a4178','516c4a42546b4e49587a41354d4463794d4449314d4455304d7a5134587a417a','5457466b64584a6861513d3d','4f446b794d7a497a4e4455774d413d3d','54555256','5457466b64584a6861534243636d46755932673d','6257466b64584a6861513d3d','5457466b64584a68615342585a584e30','6257466b64584a68615342335a584e30','4e6a497a4e545933','5647467461577767546d466b64513d3d','5457466b64584a6861513d3d','2340','Credit','NULL','NULL','','1');

INSERT INTO test_mohan_branch (id, creator, created_date_time, creator_name, bill_company_id, branch_id, name, branch_contact_number, branch_lr_prefix, branch_address, lower_case_name, branch_city, lower_case_city, branch_pincode, state, district, opening_balance, opening_balance_type, tax_opening_balance, tax_opening_balance_type, others_city, deleted) VALUES ('4','56564e46556c38774d513d3d','2025-07-14 15:31:58','55334a706332396d64486468636d5636','54314a485155354a576b46555355394f587a45314d4455794d4449304d444d784e544935587a4178','516c4a42546b4e49587a45304d4463794d4449314d444d7a4d545534587a4130','5132397062574a68644739795a534243636d46755932673d','4f446b344e7a67334e7a67344e773d3d','51303143','516e6c6c4948426863334d67556d39685a413d3d','5932397062574a68644739795a534269636d46755932673d','51586c68626d463259584a6862513d3d','59586c68626d463259584a6862513d3d','4e6a49324d546735','5647467461577767546d466b64513d3d','5132686c626d356861513d3d','60000','Credit','70000','Credit','','0');


CREATE TABLE `test_mohan_charges` (
  `id` int(100) NOT NULL AUTO_INCREMENT,
  `created_date_time` datetime NOT NULL,
  `creator` mediumtext NOT NULL,
  `creator_name` mediumtext NOT NULL,
  `bill_company_id` mediumtext NOT NULL,
  `charges_id` mediumtext NOT NULL,
  `charges_name` mediumtext NOT NULL,
  `lower_case_name` mediumtext NOT NULL,
  `deleted` int(100) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;


INSERT INTO test_mohan_charges (id, created_date_time, creator, creator_name, bill_company_id, charges_id, charges_name, lower_case_name, deleted) VALUES ('1','2025-07-15 12:39:40','56564e46556c38774d513d3d','55334a706332396d64486468636d5636','54314a485155354a576b46555355394f587a45314d4455794d4449304d444d784e544935587a4178','51306842556b6446553138784e5441334d6a41794e5445794d7a6b304d4638774d513d3d','6247396a595777675a47567361585a6c636e6b3d','6247396a595777675a47567361585a6c636e6b3d','0');


CREATE TABLE `test_mohan_company_bill_number` (
  `id` int(100) NOT NULL AUTO_INCREMENT,
  `create_date_time` datetime NOT NULL,
  `creator` mediumtext NOT NULL,
  `bill_company_id` mediumtext NOT NULL,
  `financial_year` date NOT NULL,
  `bill_number_option` mediumtext NOT NULL,
  `deleted` int(10) NOT NULL,
  `creator_name` mediumtext NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;



CREATE TABLE `test_mohan_consignee` (
  `id` int(100) NOT NULL AUTO_INCREMENT,
  `created_date_time` datetime NOT NULL,
  `creator` mediumtext NOT NULL,
  `creator_name` mediumtext NOT NULL,
  `consignee_id` mediumtext NOT NULL,
  `name` mediumtext NOT NULL,
  `address` mediumtext NOT NULL,
  `city` mediumtext NOT NULL,
  `mobile_number` mediumtext NOT NULL,
  `landline_number` mediumtext NOT NULL,
  `district` mediumtext NOT NULL,
  `state` mediumtext NOT NULL,
  `gst_number` mediumtext NOT NULL,
  `identification` mediumtext NOT NULL,
  `others_city` mediumtext NOT NULL,
  `unit_id` mediumtext NOT NULL,
  `unit_name` mediumtext NOT NULL,
  `price_value` mediumtext NOT NULL,
  `opening_balance` mediumtext NOT NULL,
  `opening_balance_type` mediumtext NOT NULL,
  `cooly_value` mediumtext NOT NULL,
  `deleted` int(100) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=166 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;


INSERT INTO test_mohan_consignee (id, created_date_time, creator, creator_name, consignee_id, name, address, city, mobile_number, landline_number, district, state, gst_number, identification, others_city, unit_id, unit_name, price_value, opening_balance, opening_balance_type, cooly_value, deleted) VALUES ('1','2025-07-11 22:01:24','56564e46556c38784d5441334d6a41794e5441354e54517a4d5638774e773d3d','56476870636e56745a573570','5130394f55306c48546b5646587a45784d4463794d4449314d5441774d544930587a4178','5530464f52306c4d53513d3d','NULL','55326c325957746863326b3d','4e7a4d334d7a67314e6a63334e773d3d','','566d6c796457526f645735685a324679','5647467461577767546d466b64513d3d','NULL','NULL','NULL','','','','','','','0');

INSERT INTO test_mohan_consignee (id, created_date_time, creator, creator_name, consignee_id, name, address, city, mobile_number, landline_number, district, state, gst_number, identification, others_city, unit_id, unit_name, price_value, opening_balance, opening_balance_type, cooly_value, deleted) VALUES ('2','2025-07-11 22:13:05','56564e46556c38784d5441334d6a41794e5441354e5445784d6c38774e673d3d','566b464553565a4654413d3d','5130394f55306c48546b5646587a45784d4463794d4449314d5441784d7a4131587a4179','545339544c6c5a4654453156556c564851553467526b6c4f52534242556c5254','5645684a556c56515656493d','56476c796458423163673d3d','4f4451344f546b794d6a51774d413d3d','','56476c79645842776458493d','5647467461577767546d466b64513d3d','NULL','51554e445431564f5643425151564a5557513d3d','','5655354a564638774f5441334d6a41794e5441314e4467314e6c38774d513d3d','516d3934','80','','','','1');

INSERT INTO test_mohan_consignee (id, created_date_time, creator, creator_name, consignee_id, name, address, city, mobile_number, landline_number, district, state, gst_number, identification, others_city, unit_id, unit_name, price_value, opening_balance, opening_balance_type, cooly_value, deleted) VALUES ('3','2025-07-14 15:35:24','56564e46556c38784e4441334d6a41794e54417a4d7a4d7a4f5638774f413d3d','55334a706332396d64486468636d5636','5130394f55306c48546b5646587a45304d4463794d4449314d444d7a4e544930587a417a','564746746157773d','NULL','55326c325957746863326b3d','4e6a63334e6a63324e6a63334e673d3d','','566d6c796457526f645735685a324679','5647467461577767546d466b64513d3d','NULL','NULL','NULL','','','','','','','0');

INSERT INTO test_mohan_consignee (id, created_date_time, creator, creator_name, consignee_id, name, address, city, mobile_number, landline_number, district, state, gst_number, identification, others_city, unit_id, unit_name, price_value, opening_balance, opening_balance_type, cooly_value, deleted) VALUES ('4','2025-07-14 22:45:33','56564e46556c38774d513d3d','55334a706332396d64486468636d5636','5130394f55306c48546b5646587a45304d4463794d4449314d5441304e544d7a587a4130','533246796447687061773d3d','NULL','56476c796458423163673d3d','4f5459314e54557a4d6a41304f413d3d','','56476c79645842776458493d','5647467461577767546d466b64513d3d','NULL','NULL','NULL','','','','','','','0');

INSERT INTO test_mohan_consignee (id, created_date_time, creator, creator_name, consignee_id, name, address, city, mobile_number, landline_number, district, state, gst_number, identification, others_city, unit_id, unit_name, price_value, opening_balance, opening_balance_type, cooly_value, deleted) VALUES ('5','2025-07-15 09:44:49','56564e46556c38774d513d3d','55334a706332396d64486468636d5636','5130394f55306c48546b5646587a45314d4463794d4449314d446b304e445135587a4131','626d46336157343d','NULL','NULL','4e6a63334e6a59334e6a63324e773d3d','','5132397062574a68644739795a513d3d','5647467461577767546d466b64513d3d','NULL','NULL','NULL','','','','','','','0');

INSERT INTO test_mohan_consignee (id, created_date_time, creator, creator_name, consignee_id, name, address, city, mobile_number, landline_number, district, state, gst_number, identification, others_city, unit_id, unit_name, price_value, opening_balance, opening_balance_type, cooly_value, deleted) VALUES ('6','2025-07-18 20:47:39','56564e46556c38774d513d3d','55334a706332396d64486468636d5636','5130394f55306c48546b5646587a45344d4463794d4449314d4467304e7a4d35587a4132','545339544c6942425455466152534251556b6c4f56455653','56456c5356564256556977675331564e51564967546b46485156496752554654564341785531516755315253525556554c413d3d','56476c796458423163673d3d','4f4455774f446b344f5467774e513d3d','','56476c79645842776458493d','5647467461577767546d466b64513d3d','NULL','NULL','','NULL','NULL','NULL','','','','0');

INSERT INTO test_mohan_consignee (id, created_date_time, creator, creator_name, consignee_id, name, address, city, mobile_number, landline_number, district, state, gst_number, identification, others_city, unit_id, unit_name, price_value, opening_balance, opening_balance_type, cooly_value, deleted) VALUES ('7','2025-07-18 20:49:10','56564e46556c38774d513d3d','55334a706332396d64486468636d5636','5130394f55306c48546b5646587a45344d4463794d4449314d4467304f544577587a4133','545339544c6942485445464e576c6f67526b465453456c5054673d3d','56456c535656425655673d3d','56476c796458423163673d3d','4f5455324e6a67794d6a4d324d413d3d','','56476c79645842776458493d','5647467461577767546d466b64513d3d','NULL','NULL','','NULL','NULL','NULL','','','','0');

INSERT INTO test_mohan_consignee (id, created_date_time, creator, creator_name, consignee_id, name, address, city, mobile_number, landline_number, district, state, gst_number, identification, others_city, unit_id, unit_name, price_value, opening_balance, opening_balance_type, cooly_value, deleted) VALUES ('8','2025-07-18 20:50:23','56564e46556c38774d513d3d','55334a706332396d64486468636d5636','5130394f55306c48546b5646587a45344d4463794d4449314d4467314d44497a587a4134','545339544c694248543039455630465a494642425130744252306c4f52773d3d','56456c535656425655673d3d','56476c796458423163673d3d','4f546b314d6a4d774e5451784d773d3d','','56476c79645842776458493d','5647467461577767546d466b64513d3d','NULL','NULL','','NULL','NULL','NULL','','','','0');

INSERT INTO test_mohan_consignee (id, created_date_time, creator, creator_name, consignee_id, name, address, city, mobile_number, landline_number, district, state, gst_number, identification, others_city, unit_id, unit_name, price_value, opening_balance, opening_balance_type, cooly_value, deleted) VALUES ('9','2025-07-18 20:53:05','56564e46556c38774d513d3d','55334a706332396d64486468636d5636','5130394f55306c48546b5646587a45344d4463794d4449314d4467314d7a4131587a4135','545339544c69425355434244565641675455464c52564a54','56456c535656425655673d3d','56476c796458423163673d3d','4f5467354e4463324e6a557a4e413d3d','','56476c79645842776458493d','5647467461577767546d466b64513d3d','NULL','NULL','','NULL','NULL','NULL','','','','0');

INSERT INTO test_mohan_consignee (id, created_date_time, creator, creator_name, consignee_id, name, address, city, mobile_number, landline_number, district, state, gst_number, identification, others_city, unit_id, unit_name, price_value, opening_balance, opening_balance_type, cooly_value, deleted) VALUES ('10','2025-07-18 21:00:34','56564e46556c38774d513d3d','55334a706332396d64486468636d5636','5130394f55306c48546b5646587a45344d4463794d4449314d446b774d444d30587a4577','545339544c6942534946424d51564e5553554d3d','56456c535656425655673d3d','56476c796458423163673d3d','4f5441344d4449344d5463794d773d3d','','56476c79645842776458493d','5647467461577767546d466b64513d3d','NULL','NULL','','NULL','NULL','NULL','','','','0');

INSERT INTO test_mohan_consignee (id, created_date_time, creator, creator_name, consignee_id, name, address, city, mobile_number, landline_number, district, state, gst_number, identification, others_city, unit_id, unit_name, price_value, opening_balance, opening_balance_type, cooly_value, deleted) VALUES ('11','2025-07-18 21:01:48','56564e46556c38774d513d3d','55334a706332396d64486468636d5636','5130394f55306c48546b5646587a45344d4463794d4449314d446b774d545134587a4578','545339544c694247556b6c46546b525449454e42556b5254','56456c535656425655673d3d','56476c796458423163673d3d','4f544d324d7a41784f5467784d413d3d','','56476c79645842776458493d','5647467461577767546d466b64513d3d','NULL','NULL','','NULL','NULL','NULL','','','','0');

INSERT INTO test_mohan_consignee (id, created_date_time, creator, creator_name, consignee_id, name, address, city, mobile_number, landline_number, district, state, gst_number, identification, others_city, unit_id, unit_name, price_value, opening_balance, opening_balance_type, cooly_value, deleted) VALUES ('12','2025-07-18 21:03:04','56564e46556c38774d513d3d','55334a706332396d64486468636d5636','5130394f55306c48546b5646587a45344d4463794d4449314d446b774d7a4130587a4579','545339544c694254556b6b6751566c5a515642515153424d51554a4654464d3d','56456c535656425655673d3d','56476c796458423163673d3d','4f5451304e5459304e6a517a4e673d3d','','56476c79645842776458493d','5647467461577767546d466b64513d3d','NULL','NULL','','NULL','NULL','NULL','','','','0');

INSERT INTO test_mohan_consignee (id, created_date_time, creator, creator_name, consignee_id, name, address, city, mobile_number, landline_number, district, state, gst_number, identification, others_city, unit_id, unit_name, price_value, opening_balance, opening_balance_type, cooly_value, deleted) VALUES ('13','2025-07-18 21:04:15','56564e46556c38774d513d3d','55334a706332396d64486468636d5636','5130394f55306c48546b5646587a45344d4463794d4449314d446b774e444531587a457a','545339544c694256524568425755464e49454e42556b5254','56456c535656425655673d3d','56476c796458423163673d3d','4f5445314d444d314e5455304f413d3d','','56476c79645842776458493d','5647467461577767546d466b64513d3d','NULL','NULL','','NULL','NULL','NULL','','','','0');

INSERT INTO test_mohan_consignee (id, created_date_time, creator, creator_name, consignee_id, name, address, city, mobile_number, landline_number, district, state, gst_number, identification, others_city, unit_id, unit_name, price_value, opening_balance, opening_balance_type, cooly_value, deleted) VALUES ('14','2025-07-18 21:05:21','56564e46556c38774d513d3d','55334a706332396d64486468636d5636','5130394f55306c48546b5646587a45344d4463794d4449314d446b774e544978587a4530','545339544c694254556b6b67536b464a49464253535535555256493d','56456c535656425655673d3d','56476c796458423163673d3d','4f5463344f5459324e4467344e413d3d','','56476c79645842776458493d','5647467461577767546d466b64513d3d','NULL','NULL','','NULL','NULL','NULL','','','','0');

INSERT INTO test_mohan_consignee (id, created_date_time, creator, creator_name, consignee_id, name, address, city, mobile_number, landline_number, district, state, gst_number, identification, others_city, unit_id, unit_name, price_value, opening_balance, opening_balance_type, cooly_value, deleted) VALUES ('15','2025-07-18 21:06:35','56564e46556c38774d513d3d','55334a706332396d64486468636d5636','5130394f55306c48546b5646587a45344d4463794d4449314d446b774e6a4d31587a4531','4945307655793467546b465351566c42546b456755315250556b556f4f5451344e6a4d794d4445304f536b3d','56456c535656425655673d3d','56476c796458423163673d3d','4f5451344e6a4d794d4445304f513d3d','','56476c79645842776458493d','5647467461577767546d466b64513d3d','NULL','NULL','','NULL','NULL','NULL','','','','0');

INSERT INTO test_mohan_consignee (id, created_date_time, creator, creator_name, consignee_id, name, address, city, mobile_number, landline_number, district, state, gst_number, identification, others_city, unit_id, unit_name, price_value, opening_balance, opening_balance_type, cooly_value, deleted) VALUES ('16','2025-07-18 21:07:39','56564e46556c38774d513d3d','55334a706332396d64486468636d5636','5130394f55306c48546b5646587a45344d4463794d4449314d446b774e7a4d35587a4532','545339544c69424e5156676752314a425545684a51305654','56456c535656425655673d3d','56476c796458423163673d3d','4f5455774d4451324e4455774e513d3d','','56476c79645842776458493d','5647467461577767546d466b64513d3d','NULL','NULL','','NULL','NULL','NULL','','','','0');

INSERT INTO test_mohan_consignee (id, created_date_time, creator, creator_name, consignee_id, name, address, city, mobile_number, landline_number, district, state, gst_number, identification, others_city, unit_id, unit_name, price_value, opening_balance, opening_balance_type, cooly_value, deleted) VALUES ('17','2025-07-18 21:40:53','56564e46556c38774d513d3d','55334a706332396d64486468636d5636','5130394f55306c48546b5646587a45344d4463794d4449314d446b304d44557a587a4533','545339544c69424b525651675330354a5643425852554653','56456c535656425655673d3d','56476c796458423163673d3d','4f544d324d6a49304f4459784d673d3d','','56476c79645842776458493d','5647467461577767546d466b64513d3d','NULL','NULL','','NULL','NULL','NULL','','','','0');

INSERT INTO test_mohan_consignee (id, created_date_time, creator, creator_name, consignee_id, name, address, city, mobile_number, landline_number, district, state, gst_number, identification, others_city, unit_id, unit_name, price_value, opening_balance, opening_balance_type, cooly_value, deleted) VALUES ('18','2025-07-18 21:42:34','56564e46556c38774d513d3d','55334a706332396d64486468636d5636','5130394f55306c48546b5646587a45344d4463794d4449314d446b304d6a4d30587a4534','545339544c69425456564a42516b684a4945744f53565167563056425569416f5530564a56436b3d','56456c535656425655673d3d','56476c796458423163673d3d','4f546b354e4441784d5467304f413d3d','','56476c79645842776458493d','5647467461577767546d466b64513d3d','NULL','NULL','','NULL','NULL','NULL','','','','0');

INSERT INTO test_mohan_consignee (id, created_date_time, creator, creator_name, consignee_id, name, address, city, mobile_number, landline_number, district, state, gst_number, identification, others_city, unit_id, unit_name, price_value, opening_balance, opening_balance_type, cooly_value, deleted) VALUES ('19','2025-07-18 22:05:19','56564e46556c38774d513d3d','55334a706332396d64486468636d5636','5130394f55306c48546b5646587a45344d4463794d4449314d5441774e544535587a4535','545339544c69425151564a425579425552566855535578464943685452556c554b513d3d','56456c535656425655673d3d','56476c796458423163673d3d','4d4451794d5449794d6a497a4e673d3d','','56476c79645842776458493d','5647467461577767546d466b64513d3d','NULL','4d4451794d5449794d6a497a4e6a413d','','NULL','NULL','NULL','','','','0');

INSERT INTO test_mohan_consignee (id, created_date_time, creator, creator_name, consignee_id, name, address, city, mobile_number, landline_number, district, state, gst_number, identification, others_city, unit_id, unit_name, price_value, opening_balance, opening_balance_type, cooly_value, deleted) VALUES ('20','2025-07-18 22:08:37','56564e46556c38774d513d3d','55334a706332396d64486468636d5636','5130394f55306c48546b5646587a45344d4463794d4449314d5441774f444d33587a4977','545339544c69424e51564a5656456842556942515445465456456c44','56456c535656425655673d3d','56476c796458423163673d3d','4e7a4d774e5467344e7a51314f513d3d','','56476c79645842776458493d','5647467461577767546d466b64513d3d','NULL','NULL','','NULL','NULL','NULL','','','','0');

INSERT INTO test_mohan_consignee (id, created_date_time, creator, creator_name, consignee_id, name, address, city, mobile_number, landline_number, district, state, gst_number, identification, others_city, unit_id, unit_name, price_value, opening_balance, opening_balance_type, cooly_value, deleted) VALUES ('21','2025-07-18 22:10:28','56564e46556c38774d513d3d','55334a706332396d64486468636d5636','5130394f55306c48546b5646587a45344d4463794d4449314d5441784d444934587a4978','545339544c6942575255784e56564a565230464f49455a4a546b556751564a5555773d3d','56456c535656425655673d3d','56476c796458423163673d3d','4f5467304d7a4d794d6a51774d413d3d','','56476c79645842776458493d','5647467461577767546d466b64513d3d','NULL','NULL','','NULL','NULL','NULL','','','','0');

INSERT INTO test_mohan_consignee (id, created_date_time, creator, creator_name, consignee_id, name, address, city, mobile_number, landline_number, district, state, gst_number, identification, others_city, unit_id, unit_name, price_value, opening_balance, opening_balance_type, cooly_value, deleted) VALUES ('22','2025-07-19 12:17:20','56564e46556c38774d513d3d','55334a706332396d64486468636d5636','5130394f55306c48546b5646587a45354d4463794d4449314d5449784e7a4977587a4979','545339544c694254556b6b67566b6c4f51566c4252304567516b464855773d3d','51565a4a546b465453513d3d','56476c796458423163673d3d','4f544d324d5441344e7a41774d413d3d','','56476c79645842776458493d','5647467461577767546d466b64513d3d','NULL','NULL','','NULL','NULL','NULL','','','','0');

INSERT INTO test_mohan_consignee (id, created_date_time, creator, creator_name, consignee_id, name, address, city, mobile_number, landline_number, district, state, gst_number, identification, others_city, unit_id, unit_name, price_value, opening_balance, opening_balance_type, cooly_value, deleted) VALUES ('23','2025-07-19 12:18:50','56564e46556c38774d513d3d','55334a706332396d64486468636d5636','5130394f55306c48546b5646587a45354d4463794d4449314d5449784f445577587a497a','545339544c69424254457449515652435353416f5153354c4c6b56595545395356464d7049436854556b6c5351553070','56456c535656425655673d3d','56476c796458423163673d3d','4f5467304d7a41334d5445784e413d3d','','56476c79645842776458493d','5647467461577767546d466b64513d3d','NULL','NULL','','NULL','NULL','NULL','','','','0');

INSERT INTO test_mohan_consignee (id, created_date_time, creator, creator_name, consignee_id, name, address, city, mobile_number, landline_number, district, state, gst_number, identification, others_city, unit_id, unit_name, price_value, opening_balance, opening_balance_type, cooly_value, deleted) VALUES ('24','2025-07-19 12:19:55','56564e46556c38774d513d3d','56476870636e56745a573570','5130394f55306c48546b5646587a45354d4463794d4449314d5449784f545531587a4930','545339544c69424e5255564f5155745453456b674a69424454773d3d','56456c535656425655673d3d','56476c796458423163673d3d','4f5441304e7a417a4e6a49794d513d3d','','56476c79645842776458493d','5647467461577767546d466b64513d3d','NULL','NULL','NULL','NULL','NULL','NULL','','','','0');

INSERT INTO test_mohan_consignee (id, created_date_time, creator, creator_name, consignee_id, name, address, city, mobile_number, landline_number, district, state, gst_number, identification, others_city, unit_id, unit_name, price_value, opening_balance, opening_balance_type, cooly_value, deleted) VALUES ('25','2025-07-19 12:22:41','56564e46556c38774d513d3d','55334a706332396d64486468636d5636','5130394f55306c48546b5646587a45354d4463794d4449314d5449794d6a5178587a4931','545339544c69424e54305246556b346755315250556b553d','56456c53565642515656493d','56476c796458423163673d3d','4f5467304d7a51334e7a45784f513d3d','','56476c79645842776458493d','5647467461577767546d466b64513d3d','NULL','NULL','','NULL','NULL','NULL','','','','0');

INSERT INTO test_mohan_consignee (id, created_date_time, creator, creator_name, consignee_id, name, address, city, mobile_number, landline_number, district, state, gst_number, identification, others_city, unit_id, unit_name, price_value, opening_balance, opening_balance_type, cooly_value, deleted) VALUES ('26','2025-07-19 12:24:30','56564e46556c38774d513d3d','55334a706332396d64486468636d5636','5130394f55306c48546b5646587a45354d4463794d4449314d5449794e444d77587a4932','545339544c6942534945464f52434253494652465746524a544555674b4564514b513d3d','56456c535656425655673d3d','56476c796458423163673d3d','4f5467304d6a49344e4445304e773d3d','','56476c79645842776458493d','5647467461577767546d466b64513d3d','NULL','NULL','','NULL','NULL','NULL','','','','0');

INSERT INTO test_mohan_consignee (id, created_date_time, creator, creator_name, consignee_id, name, address, city, mobile_number, landline_number, district, state, gst_number, identification, others_city, unit_id, unit_name, price_value, opening_balance, opening_balance_type, cooly_value, deleted) VALUES ('27','2025-07-19 12:29:33','56564e46556c38774d513d3d','55334a706332396d64486468636d5636','5130394f55306c48546b5646587a45354d4463794d4449314d5449794f544d7a587a4933','545339544c69424253564e49563046535755464e49454e42556b5254','56456c535656425655673d3d','56476c796458423163673d3d','4f546b354e444d334e7a51304e773d3d','','56476c79645842776458493d','5647467461577767546d466b64513d3d','NULL','NULL','','NULL','NULL','NULL','','','','0');

INSERT INTO test_mohan_consignee (id, created_date_time, creator, creator_name, consignee_id, name, address, city, mobile_number, landline_number, district, state, gst_number, identification, others_city, unit_id, unit_name, price_value, opening_balance, opening_balance_type, cooly_value, deleted) VALUES ('28','2025-07-19 12:38:36','56564e46556c38774d513d3d','55334a706332396d64486468636d5636','5130394f55306c48546b5646587a45354d4463794d4449314d54497a4f444d32587a4934','545339544c694254556b6b67556b464e494564535156424953554e54','56456c535656425655673d3d','56476c796458423163673d3d','4f544d304e4463334d5463784f413d3d','','56476c79645842776458493d','5647467461577767546d466b64513d3d','NULL','NULL','','NULL','NULL','NULL','','','','0');

INSERT INTO test_mohan_consignee (id, created_date_time, creator, creator_name, consignee_id, name, address, city, mobile_number, landline_number, district, state, gst_number, identification, others_city, unit_id, unit_name, price_value, opening_balance, opening_balance_type, cooly_value, deleted) VALUES ('29','2025-07-19 12:40:15','56564e46556c38774d513d3d','55334a706332396d64486468636d5636','5130394f55306c48546b5646587a45354d4463794d4449314d5449304d444531587a4935','545339544c69424651564e5851564967513078505645684a546b63675130394e5545464f57513d3d','56456c535656425655673d3d','56476c796458423163673d3d','4f4449334d4441324d4445304d673d3d','','56476c79645842776458493d','5647467461577767546d466b64513d3d','NULL','NULL','','NULL','NULL','NULL','','','','0');

INSERT INTO test_mohan_consignee (id, created_date_time, creator, creator_name, consignee_id, name, address, city, mobile_number, landline_number, district, state, gst_number, identification, others_city, unit_id, unit_name, price_value, opening_balance, opening_balance_type, cooly_value, deleted) VALUES ('30','2025-07-19 12:43:15','56564e46556c38774d513d3d','55334a706332396d64486468636d5636','5130394f55306c48546b5646587a45354d4463794d4449314d5449304d7a4531587a4d77','545339544c69425751564a565469425552566855535578465579416f52314170','56456c535656425655673d3d','56476c796458423163673d3d','4f5463314d5467784f4445304e773d3d','','56476c79645842776458493d','5647467461577767546d466b64513d3d','NULL','NULL','','NULL','NULL','NULL','','','','0');

INSERT INTO test_mohan_consignee (id, created_date_time, creator, creator_name, consignee_id, name, address, city, mobile_number, landline_number, district, state, gst_number, identification, others_city, unit_id, unit_name, price_value, opening_balance, opening_balance_type, cooly_value, deleted) VALUES ('31','2025-07-19 12:44:42','56564e46556c38774d513d3d','55334a706332396d64486468636d5636','5130394f55306c48546b5646587a45354d4463794d4449314d5449304e445179587a4d78','545339544c6942555255564c5653424c56553142556b464f49455a425530684a5430343d','56456c535656425655673d3d','56476c796458423163673d3d','4d4451314e6a49794e5445304d413d3d','','56476c79645842776458493d','5647467461577767546d466b64513d3d','NULL','NULL','NULL','NULL','NULL','NULL','','','','0');

INSERT INTO test_mohan_consignee (id, created_date_time, creator, creator_name, consignee_id, name, address, city, mobile_number, landline_number, district, state, gst_number, identification, others_city, unit_id, unit_name, price_value, opening_balance, opening_balance_type, cooly_value, deleted) VALUES ('32','2025-07-19 12:46:46','56564e46556c38774d513d3d','55334a706332396d64486468636d5636','5130394f55306c48546b5646587a45354d4463794d4449314d5449304e6a5132587a4d79','545339544c694251556b6c5a5153424954314e4a52564a544943684855436b3d','56456c535656425655673d3d','56476c796458423163673d3d','4f5451344f4445324d5445314e513d3d','','56476c79645842776458493d','5647467461577767546d466b64513d3d','NULL','51554e445431564f5643425151564a5557513d3d','','NULL','NULL','NULL','','','','0');

INSERT INTO test_mohan_consignee (id, created_date_time, creator, creator_name, consignee_id, name, address, city, mobile_number, landline_number, district, state, gst_number, identification, others_city, unit_id, unit_name, price_value, opening_balance, opening_balance_type, cooly_value, deleted) VALUES ('33','2025-07-19 13:01:24','56564e46556c38774d513d3d','55334a706332396d64486468636d5636','5130394f55306c48546b5646587a45354d4463794d4449314d4445774d544930587a4d7a','545339544c69424e5155354a556b464b49454e50564652505469416f52314170','56456c535656425655673d3d','56476c796458423163673d3d','4f5459794e6a497a4d7a49774f413d3d','','56476c79645842776458493d','5647467461577767546d466b64513d3d','NULL','NULL','','NULL','NULL','NULL','','','','0');

INSERT INTO test_mohan_consignee (id, created_date_time, creator, creator_name, consignee_id, name, address, city, mobile_number, landline_number, district, state, gst_number, identification, others_city, unit_id, unit_name, price_value, opening_balance, opening_balance_type, cooly_value, deleted) VALUES ('34','2025-07-19 13:03:18','56564e46556c38774d513d3d','55334a706332396d64486468636d5636','5130394f55306c48546b5646587a45354d4463794d4449314d4445774d7a4534587a4d30','545339544c6942485430784549454a535355564755773d3d','56456c535656425655673d3d','56476c796458423163673d3d','4d4451794d5449304d6a4d344d513d3d','','56476c79645842776458493d','5647467461577767546d466b64513d3d','NULL','494441304d6a45794e44497a4f444534','','NULL','NULL','NULL','','','','0');

INSERT INTO test_mohan_consignee (id, created_date_time, creator, creator_name, consignee_id, name, address, city, mobile_number, landline_number, district, state, gst_number, identification, others_city, unit_id, unit_name, price_value, opening_balance, opening_balance_type, cooly_value, deleted) VALUES ('35','2025-07-19 13:12:53','56564e46556c38774d513d3d','55334a706332396d64486468636d5636','5130394f55306c48546b5646587a45354d4463794d4449314d4445784d6a557a587a4d31','545339544c694251556b46575255564f4945564f5645565355464a4a55305654','56456c535656425655673d3d','56476c796458423163673d3d','4f5467304d6a49334e444d324d773d3d','','56476c79645842776458493d','5647467461577767546d466b64513d3d','NULL','NULL','NULL','NULL','NULL','NULL','','','','0');

INSERT INTO test_mohan_consignee (id, created_date_time, creator, creator_name, consignee_id, name, address, city, mobile_number, landline_number, district, state, gst_number, identification, others_city, unit_id, unit_name, price_value, opening_balance, opening_balance_type, cooly_value, deleted) VALUES ('36','2025-07-19 13:16:16','56564e46556c38774d513d3d','55334a706332396d64486468636d5636','5130394f55306c48546b5646587a45354d4463794d4449314d4445784e6a4532587a4d32','545339544c69424a5531525a5743424a546c5246556b354256456c50546b464d4943685452556c554b513d3d','56456c535656425655673d3d','56476c796458423163673d3d','4f446b334d544d334e7a637a4d773d3d','','56476c79645842776458493d','5647467461577767546d466b64513d3d','NULL','NULL','NULL','NULL','NULL','NULL','','','','0');

INSERT INTO test_mohan_consignee (id, created_date_time, creator, creator_name, consignee_id, name, address, city, mobile_number, landline_number, district, state, gst_number, identification, others_city, unit_id, unit_name, price_value, opening_balance, opening_balance_type, cooly_value, deleted) VALUES ('37','2025-07-21 20:18:42','56564e46556c38774d513d3d','55334a706332396d64486468636d5636','5130394f55306c48546b5646587a49784d4463794d4449314d4467784f445179587a4d33','545339544c69425a56565a42556b464f5353425552566855535578464943684c556b6c545345354249454e505445395655696b3d','56456c535656425655673d3d','56476c796458423163673d3d','4f5441304e7a417a4d7a6b354f513d3d','','56476c79645842776458493d','5647467461577767546d466b64513d3d','NULL','NULL','','NULL','NULL','NULL','','','','0');

INSERT INTO test_mohan_consignee (id, created_date_time, creator, creator_name, consignee_id, name, address, city, mobile_number, landline_number, district, state, gst_number, identification, others_city, unit_id, unit_name, price_value, opening_balance, opening_balance_type, cooly_value, deleted) VALUES ('38','2025-07-21 20:21:41','56564e46556c38774d513d3d','55334a706332396d64486468636d5636','5130394f55306c48546b5646587a49784d4463794d4449314d4467794d545178587a4d34','545339544c69424e553141674b45745353564e49546b45675130394d543156534b513d3d','56456c53565642515656493d','56476c796458423163673d3d','4e7a4d334d7a41334d544d334d413d3d','','56476c79645842776458493d','5647467461577767546d466b64513d3d','NULL','NULL','NULL','NULL','NULL','NULL','','','','0');

INSERT INTO test_mohan_consignee (id, created_date_time, creator, creator_name, consignee_id, name, address, city, mobile_number, landline_number, district, state, gst_number, identification, others_city, unit_id, unit_name, price_value, opening_balance, opening_balance_type, cooly_value, deleted) VALUES ('39','2025-07-22 17:33:39','56564e46556c38774d513d3d','55334a706332396d64486468636d5636','5130394f55306c48546b5646587a49794d4463794d4449314d44557a4d7a4d35587a4d35','545339544c6942574c6c4d67556b39425243425851566c54','56456850543152495655745652456b3d','564768766233526f6457747264575270','4f4467334d4441774f44457a4d513d3d','','5648563061574e76636d6c75','5647467461577767546d466b64513d3d','NULL','NULL','','NULL','NULL','NULL','','','','0');

INSERT INTO test_mohan_consignee (id, created_date_time, creator, creator_name, consignee_id, name, address, city, mobile_number, landline_number, district, state, gst_number, identification, others_city, unit_id, unit_name, price_value, opening_balance, opening_balance_type, cooly_value, deleted) VALUES ('40','2025-07-22 17:35:48','56564e46556c38774d513d3d','55334a706332396d64486468636d5636','5130394f55306c48546b5646587a49794d4463794d4449314d44557a4e545134587a5177','545339544c694167553141675156425151564a4654464d6754456c4e5356524652413d3d','55306c575155744255306b3d','55326c325957746863326b3d','4e7a4d7a4f544d7a4e444d344d673d3d','','566d6c796457526f645735685a324679','5647467461577767546d466b64513d3d','NULL','NULL','','NULL','NULL','NULL','','','','0');

INSERT INTO test_mohan_consignee (id, created_date_time, creator, creator_name, consignee_id, name, address, city, mobile_number, landline_number, district, state, gst_number, identification, others_city, unit_id, unit_name, price_value, opening_balance, opening_balance_type, cooly_value, deleted) VALUES ('41','2025-07-22 17:38:20','56564e46556c38774d513d3d','55334a706332396d64486468636d5636','5130394f55306c48546b5646587a49794d4463794d4449314d44557a4f444977587a5178','545339544c6942485656425551534251556b6c4f5645565355773d3d','55306c575155744255306b3d','55326c325957746863326b3d','4f4463314e4441794e7a41784f413d3d','','566d6c796457526f645735685a324679','5647467461577767546d466b64513d3d','NULL','NULL','','NULL','NULL','NULL','','','','0');

INSERT INTO test_mohan_consignee (id, created_date_time, creator, creator_name, consignee_id, name, address, city, mobile_number, landline_number, district, state, gst_number, identification, others_city, unit_id, unit_name, price_value, opening_balance, opening_balance_type, cooly_value, deleted) VALUES ('42','2025-07-22 17:39:12','56564e46556c38774d513d3d','55334a706332396d64486468636d5636','5130394f55306c48546b5646587a49794d4463794d4449314d44557a4f544579587a5179','545339544c69425751564e42546c52495153424351556454','55306c575155744255306b3d','55326c325957746863326b3d','4e6a4d344d7a4d774e6a63794e513d3d','','566d6c796457526f645735685a324679','5647467461577767546d466b64513d3d','NULL','NULL','','NULL','NULL','NULL','','','','0');

INSERT INTO test_mohan_consignee (id, created_date_time, creator, creator_name, consignee_id, name, address, city, mobile_number, landline_number, district, state, gst_number, identification, others_city, unit_id, unit_name, price_value, opening_balance, opening_balance_type, cooly_value, deleted) VALUES ('43','2025-07-22 17:40:27','56564e46556c38774d513d3d','55334a706332396d64486468636d5636','5130394f55306c48546b5646587a49794d4463794d4449314d4455304d444933587a517a','545339544c6b744a52464e445446564349464e445345395054413d3d','56456c535656425655673d3d','56476c796458423163673d3d','4f5463354d4449334e6a557a4f513d3d','','56476c79645842776458493d','5647467461577767546d466b64513d3d','NULL','NULL','NULL','NULL','NULL','NULL','','','','0');

INSERT INTO test_mohan_consignee (id, created_date_time, creator, creator_name, consignee_id, name, address, city, mobile_number, landline_number, district, state, gst_number, identification, others_city, unit_id, unit_name, price_value, opening_balance, opening_balance_type, cooly_value, deleted) VALUES ('44','2025-07-22 17:41:39','56564e46556c38774d513d3d','55334a706332396d64486468636d5636','5130394f55306c48546b5646587a49794d4463794d4449314d4455304d544d35587a5130','545339544c69425351306f6752314a425545684a51314d3d','56456c535656425655673d3d','56476c796458423163673d3d','4f5467304d7a45304d5445794d773d3d','','56476c79645842776458493d','5647467461577767546d466b64513d3d','NULL','NULL','','NULL','NULL','NULL','','','','0');

INSERT INTO test_mohan_consignee (id, created_date_time, creator, creator_name, consignee_id, name, address, city, mobile_number, landline_number, district, state, gst_number, identification, others_city, unit_id, unit_name, price_value, opening_balance, opening_balance_type, cooly_value, deleted) VALUES ('45','2025-07-22 17:42:34','56564e46556c38774d513d3d','55334a706332396d64486468636d5636','5130394f55306c48546b5646587a49794d4463794d4449314d4455304d6a4d30587a5131','545339544c69424f5355784252306c535353424351557446556c4d3d','56456c535656425655673d3d','56476c796458423163673d3d','4f546b304d4467314f4449774e513d3d','','56476c79645842776458493d','5647467461577767546d466b64513d3d','NULL','NULL','','NULL','NULL','NULL','','','','0');

INSERT INTO test_mohan_consignee (id, created_date_time, creator, creator_name, consignee_id, name, address, city, mobile_number, landline_number, district, state, gst_number, identification, others_city, unit_id, unit_name, price_value, opening_balance, opening_balance_type, cooly_value, deleted) VALUES ('46','2025-07-22 17:56:31','56564e46556c38774d513d3d','55334a706332396d64486468636d5636','5130394f55306c48546b5646587a49794d4463794d4449314d4455314e6a4d78587a5132','545339544c69425453464a4a494642425445464f53534242546b5242566b465349454a5051564a4555773d3d','56456c535656425655673d3d','56476c796458423163673d3d','4e7a4d334d7a63314d6a51334d413d3d','','56476c79645842776458493d','5647467461577767546d466b64513d3d','NULL','NULL','NULL','NULL','NULL','NULL','','','','0');

INSERT INTO test_mohan_consignee (id, created_date_time, creator, creator_name, consignee_id, name, address, city, mobile_number, landline_number, district, state, gst_number, identification, others_city, unit_id, unit_name, price_value, opening_balance, opening_balance_type, cooly_value, deleted) VALUES ('47','2025-07-22 18:02:03','56564e46556c38774d513d3d','55334a706332396d64486468636d5636','5130394f55306c48546b5646587a49794d4463794d4449314d4459774d6a417a587a5133','5453395449464254556942545355784c55773d3d','56456c535656425655673d3d','56476c796458423163673d3d','4f5445314d4441784e6a55324e413d3d','','56476c79645842776458493d','5647467461577767546d466b64513d3d','NULL','NULL','','NULL','NULL','NULL','','','','0');

INSERT INTO test_mohan_consignee (id, created_date_time, creator, creator_name, consignee_id, name, address, city, mobile_number, landline_number, district, state, gst_number, identification, others_city, unit_id, unit_name, price_value, opening_balance, opening_balance_type, cooly_value, deleted) VALUES ('48','2025-07-22 18:04:07','56564e46556c38774d513d3d','55334a706332396d64486468636d5636','5130394f55306c48546b5646587a49794d4463794d4449314d4459774e444133587a5134','545339544c69424f53564e54535342475430394555773d3d','51565a4a546b465453456b3d','56476c796458423163673d3d','4f5455354e7a4d784e7a4d774d673d3d','','56476c79645842776458493d','5647467461577767546d466b64513d3d','NULL','NULL','','NULL','NULL','NULL','','','','0');

INSERT INTO test_mohan_consignee (id, created_date_time, creator, creator_name, consignee_id, name, address, city, mobile_number, landline_number, district, state, gst_number, identification, others_city, unit_id, unit_name, price_value, opening_balance, opening_balance_type, cooly_value, deleted) VALUES ('49','2025-07-22 18:08:39','56564e46556c38774d513d3d','55334a706332396d64486468636d5636','5130394f55306c48546b5646587a49794d4463794d4449314d4459774f444d35587a5135','545339544c6942435345464851565a425469424954314e4a52564a5a55773d3d','56456c535656425655673d3d','56476c796458423163673d3d','4f5451304d6a497a4f5441774d773d3d','','56476c79645842776458493d','5647467461577767546d466b64513d3d','NULL','NULL','','NULL','NULL','NULL','','','','0');

INSERT INTO test_mohan_consignee (id, created_date_time, creator, creator_name, consignee_id, name, address, city, mobile_number, landline_number, district, state, gst_number, identification, others_city, unit_id, unit_name, price_value, opening_balance, opening_balance_type, cooly_value, deleted) VALUES ('50','2025-07-22 18:09:34','56564e46556c38774d513d3d','55334a706332396d64486468636d5636','5130394f55306c48546b5646587a49794d4463794d4449314d4459774f544d30587a5577','545339544c69424655314e45525555675330354a5646524a546b636754556c4d54464d675543424d5645513d','56456c535656425655673d3d','56476c796458423163673d3d','4f5455304d7a41784d5449324e673d3d','','56476c79645842776458493d','5647467461577767546d466b64513d3d','NULL','NULL','','NULL','NULL','NULL','','','','0');

INSERT INTO test_mohan_consignee (id, created_date_time, creator, creator_name, consignee_id, name, address, city, mobile_number, landline_number, district, state, gst_number, identification, others_city, unit_id, unit_name, price_value, opening_balance, opening_balance_type, cooly_value, deleted) VALUES ('51','2025-07-22 18:10:25','56564e46556c38774d513d3d','55334a706332396d64486468636d5636','5130394f55306c48546b5646587a49794d4463794d4449314d4459784d444931587a5578','545339544c6942444c6c4175556935555256673d','56456c535656425655673d3d','56476c796458423163673d3d','4f5467304d6a49344d4445354d673d3d','','56476c79645842776458493d','5647467461577767546d466b64513d3d','NULL','NULL','','NULL','NULL','NULL','','','','0');

INSERT INTO test_mohan_consignee (id, created_date_time, creator, creator_name, consignee_id, name, address, city, mobile_number, landline_number, district, state, gst_number, identification, others_city, unit_id, unit_name, price_value, opening_balance, opening_balance_type, cooly_value, deleted) VALUES ('52','2025-07-22 18:11:26','56564e46556c38774d513d3d','55334a706332396d64486468636d5636','5130394f55306c48546b5646587a49794d4463794d4449314d4459784d544932587a5579','545339544c69425451554a42556b6b675330354a564342555256673d','56456c53565642565569774e436c4246556c564e515535425445785655694253543046454c413d3d','56476c796458423163673d3d','4f544d324d7a41774f546b304e773d3d','','56476c79645842776458493d','5647467461577767546d466b64513d3d','NULL','NULL','','NULL','NULL','NULL','','','','0');

INSERT INTO test_mohan_consignee (id, created_date_time, creator, creator_name, consignee_id, name, address, city, mobile_number, landline_number, district, state, gst_number, identification, others_city, unit_id, unit_name, price_value, opening_balance, opening_balance_type, cooly_value, deleted) VALUES ('53','2025-07-22 18:12:42','56564e46556c38774d513d3d','55334a706332396d64486468636d5636','5130394f55306c48546b5646587a49794d4463794d4449314d4459784d6a5179587a557a','545339544c6942555345464f5355644253534255556b464552564a54','56456c535656425655673d3d','56476c796458423163673d3d','4f5455774d4455304f4441334e673d3d','','56476c79645842776458493d','5647467461577767546d466b64513d3d','NULL','NULL','','NULL','NULL','NULL','','','','0');

INSERT INTO test_mohan_consignee (id, created_date_time, creator, creator_name, consignee_id, name, address, city, mobile_number, landline_number, district, state, gst_number, identification, others_city, unit_id, unit_name, price_value, opening_balance, opening_balance_type, cooly_value, deleted) VALUES ('54','2025-07-22 18:13:52','56564e46556c38774d513d3d','55334a706332396d64486468636d5636','5130394f55306c48546b5646587a49794d4463794d4449314d4459784d7a5579587a5530','545339544c6942435446564649454a565445776754305a4755305655','56456c535656425655673d3d','56476c796458423163673d3d','4f5463314d5467304d4463774f513d3d','','56476c79645842776458493d','5647467461577767546d466b64513d3d','NULL','NULL','','NULL','NULL','NULL','','','','0');

INSERT INTO test_mohan_consignee (id, created_date_time, creator, creator_name, consignee_id, name, address, city, mobile_number, landline_number, district, state, gst_number, identification, others_city, unit_id, unit_name, price_value, opening_balance, opening_balance_type, cooly_value, deleted) VALUES ('55','2025-07-22 18:15:07','56564e46556c38774d513d3d','55334a706332396d64486468636d5636','5130394f55306c48546b5646587a49794d4463794d4449314d4459784e544133587a5531','545339544c69424c515535455345464f49454e42556b5254','56456c535656425655673d3d','56476c796458423163673d3d','4f4467334d4459774f4459774f513d3d','','56476c79645842776458493d','5647467461577767546d466b64513d3d','NULL','NULL','','NULL','NULL','NULL','','','','0');

INSERT INTO test_mohan_consignee (id, created_date_time, creator, creator_name, consignee_id, name, address, city, mobile_number, landline_number, district, state, gst_number, identification, others_city, unit_id, unit_name, price_value, opening_balance, opening_balance_type, cooly_value, deleted) VALUES ('56','2025-07-22 18:20:34','56564e46556c38774d513d3d','55334a706332396d64486468636d5636','5130394f55306c48546b5646587a49794d4463794d4449314d4459794d444d30587a5532','545339544c69425749464d675530354251307454','56456c535656425655673d3d','56476c796458423163673d3d','4f5467304d6a55344d7a55774f513d3d','','56476c79645842776458493d','5647467461577767546d466b64513d3d','NULL','NULL','','NULL','NULL','NULL','','','','0');

INSERT INTO test_mohan_consignee (id, created_date_time, creator, creator_name, consignee_id, name, address, city, mobile_number, landline_number, district, state, gst_number, identification, others_city, unit_id, unit_name, price_value, opening_balance, opening_balance_type, cooly_value, deleted) VALUES ('57','2025-07-22 18:22:10','56564e46556c38774d513d3d','55334a706332396d64486468636d5636','5130394f55306c48546b5646587a49794d4463794d4449314d4459794d6a4577587a5533','545339544c69424c556b6c545645464d4945744f53565246556c4d675543424d5645513d','56456c535656425655673d3d','56476c796458423163673d3d','4f546b304e446b354e6a59794e513d3d','','56476c79645842776458493d','5647467461577767546d466b64513d3d','NULL','NULL','','NULL','NULL','NULL','','','','0');

INSERT INTO test_mohan_consignee (id, created_date_time, creator, creator_name, consignee_id, name, address, city, mobile_number, landline_number, district, state, gst_number, identification, others_city, unit_id, unit_name, price_value, opening_balance, opening_balance_type, cooly_value, deleted) VALUES ('58','2025-07-22 18:23:05','56564e46556c38774d513d3d','55334a706332396d64486468636d5636','5130394f55306c48546b5646587a49794d4463794d4449314d4459794d7a4131587a5534','545339544c69424f5656525449435967516b464c52564d3d','56456c535656425655673d3d','56476c796458423163673d3d','4f5459774d446b774f546b354f513d3d','','56476c79645842776458493d','5647467461577767546d466b64513d3d','NULL','NULL','','NULL','NULL','NULL','','','','0');

INSERT INTO test_mohan_consignee (id, created_date_time, creator, creator_name, consignee_id, name, address, city, mobile_number, landline_number, district, state, gst_number, identification, others_city, unit_id, unit_name, price_value, opening_balance, opening_balance_type, cooly_value, deleted) VALUES ('59','2025-07-22 18:24:24','56564e46556c38774d513d3d','55334a706332396d64486468636d5636','5130394f55306c48546b5646587a49794d4463794d4449314d4459794e444930587a5535','545339544c69424f543039535655784d5153416f4f44677a4f4445354e6a63774e536b3d','56456c535656425655673d3d','56476c796458423163673d3d','4f44677a4f4445354e6a63774e513d3d','','56476c79645842776458493d','5647467461577767546d466b64513d3d','NULL','NULL','','NULL','NULL','NULL','','','','0');

INSERT INTO test_mohan_consignee (id, created_date_time, creator, creator_name, consignee_id, name, address, city, mobile_number, landline_number, district, state, gst_number, identification, others_city, unit_id, unit_name, price_value, opening_balance, opening_balance_type, cooly_value, deleted) VALUES ('60','2025-07-22 18:25:43','56564e46556c38774d513d3d','55334a706332396d64486468636d5636','5130394f55306c48546b5646587a49794d4463794d4449314d4459794e54517a587a5977','545339544c694251525546445343424d51554a4654464d3d','56456c535656425655673d3d','56476c796458423163673d3d','4f5467354e4441784e7a55774d513d3d','','56476c79645842776458493d','5647467461577767546d466b64513d3d','NULL','NULL','','NULL','NULL','NULL','','','','0');

INSERT INTO test_mohan_consignee (id, created_date_time, creator, creator_name, consignee_id, name, address, city, mobile_number, landline_number, district, state, gst_number, identification, others_city, unit_id, unit_name, price_value, opening_balance, opening_balance_type, cooly_value, deleted) VALUES ('61','2025-07-22 18:27:10','56564e46556c38774d513d3d','55334a706332396d64486468636d5636','5130394f55306c48546b5646587a49794d4463794d4449314d4459794e7a4577587a5978','545339544c6942545755785049456442556b3146546c5254','56456c535656425655673d3d','56476c796458423163673d3d','4f4441334d6a4d334d4449334d413d3d','','56476c79645842776458493d','5647467461577767546d466b64513d3d','NULL','NULL','','NULL','NULL','NULL','','','','0');

INSERT INTO test_mohan_consignee (id, created_date_time, creator, creator_name, consignee_id, name, address, city, mobile_number, landline_number, district, state, gst_number, identification, others_city, unit_id, unit_name, price_value, opening_balance, opening_balance_type, cooly_value, deleted) VALUES ('62','2025-07-22 18:36:30','56564e46556c38774d513d3d','55334a706332396d64486468636d5636','5130394f55306c48546b5646587a49794d4463794d4449314d44597a4e6a4d77587a5979','545339544c69424552565a4a49454e42533055675530685055413d3d','56456c535656425655673d3d','56476c796458423163673d3d','4e7a41354d6a49794d7a67774f413d3d','','56476c79645842776458493d','5647467461577767546d466b64513d3d','NULL','NULL','NULL','NULL','NULL','NULL','','','','0');

INSERT INTO test_mohan_consignee (id, created_date_time, creator, creator_name, consignee_id, name, address, city, mobile_number, landline_number, district, state, gst_number, identification, others_city, unit_id, unit_name, price_value, opening_balance, opening_balance_type, cooly_value, deleted) VALUES ('63','2025-07-22 18:39:33','56564e46556c38774d513d3d','55334a706332396d64486468636d5636','5130394f55306c48546b5646587a49794d4463794d4449314d44597a4f544d7a587a597a','545339544c69425553314967526b465453456c5054673d3d','56456c535656425655673d3d','56476c796458423163673d3d','4f444d304e444d794d544d794d513d3d','','56476c79645842776458493d','5647467461577767546d466b64513d3d','NULL','NULL','','NULL','NULL','NULL','','','','0');

INSERT INTO test_mohan_consignee (id, created_date_time, creator, creator_name, consignee_id, name, address, city, mobile_number, landline_number, district, state, gst_number, identification, others_city, unit_id, unit_name, price_value, opening_balance, opening_balance_type, cooly_value, deleted) VALUES ('64','2025-07-22 18:45:52','56564e46556c38774d513d3d','55334a706332396d64486468636d5636','5130394f55306c48546b5646587a49794d4463794d4449314d4459304e545579587a5930','545339544c694254546b46514945525351556450546967354f5459314e6a59794d4441304b513d3d','56456c535656425655673d3d','56476c796458423163673d3d','4f546b324e5459324d6a41774e413d3d','','56476c79645842776458493d','5647467461577767546d466b64513d3d','NULL','NULL','','NULL','NULL','NULL','','','','0');

INSERT INTO test_mohan_consignee (id, created_date_time, creator, creator_name, consignee_id, name, address, city, mobile_number, landline_number, district, state, gst_number, identification, others_city, unit_id, unit_name, price_value, opening_balance, opening_balance_type, cooly_value, deleted) VALUES ('65','2025-07-22 18:47:46','56564e46556c38774d513d3d','55334a706332396d64486468636d5636','5130394f55306c48546b5646587a49794d4463794d4449314d4459304e7a5132587a5931','545339544c6942574c6b73755256684a5453416f4f546b324e5451334d6a41774e436b3d','56456c535656425655673d3d','56476c796458423163673d3d','4f546b324e5451334d6a41774e413d3d','','56476c79645842776458493d','5647467461577767546d466b64513d3d','NULL','NULL','','NULL','NULL','NULL','','','','0');

INSERT INTO test_mohan_consignee (id, created_date_time, creator, creator_name, consignee_id, name, address, city, mobile_number, landline_number, district, state, gst_number, identification, others_city, unit_id, unit_name, price_value, opening_balance, opening_balance_type, cooly_value, deleted) VALUES ('66','2025-07-22 19:01:03','56564e46556c38774d513d3d','55334a706332396d64486468636d5636','5130394f55306c48546b5646587a49794d4463794d4449314d4463774d54417a587a5932','545339544c694254564342535256524253557767535535455355456755465a55494578555243416f52314170','56456c53565642565569774e436b7450546b64564945314253553467556b394252413d3d','56476c796458423163673d3d','4f5455774d446b794d7a41784f513d3d','','56476c79645842776458493d','5647467461577767546d466b64513d3d','NULL','NULL','','NULL','NULL','NULL','','','','0');

INSERT INTO test_mohan_consignee (id, created_date_time, creator, creator_name, consignee_id, name, address, city, mobile_number, landline_number, district, state, gst_number, identification, others_city, unit_id, unit_name, price_value, opening_balance, opening_balance_type, cooly_value, deleted) VALUES ('67','2025-07-22 19:02:13','56564e46556c38774d513d3d','55334a706332396d64486468636d5636','5130394f55306c48546b5646587a49794d4463794d4449314d4463774d6a457a587a5933','545339544c69425851564a53535539534945685055306c46556b6c4655773d3d','56456c535656425655673d3d','56476c796458423163673d3d','4f544d324d7a41314e4441334e413d3d','','56476c79645842776458493d','5647467461577767546d466b64513d3d','NULL','NULL','','NULL','NULL','NULL','','','','0');

INSERT INTO test_mohan_consignee (id, created_date_time, creator, creator_name, consignee_id, name, address, city, mobile_number, landline_number, district, state, gst_number, identification, others_city, unit_id, unit_name, price_value, opening_balance, opening_balance_type, cooly_value, deleted) VALUES ('68','2025-07-23 13:07:58','56564e46556c38774d513d3d','55334a706332396d64486468636d5636','5130394f55306c48546b5646587a497a4d4463794d4449314d4445774e7a5534587a5934','545339544c6942545255785751564d67523046535455564f56464d3d','56456c535656425655673d3d','56476c796458423163673d3d','4f444d774d4441324d4441344f413d3d','','56476c79645842776458493d','5647467461577767546d466b64513d3d','NULL','NULL','','NULL','NULL','NULL','','','','0');

INSERT INTO test_mohan_consignee (id, created_date_time, creator, creator_name, consignee_id, name, address, city, mobile_number, landline_number, district, state, gst_number, identification, others_city, unit_id, unit_name, price_value, opening_balance, opening_balance_type, cooly_value, deleted) VALUES ('69','2025-07-23 13:09:42','56564e46556c38774d513d3d','55334a706332396d64486468636d5636','5130394f55306c48546b5646587a497a4d4463794d4449314d4445774f545179587a5935','545339544c694245534546535530684a546b6b67523046535455564f56464d6f53314a514b513d3d','56456c535656425655673d3d','56476c796458423163673d3d','4e7a4d334d7a45774d6a6b304f413d3d','','56476c79645842776458493d','5647467461577767546d466b64513d3d','NULL','NULL','','NULL','NULL','NULL','','','','0');

INSERT INTO test_mohan_consignee (id, created_date_time, creator, creator_name, consignee_id, name, address, city, mobile_number, landline_number, district, state, gst_number, identification, others_city, unit_id, unit_name, price_value, opening_balance, opening_balance_type, cooly_value, deleted) VALUES ('70','2025-07-23 13:12:40','56564e46556c38774d513d3d','55334a706332396d64486468636d5636','5130394f55306c48546b5646587a497a4d4463794d4449314d4445784d6a5177587a6377','545339544c69424655316442556942445445395553456c4f52794244543031515155355a4b4564514b513d3d','56456c535656425655673d3d','56476c796458423163673d3d','4f5467324e546b354f5455794e673d3d','','56476c79645842776458493d','5647467461577767546d466b64513d3d','NULL','NULL','','NULL','NULL','NULL','','','','0');

INSERT INTO test_mohan_consignee (id, created_date_time, creator, creator_name, consignee_id, name, address, city, mobile_number, landline_number, district, state, gst_number, identification, others_city, unit_id, unit_name, price_value, opening_balance, opening_balance_type, cooly_value, deleted) VALUES ('71','2025-07-23 13:15:32','56564e46556c38774d513d3d','55334a706332396d64486468636d5636','5130394f55306c48546b5646587a497a4d4463794d4449314d4445784e544d79587a6378','545339544c694242556b705654694251556b6c4f5645565355773d3d','56456c535656425655673d3d','56476c796458423163673d3d','4f5467304d7a45304d4451304e413d3d','','56476c79645842776458493d','5647467461577767546d466b64513d3d','NULL','NULL','','NULL','NULL','NULL','','','','0');

INSERT INTO test_mohan_consignee (id, created_date_time, creator, creator_name, consignee_id, name, address, city, mobile_number, landline_number, district, state, gst_number, identification, others_city, unit_id, unit_name, price_value, opening_balance, opening_balance_type, cooly_value, deleted) VALUES ('72','2025-07-23 13:16:41','56564e46556c38774d513d3d','55334a706332396d64486468636d5636','5130394f55306c48546b5646587a497a4d4463794d4449314d4445784e6a5178587a6379','545339544c69425452565a4654694246544556575255346752307850516b464d49456c4f51773d3d','5645684a556c56515656493d','56476c796458423163673d3d','4f5455774d444d334e6a59324e673d3d','','56476c79645842776458493d','5647467461577767546d466b64513d3d','NULL','NULL','','NULL','NULL','NULL','','','','0');

INSERT INTO test_mohan_consignee (id, created_date_time, creator, creator_name, consignee_id, name, address, city, mobile_number, landline_number, district, state, gst_number, identification, others_city, unit_id, unit_name, price_value, opening_balance, opening_balance_type, cooly_value, deleted) VALUES ('73','2025-07-23 13:17:47','56564e46556c38774d513d3d','55334a706332396d64486468636d5636','5130394f55306c48546b5646587a497a4d4463794d4449314d4445784e7a5133587a637a','545339544c69424b5379424351556454','56456c535656425655673d3d','56476c796458423163673d3d','4f5451344f4445314d4451354e513d3d','','56476c79645842776458493d','5647467461577767546d466b64513d3d','NULL','NULL','','NULL','NULL','NULL','','','','0');

INSERT INTO test_mohan_consignee (id, created_date_time, creator, creator_name, consignee_id, name, address, city, mobile_number, landline_number, district, state, gst_number, identification, others_city, unit_id, unit_name, price_value, opening_balance, opening_balance_type, cooly_value, deleted) VALUES ('74','2025-07-23 13:20:04','56564e46556c38774d513d3d','55334a706332396d64486468636d5636','5130394f55306c48546b5646587a497a4d4463794d4449314d4445794d444130587a6330','545339544c694254534556535153424954314e4a52564a5a494368514b53424d564551674b464e4653565170','56456c535656425655673d3d','56476c796458423163673d3d','4d4451794d5449794e444d304e773d3d','','56476c79645842776458493d','5647467461577767546d466b64513d3d','NULL','4d4451794d5330794d6a517a4e446379','','NULL','NULL','NULL','','','','0');

INSERT INTO test_mohan_consignee (id, created_date_time, creator, creator_name, consignee_id, name, address, city, mobile_number, landline_number, district, state, gst_number, identification, others_city, unit_id, unit_name, price_value, opening_balance, opening_balance_type, cooly_value, deleted) VALUES ('75','2025-07-23 13:22:32','56564e46556c38774d513d3d','55334a706332396d64486468636d5636','5130394f55306c48546b5646587a497a4d4463794d4449314d4445794d6a4d79587a6331','545339544c694242575656545343425552566855535578465579416f5530564a56436c52','56456c535656425655673d3d','56476c796458423163673d3d','4e6a49774d54497a4d7a49304e413d3d','','56476c79645842776458493d','5647467461577767546d466b64513d3d','NULL','NULL','','NULL','NULL','NULL','','','','0');

INSERT INTO test_mohan_consignee (id, created_date_time, creator, creator_name, consignee_id, name, address, city, mobile_number, landline_number, district, state, gst_number, identification, others_city, unit_id, unit_name, price_value, opening_balance, opening_balance_type, cooly_value, deleted) VALUES ('76','2025-07-23 13:23:57','56564e46556c38774d513d3d','55334a706332396d64486468636d5636','5130394f55306c48546b5646587a497a4d4463794d4449314d4445794d7a5533587a6332','545339544c6942435446564649454a56544577674b43425452556c554b513d3d','56456c535656425655673d3d','56476c796458423163673d3d','4f5463344f5451344d4445344e513d3d','','56476c79645842776458493d','5647467461577767546d466b64513d3d','NULL','NULL','NULL','NULL','NULL','NULL','','','','0');

INSERT INTO test_mohan_consignee (id, created_date_time, creator, creator_name, consignee_id, name, address, city, mobile_number, landline_number, district, state, gst_number, identification, others_city, unit_id, unit_name, price_value, opening_balance, opening_balance_type, cooly_value, deleted) VALUES ('77','2025-07-23 13:25:04','56564e46556c38774d513d3d','55334a706332396d64486468636d5636','5130394f55306c48546b5646587a497a4d4463794d4449314d4445794e544130587a6333','545339544c69424c52557053535664425443425552566855535578465579424e5355784d5579685452556c554b513d3d','56456c535656425655673d3d','56476c796458423163673d3d','4f5451304d7a4d314e7a4d794e673d3d','','56476c79645842776458493d','5647467461577767546d466b64513d3d','NULL','NULL','NULL','NULL','NULL','NULL','','','','0');

INSERT INTO test_mohan_consignee (id, created_date_time, creator, creator_name, consignee_id, name, address, city, mobile_number, landline_number, district, state, gst_number, identification, others_city, unit_id, unit_name, price_value, opening_balance, opening_balance_type, cooly_value, deleted) VALUES ('78','2025-07-23 13:26:16','56564e46556c38774d513d3d','55334a706332396d64486468636d5636','5130394f55306c48546b5646587a497a4d4463794d4449314d4445794e6a4532587a6334','545339544c69425451564a42566b464f51534248556b465153456c4455773d3d','56456c535656425655673d3d','56476c796458423163673d3d','4f4441314e6a51774d7a4d354e773d3d','','56476c79645842776458493d','5647467461577767546d466b64513d3d','NULL','NULL','','NULL','NULL','NULL','','','','0');

INSERT INTO test_mohan_consignee (id, created_date_time, creator, creator_name, consignee_id, name, address, city, mobile_number, landline_number, district, state, gst_number, identification, others_city, unit_id, unit_name, price_value, opening_balance, opening_balance_type, cooly_value, deleted) VALUES ('79','2025-07-23 13:27:53','56564e46556c38774d513d3d','55334a706332396d64486468636d5636','5130394f55306c48546b5646587a497a4d4463794d4449314d4445794e7a557a587a6335','545649754945465a5755464f5156493d','56456c535656425655673d3d','56476c796458423163673d3d','4f5445314f5459314e54637a4e513d3d','','56476c79645842776458493d','5647467461577767546d466b64513d3d','NULL','NULL','','NULL','NULL','NULL','','','','0');

INSERT INTO test_mohan_consignee (id, created_date_time, creator, creator_name, consignee_id, name, address, city, mobile_number, landline_number, district, state, gst_number, identification, others_city, unit_id, unit_name, price_value, opening_balance, opening_balance_type, cooly_value, deleted) VALUES ('80','2025-07-23 13:30:44','56564e46556c38774d513d3d','55334a706332396d64486468636d5636','5130394f55306c48546b5646587a497a4d4463794d4449314d44457a4d445130587a6777','545339544c694254556b6b67556b464e','56456c535656425655673d3d','56476c796458423163673d3d','4f546b354e444d354f4451314f513d3d','','56476c79645842776458493d','5647467461577767546d466b64513d3d','NULL','NULL','','NULL','NULL','NULL','','','','0');

INSERT INTO test_mohan_consignee (id, created_date_time, creator, creator_name, consignee_id, name, address, city, mobile_number, landline_number, district, state, gst_number, identification, others_city, unit_id, unit_name, price_value, opening_balance, opening_balance_type, cooly_value, deleted) VALUES ('81','2025-07-23 13:32:29','56564e46556c38774d513d3d','55334a706332396d64486468636d5636','5130394f55306c48546b5646587a497a4d4463794d4449314d44457a4d6a4935587a6778','545339544c694242536b6c5553434255556b464552564a54','56456c535656425655673d3d','56476c796458423163673d3d','4f5451344e6a51304d444d344f413d3d','','56476c79645842776458493d','5647467461577767546d466b64513d3d','NULL','NULL','NULL','NULL','NULL','NULL','','','','0');

INSERT INTO test_mohan_consignee (id, created_date_time, creator, creator_name, consignee_id, name, address, city, mobile_number, landline_number, district, state, gst_number, identification, others_city, unit_id, unit_name, price_value, opening_balance, opening_balance_type, cooly_value, deleted) VALUES ('82','2025-07-23 13:34:05','56564e46556c38774d513d3d','55334a706332396d64486468636d5636','5130394f55306c48546b5646587a497a4d4463794d4449314d44457a4e444131587a6779','545339544c6942424c6c5975556942575355784255314d3d','56456c535656425655673d3d','56476c796458423163673d3d','4f5463354d4449344d4445324e513d3d','','56476c79645842776458493d','5647467461577767546d466b64513d3d','NULL','NULL','','NULL','NULL','NULL','','','','0');

INSERT INTO test_mohan_consignee (id, created_date_time, creator, creator_name, consignee_id, name, address, city, mobile_number, landline_number, district, state, gst_number, identification, others_city, unit_id, unit_name, price_value, opening_balance, opening_balance_type, cooly_value, deleted) VALUES ('83','2025-07-23 18:40:58','56564e46556c38774d513d3d','55334a706332396d64486468636d5636','5130394f55306c48546b5646587a497a4d4463794d4449314d4459304d445534587a677a','51566c42546942545630564656464d675155354549454e4253305654','56456c535656425655673d3d','56476c796458423163673d3d','4f5463354d5459344d54417a4d513d3d','','56476c79645842776458493d','5647467461577767546d466b64513d3d','NULL','NULL','','NULL','NULL','NULL','','','','0');

INSERT INTO test_mohan_consignee (id, created_date_time, creator, creator_name, consignee_id, name, address, city, mobile_number, landline_number, district, state, gst_number, identification, others_city, unit_id, unit_name, price_value, opening_balance, opening_balance_type, cooly_value, deleted) VALUES ('84','2025-07-23 18:42:01','56564e46556c38774d513d3d','55334a706332396d64486468636d5636','5130394f55306c48546b5646587a497a4d4463794d4449314d4459304d6a4178587a6730','545339544c69424c5155354f515534675130465352464d3d','56456c535656425655673d3d','56476c796458423163673d3d','4f5451304d7a4d334d6a45324d773d3d','','56476c79645842776458493d','5647467461577767546d466b64513d3d','NULL','NULL','','NULL','NULL','NULL','','','','0');

INSERT INTO test_mohan_consignee (id, created_date_time, creator, creator_name, consignee_id, name, address, city, mobile_number, landline_number, district, state, gst_number, identification, others_city, unit_id, unit_name, price_value, opening_balance, opening_balance_type, cooly_value, deleted) VALUES ('85','2025-07-23 18:45:31','56564e46556c38774d513d3d','55334a706332396d64486468636d5636','5130394f55306c48546b5646587a497a4d4463794d4449314d4459304e544d78587a6731','545339544c6942585355346755454651525649675455465356413d3d','56456c535656425655673d3d','56476c796458423163673d3d','4f5467304d6a49324d6a59794d673d3d','','56476c79645842776458493d','5647467461577767546d466b64513d3d','NULL','NULL','','NULL','NULL','NULL','','','','0');

INSERT INTO test_mohan_consignee (id, created_date_time, creator, creator_name, consignee_id, name, address, city, mobile_number, landline_number, district, state, gst_number, identification, others_city, unit_id, unit_name, price_value, opening_balance, opening_balance_type, cooly_value, deleted) VALUES ('86','2025-07-23 18:46:40','56564e46556c38774d513d3d','55334a706332396d64486468636d5636','5130394f55306c48546b5646587a497a4d4463794d4449314d4459304e6a5177587a6732','545339544c69425456554a46525649674b4642425445464f53565a4654436b3d','56456c5356564256556977675669425449454567546b464851564967526b6c535531516755315253525556554c46525356554e495753425354304645','56476c796458423163673d3d','4f446b794d5449324e7a55784d413d3d','','56476c79645842776458493d','5647467461577767546d466b64513d3d','NULL','NULL','','NULL','NULL','NULL','','','','0');

INSERT INTO test_mohan_consignee (id, created_date_time, creator, creator_name, consignee_id, name, address, city, mobile_number, landline_number, district, state, gst_number, identification, others_city, unit_id, unit_name, price_value, opening_balance, opening_balance_type, cooly_value, deleted) VALUES ('87','2025-07-23 18:49:56','56564e46556c38774d513d3d','55334a706332396d64486468636d5636','5130394f55306c48546b5646587a497a4d4463794d4449314d4459304f545532587a6733','545339544c694254556b6b67556b464e494642425130744252306c4f52773d3d','56456c535656425655673d3d','56476c796458423163673d3d','4f4463314e446b7a4d5441774d513d3d','','56476c79645842776458493d','5647467461577767546d466b64513d3d','NULL','NULL','','NULL','NULL','NULL','','','','0');

INSERT INTO test_mohan_consignee (id, created_date_time, creator, creator_name, consignee_id, name, address, city, mobile_number, landline_number, district, state, gst_number, identification, others_city, unit_id, unit_name, price_value, opening_balance, opening_balance_type, cooly_value, deleted) VALUES ('88','2025-07-23 18:52:54','56564e46556c38774d513d3d','55334a706332396d64486468636d5636','5130394f55306c48546b5646587a497a4d4463794d4449314d4459314d6a5530587a6734','545339544c6942535155315351556f675345464f52457850543031544943684855436b3d','56456c535656425655673d3d','56476c796458423163673d3d','4f5455344e546b784d5445304e773d3d','','56476c79645842776458493d','5647467461577767546d466b64513d3d','NULL','NULL','','NULL','NULL','NULL','','','','0');

INSERT INTO test_mohan_consignee (id, created_date_time, creator, creator_name, consignee_id, name, address, city, mobile_number, landline_number, district, state, gst_number, identification, others_city, unit_id, unit_name, price_value, opening_balance, opening_balance_type, cooly_value, deleted) VALUES ('89','2025-07-23 18:55:32','56564e46556c38774d513d3d','55334a706332396d64486468636d5636','5130394f55306c48546b5646587a497a4d4463794d4449314d4459314e544d79587a6735','545339544c69424a546b6c5a515342575255776755464a4a546c5246556c4d3d','56456c535656425655673d3d','56476c796458423163673d3d','4f546b304d446b304f5451324f413d3d','','56476c79645842776458493d','5647467461577767546d466b64513d3d','NULL','NULL','','NULL','NULL','NULL','','','','0');

INSERT INTO test_mohan_consignee (id, created_date_time, creator, creator_name, consignee_id, name, address, city, mobile_number, landline_number, district, state, gst_number, identification, others_city, unit_id, unit_name, price_value, opening_balance, opening_balance_type, cooly_value, deleted) VALUES ('90','2025-07-23 18:57:53','56564e46556c38774d513d3d','55334a706332396d64486468636d5636','5130394f55306c48546b5646587a497a4d4463794d4449314d4459314e7a5530587a6b77','545649754945744254456c4551564e54','56456c535656425655673d3d','56476c796458423163673d3d','4e7a55354f4445314e446b794d773d3d','','56476c79645842776458493d','5647467461577767546d466b64513d3d','NULL','NULL','','NULL','NULL','NULL','','','','0');

INSERT INTO test_mohan_consignee (id, created_date_time, creator, creator_name, consignee_id, name, address, city, mobile_number, landline_number, district, state, gst_number, identification, others_city, unit_id, unit_name, price_value, opening_balance, opening_balance_type, cooly_value, deleted) VALUES ('91','2025-07-23 18:59:59','56564e46556c38774d513d3d','55334a706332396d64486468636d5636','5130394f55306c48546b5646587a497a4d4463794d4449314d4459314f545535587a6b78','545339544c69424c5355354849464e42556b3867535531515256673d','53303957535578515156525553513d3d','53323932615778775958523061513d3d','4f5451344f4441334e7a4d354d773d3d','','5648563061574e76636d6c75','5647467461577767546d466b64513d3d','NULL','NULL','','NULL','NULL','NULL','','','','0');

INSERT INTO test_mohan_consignee (id, created_date_time, creator, creator_name, consignee_id, name, address, city, mobile_number, landline_number, district, state, gst_number, identification, others_city, unit_id, unit_name, price_value, opening_balance, opening_balance_type, cooly_value, deleted) VALUES ('92','2025-07-23 19:01:47','56564e46556c38774d513d3d','55334a706332396d64486468636d5636','5130394f55306c48546b5646587a497a4d4463794d4449314d4463774d545133587a6b79','545339544c69424655316442556b6b6755456c44564656535253424e51564a55','55306c575155744255306b3d','55326c325957746863326b3d','4d4451314e6a49794d7a417a4e673d3d','','566d6c796457526f645735685a324679','5647467461577767546d466b64513d3d','NULL','4d4451314e6a49794d7a417a4e6a6b3d','','NULL','NULL','NULL','','','','0');

INSERT INTO test_mohan_consignee (id, created_date_time, creator, creator_name, consignee_id, name, address, city, mobile_number, landline_number, district, state, gst_number, identification, others_city, unit_id, unit_name, price_value, opening_balance, opening_balance_type, cooly_value, deleted) VALUES ('93','2025-07-23 19:12:53','56564e46556c38774d513d3d','55334a706332396d64486468636d5636','5130394f55306c48546b5646587a497a4d4463794d4449314d4463784d6a557a587a6b7a','545339544c694257525652535353425753553542575546485153424d54314a5357513d3d','56456850543152495655745652456b3d','564768766233526f6457747264575270','4f4467344d7a55324d6a51304e413d3d','','5648563061574e76636d6c75','5647467461577767546d466b64513d3d','NULL','NULL','','NULL','NULL','NULL','','','','0');

INSERT INTO test_mohan_consignee (id, created_date_time, creator, creator_name, consignee_id, name, address, city, mobile_number, landline_number, district, state, gst_number, identification, others_city, unit_id, unit_name, price_value, opening_balance, opening_balance_type, cooly_value, deleted) VALUES ('94','2025-07-23 19:14:20','56564e46556c38774d513d3d','55334a706332396d64486468636d5636','5130394f55306c48546b5646587a497a4d4463794d4449314d4463784e444977587a6b30','545339544c69425453565a4249465246574341354e6a55314e7a67354e54496749413d3d','56456c535656425655673d3d','56476c796458423163673d3d','4f5459314e5463344f5455324d673d3d','','56476c79645842776458493d','5647467461577767546d466b64513d3d','NULL','NULL','','NULL','NULL','NULL','','','','0');

INSERT INTO test_mohan_consignee (id, created_date_time, creator, creator_name, consignee_id, name, address, city, mobile_number, landline_number, district, state, gst_number, identification, others_city, unit_id, unit_name, price_value, opening_balance, opening_balance_type, cooly_value, deleted) VALUES ('95','2025-07-23 19:15:52','56564e46556c38774d513d3d','55334a706332396d64486468636d5636','5130394f55306c48546b5646587a497a4d4463794d4449314d4463784e545579587a6b31','545339544c6942574d6c425054466b675355354556564e55556b6c4655773d3d','56456c535656425655673d3d','56476c796458423163673d3d','4f5441774d7a6b314e6a45314e513d3d','','56476c79645842776458493d','5647467461577767546d466b64513d3d','NULL','NULL','','NULL','NULL','NULL','','','','0');

INSERT INTO test_mohan_consignee (id, created_date_time, creator, creator_name, consignee_id, name, address, city, mobile_number, landline_number, district, state, gst_number, identification, others_city, unit_id, unit_name, price_value, opening_balance, opening_balance_type, cooly_value, deleted) VALUES ('96','2025-07-23 19:16:43','56564e46556c38774d513d3d','55334a706332396d64486468636d5636','5130394f55306c48546b5646587a497a4d4463794d4449314d4463784e6a517a587a6b32','545339544c6942545546513d','56456c535656425655673d3d','56476c796458423163673d3d','4f5451304d6a41354e44497a4f513d3d','','56476c79645842776458493d','5647467461577767546d466b64513d3d','NULL','NULL','','NULL','NULL','NULL','','','','0');

INSERT INTO test_mohan_consignee (id, created_date_time, creator, creator_name, consignee_id, name, address, city, mobile_number, landline_number, district, state, gst_number, identification, others_city, unit_id, unit_name, price_value, opening_balance, opening_balance_type, cooly_value, deleted) VALUES ('97','2025-07-23 19:17:43','56564e46556c38774d513d3d','55334a706332396d64486468636d5636','5130394f55306c48546b5646587a497a4d4463794d4449314d4463784e7a517a587a6b33','545339544c6942435345465757554567523046535455564f56464d674b464e4653565170','56456c535656425655673d3d','56476c796458423163673d3d','4f5455334f444d354d7a6b304e413d3d','','56476c79645842776458493d','5647467461577767546d466b64513d3d','NULL','NULL','','NULL','NULL','NULL','','','','0');

INSERT INTO test_mohan_consignee (id, created_date_time, creator, creator_name, consignee_id, name, address, city, mobile_number, landline_number, district, state, gst_number, identification, others_city, unit_id, unit_name, price_value, opening_balance, opening_balance_type, cooly_value, deleted) VALUES ('98','2025-07-23 19:23:46','56564e46556c38774d513d3d','55334a706332396d64486468636d5636','5130394f55306c48546b5646587a497a4d4463794d4449314d4463794d7a5132587a6b34','545339544c694243534546575155354249456442556b3146546c52544943685452556c554b513d3d','56456c535656425655673d3d','56476c796458423163673d3d','4e7a63774f4449354d6a45304e413d3d','','56476c79645842776458493d','5647467461577767546d466b64513d3d','NULL','NULL','','NULL','NULL','NULL','','','','0');

INSERT INTO test_mohan_consignee (id, created_date_time, creator, creator_name, consignee_id, name, address, city, mobile_number, landline_number, district, state, gst_number, identification, others_city, unit_id, unit_name, price_value, opening_balance, opening_balance_type, cooly_value, deleted) VALUES ('99','2025-07-23 19:25:43','56564e46556c38774d513d3d','55334a706332396d64486468636d5636','5130394f55306c48546b5646587a497a4d4463794d4449314d4463794e54517a587a6b35','545339544c694254556b6b675230464f51554a425645684a49464e4f51554e4c55773d3d','56456c535656425655673d3d','56476c796458423163673d3d','4f5441344d444d354d7a6b304d513d3d','','56476c79645842776458493d','5647467461577767546d466b64513d3d','NULL','NULL','','NULL','NULL','NULL','','','','0');

INSERT INTO test_mohan_consignee (id, created_date_time, creator, creator_name, consignee_id, name, address, city, mobile_number, landline_number, district, state, gst_number, identification, others_city, unit_id, unit_name, price_value, opening_balance, opening_balance_type, cooly_value, deleted) VALUES ('100','2025-07-23 19:32:53','56564e46556c38774d513d3d','55334a706332396d64486468636d5636','5130394f55306c48546b5646587a497a4d4463794d4449314d44637a4d6a557a587a45774d413d3d','5456497549464a42566b6b6f494546575355354255306b70','51565a4a546b465453513d3d','56476c796458423163673d3d','4e7a67324f446b354e5455774d413d3d','','56476c79645842776458493d','5647467461577767546d466b64513d3d','NULL','NULL','','NULL','NULL','NULL','','','','0');

INSERT INTO test_mohan_consignee (id, created_date_time, creator, creator_name, consignee_id, name, address, city, mobile_number, landline_number, district, state, gst_number, identification, others_city, unit_id, unit_name, price_value, opening_balance, opening_balance_type, cooly_value, deleted) VALUES ('101','2025-07-23 19:36:14','56564e46556c38774d513d3d','55334a706332396d64486468636d5636','5130394f55306c48546b5646587a497a4d4463794d4449314d44637a4e6a4530587a45774d513d3d','545339544c69425453565a4255464a42533046545343416f5545464d5155354a566b564d4b513d3d','56456c535656425655673d3d','56476c796458423163673d3d','4f5451344f44417a4f54677a4f513d3d','','56476c79645842776458493d','5647467461577767546d466b64513d3d','NULL','NULL','','NULL','NULL','NULL','','','','0');

INSERT INTO test_mohan_consignee (id, created_date_time, creator, creator_name, consignee_id, name, address, city, mobile_number, landline_number, district, state, gst_number, identification, others_city, unit_id, unit_name, price_value, opening_balance, opening_balance_type, cooly_value, deleted) VALUES ('102','2025-07-23 19:37:16','56564e46556c38774d513d3d','55334a706332396d64486468636d5636','5130394f55306c48546b5646587a497a4d4463794d4449314d44637a4e7a4532587a45774d673d3d','545339544c69424e55464d6756455659','56456c535656425655673d3d','56476c796458423163673d3d','4e7a557a4f546b354d4449354f413d3d','','56476c79645842776458493d','5647467461577767546d466b64513d3d','NULL','NULL','','NULL','NULL','NULL','','','','0');

INSERT INTO test_mohan_consignee (id, created_date_time, creator, creator_name, consignee_id, name, address, city, mobile_number, landline_number, district, state, gst_number, identification, others_city, unit_id, unit_name, price_value, opening_balance, opening_balance_type, cooly_value, deleted) VALUES ('103','2025-07-23 19:38:12','56564e46556c38774d513d3d','55334a706332396d64486468636d5636','5130394f55306c48546b5646587a497a4d4463794d4449314d44637a4f444579587a45774d773d3d','545339544c69424751564e495355394f49454e5352554655525551674b4642425445464f53565a4654436b3d','56456c535656425655673d3d','56476c796458423163673d3d','4f5445314f5441304d7a45344e673d3d','','56476c79645842776458493d','5647467461577767546d466b64513d3d','NULL','NULL','','NULL','NULL','NULL','','','','0');

INSERT INTO test_mohan_consignee (id, created_date_time, creator, creator_name, consignee_id, name, address, city, mobile_number, landline_number, district, state, gst_number, identification, others_city, unit_id, unit_name, price_value, opening_balance, opening_balance_type, cooly_value, deleted) VALUES ('104','2025-07-23 19:42:42','56564e46556c38774d513d3d','55334a706332396d64486468636d5636','5130394f55306c48546b5646587a497a4d4463794d4449314d4463304d6a5179587a45774e413d3d','545339544c69424e4c314d675155315351565a425645684a4946424255455653','565552565455464d51556c515256513d','56476c796458423163673d3d','4f546b304d6a49784e446b304e413d3d','','56476c79645842776458493d','5647467461577767546d466b64513d3d','NULL','NULL','','NULL','NULL','NULL','','','','0');

INSERT INTO test_mohan_consignee (id, created_date_time, creator, creator_name, consignee_id, name, address, city, mobile_number, landline_number, district, state, gst_number, identification, others_city, unit_id, unit_name, price_value, opening_balance, opening_balance_type, cooly_value, deleted) VALUES ('105','2025-07-23 19:43:37','56564e46556c38774d513d3d','55334a706332396d64486468636d5636','5130394f55306c48546b5646587a497a4d4463794d4449314d4463304d7a4d34587a45774e513d3d','5456497549453168626d6b3d','56476c796458423163673d3d','56476c796458423163673d3d','4f544d304d6a63794d6a63314d413d3d','','56476c79645842776458493d','5647467461577767546d466b64513d3d','NULL','NULL','','NULL','NULL','NULL','','','','0');

INSERT INTO test_mohan_consignee (id, created_date_time, creator, creator_name, consignee_id, name, address, city, mobile_number, landline_number, district, state, gst_number, identification, others_city, unit_id, unit_name, price_value, opening_balance, opening_balance_type, cooly_value, deleted) VALUES ('106','2025-07-23 19:44:27','56564e46556c38774d513d3d','55334a706332396d64486468636d5636','5130394f55306c48546b5646587a497a4d4463794d4449314d4463304e444933587a45774e673d3d','545339544c69424c5543425151554e4c5155644a546b6454','56456c535656425655673d3d','56476c796458423163673d3d','4f4445794e4451304e7a59354f513d3d','','56476c79645842776458493d','5647467461577767546d466b64513d3d','NULL','NULL','','NULL','NULL','NULL','','','','0');

INSERT INTO test_mohan_consignee (id, created_date_time, creator, creator_name, consignee_id, name, address, city, mobile_number, landline_number, district, state, gst_number, identification, others_city, unit_id, unit_name, price_value, opening_balance, opening_balance_type, cooly_value, deleted) VALUES ('107','2025-07-23 19:52:39','56564e46556c38774d513d3d','55334a706332396d64486468636d5636','5130394f55306c48546b5646587a497a4d4463794d4449314d4463314d6a4d35587a45774e773d3d','545339544c694242546b464f5243424954314e4a52564a4a52564d3d','56456c535656425655673d3d','56476c796458423163673d3d','4f5467304d6a63794f4449334d513d3d','','56476c79645842776458493d','5647467461577767546d466b64513d3d','NULL','NULL','','NULL','NULL','NULL','','','','0');

INSERT INTO test_mohan_consignee (id, created_date_time, creator, creator_name, consignee_id, name, address, city, mobile_number, landline_number, district, state, gst_number, identification, others_city, unit_id, unit_name, price_value, opening_balance, opening_balance_type, cooly_value, deleted) VALUES ('108','2025-07-23 19:53:50','56564e46556c38774d513d3d','55334a706332396d64486468636d5636','5130394f55306c48546b5646587a497a4d4463794d4449314d4463314d7a5577587a45774f413d3d','545339544c69424f51565a4652553467513039555645394f4945314a54457854494642575643424d5645516f52314170','56456c535656425655673d3d','56476c796458423163673d3d','4f5467304d6a51354e7a49774f413d3d','','56476c79645842776458493d','5647467461577767546d466b64513d3d','NULL','NULL','','NULL','NULL','NULL','','','','0');

INSERT INTO test_mohan_consignee (id, created_date_time, creator, creator_name, consignee_id, name, address, city, mobile_number, landline_number, district, state, gst_number, identification, others_city, unit_id, unit_name, price_value, opening_balance, opening_balance_type, cooly_value, deleted) VALUES ('109','2025-07-23 19:58:09','56564e46556c38774d513d3d','55334a706332396d64486468636d5636','5130394f55306c48546b5646587a497a4d4463794d4449314d4463314f444135587a45774f513d3d','5453395449455a535355564f52464d67545656535655644254694255556b464f55314250556c513d','55306c575155744255306b3d','55326c325957746863326b3d','4e7a4d7a4f544d7a4e444d344f413d3d','','566d6c796457526f645735685a324679','5647467461577767546d466b64513d3d','NULL','NULL','','NULL','NULL','NULL','','','','0');

INSERT INTO test_mohan_consignee (id, created_date_time, creator, creator_name, consignee_id, name, address, city, mobile_number, landline_number, district, state, gst_number, identification, others_city, unit_id, unit_name, price_value, opening_balance, opening_balance_type, cooly_value, deleted) VALUES ('110','2025-07-23 20:00:51','56564e46556c38774d513d3d','55334a706332396d64486468636d5636','5130394f55306c48546b5646587a497a4d4463794d4449314d4467774d445578587a45784d413d3d','545649754945524a546b56545343424c5655314255673d3d','56456c535656425655673d3d','56476c796458423163673d3d','4e6a4d344e4467334e4445344f513d3d','','56476c79645842776458493d','5647467461577767546d466b64513d3d','NULL','NULL','','NULL','NULL','NULL','','','','0');

INSERT INTO test_mohan_consignee (id, created_date_time, creator, creator_name, consignee_id, name, address, city, mobile_number, landline_number, district, state, gst_number, identification, others_city, unit_id, unit_name, price_value, opening_balance, opening_balance_type, cooly_value, deleted) VALUES ('111','2025-07-24 18:18:37','56564e46556c38774d513d3d','55334a706332396d64486468636d5636','5130394f55306c48546b5646587a49304d4463794d4449314d4459784f444d33587a45784d513d3d','545339544c69425453464a4652534254515564565230464f52564e49494642535355355552564a54','56456c535656425655673d3d','56476c796458423163673d3d','4f5467304d6a67334d5463324d513d3d','','56476c79645842776458493d','5647467461577767546d466b64513d3d','NULL','NULL','','NULL','NULL','NULL','','','','0');

INSERT INTO test_mohan_consignee (id, created_date_time, creator, creator_name, consignee_id, name, address, city, mobile_number, landline_number, district, state, gst_number, identification, others_city, unit_id, unit_name, price_value, opening_balance, opening_balance_type, cooly_value, deleted) VALUES ('112','2025-07-24 18:22:04','56564e46556c38774d513d3d','55334a706332396d64486468636d5636','5130394f55306c48546b5646587a49304d4463794d4449314d4459794d6a4130587a45784d673d3d','545339544c694248515535425545465553466b6752303950524578565130736753554e4649454e5054564242546c6b3d','56456c535656425655673d3d','56476c796458423163673d3d','4f5467324e5449344f4463794f513d3d','','56476c79645842776458493d','5647467461577767546d466b64513d3d','NULL','NULL','','NULL','NULL','NULL','','','','0');

INSERT INTO test_mohan_consignee (id, created_date_time, creator, creator_name, consignee_id, name, address, city, mobile_number, landline_number, district, state, gst_number, identification, others_city, unit_id, unit_name, price_value, opening_balance, opening_balance_type, cooly_value, deleted) VALUES ('113','2025-07-24 18:23:53','56564e46556c38774d513d3d','55334a706332396d64486468636d5636','5130394f55306c48546b5646587a49304d4463794d4449314d4459794d7a557a587a45784d773d3d','545339544c694242546b354253534242516b6c535155314a494642535355355552564a54','56456c535656425655673d3d','56476c796458423163673d3d','4f5467324e5449794e4441794e773d3d','','56476c79645842776458493d','5647467461577767546d466b64513d3d','NULL','NULL','','NULL','NULL','NULL','','','','0');

INSERT INTO test_mohan_consignee (id, created_date_time, creator, creator_name, consignee_id, name, address, city, mobile_number, landline_number, district, state, gst_number, identification, others_city, unit_id, unit_name, price_value, opening_balance, opening_balance_type, cooly_value, deleted) VALUES ('114','2025-07-24 18:25:23','56564e46556c38774d513d3d','55334a706332396d64486468636d5636','5130394f55306c48546b5646587a49304d4463794d4449314d4459794e54497a587a45784e413d3d','545339544c6942434c6c41754a6b4e50','56456c535656425655673d3d','56476c796458423163673d3d','4e7a557a4f546b354e5445784d513d3d','','56476c79645842776458493d','5647467461577767546d466b64513d3d','NULL','NULL','','NULL','NULL','NULL','','','','0');

INSERT INTO test_mohan_consignee (id, created_date_time, creator, creator_name, consignee_id, name, address, city, mobile_number, landline_number, district, state, gst_number, identification, others_city, unit_id, unit_name, price_value, opening_balance, opening_balance_type, cooly_value, deleted) VALUES ('115','2025-07-24 18:27:00','56564e46556c38774d513d3d','55334a706332396d64486468636d5636','5130394f55306c48546b5646587a49304d4463794d4449314d4459794e7a4177587a45784e513d3d','545339544c694254556b56464946524953564a56545656535655644249465a4a54454654','56456c535656425655673d3d','56476c796458423163673d3d','4f546b354e4451324d544d354d673d3d','','56476c79645842776458493d','5647467461577767546d466b64513d3d','NULL','NULL','','NULL','NULL','NULL','','','','0');

INSERT INTO test_mohan_consignee (id, created_date_time, creator, creator_name, consignee_id, name, address, city, mobile_number, landline_number, district, state, gst_number, identification, others_city, unit_id, unit_name, price_value, opening_balance, opening_balance_type, cooly_value, deleted) VALUES ('116','2025-07-24 18:28:50','56564e46556c38774d513d3d','55334a706332396d64486468636d5636','5130394f55306c48546b5646587a49304d4463794d4449314d4459794f445577587a45784e673d3d','545339544c69424354465646494642535355355549456c4e51556446','56456c535656425655673d3d','56476c796458423163673d3d','4f546b314d6a45774d7a6b774d413d3d','','56476c79645842776458493d','5647467461577767546d466b64513d3d','NULL','NULL','','NULL','NULL','NULL','','','','0');

INSERT INTO test_mohan_consignee (id, created_date_time, creator, creator_name, consignee_id, name, address, city, mobile_number, landline_number, district, state, gst_number, identification, others_city, unit_id, unit_name, price_value, opening_balance, opening_balance_type, cooly_value, deleted) VALUES ('117','2025-07-24 18:36:43','56564e46556c38774d513d3d','55334a706332396d64486468636d5636','5130394f55306c48546b5646587a49304d4463794d4449314d44597a4e6a517a587a45784e773d3d','54533954494531465130464f543149675455464453456c4f52564d3d','56456c535656425655673d3d','56476c796458423163673d3d','4f5455344e5455774d5455314d513d3d','','56476c79645842776458493d','5647467461577767546d466b64513d3d','NULL','NULL','','NULL','NULL','NULL','','','','0');

INSERT INTO test_mohan_consignee (id, created_date_time, creator, creator_name, consignee_id, name, address, city, mobile_number, landline_number, district, state, gst_number, identification, others_city, unit_id, unit_name, price_value, opening_balance, opening_balance_type, cooly_value, deleted) VALUES ('118','2025-07-24 18:44:36','56564e46556c38774d513d3d','55334a706332396d64486468636d5636','5130394f55306c48546b5646587a49304d4463794d4449314d4459304e444d32587a45784f413d3d','545339544c69424353556367516b39545579424851564a4e5255355555794251566c516754465245','56456c535656425655673d3d','56476c796458423163673d3d','4f544d304e4451334f4463344f413d3d','','56476c79645842776458493d','5647467461577767546d466b64513d3d','NULL','NULL','','NULL','NULL','NULL','','','','0');

INSERT INTO test_mohan_consignee (id, created_date_time, creator, creator_name, consignee_id, name, address, city, mobile_number, landline_number, district, state, gst_number, identification, others_city, unit_id, unit_name, price_value, opening_balance, opening_balance_type, cooly_value, deleted) VALUES ('119','2025-07-24 19:11:42','56564e46556c38774d513d3d','55334a706332396d64486468636d5636','5130394f55306c48546b5646587a49304d4463794d4449314d4463784d545179587a45784f513d3d','545339544c694245535652555479424851564a4e525535555579416f5455464d5156524953536b3d','56456c535656425655673d3d','56476c796458423163673d3d','4f44677a4f4459334e6a59794e673d3d','','56476c79645842776458493d','5647467461577767546d466b64513d3d','NULL','NULL','','NULL','NULL','NULL','','','','0');

INSERT INTO test_mohan_consignee (id, created_date_time, creator, creator_name, consignee_id, name, address, city, mobile_number, landline_number, district, state, gst_number, identification, others_city, unit_id, unit_name, price_value, opening_balance, opening_balance_type, cooly_value, deleted) VALUES ('120','2025-07-24 19:12:48','56564e46556c38774d513d3d','55334a706332396d64486468636d5636','5130394f55306c48546b5646587a49304d4463794d4449314d4463784d6a5134587a45794d413d3d','5453395449464e5153557446494642425130744252306c4f52314d3d','56456c535656425655673d3d','56476c796458423163673d3d','4f5467304d6a6b7a4f4445794d513d3d','','56476c79645842776458493d','5647467461577767546d466b64513d3d','NULL','NULL','','NULL','NULL','NULL','','','','0');

INSERT INTO test_mohan_consignee (id, created_date_time, creator, creator_name, consignee_id, name, address, city, mobile_number, landline_number, district, state, gst_number, identification, others_city, unit_id, unit_name, price_value, opening_balance, opening_balance_type, cooly_value, deleted) VALUES ('121','2025-07-24 19:14:50','56564e46556c38774d513d3d','55334a706332396d64486468636d5636','5130394f55306c48546b5646587a49304d4463794d4449314d4463784e445577587a45794d513d3d','545649675456564351564a4253773d3d','56456c535656425655673d3d','56476c796458423163673d3d','4f5441344d4441774e7a63344e773d3d','','56476c79645842776458493d','5647467461577767546d466b64513d3d','NULL','NULL','','NULL','NULL','NULL','','','','0');

INSERT INTO test_mohan_consignee (id, created_date_time, creator, creator_name, consignee_id, name, address, city, mobile_number, landline_number, district, state, gst_number, identification, others_city, unit_id, unit_name, price_value, opening_balance, opening_balance_type, cooly_value, deleted) VALUES ('122','2025-07-24 19:17:43','56564e46556c38774d513d3d','55334a706332396d64486468636d5636','5130394f55306c48546b5646587a49304d4463794d4449314d4463784e7a517a587a45794d673d3d','5530464a49464a425453424451564a4555773d3d','56456c535656425655673d3d','56476c796458423163673d3d','4f5467304d7a41344d446b774d773d3d','','56476c79645842776458493d','5647467461577767546d466b64513d3d','NULL','NULL','','NULL','NULL','NULL','','','','0');

INSERT INTO test_mohan_consignee (id, created_date_time, creator, creator_name, consignee_id, name, address, city, mobile_number, landline_number, district, state, gst_number, identification, others_city, unit_id, unit_name, price_value, opening_balance, opening_balance_type, cooly_value, deleted) VALUES ('123','2025-07-24 19:23:38','56564e46556c38774d513d3d','55334a706332396d64486468636d5636','5130394f55306c48546b5646587a49304d4463794d4449314d4463794d7a4d34587a45794d773d3d','545339544c694242546b464f5645684a494642535355355552564a54','56456c535656425655673d3d','56476c796458423163673d3d','4f5459794e6a49314e7a45354d673d3d','','56476c79645842776458493d','5647467461577767546d466b64513d3d','NULL','NULL','','NULL','NULL','NULL','','','','0');

INSERT INTO test_mohan_consignee (id, created_date_time, creator, creator_name, consignee_id, name, address, city, mobile_number, landline_number, district, state, gst_number, identification, others_city, unit_id, unit_name, price_value, opening_balance, opening_balance_type, cooly_value, deleted) VALUES ('124','2025-07-24 19:40:42','56564e46556c38774d513d3d','55334a706332396d64486468636d5636','5130394f55306c48546b5646587a49304d4463794d4449314d4463304d445179587a45794e413d3d','545339544c6942535355354c52566b6753453954535556535753685452556c554b513d3d','56456c535656425655673d3d','56476c796458423163673d3d','4f5441794e5445794d6a49314e773d3d','','56476c79645842776458493d','5647467461577767546d466b64513d3d','NULL','NULL','','NULL','NULL','NULL','','','','0');

INSERT INTO test_mohan_consignee (id, created_date_time, creator, creator_name, consignee_id, name, address, city, mobile_number, landline_number, district, state, gst_number, identification, others_city, unit_id, unit_name, price_value, opening_balance, opening_balance_type, cooly_value, deleted) VALUES ('125','2025-07-24 19:42:33','56564e46556c38774d513d3d','55334a706332396d64486468636d5636','5130394f55306c48546b5646587a49304d4463794d4449314d4463304d6a4d7a587a45794e513d3d','545339544c69424c4c6b497549464e585255565555773d3d','51585a70626d467a61513d3d','56476c796458423163673d3d','4f5463344e7a51304e4451344d413d3d','','56476c79645842776458493d','5647467461577767546d466b64513d3d','NULL','NULL','','NULL','NULL','NULL','','','','0');

INSERT INTO test_mohan_consignee (id, created_date_time, creator, creator_name, consignee_id, name, address, city, mobile_number, landline_number, district, state, gst_number, identification, others_city, unit_id, unit_name, price_value, opening_balance, opening_balance_type, cooly_value, deleted) VALUES ('126','2025-07-24 19:54:15','56564e46556c38774d513d3d','55334a706332396d64486468636d5636','5130394f55306c48546b5646587a49304d4463794d4449314d4463314e444531587a45794e673d3d','545339544c694251556b6c4f5645386752314a425545684a51314d3d','56456c535656425655673d3d','56476c796458423163673d3d','4e7a597a4f5451794f446b314d773d3d','','56476c79645842776458493d','5647467461577767546d466b64513d3d','NULL','NULL','','NULL','NULL','NULL','','','','0');

INSERT INTO test_mohan_consignee (id, created_date_time, creator, creator_name, consignee_id, name, address, city, mobile_number, landline_number, district, state, gst_number, identification, others_city, unit_id, unit_name, price_value, opening_balance, opening_balance_type, cooly_value, deleted) VALUES ('127','2025-07-24 19:57:04','56564e46556c38774d513d3d','55334a706332396d64486468636d5636','5130394f55306c48546b5646587a49304d4463794d4449314d4463314e7a4130587a45794e773d3d','545339544c69424352564e5549455a4a546b464f5130565449454e50556c4250556b46555355394f','56456c535656425655673d3d','56476c796458423163673d3d','4f546b304d7a45794e6a49794e773d3d','','56476c79645842776458493d','5647467461577767546d466b64513d3d','NULL','NULL','','NULL','NULL','NULL','','','','0');

INSERT INTO test_mohan_consignee (id, created_date_time, creator, creator_name, consignee_id, name, address, city, mobile_number, landline_number, district, state, gst_number, identification, others_city, unit_id, unit_name, price_value, opening_balance, opening_balance_type, cooly_value, deleted) VALUES ('128','2025-07-24 19:58:06','56564e46556c38774d513d3d','55334a706332396d64486468636d5636','5130394f55306c48546b5646587a49304d4463794d4449314d4463314f444132587a45794f413d3d','545339544c69424b5255306755315651525649675455465353305655','56456c535656425655673d3d','56476c796458423163673d3d','4f5463314d5449774d7a4d774d773d3d','','56476c79645842776458493d','5647467461577767546d466b64513d3d','NULL','NULL','','NULL','NULL','NULL','','','','0');

INSERT INTO test_mohan_consignee (id, created_date_time, creator, creator_name, consignee_id, name, address, city, mobile_number, landline_number, district, state, gst_number, identification, others_city, unit_id, unit_name, price_value, opening_balance, opening_balance_type, cooly_value, deleted) VALUES ('129','2025-07-24 19:59:04','56564e46556c38774d513d3d','55334a706332396d64486468636d5636','5130394f55306c48546b5646587a49304d4463794d4449314d4463314f544130587a45794f513d3d','545339544c69424352564a535753416d49454e4d51564a4c4943685452556c554b513d3d','56456c535656425655673d3d','56476c796458423163673d3d','4f5467354e4463324d5459334d513d3d','','56476c79645842776458493d','5647467461577767546d466b64513d3d','NULL','NULL','','NULL','NULL','NULL','','','','0');

INSERT INTO test_mohan_consignee (id, created_date_time, creator, creator_name, consignee_id, name, address, city, mobile_number, landline_number, district, state, gst_number, identification, others_city, unit_id, unit_name, price_value, opening_balance, opening_balance_type, cooly_value, deleted) VALUES ('130','2025-07-24 19:59:53','56564e46556c38774d513d3d','55334a706332396d64486468636d5636','5130394f55306c48546b5646587a49304d4463794d4449314d4463314f54557a587a457a4d413d3d','545339544c69425753564e49546c55675645565956456c4d52564d674a694244543031515155355a','56456c535656425655673d3d','56476c796458423163673d3d','4f5449774e5459304e54637a4e513d3d','','56476c79645842776458493d','5647467461577767546d466b64513d3d','NULL','NULL','','NULL','NULL','NULL','','','','0');

INSERT INTO test_mohan_consignee (id, created_date_time, creator, creator_name, consignee_id, name, address, city, mobile_number, landline_number, district, state, gst_number, identification, others_city, unit_id, unit_name, price_value, opening_balance, opening_balance_type, cooly_value, deleted) VALUES ('131','2025-07-24 20:00:57','56564e46556c38774d513d3d','55334a706332396d64486468636d5636','5130394f55306c48546b5646587a49304d4463794d4449314d4467774d445533587a457a4d513d3d','545339544c694254556c59675355354f52564a58525546535579416f5530564a56436b3d','56456c535656425655673d3d','56476c796458423163673d3d','4f5467354e4445324e7a45774d413d3d','','56476c79645842776458493d','5647467461577767546d466b64513d3d','NULL','NULL','','NULL','NULL','NULL','','','','0');

INSERT INTO test_mohan_consignee (id, created_date_time, creator, creator_name, consignee_id, name, address, city, mobile_number, landline_number, district, state, gst_number, identification, others_city, unit_id, unit_name, price_value, opening_balance, opening_balance_type, cooly_value, deleted) VALUES ('132','2025-07-24 20:03:25','56564e46556c38774d513d3d','55334a706332396d64486468636d5636','5130394f55306c48546b5646587a49304d4463794d4449314d4467774d7a4931587a457a4d673d3d','545339544c69424b53314d67544546435255776751314a42526c516749456c4f5243424d5645513d','56456c535656425655673d3d','56476c796458423163673d3d','4f4449794d4441304d6a67344f413d3d','','56476c79645842776458493d','5647467461577767546d466b64513d3d','NULL','NULL','','NULL','NULL','NULL','','','','0');

INSERT INTO test_mohan_consignee (id, created_date_time, creator, creator_name, consignee_id, name, address, city, mobile_number, landline_number, district, state, gst_number, identification, others_city, unit_id, unit_name, price_value, opening_balance, opening_balance_type, cooly_value, deleted) VALUES ('133','2025-07-24 20:04:27','56564e46556c38774d513d3d','55334a706332396d64486468636d5636','5130394f55306c48546b5646587a49304d4463794d4449314d4467774e444933587a457a4d773d3d','545339544c69425753564e585153424351557446556c6b3d','56456c535656425655673d3d','56476c796458423163673d3d','4f546b314d6a55784e7a63354f413d3d','','56476c79645842776458493d','5647467461577767546d466b64513d3d','NULL','NULL','','NULL','NULL','NULL','','','','0');

INSERT INTO test_mohan_consignee (id, created_date_time, creator, creator_name, consignee_id, name, address, city, mobile_number, landline_number, district, state, gst_number, identification, others_city, unit_id, unit_name, price_value, opening_balance, opening_balance_type, cooly_value, deleted) VALUES ('134','2025-07-24 20:05:56','56564e46556c38774d513d3d','55334a706332396d64486468636d5636','5130394f55306c48546b5646587a49304d4463794d4449314d4467774e545532587a457a4e413d3d','545339544c69424d4c6b63755345395455456c555155773d','56456c535656425655673d3d','56476c796458423163673d3d','4f5459334e7a51354e6a59324e673d3d','','56476c79645842776458493d','5647467461577767546d466b64513d3d','NULL','NULL','','NULL','NULL','NULL','','','','0');

INSERT INTO test_mohan_consignee (id, created_date_time, creator, creator_name, consignee_id, name, address, city, mobile_number, landline_number, district, state, gst_number, identification, others_city, unit_id, unit_name, price_value, opening_balance, opening_balance_type, cooly_value, deleted) VALUES ('135','2025-07-24 20:08:34','56564e46556c38774d513d3d','55334a706332396d64486468636d5636','5130394f55306c48546b5646587a49304d4463794d4449314d4467774f444d30587a457a4e513d3d','545339544c694254524649675545465356464d3d','56456c535656425655673d3d','56476c796458423163673d3d','4f5467354e4467314d4441774d513d3d','','56476c79645842776458493d','5647467461577767546d466b64513d3d','NULL','NULL','','NULL','NULL','NULL','','','','0');

INSERT INTO test_mohan_consignee (id, created_date_time, creator, creator_name, consignee_id, name, address, city, mobile_number, landline_number, district, state, gst_number, identification, others_city, unit_id, unit_name, price_value, opening_balance, opening_balance_type, cooly_value, deleted) VALUES ('136','2025-07-24 20:10:17','56564e46556c38774d513d3d','55334a706332396d64486468636d5636','5130394f55306c48546b5646587a49304d4463794d4449314d4467784d444533587a457a4e673d3d','545339544c69424e535552425579424751564e495355394f5579416f5455464d5156524953536b3d','56456c535656425655673d3d','56476c796458423163673d3d','4f544d324d7a417a4d4445794e413d3d','','56476c79645842776458493d','5647467461577767546d466b64513d3d','NULL','NULL','','NULL','NULL','NULL','','','','0');

INSERT INTO test_mohan_consignee (id, created_date_time, creator, creator_name, consignee_id, name, address, city, mobile_number, landline_number, district, state, gst_number, identification, others_city, unit_id, unit_name, price_value, opening_balance, opening_balance_type, cooly_value, deleted) VALUES ('137','2025-07-24 20:11:35','56564e46556c38774d513d3d','55334a706332396d64486468636d5636','5130394f55306c48546b5646587a49304d4463794d4449314d4467784d544d31587a457a4e773d3d','545339544c694254556b6b675330464e5156524453456b6756455659','56456c535656425655673d3d','56476c796458423163673d3d','4f5451304d7a6b784d5463774d673d3d','','56476c79645842776458493d','5647467461577767546d466b64513d3d','NULL','NULL','','NULL','NULL','NULL','','','','0');

INSERT INTO test_mohan_consignee (id, created_date_time, creator, creator_name, consignee_id, name, address, city, mobile_number, landline_number, district, state, gst_number, identification, others_city, unit_id, unit_name, price_value, opening_balance, opening_balance_type, cooly_value, deleted) VALUES ('138','2025-07-24 20:12:55','56564e46556c38774d513d3d','55334a706332396d64486468636d5636','5130394f55306c48546b5646587a49304d4463794d4449314d4467784d6a5531587a457a4f413d3d','545339544c69424c544539575253424d5355354852564a4a52564d3d','56456c535656425655673d3d','56476c796458423163673d3d','4f5463314d446b314e7a6b774e513d3d','','56476c79645842776458493d','5647467461577767546d466b64513d3d','NULL','NULL','','NULL','NULL','NULL','','','','0');

INSERT INTO test_mohan_consignee (id, created_date_time, creator, creator_name, consignee_id, name, address, city, mobile_number, landline_number, district, state, gst_number, identification, others_city, unit_id, unit_name, price_value, opening_balance, opening_balance_type, cooly_value, deleted) VALUES ('139','2025-07-24 20:18:55','56564e46556c38774d513d3d','55334a706332396d64486468636d5636','5130394f55306c48546b5646587a49304d4463794d4449314d4467784f445531587a457a4f513d3d','545339544c69424e51564a565645684a4945314a5745565349454e5054564242546c6b3d','56456c535656425655673d3d','56476c796458423163673d3d','4f5463344f54517a4e4451314f413d3d','','56476c79645842776458493d','5647467461577767546d466b64513d3d','NULL','NULL','','NULL','NULL','NULL','','','','0');

INSERT INTO test_mohan_consignee (id, created_date_time, creator, creator_name, consignee_id, name, address, city, mobile_number, landline_number, district, state, gst_number, identification, others_city, unit_id, unit_name, price_value, opening_balance, opening_balance_type, cooly_value, deleted) VALUES ('140','2025-07-24 20:19:57','56564e46556c38774d513d3d','55334a706332396d64486468636d5636','5130394f55306c48546b5646587a49304d4463794d4449314d4467784f545533587a45304d413d3d','545339544c6942545655355552554e49','56456c535656425655673d3d','56476c796458423163673d3d','4f5467304d6a45314e5463774e513d3d','','56476c79645842776458493d','5647467461577767546d466b64513d3d','NULL','NULL','','NULL','NULL','NULL','','','','0');

INSERT INTO test_mohan_consignee (id, created_date_time, creator, creator_name, consignee_id, name, address, city, mobile_number, landline_number, district, state, gst_number, identification, others_city, unit_id, unit_name, price_value, opening_balance, opening_balance_type, cooly_value, deleted) VALUES ('141','2025-07-24 20:23:04','56564e46556c38774d513d3d','55334a706332396d64486468636d5636','5130394f55306c48546b5646587a49304d4463794d4449314d4467794d7a4130587a45304d513d3d','545339544c69424b525535464945524256455654','56456c535656425655673d3d','56476c796458423163673d3d','4f5441304d6a41774d546b304f413d3d','','56476c79645842776458493d','5647467461577767546d466b64513d3d','NULL','NULL','','NULL','NULL','NULL','','','','0');

INSERT INTO test_mohan_consignee (id, created_date_time, creator, creator_name, consignee_id, name, address, city, mobile_number, landline_number, district, state, gst_number, identification, others_city, unit_id, unit_name, price_value, opening_balance, opening_balance_type, cooly_value, deleted) VALUES ('142','2025-07-24 20:23:49','56564e46556c38774d513d3d','55334a706332396d64486468636d5636','5130394f55306c48546b5646587a49304d4463794d4449314d4467794d7a5135587a45304d673d3d','545339544c694243544539545530394e49456c4f546b565355794251566c516754465245','56456c535656425655673d3d','56476c796458423163673d3d','4e7a55354e446b334e5463784d413d3d','','56476c79645842776458493d','5647467461577767546d466b64513d3d','NULL','NULL','','NULL','NULL','NULL','','','','0');

INSERT INTO test_mohan_consignee (id, created_date_time, creator, creator_name, consignee_id, name, address, city, mobile_number, landline_number, district, state, gst_number, identification, others_city, unit_id, unit_name, price_value, opening_balance, opening_balance_type, cooly_value, deleted) VALUES ('143','2025-07-24 20:27:13','56564e46556c38774d513d3d','55334a706332396d64486468636d5636','5130394f55306c48546b5646587a49304d4463794d4449314d4467794e7a457a587a45304d773d3d','545339544c69425456554a4953564e49515341675130465556457846494342475355564d52413d3d','55306c575155744255306b3d','55326c325957746863326b3d','4f4449304f4451354f4459354d673d3d','','566d6c796457526f645735685a324679','5647467461577767546d466b64513d3d','NULL','NULL','','NULL','NULL','NULL','','','','0');

INSERT INTO test_mohan_consignee (id, created_date_time, creator, creator_name, consignee_id, name, address, city, mobile_number, landline_number, district, state, gst_number, identification, others_city, unit_id, unit_name, price_value, opening_balance, opening_balance_type, cooly_value, deleted) VALUES ('144','2025-07-24 20:29:09','56564e46556c38774d513d3d','55334a706332396d64486468636d5636','5130394f55306c48546b5646587a49304d4463794d4449314d4467794f544135587a45304e413d3d','545339544c694248494564535156424953554e54','56456c535656425655673d3d','56476c796458423163673d3d','4f5451344e6a41344e5451794d513d3d','','56476c79645842776458493d','5647467461577767546d466b64513d3d','NULL','NULL','','NULL','NULL','NULL','','','','0');

INSERT INTO test_mohan_consignee (id, created_date_time, creator, creator_name, consignee_id, name, address, city, mobile_number, landline_number, district, state, gst_number, identification, others_city, unit_id, unit_name, price_value, opening_balance, opening_balance_type, cooly_value, deleted) VALUES ('145','2025-07-24 20:29:59','56564e46556c38774d513d3d','55334a706332396d64486468636d5636','5130394f55306c48546b5646587a49304d4463794d4449314d4467794f545535587a45304e513d3d','545339544c6942544c6c4d755645565956456c4d52564d674b464e4653565170','56456c535656425655673d3d','56476c796458423163673d3d','4f5459774d4467354f5441314e513d3d','','56476c79645842776458493d','5647467461577767546d466b64513d3d','NULL','NULL','','NULL','NULL','NULL','','','','0');

INSERT INTO test_mohan_consignee (id, created_date_time, creator, creator_name, consignee_id, name, address, city, mobile_number, landline_number, district, state, gst_number, identification, others_city, unit_id, unit_name, price_value, opening_balance, opening_balance_type, cooly_value, deleted) VALUES ('146','2025-07-24 20:30:48','56564e46556c38774d513d3d','55334a706332396d64486468636d5636','5130394f55306c48546b5646587a49304d4463794d4449314d44677a4d445134587a45304e673d3d','545339544c69424c4c6b3075494652465746524a54455654494367675655354a5669425151554d70','56456c535656425655673d3d','56476c796458423163673d3d','4f544d324d7a41774e4463774d773d3d','','56476c79645842776458493d','5647467461577767546d466b64513d3d','NULL','NULL','','NULL','NULL','NULL','','','','0');

INSERT INTO test_mohan_consignee (id, created_date_time, creator, creator_name, consignee_id, name, address, city, mobile_number, landline_number, district, state, gst_number, identification, others_city, unit_id, unit_name, price_value, opening_balance, opening_balance_type, cooly_value, deleted) VALUES ('147','2025-07-24 20:51:25','56564e46556c38774d513d3d','55334a706332396d64486468636d5636','5130394f55306c48546b5646587a49304d4463794d4449314d4467314d544931587a45304e773d3d','5456497549464a42536b56545346644255673d3d','56456c535656425655673d3d','56476c79645842686447683163673d3d','4f5463344e6a63304d5451314d413d3d','','56476c79645842686447683163673d3d','5647467461577767546d466b64513d3d','NULL','NULL','','NULL','NULL','NULL','','','','0');

INSERT INTO test_mohan_consignee (id, created_date_time, creator, creator_name, consignee_id, name, address, city, mobile_number, landline_number, district, state, gst_number, identification, others_city, unit_id, unit_name, price_value, opening_balance, opening_balance_type, cooly_value, deleted) VALUES ('148','2025-07-24 20:52:31','56564e46556c38774d513d3d','55334a706332396d64486468636d5636','5130394f55306c48546b5646587a49304d4463794d4449314d4467314d6a4d78587a45304f413d3d','545339544c69425351557042556b464e','56456c535656425655673d3d','56476c796458423163673d3d','4f546b304e444d774f446b324d773d3d','','56476c79645842776458493d','5647467461577767546d466b64513d3d','NULL','NULL','','NULL','NULL','NULL','','','','0');

INSERT INTO test_mohan_consignee (id, created_date_time, creator, creator_name, consignee_id, name, address, city, mobile_number, landline_number, district, state, gst_number, identification, others_city, unit_id, unit_name, price_value, opening_balance, opening_balance_type, cooly_value, deleted) VALUES ('149','2025-07-24 20:53:43','56564e46556c38774d513d3d','55334a706332396d64486468636d5636','5130394f55306c48546b5646587a49304d4463794d4449314d4467314d7a517a587a45304f513d3d','545339544c69425553456c5351565a4a524545675545465451564a4253513d3d','56456c535656425655673d3d','56476c796458423163673d3d','4f5467304d7a55314e6a59324d673d3d','','56476c79645842776458493d','5647467461577767546d466b64513d3d','NULL','NULL','','NULL','NULL','NULL','','','','0');

INSERT INTO test_mohan_consignee (id, created_date_time, creator, creator_name, consignee_id, name, address, city, mobile_number, landline_number, district, state, gst_number, identification, others_city, unit_id, unit_name, price_value, opening_balance, opening_balance_type, cooly_value, deleted) VALUES ('150','2025-07-24 20:54:56','56564e46556c38774d513d3d','55334a706332396d64486468636d5636','5130394f55306c48546b5646587a49304d4463794d4449314d4467314e445532587a45314d413d3d','5456497549464e46546c52495355784f515652495155343d','56456c535656425655673d3d','56476c796458423163673d3d','4f546b314d6a51784d5449794d513d3d','','56476c79645842776458493d','5647467461577767546d466b64513d3d','NULL','NULL','','NULL','NULL','NULL','','','','0');

INSERT INTO test_mohan_consignee (id, created_date_time, creator, creator_name, consignee_id, name, address, city, mobile_number, landline_number, district, state, gst_number, identification, others_city, unit_id, unit_name, price_value, opening_balance, opening_balance_type, cooly_value, deleted) VALUES ('151','2025-07-24 20:58:20','56564e46556c38774d513d3d','55334a706332396d64486468636d5636','5130394f55306c48546b5646587a49304d4463794d4449314d4467314f444977587a45314d513d3d','545339544c6942544c6b3467526b4643556b6c44','56456c535656425655673d3d','56476c796458423163673d3d','4e6a4d344d4467304e7a67324d413d3d','','56476c79645842776458493d','5647467461577767546d466b64513d3d','NULL','NULL','','NULL','NULL','NULL','','','','0');

INSERT INTO test_mohan_consignee (id, created_date_time, creator, creator_name, consignee_id, name, address, city, mobile_number, landline_number, district, state, gst_number, identification, others_city, unit_id, unit_name, price_value, opening_balance, opening_balance_type, cooly_value, deleted) VALUES ('152','2025-07-24 20:59:35','56564e46556c38774d513d3d','55334a706332396d64486468636d5636','5130394f55306c48546b5646587a49304d4463794d4449314d4467314f544d31587a45314d673d3d','545339544c694254556b6b675445464c5530684e53534255556b464552564a54','56456c535656425655673d3d','56476c796458423163673d3d','4f5459794f544d334d7a55324d413d3d','','56476c79645842776458493d','5647467461577767546d466b64513d3d','NULL','NULL','','NULL','NULL','NULL','','','','0');

INSERT INTO test_mohan_consignee (id, created_date_time, creator, creator_name, consignee_id, name, address, city, mobile_number, landline_number, district, state, gst_number, identification, others_city, unit_id, unit_name, price_value, opening_balance, opening_balance_type, cooly_value, deleted) VALUES ('153','2025-07-24 21:03:02','56564e46556c38774d513d3d','55334a706332396d64486468636d5636','5130394f55306c48546b5646587a49304d4463794d4449314d446b774d7a4179587a45314d773d3d','545339544c6942445345564f52456856556942515445465456456c4453314d3d','56456c535656425655673d3d','56476c796458423163673d3d','4f4441314e6a63334d6a51354e673d3d','','56476c79645842776458493d','5647467461577767546d466b64513d3d','NULL','NULL','','NULL','NULL','NULL','','','','0');

INSERT INTO test_mohan_consignee (id, created_date_time, creator, creator_name, consignee_id, name, address, city, mobile_number, landline_number, district, state, gst_number, identification, others_city, unit_id, unit_name, price_value, opening_balance, opening_balance_type, cooly_value, deleted) VALUES ('154','2025-07-26 13:37:01','56564e46556c38774d513d3d','55334a706332396d64486468636d5636','5130394f55306c48546b5646587a49324d4463794d4449314d44457a4e7a4178587a45314e413d3d','545339544c69425456553545515649675545464453314d674a69424351556454','56456c535656425655673d3d','56476c796458423163673d3d','4f5467304d7a41304d546b354f513d3d','','56476c79645842776458493d','5647467461577767546d466b64513d3d','NULL','NULL','','NULL','NULL','NULL','','','','0');

INSERT INTO test_mohan_consignee (id, created_date_time, creator, creator_name, consignee_id, name, address, city, mobile_number, landline_number, district, state, gst_number, identification, others_city, unit_id, unit_name, price_value, opening_balance, opening_balance_type, cooly_value, deleted) VALUES ('155','2025-07-26 13:38:19','56564e46556c38774d513d3d','55334a706332396d64486468636d5636','5130394f55306c48546b5646587a49324d4463794d4449314d44457a4f444535587a45314e513d3d','545339544c694254566b776756464a4252456c4f52773d3d','NULL','NULL','4f5467304d6a49334e4451344d673d3d','','NULL','5647467461577767546d466b64513d3d','NULL','NULL','','NULL','NULL','NULL','','','','0');

INSERT INTO test_mohan_consignee (id, created_date_time, creator, creator_name, consignee_id, name, address, city, mobile_number, landline_number, district, state, gst_number, identification, others_city, unit_id, unit_name, price_value, opening_balance, opening_balance_type, cooly_value, deleted) VALUES ('156','2025-07-26 13:39:16','56564e46556c38774d513d3d','55334a706332396d64486468636d5636','5130394f55306c48546b5646587a49324d4463794d4449314d44457a4f544532587a45314e673d3d','545339544c694242546b5242566b46534946424d51564e5553554d675130394e5545464f57513d3d','56456c535656425655673d3d','56476c796458423163673d3d','4f5459334e7a63314f5459354f513d3d','','56476c79645842776458493d','5647467461577767546d466b64513d3d','NULL','NULL','','NULL','NULL','NULL','','','','0');

INSERT INTO test_mohan_consignee (id, created_date_time, creator, creator_name, consignee_id, name, address, city, mobile_number, landline_number, district, state, gst_number, identification, others_city, unit_id, unit_name, price_value, opening_balance, opening_balance_type, cooly_value, deleted) VALUES ('157','2025-07-28 16:55:29','56564e46556c38774d513d3d','55334a706332396d64486468636d5636','5130394f55306c48546b5646587a49344d4463794d4449314d4451314e544935587a45314e773d3d','545339544946497555434167523046535455564f56464d3d','56456c535656425655673d3d','56476c796458423163673d3d','4f44677a4f4441354d4459774f413d3d','','56476c79645842776458493d','5647467461577767546d466b64513d3d','NULL','NULL','NULL','NULL','NULL','NULL','','','','0');

INSERT INTO test_mohan_consignee (id, created_date_time, creator, creator_name, consignee_id, name, address, city, mobile_number, landline_number, district, state, gst_number, identification, others_city, unit_id, unit_name, price_value, opening_balance, opening_balance_type, cooly_value, deleted) VALUES ('158','2025-07-28 17:14:47','56564e46556c38774d513d3d','55334a706332396d64486468636d5636','5130394f55306c48546b5646587a49344d4463794d4449314d4455784e445133587a45314f413d3d','545339544c6942514c6b3075564556594943684e515578425645684a4b513d3d','5545565356553142546b464d54465653','56476c796458423163673d3d','4f4467334d4451324d7a497a4d513d3d','','56476c79645842776458493d','5647467461577767546d466b64513d3d','NULL','NULL','NULL','NULL','NULL','NULL','','','','0');

INSERT INTO test_mohan_consignee (id, created_date_time, creator, creator_name, consignee_id, name, address, city, mobile_number, landline_number, district, state, gst_number, identification, others_city, unit_id, unit_name, price_value, opening_balance, opening_balance_type, cooly_value, deleted) VALUES ('159','2025-07-30 20:23:03','56564e46556c38774d513d3d','55334a706332396d64486468636d5636','5130394f55306c48546b5646587a4d774d4463794d4449314d4467794d7a417a587a45314f513d3d','5679416d4945636749455a425530684a5430346755465a55','NULL','56476c796458423163673d3d','4f5463354d4445334e7a45784d513d3d','','56476c79645842776458493d','5647467461577767546d466b64513d3d','NULL','NULL','NULL','','','','','','','0');

INSERT INTO test_mohan_consignee (id, created_date_time, creator, creator_name, consignee_id, name, address, city, mobile_number, landline_number, district, state, gst_number, identification, others_city, unit_id, unit_name, price_value, opening_balance, opening_balance_type, cooly_value, deleted) VALUES ('160','2025-08-01 12:06:23','56564e46556c38774d513d3d','55334a706332396d64486468636d5636','5130394f55306c48546b5646587a41784d4467794d4449314d5449774e6a497a587a45324d413d3d','545339544946497555434167523046535455564f56464d3d','56456c535656425655673d3d','56476c796458423163673d3d','4f5459344e6a63324e5459304e673d3d','','56476c79645842776458493d','5647467461577767546d466b64513d3d','NULL','4f44677a4f4441354d4459774f413d3d','','NULL','NULL','NULL','','','','0');

INSERT INTO test_mohan_consignee (id, created_date_time, creator, creator_name, consignee_id, name, address, city, mobile_number, landline_number, district, state, gst_number, identification, others_city, unit_id, unit_name, price_value, opening_balance, opening_balance_type, cooly_value, deleted) VALUES ('161','2025-08-01 12:07:48','56564e46556c38774d513d3d','55334a706332396d64486468636d5636','5130394f55306c48546b5646587a41784d4467794d4449314d5449774e7a5134587a45324d513d3d','54533954494641755453417556455659','56456c535656425655673d3d','56476c796458423163673d3d','4f546b344f4463334e6a59314e513d3d','','56476c79645842776458493d','5647467461577767546d466b64513d3d','NULL','4f4467334d4451324d7a497a4d513d3d','','NULL','NULL','NULL','','','','0');

INSERT INTO test_mohan_consignee (id, created_date_time, creator, creator_name, consignee_id, name, address, city, mobile_number, landline_number, district, state, gst_number, identification, others_city, unit_id, unit_name, price_value, opening_balance, opening_balance_type, cooly_value, deleted) VALUES ('162','2025-08-01 12:38:46','56564e46556c38774d513d3d','55334a706332396d64486468636d5636','5130394f55306c48546b5646587a41784d4467794d4449314d54497a4f445132587a45324d673d3d','545339544c6942504c6c51675645565956456c4d52564d6757314264494578555243416f5530564a56436b3d','56456c535656425655673d3d','56476c796458423163673d3d','4f5467354d6a49334e4459774d413d3d','','56476c79645842776458493d','5647467461577767546d466b64513d3d','NULL','NULL','','NULL','NULL','NULL','','','','0');

INSERT INTO test_mohan_consignee (id, created_date_time, creator, creator_name, consignee_id, name, address, city, mobile_number, landline_number, district, state, gst_number, identification, others_city, unit_id, unit_name, price_value, opening_balance, opening_balance_type, cooly_value, deleted) VALUES ('163','2025-08-01 12:43:07','56564e46556c38774d513d3d','55334a706332396d64486468636d5636','5130394f55306c48546b5646587a41784d4467794d4449314d5449304d7a4133587a45324d773d3d','545339544c694242566b464f53534258525552455355354849454e42556b5254','56456c535656425655673d3d','56476c796458423163673d3d','4f544d344e5451774e4459774d513d3d','','56476c79645842776458493d','5647467461577767546d466b64513d3d','NULL','NULL','','NULL','NULL','NULL','','','','0');

INSERT INTO test_mohan_consignee (id, created_date_time, creator, creator_name, consignee_id, name, address, city, mobile_number, landline_number, district, state, gst_number, identification, others_city, unit_id, unit_name, price_value, opening_balance, opening_balance_type, cooly_value, deleted) VALUES ('164','2025-08-01 12:47:40','56564e46556c38774d513d3d','55334a706332396d64486468636d5636','5130394f55306c48546b5646587a41784d4467794d4449314d5449304e7a5177587a45324e413d3d','5453395449464250546b35465569424751564e495355394f5579425852554653','56456c535656425655673d3d','56476c796458423163673d3d','4f546b354e4455774e4455334d513d3d','','56476c79645842776458493d','5647467461577767546d466b64513d3d','NULL','NULL','','NULL','NULL','NULL','','','','0');

INSERT INTO test_mohan_consignee (id, created_date_time, creator, creator_name, consignee_id, name, address, city, mobile_number, landline_number, district, state, gst_number, identification, others_city, unit_id, unit_name, price_value, opening_balance, opening_balance_type, cooly_value, deleted) VALUES ('165','2025-08-01 12:50:44','56564e46556c38774d513d3d','55334a706332396d64486468636d5636','5130394f55306c48546b5646587a41784d4467794d4449314d5449314d445130587a45324e513d3d','5345465353564e49','56456c535656425655673d3d','56476c796458423163673d3d','4f5451304d6a59304d444d324e513d3d','','56476c79645842776458493d','5647467461577767546d466b64513d3d','NULL','NULL','','NULL','NULL','NULL','','','','0');


CREATE TABLE `test_mohan_consignor` (
  `id` int(100) NOT NULL AUTO_INCREMENT,
  `created_date_time` datetime NOT NULL,
  `creator` mediumtext NOT NULL,
  `creator_name` mediumtext NOT NULL,
  `consignor_id` mediumtext NOT NULL,
  `name` mediumtext NOT NULL,
  `address` mediumtext NOT NULL,
  `city` mediumtext NOT NULL,
  `mobile_number` mediumtext NOT NULL,
  `landline_number` mediumtext NOT NULL,
  `district` mediumtext NOT NULL,
  `state` mediumtext NOT NULL,
  `gst_number` mediumtext NOT NULL,
  `identification` mediumtext NOT NULL,
  `bill_company_id` mediumtext NOT NULL,
  `unit_id` mediumtext NOT NULL,
  `unit_name` mediumtext NOT NULL,
  `price_value` mediumtext NOT NULL,
  `opening_balance` mediumtext NOT NULL,
  `opening_balance_type` mediumtext NOT NULL,
  `others_city` mediumtext NOT NULL,
  `cooly_value` mediumtext NOT NULL,
  `deleted` int(100) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=135 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;


INSERT INTO test_mohan_consignor (id, created_date_time, creator, creator_name, consignor_id, name, address, city, mobile_number, landline_number, district, state, gst_number, identification, bill_company_id, unit_id, unit_name, price_value, opening_balance, opening_balance_type, others_city, cooly_value, deleted) VALUES ('1','2025-07-11 22:01:24','56564e46556c38784d5441334d6a41794e5441354e54517a4d5638774e773d3d','55334a706332396d64486468636d5636','5130394f55306c48546b3953587a45784d4463794d4449314d5441774d544930587a4178','533046535645684a','NULL','NULL','4f5459314e54557a4d6a41304f413d3d','','NULL','5647467461577767546d466b64513d3d','NULL','NULL','','NULL','NULL','NULL','','','','','0');

INSERT INTO test_mohan_consignor (id, created_date_time, creator, creator_name, consignor_id, name, address, city, mobile_number, landline_number, district, state, gst_number, identification, bill_company_id, unit_id, unit_name, price_value, opening_balance, opening_balance_type, others_city, cooly_value, deleted) VALUES ('2','2025-07-12 18:58:11','56564e46556c38784d5441334d6a41794e5441354e5445784d6c38774e673d3d','55334a706332396d64486468636d5636','5130394f55306c48546b3953587a45794d4463794d4449314d4459314f444578587a4179','545339544c69425453464a4a4945745353564e49546b45675545394d57553146556c4d3d','55306c575155744255306b3d','55326c325957746863326b3d','4f544d304e5441794d6a67354d413d3d','','566d6c796457526f645735685a324679','5647467461577767546d466b64513d3d','NULL','NULL','','NULL','NULL','NULL','','','Sivakasi','','0');

INSERT INTO test_mohan_consignor (id, created_date_time, creator, creator_name, consignor_id, name, address, city, mobile_number, landline_number, district, state, gst_number, identification, bill_company_id, unit_id, unit_name, price_value, opening_balance, opening_balance_type, others_city, cooly_value, deleted) VALUES ('3','2025-07-12 18:59:38','56564e46556c38784d5441334d6a41794e5441354e5445784d6c38774e673d3d','55334a706332396d64486468636d5636','5130394f55306c48546b3953587a45794d4463794d4449314d4459314f544d34587a417a','545339544c69424e515578425645684a494546485255354453555654','55306c575155744255306b3d','55326c325957746863326b3d','4f5455344e54557a4d6a45794e673d3d','','566d6c796457526f645735685a324679','5647467461577767546d466b64513d3d','NULL','NULL','','NULL','NULL','NULL','','','Sivakasi','','0');

INSERT INTO test_mohan_consignor (id, created_date_time, creator, creator_name, consignor_id, name, address, city, mobile_number, landline_number, district, state, gst_number, identification, bill_company_id, unit_id, unit_name, price_value, opening_balance, opening_balance_type, others_city, cooly_value, deleted) VALUES ('4','2025-07-12 19:03:07','56564e46556c38784d5441334d6a41794e5441354e5445784d6c38774e673d3d','55334a706332396d64486468636d5636','5130394f55306c48546b3953587a45794d4463794d4449314d4463774d7a4133587a4130','545339544c694254556b56464946524953564a565545465553456b67516b464d5155704a','55306c575155744255306b3d','55326c325957746863326b3d','4f5451304d7a67324f4441794d773d3d','','566d6c796457526f645735685a324679','5647467461577767546d466b64513d3d','NULL','NULL','','NULL','NULL','NULL','','','Sivakasi','','0');

INSERT INTO test_mohan_consignor (id, created_date_time, creator, creator_name, consignor_id, name, address, city, mobile_number, landline_number, district, state, gst_number, identification, bill_company_id, unit_id, unit_name, price_value, opening_balance, opening_balance_type, others_city, cooly_value, deleted) VALUES ('5','2025-07-12 19:04:28','56564e46556c38784d5441334d6a41794e5441354e5445784d6c38774e673d3d','55334a706332396d64486468636d5636','5130394f55306c48546b3953587a45794d4463794d4449314d4463774e444934587a4131','545339544c694254556b6b67556b395a5155776756464a425245565355773d3d','55306c575155744255306b3d','55326c325957746863326b3d','4d4451314e6a49794d7a41324e513d3d','','566d6c796457526f645735685a324679','5647467461577767546d466b64513d3d','NULL','NULL','','NULL','NULL','NULL','','','Sivakasi','','0');

INSERT INTO test_mohan_consignor (id, created_date_time, creator, creator_name, consignor_id, name, address, city, mobile_number, landline_number, district, state, gst_number, identification, bill_company_id, unit_id, unit_name, price_value, opening_balance, opening_balance_type, others_city, cooly_value, deleted) VALUES ('6','2025-07-12 19:20:56','56564e46556c38784d5441334d6a41794e5441354e5445784d6c38774e673d3d','55334a706332396d64486468636d5636','5130394f55306c48546b3953587a45794d4463794d4449314d4463794d445532587a4132','545339544c69424852555655534546535155354a49453947526c4e4656434251556b6c4f5645565355773d3d','55306c575155744255306b3d','55326c325957746863326b3d','4f5467304d7a41794e7a63304f513d3d','','566d6c796457526f645735685a324679','5647467461577767546d466b64513d3d','NULL','NULL','','NULL','NULL','NULL','','','Sivakasi','','0');

INSERT INTO test_mohan_consignor (id, created_date_time, creator, creator_name, consignor_id, name, address, city, mobile_number, landline_number, district, state, gst_number, identification, bill_company_id, unit_id, unit_name, price_value, opening_balance, opening_balance_type, others_city, cooly_value, deleted) VALUES ('7','2025-07-12 19:23:00','56564e46556c38784d5441334d6a41794e5441354e5445784d6c38774e673d3d','55334a706332396d64486468636d5636','5130394f55306c48546b3953587a45794d4463794d4449314d4463794d7a4177587a4133','545339544c6942615255354a56456767556c5643516b5653','55306c575155744255306b3d','55326c325957746863326b3d','4f5467304d7a49324d5445794e413d3d','','566d6c796457526f645735685a324679','5647467461577767546d466b64513d3d','NULL','NULL','','NULL','NULL','NULL','','','Sivakasi','','0');

INSERT INTO test_mohan_consignor (id, created_date_time, creator, creator_name, consignor_id, name, address, city, mobile_number, landline_number, district, state, gst_number, identification, bill_company_id, unit_id, unit_name, price_value, opening_balance, opening_balance_type, others_city, cooly_value, deleted) VALUES ('8','2025-07-12 19:25:28','56564e46556c38784d5441334d6a41794e5441354e5445784d6c38774e673d3d','55334a706332396d64486468636d5636','5130394f55306c48546b3953587a45794d4463794d4449314d4463794e544934587a4134','545339544c69425351556f675130465352464d3d','55306c575155744255306b3d','55326c325957746863326b3d','4f5451344e6a6b784d4463784d673d3d','','566d6c796457526f645735685a324679','5647467461577767546d466b64513d3d','NULL','NULL','','NULL','NULL','NULL','','','Sivakasi','','0');

INSERT INTO test_mohan_consignor (id, created_date_time, creator, creator_name, consignor_id, name, address, city, mobile_number, landline_number, district, state, gst_number, identification, bill_company_id, unit_id, unit_name, price_value, opening_balance, opening_balance_type, others_city, cooly_value, deleted) VALUES ('9','2025-07-12 19:28:43','56564e46556c38784d5441334d6a41794e5441354e5445784d6c38774e673d3d','55334a706332396d64486468636d5636','5130394f55306c48546b3953587a45794d4463794d4449314d4463794f44517a587a4135','545339544c6941675530456755464a4a546c5246556c4d3d','55306c575155744255306b3d','55326c325957746863326b3d','4f5467304d7a51344f4441774d513d3d','','566d6c796457526f645735685a324679','5647467461577767546d466b64513d3d','NULL','NULL','','NULL','NULL','NULL','','','Sivakasi','','0');

INSERT INTO test_mohan_consignor (id, created_date_time, creator, creator_name, consignor_id, name, address, city, mobile_number, landline_number, district, state, gst_number, identification, bill_company_id, unit_id, unit_name, price_value, opening_balance, opening_balance_type, others_city, cooly_value, deleted) VALUES ('10','2025-07-14 11:03:59','56564e46556c38784d5441334d6a41794e5441354e5445784d6c38774e673d3d','55334a706332396d64486468636d5636','5130394f55306c48546b3953587a45304d4463794d4449314d5445774d7a5535587a4577','545339544c6942545655354e5430394f49456c4f5246565456464a4a52564d3d','55306c575155744255306b3d','55326c325957746863326b3d','4f5451304d6a59304e4459334e513d3d','','566d6c796457526f645735685a324679','5647467461577767546d466b64513d3d','NULL','NULL','','NULL','NULL','NULL','','','Sivakasi','','0');

INSERT INTO test_mohan_consignor (id, created_date_time, creator, creator_name, consignor_id, name, address, city, mobile_number, landline_number, district, state, gst_number, identification, bill_company_id, unit_id, unit_name, price_value, opening_balance, opening_balance_type, others_city, cooly_value, deleted) VALUES ('11','2025-07-14 11:08:55','56564e46556c38784d5441334d6a41794e5441354e5445784d6c38774e673d3d','55334a706332396d64486468636d5636','5130394f55306c48546b3953587a45304d4463794d4449314d5445774f445531587a4578','545339544c69425151557842546b6c57525577674c53425453565a42553156535755456756464a425245565355773d3d','55306c575155744255306b3d','55326c325957746863326b3d','4f5467304d6a45354f4467354f413d3d','','566d6c796457526f645735685a324679','5647467461577767546d466b64513d3d','NULL','NULL','','NULL','NULL','NULL','','','Sivakasi','','0');

INSERT INTO test_mohan_consignor (id, created_date_time, creator, creator_name, consignor_id, name, address, city, mobile_number, landline_number, district, state, gst_number, identification, bill_company_id, unit_id, unit_name, price_value, opening_balance, opening_balance_type, others_city, cooly_value, deleted) VALUES ('12','2025-07-14 11:11:24','56564e46556c38784d5441334d6a41794e5441354e5445784d6c38774e673d3d','55334a706332396d64486468636d5636','5130394f55306c48546b3953587a45304d4463794d4449314d5445784d544930587a4579','545339544c694256546b6c5749464242513142425130744252305654494368514b53424d5645513d','55306c575155744255306b3d','55326c325957746863326b3d','4f5467304d7a45344e7a45304e513d3d','','566d6c796457526f645735685a324679','5647467461577767546d466b64513d3d','NULL','NULL','','NULL','NULL','NULL','','','Sivakasi','','0');

INSERT INTO test_mohan_consignor (id, created_date_time, creator, creator_name, consignor_id, name, address, city, mobile_number, landline_number, district, state, gst_number, identification, bill_company_id, unit_id, unit_name, price_value, opening_balance, opening_balance_type, others_city, cooly_value, deleted) VALUES ('13','2025-07-14 11:12:58','56564e46556c38784d5441334d6a41794e5441354e5445784d6c38774e673d3d','55334a706332396d64486468636d5636','5130394f55306c48546b3953587a45304d4463794d4449314d5445784d6a5534587a457a','545339544c694253515652495355354254534255556b464552564a54','55306c575155744255306b3d','55326c325957746863326b3d','4f4463314e44637a4d7a59324e673d3d','','566d6c796457526f645735685a324679','5647467461577767546d466b64513d3d','NULL','NULL','','NULL','NULL','NULL','','','Sivakasi','','0');

INSERT INTO test_mohan_consignor (id, created_date_time, creator, creator_name, consignor_id, name, address, city, mobile_number, landline_number, district, state, gst_number, identification, bill_company_id, unit_id, unit_name, price_value, opening_balance, opening_balance_type, others_city, cooly_value, deleted) VALUES ('14','2025-07-14 11:15:41','56564e46556c38784d5441334d6a41794e5441354e5445784d6c38774e673d3d','55334a706332396d64486468636d5636','5130394f55306c48546b3953587a45304d4463794d4449314d5445784e545178587a4530','545339544c69424b5155314655794242556c525449454e5351555a5555773d3d','55306c575155744255306b3d','55326c325957746863326b3d','4d4451314e6a49794e7a67794d413d3d','','566d6c796457526f645735685a324679','5647467461577767546d466b64513d3d','NULL','4d4451314e6a49794e7a67794d44553d','','NULL','NULL','NULL','','','Sivakasi','','0');

INSERT INTO test_mohan_consignor (id, created_date_time, creator, creator_name, consignor_id, name, address, city, mobile_number, landline_number, district, state, gst_number, identification, bill_company_id, unit_id, unit_name, price_value, opening_balance, opening_balance_type, others_city, cooly_value, deleted) VALUES ('15','2025-07-14 11:16:59','56564e46556c38784d5441334d6a41794e5441354e5445784d6c38774e673d3d','55334a706332396d64486468636d5636','5130394f55306c48546b3953587a45304d4463794d4449314d5445784e6a5535587a4531','545339544c694254556b6b67556b464e49455a4a546b556751564a5555773d3d','55306c575155744255306b3d','55326c325957746863326b3d','4f4459324e7a63794e6a63304e773d3d','','566d6c796457526f645735685a324679','5647467461577767546d466b64513d3d','NULL','NULL','','NULL','NULL','NULL','','','Sivakasi','','0');

INSERT INTO test_mohan_consignor (id, created_date_time, creator, creator_name, consignor_id, name, address, city, mobile_number, landline_number, district, state, gst_number, identification, bill_company_id, unit_id, unit_name, price_value, opening_balance, opening_balance_type, others_city, cooly_value, deleted) VALUES ('16','2025-07-14 11:22:48','56564e46556c38784d5441334d6a41794e5441354e5445784d6c38774e673d3d','55334a706332396d64486468636d5636','5130394f55306c48546b3953587a45304d4463794d4449314d5445794d6a5134587a4532','545339544c69424655316442556b6b6755456c44564656535253424e51564a55','55306c575155744255306b3d','55326c325957746863326b3d','4d4451314e6a49794d7a417a4e673d3d','','566d6c796457526f645735685a324679','5647467461577767546d466b64513d3d','NULL','494441304e5459794c54497a4d444d324f513d3d','','NULL','NULL','NULL','','','Sivakasi','','0');

INSERT INTO test_mohan_consignor (id, created_date_time, creator, creator_name, consignor_id, name, address, city, mobile_number, landline_number, district, state, gst_number, identification, bill_company_id, unit_id, unit_name, price_value, opening_balance, opening_balance_type, others_city, cooly_value, deleted) VALUES ('17','2025-07-14 11:24:21','56564e46556c38784d5441334d6a41794e5441354e5445784d6c38774e673d3d','55334a706332396d64486468636d5636','5130394f55306c48546b3953587a45304d4463794d4449314d5445794e444978587a4533','545339544c69424c4c6c4d7555694255556b464552564a54','55306c575155744255306b3d','55326c325957746863326b3d','4f4467794e5459334e6a6b7a4e773d3d','','566d6c796457526f645735685a324679','5647467461577767546d466b64513d3d','NULL','NULL','','NULL','NULL','NULL','','','Sivakasi','','0');

INSERT INTO test_mohan_consignor (id, created_date_time, creator, creator_name, consignor_id, name, address, city, mobile_number, landline_number, district, state, gst_number, identification, bill_company_id, unit_id, unit_name, price_value, opening_balance, opening_balance_type, others_city, cooly_value, deleted) VALUES ('18','2025-07-14 11:26:22','56564e46556c38784d5441334d6a41794e5441354e5445784d6c38774e673d3d','55334a706332396d64486468636d5636','5130394f55306c48546b3953587a45304d4463794d4449314d5445794e6a4979587a4534','54533954494334675530564d4945704652304655','55306c575155744255306b3d','55326c325957746863326b3d','4d4451314e6a49794e5445304d413d3d','','566d6c796457526f645735685a324679','5647467461577767546d466b64513d3d','NULL','494441304e5459794d6a55784e444177','','NULL','NULL','NULL','','','Sivakasi','','0');

INSERT INTO test_mohan_consignor (id, created_date_time, creator, creator_name, consignor_id, name, address, city, mobile_number, landline_number, district, state, gst_number, identification, bill_company_id, unit_id, unit_name, price_value, opening_balance, opening_balance_type, others_city, cooly_value, deleted) VALUES ('19','2025-07-14 11:27:37','56564e46556c38784d5441334d6a41794e5441354e5445784d6c38774e673d3d','55334a706332396d64486468636d5636','5130394f55306c48546b3953587a45304d4463794d4449314d5445794e7a4d33587a4535','545339544c69424e515552425469424451564a455579416d4945465356464d3d','55306c575155744255306b3d','55326c325957746863326b3d','4f5451304d7a4d324d7a4d794f413d3d','','566d6c796457526f645735685a324679','5647467461577767546d466b64513d3d','NULL','NULL','','NULL','NULL','NULL','','','Sivakasi','','0');

INSERT INTO test_mohan_consignor (id, created_date_time, creator, creator_name, consignor_id, name, address, city, mobile_number, landline_number, district, state, gst_number, identification, bill_company_id, unit_id, unit_name, price_value, opening_balance, opening_balance_type, others_city, cooly_value, deleted) VALUES ('20','2025-07-14 11:29:21','56564e46556c38784d5441334d6a41794e5441354e5445784d6c38774e673d3d','55334a706332396d64486468636d5636','5130394f55306c48546b3953587a45304d4463794d4449314d5445794f544978587a4977','5455464f53565a42546b354254673d3d','56456c535656425655673d3d','56476c796458423163673d3d','4f4441334d6a51324e546b304f513d3d','','56476c79645842776458493d','5647467461577767546d466b64513d3d','NULL','NULL','','NULL','NULL','NULL','','','Tirupur','','0');

INSERT INTO test_mohan_consignor (id, created_date_time, creator, creator_name, consignor_id, name, address, city, mobile_number, landline_number, district, state, gst_number, identification, bill_company_id, unit_id, unit_name, price_value, opening_balance, opening_balance_type, others_city, cooly_value, deleted) VALUES ('21','2025-07-14 11:30:41','56564e46556c38784d5441334d6a41794e5441354e5445784d6c38774e673d3d','55334a706332396d64486468636d5636','5130394f55306c48546b3953587a45304d4463794d4449314d54457a4d445178587a4978','545339544c69424c515535455345464f49454e42556b5254','56456c535656425655673d3d','56476c796458423163673d3d','4f4467334d4459774f4459774f513d3d','','56476c79645842776458493d','5647467461577767546d466b64513d3d','NULL','NULL','','NULL','NULL','NULL','','','Tirupur','','0');

INSERT INTO test_mohan_consignor (id, created_date_time, creator, creator_name, consignor_id, name, address, city, mobile_number, landline_number, district, state, gst_number, identification, bill_company_id, unit_id, unit_name, price_value, opening_balance, opening_balance_type, others_city, cooly_value, deleted) VALUES ('22','2025-07-14 11:32:15','56564e46556c38784d5441334d6a41794e5441354e5445784d6c38774e673d3d','55334a706332396d64486468636d5636','5130394f55306c48546b3953587a45304d4463794d4449314d54457a4d6a4531587a4979','545339544c6942485656425551534251556b6c4f5645565355773d3d','55306c575155744255306b3d','55326c325957746863326b3d','4f4463314e4441794e7a41784f413d3d','','566d6c796457526f645735685a324679','5647467461577767546d466b64513d3d','NULL','NULL','','NULL','NULL','NULL','','','Sivakasi','','0');

INSERT INTO test_mohan_consignor (id, created_date_time, creator, creator_name, consignor_id, name, address, city, mobile_number, landline_number, district, state, gst_number, identification, bill_company_id, unit_id, unit_name, price_value, opening_balance, opening_balance_type, others_city, cooly_value, deleted) VALUES ('23','2025-07-14 11:33:58','56564e46556c38784d5441334d6a41794e5441354e5445784d6c38774e673d3d','55334a706332396d64486468636d5636','5130394f55306c48546b3953587a45304d4463794d4449314d54457a4d7a5534587a497a','545339544c69424b5155314a5455456755464a4a546c5246556c4d3d','55306c575155744255306b3d','55326c325957746863326b3d','4f5451304d7a55304e4445774d773d3d','','566d6c796457526f645735685a324679','5647467461577767546d466b64513d3d','NULL','NULL','','NULL','NULL','NULL','','','Sivakasi','','0');

INSERT INTO test_mohan_consignor (id, created_date_time, creator, creator_name, consignor_id, name, address, city, mobile_number, landline_number, district, state, gst_number, identification, bill_company_id, unit_id, unit_name, price_value, opening_balance, opening_balance_type, others_city, cooly_value, deleted) VALUES ('24','2025-07-14 11:37:19','56564e46556c38784d5441334d6a41794e5441354e5445784d6c38774e673d3d','55334a706332396d64486468636d5636','5130394f55306c48546b3953587a45304d4463794d4449314d54457a4e7a4535587a4930','5169354351554a56','55306c575155744255306b3d','55326c325957746863326b3d','4f4467774e7a6b314d54597a4e673d3d','','566d6c796457526f645735685a324679','5647467461577767546d466b64513d3d','NULL','NULL','','NULL','NULL','NULL','','','Sivakasi','','0');

INSERT INTO test_mohan_consignor (id, created_date_time, creator, creator_name, consignor_id, name, address, city, mobile_number, landline_number, district, state, gst_number, identification, bill_company_id, unit_id, unit_name, price_value, opening_balance, opening_balance_type, others_city, cooly_value, deleted) VALUES ('25','2025-07-14 11:40:11','56564e46556c38784d5441334d6a41794e5441354e5445784d6c38774e673d3d','55334a706332396d64486468636d5636','5130394f55306c48546b3953587a45304d4463794d4449314d5445304d444578587a4931','545339544c6942575255784e56564a565230464f49455a4a546b556751564a5555773d3d','56456c535656425655673d3d','56476c796458423163673d3d','4f5467304d7a4d794d6a51774d413d3d','','56476c79645842776458493d','5647467461577767546d466b64513d3d','NULL','NULL','','NULL','NULL','NULL','','','Tirupur','','0');

INSERT INTO test_mohan_consignor (id, created_date_time, creator, creator_name, consignor_id, name, address, city, mobile_number, landline_number, district, state, gst_number, identification, bill_company_id, unit_id, unit_name, price_value, opening_balance, opening_balance_type, others_city, cooly_value, deleted) VALUES ('26','2025-07-14 11:42:50','56564e46556c38784d5441334d6a41794e5441354e5445784d6c38774e673d3d','55334a706332396d64486468636d5636','5130394f55306c48546b3953587a45304d4463794d4449314d5445304d6a5577587a4932','545339544c694251556b464c51564e494945465356464d3d','55306c575155744255306b3d','55326c325957746863326b3d','4f5463314d546b784e5451784d673d3d','','566d6c796457526f645735685a324679','5647467461577767546d466b64513d3d','NULL','NULL','','NULL','NULL','NULL','','','Sivakasi','','0');

INSERT INTO test_mohan_consignor (id, created_date_time, creator, creator_name, consignor_id, name, address, city, mobile_number, landline_number, district, state, gst_number, identification, bill_company_id, unit_id, unit_name, price_value, opening_balance, opening_balance_type, others_city, cooly_value, deleted) VALUES ('27','2025-07-14 11:44:50','56564e46556c38784d5441334d6a41794e5441354e5445784d6c38774e673d3d','55334a706332396d64486468636d5636','5130394f55306c48546b3953587a45304d4463794d4449314d5445304e445577587a4933','545339544c694254556b6b6753314a4a5530684f51534244543078505656493d','55306c575155744255306b3d','55326c325957746863326b3d','4f4459324f4441324e4459774d773d3d','','566d6c796457526f645735685a324679','5647467461577767546d466b64513d3d','NULL','NULL','','NULL','NULL','NULL','','','Sivakasi','','0');

INSERT INTO test_mohan_consignor (id, created_date_time, creator, creator_name, consignor_id, name, address, city, mobile_number, landline_number, district, state, gst_number, identification, bill_company_id, unit_id, unit_name, price_value, opening_balance, opening_balance_type, others_city, cooly_value, deleted) VALUES ('28','2025-07-14 15:35:24','56564e46556c38784e4441334d6a41794e54417a4d7a4d7a4f5638774f413d3d','55334a706332396d64486468636d5636','5130394f55306c48546b3953587a45304d4463794d4449314d444d7a4e544930587a4934','5533567961586c68','NULL','NULL','4f4463344e7a67334f4463334f413d3d','','NULL','5647467461577767546d466b64513d3d','NULL','NULL','','NULL','NULL','NULL','','','','','0');

INSERT INTO test_mohan_consignor (id, created_date_time, creator, creator_name, consignor_id, name, address, city, mobile_number, landline_number, district, state, gst_number, identification, bill_company_id, unit_id, unit_name, price_value, opening_balance, opening_balance_type, others_city, cooly_value, deleted) VALUES ('29','2025-07-14 19:18:24','56564e46556c38784d5441334d6a41794e5441354e5445784d6c38774e673d3d','55334a706332396d64486468636d5636','5130394f55306c48546b3953587a45304d4463794d4449314d4463784f444930587a4935','545339544c69424e5430684254694255556b464f55314250556c513d','56456c535656425655673d3d','56476c796458423163673d3d','4f5451304d7a4d334d6a41304f413d3d','','56476c79645842776458493d','5647467461577767546d466b64513d3d','NULL','NULL','','NULL','NULL','NULL','','','Tirupur','','0');

INSERT INTO test_mohan_consignor (id, created_date_time, creator, creator_name, consignor_id, name, address, city, mobile_number, landline_number, district, state, gst_number, identification, bill_company_id, unit_id, unit_name, price_value, opening_balance, opening_balance_type, others_city, cooly_value, deleted) VALUES ('30','2025-07-14 19:19:40','56564e46556c38784d5441334d6a41794e5441354e5445784d6c38774e673d3d','55334a706332396d64486468636d5636','5130394f55306c48546b3953587a45304d4463794d4449314d4463784f545177587a4d77','545339544c69424e52554e42546b3953494531425130684a546b5654','56456c535656425655673d3d','56476c796458423163673d3d','4f5455344e5455774d5455314d513d3d','','56476c79645842776458493d','5647467461577767546d466b64513d3d','NULL','NULL','','NULL','NULL','NULL','','','Tirupur','','0');

INSERT INTO test_mohan_consignor (id, created_date_time, creator, creator_name, consignor_id, name, address, city, mobile_number, landline_number, district, state, gst_number, identification, bill_company_id, unit_id, unit_name, price_value, opening_balance, opening_balance_type, others_city, cooly_value, deleted) VALUES ('31','2025-07-14 19:21:11','56564e46556c38784d5441334d6a41794e5441354e5445784d6c38774e673d3d','55334a706332396d64486468636d5636','5130394f55306c48546b3953587a45304d4463794d4449314d4463794d544578587a4d78','545339544c6942585355346756464a425245565355773d3d','56456c535656425655673d3d','56476c796458423163673d3d','4f5451304d7a51774f4441784d413d3d','','56476c79645842776458493d','5647467461577767546d466b64513d3d','NULL','NULL','','NULL','NULL','NULL','','','Tirupur','','0');

INSERT INTO test_mohan_consignor (id, created_date_time, creator, creator_name, consignor_id, name, address, city, mobile_number, landline_number, district, state, gst_number, identification, bill_company_id, unit_id, unit_name, price_value, opening_balance, opening_balance_type, others_city, cooly_value, deleted) VALUES ('32','2025-07-14 19:22:12','56564e46556c38784d5441334d6a41794e5441354e5445784d6c38774e673d3d','55334a706332396d64486468636d5636','5130394f55306c48546b3953587a45304d4463794d4449314d4463794d6a4579587a4d79','545339544c69425753564e4253534255525668555355784655773d3d','56456c535656425655673d3d','56476c796458423163673d3d','4f5451304d7a49304e6a49774d673d3d','','56476c79645842776458493d','5647467461577767546d466b64513d3d','NULL','NULL','','NULL','NULL','NULL','','','Tirupur','','0');

INSERT INTO test_mohan_consignor (id, created_date_time, creator, creator_name, consignor_id, name, address, city, mobile_number, landline_number, district, state, gst_number, identification, bill_company_id, unit_id, unit_name, price_value, opening_balance, opening_balance_type, others_city, cooly_value, deleted) VALUES ('33','2025-07-14 20:45:00','56564e46556c38784d5441334d6a41794e5441354e5445784d6c38774e673d3d','55334a706332396d64486468636d5636','5130394f55306c48546b3953587a45304d4463794d4449314d4467304e544177587a4d7a','545339544c69424654457850556b45675531524256456c50546b5653575342514945785552413d3d','55306c575155744255306b3d','55326c325957746863326b3d','4d4451314e6a49794e7a63324e673d3d','','566d6c796457526f645735685a324679','5647467461577767546d466b64513d3d','NULL','4d4451314e6a49794e7a63324e6a453d','','NULL','NULL','NULL','','','Sivakasi','','0');

INSERT INTO test_mohan_consignor (id, created_date_time, creator, creator_name, consignor_id, name, address, city, mobile_number, landline_number, district, state, gst_number, identification, bill_company_id, unit_id, unit_name, price_value, opening_balance, opening_balance_type, others_city, cooly_value, deleted) VALUES ('34','2025-07-14 20:47:22','56564e46556c38784d5441334d6a41794e5441354e5445784d6c38774e673d3d','55334a706332396d64486468636d5636','5130394f55306c48546b3953587a45304d4463794d4449314d4467304e7a4979587a4d30','545339544c6942534c6c417555413d3d','55306c575155744255306b3d','55326c325957746863326b3d','4e7a55354f44597a4f5463354e413d3d','','566d6c796457526f645735685a324679','5647467461577767546d466b64513d3d','NULL','NULL','','NULL','NULL','NULL','','','Sivakasi','','0');

INSERT INTO test_mohan_consignor (id, created_date_time, creator, creator_name, consignor_id, name, address, city, mobile_number, landline_number, district, state, gst_number, identification, bill_company_id, unit_id, unit_name, price_value, opening_balance, opening_balance_type, others_city, cooly_value, deleted) VALUES ('35','2025-07-14 20:53:36','56564e46556c38784d5441334d6a41794e5441354e5445784d6c38774e673d3d','55334a706332396d64486468636d5636','5130394f55306c48546b3953587a45304d4463794d4449314d4467314d7a4d32587a4d31','545339544c69425451555a4a556b556754305a4752564e55494642535355355552564a54','55306c575155744255306b3d','55326c325957746863326b3d','4f5467304d7a41344f446b784e773d3d','','566d6c796457526f645735685a324679','5647467461577767546d466b64513d3d','NULL','NULL','','NULL','NULL','NULL','','','Sivakasi','','0');

INSERT INTO test_mohan_consignor (id, created_date_time, creator, creator_name, consignor_id, name, address, city, mobile_number, landline_number, district, state, gst_number, identification, bill_company_id, unit_id, unit_name, price_value, opening_balance, opening_balance_type, others_city, cooly_value, deleted) VALUES ('36','2025-07-14 22:45:33','56564e46556c38774d513d3d','55334a706332396d64486468636d5636','5130394f55306c48546b3953587a45304d4463794d4449314d5441304e544d7a587a4d32','553246755a326c7361513d3d','NULL','NULL','4e7a4d334d7a67314e6a63334e773d3d','','NULL','5647467461577767546d466b64513d3d','NULL','NULL','','NULL','NULL','NULL','','','','','0');

INSERT INTO test_mohan_consignor (id, created_date_time, creator, creator_name, consignor_id, name, address, city, mobile_number, landline_number, district, state, gst_number, identification, bill_company_id, unit_id, unit_name, price_value, opening_balance, opening_balance_type, others_city, cooly_value, deleted) VALUES ('37','2025-07-15 09:44:49','56564e46556c38774d513d3d','55334a706332396d64486468636d5636','5130394f55306c48546b3953587a45314d4463794d4449314d446b304e445135587a4d33','63326868626d31315a324674','NULL','NULL','4e7a59344e7a67334e6a63324e773d3d','','NULL','5647467461577767546d466b64513d3d','NULL','NULL','','NULL','NULL','NULL','','','','','0');

INSERT INTO test_mohan_consignor (id, created_date_time, creator, creator_name, consignor_id, name, address, city, mobile_number, landline_number, district, state, gst_number, identification, bill_company_id, unit_id, unit_name, price_value, opening_balance, opening_balance_type, others_city, cooly_value, deleted) VALUES ('38','2025-07-15 16:33:30','56564e46556c38784d5441334d6a41794e5441354e5445784d6c38774e673d3d','55334a706332396d64486468636d5636','5130394f55306c48546b3953587a45314d4463794d4449314d44517a4d7a4d77587a4d34','546b464851564a42536b464f','55306c575155744255306b3d','55326c325957746863326b3d','4f5451304d7a4d334e546b304e413d3d','','566d6c796457526f645735685a324679','5647467461577767546d466b64513d3d','NULL','NULL','','NULL','NULL','NULL','','','Sivakasi','','0');

INSERT INTO test_mohan_consignor (id, created_date_time, creator, creator_name, consignor_id, name, address, city, mobile_number, landline_number, district, state, gst_number, identification, bill_company_id, unit_id, unit_name, price_value, opening_balance, opening_balance_type, others_city, cooly_value, deleted) VALUES ('39','2025-07-15 16:35:42','56564e46556c38784d5441334d6a41794e5441354e5445784d6c38774e673d3d','55334a706332396d64486468636d5636','5130394f55306c48546b3953587a45314d4463794d4449314d44517a4e545179587a4d35','545339544c694251556b464c51564e4949455a4a546b556751564a5555773d3d','55306c575155744255306b3d','55326c325957746863326b3d','4f5467304d6a67354f4459324d513d3d','','566d6c796457526f645735685a324679','5647467461577767546d466b64513d3d','NULL','NULL','','NULL','NULL','NULL','','','Sivakasi','','0');

INSERT INTO test_mohan_consignor (id, created_date_time, creator, creator_name, consignor_id, name, address, city, mobile_number, landline_number, district, state, gst_number, identification, bill_company_id, unit_id, unit_name, price_value, opening_balance, opening_balance_type, others_city, cooly_value, deleted) VALUES ('40','2025-07-15 16:42:04','56564e46556c38784d5441334d6a41794e5441354e5445784d6c38774e673d3d','55334a706332396d64486468636d5636','5130394f55306c48546b3953587a45314d4463794d4449314d4451304d6a4130587a5177','545339544c694254556b6b675545394f4946425054466c4e52564a54','55306c575155744255306b3d','55326c325957746863326b3d','4f5455324e6a637a4e4451334f513d3d','','566d6c796457526f645735685a324679','5647467461577767546d466b64513d3d','NULL','NULL','','NULL','NULL','NULL','','','Sivakasi','','0');

INSERT INTO test_mohan_consignor (id, created_date_time, creator, creator_name, consignor_id, name, address, city, mobile_number, landline_number, district, state, gst_number, identification, bill_company_id, unit_id, unit_name, price_value, opening_balance, opening_balance_type, others_city, cooly_value, deleted) VALUES ('41','2025-07-15 16:45:46','56564e46556c38784d5441334d6a41794e5441354e5445784d6c38774e673d3d','55334a706332396d64486468636d5636','5130394f55306c48546b3953587a45314d4463794d4449314d4451304e545132587a5178','545339544c69424b5155354253306b6755464a4a546c5246556c4d3d','55306c575155744255306b3d','55326c325957746863326b3d','4f5449304e5445304d4441314f413d3d','','566d6c796457526f645735685a324679','5647467461577767546d466b64513d3d','NULL','NULL','','NULL','NULL','NULL','','','Sivakasi','','0');

INSERT INTO test_mohan_consignor (id, created_date_time, creator, creator_name, consignor_id, name, address, city, mobile_number, landline_number, district, state, gst_number, identification, bill_company_id, unit_id, unit_name, price_value, opening_balance, opening_balance_type, others_city, cooly_value, deleted) VALUES ('42','2025-07-15 16:47:14','56564e46556c38784d5441334d6a41794e5441354e5445784d6c38774e673d3d','55334a706332396d64486468636d5636','5130394f55306c48546b3953587a45314d4463794d4449314d4451304e7a4530587a5179','545339544c6942534c69424c4c694255556b464552564a54','55306c575155744255306b3d','55326c325957746863326b3d','4f5441304d7a51314f5459304d413d3d','','566d6c796457526f645735685a324679','5647467461577767546d466b64513d3d','NULL','NULL','','NULL','NULL','NULL','','','Sivakasi','','0');

INSERT INTO test_mohan_consignor (id, created_date_time, creator, creator_name, consignor_id, name, address, city, mobile_number, landline_number, district, state, gst_number, identification, bill_company_id, unit_id, unit_name, price_value, opening_balance, opening_balance_type, others_city, cooly_value, deleted) VALUES ('43','2025-07-15 16:48:26','56564e46556c38784d5441334d6a41794e5441354e5445784d6c38774e673d3d','55334a706332396d64486468636d5636','5130394f55306c48546b3953587a45314d4463794d4449314d4451304f444932587a517a','545339544c69424852555655534545675445464e5355354256456c5054673d3d','55306c575155744255306b3d','55326c325957746863326b3d','4f5451304d7a45324e4459304e513d3d','','566d6c796457526f645735685a324679','5647467461577767546d466b64513d3d','NULL','NULL','','NULL','NULL','NULL','','','Sivakasi','','0');

INSERT INTO test_mohan_consignor (id, created_date_time, creator, creator_name, consignor_id, name, address, city, mobile_number, landline_number, district, state, gst_number, identification, bill_company_id, unit_id, unit_name, price_value, opening_balance, opening_balance_type, others_city, cooly_value, deleted) VALUES ('44','2025-07-15 16:50:41','56564e46556c38784d5441334d6a41794e5441354e5445784d6c38774e673d3d','55334a706332396d64486468636d5636','5130394f55306c48546b3953587a45314d4463794d4449314d4451314d445178587a5130','545339544c69424257566c42546b4653494652535155524a546b63675130394e5545464f57513d3d','55306c575155744255306b3d','55326c325957746863326b3d','4f5451304d7a4d334e7a55334f413d3d','','566d6c796457526f645735685a324679','5647467461577767546d466b64513d3d','NULL','NULL','','NULL','NULL','NULL','','','Sivakasi','','0');

INSERT INTO test_mohan_consignor (id, created_date_time, creator, creator_name, consignor_id, name, address, city, mobile_number, landline_number, district, state, gst_number, identification, bill_company_id, unit_id, unit_name, price_value, opening_balance, opening_balance_type, others_city, cooly_value, deleted) VALUES ('45','2025-07-15 16:55:13','56564e46556c38784d5441334d6a41794e5441354e5445784d6c38774e673d3d','55334a706332396d64486468636d5636','5130394f55306c48546b3953587a45314d4463794d4449314d4451314e54457a587a5131','545339544c694254556b6b67546b464f52456842546b456756464a425245565355773d3d','55306c575155744255306b3d','55326c325957746863326b3d','4f5451304d6a45784e5463774f413d3d','','566d6c796457526f645735685a324679','5647467461577767546d466b64513d3d','NULL','NULL','','NULL','NULL','NULL','','','Sivakasi','','0');

INSERT INTO test_mohan_consignor (id, created_date_time, creator, creator_name, consignor_id, name, address, city, mobile_number, landline_number, district, state, gst_number, identification, bill_company_id, unit_id, unit_name, price_value, opening_balance, opening_balance_type, others_city, cooly_value, deleted) VALUES ('46','2025-07-15 16:57:30','56564e46556c38784d5441334d6a41794e5441354e5445784d6c38774e673d3d','55334a706332396d64486468636d5636','5130394f55306c48546b3953587a45314d4463794d4449314d4451314e7a4d77587a5132','545339544c694242553068505379424451564a455579416d4945465356464d3d','55306c575155744255306b3d','55326c325957746863326b3d','4f5451304d6a51784f54457a4d673d3d','','566d6c796457526f645735685a324679','5647467461577767546d466b64513d3d','NULL','NULL','','NULL','NULL','NULL','','','Sivakasi','','0');

INSERT INTO test_mohan_consignor (id, created_date_time, creator, creator_name, consignor_id, name, address, city, mobile_number, landline_number, district, state, gst_number, identification, bill_company_id, unit_id, unit_name, price_value, opening_balance, opening_balance_type, others_city, cooly_value, deleted) VALUES ('47','2025-07-15 16:59:01','56564e46556c38784d5441334d6a41794e5441354e5445784d6c38774e673d3d','55334a706332396d64486468636d5636','5130394f55306c48546b3953587a45314d4463794d4449314d4451314f544178587a5133','545339544c694242545531425469424451564a4555773d3d','55306c575155744255306b3d','55326c325957746863326b3d','4f5451304d6a41314f5449774f513d3d','','566d6c796457526f645735685a324679','5647467461577767546d466b64513d3d','NULL','NULL','','NULL','NULL','NULL','','','Sivakasi','','0');

INSERT INTO test_mohan_consignor (id, created_date_time, creator, creator_name, consignor_id, name, address, city, mobile_number, landline_number, district, state, gst_number, identification, bill_company_id, unit_id, unit_name, price_value, opening_balance, opening_balance_type, others_city, cooly_value, deleted) VALUES ('48','2025-07-15 17:00:28','56564e46556c38784d5441334d6a41794e5441354e5445784d6c38774e673d3d','55334a706332396d64486468636d5636','5130394f55306c48546b3953587a45314d4463794d4449314d4455774d444934587a5134','545339544c694251556b6c4f56455659','55306c575155744255306b3d','55326c325957746863326b3d','4f5467304d7a41794d5445304f413d3d','','566d6c796457526f645735685a324679','5647467461577767546d466b64513d3d','NULL','NULL','','NULL','NULL','NULL','','','Sivakasi','','0');

INSERT INTO test_mohan_consignor (id, created_date_time, creator, creator_name, consignor_id, name, address, city, mobile_number, landline_number, district, state, gst_number, identification, bill_company_id, unit_id, unit_name, price_value, opening_balance, opening_balance_type, others_city, cooly_value, deleted) VALUES ('49','2025-07-15 19:30:07','56564e46556c38774d513d3d','55334a706332396d64486468636d5636','5130394f55306c48546b3953587a45314d4463794d4449314d44637a4d444133587a5135','545339544c69424c556c416755464a4a546c51675545464453773d3d','55306c575155744255306b3d','55326c325957746863326b3d','4f5451304d6a49314e4449784e413d3d','','566d6c796457526f645735685a324679','5647467461577767546d466b64513d3d','NULL','NULL','','NULL','NULL','NULL','','','Sivakasi','','0');

INSERT INTO test_mohan_consignor (id, created_date_time, creator, creator_name, consignor_id, name, address, city, mobile_number, landline_number, district, state, gst_number, identification, bill_company_id, unit_id, unit_name, price_value, opening_balance, opening_balance_type, others_city, cooly_value, deleted) VALUES ('50','2025-07-15 19:31:47','56564e46556c38774d513d3d','55334a706332396d64486468636d5636','5130394f55306c48546b3953587a45314d4463794d4449314d44637a4d545133587a5577','545339544c694254556b6b675455465353566c425546424254694251556b6c4f56456c4f52794251556b565455773d3d','55306c575155744255306b3d','55326c325957746863326b3d','4f5451304d6a55794f5445324d413d3d','','566d6c796457526f645735685a324679','5647467461577767546d466b64513d3d','NULL','NULL','','NULL','NULL','NULL','','','Sivakasi','','0');

INSERT INTO test_mohan_consignor (id, created_date_time, creator, creator_name, consignor_id, name, address, city, mobile_number, landline_number, district, state, gst_number, identification, bill_company_id, unit_id, unit_name, price_value, opening_balance, opening_balance_type, others_city, cooly_value, deleted) VALUES ('51','2025-07-15 19:36:11','56564e46556c38774d513d3d','55334a706332396d64486468636d5636','5130394f55306c48546b3953587a45314d4463794d4449314d44637a4e6a4578587a5578','545339544c694256546b6c52565555675545394d57553146556c6f3d','55306c575155744255306b3d','55326c325957746863326b3d','4f4467334d446b7a4d4459334f513d3d','','566d6c796457526f645735685a324679','5647467461577767546d466b64513d3d','NULL','NULL','','NULL','NULL','NULL','','','Sivakasi','','0');

INSERT INTO test_mohan_consignor (id, created_date_time, creator, creator_name, consignor_id, name, address, city, mobile_number, landline_number, district, state, gst_number, identification, bill_company_id, unit_id, unit_name, price_value, opening_balance, opening_balance_type, others_city, cooly_value, deleted) VALUES ('52','2025-07-15 19:38:28','56564e46556c38774d513d3d','55334a706332396d64486468636d5636','5130394f55306c48546b3953587a45314d4463794d4449314d44637a4f444934587a5579','545339544c69425451564a42566b464f5153424454307850565649675130394e5545464f57513d3d','55306c575155744255306b3d','55326c325957746863326b3d','4d4451314e6a49794d6a4d314d673d3d','','566d6c796457526f645735685a324679','5647467461577767546d466b64513d3d','NULL','4d4451314e6a49794d6a4d314d6a553d','','NULL','NULL','NULL','','','Sivakasi','','0');

INSERT INTO test_mohan_consignor (id, created_date_time, creator, creator_name, consignor_id, name, address, city, mobile_number, landline_number, district, state, gst_number, identification, bill_company_id, unit_id, unit_name, price_value, opening_balance, opening_balance_type, others_city, cooly_value, deleted) VALUES ('53','2025-07-15 19:41:52','56564e46556c38774d513d3d','55334a706332396d64486468636d5636','5130394f55306c48546b3953587a45314d4463794d4449314d4463304d545579587a557a','545339544c6942545346564f54565648534545675255355552564a51556b6c5452564d3d','55306c575155744255306b3d','55326c325957746863326b3d','4f4445794d6a6b314e7a677a4e673d3d','','566d6c796457526f645735685a324679','5647467461577767546d466b64513d3d','NULL','NULL','','NULL','NULL','NULL','','','Sivakasi','','0');

INSERT INTO test_mohan_consignor (id, created_date_time, creator, creator_name, consignor_id, name, address, city, mobile_number, landline_number, district, state, gst_number, identification, bill_company_id, unit_id, unit_name, price_value, opening_balance, opening_balance_type, others_city, cooly_value, deleted) VALUES ('54','2025-07-15 19:44:00','56564e46556c38774d513d3d','55334a706332396d64486468636d5636','5130394f55306c48546b3953587a45314d4463794d4449314d4463304e444177587a5530','5230464f52564e4254673d3d','55306c575155744255306b3d','55326c325957746863326b3d','4f5467304d6a45304e446b354e673d3d','','566d6c796457526f645735685a324679','5647467461577767546d466b64513d3d','NULL','NULL','','NULL','NULL','NULL','','','Sivakasi','','0');

INSERT INTO test_mohan_consignor (id, created_date_time, creator, creator_name, consignor_id, name, address, city, mobile_number, landline_number, district, state, gst_number, identification, bill_company_id, unit_id, unit_name, price_value, opening_balance, opening_balance_type, others_city, cooly_value, deleted) VALUES ('55','2025-07-15 19:47:12','56564e46556c38774d513d3d','55334a706332396d64486468636d5636','5130394f55306c48546b3953587a45314d4463794d4449314d4463304e7a4579587a5531','545339544c694248544539535753424753553546494642425545565355773d3d','55306c575155744255306b3d','55326c325957746863326b3d','4d4451314e6a49794d6a4d7a4e413d3d','','566d6c796457526f645735685a324679','5647467461577767546d466b64513d3d','NULL','4d4451314e6a49794d6a4d7a4e44513d','','NULL','NULL','NULL','','','Sivakasi','','0');

INSERT INTO test_mohan_consignor (id, created_date_time, creator, creator_name, consignor_id, name, address, city, mobile_number, landline_number, district, state, gst_number, identification, bill_company_id, unit_id, unit_name, price_value, opening_balance, opening_balance_type, others_city, cooly_value, deleted) VALUES ('56','2025-07-15 19:49:03','56564e46556c38774d513d3d','55334a706332396d64486468636d5636','5130394f55306c48546b3953587a45314d4463794d4449314d4463304f54417a587a5532','55464a4652553554','55306c575155744255306b3d','55326c325957746863326b3d','4f5445314f544d314d7a457a4e413d3d','','566d6c796457526f645735685a324679','5647467461577767546d466b64513d3d','NULL','NULL','','NULL','NULL','NULL','','','Sivakasi','','0');

INSERT INTO test_mohan_consignor (id, created_date_time, creator, creator_name, consignor_id, name, address, city, mobile_number, landline_number, district, state, gst_number, identification, bill_company_id, unit_id, unit_name, price_value, opening_balance, opening_balance_type, others_city, cooly_value, deleted) VALUES ('57','2025-07-15 19:51:25','56564e46556c38774d513d3d','55334a706332396d64486468636d5636','5130394f55306c48546b3953587a45314d4463794d4449314d4463314d544931587a5533','545339544c69424252314d3d','55306c575155744255306b3d','55326c325957746863326b3d','4f5467304d7a59324e6a41774f413d3d','','566d6c796457526f645735685a324679','5647467461577767546d466b64513d3d','NULL','NULL','','NULL','NULL','NULL','','','Sivakasi','','0');

INSERT INTO test_mohan_consignor (id, created_date_time, creator, creator_name, consignor_id, name, address, city, mobile_number, landline_number, district, state, gst_number, identification, bill_company_id, unit_id, unit_name, price_value, opening_balance, opening_balance_type, others_city, cooly_value, deleted) VALUES ('58','2025-07-15 20:09:30','56564e46556c38774d513d3d','55334a706332396d64486468636d5636','5130394f55306c48546b3953587a45314d4463794d4449314d4467774f544d77587a5534','51564a565443424e5155354a','55306c575155744255306b3d','55326c325957746863326b3d','4f5451304d7a63794e4459794e773d3d','','566d6c796457526f645735685a324679','5647467461577767546d466b64513d3d','NULL','NULL','','NULL','NULL','NULL','','','Sivakasi','','0');

INSERT INTO test_mohan_consignor (id, created_date_time, creator, creator_name, consignor_id, name, address, city, mobile_number, landline_number, district, state, gst_number, identification, bill_company_id, unit_id, unit_name, price_value, opening_balance, opening_balance_type, others_city, cooly_value, deleted) VALUES ('59','2025-07-15 20:13:11','56564e46556c38774d513d3d','55334a706332396d64486468636d5636','5130394f55306c48546b3953587a45314d4463794d4449314d4467784d7a4578587a5535','545339544c69425453456c4f525342515430785a54555653','55306c575155744255306b3d','55326c325957746863326b3d','4f5459314e5455334e444d324f513d3d','','566d6c796457526f645735685a324679','5647467461577767546d466b64513d3d','NULL','NULL','','NULL','NULL','NULL','','','Sivakasi','','0');

INSERT INTO test_mohan_consignor (id, created_date_time, creator, creator_name, consignor_id, name, address, city, mobile_number, landline_number, district, state, gst_number, identification, bill_company_id, unit_id, unit_name, price_value, opening_balance, opening_balance_type, others_city, cooly_value, deleted) VALUES ('60','2025-07-16 12:57:47','56564e46556c38774d513d3d','55334a706332396d64486468636d5636','5130394f55306c48546b3953587a45324d4463794d4449314d5449314e7a5133587a5977','545339544c69424655316442556b6b67526b6c4f52534242556c52544945645351555a55','55306c575155744255306b3d','55326c325957746863326b3d','4e7a55354f4445334e6a4d324f513d3d','','566d6c796457526f645735685a324679','5647467461577767546d466b64513d3d','NULL','NULL','','NULL','NULL','NULL','','','Sivakasi','','0');

INSERT INTO test_mohan_consignor (id, created_date_time, creator, creator_name, consignor_id, name, address, city, mobile_number, landline_number, district, state, gst_number, identification, bill_company_id, unit_id, unit_name, price_value, opening_balance, opening_balance_type, others_city, cooly_value, deleted) VALUES ('61','2025-07-16 13:01:45','56564e46556c38774d513d3d','55334a706332396d64486468636d5636','5130394f55306c48546b3953587a45324d4463794d4449314d4445774d545131587a5978','545339544c69425752555249535574424945564f56455651556b6c5452564d3d','55306c575155744255306b3d','55326c325957746863326b3d','4f5451304d7a51314e5467784d513d3d','','566d6c796457526f645735685a324679','5647467461577767546d466b64513d3d','NULL','NULL','','NULL','NULL','NULL','','','Sivakasi','','0');

INSERT INTO test_mohan_consignor (id, created_date_time, creator, creator_name, consignor_id, name, address, city, mobile_number, landline_number, district, state, gst_number, identification, bill_company_id, unit_id, unit_name, price_value, opening_balance, opening_balance_type, others_city, cooly_value, deleted) VALUES ('62','2025-07-16 13:03:04','56564e46556c38774d513d3d','55334a706332396d64486468636d5636','5130394f55306c48546b3953587a45324d4463794d4449314d4445774d7a4130587a5979','545339544c694254556b6b67536b565a515342545155745553456b675545394d57534251556b6c4f5645565355773d3d','55306c575155744255306b3d','55326c325957746863326b3d','4f5455774d444d354e6a63324e513d3d','','566d6c796457526f645735685a324679','5647467461577767546d466b64513d3d','NULL','NULL','','NULL','NULL','NULL','','','Sivakasi','','0');

INSERT INTO test_mohan_consignor (id, created_date_time, creator, creator_name, consignor_id, name, address, city, mobile_number, landline_number, district, state, gst_number, identification, bill_company_id, unit_id, unit_name, price_value, opening_balance, opening_balance_type, others_city, cooly_value, deleted) VALUES ('63','2025-07-16 13:07:30','56564e46556c38774d513d3d','55334a706332396d64486468636d5636','5130394f55306c48546b3953587a45324d4463794d4449314d4445774e7a4d77587a597a','545339544c69424e5255564f5155745453456b674a69424454773d3d','56456c535656425655673d3d','56476c796458423163673d3d','4f5441304e7a417a4e6a49794d513d3d','','56476c79645842776458493d','5647467461577767546d466b64513d3d','NULL','NULL','','NULL','NULL','NULL','','','Tirupur','','0');

INSERT INTO test_mohan_consignor (id, created_date_time, creator, creator_name, consignor_id, name, address, city, mobile_number, landline_number, district, state, gst_number, identification, bill_company_id, unit_id, unit_name, price_value, opening_balance, opening_balance_type, others_city, cooly_value, deleted) VALUES ('64','2025-07-16 13:12:05','56564e46556c38774d513d3d','55334a706332396d64486468636d5636','5130394f55306c48546b3953587a45324d4463794d4449314d4445784d6a4131587a5930','545339544c694254556b6b6755464a4a5755456756564e4951534248543031425645684a49465a425445784a','55306c575155744255306b3d','55326c325957746863326b3d','4f5459314e5455324f4441794e513d3d','','566d6c796457526f645735685a324679','5647467461577767546d466b64513d3d','NULL','NULL','','NULL','NULL','NULL','','','Sivakasi','','0');

INSERT INTO test_mohan_consignor (id, created_date_time, creator, creator_name, consignor_id, name, address, city, mobile_number, landline_number, district, state, gst_number, identification, bill_company_id, unit_id, unit_name, price_value, opening_balance, opening_balance_type, others_city, cooly_value, deleted) VALUES ('65','2025-07-16 15:56:02','56564e46556c38774d513d3d','55334a706332396d64486468636d5636','5130394f55306c48546b3953587a45324d4463794d4449314d444d314e6a4179587a5931','556b464e5331564e5156493d','56456c535656425655673d3d','56476c796458423163673d3d','4f5467344e4449354e544d314d513d3d','','56476c79645842776458493d','5647467461577767546d466b64513d3d','NULL','NULL','','NULL','NULL','NULL','','','Tirupur','','0');

INSERT INTO test_mohan_consignor (id, created_date_time, creator, creator_name, consignor_id, name, address, city, mobile_number, landline_number, district, state, gst_number, identification, bill_company_id, unit_id, unit_name, price_value, opening_balance, opening_balance_type, others_city, cooly_value, deleted) VALUES ('66','2025-07-16 15:57:30','56564e46556c38774d513d3d','55334a706332396d64486468636d5636','5130394f55306c48546b3953587a45324d4463794d4449314d444d314e7a4d77587a5932','545339544c694254556b6b67516b464d5155704a','55306c575155744255306b3d','55326c325957746863326b3d','4f5467304d7a45784d7a4d784d773d3d','','566d6c796457526f645735685a324679','5647467461577767546d466b64513d3d','NULL','NULL','','NULL','NULL','NULL','','','Sivakasi','','0');

INSERT INTO test_mohan_consignor (id, created_date_time, creator, creator_name, consignor_id, name, address, city, mobile_number, landline_number, district, state, gst_number, identification, bill_company_id, unit_id, unit_name, price_value, opening_balance, opening_balance_type, others_city, cooly_value, deleted) VALUES ('67','2025-07-16 16:00:47','56564e46556c38774d513d3d','55334a706332396d64486468636d5636','5130394f55306c48546b3953587a45324d4463794d4449314d4451774d445133587a5933','545339544c69425453464a4652534254556b6c4f53565a425530456755464a4a546c516d494642425130733d','55306c575155744255306b3d','55326c325957746863326b3d','4f5451304d6a55774e5445354f513d3d','','566d6c796457526f645735685a324679','5647467461577767546d466b64513d3d','NULL','NULL','','NULL','NULL','NULL','','','Sivakasi','','0');

INSERT INTO test_mohan_consignor (id, created_date_time, creator, creator_name, consignor_id, name, address, city, mobile_number, landline_number, district, state, gst_number, identification, bill_company_id, unit_id, unit_name, price_value, opening_balance, opening_balance_type, others_city, cooly_value, deleted) VALUES ('68','2025-07-16 16:02:12','56564e46556c38774d513d3d','55334a706332396d64486468636d5636','5130394f55306c48546b3953587a45324d4463794d4449314d4451774d6a4579587a5934','545339544c6942425531644a54694251556b6c4f5645565355773d3d','55306c575155744255306b3d','55326c325957746863326b3d','4f5451304d6a497a4d544d314d513d3d','','566d6c796457526f645735685a324679','5647467461577767546d466b64513d3d','NULL','NULL','','NULL','NULL','NULL','','','Sivakasi','','0');

INSERT INTO test_mohan_consignor (id, created_date_time, creator, creator_name, consignor_id, name, address, city, mobile_number, landline_number, district, state, gst_number, identification, bill_company_id, unit_id, unit_name, price_value, opening_balance, opening_balance_type, others_city, cooly_value, deleted) VALUES ('69','2025-07-16 16:05:29','56564e46556c38774d513d3d','55334a706332396d64486468636d5636','5130394f55306c48546b3953587a45324d4463794d4449314d4451774e544935587a5935','545339544c694254556b6b67556b46425455704a494642425545565349454a4252314d3d','55306c575155744255306b3d','55326c325957746863326b3d','4f544d324d4467314f4467344e513d3d','','566d6c796457526f645735685a324679','5647467461577767546d466b64513d3d','NULL','NULL','','NULL','NULL','NULL','','','Sivakasi','','0');

INSERT INTO test_mohan_consignor (id, created_date_time, creator, creator_name, consignor_id, name, address, city, mobile_number, landline_number, district, state, gst_number, identification, bill_company_id, unit_id, unit_name, price_value, opening_balance, opening_balance_type, others_city, cooly_value, deleted) VALUES ('70','2025-07-16 16:07:47','56564e46556c38774d513d3d','55334a706332396d64486468636d5636','5130394f55306c48546b3953587a45324d4463794d4449314d4451774e7a5133587a6377','545339544c69424951564a5453454642494642535355355555773d3d','55306c575155744255306b3d','55326c325957746863326b3d','4f5451304d6a49334e6a63774e773d3d','','566d6c796457526f645735685a324679','5647467461577767546d466b64513d3d','NULL','NULL','','NULL','NULL','NULL','','','Sivakasi','','0');

INSERT INTO test_mohan_consignor (id, created_date_time, creator, creator_name, consignor_id, name, address, city, mobile_number, landline_number, district, state, gst_number, identification, bill_company_id, unit_id, unit_name, price_value, opening_balance, opening_balance_type, others_city, cooly_value, deleted) VALUES ('71','2025-07-16 16:11:08','56564e46556c38774d513d3d','55334a706332396d64486468636d5636','5130394f55306c48546b3953587a45324d4463794d4449314d4451784d544134587a6378','5155314e5155343d','55306c575155744255306b3d','55326c325957746863326b3d','4e7a41354e4451334e5463774f513d3d','','566d6c796457526f645735685a324679','5647467461577767546d466b64513d3d','NULL','NULL','','NULL','NULL','NULL','','','Sivakasi','','0');

INSERT INTO test_mohan_consignor (id, created_date_time, creator, creator_name, consignor_id, name, address, city, mobile_number, landline_number, district, state, gst_number, identification, bill_company_id, unit_id, unit_name, price_value, opening_balance, opening_balance_type, others_city, cooly_value, deleted) VALUES ('72','2025-07-16 16:13:12','56564e46556c38774d513d3d','55334a706332396d64486468636d5636','5130394f55306c48546b3953587a45324d4463794d4449314d4451784d7a4579587a6379','556b464e52564e49','56456c53565642565569417449454e4a56466b675245564d53565a46556c6b3d','56476c796458423163673d3d','4f446b794e5459794f446b354f513d3d','','56476c79645842776458493d','5647467461577767546d466b64513d3d','NULL','NULL','','NULL','NULL','NULL','','','Tirupur','','0');

INSERT INTO test_mohan_consignor (id, created_date_time, creator, creator_name, consignor_id, name, address, city, mobile_number, landline_number, district, state, gst_number, identification, bill_company_id, unit_id, unit_name, price_value, opening_balance, opening_balance_type, others_city, cooly_value, deleted) VALUES ('73','2025-07-16 16:16:44','56564e46556c38774d513d3d','55334a706332396d64486468636d5636','5130394f55306c48546b3953587a45324d4463794d4449314d4451784e6a5130587a637a','545339544c694254556b6b675530464c5645684a49455a4a546b556751564a5555773d3d','55306c575155744255306b3d','55326c325957746863326b3d','4f5467304d7a41794d6a63314e673d3d','','566d6c796457526f645735685a324679','5647467461577767546d466b64513d3d','NULL','NULL','','NULL','NULL','NULL','','','Sivakasi','','0');

INSERT INTO test_mohan_consignor (id, created_date_time, creator, creator_name, consignor_id, name, address, city, mobile_number, landline_number, district, state, gst_number, identification, bill_company_id, unit_id, unit_name, price_value, opening_balance, opening_balance_type, others_city, cooly_value, deleted) VALUES ('74','2025-07-16 16:23:35','56564e46556c38774d513d3d','55334a706332396d64486468636d5636','5130394f55306c48546b3953587a45324d4463794d4449314d4451794d7a4d31587a6330','516b464d51553156556c56485155343d','52456842556b465156564a4254513d3d','52476868636d467764584a6862513d3d','4e6a4d344d6a4d774d7a417a4d773d3d','','56476c79645842776458493d','5647467461577767546d466b64513d3d','NULL','NULL','','NULL','NULL','NULL','','','Dharapuram','','0');

INSERT INTO test_mohan_consignor (id, created_date_time, creator, creator_name, consignor_id, name, address, city, mobile_number, landline_number, district, state, gst_number, identification, bill_company_id, unit_id, unit_name, price_value, opening_balance, opening_balance_type, others_city, cooly_value, deleted) VALUES ('75','2025-07-16 16:25:38','56564e46556c38774d513d3d','55334a706332396d64486468636d5636','5130394f55306c48546b3953587a45324d4463794d4449314d4451794e544d34587a6331','545339544c694242556c564f494546485255354453555654','55306c575155744255306b3d','55326c325957746863326b3d','4f5451304d6a49304f4459304d513d3d','','566d6c796457526f645735685a324679','5647467461577767546d466b64513d3d','NULL','NULL','','NULL','NULL','NULL','','','Sivakasi','','0');

INSERT INTO test_mohan_consignor (id, created_date_time, creator, creator_name, consignor_id, name, address, city, mobile_number, landline_number, district, state, gst_number, identification, bill_company_id, unit_id, unit_name, price_value, opening_balance, opening_balance_type, others_city, cooly_value, deleted) VALUES ('76','2025-07-16 16:31:54','56564e46556c38774d513d3d','55334a706332396d64486468636d5636','5130394f55306c48546b3953587a45324d4463794d4449314d44517a4d545530587a6332','545339544c694248556b564654694247535535464945465356464d3d','55306c575155744255306b3d','55326c325957746863326b3d','4f5455344e5455784d4467324d413d3d','','566d6c796457526f645735685a324679','5647467461577767546d466b64513d3d','NULL','NULL','','NULL','NULL','NULL','','','Sivakasi','','0');

INSERT INTO test_mohan_consignor (id, created_date_time, creator, creator_name, consignor_id, name, address, city, mobile_number, landline_number, district, state, gst_number, identification, bill_company_id, unit_id, unit_name, price_value, opening_balance, opening_balance_type, others_city, cooly_value, deleted) VALUES ('77','2025-07-16 16:33:51','56564e46556c38774d513d3d','55334a706332396d64486468636d5636','5130394f55306c48546b3953587a45324d4463794d4449314d44517a4d7a5578587a6333','545339544c694254556b6b675530684a566b464e49454e505445395655694251556b6c4f5645565355773d3d','55306c575155744255306b3d','55326c325957746863326b3d','4f5455774d444d774d4459794d773d3d','','566d6c796457526f645735685a324679','5647467461577767546d466b64513d3d','NULL','NULL','','NULL','NULL','NULL','','','Sivakasi','','0');

INSERT INTO test_mohan_consignor (id, created_date_time, creator, creator_name, consignor_id, name, address, city, mobile_number, landline_number, district, state, gst_number, identification, bill_company_id, unit_id, unit_name, price_value, opening_balance, opening_balance_type, others_city, cooly_value, deleted) VALUES ('78','2025-07-16 16:36:45','56564e46556c38774d513d3d','55334a706332396d64486468636d5636','5130394f55306c48546b3953587a45324d4463794d4449314d44517a4e6a5131587a6334','545339544c694167553141675156425151564a4654464d6754456c4e5356524652413d3d','55306c575155744255306b3d','55326c325957746863326b3d','4e7a4d7a4f544d7a4e444d344d673d3d','','566d6c796457526f645735685a324679','5647467461577767546d466b64513d3d','NULL','NULL','','NULL','NULL','NULL','','','Sivakasi','','0');

INSERT INTO test_mohan_consignor (id, created_date_time, creator, creator_name, consignor_id, name, address, city, mobile_number, landline_number, district, state, gst_number, identification, bill_company_id, unit_id, unit_name, price_value, opening_balance, opening_balance_type, others_city, cooly_value, deleted) VALUES ('79','2025-07-16 16:40:36','56564e46556c38774d513d3d','55334a706332396d64486468636d5636','5130394f55306c48546b3953587a45324d4463794d4449314d4451304d444d32587a6335','545339544c694242516b684a556b464e53534255556b464552564a54','55306c575155744255306b3d','55326c325957746863326b3d','4f5451304d7a457a4d5459314f413d3d','','566d6c796457526f645735685a324679','5647467461577767546d466b64513d3d','NULL','NULL','','NULL','NULL','NULL','','','Sivakasi','','0');

INSERT INTO test_mohan_consignor (id, created_date_time, creator, creator_name, consignor_id, name, address, city, mobile_number, landline_number, district, state, gst_number, identification, bill_company_id, unit_id, unit_name, price_value, opening_balance, opening_balance_type, others_city, cooly_value, deleted) VALUES ('80','2025-07-16 16:41:59','56564e46556c38774d513d3d','55334a706332396d64486468636d5636','5130394f55306c48546b3953587a45324d4463794d4449314d4451304d545535587a6777','545339544c69424e56564a565230464f4946525351555246556c4d3d','55306c575155744255306b3d','55326c325957746863326b3d','4f5441304d6a637a4e544d314d413d3d','','566d6c796457526f645735685a324679','5647467461577767546d466b64513d3d','NULL','NULL','','NULL','NULL','NULL','','','Sivakasi','','0');

INSERT INTO test_mohan_consignor (id, created_date_time, creator, creator_name, consignor_id, name, address, city, mobile_number, landline_number, district, state, gst_number, identification, bill_company_id, unit_id, unit_name, price_value, opening_balance, opening_balance_type, others_city, cooly_value, deleted) VALUES ('81','2025-07-16 16:43:16','56564e46556c38774d513d3d','55334a706332396d64486468636d5636','5130394f55306c48546b3953587a45324d4463794d4449314d4451304d7a4532587a6778','545339544c6942455355464e543035454946425054466b675130394256464d3d','55306c575155744255306b3d','55326c325957746863326b3d','4f4441354f4459324e5463324d513d3d','','566d6c796457526f645735685a324679','5647467461577767546d466b64513d3d','NULL','NULL','','NULL','NULL','NULL','','','Sivakasi','','0');

INSERT INTO test_mohan_consignor (id, created_date_time, creator, creator_name, consignor_id, name, address, city, mobile_number, landline_number, district, state, gst_number, identification, bill_company_id, unit_id, unit_name, price_value, opening_balance, opening_balance_type, others_city, cooly_value, deleted) VALUES ('82','2025-07-16 16:46:30','56564e46556c38774d513d3d','55334a706332396d64486468636d5636','5130394f55306c48546b3953587a45324d4463794d4449314d4451304e6a4d77587a6779','545339544c694254556b6b6755315645534546535530464f51534250526b5a465531516755464a4a546c5246556c4d3d','55306c575155744255306b3d','55326c325957746863326b3d','4f5451304d7a45324e4455354d673d3d','','566d6c796457526f645735685a324679','5647467461577767546d466b64513d3d','NULL','NULL','','NULL','NULL','NULL','','','Sivakasi','','0');

INSERT INTO test_mohan_consignor (id, created_date_time, creator, creator_name, consignor_id, name, address, city, mobile_number, landline_number, district, state, gst_number, identification, bill_company_id, unit_id, unit_name, price_value, opening_balance, opening_balance_type, others_city, cooly_value, deleted) VALUES ('83','2025-07-16 16:55:54','56564e46556c38774d513d3d','55334a706332396d64486468636d5636','5130394f55306c48546b3953587a45324d4463794d4449314d4451314e545530587a677a','545339544c694254556b6b6755464a4a546c525052314a4255456854','55306c575155744255306b3d','55326c325957746863326b3d','4f5463314d446b784d6a55314d773d3d','','566d6c796457526f645735685a324679','5647467461577767546d466b64513d3d','NULL','NULL','','NULL','NULL','NULL','','','Sivakasi','','0');

INSERT INTO test_mohan_consignor (id, created_date_time, creator, creator_name, consignor_id, name, address, city, mobile_number, landline_number, district, state, gst_number, identification, bill_company_id, unit_id, unit_name, price_value, opening_balance, opening_balance_type, others_city, cooly_value, deleted) VALUES ('84','2025-07-16 16:59:50','56564e46556c38774d513d3d','55334a706332396d64486468636d5636','5130394f55306c48546b3953587a45324d4463794d4449314d4451314f545577587a6730','556b464b','56456c535656425655673d3d','56476c796458423163673d3d','4f5463344e7a4d774e5451314e673d3d','','56476c79645842776458493d','5647467461577767546d466b64513d3d','NULL','NULL','','NULL','NULL','NULL','','','Tirupur','','0');

INSERT INTO test_mohan_consignor (id, created_date_time, creator, creator_name, consignor_id, name, address, city, mobile_number, landline_number, district, state, gst_number, identification, bill_company_id, unit_id, unit_name, price_value, opening_balance, opening_balance_type, others_city, cooly_value, deleted) VALUES ('85','2025-07-16 17:02:12','56564e46556c38774d513d3d','55334a706332396d64486468636d5636','5130394f55306c48546b3953587a45324d4463794d4449314d4455774d6a4579587a6731','545339544c6942575255776751564a5555773d3d','55306c575155744255306b3d','55326c325957746863326b3d','4f546b304e4441784d544d354f513d3d','','566d6c796457526f645735685a324679','5647467461577767546d466b64513d3d','NULL','NULL','','NULL','NULL','NULL','','','Sivakasi','','0');

INSERT INTO test_mohan_consignor (id, created_date_time, creator, creator_name, consignor_id, name, address, city, mobile_number, landline_number, district, state, gst_number, identification, bill_company_id, unit_id, unit_name, price_value, opening_balance, opening_balance_type, others_city, cooly_value, deleted) VALUES ('86','2025-07-16 17:04:13','56564e46556c38774d513d3d','55334a706332396d64486468636d5636','5130394f55306c48546b3953587a45324d4463794d4449314d4455774e44457a587a6732','545339544c6942425369424552564e4a52303546556c4d3d','55306c575155744255306b3d','55326c325957746863326b3d','4f5459774d4459304e546b7a4e773d3d','','566d6c796457526f645735685a324679','5647467461577767546d466b64513d3d','NULL','NULL','','NULL','NULL','NULL','','','Sivakasi','','0');

INSERT INTO test_mohan_consignor (id, created_date_time, creator, creator_name, consignor_id, name, address, city, mobile_number, landline_number, district, state, gst_number, identification, bill_company_id, unit_id, unit_name, price_value, opening_balance, opening_balance_type, others_city, cooly_value, deleted) VALUES ('87','2025-07-16 17:08:46','56564e46556c38774d513d3d','55334a706332396d64486468636d5636','5130394f55306c48546b3953587a45324d4463794d4449314d4455774f445132587a6733','5669354c51564a56546b464e543039535645685a','55306c575155744255306b3d','55326c325957746863326b3d','4f5463344e7a67794d5455774e773d3d','','566d6c796457526f645735685a324679','5647467461577767546d466b64513d3d','NULL','NULL','','NULL','NULL','NULL','','','Sivakasi','','0');

INSERT INTO test_mohan_consignor (id, created_date_time, creator, creator_name, consignor_id, name, address, city, mobile_number, landline_number, district, state, gst_number, identification, bill_company_id, unit_id, unit_name, price_value, opening_balance, opening_balance_type, others_city, cooly_value, deleted) VALUES ('88','2025-07-16 17:10:22','56564e46556c38774d513d3d','55334a706332396d64486468636d5636','5130394f55306c48546b3953587a45324d4463794d4449314d4455784d444979587a6734','5155354a56456842','56456c535656425655673d3d','56476c796458423163673d3d','4f546b324e5449794d7a67344d673d3d','','56476c79645842776458493d','5647467461577767546d466b64513d3d','NULL','NULL','','NULL','NULL','NULL','','','Tirupur','','0');

INSERT INTO test_mohan_consignor (id, created_date_time, creator, creator_name, consignor_id, name, address, city, mobile_number, landline_number, district, state, gst_number, identification, bill_company_id, unit_id, unit_name, price_value, opening_balance, opening_balance_type, others_city, cooly_value, deleted) VALUES ('89','2025-07-16 17:12:30','56564e46556c38774d513d3d','55334a706332396d64486468636d5636','5130394f55306c48546b3953587a45324d4463794d4449314d4455784d6a4d77587a6735','545339544c69424c56553142556b4657525577675355354556564e55556b6c4655773d3d','55306c575155744255306b3d','55326c325957746863326b3d','4f5451304d7a4d334f4467324d673d3d','','566d6c796457526f645735685a324679','5647467461577767546d466b64513d3d','NULL','NULL','','NULL','NULL','NULL','','','Sivakasi','','0');

INSERT INTO test_mohan_consignor (id, created_date_time, creator, creator_name, consignor_id, name, address, city, mobile_number, landline_number, district, state, gst_number, identification, bill_company_id, unit_id, unit_name, price_value, opening_balance, opening_balance_type, others_city, cooly_value, deleted) VALUES ('90','2025-07-16 17:33:55','56564e46556c38774d513d3d','55334a706332396d64486468636d5636','5130394f55306c48546b3953587a45324d4463794d4449314d44557a4d7a5531587a6b77','545339544c69424a545546485355354849464e50544656555355394f','55306c575155744255306b3d','55326c325957746863326b3d','4f5467304d6a45314e5463774e513d3d','','566d6c796457526f645735685a324679','5647467461577767546d466b64513d3d','NULL','NULL','','NULL','NULL','NULL','','','Sivakasi','','0');

INSERT INTO test_mohan_consignor (id, created_date_time, creator, creator_name, consignor_id, name, address, city, mobile_number, landline_number, district, state, gst_number, identification, bill_company_id, unit_id, unit_name, price_value, opening_balance, opening_balance_type, others_city, cooly_value, deleted) VALUES ('91','2025-07-16 17:36:48','56564e46556c38774d513d3d','55334a706332396d64486468636d5636','5130394f55306c48546b3953587a45324d4463794d4449314d44557a4e6a5134587a6b78','545339544c6942544946496751556446546b4e5a','56456c535656425655673d3d','55326c325957746863326b3d','4f546b354e444d794e6a51334d413d3d','','566d6c796457526f645735685a324679','5647467461577767546d466b64513d3d','NULL','NULL','','NULL','NULL','NULL','','','Sivakasi','','0');

INSERT INTO test_mohan_consignor (id, created_date_time, creator, creator_name, consignor_id, name, address, city, mobile_number, landline_number, district, state, gst_number, identification, bill_company_id, unit_id, unit_name, price_value, opening_balance, opening_balance_type, others_city, cooly_value, deleted) VALUES ('92','2025-07-17 18:29:55','56564e46556c38774d513d3d','55334a706332396d64486468636d5636','5130394f55306c48546b3953587a45334d4463794d4449314d4459794f545531587a6b79','545339544c69425456564a485253425452565a465469424a546b4d3d','55306c575155744255306b3d','55326c325957746863326b3d','4f5463314d446b314d6a41774e773d3d','','566d6c796457526f645735685a324679','5647467461577767546d466b64513d3d','NULL','NULL','','NULL','NULL','NULL','','','Sivakasi','','0');

INSERT INTO test_mohan_consignor (id, created_date_time, creator, creator_name, consignor_id, name, address, city, mobile_number, landline_number, district, state, gst_number, identification, bill_company_id, unit_id, unit_name, price_value, opening_balance, opening_balance_type, others_city, cooly_value, deleted) VALUES ('93','2025-07-17 18:31:09','56564e46556c38774d513d3d','55334a706332396d64486468636d5636','5130394f55306c48546b3953587a45334d4463794d4449314d44597a4d544135587a6b7a','545339544c69424c526b453d','55306c575155744255306b3d','55326c325957746863326b3d','4f5451304d7a51314e6a41324d413d3d','','566d6c796457526f645735685a324679','5647467461577767546d466b64513d3d','NULL','NULL','','NULL','NULL','NULL','','','Sivakasi','','0');

INSERT INTO test_mohan_consignor (id, created_date_time, creator, creator_name, consignor_id, name, address, city, mobile_number, landline_number, district, state, gst_number, identification, bill_company_id, unit_id, unit_name, price_value, opening_balance, opening_balance_type, others_city, cooly_value, deleted) VALUES ('94','2025-07-17 18:34:18','56564e46556c38774d513d3d','55334a706332396d64486468636d5636','5130394f55306c48546b3953587a45334d4463794d4449314d44597a4e444534587a6b30','5155785654556c4f5356564254534251543164455256493d','56456c535656425655673d3d','56476c796458423163673d3d','4f5463344e6a55784d546b354e513d3d','','56476c79645842776458493d','5647467461577767546d466b64513d3d','NULL','NULL','','NULL','NULL','NULL','','','Tirupur','','0');

INSERT INTO test_mohan_consignor (id, created_date_time, creator, creator_name, consignor_id, name, address, city, mobile_number, landline_number, district, state, gst_number, identification, bill_company_id, unit_id, unit_name, price_value, opening_balance, opening_balance_type, others_city, cooly_value, deleted) VALUES ('95','2025-07-17 18:35:53','56564e46556c38774d513d3d','55334a706332396d64486468636d5636','5130394f55306c48546b3953587a45334d4463794d4449314d44597a4e54557a587a6b31','545339544c69425552554e49546b38675530464d52564d6751303953554539535156524a5430343d','55306c575155744255306b3d','55326c325957746863326b3d','4f5451304d7a45774d7a45774e673d3d','','566d6c796457526f645735685a324679','5647467461577767546d466b64513d3d','NULL','NULL','','NULL','NULL','NULL','','','Sivakasi','','0');

INSERT INTO test_mohan_consignor (id, created_date_time, creator, creator_name, consignor_id, name, address, city, mobile_number, landline_number, district, state, gst_number, identification, bill_company_id, unit_id, unit_name, price_value, opening_balance, opening_balance_type, others_city, cooly_value, deleted) VALUES ('96','2025-07-17 18:38:34','56564e46556c38774d513d3d','55334a706332396d64486468636d5636','5130394f55306c48546b3953587a45334d4463794d4449314d44597a4f444d30587a6b32','545339544c694254556b6b675230464f52564e4949464253535535555430645351564249','55306c575155744255306b3d','55326c325957746863326b3d','4f5467304d7a49794e6a517a4e513d3d','','566d6c796457526f645735685a324679','5647467461577767546d466b64513d3d','NULL','NULL','','NULL','NULL','NULL','','','Sivakasi','','0');

INSERT INTO test_mohan_consignor (id, created_date_time, creator, creator_name, consignor_id, name, address, city, mobile_number, landline_number, district, state, gst_number, identification, bill_company_id, unit_id, unit_name, price_value, opening_balance, opening_balance_type, others_city, cooly_value, deleted) VALUES ('97','2025-07-17 18:44:25','56564e46556c38774d513d3d','55334a706332396d64486468636d5636','5130394f55306c48546b3953587a45334d4463794d4449314d4459304e444931587a6b33','53793553','55306c575155744255306b3d','55326c325957746863326b3d','4f5463344f5445774d5463354d773d3d','','566d6c796457526f645735685a324679','5647467461577767546d466b64513d3d','NULL','NULL','','NULL','NULL','NULL','','','Sivakasi','','0');

INSERT INTO test_mohan_consignor (id, created_date_time, creator, creator_name, consignor_id, name, address, city, mobile_number, landline_number, district, state, gst_number, identification, bill_company_id, unit_id, unit_name, price_value, opening_balance, opening_balance_type, others_city, cooly_value, deleted) VALUES ('98','2025-07-17 18:47:17','56564e46556c38774d513d3d','55334a706332396d64486468636d5636','5130394f55306c48546b3953587a45334d4463794d4449314d4459304e7a4533587a6b34','545339544c69425355434244565641675455464c52564a54','56456c535656425655673d3d','56476c796458423163673d3d','4f5467354e4463324e6a557a4e413d3d','','56476c79645842776458493d','5647467461577767546d466b64513d3d','NULL','NULL','','NULL','NULL','NULL','','','Tirupur','','0');

INSERT INTO test_mohan_consignor (id, created_date_time, creator, creator_name, consignor_id, name, address, city, mobile_number, landline_number, district, state, gst_number, identification, bill_company_id, unit_id, unit_name, price_value, opening_balance, opening_balance_type, others_city, cooly_value, deleted) VALUES ('99','2025-07-17 18:48:50','56564e46556c38774d513d3d','55334a706332396d64486468636d5636','5130394f55306c48546b3953587a45334d4463794d4449314d4459304f445577587a6b35','5546565356564e49543152495155314254673d3d','56456c5355465653','56476c796458423163673d3d','4f5467304d6a49304d6a55314f513d3d','','56476c79645842776458493d','5647467461577767546d466b64513d3d','NULL','NULL','','NULL','NULL','NULL','','','Tirupur','','0');

INSERT INTO test_mohan_consignor (id, created_date_time, creator, creator_name, consignor_id, name, address, city, mobile_number, landline_number, district, state, gst_number, identification, bill_company_id, unit_id, unit_name, price_value, opening_balance, opening_balance_type, others_city, cooly_value, deleted) VALUES ('100','2025-07-17 18:53:10','56564e46556c38774d513d3d','55334a706332396d64486468636d5636','5130394f55306c48546b3953587a45334d4463794d4449314d4459314d7a4577587a45774d413d3d','545339544c69425751556c43534546574946525351555246556c4d3d','55306c575155744255306b3d','55326c325957746863326b3d','4f5441304e7a41794d6a6b314e773d3d','','566d6c796457526f645735685a324679','5647467461577767546d466b64513d3d','NULL','NULL','','NULL','NULL','NULL','','','Sivakasi','','0');

INSERT INTO test_mohan_consignor (id, created_date_time, creator, creator_name, consignor_id, name, address, city, mobile_number, landline_number, district, state, gst_number, identification, bill_company_id, unit_id, unit_name, price_value, opening_balance, opening_balance_type, others_city, cooly_value, deleted) VALUES ('101','2025-07-17 18:54:50','56564e46556c38774d513d3d','55334a706332396d64486468636d5636','5130394f55306c48546b3953587a45334d4463794d4449314d4459314e445577587a45774d513d3d','545339544c69424a546b524a5155346755304e50556b6c4f52794245535555675630395353314d3d','55306c575155744255306b3d','55326c325957746863326b3d','4f4445304e444d304d5441324e413d3d','','566d6c796457526f645735685a324679','5647467461577767546d466b64513d3d','NULL','NULL','','NULL','NULL','NULL','','','Sivakasi','','0');

INSERT INTO test_mohan_consignor (id, created_date_time, creator, creator_name, consignor_id, name, address, city, mobile_number, landline_number, district, state, gst_number, identification, bill_company_id, unit_id, unit_name, price_value, opening_balance, opening_balance_type, others_city, cooly_value, deleted) VALUES ('102','2025-07-17 18:56:02','56564e46556c38774d513d3d','55334a706332396d64486468636d5636','5130394f55306c48546b3953587a45334d4463794d4449314d4459314e6a4179587a45774d673d3d','55464a42516b6842533046535155343d','55306c575155744255306b3d','55326c325957746863326b3d','4f4451794f4455354f5451324e673d3d','','566d6c796457526f645735685a324679','5647467461577767546d466b64513d3d','NULL','NULL','','NULL','NULL','NULL','','','Sivakasi','','0');

INSERT INTO test_mohan_consignor (id, created_date_time, creator, creator_name, consignor_id, name, address, city, mobile_number, landline_number, district, state, gst_number, identification, bill_company_id, unit_id, unit_name, price_value, opening_balance, opening_balance_type, others_city, cooly_value, deleted) VALUES ('103','2025-07-17 18:57:32','56564e46556c38774d513d3d','55334a706332396d64486468636d5636','5130394f55306c48546b3953587a45334d4463794d4449314d4459314e7a4d79587a45774d773d3d','545339544c69424d53553548515530675545394d575342445430785056564a54','55306c575155744255306b3d','55326c325957746863326b3d','4f546b354e4451784d5451774d673d3d','','566d6c796457526f645735685a324679','5647467461577767546d466b64513d3d','NULL','NULL','','NULL','NULL','NULL','','','Sivakasi','','0');

INSERT INTO test_mohan_consignor (id, created_date_time, creator, creator_name, consignor_id, name, address, city, mobile_number, landline_number, district, state, gst_number, identification, bill_company_id, unit_id, unit_name, price_value, opening_balance, opening_balance_type, others_city, cooly_value, deleted) VALUES ('104','2025-07-17 18:59:26','56564e46556c38774d513d3d','55334a706332396d64486468636d5636','5130394f55306c48546b3953587a45334d4463794d4449314d4459314f544932587a45774e413d3d','545339544c69424b54316b6755464a4a546c5246556c4d3d','55306c575155744255306b3d','55326c325957746863326b3d','4f5459314e544d324e7a597a4e673d3d','','566d6c796457526f645735685a324679','5647467461577767546d466b64513d3d','NULL','NULL','','NULL','NULL','NULL','','','Sivakasi','','0');

INSERT INTO test_mohan_consignor (id, created_date_time, creator, creator_name, consignor_id, name, address, city, mobile_number, landline_number, district, state, gst_number, identification, bill_company_id, unit_id, unit_name, price_value, opening_balance, opening_balance_type, others_city, cooly_value, deleted) VALUES ('105','2025-07-17 19:02:20','56564e46556c38774d513d3d','55334a706332396d64486468636d5636','5130394f55306c48546b3953587a45334d4463794d4449314d4463774d6a4977587a45774e513d3d','5530394d51556c51515535455355464f','55306c575155744255306b3d','55326c325957746863326b3d','4f5441774d7a67344f446b354e773d3d','','566d6c796457526f645735685a324679','5647467461577767546d466b64513d3d','NULL','NULL','','NULL','NULL','NULL','','','Sivakasi','','0');

INSERT INTO test_mohan_consignor (id, created_date_time, creator, creator_name, consignor_id, name, address, city, mobile_number, landline_number, district, state, gst_number, identification, bill_company_id, unit_id, unit_name, price_value, opening_balance, opening_balance_type, others_city, cooly_value, deleted) VALUES ('106','2025-07-17 19:04:22','56564e46556c38774d513d3d','55334a706332396d64486468636d5636','5130394f55306c48546b3953587a45334d4463794d4449314d4463774e444979587a45774e673d3d','5530564f5645684a5443424c5655314255673d3d','56456c535656425655673d3d','56476c796458423163673d3d','4f4449794d4463304f4451344d513d3d','','56476c79645842776458493d','5647467461577767546d466b64513d3d','NULL','NULL','','NULL','NULL','NULL','','','Tirupur','','0');

INSERT INTO test_mohan_consignor (id, created_date_time, creator, creator_name, consignor_id, name, address, city, mobile_number, landline_number, district, state, gst_number, identification, bill_company_id, unit_id, unit_name, price_value, opening_balance, opening_balance_type, others_city, cooly_value, deleted) VALUES ('107','2025-07-17 19:08:52','56564e46556c38774d513d3d','55334a706332396d64486468636d5636','5130394f55306c48546b3953587a45334d4463794d4449314d4463774f445579587a45774e773d3d','545339544c69424e543039535645685a49453947526c4e4656434251556b6c4f5645565355773d3d','55306c575155744255306b3d','55326c325957746863326b3d','4f5467304d6a49304e7a67304d513d3d','','566d6c796457526f645735685a324679','5647467461577767546d466b64513d3d','NULL','NULL','','NULL','NULL','NULL','','','Sivakasi','','0');

INSERT INTO test_mohan_consignor (id, created_date_time, creator, creator_name, consignor_id, name, address, city, mobile_number, landline_number, district, state, gst_number, identification, bill_company_id, unit_id, unit_name, price_value, opening_balance, opening_balance_type, others_city, cooly_value, deleted) VALUES ('108','2025-07-17 19:10:06','56564e46556c38774d513d3d','55334a706332396d64486468636d5636','5130394f55306c48546b3953587a45334d4463794d4449314d4463784d444132587a45774f413d3d','545339544c6942535156524953534251556b6c4f5643425151554e4c','55306c575155744255306b3d','55326c325957746863326b3d','4f5451304d7a45794e7a59344d513d3d','','566d6c796457526f645735685a324679','5647467461577767546d466b64513d3d','NULL','NULL','','NULL','NULL','NULL','','','Sivakasi','','0');

INSERT INTO test_mohan_consignor (id, created_date_time, creator, creator_name, consignor_id, name, address, city, mobile_number, landline_number, district, state, gst_number, identification, bill_company_id, unit_id, unit_name, price_value, opening_balance, opening_balance_type, others_city, cooly_value, deleted) VALUES ('109','2025-07-17 19:16:27','56564e46556c38774d513d3d','56476870636e56745a573570','5130394f55306c48546b3953587a45334d4463794d4449314d4463784e6a4933587a45774f513d3d','545339544c6942535155314249464253535535555430464a52464d3d','55306c575155744255306b3d','55326c325957746863326b3d','4f5451304d6a49304e544d334d513d3d','','566d6c796457526f645735685a324679','5647467461577767546d466b64513d3d','NULL','NULL','','NULL','NULL','NULL','','','Sivakasi','','0');

INSERT INTO test_mohan_consignor (id, created_date_time, creator, creator_name, consignor_id, name, address, city, mobile_number, landline_number, district, state, gst_number, identification, bill_company_id, unit_id, unit_name, price_value, opening_balance, opening_balance_type, others_city, cooly_value, deleted) VALUES ('110','2025-07-17 19:24:40','56564e46556c38774d513d3d','55334a706332396d64486468636d5636','5130394f55306c48546b3953587a45334d4463794d4449314d4463794e445177587a45784d413d3d','545339544c694254556b6b67566b6c4f51566c425330456755304e50556b6c4f52773d3d','55306c575155744255306b3d','55326c325957746863326b3d','4f5451304d6a55794e4467794d513d3d','','566d6c796457526f645735685a324679','5647467461577767546d466b64513d3d','NULL','NULL','','NULL','NULL','NULL','','','Sivakasi','','0');

INSERT INTO test_mohan_consignor (id, created_date_time, creator, creator_name, consignor_id, name, address, city, mobile_number, landline_number, district, state, gst_number, identification, bill_company_id, unit_id, unit_name, price_value, opening_balance, opening_balance_type, others_city, cooly_value, deleted) VALUES ('111','2025-07-17 19:33:10','56564e46556c38774d513d3d','55334a706332396d64486468636d5636','5130394f55306c48546b3953587a45334d4463794d4449314d44637a4d7a4577587a45784d513d3d','545339544c6942515355394f5255565349464a4657456c4f52534255556b464552564a54','56456c535656425655673d3d','56476c796458423163673d3d','4f5467304d446b354e5463784e513d3d','','56476c79645842776458493d','5647467461577767546d466b64513d3d','NULL','NULL','','NULL','NULL','NULL','','','Tirupur','','0');

INSERT INTO test_mohan_consignor (id, created_date_time, creator, creator_name, consignor_id, name, address, city, mobile_number, landline_number, district, state, gst_number, identification, bill_company_id, unit_id, unit_name, price_value, opening_balance, opening_balance_type, others_city, cooly_value, deleted) VALUES ('112','2025-07-17 19:34:43','56564e46556c38774d513d3d','55334a706332396d64486468636d5636','5130394f55306c48546b3953587a45334d4463794d4449314d44637a4e44517a587a45784d673d3d','5530464f536b6c5753513d3d','55306c575155744255306b3d','55326c325957746863326b3d','4f5467304d7a55784e7a6b334d773d3d','','566d6c796457526f645735685a324679','5647467461577767546d466b64513d3d','NULL','NULL','','NULL','NULL','NULL','','','Sivakasi','','0');

INSERT INTO test_mohan_consignor (id, created_date_time, creator, creator_name, consignor_id, name, address, city, mobile_number, landline_number, district, state, gst_number, identification, bill_company_id, unit_id, unit_name, price_value, opening_balance, opening_balance_type, others_city, cooly_value, deleted) VALUES ('113','2025-07-17 19:55:17','56564e46556c38774d513d3d','55334a706332396d64486468636d5636','5130394f55306c48546b3953587a45334d4463794d4449314d4463314e544533587a45784d773d3d','515535555430355a','55306c575155744255306b3d','55326c325957746863326b3d','4f5459354f446b334f546b794d673d3d','','566d6c796457526f645735685a324679','5647467461577767546d466b64513d3d','NULL','NULL','','NULL','NULL','NULL','','','Sivakasi','','0');

INSERT INTO test_mohan_consignor (id, created_date_time, creator, creator_name, consignor_id, name, address, city, mobile_number, landline_number, district, state, gst_number, identification, bill_company_id, unit_id, unit_name, price_value, opening_balance, opening_balance_type, others_city, cooly_value, deleted) VALUES ('114','2025-07-17 19:56:49','56564e46556c38774d513d3d','55334a706332396d64486468636d5636','5130394f55306c48546b3953587a45334d4463794d4449314d4463314e6a5135587a45784e413d3d','5453395449464e535353424b5755395553456b6755464a4655314d3d','55306c575155744255306b3d','55326c325957746863326b3d','4f5467304d6a45794e6a41334f513d3d','','566d6c796457526f645735685a324679','5647467461577767546d466b64513d3d','NULL','NULL','','NULL','NULL','NULL','','','Sivakasi','','0');

INSERT INTO test_mohan_consignor (id, created_date_time, creator, creator_name, consignor_id, name, address, city, mobile_number, landline_number, district, state, gst_number, identification, bill_company_id, unit_id, unit_name, price_value, opening_balance, opening_balance_type, others_city, cooly_value, deleted) VALUES ('115','2025-07-17 20:03:02','56564e46556c38774d513d3d','55334a706332396d64486468636d5636','5130394f55306c48546b3953587a45334d4463794d4449314d4467774d7a4179587a45784e513d3d','5453395449465a46544342425230564f51306c4655773d3d','51306846546b354253513d3d','51306846546b354253513d3d','4f5455344e5449784d6a4d344f513d3d','','5132686c626d356861513d3d','5647467461577767546d466b64513d3d','NULL','NULL','','NULL','NULL','NULL','','','CHENNAI','','0');

INSERT INTO test_mohan_consignor (id, created_date_time, creator, creator_name, consignor_id, name, address, city, mobile_number, landline_number, district, state, gst_number, identification, bill_company_id, unit_id, unit_name, price_value, opening_balance, opening_balance_type, others_city, cooly_value, deleted) VALUES ('116','2025-07-17 20:04:49','56564e46556c38774d513d3d','55334a706332396d64486468636d5636','5130394f55306c48546b3953587a45334d4463794d4449314d4467774e445135587a45784e673d3d','5453395449456c4f52456c42546942455355553d','55306c575155744255306b3d','55326c325957746863326b3d','4e6a4d344d7a63774d6a41304d773d3d','','566d6c796457526f645735685a324679','5647467461577767546d466b64513d3d','NULL','NULL','','NULL','NULL','NULL','','','Sivakasi','','0');

INSERT INTO test_mohan_consignor (id, created_date_time, creator, creator_name, consignor_id, name, address, city, mobile_number, landline_number, district, state, gst_number, identification, bill_company_id, unit_id, unit_name, price_value, opening_balance, opening_balance_type, others_city, cooly_value, deleted) VALUES ('117','2025-07-17 20:06:37','56564e46556c38774d513d3d','55334a706332396d64486468636d5636','5130394f55306c48546b3953587a45334d4463794d4449314d4467774e6a4d33587a45784e773d3d','545339544c6942485256424649456c4f5246565456464a4a52564d3d','56456c535656425655673d3d','56476c796458423163673d3d','4d4451314e6a49794d7a41354e773d3d','','56476c79645842776458493d','5647467461577767546d466b64513d3d','NULL','4d4451314e6a49744d6a4d774f546379','','NULL','NULL','NULL','','','Tirupur','','0');

INSERT INTO test_mohan_consignor (id, created_date_time, creator, creator_name, consignor_id, name, address, city, mobile_number, landline_number, district, state, gst_number, identification, bill_company_id, unit_id, unit_name, price_value, opening_balance, opening_balance_type, others_city, cooly_value, deleted) VALUES ('118','2025-07-17 20:08:09','56564e46556c38774d513d3d','55334a706332396d64486468636d5636','5130394f55306c48546b3953587a45334d4463794d4449314d4467774f444135587a45784f413d3d','545339544c69424c5155354f5153424451557842546b524655673d3d','55306c575155744255306b3d','55326c325957746863326b3d','4f5441304e7a4d304f446b354f513d3d','','566d6c796457526f645735685a324679','5647467461577767546d466b64513d3d','NULL','NULL','','NULL','NULL','NULL','','','Sivakasi','','0');

INSERT INTO test_mohan_consignor (id, created_date_time, creator, creator_name, consignor_id, name, address, city, mobile_number, landline_number, district, state, gst_number, identification, bill_company_id, unit_id, unit_name, price_value, opening_balance, opening_balance_type, others_city, cooly_value, deleted) VALUES ('119','2025-07-17 20:09:25','56564e46556c38774d513d3d','55334a706332396d64486468636d5636','5130394f55306c48546b3953587a45334d4463794d4449314d4467774f544931587a45784f513d3d','545339544c6942555345464f5230464e49455a4a546b556751564a5555773d3d','55306c575155744255306b3d','55326c325957746863326b3d','4f5467304d7a67334e7a4d344e773d3d','','566d6c796457526f645735685a324679','5647467461577767546d466b64513d3d','NULL','NULL','','NULL','NULL','NULL','','','Sivakasi','','0');

INSERT INTO test_mohan_consignor (id, created_date_time, creator, creator_name, consignor_id, name, address, city, mobile_number, landline_number, district, state, gst_number, identification, bill_company_id, unit_id, unit_name, price_value, opening_balance, opening_balance_type, others_city, cooly_value, deleted) VALUES ('120','2025-07-17 20:11:35','56564e46556c38774d513d3d','55334a706332396d64486468636d5636','5130394f55306c48546b3953587a45334d4463794d4449314d4467784d544d31587a45794d413d3d','545339544c694254556b6b67566b6c4f51566c42523045675130465352464d3d','55306c575155744255306b3d','55326c325957746863326b3d','4f5467354e4467774e4459774d513d3d','','566d6c796457526f645735685a324679','5647467461577767546d466b64513d3d','NULL','NULL','','NULL','NULL','NULL','','','Sivakasi','','0');

INSERT INTO test_mohan_consignor (id, created_date_time, creator, creator_name, consignor_id, name, address, city, mobile_number, landline_number, district, state, gst_number, identification, bill_company_id, unit_id, unit_name, price_value, opening_balance, opening_balance_type, others_city, cooly_value, deleted) VALUES ('121','2025-07-17 20:13:19','56564e46556c38774d513d3d','55334a706332396d64486468636d5636','5130394f55306c48546b3953587a45334d4463794d4449314d4467784d7a4535587a45794d513d3d','545339544c694257535570425755456755464a4a546c5246556c4d3d','55306c575155744255306b3d','55326c325957746863326b3d','4f5463344f444d334f5449794f513d3d','','566d6c796457526f645735685a324679','5647467461577767546d466b64513d3d','NULL','NULL','','NULL','NULL','NULL','','','Sivakasi','','0');

INSERT INTO test_mohan_consignor (id, created_date_time, creator, creator_name, consignor_id, name, address, city, mobile_number, landline_number, district, state, gst_number, identification, bill_company_id, unit_id, unit_name, price_value, opening_balance, opening_balance_type, others_city, cooly_value, deleted) VALUES ('122','2025-07-17 20:24:18','56564e46556c38774d513d3d','55334a706332396d64486468636d5636','5130394f55306c48546b3953587a45334d4463794d4449314d4467794e444534587a45794d673d3d','545339544c6942545345464f5330465349464242513074425230553d','56456c535656425655673d3d','56476c796458423163673d3d','4f5459334e7a63334f546b324e673d3d','','56476c79645842776458493d','5647467461577767546d466b64513d3d','NULL','NULL','','NULL','NULL','NULL','','','Tirupur','','0');

INSERT INTO test_mohan_consignor (id, created_date_time, creator, creator_name, consignor_id, name, address, city, mobile_number, landline_number, district, state, gst_number, identification, bill_company_id, unit_id, unit_name, price_value, opening_balance, opening_balance_type, others_city, cooly_value, deleted) VALUES ('123','2025-07-17 20:25:46','56564e46556c38774d513d3d','55334a706332396d64486468636d5636','5130394f55306c48546b3953587a45334d4463794d4449314d4467794e545132587a45794d773d3d','545339544c69425456434242546c5250546c6b6751307850516b464d49464e44556b4651','56456c535656425655673d3d','56476c796458423163673d3d','4e7a55354f444d354d4441314e673d3d','','56476c79645842776458493d','5647467461577767546d466b64513d3d','NULL','NULL','','NULL','NULL','NULL','','','Tirupur','','0');

INSERT INTO test_mohan_consignor (id, created_date_time, creator, creator_name, consignor_id, name, address, city, mobile_number, landline_number, district, state, gst_number, identification, bill_company_id, unit_id, unit_name, price_value, opening_balance, opening_balance_type, others_city, cooly_value, deleted) VALUES ('124','2025-07-17 21:17:23','56564e46556c38774d513d3d','55334a706332396d64486468636d5636','5130394f55306c48546b3953587a45334d4463794d4449314d446b784e7a497a587a45794e413d3d','5453395449464e53535342545655704652565a4254694255556b464552564a54','55306c575155744255306b3d','55326c325957746863326b3d','4f4441314e6a63354e7a41344e413d3d','','566d6c796457526f645735685a324679','5647467461577767546d466b64513d3d','NULL','NULL','','NULL','NULL','NULL','','','Sivakasi','','0');

INSERT INTO test_mohan_consignor (id, created_date_time, creator, creator_name, consignor_id, name, address, city, mobile_number, landline_number, district, state, gst_number, identification, bill_company_id, unit_id, unit_name, price_value, opening_balance, opening_balance_type, others_city, cooly_value, deleted) VALUES ('125','2025-07-18 19:11:10','56564e46556c38774d513d3d','55334a706332396d64486468636d5636','5130394f55306c48546b3953587a45344d4463794d4449314d4463784d544577587a45794e513d3d','545649674c6b31425345464655316442556b464f','55306c575155744255306b3d','55326c325957746863326b3d','4e7a49774d4445794e7a41774f413d3d','','566d6c796457526f645735685a324679','5647467461577767546d466b64513d3d','NULL','NULL','','NULL','NULL','NULL','','','Sivakasi','','0');

INSERT INTO test_mohan_consignor (id, created_date_time, creator, creator_name, consignor_id, name, address, city, mobile_number, landline_number, district, state, gst_number, identification, bill_company_id, unit_id, unit_name, price_value, opening_balance, opening_balance_type, others_city, cooly_value, deleted) VALUES ('126','2025-07-18 19:13:02','56564e46556c38774d513d3d','55334a706332396d64486468636d5636','5130394f55306c48546b3953587a45344d4463794d4449314d4463784d7a4179587a45794e673d3d','545339544c6942545255355553456c4d49453947526c4e4656434251556b6c4f5645565355773d3d','55306c575155744255306b3d','55326c325957746863326b3d','4f5451304d7a45304e7a63334e513d3d','','566d6c796457526f645735685a324679','5647467461577767546d466b64513d3d','NULL','NULL','','NULL','NULL','NULL','','','Sivakasi','','0');

INSERT INTO test_mohan_consignor (id, created_date_time, creator, creator_name, consignor_id, name, address, city, mobile_number, landline_number, district, state, gst_number, identification, bill_company_id, unit_id, unit_name, price_value, opening_balance, opening_balance_type, others_city, cooly_value, deleted) VALUES ('127','2025-07-18 19:17:10','56564e46556c38774d513d3d','55334a706332396d64486468636d5636','5130394f55306c48546b3953587a45344d4463794d4449314d4463784e7a4577587a45794e773d3d','556b464b515342485431424254413d3d','55306c575155744255306b3d','55326c325957746863326b3d','4f5467304d6a63784f544d354e773d3d','','566d6c796457526f645735685a324679','5647467461577767546d466b64513d3d','NULL','NULL','','NULL','NULL','NULL','','','Sivakasi','','0');

INSERT INTO test_mohan_consignor (id, created_date_time, creator, creator_name, consignor_id, name, address, city, mobile_number, landline_number, district, state, gst_number, identification, bill_company_id, unit_id, unit_name, price_value, opening_balance, opening_balance_type, others_city, cooly_value, deleted) VALUES ('128','2025-07-18 19:19:13','56564e46556c38774d513d3d','55334a706332396d64486468636d5636','5130394f55306c48546b3953587a45344d4463794d4449314d4463784f54457a587a45794f413d3d','545339544c6942544c6c497552314a425545684a5179424a5456424657413d3d','55306c575155744255306b3d','55326c325957746863326b3d','4e6a4d324f5449344f4455784e513d3d','','566d6c796457526f645735685a324679','5647467461577767546d466b64513d3d','NULL','NULL','','NULL','NULL','NULL','','','Sivakasi','','0');

INSERT INTO test_mohan_consignor (id, created_date_time, creator, creator_name, consignor_id, name, address, city, mobile_number, landline_number, district, state, gst_number, identification, bill_company_id, unit_id, unit_name, price_value, opening_balance, opening_balance_type, others_city, cooly_value, deleted) VALUES ('129','2025-07-18 19:20:55','56564e46556c38774d513d3d','55334a706332396d64486468636d5636','5130394f55306c48546b3953587a45344d4463794d4449314d4463794d445531587a45794f513d3d','545339544c69424f525663675130684a56464a4249453947526b565456434251556b6c4f5645565355773d3d','55306c575155744255306b3d','55326c325957746863326b3d','4e7a41784d4449334e7a67314d513d3d','','566d6c796457526f645735685a324679','5647467461577767546d466b64513d3d','NULL','NULL','','NULL','NULL','NULL','','','Sivakasi','','0');

INSERT INTO test_mohan_consignor (id, created_date_time, creator, creator_name, consignor_id, name, address, city, mobile_number, landline_number, district, state, gst_number, identification, bill_company_id, unit_id, unit_name, price_value, opening_balance, opening_balance_type, others_city, cooly_value, deleted) VALUES ('130','2025-07-18 19:28:14','56564e46556c38774d513d3d','55334a706332396d64486468636d5636','5130394f55306c48546b3953587a45344d4463794d4449314d4463794f444530587a457a4d413d3d','545339544c6942545655745351554567554578425531524a51314d3d','55306c575155744255306b3d','55326c325957746863326b3d','4f5451304e444d334e4445354f513d3d','','566d6c796457526f645735685a324679','5647467461577767546d466b64513d3d','NULL','NULL','','NULL','NULL','NULL','','','Sivakasi','','0');

INSERT INTO test_mohan_consignor (id, created_date_time, creator, creator_name, consignor_id, name, address, city, mobile_number, landline_number, district, state, gst_number, identification, bill_company_id, unit_id, unit_name, price_value, opening_balance, opening_balance_type, others_city, cooly_value, deleted) VALUES ('131','2025-07-30 20:23:03','56564e46556c38774d513d3d','55334a706332396d64486468636d5636','5130394f55306c48546b3953587a4d774d4463794d4449314d4467794d7a417a587a457a4d513d3d','545339544c69424e51556842566b56465569424e51564a4c5256524a546b633d','NULL','NULL','4f5463344e7a55344f5463344d513d3d','','NULL','NULL','NULL','NULL','','','','','','','','','0');

INSERT INTO test_mohan_consignor (id, created_date_time, creator, creator_name, consignor_id, name, address, city, mobile_number, landline_number, district, state, gst_number, identification, bill_company_id, unit_id, unit_name, price_value, opening_balance, opening_balance_type, others_city, cooly_value, deleted) VALUES ('132','2025-08-01 11:57:34','56564e46556c38774d513d3d','55334a706332396d64486468636d5636','5130394f55306c48546b3953587a41784d4467794d4449314d5445314e7a4d30587a457a4d673d3d','545339544c694242546b464f5243424454307850565649675130394e5545464f57513d3d','55306c575155744255306b3d','55326c325957746863326b3d','4f4455794e6a51774e7a67324e673d3d','','566d6c796457526f645735685a324679','5647467461577767546d466b64513d3d','NULL','NULL','','NULL','NULL','NULL','','','','','0');

INSERT INTO test_mohan_consignor (id, created_date_time, creator, creator_name, consignor_id, name, address, city, mobile_number, landline_number, district, state, gst_number, identification, bill_company_id, unit_id, unit_name, price_value, opening_balance, opening_balance_type, others_city, cooly_value, deleted) VALUES ('133','2025-08-01 11:59:41','56564e46556c38774d513d3d','55334a706332396d64486468636d5636','5130394f55306c48546b3953587a41784d4467794d4449314d5445314f545179587a457a4d773d3d','545339544c694255534555675330464f546b464f4946424256465242553155675330464551556b3d','55306c575155744255306b3d','55326c325957746863326b3d','4f5463354d5459774f546b354d513d3d','','566d6c796457526f645735685a324679','5647467461577767546d466b64513d3d','NULL','NULL','','NULL','NULL','NULL','','','','','0');

INSERT INTO test_mohan_consignor (id, created_date_time, creator, creator_name, consignor_id, name, address, city, mobile_number, landline_number, district, state, gst_number, identification, bill_company_id, unit_id, unit_name, price_value, opening_balance, opening_balance_type, others_city, cooly_value, deleted) VALUES ('134','2025-08-01 12:03:18','56564e46556c38774d513d3d','55334a706332396d64486468636d5636','5130394f55306c48546b3953587a41784d4467794d4449314d5449774d7a4534587a457a4e413d3d','545339544c69424e5431564d5353425157564a5049464242556b733d','55306c575155744255306b3d','55326c325957746863326b3d','4f5463314d5441304e5449354d673d3d','','566d6c796457526f645735685a324679','5647467461577767546d466b64513d3d','NULL','NULL','','NULL','NULL','NULL','','','','','0');


CREATE TABLE `test_mohan_driver` (
  `id` int(100) NOT NULL AUTO_INCREMENT,
  `creator` mediumtext NOT NULL,
  `created_date_time` datetime NOT NULL,
  `creator_name` mediumtext NOT NULL,
  `bill_company_id` mediumtext NOT NULL,
  `driver_id` mediumtext NOT NULL,
  `driver_name` mediumtext NOT NULL,
  `driver_number` mediumtext NOT NULL,
  `lower_case_name` mediumtext NOT NULL,
  `license_number` mediumtext NOT NULL,
  `license_type` mediumtext NOT NULL,
  `expiry_date` date NOT NULL,
  `deleted` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;


INSERT INTO test_mohan_driver (id, creator, created_date_time, creator_name, bill_company_id, driver_id, driver_name, driver_number, lower_case_name, license_number, license_type, expiry_date, deleted) VALUES ('1','56564e46556c38774d513d3d','2025-07-09 17:47:24','55334a706332396d64486468636d5636','54314a485155354a576b46555355394f587a45314d4455794d4449304d444d784e544935587a4178','52464a4a566b5653587a41354d4463794d4449314d4455304e7a4930587a4178','566d6c756233526f','4f5463774e6a59314d4455304e413d3d','646d6c756233526f','NULL','1','2025-08-07','0');

INSERT INTO test_mohan_driver (id, creator, created_date_time, creator_name, bill_company_id, driver_id, driver_name, driver_number, lower_case_name, license_number, license_type, expiry_date, deleted) VALUES ('2','56564e46556c38774d513d3d','2025-07-09 17:47:53','55334a706332396d64486468636d5636','54314a485155354a576b46555355394f587a45314d4455794d4449304d444d784e544935587a4178','52464a4a566b5653587a41354d4463794d4449314d4455304e7a557a587a4179','545856796457646862673d3d','4e6a55344f4463354d446b774f413d3d','625856796457646862673d3d','5a6d56795a6d557a4e48497a4e444d3d','2','2025-08-16','0');

INSERT INTO test_mohan_driver (id, creator, created_date_time, creator_name, bill_company_id, driver_id, driver_name, driver_number, lower_case_name, license_number, license_type, expiry_date, deleted) VALUES ('3','56564e46556c38774d513d3d','2025-07-10 15:36:25','55334a706332396d64486468636d5636','54314a485155354a576b46555355394f587a45314d4455794d4449304d444d784e544935587a4178','52464a4a566b5653587a45774d4463794d4449314d444d7a4e6a4931587a417a','526d56335a6e467863513d3d','4d6a4d794d6a55314d6a51314d413d3d','5a6d56335a6e467863513d3d','4e475a6e5a32633d','1','2025-07-11','1');

INSERT INTO test_mohan_driver (id, creator, created_date_time, creator_name, bill_company_id, driver_id, driver_name, driver_number, lower_case_name, license_number, license_type, expiry_date, deleted) VALUES ('4','56564e46556c38774d513d3d','2025-07-15 09:48:36','55334a706332396d64486468636d5636','54314a485155354a576b46555355394f587a45314d4455794d4449304d444d784e544935587a4178','52464a4a566b5653587a45314d4463794d4449314d446b304f444d32587a4130','523246755a584e6f','4e6a63794f446b784f4449334d673d3d','5a3246755a584e6f','64577070627a4a714d6d566b626d747161773d3d','1','2025-08-08','0');


CREATE TABLE `test_mohan_expense` (
  `id` int(100) NOT NULL AUTO_INCREMENT,
  `created_date_time` datetime NOT NULL,
  `creator` mediumtext NOT NULL,
  `creator_name` mediumtext NOT NULL,
  `bill_company_id` mediumtext NOT NULL,
  `expense_id` mediumtext NOT NULL,
  `expense_number` mediumtext NOT NULL,
  `expense_date` date NOT NULL,
  `payment_tax_type` mediumtext NOT NULL,
  `expense_category_id` mediumtext NOT NULL,
  `expense_category_name` mediumtext NOT NULL,
  `amount` mediumtext NOT NULL,
  `narration` mediumtext NOT NULL,
  `payment_mode_id` mediumtext NOT NULL,
  `payment_mode_name` mediumtext NOT NULL,
  `bank_id` mediumtext NOT NULL,
  `bank_name` mediumtext NOT NULL,
  `total_amount` mediumtext NOT NULL,
  `tripsheet_profit_loss_id` mediumtext NOT NULL,
  `deleted` int(10) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;


INSERT INTO test_mohan_expense (id, created_date_time, creator, creator_name, bill_company_id, expense_id, expense_number, expense_date, payment_tax_type, expense_category_id, expense_category_name, amount, narration, payment_mode_id, payment_mode_name, bank_id, bank_name, total_amount, tripsheet_profit_loss_id, deleted) VALUES ('1','2025-07-21 22:24:21','56564e46556c38774d513d3d','55334a706332396d64486468636d5636','54314a485155354a576b46555355394f587a45314d4455794d4449304d444d784e544935587a4178','52566851587a49784d4463794d4449314d5441794e444978587a4178','EV001/25-26','2025-07-21','2','5256685158304e42564638784e5441334d6a41794e5445774d4467304e3138774d773d3d','52464a4a566b565349464e42544546535753413d','5000','52484a70646d567949464e6864476870633267676332467359584a35','5547463562575675644639746232526c587a45784d4463794d4449314d5445784d444930587a417a','5130465453413d3d','','','5000','','0');

INSERT INTO test_mohan_expense (id, created_date_time, creator, creator_name, bill_company_id, expense_id, expense_number, expense_date, payment_tax_type, expense_category_id, expense_category_name, amount, narration, payment_mode_id, payment_mode_name, bank_id, bank_name, total_amount, tripsheet_profit_loss_id, deleted) VALUES ('2','2025-07-22 09:37:00','56564e46556c38774d513d3d','55334a706332396d64486468636d5636','54314a485155354a576b46555355394f587a45314d4455794d4449304d444d784e544935587a4178','52566851587a49794d4463794d4449314d446b7a4e7a4177587a4179','EV002/25-26','2025-07-22','2','5256685158304e42564638784e5441334d6a41794e5445774d4467304e3138774d773d3d','52464a4a566b565349464e42544546535753413d','1000','516d6c7362413d3d','5547463562575675644639746232526c587a45784d4463794d4449314d5445784d444930587a417a','5130465453413d3d','','','1000','','0');

INSERT INTO test_mohan_expense (id, created_date_time, creator, creator_name, bill_company_id, expense_id, expense_number, expense_date, payment_tax_type, expense_category_id, expense_category_name, amount, narration, payment_mode_id, payment_mode_name, bank_id, bank_name, total_amount, tripsheet_profit_loss_id, deleted) VALUES ('3','2025-07-23 15:44:28','56564e46556c38774d513d3d','55334a706332396d64486468636d5636','54314a485155354a576b46555355394f587a45314d4455794d4449304d444d784e544935587a4178','52566851587a497a4d4463794d4449314d444d304e444934587a417a','EV003/25-26','2025-07-23','2','5256685158304e42564638784e5441334d6a41794e5445774d4467304e3138774d773d3d','5530464d51564a5a49454645566b464f5130556752464a4a566b565349454654543074465331564e5156493d','500','52484a70646d56794947467a6232746c49484e686247467965513d3d','5547463562575675644639746232526c587a45784d4463794d4449314d5445784d444930587a417a','5130465453413d3d','','','500','','0');


CREATE TABLE `test_mohan_expense_category` (
  `id` int(100) NOT NULL AUTO_INCREMENT,
  `created_date_time` datetime NOT NULL,
  `creator` mediumtext NOT NULL,
  `creator_name` mediumtext NOT NULL,
  `bill_company_id` mediumtext NOT NULL,
  `expense_category_id` mediumtext NOT NULL,
  `expense_category_name` mediumtext NOT NULL,
  `lower_case_name` mediumtext NOT NULL,
  `deleted` int(100) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;


INSERT INTO test_mohan_expense_category (id, created_date_time, creator, creator_name, bill_company_id, expense_category_id, expense_category_name, lower_case_name, deleted) VALUES ('1','2025-07-14 16:18:40','56564e46556c38774d513d3d','4e54557a4d7a52684e7a41324d7a4d794d7a6b325a4459304e4467324e4459344e6a4d325a4455324d7a593d','','5256685158304e42564638784e4441334d6a41794e5441304d5467304d4638774d513d3d','526c56465443424657464246546c4e4649413d3d','5a6e566c6243426c6548426c626e4e6c','0');

INSERT INTO test_mohan_expense_category (id, created_date_time, creator, creator_name, bill_company_id, expense_category_id, expense_category_name, lower_case_name, deleted) VALUES ('2','2025-07-15 22:08:03','56564e46556c38774d513d3d','4e54557a4d7a52684e7a41324d7a4d794d7a6b325a4459304e4467324e4459344e6a4d325a4455324d7a593d','','5256685158304e42564638784e5441334d6a41794e5445774d4467774d3138774d673d3d','56455642494556595545564f5530553d','6447566849475634634756756332553d','0');

INSERT INTO test_mohan_expense_category (id, created_date_time, creator, creator_name, bill_company_id, expense_category_id, expense_category_name, lower_case_name, deleted) VALUES ('3','2025-07-15 22:08:47','56564e46556c38774d513d3d','4e54557a4d7a52684e7a41324d7a4d794d7a6b325a4459304e4467324e4459344e6a4d325a4455324d7a593d','','5256685158304e42564638784e5441334d6a41794e5445774d4467304e3138774d773d3d','5530464d51564a5a49454645566b464f5130556752464a4a566b565349454654543074465331564e5156493d','6332467359584a354947466b646d4675593255675a484a70646d56794947467a6232746c613356745958493d','0');

INSERT INTO test_mohan_expense_category (id, created_date_time, creator, creator_name, bill_company_id, expense_category_id, expense_category_name, lower_case_name, deleted) VALUES ('4','2025-07-23 15:41:45','56564e46556c38774d513d3d','4e54557a4d7a52684e7a41324d7a4d794d7a6b325a4459304e4467324e4459344e6a4d325a4455324d7a593d','','5256685158304e42564638794d7a41334d6a41794e54417a4e4445304e5638774e413d3d','5530464d51564a5a4945525353565a465569413d','6332467359584a354947527961585a6c63673d3d','0');


CREATE TABLE `test_mohan_godown` (
  `id` int(100) NOT NULL AUTO_INCREMENT,
  `creator` mediumtext NOT NULL,
  `created_date_time` datetime NOT NULL,
  `creator_name` mediumtext NOT NULL,
  `bill_company_id` mediumtext NOT NULL,
  `godown_id` mediumtext NOT NULL,
  `name` mediumtext NOT NULL,
  `mobile_number` mediumtext NOT NULL,
  `lower_case_name` mediumtext NOT NULL,
  `deleted` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;



CREATE TABLE `test_mohan_godown_staff` (
  `id` int(100) NOT NULL AUTO_INCREMENT,
  `created_date_time` datetime NOT NULL,
  `creator` mediumtext NOT NULL,
  `creator_name` mediumtext NOT NULL,
  `bill_company_id` mediumtext NOT NULL,
  `staff_id` mediumtext NOT NULL,
  `name` mediumtext NOT NULL,
  `mobile_number` mediumtext NOT NULL,
  `username` mediumtext NOT NULL,
  `lower_case_name` mediumtext NOT NULL,
  `password` mediumtext NOT NULL,
  `deleted` int(100) NOT NULL,
  `access_pages` mediumtext NOT NULL,
  `godown_id` mediumtext NOT NULL,
  `access_page_actions` mediumtext NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;



CREATE TABLE `test_mohan_invest` (
  `id` int(100) NOT NULL AUTO_INCREMENT,
  `created_date_time` datetime NOT NULL,
  `creator` mediumtext NOT NULL,
  `creator_name` mediumtext NOT NULL,
  `bill_company_id` mediumtext NOT NULL,
  `invest_id` mediumtext NOT NULL,
  `invest_number` mediumtext NOT NULL,
  `invest_date` date NOT NULL,
  `party_name` mediumtext NOT NULL,
  `amount` mediumtext NOT NULL,
  `narration` mediumtext NOT NULL,
  `payment_mode_id` mediumtext NOT NULL,
  `payment_mode_name` mediumtext NOT NULL,
  `bank_id` mediumtext NOT NULL,
  `bank_name` mediumtext NOT NULL,
  `total_amount` mediumtext NOT NULL,
  `payment_tax_type` mediumtext NOT NULL,
  `deleted` int(10) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;


INSERT INTO test_mohan_invest (id, created_date_time, creator, creator_name, bill_company_id, invest_id, invest_number, invest_date, party_name, amount, narration, payment_mode_id, payment_mode_name, bank_id, bank_name, total_amount, payment_tax_type, deleted) VALUES ('1','2025-07-22 09:56:43','56564e46556c38774d513d3d','55334a706332396d64486468636d5636','54314a485155354a576b46555355394f587a45314d4455794d4449304d444d784e544935587a4178','5355355752564e55587a49794d4463794d4449314d446b314e6a517a587a4178','IN001/25-26','2025-07-22','5457396f5957343d','20000','516d6c7362413d3d','5547463562575675644639746232526c587a45784d4463794d4449314d5445774f544534587a4178','5279425151566b3d','516b464f533138784d5441334d6a41794e5445784d5451774e6c38774d513d3d','51306c5557534256546b6c50546942435155354c','20000','1','1');


CREATE TABLE `test_mohan_invoice` (
  `id` int(100) NOT NULL AUTO_INCREMENT,
  `created_date_time` datetime NOT NULL,
  `creator` mediumtext NOT NULL,
  `creator_name` mediumtext NOT NULL,
  `invoice_id` mediumtext NOT NULL,
  `invoice_number` mediumtext NOT NULL,
  `invoice_date` mediumtext NOT NULL,
  `organization_id` mediumtext NOT NULL,
  `consignor_id` mediumtext NOT NULL,
  `consignee_id` mediumtext NOT NULL,
  `driver_name` mediumtext NOT NULL,
  `helper_name` mediumtext NOT NULL,
  `lr_number` mediumtext NOT NULL,
  `branch_id` mediumtext NOT NULL,
  `vehicle_id` mediumtext NOT NULL,
  `is_acknowledged` mediumtext NOT NULL,
  `cancelled` mediumtext NOT NULL,
  `deleted` int(100) NOT NULL,
  `organization_details` mediumtext NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;



CREATE TABLE `test_mohan_login` (
  `id` int(100) NOT NULL AUTO_INCREMENT,
  `login_date_time` mediumtext NOT NULL,
  `logout_date_time` mediumtext NOT NULL,
  `ip_address` mediumtext NOT NULL,
  `browser` mediumtext NOT NULL,
  `os_detail` mediumtext NOT NULL,
  `type` mediumtext NOT NULL,
  `user_id` mediumtext NOT NULL,
  `deleted` int(100) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=114 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;


INSERT INTO test_mohan_login (id, login_date_time, logout_date_time, ip_address, browser, os_detail, type, user_id, deleted) VALUES ('1','2025-07-19 09:59:26','0000-00-00 00:00:00','103.93.105.58','Mozilla/5.0 (Windows NT 10.0; Win64; x64; rv:140.0) Gecko/20100101 Firefox/140.0','Linux sg2plmcpnl486913.prod.sin2.secureserver.net 4.18.0-553.51.1.lve.el8.x86_64 #1 SMP Tue May 6 15:14:12 UTC 2025 x86_64','Super Admin','56564e46556c38774d513d3d','0');

INSERT INTO test_mohan_login (id, login_date_time, logout_date_time, ip_address, browser, os_detail, type, user_id, deleted) VALUES ('2','2025-07-19 12:14:29','2025-07-19 13:33:08','117.196.83.98','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/138.0.0.0 Safari/537.36','Linux sg2plmcpnl486913.prod.sin2.secureserver.net 4.18.0-553.51.1.lve.el8.x86_64 #1 SMP Tue May 6 15:14:12 UTC 2025 x86_64','Super Admin','56564e46556c38774d513d3d','0');

INSERT INTO test_mohan_login (id, login_date_time, logout_date_time, ip_address, browser, os_detail, type, user_id, deleted) VALUES ('3','2025-07-19 15:28:04','0000-00-00 00:00:00','103.104.58.164','Mozilla/5.0 (Windows NT 10.0; Win64; x64; rv:140.0) Gecko/20100101 Firefox/140.0','Linux sg2plmcpnl486913.prod.sin2.secureserver.net 4.18.0-553.51.1.lve.el8.x86_64 #1 SMP Tue May 6 15:14:12 UTC 2025 x86_64','Super Admin','56564e46556c38774d513d3d','0');

INSERT INTO test_mohan_login (id, login_date_time, logout_date_time, ip_address, browser, os_detail, type, user_id, deleted) VALUES ('4','2025-07-19 18:51:05','0000-00-00 00:00:00','117.196.83.98','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/138.0.0.0 Safari/537.36','Linux sg2plmcpnl486913.prod.sin2.secureserver.net 4.18.0-553.51.1.lve.el8.x86_64 #1 SMP Tue May 6 15:14:12 UTC 2025 x86_64','Super Admin','56564e46556c38774d513d3d','0');

INSERT INTO test_mohan_login (id, login_date_time, logout_date_time, ip_address, browser, os_detail, type, user_id, deleted) VALUES ('5','2025-07-19 19:27:04','0000-00-00 00:00:00','223.182.226.35','Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/138.0.0.0 Safari/537.36','Linux sg2plmcpnl486913.prod.sin2.secureserver.net 4.18.0-553.51.1.lve.el8.x86_64 #1 SMP Tue May 6 15:14:12 UTC 2025 x86_64','Super Admin','56564e46556c38774d513d3d','0');

INSERT INTO test_mohan_login (id, login_date_time, logout_date_time, ip_address, browser, os_detail, type, user_id, deleted) VALUES ('6','2025-07-20 00:39:18','0000-00-00 00:00:00','223.185.219.162','Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/137.0.0.0 Mobile Safari/537.36','Linux sg2plmcpnl486913.prod.sin2.secureserver.net 4.18.0-553.51.1.lve.el8.x86_64 #1 SMP Tue May 6 15:14:12 UTC 2025 x86_64','Super Admin','56564e46556c38774d513d3d','0');

INSERT INTO test_mohan_login (id, login_date_time, logout_date_time, ip_address, browser, os_detail, type, user_id, deleted) VALUES ('7','2025-07-20 22:08:24','0000-00-00 00:00:00','157.51.37.81','Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/138.0.0.0 Mobile Safari/537.36','Linux sg2plmcpnl486913.prod.sin2.secureserver.net 4.18.0-553.51.1.lve.el8.x86_64 #1 SMP Tue May 6 15:14:12 UTC 2025 x86_64','Super Admin','56564e46556c38774d513d3d','0');

INSERT INTO test_mohan_login (id, login_date_time, logout_date_time, ip_address, browser, os_detail, type, user_id, deleted) VALUES ('8','2025-07-21 10:05:26','0000-00-00 00:00:00','157.51.38.53','Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/138.0.0.0 Mobile Safari/537.36','Linux sg2plmcpnl486913.prod.sin2.secureserver.net 4.18.0-553.51.1.lve.el8.x86_64 #1 SMP Tue May 6 15:14:12 UTC 2025 x86_64','Super Admin','56564e46556c38774d513d3d','0');

INSERT INTO test_mohan_login (id, login_date_time, logout_date_time, ip_address, browser, os_detail, type, user_id, deleted) VALUES ('9','2025-07-21 19:58:54','0000-00-00 00:00:00','117.196.94.41','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/138.0.0.0 Safari/537.36','Linux sg2plmcpnl486913.prod.sin2.secureserver.net 4.18.0-553.51.1.lve.el8.x86_64 #1 SMP Tue May 6 15:14:12 UTC 2025 x86_64','Super Admin','56564e46556c38774d513d3d','0');

INSERT INTO test_mohan_login (id, login_date_time, logout_date_time, ip_address, browser, os_detail, type, user_id, deleted) VALUES ('10','2025-07-21 22:09:21','0000-00-00 00:00:00','223.185.219.162','Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/137.0.0.0 Mobile Safari/537.36','Linux sg2plmcpnl486913.prod.sin2.secureserver.net 4.18.0-553.51.1.lve.el8.x86_64 #1 SMP Tue May 6 15:14:12 UTC 2025 x86_64','Super Admin','56564e46556c38774d513d3d','0');

INSERT INTO test_mohan_login (id, login_date_time, logout_date_time, ip_address, browser, os_detail, type, user_id, deleted) VALUES ('11','2025-07-21 22:10:13','0000-00-00 00:00:00','223.185.219.162','Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/137.0.0.0 Mobile Safari/537.36','Linux sg2plmcpnl486913.prod.sin2.secureserver.net 4.18.0-553.51.1.lve.el8.x86_64 #1 SMP Tue May 6 15:14:12 UTC 2025 x86_64','Super Admin','56564e46556c38774d513d3d','0');

INSERT INTO test_mohan_login (id, login_date_time, logout_date_time, ip_address, browser, os_detail, type, user_id, deleted) VALUES ('12','2025-07-21 22:21:28','0000-00-00 00:00:00','223.185.219.162','Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/137.0.0.0 Mobile Safari/537.36','Linux sg2plmcpnl486913.prod.sin2.secureserver.net 4.18.0-553.51.1.lve.el8.x86_64 #1 SMP Tue May 6 15:14:12 UTC 2025 x86_64','Super Admin','56564e46556c38774d513d3d','0');

INSERT INTO test_mohan_login (id, login_date_time, logout_date_time, ip_address, browser, os_detail, type, user_id, deleted) VALUES ('13','2025-07-22 09:34:40','2025-07-22 09:40:08','103.104.58.164','Mozilla/5.0 (Windows NT 10.0; Win64; x64; rv:140.0) Gecko/20100101 Firefox/140.0','Linux sg2plmcpnl486913.prod.sin2.secureserver.net 4.18.0-553.51.1.lve.el8.x86_64 #1 SMP Tue May 6 15:14:12 UTC 2025 x86_64','Super Admin','56564e46556c38774d513d3d','0');

INSERT INTO test_mohan_login (id, login_date_time, logout_date_time, ip_address, browser, os_detail, type, user_id, deleted) VALUES ('14','2025-07-22 09:40:19','2025-07-22 09:42:59','103.104.58.164','Mozilla/5.0 (Windows NT 10.0; Win64; x64; rv:140.0) Gecko/20100101 Firefox/140.0','Linux sg2plmcpnl486913.prod.sin2.secureserver.net 4.18.0-553.51.1.lve.el8.x86_64 #1 SMP Tue May 6 15:14:12 UTC 2025 x86_64','Staff','56564e46556c38784e4441334d6a41794e54417a4d7a4d7a4f5638774f413d3d','0');

INSERT INTO test_mohan_login (id, login_date_time, logout_date_time, ip_address, browser, os_detail, type, user_id, deleted) VALUES ('15','2025-07-22 09:43:12','2025-07-22 09:53:00','103.104.58.164','Mozilla/5.0 (Windows NT 10.0; Win64; x64; rv:140.0) Gecko/20100101 Firefox/140.0','Linux sg2plmcpnl486913.prod.sin2.secureserver.net 4.18.0-553.51.1.lve.el8.x86_64 #1 SMP Tue May 6 15:14:12 UTC 2025 x86_64','Staff','56564e46556c38784e4441334d6a41794e54417a4d7a4d7a4f5638774f413d3d','0');

INSERT INTO test_mohan_login (id, login_date_time, logout_date_time, ip_address, browser, os_detail, type, user_id, deleted) VALUES ('16','2025-07-22 09:53:03','0000-00-00 00:00:00','103.104.58.164','Mozilla/5.0 (Windows NT 10.0; Win64; x64; rv:140.0) Gecko/20100101 Firefox/140.0','Linux sg2plmcpnl486913.prod.sin2.secureserver.net 4.18.0-553.51.1.lve.el8.x86_64 #1 SMP Tue May 6 15:14:12 UTC 2025 x86_64','Super Admin','56564e46556c38774d513d3d','0');

INSERT INTO test_mohan_login (id, login_date_time, logout_date_time, ip_address, browser, os_detail, type, user_id, deleted) VALUES ('17','2025-07-22 10:55:44','0000-00-00 00:00:00','103.93.105.58','Mozilla/5.0 (Windows NT 10.0; Win64; x64; rv:140.0) Gecko/20100101 Firefox/140.0','Linux sg2plmcpnl486913.prod.sin2.secureserver.net 4.18.0-553.51.1.lve.el8.x86_64 #1 SMP Tue May 6 15:14:12 UTC 2025 x86_64','Super Admin','56564e46556c38774d513d3d','0');

INSERT INTO test_mohan_login (id, login_date_time, logout_date_time, ip_address, browser, os_detail, type, user_id, deleted) VALUES ('18','2025-07-22 10:59:24','0000-00-00 00:00:00','103.93.105.58','Mozilla/5.0 (Windows NT 10.0; Win64; x64; rv:140.0) Gecko/20100101 Firefox/140.0','Linux sg2plmcpnl486913.prod.sin2.secureserver.net 4.18.0-553.51.1.lve.el8.x86_64 #1 SMP Tue May 6 15:14:12 UTC 2025 x86_64','Super Admin','56564e46556c38774d513d3d','0');

INSERT INTO test_mohan_login (id, login_date_time, logout_date_time, ip_address, browser, os_detail, type, user_id, deleted) VALUES ('19','2025-07-22 14:43:59','0000-00-00 00:00:00','103.93.105.58','Mozilla/5.0 (Windows NT 10.0; Win64; x64; rv:140.0) Gecko/20100101 Firefox/140.0','Linux sg2plmcpnl486913.prod.sin2.secureserver.net 4.18.0-553.51.1.lve.el8.x86_64 #1 SMP Tue May 6 15:14:12 UTC 2025 x86_64','Super Admin','56564e46556c38774d513d3d','0');

INSERT INTO test_mohan_login (id, login_date_time, logout_date_time, ip_address, browser, os_detail, type, user_id, deleted) VALUES ('20','2025-07-22 17:22:57','0000-00-00 00:00:00','117.196.92.120','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/138.0.0.0 Safari/537.36','Linux sg2plmcpnl486913.prod.sin2.secureserver.net 4.18.0-553.51.1.lve.el8.x86_64 #1 SMP Tue May 6 15:14:12 UTC 2025 x86_64','Super Admin','56564e46556c38774d513d3d','0');

INSERT INTO test_mohan_login (id, login_date_time, logout_date_time, ip_address, browser, os_detail, type, user_id, deleted) VALUES ('21','2025-07-22 17:35:36','0000-00-00 00:00:00','103.93.105.58','Mozilla/5.0 (Windows NT 10.0; Win64; x64; rv:140.0) Gecko/20100101 Firefox/140.0','Linux sg2plmcpnl486913.prod.sin2.secureserver.net 4.18.0-553.51.1.lve.el8.x86_64 #1 SMP Tue May 6 15:14:12 UTC 2025 x86_64','Super Admin','56564e46556c38774d513d3d','0');

INSERT INTO test_mohan_login (id, login_date_time, logout_date_time, ip_address, browser, os_detail, type, user_id, deleted) VALUES ('22','2025-07-22 19:20:07','0000-00-00 00:00:00','103.104.58.164','Mozilla/5.0 (Windows NT 10.0; Win64; x64; rv:140.0) Gecko/20100101 Firefox/140.0','Linux sg2plmcpnl486913.prod.sin2.secureserver.net 4.18.0-553.51.1.lve.el8.x86_64 #1 SMP Tue May 6 15:14:12 UTC 2025 x86_64','Super Admin','56564e46556c38774d513d3d','0');

INSERT INTO test_mohan_login (id, login_date_time, logout_date_time, ip_address, browser, os_detail, type, user_id, deleted) VALUES ('23','2025-07-22 22:31:37','0000-00-00 00:00:00','223.185.219.162','Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/137.0.0.0 Mobile Safari/537.36','Linux sg2plmcpnl486913.prod.sin2.secureserver.net 4.18.0-553.51.1.lve.el8.x86_64 #1 SMP Tue May 6 15:14:12 UTC 2025 x86_64','Super Admin','56564e46556c38774d513d3d','0');

INSERT INTO test_mohan_login (id, login_date_time, logout_date_time, ip_address, browser, os_detail, type, user_id, deleted) VALUES ('24','2025-07-23 07:14:11','0000-00-00 00:00:00','223.185.219.162','Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/137.0.0.0 Mobile Safari/537.36','Linux sg2plmcpnl486913.prod.sin2.secureserver.net 4.18.0-553.51.1.lve.el8.x86_64 #1 SMP Tue May 6 15:14:12 UTC 2025 x86_64','Super Admin','56564e46556c38774d513d3d','0');

INSERT INTO test_mohan_login (id, login_date_time, logout_date_time, ip_address, browser, os_detail, type, user_id, deleted) VALUES ('25','2025-07-23 09:37:41','0000-00-00 00:00:00','103.93.105.58','Mozilla/5.0 (Windows NT 10.0; Win64; x64; rv:140.0) Gecko/20100101 Firefox/140.0','Linux sg2plmcpnl486913.prod.sin2.secureserver.net 4.18.0-553.51.1.lve.el8.x86_64 #1 SMP Tue May 6 15:14:12 UTC 2025 x86_64','Super Admin','56564e46556c38774d513d3d','0');

INSERT INTO test_mohan_login (id, login_date_time, logout_date_time, ip_address, browser, os_detail, type, user_id, deleted) VALUES ('26','2025-07-23 11:38:46','0000-00-00 00:00:00','223.182.226.57','Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/138.0.0.0 Safari/537.36','Linux sg2plmcpnl486913.prod.sin2.secureserver.net 4.18.0-553.51.1.lve.el8.x86_64 #1 SMP Tue May 6 15:14:12 UTC 2025 x86_64','Super Admin','56564e46556c38774d513d3d','0');

INSERT INTO test_mohan_login (id, login_date_time, logout_date_time, ip_address, browser, os_detail, type, user_id, deleted) VALUES ('27','2025-07-23 13:01:55','0000-00-00 00:00:00','117.221.15.228','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/138.0.0.0 Safari/537.36','Linux sg2plmcpnl486913.prod.sin2.secureserver.net 4.18.0-553.51.1.lve.el8.x86_64 #1 SMP Tue May 6 15:14:12 UTC 2025 x86_64','Super Admin','56564e46556c38774d513d3d','0');

INSERT INTO test_mohan_login (id, login_date_time, logout_date_time, ip_address, browser, os_detail, type, user_id, deleted) VALUES ('28','2025-07-23 13:22:00','0000-00-00 00:00:00','103.93.105.58','Mozilla/5.0 (Windows NT 10.0; Win64; x64; rv:141.0) Gecko/20100101 Firefox/141.0','Linux sg2plmcpnl486913.prod.sin2.secureserver.net 4.18.0-553.51.1.lve.el8.x86_64 #1 SMP Tue May 6 15:14:12 UTC 2025 x86_64','Super Admin','56564e46556c38774d513d3d','0');

INSERT INTO test_mohan_login (id, login_date_time, logout_date_time, ip_address, browser, os_detail, type, user_id, deleted) VALUES ('29','2025-07-23 13:23:23','0000-00-00 00:00:00','223.185.219.162','Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/137.0.0.0 Mobile Safari/537.36','Linux sg2plmcpnl486913.prod.sin2.secureserver.net 4.18.0-553.51.1.lve.el8.x86_64 #1 SMP Tue May 6 15:14:12 UTC 2025 x86_64','Super Admin','56564e46556c38774d513d3d','0');

INSERT INTO test_mohan_login (id, login_date_time, logout_date_time, ip_address, browser, os_detail, type, user_id, deleted) VALUES ('30','2025-07-23 15:34:28','0000-00-00 00:00:00','223.182.226.9','Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/138.0.0.0 Safari/537.36','Linux sg2plmcpnl486913.prod.sin2.secureserver.net 4.18.0-553.51.1.lve.el8.x86_64 #1 SMP Tue May 6 15:14:12 UTC 2025 x86_64','Super Admin','56564e46556c38774d513d3d','0');

INSERT INTO test_mohan_login (id, login_date_time, logout_date_time, ip_address, browser, os_detail, type, user_id, deleted) VALUES ('31','2025-07-23 15:36:57','0000-00-00 00:00:00','103.104.58.164','Mozilla/5.0 (Windows NT 10.0; Win64; x64; rv:140.0) Gecko/20100101 Firefox/140.0','Linux sg2plmcpnl486913.prod.sin2.secureserver.net 4.18.0-553.51.1.lve.el8.x86_64 #1 SMP Tue May 6 15:14:12 UTC 2025 x86_64','Super Admin','56564e46556c38774d513d3d','0');

INSERT INTO test_mohan_login (id, login_date_time, logout_date_time, ip_address, browser, os_detail, type, user_id, deleted) VALUES ('32','2025-07-23 15:55:21','0000-00-00 00:00:00','117.221.15.228','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/138.0.0.0 Safari/537.36','Linux sg2plmcpnl486913.prod.sin2.secureserver.net 4.18.0-553.51.1.lve.el8.x86_64 #1 SMP Tue May 6 15:14:12 UTC 2025 x86_64','Super Admin','56564e46556c38774d513d3d','0');

INSERT INTO test_mohan_login (id, login_date_time, logout_date_time, ip_address, browser, os_detail, type, user_id, deleted) VALUES ('33','2025-07-23 16:40:10','0000-00-00 00:00:00','103.93.105.58','Mozilla/5.0 (Windows NT 10.0; Win64; x64; rv:141.0) Gecko/20100101 Firefox/141.0','Linux sg2plmcpnl486913.prod.sin2.secureserver.net 4.18.0-553.51.1.lve.el8.x86_64 #1 SMP Tue May 6 15:14:12 UTC 2025 x86_64','Super Admin','56564e46556c38774d513d3d','0');

INSERT INTO test_mohan_login (id, login_date_time, logout_date_time, ip_address, browser, os_detail, type, user_id, deleted) VALUES ('34','2025-07-23 17:16:47','0000-00-00 00:00:00','103.93.105.58','Mozilla/5.0 (Windows NT 10.0; Win64; x64; rv:141.0) Gecko/20100101 Firefox/141.0','Linux sg2plmcpnl486913.prod.sin2.secureserver.net 4.18.0-553.51.1.lve.el8.x86_64 #1 SMP Tue May 6 15:14:12 UTC 2025 x86_64','Super Admin','56564e46556c38774d513d3d','0');

INSERT INTO test_mohan_login (id, login_date_time, logout_date_time, ip_address, browser, os_detail, type, user_id, deleted) VALUES ('35','2025-07-23 18:40:17','2025-07-23 20:13:16','117.221.15.228','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/138.0.0.0 Safari/537.36','Linux sg2plmcpnl486913.prod.sin2.secureserver.net 4.18.0-553.51.1.lve.el8.x86_64 #1 SMP Tue May 6 15:14:12 UTC 2025 x86_64','Super Admin','56564e46556c38774d513d3d','0');

INSERT INTO test_mohan_login (id, login_date_time, logout_date_time, ip_address, browser, os_detail, type, user_id, deleted) VALUES ('36','2025-07-23 18:58:03','0000-00-00 00:00:00','223.182.226.9','Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/138.0.0.0 Safari/537.36','Linux sg2plmcpnl486913.prod.sin2.secureserver.net 4.18.0-553.51.1.lve.el8.x86_64 #1 SMP Tue May 6 15:14:12 UTC 2025 x86_64','Super Admin','56564e46556c38774d513d3d','0');

INSERT INTO test_mohan_login (id, login_date_time, logout_date_time, ip_address, browser, os_detail, type, user_id, deleted) VALUES ('37','2025-07-23 20:50:29','2025-07-23 20:53:27','223.185.219.162','Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/137.0.0.0 Mobile Safari/537.36','Linux sg2plmcpnl486913.prod.sin2.secureserver.net 4.18.0-553.51.1.lve.el8.x86_64 #1 SMP Tue May 6 15:14:12 UTC 2025 x86_64','Super Admin','56564e46556c38774d513d3d','0');

INSERT INTO test_mohan_login (id, login_date_time, logout_date_time, ip_address, browser, os_detail, type, user_id, deleted) VALUES ('38','2025-07-23 20:53:29','2025-07-23 20:57:01','223.185.219.162','Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/137.0.0.0 Mobile Safari/537.36','Linux sg2plmcpnl486913.prod.sin2.secureserver.net 4.18.0-553.51.1.lve.el8.x86_64 #1 SMP Tue May 6 15:14:12 UTC 2025 x86_64','Staff','56564e46556c38784d5441334d6a41794e5441354e54517a4d5638774e773d3d','0');

INSERT INTO test_mohan_login (id, login_date_time, logout_date_time, ip_address, browser, os_detail, type, user_id, deleted) VALUES ('39','2025-07-23 20:57:03','0000-00-00 00:00:00','223.185.219.162','Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/137.0.0.0 Mobile Safari/537.36','Linux sg2plmcpnl486913.prod.sin2.secureserver.net 4.18.0-553.51.1.lve.el8.x86_64 #1 SMP Tue May 6 15:14:12 UTC 2025 x86_64','Super Admin','56564e46556c38774d513d3d','0');

INSERT INTO test_mohan_login (id, login_date_time, logout_date_time, ip_address, browser, os_detail, type, user_id, deleted) VALUES ('40','2025-07-24 10:22:10','2025-07-24 10:23:27','223.182.226.9','Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/138.0.0.0 Safari/537.36','Linux sg2plmcpnl486913.prod.sin2.secureserver.net 4.18.0-553.51.1.lve.el8.x86_64 #1 SMP Tue May 6 15:14:12 UTC 2025 x86_64','Super Admin','56564e46556c38774d513d3d','0');

INSERT INTO test_mohan_login (id, login_date_time, logout_date_time, ip_address, browser, os_detail, type, user_id, deleted) VALUES ('41','2025-07-24 16:38:48','0000-00-00 00:00:00','157.51.47.53','Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/138.0.0.0 Mobile Safari/537.36','Linux sg2plmcpnl486913.prod.sin2.secureserver.net 4.18.0-553.51.1.lve.el8.x86_64 #1 SMP Tue May 6 15:14:12 UTC 2025 x86_64','Super Admin','56564e46556c38774d513d3d','0');

INSERT INTO test_mohan_login (id, login_date_time, logout_date_time, ip_address, browser, os_detail, type, user_id, deleted) VALUES ('42','2025-07-24 18:11:05','2025-07-24 21:38:16','117.221.0.212','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/138.0.0.0 Safari/537.36','Linux sg2plmcpnl486913.prod.sin2.secureserver.net 4.18.0-553.51.1.lve.el8.x86_64 #1 SMP Tue May 6 15:14:12 UTC 2025 x86_64','Super Admin','56564e46556c38774d513d3d','0');

INSERT INTO test_mohan_login (id, login_date_time, logout_date_time, ip_address, browser, os_detail, type, user_id, deleted) VALUES ('43','2025-07-25 09:36:28','0000-00-00 00:00:00','103.104.58.164','Mozilla/5.0 (Windows NT 10.0; Win64; x64; rv:140.0) Gecko/20100101 Firefox/140.0','Linux sg2plmcpnl486913.prod.sin2.secureserver.net 4.18.0-553.51.1.lve.el8.x86_64 #1 SMP Tue May 6 15:14:12 UTC 2025 x86_64','Super Admin','56564e46556c38774d513d3d','0');

INSERT INTO test_mohan_login (id, login_date_time, logout_date_time, ip_address, browser, os_detail, type, user_id, deleted) VALUES ('44','2025-07-25 09:38:58','0000-00-00 00:00:00','103.104.58.164','Mozilla/5.0 (Windows NT 10.0; Win64; x64; rv:140.0) Gecko/20100101 Firefox/140.0','Linux sg2plmcpnl486913.prod.sin2.secureserver.net 4.18.0-553.51.1.lve.el8.x86_64 #1 SMP Tue May 6 15:14:12 UTC 2025 x86_64','Super Admin','56564e46556c38774d513d3d','0');

INSERT INTO test_mohan_login (id, login_date_time, logout_date_time, ip_address, browser, os_detail, type, user_id, deleted) VALUES ('45','2025-07-25 20:49:07','0000-00-00 00:00:00','157.51.46.49','Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/138.0.0.0 Mobile Safari/537.36','Linux sg2plmcpnl486913.prod.sin2.secureserver.net 4.18.0-553.51.1.lve.el8.x86_64 #1 SMP Tue May 6 15:14:12 UTC 2025 x86_64','Super Admin','56564e46556c38774d513d3d','0');

INSERT INTO test_mohan_login (id, login_date_time, logout_date_time, ip_address, browser, os_detail, type, user_id, deleted) VALUES ('46','2025-07-25 20:53:00','0000-00-00 00:00:00','157.51.46.49','Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/138.0.0.0 Mobile Safari/537.36','Linux sg2plmcpnl486913.prod.sin2.secureserver.net 4.18.0-553.51.1.lve.el8.x86_64 #1 SMP Tue May 6 15:14:12 UTC 2025 x86_64','Super Admin','56564e46556c38774d513d3d','0');

INSERT INTO test_mohan_login (id, login_date_time, logout_date_time, ip_address, browser, os_detail, type, user_id, deleted) VALUES ('47','2025-07-26 12:22:12','0000-00-00 00:00:00','106.211.206.116','Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/138.0.0.0 Safari/537.36','Linux sg2plmcpnl486913.prod.sin2.secureserver.net 4.18.0-553.51.1.lve.el8.x86_64 #1 SMP Tue May 6 15:14:12 UTC 2025 x86_64','Super Admin','56564e46556c38774d513d3d','0');

INSERT INTO test_mohan_login (id, login_date_time, logout_date_time, ip_address, browser, os_detail, type, user_id, deleted) VALUES ('48','2025-07-26 13:01:40','2025-07-26 13:41:20','117.221.10.48','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/138.0.0.0 Safari/537.36','Linux sg2plmcpnl486913.prod.sin2.secureserver.net 4.18.0-553.51.1.lve.el8.x86_64 #1 SMP Tue May 6 15:14:12 UTC 2025 x86_64','Super Admin','56564e46556c38774d513d3d','0');

INSERT INTO test_mohan_login (id, login_date_time, logout_date_time, ip_address, browser, os_detail, type, user_id, deleted) VALUES ('49','2025-07-26 17:40:42','0000-00-00 00:00:00','117.221.10.48','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/138.0.0.0 Safari/537.36','Linux sg2plmcpnl486913.prod.sin2.secureserver.net 4.18.0-553.51.1.lve.el8.x86_64 #1 SMP Tue May 6 15:14:12 UTC 2025 x86_64','Super Admin','56564e46556c38774d513d3d','0');

INSERT INTO test_mohan_login (id, login_date_time, logout_date_time, ip_address, browser, os_detail, type, user_id, deleted) VALUES ('50','2025-07-26 17:41:05','0000-00-00 00:00:00','103.104.58.164','Mozilla/5.0 (Windows NT 10.0; Win64; x64; rv:141.0) Gecko/20100101 Firefox/141.0','Linux sg2plmcpnl486913.prod.sin2.secureserver.net 4.18.0-553.51.1.lve.el8.x86_64 #1 SMP Tue May 6 15:14:12 UTC 2025 x86_64','Super Admin','56564e46556c38774d513d3d','0');

INSERT INTO test_mohan_login (id, login_date_time, logout_date_time, ip_address, browser, os_detail, type, user_id, deleted) VALUES ('51','2025-07-26 21:17:57','0000-00-00 00:00:00','106.211.206.116','Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/138.0.0.0 Safari/537.36','Linux sg2plmcpnl486913.prod.sin2.secureserver.net 4.18.0-553.51.1.lve.el8.x86_64 #1 SMP Tue May 6 15:14:12 UTC 2025 x86_64','Super Admin','56564e46556c38774d513d3d','0');

INSERT INTO test_mohan_login (id, login_date_time, logout_date_time, ip_address, browser, os_detail, type, user_id, deleted) VALUES ('52','2025-07-27 01:10:02','0000-00-00 00:00:00','223.185.219.162','Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/137.0.0.0 Mobile Safari/537.36','Linux sg2plmcpnl486913.prod.sin2.secureserver.net 4.18.0-553.51.1.lve.el8.x86_64 #1 SMP Tue May 6 15:14:12 UTC 2025 x86_64','Super Admin','56564e46556c38774d513d3d','0');

INSERT INTO test_mohan_login (id, login_date_time, logout_date_time, ip_address, browser, os_detail, type, user_id, deleted) VALUES ('53','2025-07-27 21:28:09','0000-00-00 00:00:00','223.185.219.162','Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/137.0.0.0 Mobile Safari/537.36','Linux sg2plmcpnl486913.prod.sin2.secureserver.net 4.18.0-553.51.1.lve.el8.x86_64 #1 SMP Tue May 6 15:14:12 UTC 2025 x86_64','Super Admin','56564e46556c38774d513d3d','0');

INSERT INTO test_mohan_login (id, login_date_time, logout_date_time, ip_address, browser, os_detail, type, user_id, deleted) VALUES ('54','2025-07-28 14:38:11','0000-00-00 00:00:00','223.185.219.162','Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/137.0.0.0 Mobile Safari/537.36','Linux sg2plmcpnl486913.prod.sin2.secureserver.net 4.18.0-553.51.1.lve.el8.x86_64 #1 SMP Tue May 6 15:14:12 UTC 2025 x86_64','Super Admin','56564e46556c38774d513d3d','0');

INSERT INTO test_mohan_login (id, login_date_time, logout_date_time, ip_address, browser, os_detail, type, user_id, deleted) VALUES ('55','2025-07-28 16:49:13','0000-00-00 00:00:00','117.196.84.219','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/138.0.0.0 Safari/537.36','Linux sg2plmcpnl486913.prod.sin2.secureserver.net 4.18.0-553.51.1.lve.el8.x86_64 #1 SMP Tue May 6 15:14:12 UTC 2025 x86_64','Super Admin','56564e46556c38774d513d3d','0');

INSERT INTO test_mohan_login (id, login_date_time, logout_date_time, ip_address, browser, os_detail, type, user_id, deleted) VALUES ('56','2025-07-28 18:46:08','0000-00-00 00:00:00','117.196.84.219','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/138.0.0.0 Safari/537.36','Linux sg2plmcpnl486913.prod.sin2.secureserver.net 4.18.0-553.51.1.lve.el8.x86_64 #1 SMP Tue May 6 15:14:12 UTC 2025 x86_64','Super Admin','56564e46556c38774d513d3d','0');

INSERT INTO test_mohan_login (id, login_date_time, logout_date_time, ip_address, browser, os_detail, type, user_id, deleted) VALUES ('57','2025-07-28 21:47:07','0000-00-00 00:00:00','157.51.1.202','Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/138.0.0.0 Mobile Safari/537.36','Linux sg2plmcpnl486913.prod.sin2.secureserver.net 4.18.0-553.51.1.lve.el8.x86_64 #1 SMP Tue May 6 15:14:12 UTC 2025 x86_64','Super Admin','56564e46556c38774d513d3d','0');

INSERT INTO test_mohan_login (id, login_date_time, logout_date_time, ip_address, browser, os_detail, type, user_id, deleted) VALUES ('58','2025-07-29 10:43:28','0000-00-00 00:00:00','106.211.206.116','Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/138.0.0.0 Safari/537.36','Linux sg2plmcpnl486913.prod.sin2.secureserver.net 4.18.0-553.51.1.lve.el8.x86_64 #1 SMP Tue May 6 15:14:12 UTC 2025 x86_64','Super Admin','56564e46556c38774d513d3d','0');

INSERT INTO test_mohan_login (id, login_date_time, logout_date_time, ip_address, browser, os_detail, type, user_id, deleted) VALUES ('59','2025-07-29 11:50:19','0000-00-00 00:00:00','106.211.206.116','Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/138.0.0.0 Safari/537.36','Linux sg2plmcpnl486913.prod.sin2.secureserver.net 4.18.0-553.51.1.lve.el8.x86_64 #1 SMP Tue May 6 15:14:12 UTC 2025 x86_64','Super Admin','56564e46556c38774d513d3d','0');

INSERT INTO test_mohan_login (id, login_date_time, logout_date_time, ip_address, browser, os_detail, type, user_id, deleted) VALUES ('60','2025-07-29 17:52:48','0000-00-00 00:00:00','117.196.90.57','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/138.0.0.0 Safari/537.36','Linux sg2plmcpnl486913.prod.sin2.secureserver.net 4.18.0-553.51.1.lve.el8.x86_64 #1 SMP Tue May 6 15:14:12 UTC 2025 x86_64','Super Admin','56564e46556c38774d513d3d','0');

INSERT INTO test_mohan_login (id, login_date_time, logout_date_time, ip_address, browser, os_detail, type, user_id, deleted) VALUES ('61','2025-07-30 12:07:54','0000-00-00 00:00:00','157.51.25.93','Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/138.0.0.0 Mobile Safari/537.36','Linux sg2plmcpnl486913.prod.sin2.secureserver.net 4.18.0-553.51.1.lve.el8.x86_64 #1 SMP Tue May 6 15:14:12 UTC 2025 x86_64','Super Admin','56564e46556c38774d513d3d','0');

INSERT INTO test_mohan_login (id, login_date_time, logout_date_time, ip_address, browser, os_detail, type, user_id, deleted) VALUES ('62','2025-07-30 19:38:39','0000-00-00 00:00:00','59.93.66.108','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/138.0.0.0 Safari/537.36','Linux sg2plmcpnl486913.prod.sin2.secureserver.net 4.18.0-553.51.1.lve.el8.x86_64 #1 SMP Tue May 6 15:14:12 UTC 2025 x86_64','Super Admin','56564e46556c38774d513d3d','0');

INSERT INTO test_mohan_login (id, login_date_time, logout_date_time, ip_address, browser, os_detail, type, user_id, deleted) VALUES ('63','2025-07-30 19:48:34','0000-00-00 00:00:00','106.211.206.93','Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/138.0.0.0 Safari/537.36','Linux sg2plmcpnl486913.prod.sin2.secureserver.net 4.18.0-553.51.1.lve.el8.x86_64 #1 SMP Tue May 6 15:14:12 UTC 2025 x86_64','Super Admin','56564e46556c38774d513d3d','0');

INSERT INTO test_mohan_login (id, login_date_time, logout_date_time, ip_address, browser, os_detail, type, user_id, deleted) VALUES ('64','2025-07-30 20:11:30','0000-00-00 00:00:00','106.211.206.93','Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/138.0.0.0 Safari/537.36','Linux sg2plmcpnl486913.prod.sin2.secureserver.net 4.18.0-553.51.1.lve.el8.x86_64 #1 SMP Tue May 6 15:14:12 UTC 2025 x86_64','Super Admin','56564e46556c38774d513d3d','0');

INSERT INTO test_mohan_login (id, login_date_time, logout_date_time, ip_address, browser, os_detail, type, user_id, deleted) VALUES ('65','2025-07-30 22:25:21','0000-00-00 00:00:00','223.182.201.244','Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/137.0.0.0 Mobile Safari/537.36','Linux sg2plmcpnl486913.prod.sin2.secureserver.net 4.18.0-553.51.1.lve.el8.x86_64 #1 SMP Tue May 6 15:14:12 UTC 2025 x86_64','Super Admin','56564e46556c38774d513d3d','0');

INSERT INTO test_mohan_login (id, login_date_time, logout_date_time, ip_address, browser, os_detail, type, user_id, deleted) VALUES ('66','2025-07-30 23:02:24','0000-00-00 00:00:00','223.182.201.244','Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/137.0.0.0 Mobile Safari/537.36','Linux sg2plmcpnl486913.prod.sin2.secureserver.net 4.18.0-553.51.1.lve.el8.x86_64 #1 SMP Tue May 6 15:14:12 UTC 2025 x86_64','Staff','56564e46556c38784d5441334d6a41794e5441354e54517a4d5638774e773d3d','0');

INSERT INTO test_mohan_login (id, login_date_time, logout_date_time, ip_address, browser, os_detail, type, user_id, deleted) VALUES ('67','2025-07-31 09:47:45','0000-00-00 00:00:00','103.104.58.164','Mozilla/5.0 (Windows NT 10.0; Win64; x64; rv:141.0) Gecko/20100101 Firefox/141.0','Linux sg2plmcpnl486913.prod.sin2.secureserver.net 4.18.0-553.51.1.lve.el8.x86_64 #1 SMP Tue May 6 15:14:12 UTC 2025 x86_64','Super Admin','56564e46556c38774d513d3d','0');

INSERT INTO test_mohan_login (id, login_date_time, logout_date_time, ip_address, browser, os_detail, type, user_id, deleted) VALUES ('68','2025-07-31 10:23:12','0000-00-00 00:00:00','103.104.58.164','Mozilla/5.0 (Windows NT 10.0; Win64; x64; rv:141.0) Gecko/20100101 Firefox/141.0','Linux sg2plmcpnl486913.prod.sin2.secureserver.net 4.18.0-553.51.1.lve.el8.x86_64 #1 SMP Tue May 6 15:14:12 UTC 2025 x86_64','Super Admin','56564e46556c38774d513d3d','0');

INSERT INTO test_mohan_login (id, login_date_time, logout_date_time, ip_address, browser, os_detail, type, user_id, deleted) VALUES ('69','2025-07-31 22:54:19','0000-00-00 00:00:00','223.182.201.244','Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/137.0.0.0 Mobile Safari/537.36','Linux sg2plmcpnl486913.prod.sin2.secureserver.net 4.18.0-553.51.1.lve.el8.x86_64 #1 SMP Tue May 6 15:14:12 UTC 2025 x86_64','Super Admin','56564e46556c38774d513d3d','0');

INSERT INTO test_mohan_login (id, login_date_time, logout_date_time, ip_address, browser, os_detail, type, user_id, deleted) VALUES ('70','2025-08-01 10:21:38','0000-00-00 00:00:00','223.182.201.244','Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/137.0.0.0 Mobile Safari/537.36','Linux sg2plmcpnl486913.prod.sin2.secureserver.net 4.18.0-553.51.1.lve.el8.x86_64 #1 SMP Tue May 6 15:14:12 UTC 2025 x86_64','Super Admin','56564e46556c38774d513d3d','0');

INSERT INTO test_mohan_login (id, login_date_time, logout_date_time, ip_address, browser, os_detail, type, user_id, deleted) VALUES ('71','2025-08-01 11:27:42','0000-00-00 00:00:00','59.98.49.23','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/138.0.0.0 Safari/537.36','Linux sg2plmcpnl486913.prod.sin2.secureserver.net 4.18.0-553.51.1.lve.el8.x86_64 #1 SMP Tue May 6 15:14:12 UTC 2025 x86_64','Super Admin','56564e46556c38774d513d3d','0');

INSERT INTO test_mohan_login (id, login_date_time, logout_date_time, ip_address, browser, os_detail, type, user_id, deleted) VALUES ('72','2025-08-01 15:11:28','0000-00-00 00:00:00','223.181.247.200','Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/137.0.0.0 Mobile Safari/537.36','Linux sg2plmcpnl486913.prod.sin2.secureserver.net 4.18.0-553.51.1.lve.el8.x86_64 #1 SMP Tue May 6 15:14:12 UTC 2025 x86_64','Super Admin','56564e46556c38774d513d3d','0');

INSERT INTO test_mohan_login (id, login_date_time, logout_date_time, ip_address, browser, os_detail, type, user_id, deleted) VALUES ('73','2025-08-01 19:24:56','0000-00-00 00:00:00','106.211.206.93','Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/138.0.0.0 Safari/537.36','Linux sg2plmcpnl486913.prod.sin2.secureserver.net 4.18.0-553.51.1.lve.el8.x86_64 #1 SMP Tue May 6 15:14:12 UTC 2025 x86_64','Super Admin','56564e46556c38774d513d3d','0');

INSERT INTO test_mohan_login (id, login_date_time, logout_date_time, ip_address, browser, os_detail, type, user_id, deleted) VALUES ('74','2025-08-01 20:01:55','0000-00-00 00:00:00','106.211.206.93','Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/138.0.0.0 Safari/537.36','Linux sg2plmcpnl486913.prod.sin2.secureserver.net 4.18.0-553.51.1.lve.el8.x86_64 #1 SMP Tue May 6 15:14:12 UTC 2025 x86_64','Super Admin','56564e46556c38774d513d3d','0');

INSERT INTO test_mohan_login (id, login_date_time, logout_date_time, ip_address, browser, os_detail, type, user_id, deleted) VALUES ('75','2025-08-02 10:58:34','0000-00-00 00:00:00','223.181.247.200','Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/137.0.0.0 Mobile Safari/537.36','Linux sg2plmcpnl486913.prod.sin2.secureserver.net 4.18.0-553.51.1.lve.el8.x86_64 #1 SMP Tue May 6 15:14:12 UTC 2025 x86_64','Super Admin','56564e46556c38774d513d3d','0');

INSERT INTO test_mohan_login (id, login_date_time, logout_date_time, ip_address, browser, os_detail, type, user_id, deleted) VALUES ('76','2025-08-02 13:10:49','0000-00-00 00:00:00','223.181.241.177','Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/137.0.0.0 Mobile Safari/537.36','Linux sg2plmcpnl486913.prod.sin2.secureserver.net 4.18.0-553.51.1.lve.el8.x86_64 #1 SMP Tue May 6 15:14:12 UTC 2025 x86_64','Super Admin','56564e46556c38774d513d3d','0');

INSERT INTO test_mohan_login (id, login_date_time, logout_date_time, ip_address, browser, os_detail, type, user_id, deleted) VALUES ('77','2025-08-02 13:11:11','0000-00-00 00:00:00','223.181.241.177','Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/137.0.0.0 Mobile Safari/537.36','Linux sg2plmcpnl486913.prod.sin2.secureserver.net 4.18.0-553.51.1.lve.el8.x86_64 #1 SMP Tue May 6 15:14:12 UTC 2025 x86_64','Super Admin','56564e46556c38774d513d3d','0');

INSERT INTO test_mohan_login (id, login_date_time, logout_date_time, ip_address, browser, os_detail, type, user_id, deleted) VALUES ('78','2025-08-02 13:47:02','0000-00-00 00:00:00','223.181.241.177','Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/137.0.0.0 Mobile Safari/537.36','Linux sg2plmcpnl486913.prod.sin2.secureserver.net 4.18.0-553.51.1.lve.el8.x86_64 #1 SMP Tue May 6 15:14:12 UTC 2025 x86_64','Super Admin','56564e46556c38774d513d3d','0');

INSERT INTO test_mohan_login (id, login_date_time, logout_date_time, ip_address, browser, os_detail, type, user_id, deleted) VALUES ('79','2025-08-02 14:34:46','2025-08-02 14:35:56','223.181.241.177','Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/137.0.0.0 Mobile Safari/537.36','Linux sg2plmcpnl486913.prod.sin2.secureserver.net 4.18.0-553.51.1.lve.el8.x86_64 #1 SMP Tue May 6 15:14:12 UTC 2025 x86_64','Super Admin','56564e46556c38774d513d3d','0');

INSERT INTO test_mohan_login (id, login_date_time, logout_date_time, ip_address, browser, os_detail, type, user_id, deleted) VALUES ('80','2025-08-02 14:45:19','0000-00-00 00:00:00','223.181.241.177','Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/137.0.0.0 Mobile Safari/537.36','Linux sg2plmcpnl486913.prod.sin2.secureserver.net 4.18.0-553.51.1.lve.el8.x86_64 #1 SMP Tue May 6 15:14:12 UTC 2025 x86_64','Super Admin','56564e46556c38774d513d3d','0');

INSERT INTO test_mohan_login (id, login_date_time, logout_date_time, ip_address, browser, os_detail, type, user_id, deleted) VALUES ('81','2025-08-02 16:11:23','0000-00-00 00:00:00','223.181.241.177','Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/137.0.0.0 Mobile Safari/537.36','Linux sg2plmcpnl486913.prod.sin2.secureserver.net 4.18.0-553.51.1.lve.el8.x86_64 #1 SMP Tue May 6 15:14:12 UTC 2025 x86_64','Super Admin','56564e46556c38774d513d3d','0');

INSERT INTO test_mohan_login (id, login_date_time, logout_date_time, ip_address, browser, os_detail, type, user_id, deleted) VALUES ('82','2025-08-02 17:16:51','2025-08-02 18:42:56','106.211.206.93','Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/138.0.0.0 Safari/537.36','Linux sg2plmcpnl486913.prod.sin2.secureserver.net 4.18.0-553.51.1.lve.el8.x86_64 #1 SMP Tue May 6 15:14:12 UTC 2025 x86_64','Super Admin','56564e46556c38774d513d3d','0');

INSERT INTO test_mohan_login (id, login_date_time, logout_date_time, ip_address, browser, os_detail, type, user_id, deleted) VALUES ('83','2025-08-02 18:03:23','0000-00-00 00:00:00','103.104.58.164','Mozilla/5.0 (Windows NT 10.0; Win64; x64; rv:141.0) Gecko/20100101 Firefox/141.0','Linux sg2plmcpnl486913.prod.sin2.secureserver.net 4.18.0-553.51.1.lve.el8.x86_64 #1 SMP Tue May 6 15:14:12 UTC 2025 x86_64','Super Admin','56564e46556c38774d513d3d','0');

INSERT INTO test_mohan_login (id, login_date_time, logout_date_time, ip_address, browser, os_detail, type, user_id, deleted) VALUES ('84','2025-08-02 18:43:02','0000-00-00 00:00:00','106.211.206.93','Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/138.0.0.0 Safari/537.36','Linux sg2plmcpnl486913.prod.sin2.secureserver.net 4.18.0-553.51.1.lve.el8.x86_64 #1 SMP Tue May 6 15:14:12 UTC 2025 x86_64','Super Admin','56564e46556c38774d513d3d','0');

INSERT INTO test_mohan_login (id, login_date_time, logout_date_time, ip_address, browser, os_detail, type, user_id, deleted) VALUES ('85','2025-08-02 18:45:11','0000-00-00 00:00:00','106.211.206.93','Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/138.0.0.0 Safari/537.36','Linux sg2plmcpnl486913.prod.sin2.secureserver.net 4.18.0-553.51.1.lve.el8.x86_64 #1 SMP Tue May 6 15:14:12 UTC 2025 x86_64','Super Admin','56564e46556c38774d513d3d','0');

INSERT INTO test_mohan_login (id, login_date_time, logout_date_time, ip_address, browser, os_detail, type, user_id, deleted) VALUES ('86','2025-08-02 18:49:32','0000-00-00 00:00:00','103.104.58.164','Mozilla/5.0 (Windows NT 10.0; Win64; x64; rv:141.0) Gecko/20100101 Firefox/141.0','Linux sg2plmcpnl486913.prod.sin2.secureserver.net 4.18.0-553.51.1.lve.el8.x86_64 #1 SMP Tue May 6 15:14:12 UTC 2025 x86_64','Super Admin','56564e46556c38774d513d3d','0');

INSERT INTO test_mohan_login (id, login_date_time, logout_date_time, ip_address, browser, os_detail, type, user_id, deleted) VALUES ('87','2025-08-02 19:54:36','2025-08-02 19:55:31','106.211.206.93','Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/138.0.0.0 Safari/537.36','Linux sg2plmcpnl486913.prod.sin2.secureserver.net 4.18.0-553.51.1.lve.el8.x86_64 #1 SMP Tue May 6 15:14:12 UTC 2025 x86_64','Super Admin','56564e46556c38774d513d3d','0');

INSERT INTO test_mohan_login (id, login_date_time, logout_date_time, ip_address, browser, os_detail, type, user_id, deleted) VALUES ('88','2025-08-02 19:55:34','2025-08-02 20:18:12','106.211.206.93','Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/138.0.0.0 Safari/537.36','Linux sg2plmcpnl486913.prod.sin2.secureserver.net 4.18.0-553.51.1.lve.el8.x86_64 #1 SMP Tue May 6 15:14:12 UTC 2025 x86_64','Super Admin','56564e46556c38774d513d3d','0');

INSERT INTO test_mohan_login (id, login_date_time, logout_date_time, ip_address, browser, os_detail, type, user_id, deleted) VALUES ('89','2025-08-02 20:18:17','0000-00-00 00:00:00','106.211.206.93','Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/138.0.0.0 Safari/537.36','Linux sg2plmcpnl486913.prod.sin2.secureserver.net 4.18.0-553.51.1.lve.el8.x86_64 #1 SMP Tue May 6 15:14:12 UTC 2025 x86_64','Super Admin','56564e46556c38774d513d3d','0');

INSERT INTO test_mohan_login (id, login_date_time, logout_date_time, ip_address, browser, os_detail, type, user_id, deleted) VALUES ('90','2025-08-02 20:24:02','0000-00-00 00:00:00','103.104.58.164','Mozilla/5.0 (Windows NT 10.0; Win64; x64; rv:141.0) Gecko/20100101 Firefox/141.0','Linux sg2plmcpnl486913.prod.sin2.secureserver.net 4.18.0-553.51.1.lve.el8.x86_64 #1 SMP Tue May 6 15:14:12 UTC 2025 x86_64','Super Admin','56564e46556c38774d513d3d','0');

INSERT INTO test_mohan_login (id, login_date_time, logout_date_time, ip_address, browser, os_detail, type, user_id, deleted) VALUES ('91','2025-08-02 20:24:22','0000-00-00 00:00:00','157.51.34.45','Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/138.0.0.0 Mobile Safari/537.36','Linux sg2plmcpnl486913.prod.sin2.secureserver.net 4.18.0-553.51.1.lve.el8.x86_64 #1 SMP Tue May 6 15:14:12 UTC 2025 x86_64','Super Admin','56564e46556c38774d513d3d','0');

INSERT INTO test_mohan_login (id, login_date_time, logout_date_time, ip_address, browser, os_detail, type, user_id, deleted) VALUES ('92','2025-08-02 21:42:19','0000-00-00 00:00:00','106.211.206.93','Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/138.0.0.0 Safari/537.36','Linux sg2plmcpnl486913.prod.sin2.secureserver.net 4.18.0-553.51.1.lve.el8.x86_64 #1 SMP Tue May 6 15:14:12 UTC 2025 x86_64','Super Admin','56564e46556c38774d513d3d','0');

INSERT INTO test_mohan_login (id, login_date_time, logout_date_time, ip_address, browser, os_detail, type, user_id, deleted) VALUES ('93','2025-08-02 23:57:20','0000-00-00 00:00:00','106.211.206.93','Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/138.0.0.0 Safari/537.36','Linux sg2plmcpnl486913.prod.sin2.secureserver.net 4.18.0-553.51.1.lve.el8.x86_64 #1 SMP Tue May 6 15:14:12 UTC 2025 x86_64','Super Admin','56564e46556c38774d513d3d','0');

INSERT INTO test_mohan_login (id, login_date_time, logout_date_time, ip_address, browser, os_detail, type, user_id, deleted) VALUES ('94','2025-08-03 00:00:50','0000-00-00 00:00:00','106.211.206.93','Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/138.0.0.0 Safari/537.36','Linux sg2plmcpnl486913.prod.sin2.secureserver.net 4.18.0-553.51.1.lve.el8.x86_64 #1 SMP Tue May 6 15:14:12 UTC 2025 x86_64','Super Admin','56564e46556c38774d513d3d','0');

INSERT INTO test_mohan_login (id, login_date_time, logout_date_time, ip_address, browser, os_detail, type, user_id, deleted) VALUES ('95','2025-08-04 13:05:53','0000-00-00 00:00:00','106.211.206.93','Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/138.0.0.0 Safari/537.36','Linux sg2plmcpnl486913.prod.sin2.secureserver.net 4.18.0-553.51.1.lve.el8.x86_64 #1 SMP Tue May 6 15:14:12 UTC 2025 x86_64','Super Admin','56564e46556c38774d513d3d','0');

INSERT INTO test_mohan_login (id, login_date_time, logout_date_time, ip_address, browser, os_detail, type, user_id, deleted) VALUES ('96','2025-08-04 13:08:22','0000-00-00 00:00:00','223.237.184.43','Mozilla/5.0 (Windows NT 10.0; Win64; x64; rv:141.0) Gecko/20100101 Firefox/141.0','Linux sg2plmcpnl486913.prod.sin2.secureserver.net 4.18.0-553.51.1.lve.el8.x86_64 #1 SMP Tue May 6 15:14:12 UTC 2025 x86_64','Super Admin','56564e46556c38774d513d3d','0');

INSERT INTO test_mohan_login (id, login_date_time, logout_date_time, ip_address, browser, os_detail, type, user_id, deleted) VALUES ('97','2025-08-04 13:34:21','0000-00-00 00:00:00','106.211.206.93','Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/138.0.0.0 Safari/537.36','Linux sg2plmcpnl486913.prod.sin2.secureserver.net 4.18.0-553.51.1.lve.el8.x86_64 #1 SMP Tue May 6 15:14:12 UTC 2025 x86_64','Super Admin','56564e46556c38774d513d3d','0');

INSERT INTO test_mohan_login (id, login_date_time, logout_date_time, ip_address, browser, os_detail, type, user_id, deleted) VALUES ('98','2025-08-04 13:44:41','0000-00-00 00:00:00','103.93.105.58','Mozilla/5.0 (Windows NT 10.0; Win64; x64; rv:141.0) Gecko/20100101 Firefox/141.0','Linux sg2plmcpnl486913.prod.sin2.secureserver.net 4.18.0-553.51.1.lve.el8.x86_64 #1 SMP Tue May 6 15:14:12 UTC 2025 x86_64','Super Admin','56564e46556c38774d513d3d','0');

INSERT INTO test_mohan_login (id, login_date_time, logout_date_time, ip_address, browser, os_detail, type, user_id, deleted) VALUES ('99','2025-08-04 15:27:47','0000-00-00 00:00:00','223.185.217.166','Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/137.0.0.0 Mobile Safari/537.36','Linux sg2plmcpnl486913.prod.sin2.secureserver.net 4.18.0-553.51.1.lve.el8.x86_64 #1 SMP Tue May 6 15:14:12 UTC 2025 x86_64','Super Admin','56564e46556c38774d513d3d','0');

INSERT INTO test_mohan_login (id, login_date_time, logout_date_time, ip_address, browser, os_detail, type, user_id, deleted) VALUES ('100','2025-08-04 21:37:44','0000-00-00 00:00:00','223.185.217.166','Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/137.0.0.0 Mobile Safari/537.36','Linux sg2plmcpnl486913.prod.sin2.secureserver.net 4.18.0-553.51.1.lve.el8.x86_64 #1 SMP Tue May 6 15:14:12 UTC 2025 x86_64','Super Admin','56564e46556c38774d513d3d','0');

INSERT INTO test_mohan_login (id, login_date_time, logout_date_time, ip_address, browser, os_detail, type, user_id, deleted) VALUES ('101','2025-08-05 09:51:34','0000-00-00 00:00:00','103.93.105.58','Mozilla/5.0 (Windows NT 10.0; Win64; x64; rv:141.0) Gecko/20100101 Firefox/141.0','Linux sg2plmcpnl486913.prod.sin2.secureserver.net 4.18.0-553.51.1.lve.el8.x86_64 #1 SMP Tue May 6 15:14:12 UTC 2025 x86_64','Super Admin','56564e46556c38774d513d3d','0');

INSERT INTO test_mohan_login (id, login_date_time, logout_date_time, ip_address, browser, os_detail, type, user_id, deleted) VALUES ('102','2025-08-05 12:43:20','0000-00-00 00:00:00','103.93.105.58','Mozilla/5.0 (Windows NT 10.0; Win64; x64; rv:141.0) Gecko/20100101 Firefox/141.0','Linux sg2plmcpnl486913.prod.sin2.secureserver.net 4.18.0-553.51.1.lve.el8.x86_64 #1 SMP Tue May 6 15:14:12 UTC 2025 x86_64','Super Admin','56564e46556c38774d513d3d','0');

INSERT INTO test_mohan_login (id, login_date_time, logout_date_time, ip_address, browser, os_detail, type, user_id, deleted) VALUES ('103','2025-08-05 12:45:23','0000-00-00 00:00:00','103.93.105.58','Mozilla/5.0 (Windows NT 10.0; Win64; x64; rv:141.0) Gecko/20100101 Firefox/141.0','Linux sg2plmcpnl486913.prod.sin2.secureserver.net 4.18.0-553.51.1.lve.el8.x86_64 #1 SMP Tue May 6 15:14:12 UTC 2025 x86_64','Super Admin','56564e46556c38774d513d3d','0');

INSERT INTO test_mohan_login (id, login_date_time, logout_date_time, ip_address, browser, os_detail, type, user_id, deleted) VALUES ('104','2025-08-05 13:43:17','0000-00-00 00:00:00','103.93.105.58','Mozilla/5.0 (Windows NT 10.0; Win64; x64; rv:141.0) Gecko/20100101 Firefox/141.0','Linux sg2plmcpnl486913.prod.sin2.secureserver.net 4.18.0-553.51.1.lve.el8.x86_64 #1 SMP Tue May 6 15:14:12 UTC 2025 x86_64','Super Admin','56564e46556c38774d513d3d','0');

INSERT INTO test_mohan_login (id, login_date_time, logout_date_time, ip_address, browser, os_detail, type, user_id, deleted) VALUES ('105','2025-08-05 16:17:01','0000-00-00 00:00:00','103.104.58.164','Mozilla/5.0 (Windows NT 10.0; Win64; x64; rv:141.0) Gecko/20100101 Firefox/141.0','Linux sg2plmcpnl486913.prod.sin2.secureserver.net 4.18.0-553.51.1.lve.el8.x86_64 #1 SMP Tue May 6 15:14:12 UTC 2025 x86_64','Super Admin','56564e46556c38774d513d3d','0');

INSERT INTO test_mohan_login (id, login_date_time, logout_date_time, ip_address, browser, os_detail, type, user_id, deleted) VALUES ('106','2025-08-05 22:05:16','0000-00-00 00:00:00','157.51.6.189','Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/138.0.0.0 Mobile Safari/537.36','Linux sg2plmcpnl486913.prod.sin2.secureserver.net 4.18.0-553.51.1.lve.el8.x86_64 #1 SMP Tue May 6 15:14:12 UTC 2025 x86_64','Super Admin','56564e46556c38774d513d3d','0');

INSERT INTO test_mohan_login (id, login_date_time, logout_date_time, ip_address, browser, os_detail, type, user_id, deleted) VALUES ('107','2025-08-06 09:48:45','0000-00-00 00:00:00','103.93.105.58','Mozilla/5.0 (Windows NT 10.0; Win64; x64; rv:141.0) Gecko/20100101 Firefox/141.0','Linux sg2plmcpnl486913.prod.sin2.secureserver.net 4.18.0-553.51.1.lve.el8.x86_64 #1 SMP Tue May 6 15:14:12 UTC 2025 x86_64','Super Admin','56564e46556c38774d513d3d','0');

INSERT INTO test_mohan_login (id, login_date_time, logout_date_time, ip_address, browser, os_detail, type, user_id, deleted) VALUES ('108','2025-08-06 14:51:49','0000-00-00 00:00:00','103.93.105.58','Mozilla/5.0 (Windows NT 10.0; Win64; x64; rv:141.0) Gecko/20100101 Firefox/141.0','Linux sg2plmcpnl486913.prod.sin2.secureserver.net 4.18.0-553.51.1.lve.el8.x86_64 #1 SMP Tue May 6 15:14:12 UTC 2025 x86_64','Super Admin','56564e46556c38774d513d3d','0');

INSERT INTO test_mohan_login (id, login_date_time, logout_date_time, ip_address, browser, os_detail, type, user_id, deleted) VALUES ('109','2025-08-06 16:00:08','0000-00-00 00:00:00','103.93.105.58','Mozilla/5.0 (Windows NT 10.0; Win64; x64; rv:141.0) Gecko/20100101 Firefox/141.0','Linux sg2plmcpnl486913.prod.sin2.secureserver.net 4.18.0-553.51.1.lve.el8.x86_64 #1 SMP Tue May 6 15:14:12 UTC 2025 x86_64','Super Admin','56564e46556c38774d513d3d','0');

INSERT INTO test_mohan_login (id, login_date_time, logout_date_time, ip_address, browser, os_detail, type, user_id, deleted) VALUES ('110','2025-08-06 23:41:09','0000-00-00 00:00:00','223.185.217.166','Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/137.0.0.0 Mobile Safari/537.36','Linux sg2plmcpnl486913.prod.sin2.secureserver.net 4.18.0-553.51.1.lve.el8.x86_64 #1 SMP Tue May 6 15:14:12 UTC 2025 x86_64','Super Admin','56564e46556c38774d513d3d','0');

INSERT INTO test_mohan_login (id, login_date_time, logout_date_time, ip_address, browser, os_detail, type, user_id, deleted) VALUES ('111','2025-08-07 17:06:37','0000-00-00 00:00:00','103.93.105.58','Mozilla/5.0 (Windows NT 10.0; Win64; x64; rv:141.0) Gecko/20100101 Firefox/141.0','Linux sg2plmcpnl486913.prod.sin2.secureserver.net 4.18.0-553.51.1.lve.el8.x86_64 #1 SMP Tue May 6 15:14:12 UTC 2025 x86_64','Super Admin','56564e46556c38774d513d3d','0');

INSERT INTO test_mohan_login (id, login_date_time, logout_date_time, ip_address, browser, os_detail, type, user_id, deleted) VALUES ('112','2025-08-08 15:07:56','0000-00-00 00:00:00','103.93.105.58','Mozilla/5.0 (Windows NT 10.0; Win64; x64; rv:141.0) Gecko/20100101 Firefox/141.0','Linux sg2plmcpnl486913.prod.sin2.secureserver.net 4.18.0-553.51.1.lve.el8.x86_64 #1 SMP Tue May 6 15:14:12 UTC 2025 x86_64','Super Admin','56564e46556c38774d513d3d','0');

INSERT INTO test_mohan_login (id, login_date_time, logout_date_time, ip_address, browser, os_detail, type, user_id, deleted) VALUES ('113','2025-08-08 15:23:47','0000-00-00 00:00:00','103.104.58.164','Mozilla/5.0 (Windows NT 10.0; Win64; x64; rv:141.0) Gecko/20100101 Firefox/141.0','Linux sg2plmcpnl486913.prod.sin2.secureserver.net 4.18.0-553.51.1.lve.el8.x86_64 #1 SMP Tue May 6 15:14:12 UTC 2025 x86_64','Super Admin','56564e46556c38774d513d3d','0');


CREATE TABLE `test_mohan_lr` (
  `id` int(100) NOT NULL AUTO_INCREMENT,
  `created_date_time` datetime NOT NULL,
  `creator` mediumtext NOT NULL,
  `creator_name` mediumtext NOT NULL,
  `lr_id` mediumtext NOT NULL,
  `lr_number` mediumtext NOT NULL,
  `lr_date` mediumtext NOT NULL,
  `reference_number` mediumtext NOT NULL,
  `organization_id` mediumtext NOT NULL,
  `consignor_id` mediumtext NOT NULL,
  `consignee_id` mediumtext NOT NULL,
  `consignor_name` mediumtext NOT NULL,
  `consignee_name` mediumtext NOT NULL,
  `bill_type` mediumtext NOT NULL,
  `vehicle_id` mediumtext NOT NULL,
  `bill_value` mediumtext NOT NULL,
  `bill_number` mediumtext NOT NULL,
  `bill_date` mediumtext NOT NULL,
  `unit_id` mediumtext NOT NULL,
  `quantity` mediumtext NOT NULL,
  `weight` mediumtext NOT NULL,
  `price_per_qty` mediumtext NOT NULL,
  `freight` mediumtext NOT NULL,
  `kooli_per_unit` mediumtext NOT NULL,
  `kooli_per_qty` mediumtext NOT NULL,
  `amount` mediumtext NOT NULL,
  `delivery_charges` mediumtext NOT NULL,
  `delivery_charges_value` mediumtext NOT NULL,
  `unloading_charges` mediumtext NOT NULL,
  `unloading_charges_value` mediumtext NOT NULL,
  `loading_charges` mediumtext NOT NULL,
  `loading_charges_value` mediumtext NOT NULL,
  `gst_value` mediumtext NOT NULL,
  `from_branch_id` mediumtext NOT NULL,
  `from_branch_name` mediumtext NOT NULL,
  `to_branch_id` mediumtext NOT NULL,
  `to_branch_name` mediumtext NOT NULL,
  `organization_state` mediumtext NOT NULL,
  `consignee_state` mediumtext NOT NULL,
  `consignor_state` mediumtext NOT NULL,
  `from_branch_state` mediumtext NOT NULL,
  `organization_details` mediumtext NOT NULL,
  `consignee_details` mediumtext NOT NULL,
  `consignor_details` mediumtext NOT NULL,
  `vehicle_details` mediumtext NOT NULL,
  `unit_name` mediumtext NOT NULL,
  `round_off` mediumtext NOT NULL,
  `total` mediumtext NOT NULL,
  `deleted` int(100) NOT NULL,
  `cancelled` mediumtext NOT NULL,
  `gst_option` mediumint(9) NOT NULL,
  `tax_value` mediumtext NOT NULL,
  `tax_option` mediumtext NOT NULL,
  `cgst` mediumtext NOT NULL,
  `sgst` mediumtext NOT NULL,
  `igst` mediumtext NOT NULL,
  `total_tax` mediumtext NOT NULL,
  `invoice_status` mediumtext NOT NULL,
  `invoice_number` mediumtext NOT NULL,
  `invoice_date` mediumtext NOT NULL,
  `is_cleared` mediumtext NOT NULL,
  `is_luggage_entry` mediumtext NOT NULL,
  `is_tripsheet_entry` mediumtext NOT NULL,
  `city` mediumtext NOT NULL,
  `consignee_city` mediumtext NOT NULL,
  `received_person` mediumtext NOT NULL,
  `received_mobile_number` mediumtext NOT NULL,
  `received_identification` mediumtext NOT NULL,
  `print_type` mediumtext NOT NULL,
  `account_party_id` mediumtext NOT NULL,
  `account_party_name` mediumtext NOT NULL,
  `godown_id` mediumtext NOT NULL,
  `tripsheet_number` mediumtext NOT NULL,
  `luggagesheet_number` mediumtext NOT NULL,
  `godown_name` mediumtext NOT NULL,
  `account_party_details` mediumtext NOT NULL,
  `total_qty` mediumtext NOT NULL,
  `others_consignee_city` mediumtext NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=21 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;


INSERT INTO test_mohan_lr (id, created_date_time, creator, creator_name, lr_id, lr_number, lr_date, reference_number, organization_id, consignor_id, consignee_id, consignor_name, consignee_name, bill_type, vehicle_id, bill_value, bill_number, bill_date, unit_id, quantity, weight, price_per_qty, freight, kooli_per_unit, kooli_per_qty, amount, delivery_charges, delivery_charges_value, unloading_charges, unloading_charges_value, loading_charges, loading_charges_value, gst_value, from_branch_id, from_branch_name, to_branch_id, to_branch_name, organization_state, consignee_state, consignor_state, from_branch_state, organization_details, consignee_details, consignor_details, vehicle_details, unit_name, round_off, total, deleted, cancelled, gst_option, tax_value, tax_option, cgst, sgst, igst, total_tax, invoice_status, invoice_number, invoice_date, is_cleared, is_luggage_entry, is_tripsheet_entry, city, consignee_city, received_person, received_mobile_number, received_identification, print_type, account_party_id, account_party_name, godown_id, tripsheet_number, luggagesheet_number, godown_name, account_party_details, total_qty, others_consignee_city) VALUES ('1','2025-07-19 15:46:33','56564e46556c38774d513d3d','55334a706332396d64486468636d5636','62484a664d546b774e7a49774d6a55774d7a51324d7a4e664d44453d','1/SVK-G','2025-04-01','4d7a497a','54314a485155354a576b46555355394f587a45314d4455794d4449304d444d784e544935587a4178','5130394f55306c48546b3953587a45344d4463794d4449314d4463794d445531587a45794f513d3d','5130394f55306c48546b5646587a45354d4463794d4449314d4445784d6a557a587a4d31','545339544c69424f525663675130684a56464a4249453947526b565456434251556b6c4f5645565355773d3d','545339544c694251556b46575255564f4945564f5645565355464a4a55305654','ToPay','NULL','NULL','NULL','0000-00-00','5655354a564638774f5441334d6a41794e5441314e4467314e6c38774d513d3d','100','0','390','39000.00','30','3000.00','42000','NULL','NULL','NULL','NULL','NULL','NULL','NULL','516c4a42546b4e49587a41354d4463794d4449314d4455304d544577587a4178','55326c325957746863326b3d','516c4a42546b4e49587a45304d4463794d4449314d444d7a4d545534587a4130','5132397062574a68644739795a534243636d46755932673d','5647467461577767546d466b64513d3d','5647467461577767546d466b64513d3d','5647467461577767546d466b64513d3d','5647467461577767546d466b64513d3d','545539495155346756464a42546c4e5154314a554a43516b55314a4a546b6c5751564e424945314655314d67546b56425569516b4a4641755379354f49464a505155517349464e4a566b464c51564e4a4a43516b55326c325957746863326b6b4a4351324d6a59784d6a4d6b4a435255595731706243424f595752314a43516b4d7a4e47556c4e51557a49354d4442454d5670534a43516b4e7a4d334d7a67314e6a63334e773d3d','545339544c694251556b46575255564f4945564f5645565355464a4a553056544a43516b4f5467304d6a49334e444d324d79516b4a4535565445776b4a43525553564a56554656534a43516b56476c79645842316369516b4a465270636e5677634856794a43516b5647467461577767546d466b6453516b4a4535565445773d','545339544c69424f525663675130684a56464a4249453947526b565456434251556b6c4f564556535579516b4a4463774d5441794e7a63344e54456b4a4352555479425151566b6b4a43525453565a42533046545353516b4a464e70646d467259584e704a43516b566d6c796457526f645735685a3246794a43516b5647467461577767546d466b6453516b4a4535565445773d','NULL','546b3954','0','44100','0','1','1','5','NULL','1050','1050','0','2100.00','O','NULL','0000-00-00','0','0','0','NULL','56476c796458423163673d3d','NULL','NULL','NULL','NULL','51554e445545465356466c664d546b774e7a49774d6a55774d7a51324d7a4e664d44493d','5248567959576b3d','NULL','NULL','NULL','NULL','5248567959576b6b4a43524f5655784d4a43516b546c564d5443516b4a4535565445776b4a4351324e7a59324e7a59324e7a59334a43516b546c564d5443516b4a4535565445776b4a43513d','100','NULL');

INSERT INTO test_mohan_lr (id, created_date_time, creator, creator_name, lr_id, lr_number, lr_date, reference_number, organization_id, consignor_id, consignee_id, consignor_name, consignee_name, bill_type, vehicle_id, bill_value, bill_number, bill_date, unit_id, quantity, weight, price_per_qty, freight, kooli_per_unit, kooli_per_qty, amount, delivery_charges, delivery_charges_value, unloading_charges, unloading_charges_value, loading_charges, loading_charges_value, gst_value, from_branch_id, from_branch_name, to_branch_id, to_branch_name, organization_state, consignee_state, consignor_state, from_branch_state, organization_details, consignee_details, consignor_details, vehicle_details, unit_name, round_off, total, deleted, cancelled, gst_option, tax_value, tax_option, cgst, sgst, igst, total_tax, invoice_status, invoice_number, invoice_date, is_cleared, is_luggage_entry, is_tripsheet_entry, city, consignee_city, received_person, received_mobile_number, received_identification, print_type, account_party_id, account_party_name, godown_id, tripsheet_number, luggagesheet_number, godown_name, account_party_details, total_qty, others_consignee_city) VALUES ('2','2025-07-19 15:54:58','56564e46556c38774d513d3d','55334a706332396d64486468636d5636','62484a664d546b774e7a49774d6a55774d7a55304e5468664d44493d','2/SVK-G','2025-04-01','4e6a633d','54314a485155354a576b46555355394f587a45314d4455794d4449304d444d784e544935587a4178','5130394f55306c48546b3953587a45344d4463794d4449314d4463784f54457a587a45794f413d3d','5130394f55306c48546b5646587a45354d4463794d4449314d4445784e6a4532587a4d32','545339544c6942544c6c497552314a425545684a5179424a5456424657413d3d','545339544c69424a5531525a5743424a546c5246556b354256456c50546b464d4943685452556c554b513d3d','ToPay','NULL','NULL','NULL','0000-00-00','5655354a564638774f5441334d6a41794e5441314e4467314e6c38774d513d3d','100','0','300','30000.00','10','1000.00','31000','NULL','NULL','NULL','NULL','NULL','NULL','NULL','516c4a42546b4e49587a41354d4463794d4449314d4455304d544577587a4178','55326c325957746863326b3d','516c4a42546b4e49587a45304d4463794d4449314d444d7a4d545534587a4130','5132397062574a68644739795a534243636d46755932673d','5647467461577767546d466b64513d3d','5647467461577767546d466b64513d3d','5647467461577767546d466b64513d3d','5647467461577767546d466b64513d3d','545539495155346756464a42546c4e5154314a554a43516b55314a4a546b6c5751564e424945314655314d67546b56425569516b4a4641755379354f49464a505155517349464e4a566b464c51564e4a4a43516b55326c325957746863326b6b4a4351324d6a59784d6a4d6b4a435255595731706243424f595752314a43516b4d7a4e47556c4e51557a49354d4442454d5670534a43516b4e7a4d334d7a67314e6a63334e773d3d','545339544c69424a5531525a5743424a546c5246556b354256456c50546b464d4943685452556c554b53516b4a4467354e7a457a4e7a63334d7a4d6b4a43524f5655784d4a43516b56456c53565642565569516b4a465270636e56776458496b4a43525561584a31634842316369516b4a46526862576c73494535685a48556b4a43524f5655784d','545339544c6942544c6c497552314a425545684a5179424a545642465743516b4a44597a4e6a6b794f4467314d54556b4a4352555479425151566b6b4a43525453565a42533046545353516b4a464e70646d467259584e704a43516b566d6c796457526f645735685a3246794a43516b5647467461577767546d466b6453516b4a4535565445773d','NULL','546b3954','0','32550','0','0','1','5','NULL','775','775','0','1550.00','C','NULL','0000-00-00','1','0','1','NULL','56476c796458423163673d3d','53564e55575667675355355552564a4f5156524a543035425443416f5530564a56436b3d','4f446b334d544d334e7a637a4d773d3d','','NULL','NULL','NULL','NULL','1/SVK-TS','NULL','NULL','NULL','100','NULL');

INSERT INTO test_mohan_lr (id, created_date_time, creator, creator_name, lr_id, lr_number, lr_date, reference_number, organization_id, consignor_id, consignee_id, consignor_name, consignee_name, bill_type, vehicle_id, bill_value, bill_number, bill_date, unit_id, quantity, weight, price_per_qty, freight, kooli_per_unit, kooli_per_qty, amount, delivery_charges, delivery_charges_value, unloading_charges, unloading_charges_value, loading_charges, loading_charges_value, gst_value, from_branch_id, from_branch_name, to_branch_id, to_branch_name, organization_state, consignee_state, consignor_state, from_branch_state, organization_details, consignee_details, consignor_details, vehicle_details, unit_name, round_off, total, deleted, cancelled, gst_option, tax_value, tax_option, cgst, sgst, igst, total_tax, invoice_status, invoice_number, invoice_date, is_cleared, is_luggage_entry, is_tripsheet_entry, city, consignee_city, received_person, received_mobile_number, received_identification, print_type, account_party_id, account_party_name, godown_id, tripsheet_number, luggagesheet_number, godown_name, account_party_details, total_qty, others_consignee_city) VALUES ('3','2025-07-22 09:38:00','56564e46556c38774d513d3d','55334a706332396d64486468636d5636','62484a664d6a49774e7a49774d6a55774f544d344d4442664d444d3d','1/SVK-P','2025-04-01','4e7a4d344d673d3d','54314a485155354a576b46555355394f587a45314d4455794d4449304d444d784e544935587a4178','5130394f55306c48546b3953587a45324d4463794d4449314d4445774d7a4130587a5979','5130394f55306c48546b5646587a49784d4463794d4449314d4467794d545178587a4d34','545339544c694254556b6b67536b565a515342545155745553456b675545394d57534251556b6c4f5645565355773d3d','545339544c69424e553141674b45745353564e49546b45675130394d543156534b513d3d','ToPay','NULL','NULL','NULL','0000-00-00','5655354a564638784d4441334d6a41794e54417a4d7a63304d3138774d773d3d','100','0','10','1000.00','20','2000.00','3000','NULL','NULL','NULL','NULL','NULL','NULL','NULL','516c4a42546b4e49587a41354d4463794d4449314d4455304d544577587a4178','55326c325957746863326b3d','516c4a42546b4e49587a45304d4463794d4449314d444d7a4d545534587a4130','5132397062574a68644739795a534243636d46755932673d','5647467461577767546d466b64513d3d','5647467461577767546d466b64513d3d','5647467461577767546d466b64513d3d','5647467461577767546d466b64513d3d','545539495155346756464a42546c4e5154314a554a43516b55314a4a546b6c5751564e424945314655314d67546b56425569516b4a4641755379354f49464a505155517349464e4a566b464c51564e4a4a43516b55326c325957746863326b6b4a4351324d6a59784d6a4d6b4a435255595731706243424f595752314a43516b4d7a4e47556c4e51557a49354d4442454d5670534a43516b4e7a4d334d7a67314e6a63334e773d3d','545339544c69424e553141674b45745353564e49546b45675130394d543156534b53516b4a44637a4e7a4d774e7a457a4e7a416b4a43524f5655784d4a43516b56456c53565642515656496b4a43525561584a31634856794a43516b56476c79645842776458496b4a435255595731706243424f595752314a43516b546c564d54413d3d','545339544c694254556b6b67536b565a515342545155745553456b675545394d57534251556b6c4f564556535579516b4a446b314d44417a4f5459334e6a556b4a43524f5655784d4a43516b4a43516b55306c575155744255306b6b4a43525461585a686132467a6153516b4a465a70636e566b61485675595764686369516b4a46526862576c73494535685a48556b4a43524f5655784d','NULL','62476c30636d553d','0','3000','0','0','0','5','NULL','0','0','0','NULL','C','NULL','0000-00-00','1','0','1','NULL','56476c796458423163673d3d','54564e514943684c556b6c545345354249454e505445395655696b3d','4e7a4d334d7a41334d544d334d413d3d','','NULL','NULL','NULL','NULL','2/SVK-TS','NULL','NULL','NULL','100','NULL');

INSERT INTO test_mohan_lr (id, created_date_time, creator, creator_name, lr_id, lr_number, lr_date, reference_number, organization_id, consignor_id, consignee_id, consignor_name, consignee_name, bill_type, vehicle_id, bill_value, bill_number, bill_date, unit_id, quantity, weight, price_per_qty, freight, kooli_per_unit, kooli_per_qty, amount, delivery_charges, delivery_charges_value, unloading_charges, unloading_charges_value, loading_charges, loading_charges_value, gst_value, from_branch_id, from_branch_name, to_branch_id, to_branch_name, organization_state, consignee_state, consignor_state, from_branch_state, organization_details, consignee_details, consignor_details, vehicle_details, unit_name, round_off, total, deleted, cancelled, gst_option, tax_value, tax_option, cgst, sgst, igst, total_tax, invoice_status, invoice_number, invoice_date, is_cleared, is_luggage_entry, is_tripsheet_entry, city, consignee_city, received_person, received_mobile_number, received_identification, print_type, account_party_id, account_party_name, godown_id, tripsheet_number, luggagesheet_number, godown_name, account_party_details, total_qty, others_consignee_city) VALUES ('4','2025-07-22 09:39:25','56564e46556c38774d513d3d','55334a706332396d64486468636d5636','62484a664d6a49774e7a49774d6a55774f544d354d6a56664d44513d','2/SVK-P','2025-04-01','NULL','54314a485155354a576b46555355394f587a45314d4455794d4449304d444d784e544935587a4178','5130394f55306c48546b3953587a45334d4463794d4449314d4467774f444135587a45784f413d3d','5130394f55306c48546b5646587a45354d4463794d4449314d5449304e445179587a4d78','545339544c69424c5155354f5153424451557842546b524655673d3d','545339544c6942555255564c5653424c56553142556b464f49455a425530684a5430343d','ToPay','NULL','NULL','NULL','0000-00-00','5655354a564638784d4441334d6a41794e54417a4d7a63304d3138774e413d3d','0','100','20','2000.00','30','3000.00','5000','NULL','NULL','NULL','NULL','NULL','NULL','NULL','516c4a42546b4e49587a41354d4463794d4449314d4455304d544577587a4178','55326c325957746863326b3d','516c4a42546b4e49587a45304d4463794d4449314d444d7a4d545534587a4130','5132397062574a68644739795a534243636d46755932673d','5647467461577767546d466b64513d3d','5647467461577767546d466b64513d3d','5647467461577767546d466b64513d3d','5647467461577767546d466b64513d3d','545539495155346756464a42546c4e5154314a554a43516b55314a4a546b6c5751564e424945314655314d67546b56425569516b4a4641755379354f49464a505155517349464e4a566b464c51564e4a4a43516b55326c325957746863326b6b4a4351324d6a59784d6a4d6b4a435255595731706243424f595752314a43516b4d7a4e47556c4e51557a49354d4442454d5670534a43516b4e7a4d334d7a67314e6a63334e773d3d','545339544c6942555255564c5653424c56553142556b464f49455a425530684a5430346b4a4351774e4455324d6a49314d5451774a43516b546c564d5443516b4a46524a556c56515656496b4a43525561584a31634856794a43516b56476c79645842776458496b4a435255595731706243424f595752314a43516b546c564d54413d3d','545339544c69424c5155354f5153424451557842546b52465569516b4a446b774e44637a4e4467354f546b6b4a43524f5655784d4a43516b4a43516b55306c575155744255306b6b4a43525461585a686132467a6153516b4a465a70636e566b61485675595764686369516b4a46526862576c73494535685a48556b4a43524f5655784d','NULL','6132633d','0','5000','0','0','0','5','NULL','0','0','0','NULL','C','NULL','0000-00-00','1','0','1','NULL','56476c796458423163673d3d','56455646533155675331564e51564a425469424751564e495355394f','4d4451314e6a49794e5445304d413d3d','','NULL','NULL','NULL','NULL','2/SVK-TS','NULL','NULL','NULL','100','NULL');

INSERT INTO test_mohan_lr (id, created_date_time, creator, creator_name, lr_id, lr_number, lr_date, reference_number, organization_id, consignor_id, consignee_id, consignor_name, consignee_name, bill_type, vehicle_id, bill_value, bill_number, bill_date, unit_id, quantity, weight, price_per_qty, freight, kooli_per_unit, kooli_per_qty, amount, delivery_charges, delivery_charges_value, unloading_charges, unloading_charges_value, loading_charges, loading_charges_value, gst_value, from_branch_id, from_branch_name, to_branch_id, to_branch_name, organization_state, consignee_state, consignor_state, from_branch_state, organization_details, consignee_details, consignor_details, vehicle_details, unit_name, round_off, total, deleted, cancelled, gst_option, tax_value, tax_option, cgst, sgst, igst, total_tax, invoice_status, invoice_number, invoice_date, is_cleared, is_luggage_entry, is_tripsheet_entry, city, consignee_city, received_person, received_mobile_number, received_identification, print_type, account_party_id, account_party_name, godown_id, tripsheet_number, luggagesheet_number, godown_name, account_party_details, total_qty, others_consignee_city) VALUES ('5','2025-07-22 09:51:21','56564e46556c38784e4441334d6a41794e54417a4d7a4d7a4f5638774f413d3d','56476870636e56745a573570','62484a664d6a49774e7a49774d6a55774f5455784d6a46664d44553d','1/CMB-P','2025-04-01','NULL','54314a485155354a576b46555355394f587a45314d4455794d4449304d444d784e544935587a4178','5130394f55306c48546b3953587a45334d4463794d4449314d4463784e6a4933587a45774f513d3d','5130394f55306c48546b5646587a45354d4463794d4449314d5449784f545531587a4930','545339544c6942535155314249464253535535555430464a52464d3d','545339544c69424e5255564f5155745453456b674a69424454773d3d','ToPay','NULL','NULL','NULL','0000-00-00','5655354a564638784d4441334d6a41794e54417a4d7a63304d3138774d773d3d','100','0','10','1000.00','25','2500.00','3500','NULL','NULL','NULL','NULL','NULL','NULL','NULL','516c4a42546b4e49587a45304d4463794d4449314d444d7a4d545534587a4130','5132397062574a68644739795a534243636d46755932673d','516c4a42546b4e49587a41354d4463794d4449314d4455304d544577587a4178','55326c325957746863326b3d','5647467461577767546d466b64513d3d','5647467461577767546d466b64513d3d','5647467461577767546d466b64513d3d','5647467461577767546d466b64513d3d','545539495155346756464a42546c4e5154314a554a43516b55314a4a546b6c5751564e424945314655314d67546b56425569516b4a4641755379354f49464a505155517349464e4a566b464c51564e4a4a43516b55326c325957746863326b6b4a4351324d6a59784d6a4d6b4a435255595731706243424f595752314a43516b4d7a4e47556c4e51557a49354d4442454d5670534a43516b4e7a4d334d7a67314e6a63334e773d3d','545339544c69424e5255564f5155745453456b674a6942445479516b4a446b774e4463774d7a59794d6a456b4a43524f5655784d4a43516b56456c53565642565569516b4a465270636e56776458496b4a43525561584a31634842316369516b4a46526862576c73494535685a48556b4a43524f5655784d','545339544c6942535155314249464253535535555430464a52464d6b4a4351354e4451794d6a51314d7a63784a43516b546c564d5443516b4a43516b4a464e4a566b464c51564e4a4a43516b55326c325957746863326b6b4a43525761584a315a476831626d466e5958496b4a435255595731706243424f595752314a43516b546c564d54413d3d','NULL','62476c30636d553d','0','3500','0','0','0','5','NULL','0','0','0','NULL','C','NULL','0000-00-00','1','0','1','NULL','56476c796458423163673d3d','545339544c694251556b46575255564f4945564f5645565355464a4a55305654','4d6a497a4d6a49794d7a4d7a4d513d3d','','NULL','NULL','NULL','NULL','1/CMB-TS','NULL','NULL','NULL','100','NULL');

INSERT INTO test_mohan_lr (id, created_date_time, creator, creator_name, lr_id, lr_number, lr_date, reference_number, organization_id, consignor_id, consignee_id, consignor_name, consignee_name, bill_type, vehicle_id, bill_value, bill_number, bill_date, unit_id, quantity, weight, price_per_qty, freight, kooli_per_unit, kooli_per_qty, amount, delivery_charges, delivery_charges_value, unloading_charges, unloading_charges_value, loading_charges, loading_charges_value, gst_value, from_branch_id, from_branch_name, to_branch_id, to_branch_name, organization_state, consignee_state, consignor_state, from_branch_state, organization_details, consignee_details, consignor_details, vehicle_details, unit_name, round_off, total, deleted, cancelled, gst_option, tax_value, tax_option, cgst, sgst, igst, total_tax, invoice_status, invoice_number, invoice_date, is_cleared, is_luggage_entry, is_tripsheet_entry, city, consignee_city, received_person, received_mobile_number, received_identification, print_type, account_party_id, account_party_name, godown_id, tripsheet_number, luggagesheet_number, godown_name, account_party_details, total_qty, others_consignee_city) VALUES ('6','2025-07-22 17:41:30','56564e46556c38774d513d3d','55334a706332396d64486468636d5636','62484a664d6a49774e7a49774d6a55774e5451784d7a42664d44593d','2/CMB-P','2025-07-22','NULL','54314a485155354a576b46555355394f587a45314d4455794d4449304d444d784e544935587a4178','5130394f55306c48546b3953587a45344d4463794d4449314d4463794d445531587a45794f513d3d','5130394f55306c48546b5646587a45354d4463794d4449314d4445784d6a557a587a4d31','545339544c69424f525663675130684a56464a4249453947526b565456434251556b6c4f5645565355773d3d','545339544c694251556b46575255564f4945564f5645565355464a4a55305654','ToPay','NULL','NULL','NULL','0000-00-00','5655354a564638784d4441334d6a41794e54417a4d7a63304d3138774e413d3d','10','0','30','300.00','5','50.00','350','NULL','NULL','NULL','NULL','NULL','NULL','NULL','516c4a42546b4e49587a45304d4463794d4449314d444d7a4d545534587a4130','5132397062574a68644739795a534243636d46755932673d','516c4a42546b4e49587a41354d4463794d4449314d4455304d6a5534587a4179','56476870636e56776458493d','5647467461577767546d466b64513d3d','5647467461577767546d466b64513d3d','5647467461577767546d466b64513d3d','5647467461577767546d466b64513d3d','545539495155346756464a42546c4e5154314a554a43516b55314a4a546b6c5751564e424945314655314d67546b56425569516b4a4641755379354f49464a505155517349464e4a566b464c51564e4a4a43516b55326c325957746863326b6b4a4351324d6a59784d6a4d6b4a435255595731706243424f595752314a43516b4d7a4e47556c4e51557a49354d4442454d5670534a43516b4e7a4d334d7a67314e6a63334e773d3d','545339544c694251556b46575255564f4945564f5645565355464a4a553056544a43516b4f5467304d6a49334e444d324d79516b4a4535565445776b4a43525553564a56554656534a43516b56476c79645842316369516b4a465270636e5677634856794a43516b5647467461577767546d466b6453516b4a4535565445773d','545339544c69424f525663675130684a56464a4249453947526b565456434251556b6c4f564556535579516b4a4463774d5441794e7a63344e54456b4a43524f5655784d4a43516b4a43516b55306c575155744255306b6b4a43525461585a686132467a6153516b4a465a70636e566b61485675595764686369516b4a46526862576c73494535685a48556b4a43524f5655784d','NULL','6132633d','0','350','0','1','0','5','NULL','0','0','0','NULL','O','NULL','0000-00-00','0','0','0','NULL','56476c796458423163673d3d','NULL','NULL','NULL','NULL','NULL','NULL','NULL','NULL','NULL','NULL','NULL','10','NULL');

INSERT INTO test_mohan_lr (id, created_date_time, creator, creator_name, lr_id, lr_number, lr_date, reference_number, organization_id, consignor_id, consignee_id, consignor_name, consignee_name, bill_type, vehicle_id, bill_value, bill_number, bill_date, unit_id, quantity, weight, price_per_qty, freight, kooli_per_unit, kooli_per_qty, amount, delivery_charges, delivery_charges_value, unloading_charges, unloading_charges_value, loading_charges, loading_charges_value, gst_value, from_branch_id, from_branch_name, to_branch_id, to_branch_name, organization_state, consignee_state, consignor_state, from_branch_state, organization_details, consignee_details, consignor_details, vehicle_details, unit_name, round_off, total, deleted, cancelled, gst_option, tax_value, tax_option, cgst, sgst, igst, total_tax, invoice_status, invoice_number, invoice_date, is_cleared, is_luggage_entry, is_tripsheet_entry, city, consignee_city, received_person, received_mobile_number, received_identification, print_type, account_party_id, account_party_name, godown_id, tripsheet_number, luggagesheet_number, godown_name, account_party_details, total_qty, others_consignee_city) VALUES ('7','2025-07-22 17:55:07','56564e46556c38774d513d3d','55334a706332396d64486468636d5636','62484a664d6a49774e7a49774d6a55774e5455314d4464664d44633d','1/TPR-P','2025-07-22','4d4441774d513d3d','54314a485155354a576b46555355394f587a45314d4455794d4449304d444d784e544935587a4178','5130394f55306c48546b3953587a45334d4463794d4449314d446b784e7a497a587a45794e413d3d','5130394f55306c48546b5646587a49794d4463794d4449314d4455304d444933587a517a','5453395449464e53535342545655704652565a4254694255556b464552564a54','545339544c6b744a52464e445446564349464e445345395054413d3d','ToPay','NULL','NULL','NULL','0000-00-00','5655354a564638784d4441334d6a41794e54417a4d7a63304d3138774e673d3d','33','0','033','1089.00','3','99.00','1188','NULL','NULL','NULL','NULL','NULL','NULL','NULL','516c4a42546b4e49587a41354d4463794d4449314d4455304d6a5534587a4179','56476870636e56776458493d','516c4a42546b4e49587a41354d4463794d4449314d4455304d544577587a4178','55326c325957746863326b3d','5647467461577767546d466b64513d3d','5647467461577767546d466b64513d3d','5647467461577767546d466b64513d3d','5647467461577767546d466b64513d3d','545539495155346756464a42546c4e5154314a554a43516b55314a4a546b6c5751564e424945314655314d67546b56425569516b4a4641755379354f49464a505155517349464e4a566b464c51564e4a4a43516b55326c325957746863326b6b4a4351324d6a59784d6a4d6b4a435255595731706243424f595752314a43516b4d7a4e47556c4e51557a49354d4442454d5670534a43516b4e7a4d334d7a67314e6a63334e773d3d','545339544c6b744a52464e445446564349464e44534539505443516b4a446b334f5441794e7a59314d7a6b6b4a43524f5655784d4a43516b56456c53565642565569516b4a465270636e56776458496b4a43525561584a31634842316369516b4a46526862576c73494535685a48556b4a43524f5655784d','5453395449464e53535342545655704652565a4254694255556b464552564a544a43516b4f4441314e6a63354e7a41344e43516b4a4535565445776b4a43516b4a43525453565a42533046545353516b4a464e70646d467259584e704a43516b566d6c796457526f645735685a3246794a43516b5647467461577767546d466b6453516b4a4535565445773d','NULL','55476c6c5932567a','0','1188','0','0','0','5','NULL','0','0','0','NULL','O','NULL','0000-00-00','0','0','0','NULL','56476c796458423163673d3d','NULL','NULL','NULL','NULL','NULL','NULL','NULL','NULL','NULL','NULL','NULL','33','NULL');

INSERT INTO test_mohan_lr (id, created_date_time, creator, creator_name, lr_id, lr_number, lr_date, reference_number, organization_id, consignor_id, consignee_id, consignor_name, consignee_name, bill_type, vehicle_id, bill_value, bill_number, bill_date, unit_id, quantity, weight, price_per_qty, freight, kooli_per_unit, kooli_per_qty, amount, delivery_charges, delivery_charges_value, unloading_charges, unloading_charges_value, loading_charges, loading_charges_value, gst_value, from_branch_id, from_branch_name, to_branch_id, to_branch_name, organization_state, consignee_state, consignor_state, from_branch_state, organization_details, consignee_details, consignor_details, vehicle_details, unit_name, round_off, total, deleted, cancelled, gst_option, tax_value, tax_option, cgst, sgst, igst, total_tax, invoice_status, invoice_number, invoice_date, is_cleared, is_luggage_entry, is_tripsheet_entry, city, consignee_city, received_person, received_mobile_number, received_identification, print_type, account_party_id, account_party_name, godown_id, tripsheet_number, luggagesheet_number, godown_name, account_party_details, total_qty, others_consignee_city) VALUES ('8','2025-07-22 17:59:51','56564e46556c38774d513d3d','55334a706332396d64486468636d5636','62484a664d6a49774e7a49774d6a55774e5455354e5446664d44673d','3/CMB-P','2025-07-22','NULL','54314a485155354a576b46555355394f587a45314d4455794d4449304d444d784e544935587a4178','5130394f55306c48546b3953587a45334d4463794d4449314d4467784d544d31587a45794d413d3d','5130394f55306c48546b5646587a49794d4463794d4449314d4455314e6a4d78587a5132','545339544c694254556b6b67566b6c4f51566c42523045675130465352464d3d','545339544c69425453464a4a494642425445464f53534242546b5242566b465349454a5051564a4555773d3d','ToPay','NULL','NULL','NULL','0000-00-00','5655354a564638784d4441334d6a41794e54417a4d7a63304d3138774e673d3d','3','0','42','126.00','3','9.00','135','NULL','NULL','NULL','NULL','NULL','NULL','NULL','516c4a42546b4e49587a45304d4463794d4449314d444d7a4d545534587a4130','5132397062574a68644739795a534243636d46755932673d','516c4a42546b4e49587a41354d4463794d4449314d4455304d544577587a4178','55326c325957746863326b3d','5647467461577767546d466b64513d3d','5647467461577767546d466b64513d3d','5647467461577767546d466b64513d3d','5647467461577767546d466b64513d3d','545539495155346756464a42546c4e5154314a554a43516b55314a4a546b6c5751564e424945314655314d67546b56425569516b4a4641755379354f49464a505155517349464e4a566b464c51564e4a4a43516b55326c325957746863326b6b4a4351324d6a59784d6a4d6b4a435255595731706243424f595752314a43516b4d7a4e47556c4e51557a49354d4442454d5670534a43516b4e7a4d334d7a67314e6a63334e773d3d','545339544c69425453464a4a494642425445464f53534242546b5242566b465349454a5051564a455579516b4a44637a4e7a4d334e5449304e7a416b4a43524f5655784d4a43516b56456c53565642565569516b4a465270636e56776458496b4a43525561584a31634842316369516b4a46526862576c73494535685a48556b4a43524f5655784d','545339544c694254556b6b67566b6c4f51566c42523045675130465352464d6b4a4351354f446b304f4441304e6a41784a43516b546c564d5443516b4a43516b4a464e4a566b464c51564e4a4a43516b55326c325957746863326b6b4a43525761584a315a476831626d466e5958496b4a435255595731706243424f595752314a43516b546c564d54413d3d','NULL','55476c6c5932567a','0','135','0','0','0','5','NULL','0','0','0','NULL','C','NULL','0000-00-00','1','0','1','NULL','56476c796458423163673d3d','545339544c694251556b46575255564f4945564f5645565355464a4a55305654','','','NULL','NULL','NULL','NULL','2/CMB-TS','NULL','NULL','NULL','3','NULL');

INSERT INTO test_mohan_lr (id, created_date_time, creator, creator_name, lr_id, lr_number, lr_date, reference_number, organization_id, consignor_id, consignee_id, consignor_name, consignee_name, bill_type, vehicle_id, bill_value, bill_number, bill_date, unit_id, quantity, weight, price_per_qty, freight, kooli_per_unit, kooli_per_qty, amount, delivery_charges, delivery_charges_value, unloading_charges, unloading_charges_value, loading_charges, loading_charges_value, gst_value, from_branch_id, from_branch_name, to_branch_id, to_branch_name, organization_state, consignee_state, consignor_state, from_branch_state, organization_details, consignee_details, consignor_details, vehicle_details, unit_name, round_off, total, deleted, cancelled, gst_option, tax_value, tax_option, cgst, sgst, igst, total_tax, invoice_status, invoice_number, invoice_date, is_cleared, is_luggage_entry, is_tripsheet_entry, city, consignee_city, received_person, received_mobile_number, received_identification, print_type, account_party_id, account_party_name, godown_id, tripsheet_number, luggagesheet_number, godown_name, account_party_details, total_qty, others_consignee_city) VALUES ('9','2025-07-22 23:25:52','56564e46556c38774d513d3d','55334a706332396d64486468636d5636','62484a664d6a49774e7a49774d6a55784d5449314e544a664d446b3d','3/SVK-G','2025-04-01','NULL','54314a485155354a576b46555355394f587a45314d4455794d4449304d444d784e544935587a4178','5130394f55306c48546b3953587a45314d4463794d4449314d44637a4d444133587a5135','5130394f55306c48546b5646587a49794d4463794d4449314d44597a4e6a4d77587a5979','545339544c69424c556c416755464a4a546c51675545464453773d3d','545339544c69424552565a4a49454e42533055675530685055413d3d','Account Party','NULL','NULL','NULL','0000-00-00','5655354a564638774f5441334d6a41794e5441314e4467314e6c38774d513d3d','100','0','80','8000.00','10','1000.00','9000','NULL','NULL','NULL','NULL','NULL','NULL','NULL','516c4a42546b4e49587a41354d4463794d4449314d4455304d544577587a4178','55326c325957746863326b3d','516c4a42546b4e49587a41354d4463794d4449314d4455304d6a5534587a4179','56476870636e56776458493d','5647467461577767546d466b64513d3d','5647467461577767546d466b64513d3d','5647467461577767546d466b64513d3d','5647467461577767546d466b64513d3d','545539495155346756464a42546c4e5154314a554a43516b55314a4a546b6c5751564e424945314655314d67546b56425569516b4a4641755379354f49464a505155517349464e4a566b464c51564e4a4a43516b55326c325957746863326b6b4a4351324d6a59784d6a4d6b4a435255595731706243424f595752314a43516b4d7a4e47556c4e51557a49354d4442454d5670534a43516b4e7a4d334d7a67314e6a63334e773d3d','545339544c69424552565a4a49454e4253305567553068505543516b4a4463774f5449794d6a4d344d44676b4a43524f5655784d4a43516b56456c53565642565569516b4a465270636e56776458496b4a43525561584a31634842316369516b4a46526862576c73494535685a48556b4a43524f5655784d','545339544c69424c556c416755464a4a546c5167554546445379516b4a446b304e4449794e5451794d54516b4a43524f5655784d4a43516b4a43516b55306c575155744255306b6b4a43525461585a686132467a6153516b4a465a70636e566b61485675595764686369516b4a46526862576c73494535685a48556b4a43524f5655784d','NULL','546b3954','0','9450','0','0','1','5','NULL','225','225','0','450.00','C','NULL','0000-00-00','1','0','1','NULL','56476c796458423163673d3d','545339544c69424552565a4a49454e42533055675530685055413d3d','4e7a41354d6a49794d7a67774f413d3d','','NULL','51554e445545465356466c664d6a49774e7a49774d6a55784d5449314e544a664d444d3d','545339544c69424c556c416755464a4a546c51675545464453773d3d','NULL','3/SVK-TS','NULL','NULL','545339544c69424c556c416755464a4a546c5167554546445379516b4a4535565445776b4a43524f5655784d4a43516b546c564d5443516b4a446b304e4449794e5451794d54516b4a43524f5655784d4a43516b546c564d5443516b4a413d3d','100','NULL');

INSERT INTO test_mohan_lr (id, created_date_time, creator, creator_name, lr_id, lr_number, lr_date, reference_number, organization_id, consignor_id, consignee_id, consignor_name, consignee_name, bill_type, vehicle_id, bill_value, bill_number, bill_date, unit_id, quantity, weight, price_per_qty, freight, kooli_per_unit, kooli_per_qty, amount, delivery_charges, delivery_charges_value, unloading_charges, unloading_charges_value, loading_charges, loading_charges_value, gst_value, from_branch_id, from_branch_name, to_branch_id, to_branch_name, organization_state, consignee_state, consignor_state, from_branch_state, organization_details, consignee_details, consignor_details, vehicle_details, unit_name, round_off, total, deleted, cancelled, gst_option, tax_value, tax_option, cgst, sgst, igst, total_tax, invoice_status, invoice_number, invoice_date, is_cleared, is_luggage_entry, is_tripsheet_entry, city, consignee_city, received_person, received_mobile_number, received_identification, print_type, account_party_id, account_party_name, godown_id, tripsheet_number, luggagesheet_number, godown_name, account_party_details, total_qty, others_consignee_city) VALUES ('10','2025-07-23 13:28:59','56564e46556c38774d513d3d','55334a706332396d64486468636d5636','62484a664d6a4d774e7a49774d6a55774d5449344e546c664d54413d','4/CMB-P','2025-04-01','NULL','54314a485155354a576b46555355394f587a45314d4455794d4449304d444d784e544935587a4178','5130394f55306c48546b3953587a45344d4463794d4449314d4463794d445531587a45794f513d3d','5130394f55306c48546b5646587a497a4d4463794d4449314d4445794e6a4532587a6334','545339544c69424f525663675130684a56464a4249453947526b565456434251556b6c4f5645565355773d3d','545339544c69425451564a42566b464f51534248556b465153456c4455773d3d','ToPay','NULL','NULL','NULL','0000-00-00','5655354a564638784d4441334d6a41794e54417a4d7a63304d3138774e673d3d','101','0','20','2020.00','4','404.00','2424','NULL','NULL','NULL','NULL','NULL','NULL','NULL','516c4a42546b4e49587a45304d4463794d4449314d444d7a4d545534587a4130','5132397062574a68644739795a534243636d46755932673d','516c4a42546b4e49587a41354d4463794d4449314d4455304d544577587a4178','55326c325957746863326b3d','5647467461577767546d466b64513d3d','564756735957356e59573568','5647467461577767546d466b64513d3d','5647467461577767546d466b64513d3d','545539495155346756464a42546c4e5154314a554a43516b55314a4a546b6c5751564e424945314655314d67546b56425569516b4a4641755379354f49464a505155517349464e4a566b464c51564e4a4a43516b55326c325957746863326b6b4a4351324d6a59784d6a4d6b4a435255595731706243424f595752314a43516b4d7a4e47556c4e51557a49354d4442454d5670534a43516b4e7a4d334d7a67314e6a63334e773d3d','545339544c69425451564a42566b464f51534248556b465153456c445579516b4a4467774e5459304d444d7a4f54636b4a43524f5655784d4a43516b56456c53565642565569516b4a4535565445776b4a43524f5655784d4a43516b564756735957356e595735684a43516b546c564d54413d3d','545339544c69424f525663675130684a56464a4249453947526b565456434251556b6c4f564556535579516b4a4463774d5441794e7a63344e54456b4a43524f5655784d4a43516b4a43516b55306c575155744255306b6b4a43525461585a686132467a6153516b4a465a70636e566b61485675595764686369516b4a46526862576c73494535685a48556b4a43524f5655784d','NULL','55476c6c5932567a','0','2424','0','0','0','5','NULL','0','0','0','NULL','O','NULL','0000-00-00','0','0','0','NULL','NULL','NULL','NULL','NULL','NULL','NULL','NULL','NULL','NULL','NULL','NULL','NULL','101','NULL');

INSERT INTO test_mohan_lr (id, created_date_time, creator, creator_name, lr_id, lr_number, lr_date, reference_number, organization_id, consignor_id, consignee_id, consignor_name, consignee_name, bill_type, vehicle_id, bill_value, bill_number, bill_date, unit_id, quantity, weight, price_per_qty, freight, kooli_per_unit, kooli_per_qty, amount, delivery_charges, delivery_charges_value, unloading_charges, unloading_charges_value, loading_charges, loading_charges_value, gst_value, from_branch_id, from_branch_name, to_branch_id, to_branch_name, organization_state, consignee_state, consignor_state, from_branch_state, organization_details, consignee_details, consignor_details, vehicle_details, unit_name, round_off, total, deleted, cancelled, gst_option, tax_value, tax_option, cgst, sgst, igst, total_tax, invoice_status, invoice_number, invoice_date, is_cleared, is_luggage_entry, is_tripsheet_entry, city, consignee_city, received_person, received_mobile_number, received_identification, print_type, account_party_id, account_party_name, godown_id, tripsheet_number, luggagesheet_number, godown_name, account_party_details, total_qty, others_consignee_city) VALUES ('11','2025-07-23 13:29:31','56564e46556c38774d513d3d','55334a706332396d64486468636d5636','62484a664d6a4d774e7a49774d6a55774d5449354d7a46664d54453d','1/CMB-G','2025-04-01','NULL','54314a485155354a576b46555355394f587a45314d4455794d4449304d444d784e544935587a4178','5130394f55306c48546b3953587a45344d4463794d4449314d4463784f54457a587a45794f413d3d','5130394f55306c48546b5646587a497a4d4463794d4449314d4445794e6a4532587a6334','545339544c6942544c6c497552314a425545684a5179424a5456424657413d3d','545339544c69425451564a42566b464f51534248556b465153456c4455773d3d','ToPay','NULL','NULL','NULL','0000-00-00','5655354a564638784d4441334d6a41794e54417a4d7a63304d3138774e513d3d','3','0','21','63.00','4','12.00','75','NULL','NULL','NULL','NULL','NULL','NULL','NULL','516c4a42546b4e49587a45304d4463794d4449314d444d7a4d545534587a4130','5132397062574a68644739795a534243636d46755932673d','516c4a42546b4e49587a41354d4463794d4449314d4455304d544577587a4178','55326c325957746863326b3d','5647467461577767546d466b64513d3d','564756735957356e59573568','5647467461577767546d466b64513d3d','5647467461577767546d466b64513d3d','545539495155346756464a42546c4e5154314a554a43516b55314a4a546b6c5751564e424945314655314d67546b56425569516b4a4641755379354f49464a505155517349464e4a566b464c51564e4a4a43516b55326c325957746863326b6b4a4351324d6a59784d6a4d6b4a435255595731706243424f595752314a43516b4d7a4e47556c4e51557a49354d4442454d5670534a43516b4e7a4d334d7a67314e6a63334e773d3d','545339544c69425451564a42566b464f51534248556b465153456c445579516b4a4467774e5459304d444d7a4f54636b4a43524f5655784d4a43516b56456c53565642565569516b4a4535565445776b4a43524f5655784d4a43516b564756735957356e595735684a43516b546c564d54413d3d','545339544c6942544c6c497552314a425545684a5179424a545642465743516b4a44597a4e6a6b794f4467314d54556b4a43524f5655784d4a43516b4a43516b55306c575155744255306b6b4a43525461585a686132467a6153516b4a465a70636e566b61485675595764686369516b4a46526862576c73494535685a48556b4a43524f5655784d','NULL','52334a6862513d3d','0.25','79','0','0','1','5','NULL','0','0','3.75','3.75','O','NULL','0000-00-00','0','0','0','NULL','NULL','NULL','NULL','NULL','NULL','NULL','NULL','NULL','NULL','NULL','NULL','NULL','3','NULL');

INSERT INTO test_mohan_lr (id, created_date_time, creator, creator_name, lr_id, lr_number, lr_date, reference_number, organization_id, consignor_id, consignee_id, consignor_name, consignee_name, bill_type, vehicle_id, bill_value, bill_number, bill_date, unit_id, quantity, weight, price_per_qty, freight, kooli_per_unit, kooli_per_qty, amount, delivery_charges, delivery_charges_value, unloading_charges, unloading_charges_value, loading_charges, loading_charges_value, gst_value, from_branch_id, from_branch_name, to_branch_id, to_branch_name, organization_state, consignee_state, consignor_state, from_branch_state, organization_details, consignee_details, consignor_details, vehicle_details, unit_name, round_off, total, deleted, cancelled, gst_option, tax_value, tax_option, cgst, sgst, igst, total_tax, invoice_status, invoice_number, invoice_date, is_cleared, is_luggage_entry, is_tripsheet_entry, city, consignee_city, received_person, received_mobile_number, received_identification, print_type, account_party_id, account_party_name, godown_id, tripsheet_number, luggagesheet_number, godown_name, account_party_details, total_qty, others_consignee_city) VALUES ('12','2025-07-23 13:31:15','56564e46556c38774d513d3d','55334a706332396d64486468636d5636','62484a664d6a4d774e7a49774d6a55774d544d784d5456664d54493d','2/CMB-G','2025-07-01','NULL','54314a485155354a576b46555355394f587a45314d4455794d4449304d444d784e544935587a4178','5130394f55306c48546b3953587a45334d4463794d4449314d446b784e7a497a587a45794e413d3d','5130394f55306c48546b5646587a497a4d4463794d4449314d4445774f545179587a5935','5453395449464e53535342545655704652565a4254694255556b464552564a54','545339544c694245534546535530684a546b6b67523046535455564f56464d6f53314a514b513d3d','ToPay','NULL','NULL','NULL','0000-00-00','5655354a564638784d4441334d6a41794e54417a4d7a63304d3138774e413d3d','20','0','30','600.00','2','40.00','640','NULL','NULL','NULL','NULL','NULL','NULL','NULL','516c4a42546b4e49587a45304d4463794d4449314d444d7a4d545534587a4130','5132397062574a68644739795a534243636d46755932673d','516c4a42546b4e49587a41354d4463794d4449314d4455304d6a5534587a4179','56476870636e56776458493d','5647467461577767546d466b64513d3d','5647467461577767546d466b64513d3d','5647467461577767546d466b64513d3d','5647467461577767546d466b64513d3d','545539495155346756464a42546c4e5154314a554a43516b55314a4a546b6c5751564e424945314655314d67546b56425569516b4a4641755379354f49464a505155517349464e4a566b464c51564e4a4a43516b55326c325957746863326b6b4a4351324d6a59784d6a4d6b4a435255595731706243424f595752314a43516b4d7a4e47556c4e51557a49354d4442454d5670534a43516b4e7a4d334d7a67314e6a63334e773d3d','545339544c694245534546535530684a546b6b67523046535455564f56464d6f53314a514b53516b4a44637a4e7a4d784d4449354e44676b4a43524f5655784d4a43516b56456c53565642565569516b4a4535565445776b4a43524f5655784d4a43516b5647467461577767546d466b6453516b4a4535565445773d','5453395449464e53535342545655704652565a4254694255556b464552564a544a43516b4f4441314e6a63354e7a41344e43516b4a4535565445776b4a43516b4a43525453565a42533046545353516b4a464e70646d467259584e704a43516b566d6c796457526f645735685a3246794a43516b5647467461577767546d466b6453516b4a4535565445773d','NULL','6132633d','0','672','0','0','1','5','NULL','16','16','0','32.00','O','NULL','0000-00-00','0','0','0','NULL','NULL','NULL','NULL','NULL','NULL','NULL','NULL','NULL','NULL','NULL','NULL','NULL','20','NULL');

INSERT INTO test_mohan_lr (id, created_date_time, creator, creator_name, lr_id, lr_number, lr_date, reference_number, organization_id, consignor_id, consignee_id, consignor_name, consignee_name, bill_type, vehicle_id, bill_value, bill_number, bill_date, unit_id, quantity, weight, price_per_qty, freight, kooli_per_unit, kooli_per_qty, amount, delivery_charges, delivery_charges_value, unloading_charges, unloading_charges_value, loading_charges, loading_charges_value, gst_value, from_branch_id, from_branch_name, to_branch_id, to_branch_name, organization_state, consignee_state, consignor_state, from_branch_state, organization_details, consignee_details, consignor_details, vehicle_details, unit_name, round_off, total, deleted, cancelled, gst_option, tax_value, tax_option, cgst, sgst, igst, total_tax, invoice_status, invoice_number, invoice_date, is_cleared, is_luggage_entry, is_tripsheet_entry, city, consignee_city, received_person, received_mobile_number, received_identification, print_type, account_party_id, account_party_name, godown_id, tripsheet_number, luggagesheet_number, godown_name, account_party_details, total_qty, others_consignee_city) VALUES ('13','2025-07-23 16:40:37','56564e46556c38774d513d3d','55334a706332396d64486468636d5636','62484a664d6a4d774e7a49774d6a55774e4451774d7a64664d544d3d','1/TPR-G','2025-04-01','NULL','54314a485155354a576b46555355394f587a45314d4455794d4449304d444d784e544935587a4178','5130394f55306c48546b3953587a45334d4463794d4449314d446b784e7a497a587a45794e413d3d','5130394f55306c48546b5646587a497a4d4463794d4449314d44457a4d6a4935587a6778','5453395449464e53535342545655704652565a4254694255556b464552564a54','545339544c694242536b6c5553434255556b464552564a54','ToPay','NULL','NULL','NULL','0000-00-00','5655354a564638784d4441334d6a41794e54417a4d7a63304d3138774d773d3d','2','0','032','64.00','3','6.00','70','NULL','NULL','NULL','NULL','NULL','NULL','NULL','516c4a42546b4e49587a41354d4463794d4449314d4455304d6a5534587a4179','56476870636e56776458493d','516c4a42546b4e49587a41354d4463794d4449314d4455304d544577587a4178','55326c325957746863326b3d','5647467461577767546d466b64513d3d','5647467461577767546d466b64513d3d','5647467461577767546d466b64513d3d','5647467461577767546d466b64513d3d','545539495155346756464a42546c4e5154314a554a43516b55314a4a546b6c5751564e424945314655314d67546b56425569516b4a4641755379354f49464a505155517349464e4a566b464c51564e4a4a43516b55326c325957746863326b6b4a4351324d6a59784d6a4d6b4a435255595731706243424f595752314a43516b4d7a4e47556c4e51557a49354d4442454d5670534a43516b4e7a4d334d7a67314e6a63334e773d3d','545339544c694242536b6c5553434255556b464552564a544a43516b4f5451344e6a51304d444d344f43516b4a4535565445776b4a43525553564a56554656534a43516b56476c79645842316369516b4a465270636e5677634856794a43516b5647467461577767546d466b6453516b4a4535565445773d','5453395449464e53535342545655704652565a4254694255556b464552564a544a43516b4f4441314e6a63354e7a41344e43516b4a4535565445776b4a43516b4a43525453565a42533046545353516b4a464e70646d467259584e704a43516b566d6c796457526f645735685a3246794a43516b5647467461577767546d466b6453516b4a4535565445773d','NULL','62476c30636d553d','0.50','74','0','0','1','5','NULL','1.75','1.75','0','3.50','O','NULL','0000-00-00','0','0','0','NULL','56476c796458423163673d3d','NULL','NULL','NULL','NULL','NULL','NULL','NULL','NULL','NULL','NULL','NULL','2','NULL');

INSERT INTO test_mohan_lr (id, created_date_time, creator, creator_name, lr_id, lr_number, lr_date, reference_number, organization_id, consignor_id, consignee_id, consignor_name, consignee_name, bill_type, vehicle_id, bill_value, bill_number, bill_date, unit_id, quantity, weight, price_per_qty, freight, kooli_per_unit, kooli_per_qty, amount, delivery_charges, delivery_charges_value, unloading_charges, unloading_charges_value, loading_charges, loading_charges_value, gst_value, from_branch_id, from_branch_name, to_branch_id, to_branch_name, organization_state, consignee_state, consignor_state, from_branch_state, organization_details, consignee_details, consignor_details, vehicle_details, unit_name, round_off, total, deleted, cancelled, gst_option, tax_value, tax_option, cgst, sgst, igst, total_tax, invoice_status, invoice_number, invoice_date, is_cleared, is_luggage_entry, is_tripsheet_entry, city, consignee_city, received_person, received_mobile_number, received_identification, print_type, account_party_id, account_party_name, godown_id, tripsheet_number, luggagesheet_number, godown_name, account_party_details, total_qty, others_consignee_city) VALUES ('14','2025-07-23 16:42:23','56564e46556c38774d513d3d','55334a706332396d64486468636d5636','62484a664d6a4d774e7a49774d6a55774e4451794d6a4e664d54513d','5/CMB-P','2025-07-01','NULL','54314a485155354a576b46555355394f587a45314d4455794d4449304d444d784e544935587a4178','5130394f55306c48546b3953587a45344d4463794d4449314d4463794f444530587a457a4d413d3d','5130394f55306c48546b5646587a497a4d4463794d4449314d4445794e544130587a6333','545339544c6942545655745351554567554578425531524a51314d3d','545339544c69424c52557053535664425443425552566855535578465579424e5355784d5579685452556c554b513d3d','ToPay','NULL','NULL','NULL','0000-00-00','5655354a564638784d4441334d6a41794e54417a4d7a63304d3138774e513d3d','5','0','85','425.00','5','25.00','450','NULL','NULL','NULL','NULL','NULL','NULL','NULL','516c4a42546b4e49587a45304d4463794d4449314d444d7a4d545534587a4130','5132397062574a68644739795a534243636d46755932673d','516c4a42546b4e49587a41354d4463794d4449314d4455304d544577587a4178','55326c325957746863326b3d','5647467461577767546d466b64513d3d','5647467461577767546d466b64513d3d','5647467461577767546d466b64513d3d','5647467461577767546d466b64513d3d','545539495155346756464a42546c4e5154314a554a43516b55314a4a546b6c5751564e424945314655314d67546b56425569516b4a4641755379354f49464a505155517349464e4a566b464c51564e4a4a43516b55326c325957746863326b6b4a4351324d6a59784d6a4d6b4a435255595731706243424f595752314a43516b4d7a4e47556c4e51557a49354d4442454d5670534a43516b4e7a4d334d7a67314e6a63334e773d3d','545339544c69424c52557053535664425443425552566855535578465579424e5355784d5579685452556c554b53516b4a446b304e444d7a4e54637a4d6a596b4a43524f5655784d4a43516b56456c53565642565569516b4a465270636e56776458496b4a43525561584a31634842316369516b4a46526862576c73494535685a48556b4a43524f5655784d','545339544c6942545655745351554567554578425531524a51314d6b4a4351354e4451304d7a63304d546b354a43516b546c564d5443516b4a43516b4a464e4a566b464c51564e4a4a43516b55326c325957746863326b6b4a43525761584a315a476831626d466e5958496b4a435255595731706243424f595752314a43516b546c564d54413d3d','NULL','52334a6862513d3d','0','450','0','0','0','5','NULL','0','0','0','NULL','O','NULL','0000-00-00','0','0','0','NULL','56476c796458423163673d3d','NULL','NULL','NULL','NULL','NULL','NULL','NULL','NULL','NULL','NULL','NULL','5','NULL');

INSERT INTO test_mohan_lr (id, created_date_time, creator, creator_name, lr_id, lr_number, lr_date, reference_number, organization_id, consignor_id, consignee_id, consignor_name, consignee_name, bill_type, vehicle_id, bill_value, bill_number, bill_date, unit_id, quantity, weight, price_per_qty, freight, kooli_per_unit, kooli_per_qty, amount, delivery_charges, delivery_charges_value, unloading_charges, unloading_charges_value, loading_charges, loading_charges_value, gst_value, from_branch_id, from_branch_name, to_branch_id, to_branch_name, organization_state, consignee_state, consignor_state, from_branch_state, organization_details, consignee_details, consignor_details, vehicle_details, unit_name, round_off, total, deleted, cancelled, gst_option, tax_value, tax_option, cgst, sgst, igst, total_tax, invoice_status, invoice_number, invoice_date, is_cleared, is_luggage_entry, is_tripsheet_entry, city, consignee_city, received_person, received_mobile_number, received_identification, print_type, account_party_id, account_party_name, godown_id, tripsheet_number, luggagesheet_number, godown_name, account_party_details, total_qty, others_consignee_city) VALUES ('15','2025-07-28 17:04:25','56564e46556c38774d513d3d','55334a706332396d64486468636d5636','62484a664d6a67774e7a49774d6a55774e5441304d6a56664d54553d','3/SVK-P','2025-04-23','5230524e494330674d6a4d79','54314a485155354a576b46555355394f587a45314d4455794d4449304d444d784e544935587a4178','5130394f55306c48546b3953587a45324d4463794d4449314d4451784d544134587a6378','5130394f55306c48546b5646587a49344d4463794d4449314d4451314e544935587a45314e773d3d','5155314e5155343d','545339544946497555434167523046535455564f56464d3d','ToPay','NULL','NULL','NULL','0000-00-00','5655354a564638774f5441334d6a41794e5441314e4467314e6c38774d513d3d','14','0','90','1260.00','10','140.00','1400','NULL','NULL','NULL','NULL','NULL','NULL','NULL','516c4a42546b4e49587a41354d4463794d4449314d4455304d544577587a4178','55326c325957746863326b3d','516c4a42546b4e49587a41354d4463794d4449314d4455304d6a5534587a4179','56476870636e56776458493d','5647467461577767546d466b64513d3d','5647467461577767546d466b64513d3d','5647467461577767546d466b64513d3d','5647467461577767546d466b64513d3d','545539495155346756464a42546c4e5154314a554a43516b55314a4a546b6c5751564e424945314655314d67546b56425569516b4a4641755379354f49464a505155517349464e4a566b464c51564e4a4a43516b55326c325957746863326b6b4a4351324d6a59784d6a4d6b4a435255595731706243424f595752314a43516b4d7a4e47556c4e51557a49354d4442454d5670534a43516b4e7a4d334d7a67314e6a63334e773d3d','545339544946497555434167523046535455564f56464d6b4a4351344f444d344d446b774e6a41344a43516b546c564d5443516b4a46524a556c56515656496b4a43525561584a31634856794a43516b56476c79645842776458496b4a435255595731706243424f595752314a43516b546c564d54413d3d','5155314e5155346b4a4351334d446b304e4463314e7a41354a43516b546c564d5443516b4a43516b4a464e4a566b464c51564e4a4a43516b55326c325957746863326b6b4a43525761584a315a476831626d466e5958496b4a435255595731706243424f595752314a43516b546c564d54413d3d','NULL','546b3954','0','1400','0','0','0','5','NULL','0','0','0','NULL','C','NULL','0000-00-00','0','0','1','NULL','56476c796458423163673d3d','NULL','NULL','NULL','NULL','51554e445545465356466c664d6a67774e7a49774d6a55774e5441784d444a664d44513d','545339544946497555434167523046535455564f56464d3d','NULL','3/SVK-TS','NULL','NULL','545339544946497555434167523046535455564f56464d6b4a43525553564a56554656534a43516b5647467461577767546d466b6453516b4a465270636e56776458496b4a4351344f444d344d446b774e6a41344a43516b546c564d5443516b4a4652504946424257513d3d','14','NULL');

INSERT INTO test_mohan_lr (id, created_date_time, creator, creator_name, lr_id, lr_number, lr_date, reference_number, organization_id, consignor_id, consignee_id, consignor_name, consignee_name, bill_type, vehicle_id, bill_value, bill_number, bill_date, unit_id, quantity, weight, price_per_qty, freight, kooli_per_unit, kooli_per_qty, amount, delivery_charges, delivery_charges_value, unloading_charges, unloading_charges_value, loading_charges, loading_charges_value, gst_value, from_branch_id, from_branch_name, to_branch_id, to_branch_name, organization_state, consignee_state, consignor_state, from_branch_state, organization_details, consignee_details, consignor_details, vehicle_details, unit_name, round_off, total, deleted, cancelled, gst_option, tax_value, tax_option, cgst, sgst, igst, total_tax, invoice_status, invoice_number, invoice_date, is_cleared, is_luggage_entry, is_tripsheet_entry, city, consignee_city, received_person, received_mobile_number, received_identification, print_type, account_party_id, account_party_name, godown_id, tripsheet_number, luggagesheet_number, godown_name, account_party_details, total_qty, others_consignee_city) VALUES ('16','2025-07-28 17:17:08','56564e46556c38774d513d3d','55334a706332396d64486468636d5636','62484a664d6a67774e7a49774d6a55774e5445334d4468664d54593d','4/SVK-P','2025-04-23','NULL','54314a485155354a576b46555355394f587a45314d4455794d4449304d444d784e544935587a4178','5130394f55306c48546b3953587a45794d4463794d4449314d4459314f544d34587a417a','5130394f55306c48546b5646587a49344d4463794d4449314d4455784e445133587a45314f413d3d','545339544c69424e515578425645684a494546485255354453555654','545339544c6942514c6b3075564556594943684e515578425645684a4b513d3d','Account Party','NULL','NULL','NULL','0000-00-00','5655354a564638774f5441334d6a41794e5441314e4467314e6c38774d513d3d','18','0','120','2160.00','10','180.00','2340','NULL','NULL','NULL','NULL','NULL','NULL','NULL','516c4a42546b4e49587a41354d4463794d4449314d4455304d544577587a4178','55326c325957746863326b3d','516c4a42546b4e49587a41354d4463794d4449314d4455304d6a5534587a4179','56476870636e56776458493d','5647467461577767546d466b64513d3d','5647467461577767546d466b64513d3d','5647467461577767546d466b64513d3d','5647467461577767546d466b64513d3d','545539495155346756464a42546c4e5154314a554a43516b55314a4a546b6c5751564e424945314655314d67546b56425569516b4a4641755379354f49464a505155517349464e4a566b464c51564e4a4a43516b55326c325957746863326b6b4a4351324d6a59784d6a4d6b4a435255595731706243424f595752314a43516b4d7a4e47556c4e51557a49354d4442454d5670534a43516b4e7a4d334d7a67314e6a63334e773d3d','545339544c6942514c6b3075564556594943684e515578425645684a4b53516b4a4467344e7a41304e6a4d794d7a456b4a43524f5655784d4a43516b5545565356553142546b464d544656534a43516b56476c79645842316369516b4a465270636e5677634856794a43516b5647467461577767546d466b6453516b4a4535565445773d','545339544c69424e515578425645684a4945464852553544535556544a43516b4f5455344e54557a4d6a45794e69516b4a4535565445776b4a43516b4a43525453565a42533046545353516b4a464e70646d467259584e704a43516b566d6c796457526f645735685a3246794a43516b5647467461577767546d466b6453516b4a4535565445773d','NULL','546b3954','0','2340','0','0','0','5','NULL','0','0','0','NULL','C','NULL','0000-00-00','0','0','1','NULL','56476c796458423163673d3d','NULL','NULL','NULL','NULL','51554e445545465356466c664d6a67774e7a49774d6a55774e5445794d7a6c664d44553d','545339544c69424e515578425645684a494546485255354453555654','NULL','3/SVK-TS','NULL','NULL','545339544c69424e515578425645684a4945464852553544535556544a43516b55306c575155744255306b6b4a435255595731706243424f595752314a43516b55326c325957746863326b6b4a4351354e5467314e544d794d5449324a43516b546c564d5443516b4a45464451303956546c51675545465356466b3d','18','NULL');

INSERT INTO test_mohan_lr (id, created_date_time, creator, creator_name, lr_id, lr_number, lr_date, reference_number, organization_id, consignor_id, consignee_id, consignor_name, consignee_name, bill_type, vehicle_id, bill_value, bill_number, bill_date, unit_id, quantity, weight, price_per_qty, freight, kooli_per_unit, kooli_per_qty, amount, delivery_charges, delivery_charges_value, unloading_charges, unloading_charges_value, loading_charges, loading_charges_value, gst_value, from_branch_id, from_branch_name, to_branch_id, to_branch_name, organization_state, consignee_state, consignor_state, from_branch_state, organization_details, consignee_details, consignor_details, vehicle_details, unit_name, round_off, total, deleted, cancelled, gst_option, tax_value, tax_option, cgst, sgst, igst, total_tax, invoice_status, invoice_number, invoice_date, is_cleared, is_luggage_entry, is_tripsheet_entry, city, consignee_city, received_person, received_mobile_number, received_identification, print_type, account_party_id, account_party_name, godown_id, tripsheet_number, luggagesheet_number, godown_name, account_party_details, total_qty, others_consignee_city) VALUES ('17','2025-07-30 20:23:03','56564e46556c38774d513d3d','55334a706332396d64486468636d5636','62484a664d7a41774e7a49774d6a55774f44497a4d444e664d54633d','5/SVK-P','2025-07-23','NULL','54314a485155354a576b46555355394f587a45314d4455794d4449304d444d784e544935587a4178','5130394f55306c48546b3953587a4d774d4463794d4449314d4467794d7a417a587a457a4d513d3d','5130394f55306c48546b5646587a4d774d4463794d4449314d4467794d7a417a587a45314f513d3d','545339544c69424e51556842566b56465569424e51564a4c5256524a546b633d','5679416d4945636749455a425530684a5430346755465a55','Account Party','NULL','NULL','NULL','0000-00-00','5655354a564638774f5441334d6a41794e5441314e4467314e6c38774d513d3d','26','0','75','1950.00','10','260.00','2210','NULL','NULL','NULL','NULL','NULL','NULL','NULL','516c4a42546b4e49587a41354d4463794d4449314d4455304d544577587a4178','55326c325957746863326b3d','516c4a42546b4e49587a41354d4463794d4449314d4455304d6a5534587a4179','56476870636e56776458493d','5647467461577767546d466b64513d3d','5647467461577767546d466b64513d3d','5647467461577767546d466b64513d3d','5647467461577767546d466b64513d3d','545539495155346756464a42546c4e5154314a554a43516b55314a4a546b6c5751564e424945314655314d67546b56425569516b4a4641755379354f49464a505155517349464e4a566b464c51564e4a4a43516b55326c325957746863326b6b4a4351324d6a59784d6a4d6b4a435255595731706243424f595752314a43516b4d7a4e47556c4e51557a49354d4442454d5670534a43516b4e7a4d334d7a67314e6a63334e773d3d','5679416d4945636749455a425530684a5430346755465a554a43516b4f5463354d4445334e7a45784d53516b4a4535565445776b4a43524f5655784d4a43516b56476c79645842316369516b4a465270636e5677634856794a43516b5647467461577767546d466b6453516b4a4535565445773d','545339544c69424e51556842566b56465569424e51564a4c5256524a546b636b4a4351354e7a67334e5467354e7a67784a43516b546c564d5443516b4a43516b4a4535565445776b4a43524f5655784d4a43516b546c564d5443516b4a4535565445776b4a43524f5655784d','NULL','546b3954','0','2210','0','0','0','5','NULL','0','0','0','NULL','C','NULL','0000-00-00','0','0','1','NULL','56476c796458423163673d3d','NULL','NULL','NULL','NULL','51554e445545465356466c664d7a41774e7a49774d6a55774f44497a4d444e664d44593d','545339544c69424e51556842566b56465569424e51564a4656456c4f52773d3d','NULL','3/SVK-TS','NULL','NULL','545339544c69424e51556842566b56465569424e51564a4656456c4f5279516b4a4535565445776b4a43524f5655784d4a43516b546c564d5443516b4a446b334f4463314f446b334f44456b4a43524f5655784d4a43516b546c564d5443516b4a413d3d','26','NULL');

INSERT INTO test_mohan_lr (id, created_date_time, creator, creator_name, lr_id, lr_number, lr_date, reference_number, organization_id, consignor_id, consignee_id, consignor_name, consignee_name, bill_type, vehicle_id, bill_value, bill_number, bill_date, unit_id, quantity, weight, price_per_qty, freight, kooli_per_unit, kooli_per_qty, amount, delivery_charges, delivery_charges_value, unloading_charges, unloading_charges_value, loading_charges, loading_charges_value, gst_value, from_branch_id, from_branch_name, to_branch_id, to_branch_name, organization_state, consignee_state, consignor_state, from_branch_state, organization_details, consignee_details, consignor_details, vehicle_details, unit_name, round_off, total, deleted, cancelled, gst_option, tax_value, tax_option, cgst, sgst, igst, total_tax, invoice_status, invoice_number, invoice_date, is_cleared, is_luggage_entry, is_tripsheet_entry, city, consignee_city, received_person, received_mobile_number, received_identification, print_type, account_party_id, account_party_name, godown_id, tripsheet_number, luggagesheet_number, godown_name, account_party_details, total_qty, others_consignee_city) VALUES ('18','2025-07-30 20:28:13','56564e46556c38774d513d3d','55334a706332396d64486468636d5636','62484a664d7a41774e7a49774d6a55774f4449344d544e664d54673d','6/SVK-P','2025-07-23','5230524e494330674d6a4d79','54314a485155354a576b46555355394f587a45314d4455794d4449304d444d784e544935587a4178','5130394f55306c48546b3953587a45304d4463794d4449314d5445784d544930587a4579','5130394f55306c48546b5646587a497a4d4463794d4449314d4445794d7a5533587a6332','545339544c694256546b6c5749464242513142425130744252305654494368514b53424d5645513d','545339544c6942435446564649454a56544577674b43425452556c554b513d3d','Account Party','NULL','NULL','NULL','0000-00-00','5655354a564638774f5441334d6a41794e5441314e4467314e6c38774d513d3d','22','0','70','1540.00','10','220.00','1760','NULL','NULL','NULL','NULL','NULL','NULL','NULL','516c4a42546b4e49587a41354d4463794d4449314d4455304d544577587a4178','55326c325957746863326b3d','516c4a42546b4e49587a41354d4463794d4449314d4455304d6a5534587a4179','56476870636e56776458493d','5647467461577767546d466b64513d3d','5647467461577767546d466b64513d3d','5647467461577767546d466b64513d3d','5647467461577767546d466b64513d3d','545539495155346756464a42546c4e5154314a554a43516b55314a4a546b6c5751564e424945314655314d67546b56425569516b4a4641755379354f49464a505155517349464e4a566b464c51564e4a4a43516b55326c325957746863326b6b4a4351324d6a59784d6a4d6b4a435255595731706243424f595752314a43516b4d7a4e47556c4e51557a49354d4442454d5670534a43516b4e7a4d334d7a67314e6a63334e773d3d','545339544c6942435446564649454a56544577674b43425452556c554b53516b4a446b334f446b304f4441784f44556b4a43524f5655784d4a43516b56456c53565642565569516b4a465270636e56776458496b4a43525561584a31634842316369516b4a46526862576c73494535685a48556b4a43524f5655784d','545339544c694256546b6c5749464242513142425130744252305654494368514b53424d5645516b4a4351354f44517a4d5467334d5451314a43516b546c564d5443516b4a43516b4a464e4a566b464c51564e4a4a43516b55326c325957746863326b6b4a43525761584a315a476831626d466e5958496b4a435255595731706243424f595752314a43516b546c564d54413d3d','NULL','546b3954','0','1760','0','0','0','5','NULL','0','0','0','NULL','C','NULL','0000-00-00','0','0','1','NULL','56476c796458423163673d3d','NULL','NULL','NULL','NULL','51554e445545465356466c664d7a41774e7a49774d6a55774f4449344d544e664d44633d','545339544c694256546b6c5749464242513142425130744252305654494368514b53424d5645513d','NULL','3/SVK-TS','NULL','NULL','545339544c694256546b6c5749464242513142425130744252305654494368514b53424d5645516b4a43524f5655784d4a43516b546c564d5443516b4a4535565445776b4a4351354f44517a4d5467334d5451314a43516b546c564d5443516b4a4535565445776b4a43513d','22','NULL');

INSERT INTO test_mohan_lr (id, created_date_time, creator, creator_name, lr_id, lr_number, lr_date, reference_number, organization_id, consignor_id, consignee_id, consignor_name, consignee_name, bill_type, vehicle_id, bill_value, bill_number, bill_date, unit_id, quantity, weight, price_per_qty, freight, kooli_per_unit, kooli_per_qty, amount, delivery_charges, delivery_charges_value, unloading_charges, unloading_charges_value, loading_charges, loading_charges_value, gst_value, from_branch_id, from_branch_name, to_branch_id, to_branch_name, organization_state, consignee_state, consignor_state, from_branch_state, organization_details, consignee_details, consignor_details, vehicle_details, unit_name, round_off, total, deleted, cancelled, gst_option, tax_value, tax_option, cgst, sgst, igst, total_tax, invoice_status, invoice_number, invoice_date, is_cleared, is_luggage_entry, is_tripsheet_entry, city, consignee_city, received_person, received_mobile_number, received_identification, print_type, account_party_id, account_party_name, godown_id, tripsheet_number, luggagesheet_number, godown_name, account_party_details, total_qty, others_consignee_city) VALUES ('19','2025-08-04 13:13:01','56564e46556c38774d513d3d','55334a706332396d64486468636d5636','62484a664d4451774f4449774d6a55774d54457a4d4446664d546b3d','3/CMB-G','2025-08-04','NULL','54314a485155354a576b46555355394f587a45314d4455794d4449304d444d784e544935587a4178','5130394f55306c48546b3953587a45304d4463794d4449314d5441304e544d7a587a4d32','5130394f55306c48546b5646587a49794d4463794d4449314d44597a4e6a4d77587a5979','553246755a326c7361513d3d','545339544c69424552565a4a49454e42533055675530685055413d3d','ToPay','NULL','NULL','NULL','0000-00-00','5655354a564638774f5441334d6a41794e5441314e4467314e6c38774d513d3d','10','0','100','1000.00','10','100.00','1100','NULL','NULL','NULL','NULL','NULL','NULL','NULL','516c4a42546b4e49587a45304d4463794d4449314d444d7a4d545534587a4130','5132397062574a68644739795a534243636d46755932673d','516c4a42546b4e49587a41354d4463794d4449314d4455304d544577587a4178','55326c325957746863326b3d','5647467461577767546d466b64513d3d','5647467461577767546d466b64513d3d','5647467461577767546d466b64513d3d','5647467461577767546d466b64513d3d','545539495155346756464a42546c4e5154314a554a43516b55314a4a546b6c5751564e424945314655314d67546b56425569516b4a4641755379354f49464a505155517349464e4a566b464c51564e4a4a43516b55326c325957746863326b6b4a4351324d6a59784d6a4d6b4a435255595731706243424f595752314a43516b4d7a4e47556c4e51557a49354d4442454d5670534a43516b4e7a4d334d7a67314e6a63334e773d3d','545339544c69424552565a4a49454e4253305567553068505543516b4a4463774f5449794d6a4d344d44676b4a43524f5655784d4a43516b56456c53565642565569516b4a465270636e56776458496b4a43525561584a31634842316369516b4a46526862576c73494535685a48556b4a43524f5655784d','553246755a326c736153516b4a44637a4e7a4d344e5459334e7a636b4a43524f5655784d4a43516b4a43516b546c564d5443516b4a4535565445776b4a43524f5655784d4a43516b5647467461577767546d466b6453516b4a4535565445773d','NULL','546b3954','0','1155','0','0','1','5','NULL','27.5','27.5','0','55.00','O','NULL','0000-00-00','0','0','0','NULL','56476c796458423163673d3d','NULL','NULL','NULL','NULL','51554e445545465356466c664d7a41774e7a49774d6a55774f4449344d544e664d44633d','545339544c694256546b6c5749464242513142425130744252305654494368514b53424d5645513d','NULL','NULL','NULL','NULL','545339544c694256546b6c5749464242513142425130744252305654494368514b53424d5645516b4a43524f5655784d4a43516b546c564d5443516b4a4535565445776b4a4351354f44517a4d5467334d5451314a43516b546c564d5443516b4a4535565445776b4a43513d','10','NULL');

INSERT INTO test_mohan_lr (id, created_date_time, creator, creator_name, lr_id, lr_number, lr_date, reference_number, organization_id, consignor_id, consignee_id, consignor_name, consignee_name, bill_type, vehicle_id, bill_value, bill_number, bill_date, unit_id, quantity, weight, price_per_qty, freight, kooli_per_unit, kooli_per_qty, amount, delivery_charges, delivery_charges_value, unloading_charges, unloading_charges_value, loading_charges, loading_charges_value, gst_value, from_branch_id, from_branch_name, to_branch_id, to_branch_name, organization_state, consignee_state, consignor_state, from_branch_state, organization_details, consignee_details, consignor_details, vehicle_details, unit_name, round_off, total, deleted, cancelled, gst_option, tax_value, tax_option, cgst, sgst, igst, total_tax, invoice_status, invoice_number, invoice_date, is_cleared, is_luggage_entry, is_tripsheet_entry, city, consignee_city, received_person, received_mobile_number, received_identification, print_type, account_party_id, account_party_name, godown_id, tripsheet_number, luggagesheet_number, godown_name, account_party_details, total_qty, others_consignee_city) VALUES ('20','2025-08-04 13:16:00','56564e46556c38774d513d3d','55334a706332396d64486468636d5636','62484a664d4451774f4449774d6a55774d5445324d4442664d6a413d','6/CMB-P','2025-08-04','NULL','54314a485155354a576b46555355394f587a45314d4455794d4449304d444d784e544935587a4178','5130394f55306c48546b3953587a45304d4463794d4449314d5441304e544d7a587a4d32','5130394f55306c48546b5646587a49794d4463794d4449314d44597a4e6a4d77587a5979','553246755a326c7361513d3d','545339544c69424552565a4a49454e42533055675530685055413d3d','Account Party','NULL','NULL','NULL','0000-00-00','5655354a564638784d4441334d6a41794e54417a4d7a63304d3138774e413d3d','1','0','2000','2000.00','200','200.00','2200','NULL','NULL','NULL','NULL','NULL','NULL','NULL','516c4a42546b4e49587a45304d4463794d4449314d444d7a4d545534587a4130','5132397062574a68644739795a534243636d46755932673d','516c4a42546b4e49587a41354d4463794d4449314d4455304d544577587a4178','55326c325957746863326b3d','5647467461577767546d466b64513d3d','5647467461577767546d466b64513d3d','5647467461577767546d466b64513d3d','5647467461577767546d466b64513d3d','545539495155346756464a42546c4e5154314a554a43516b55314a4a546b6c5751564e424945314655314d67546b56425569516b4a4641755379354f49464a505155517349464e4a566b464c51564e4a4a43516b55326c325957746863326b6b4a4351324d6a59784d6a4d6b4a435255595731706243424f595752314a43516b4d7a4e47556c4e51557a49354d4442454d5670534a43516b4e7a4d334d7a67314e6a63334e773d3d','545339544c69424552565a4a49454e4253305567553068505543516b4a4463774f5449794d6a4d344d44676b4a43524f5655784d4a43516b56456c53565642565569516b4a465270636e56776458496b4a43525561584a31634842316369516b4a46526862576c73494535685a48556b4a43524f5655784d','553246755a326c736153516b4a44637a4e7a4d344e5459334e7a636b4a43524f5655784d4a43516b4a43516b546c564d5443516b4a4535565445776b4a43524f5655784d4a43516b5647467461577767546d466b6453516b4a4535565445773d','NULL','6132633d','0','2200','0','0','0','5','NULL','0','0','0','NULL','O','NULL','0000-00-00','0','0','0','NULL','56476c796458423163673d3d','NULL','NULL','NULL','NULL','51554e445545465356466c664d7a41774e7a49774d6a55774f4449344d544e664d44633d','545339544c694256546b6c5749464242513142425130744252305654494368514b53424d5645513d','NULL','NULL','NULL','NULL','545339544c694256546b6c5749464242513142425130744252305654494368514b53424d5645516b4a43524f5655784d4a43516b546c564d5443516b4a4535565445776b4a4351354f44517a4d5467334d5451314a43516b546c564d5443516b4a4535565445776b4a43513d','1','NULL');


CREATE TABLE `test_mohan_lr_product` (
  `id` int(100) NOT NULL AUTO_INCREMENT,
  `created_date_time` datetime NOT NULL,
  `creator` mediumtext NOT NULL,
  `creator_name` mediumtext NOT NULL,
  `bill_company_id` mediumtext NOT NULL,
  `lr_product_id` mediumtext NOT NULL,
  `lr_product_name` mediumtext NOT NULL,
  `lower_case_name` mediumtext NOT NULL,
  `deleted` int(100) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;



CREATE TABLE `test_mohan_organization` (
  `id` int(100) NOT NULL AUTO_INCREMENT,
  `created_date_time` datetime NOT NULL,
  `creator` mediumtext NOT NULL,
  `creator_name` mediumtext NOT NULL,
  `organization_id` mediumtext NOT NULL,
  `name` mediumtext NOT NULL,
  `address_line1` mediumtext NOT NULL,
  `address_line2` mediumtext NOT NULL,
  `city` mediumtext NOT NULL,
  `district` mediumtext NOT NULL,
  `pincode` mediumtext NOT NULL,
  `state` mediumtext NOT NULL,
  `gst_number` mediumtext NOT NULL,
  `mobile_number` mediumtext NOT NULL,
  `lr_starting_date` date NOT NULL,
  `send_sms` int(100) NOT NULL,
  `payment_mode_id` mediumtext NOT NULL,
  `payment_mode_name` mediumtext NOT NULL,
  `bank_id` mediumtext NOT NULL,
  `bank_name` mediumtext NOT NULL,
  `payment_tax_type` mediumtext NOT NULL,
  `amount` mediumtext NOT NULL,
  `total_amount` mediumtext NOT NULL,
  `deleted` int(100) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;


INSERT INTO test_mohan_organization (id, created_date_time, creator, creator_name, organization_id, name, address_line1, address_line2, city, district, pincode, state, gst_number, mobile_number, lr_starting_date, send_sms, payment_mode_id, payment_mode_name, bank_id, bank_name, payment_tax_type, amount, total_amount, deleted) VALUES ('1','2024-05-15 15:15:29','56564e46556c38774d513d3d','55334a706332396d64486468636d5636','54314a485155354a576b46555355394f587a45314d4455794d4449304d444d784e544935587a4178','545539495155346756464a42546c4e5154314a55','55314a4a546b6c5751564e424945314655314d67546b564255673d3d','5543354c4c6b3467556b39425243776755306c575155744255306b3d','55326c325957746863326b3d','566d6c796457526f645735685a324679','4e6a49324d54497a','5647467461577767546d466b64513d3d','4d7a4e47556c4e51557a49354d4442454d567053','4e7a4d334d7a67314e6a63334e773d3d','2025-04-01','2','5547463562575675644639746232526c587a45784d4463794d4449314d5445774f544534587a4178,5547463562575675644639746232526c587a45784d4463794d4449314d5445784d444930587a417a','5279425151566b3d,5130465453413d3d','516b464f533138784d5441334d6a41794e5445784d5451774e6c38774d513d3d,','51306c5557534256546b6c50546942435155354c,','1,2','501,256000','256501','0');


CREATE TABLE `test_mohan_party` (
  `id` int(100) NOT NULL AUTO_INCREMENT,
  `created_date_time` datetime NOT NULL,
  `creator` mediumtext NOT NULL,
  `creator_name` mediumtext NOT NULL,
  `bill_company_id` mediumtext NOT NULL,
  `party_type` mediumtext NOT NULL,
  `party_id` mediumtext NOT NULL,
  `party_name` mediumtext NOT NULL,
  `lower_case_name` mediumtext NOT NULL,
  `address` mediumtext NOT NULL,
  `city` mediumtext NOT NULL,
  `district` mediumtext NOT NULL,
  `state` mediumtext NOT NULL,
  `pincode` mediumtext NOT NULL,
  `mobile_number` mediumtext NOT NULL,
  `others_city` mediumtext NOT NULL,
  `party_details` mediumtext NOT NULL,
  `opening_balance` mediumtext NOT NULL,
  `opening_balance_type` mediumtext NOT NULL,
  `name_mobile_city` mediumtext NOT NULL,
  `identification` mediumtext NOT NULL,
  `deleted` int(100) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;


INSERT INTO test_mohan_party (id, created_date_time, creator, creator_name, bill_company_id, party_type, party_id, party_name, lower_case_name, address, city, district, state, pincode, mobile_number, others_city, party_details, opening_balance, opening_balance_type, name_mobile_city, identification, deleted) VALUES ('1','2025-07-11 23:23:34','56564e46556c38774d513d3d','55334a706332396d64486468636d5636','54314a485155354a576b46555355394f587a45314d4455794d4449304d444d784e544935587a4178','1','5546565351306842553056665545465356466c664d5445774e7a49774d6a55784d54497a4d7a52664d44453d','533046424945465356553542513068425445464e49413d3d','613246684947467964573568593268686247467449413d3d','55306c575155744255306b3d','55326c325957746863326b3d','566d6c796457526f645735685a324679','5647467461577767546d466b64513d3d','4e6a49324d546735','4f5459314e544d774f4459304e413d3d','Sivakasi','533046424945465356553542513068425445464e4943516b4a464e4a566b464c51564e4a4a43516b566d6c796457526f645735685a3246794a43516b55326c325957746863326b6b4a435255595731706243424f595752314a43516b4e6a49324d5467354a43516b4f5459314e544d774f4459304e413d3d','','','533046424945465356553542513068425445464e4943416f4f5459314e544d774f4459304e436b674c53425461585a686132467a61513d3d','55306c575155744255306b3d','0');

INSERT INTO test_mohan_party (id, created_date_time, creator, creator_name, bill_company_id, party_type, party_id, party_name, lower_case_name, address, city, district, state, pincode, mobile_number, others_city, party_details, opening_balance, opening_balance_type, name_mobile_city, identification, deleted) VALUES ('2','2025-07-14 15:53:59','56564e46556c38774d513d3d','55334a706332396d64486468636d5636','54314a485155354a576b46555355394f587a45314d4455794d4449304d444d784e544935587a4178','1','5546565351306842553056665545465356466c664d5451774e7a49774d6a55774d7a557a4e546c664d44493d','566d6c756233526f49413d3d','646d6c756233526f49413d3d','4d54497a49484e30636d566c64434269655755676347467a637942796232466b','55326c325957746863326b3d','566d6c796457526f645735685a324679','5647467461577767546d466b64513d3d','4e6a49324d546735','4f4463344e7a67334f4463344e773d3d','Sivakasi','566d6c756233526f4943516b4a4445794d79427a64484a6c5a585167596e6c6c4948426863334d67636d39685a43516b4a465a70636e566b61485675595764686369516b4a464e70646d467259584e704a43516b5647467461577767546d466b6453516b4a4459794e6a45344f53516b4a4467334f4463344e7a67334f44633d','','','566d6c756233526f4943416f4f4463344e7a67334f4463344e796b674c53425461585a686132467a61513d3d','NULL','0');


CREATE TABLE `test_mohan_payment` (
  `id` int(100) NOT NULL AUTO_INCREMENT,
  `created_date_time` datetime NOT NULL,
  `creator` mediumtext NOT NULL,
  `creator_name` mediumtext NOT NULL,
  `bill_company_id` mediumtext NOT NULL DEFAULT '',
  `bill_id` mediumtext NOT NULL,
  `bill_number` mediumtext NOT NULL,
  `bill_date` date NOT NULL,
  `bill_type` mediumtext NOT NULL,
  `party_id` mediumtext NOT NULL,
  `party_name` mediumtext NOT NULL,
  `party_type` mediumtext NOT NULL,
  `payment_type` mediumtext NOT NULL,
  `branch_id` mediumtext NOT NULL,
  `payment_mode_id` mediumtext NOT NULL,
  `payment_mode_name` mediumtext NOT NULL,
  `bank_id` mediumtext NOT NULL,
  `bank_name` mediumtext NOT NULL,
  `open_balance_type` mediumtext NOT NULL,
  `credit` mediumtext NOT NULL,
  `debit` mediumtext NOT NULL,
  `payment_tax_type` mediumtext NOT NULL,
  `cash_balance` mediumtext NOT NULL,
  `lr_id` mediumtext NOT NULL,
  `deleted` int(100) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=40 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;


INSERT INTO test_mohan_payment (id, created_date_time, creator, creator_name, bill_company_id, bill_id, bill_number, bill_date, bill_type, party_id, party_name, party_type, payment_type, branch_id, payment_mode_id, payment_mode_name, bank_id, bank_name, open_balance_type, credit, debit, payment_tax_type, cash_balance, lr_id, deleted) VALUES ('2','2025-07-19 15:30:17','56564e46556c38774d513d3d','55334a706332396d64486468636d5636','54314a485155354a576b46555355394f587a45314d4455794d4449304d444d784e544935587a4178','5546565351306842553056664d546b774e7a49774d6a55774d7a4d774d5464664d44453d','232','2025-07-19','Purchase Entry','5546565351306842553056665545465356466c664d5451774e7a49774d6a55774d7a557a4e546c664d44493d','566d6c756233526f49413d3d','Purchase Party','','NULL','NULL','NULL','NULL','NULL','Credit','156800','0','NULL','0','NULL','0');

INSERT INTO test_mohan_payment (id, created_date_time, creator, creator_name, bill_company_id, bill_id, bill_number, bill_date, bill_type, party_id, party_name, party_type, payment_type, branch_id, payment_mode_id, payment_mode_name, bank_id, bank_name, open_balance_type, credit, debit, payment_tax_type, cash_balance, lr_id, deleted) VALUES ('3','2025-07-19 15:33:12','56564e46556c38774d513d3d','55334a706332396d64486468636d5636','54314a485155354a576b46555355394f587a45314d4455794d4449304d444d784e544935587a4178','54314a485155354a576b46555355394f587a45314d4455794d4449304d444d784e544935587a4178','NULL','2025-07-22','Company','NULL','NULL','NULL','','NULL','5547463562575675644639746232526c587a45784d4463794d4449314d5445784d444930587a417a','5130465453413d3d','NULL','NULL','Credit','256000','0','2','1','NULL','0');

INSERT INTO test_mohan_payment (id, created_date_time, creator, creator_name, bill_company_id, bill_id, bill_number, bill_date, bill_type, party_id, party_name, party_type, payment_type, branch_id, payment_mode_id, payment_mode_name, bank_id, bank_name, open_balance_type, credit, debit, payment_tax_type, cash_balance, lr_id, deleted) VALUES ('4','2025-07-19 15:33:12','56564e46556c38774d513d3d','55334a706332396d64486468636d5636','54314a485155354a576b46555355394f587a45314d4455794d4449304d444d784e544935587a4178','54314a485155354a576b46555355394f587a45314d4455794d4449304d444d784e544935587a4178','NULL','2025-07-22','Company','NULL','NULL','NULL','','NULL','5547463562575675644639746232526c587a45784d4463794d4449314d5445774f544534587a4178','5279425151566b3d','516b464f533138784d5441334d6a41794e5445784d5451774e6c38774d513d3d','51306c5557534256546b6c50546942435155354c','Credit','501','0','1','0','NULL','0');

INSERT INTO test_mohan_payment (id, created_date_time, creator, creator_name, bill_company_id, bill_id, bill_number, bill_date, bill_type, party_id, party_name, party_type, payment_type, branch_id, payment_mode_id, payment_mode_name, bank_id, bank_name, open_balance_type, credit, debit, payment_tax_type, cash_balance, lr_id, deleted) VALUES ('5','2025-07-19 15:33:36','56564e46556c38774d513d3d','55334a706332396d64486468636d5636','54314a485155354a576b46555355394f587a45314d4455794d4449304d444d784e544935587a4178','516c4a42546b4e49587a45304d4463794d4449314d444d7a4d545534587a4130','NULL','0000-00-00','Branch Tax Opening','516c4a42546b4e49587a45304d4463794d4449314d444d7a4d545534587a4130','5132397062574a68644739795a534243636d46755932673d','Branch','','516c4a42546b4e49587a45304d4463794d4449314d444d7a4d545534587a4130','5547463562575675644639746232526c587a45784d4463794d4449314d5445784d444930587a417a','NULL','NULL','NULL','Credit','70000','0','1','1','NULL','0');

INSERT INTO test_mohan_payment (id, created_date_time, creator, creator_name, bill_company_id, bill_id, bill_number, bill_date, bill_type, party_id, party_name, party_type, payment_type, branch_id, payment_mode_id, payment_mode_name, bank_id, bank_name, open_balance_type, credit, debit, payment_tax_type, cash_balance, lr_id, deleted) VALUES ('6','2025-07-19 15:33:36','56564e46556c38774d513d3d','55334a706332396d64486468636d5636','54314a485155354a576b46555355394f587a45314d4455794d4449304d444d784e544935587a4178','516c4a42546b4e49587a45304d4463794d4449314d444d7a4d545534587a4130','NULL','0000-00-00','Branch Opening Balance','516c4a42546b4e49587a45304d4463794d4449314d444d7a4d545534587a4130','5132397062574a68644739795a534243636d46755932673d','Branch','','516c4a42546b4e49587a45304d4463794d4449314d444d7a4d545534587a4130','5547463562575675644639746232526c587a45784d4463794d4449314d5445784d444930587a417a','NULL','NULL','NULL','Credit','60000','0','2','1','NULL','0');

INSERT INTO test_mohan_payment (id, created_date_time, creator, creator_name, bill_company_id, bill_id, bill_number, bill_date, bill_type, party_id, party_name, party_type, payment_type, branch_id, payment_mode_id, payment_mode_name, bank_id, bank_name, open_balance_type, credit, debit, payment_tax_type, cash_balance, lr_id, deleted) VALUES ('7','2025-07-19 15:42:19','56564e46556c38774d513d3d','55334a706332396d64486468636d5636','54314a485155354a576b46555355394f587a45314d4455794d4449304d444d784e544935587a4178','646d39315932686c636c38784f5441334d6a41794e54417a4e4449784f5638774d513d3d','V001/25-26','2025-07-19','Voucher','5546565351306842553056665545465356466c664d5451774e7a49774d6a55774d7a557a4e546c664d44493d','566d6c756233526f49413d3d','Purchase Party','','NULL','5547463562575675644639746232526c587a45784d4463794d4449314d5445774f544534587a4178','5279425151566b3d','516b464f533138784d5441334d6a41794e5445784d5451774e6c38774d513d3d','51306c5557534256546b6c50546942435155354c','Debit','0','156800','1','0','NULL','1');

INSERT INTO test_mohan_payment (id, created_date_time, creator, creator_name, bill_company_id, bill_id, bill_number, bill_date, bill_type, party_id, party_name, party_type, payment_type, branch_id, payment_mode_id, payment_mode_name, bank_id, bank_name, open_balance_type, credit, debit, payment_tax_type, cash_balance, lr_id, deleted) VALUES ('8','2025-07-19 15:43:47','56564e46556c38774d513d3d','55334a706332396d64486468636d5636','54314a485155354a576b46555355394f587a45314d4455794d4449304d444d784e544935587a4178','646d39315932686c636c38784f5441334d6a41794e54417a4e444d304e3138774d673d3d','V002/25-26','2025-07-19','Voucher','5546565351306842553056665545465356466c664d5451774e7a49774d6a55774d7a557a4e546c664d44493d','566d6c756233526f49413d3d','Purchase Party','','NULL','5547463562575675644639746232526c587a45784d4463794d4449314d5445774f544534587a4178','5279425151566b3d','516b464f533138784d5441334d6a41794e5445784d5451774e6c38774d513d3d','51306c5557534256546b6c50546942435155354c','Debit','0','156800','1','0','NULL','0');

INSERT INTO test_mohan_payment (id, created_date_time, creator, creator_name, bill_company_id, bill_id, bill_number, bill_date, bill_type, party_id, party_name, party_type, payment_type, branch_id, payment_mode_id, payment_mode_name, bank_id, bank_name, open_balance_type, credit, debit, payment_tax_type, cash_balance, lr_id, deleted) VALUES ('9','2025-07-19 15:46:33','56564e46556c38774d513d3d','55334a706332396d64486468636d5636','54314a485155354a576b46555355394f587a45314d4455794d4449304d444d784e544935587a4178','62484a664d546b774e7a49774d6a55774d7a51324d7a4e664d44453d','1/SVK-G','2025-04-01','LR Entry','5130394f55306c48546b5646587a45354d4463794d4449314d4445784d6a557a587a4d31','','Consignee','','516c4a42546b4e49587a45304d4463794d4449314d444d7a4d545534587a4130','NULL','NULL','NULL','NULL','Debit','0','44100','NULL','0','62484a664d546b774e7a49774d6a55774d7a51324d7a4e664d44453d','0');

INSERT INTO test_mohan_payment (id, created_date_time, creator, creator_name, bill_company_id, bill_id, bill_number, bill_date, bill_type, party_id, party_name, party_type, payment_type, branch_id, payment_mode_id, payment_mode_name, bank_id, bank_name, open_balance_type, credit, debit, payment_tax_type, cash_balance, lr_id, deleted) VALUES ('10','2025-07-19 15:54:58','56564e46556c38774d513d3d','55334a706332396d64486468636d5636','54314a485155354a576b46555355394f587a45314d4455794d4449304d444d784e544935587a4178','62484a664d546b774e7a49774d6a55774d7a55304e5468664d44493d','2/SVK-G','2025-04-01','LR Entry','5130394f55306c48546b5646587a45354d4463794d4449314d4445784e6a4532587a4d32','','Consignee','','516c4a42546b4e49587a45304d4463794d4449314d444d7a4d545534587a4130','NULL','NULL','NULL','NULL','Debit','0','32550','NULL','0','62484a664d546b774e7a49774d6a55774d7a55304e5468664d44493d','0');

INSERT INTO test_mohan_payment (id, created_date_time, creator, creator_name, bill_company_id, bill_id, bill_number, bill_date, bill_type, party_id, party_name, party_type, payment_type, branch_id, payment_mode_id, payment_mode_name, bank_id, bank_name, open_balance_type, credit, debit, payment_tax_type, cash_balance, lr_id, deleted) VALUES ('11','2025-07-21 22:24:21','56564e46556c38774d513d3d','55334a706332396d64486468636d5636','54314a485155354a576b46555355394f587a45314d4455794d4449304d444d784e544935587a4178','52566851587a49784d4463794d4449314d5441794e444978587a4178','EV001/25-26','2025-07-21','Expense','52566851587a49784d4463794d4449314d5441794e444978587a4178','NULL','Expense Category','','NULL','5547463562575675644639746232526c587a45784d4463794d4449314d5445784d444930587a417a','5130465453413d3d','NULL','NULL','Debit','0','5000','2','1','NULL','0');

INSERT INTO test_mohan_payment (id, created_date_time, creator, creator_name, bill_company_id, bill_id, bill_number, bill_date, bill_type, party_id, party_name, party_type, payment_type, branch_id, payment_mode_id, payment_mode_name, bank_id, bank_name, open_balance_type, credit, debit, payment_tax_type, cash_balance, lr_id, deleted) VALUES ('12','2025-07-22 09:37:00','56564e46556c38774d513d3d','55334a706332396d64486468636d5636','54314a485155354a576b46555355394f587a45314d4455794d4449304d444d784e544935587a4178','52566851587a49794d4463794d4449314d446b7a4e7a4177587a4179','EV002/25-26','2025-07-22','Expense','52566851587a49794d4463794d4449314d446b7a4e7a4177587a4179','NULL','Expense Category','','NULL','5547463562575675644639746232526c587a45784d4463794d4449314d5445784d444930587a417a','5130465453413d3d','NULL','NULL','Debit','0','1000','2','1','NULL','0');

INSERT INTO test_mohan_payment (id, created_date_time, creator, creator_name, bill_company_id, bill_id, bill_number, bill_date, bill_type, party_id, party_name, party_type, payment_type, branch_id, payment_mode_id, payment_mode_name, bank_id, bank_name, open_balance_type, credit, debit, payment_tax_type, cash_balance, lr_id, deleted) VALUES ('13','2025-07-22 09:38:00','56564e46556c38774d513d3d','55334a706332396d64486468636d5636','54314a485155354a576b46555355394f587a45314d4455794d4449304d444d784e544935587a4178','62484a664d6a49774e7a49774d6a55774f544d344d4442664d444d3d','1/SVK-P','2025-04-01','LR Entry','5130394f55306c48546b5646587a49784d4463794d4449314d4467794d545178587a4d34','','Consignee','','516c4a42546b4e49587a45304d4463794d4449314d444d7a4d545534587a4130','NULL','NULL','NULL','NULL','Debit','0','3000','NULL','0','62484a664d6a49774e7a49774d6a55774f544d344d4442664d444d3d','0');

INSERT INTO test_mohan_payment (id, created_date_time, creator, creator_name, bill_company_id, bill_id, bill_number, bill_date, bill_type, party_id, party_name, party_type, payment_type, branch_id, payment_mode_id, payment_mode_name, bank_id, bank_name, open_balance_type, credit, debit, payment_tax_type, cash_balance, lr_id, deleted) VALUES ('14','2025-07-22 09:39:25','56564e46556c38774d513d3d','55334a706332396d64486468636d5636','54314a485155354a576b46555355394f587a45314d4455794d4449304d444d784e544935587a4178','62484a664d6a49774e7a49774d6a55774f544d354d6a56664d44513d','2/SVK-P','2025-04-01','LR Entry','5130394f55306c48546b5646587a45354d4463794d4449314d5449304e445179587a4d78','','Consignee','','516c4a42546b4e49587a45304d4463794d4449314d444d7a4d545534587a4130','NULL','NULL','NULL','NULL','Debit','0','5000','NULL','0','62484a664d6a49774e7a49774d6a55774f544d354d6a56664d44513d','0');

INSERT INTO test_mohan_payment (id, created_date_time, creator, creator_name, bill_company_id, bill_id, bill_number, bill_date, bill_type, party_id, party_name, party_type, payment_type, branch_id, payment_mode_id, payment_mode_name, bank_id, bank_name, open_balance_type, credit, debit, payment_tax_type, cash_balance, lr_id, deleted) VALUES ('15','2025-07-22 09:42:04','56564e46556c38784e4441334d6a41794e54417a4d7a4d7a4f5638774f413d3d','56476870636e56745a573570','54314a485155354a576b46555355394f587a45314d4455794d4449304d444d784e544935587a4178','556b564452556c51564638794d6a41334d6a41794e5441354e4449774e4638774d513d3d','RCT001/25-26','2025-07-22','Receipt','5130394f55306c48546b5646587a45354d4463794d4449314d5449304e445179587a4d78','545339544c6942555255564c5653424c56553142556b464f49455a425530684a5430343d','Consignee','','516c4a42546b4e49587a45304d4463794d4449314d444d7a4d545534587a4130','5547463562575675644639746232526c587a45784d4463794d4449314d5445784d444930587a417a','5130465453413d3d','NULL','NULL','Credit','5000','0','1','1','62484a664d6a49774e7a49774d6a55774f544d354d6a56664d44513d','0');

INSERT INTO test_mohan_payment (id, created_date_time, creator, creator_name, bill_company_id, bill_id, bill_number, bill_date, bill_type, party_id, party_name, party_type, payment_type, branch_id, payment_mode_id, payment_mode_name, bank_id, bank_name, open_balance_type, credit, debit, payment_tax_type, cash_balance, lr_id, deleted) VALUES ('16','2025-07-22 09:51:21','56564e46556c38784e4441334d6a41794e54417a4d7a4d7a4f5638774f413d3d','56476870636e56745a573570','54314a485155354a576b46555355394f587a45314d4455794d4449304d444d784e544935587a4178','62484a664d6a49774e7a49774d6a55774f5455784d6a46664d44553d','1/CMB-P','2025-04-01','LR Entry','5130394f55306c48546b5646587a45354d4463794d4449314d5449784f545531587a4930','','Consignee','','516c4a42546b4e49587a41354d4463794d4449314d4455304d544577587a4178','NULL','NULL','NULL','NULL','Debit','0','3500','NULL','0','62484a664d6a49774e7a49774d6a55774f5455784d6a46664d44553d','0');

INSERT INTO test_mohan_payment (id, created_date_time, creator, creator_name, bill_company_id, bill_id, bill_number, bill_date, bill_type, party_id, party_name, party_type, payment_type, branch_id, payment_mode_id, payment_mode_name, bank_id, bank_name, open_balance_type, credit, debit, payment_tax_type, cash_balance, lr_id, deleted) VALUES ('17','2025-07-22 09:55:21','56564e46556c38774d513d3d','55334a706332396d64486468636d5636','54314a485155354a576b46555355394f587a45314d4455794d4449304d444d784e544935587a4178','636d563064584a75587a49794d4463794d4449314d446b314e544978587a4178','RN001/25-26','2025-07-22','Return','54325a6d61574e6c','54325a6d61574e6c','NULL','','NULL','5547463562575675644639746232526c587a45784d4463794d4449314d5445774f544534587a4178','5279425151566b3d','516b464f533138784d5441334d6a41794e5445784d5451774e6c38774d513d3d','51306c5557534256546b6c50546942435155354c','NULL','0','3200','1','0','NULL','1');

INSERT INTO test_mohan_payment (id, created_date_time, creator, creator_name, bill_company_id, bill_id, bill_number, bill_date, bill_type, party_id, party_name, party_type, payment_type, branch_id, payment_mode_id, payment_mode_name, bank_id, bank_name, open_balance_type, credit, debit, payment_tax_type, cash_balance, lr_id, deleted) VALUES ('18','2025-07-22 09:56:09','56564e46556c38774d513d3d','55334a706332396d64486468636d5636','54314a485155354a576b46555355394f587a45314d4455794d4449304d444d784e544935587a4178','636d563064584a75587a49794d4463794d4449314d446b314e6a4135587a4179','RN002/25-26','2025-07-22','Return','54325a6d61574e6c','54325a6d61574e6c','NULL','','NULL','5547463562575675644639746232526c587a45784d4463794d4449314d5445774f544534587a4178','5279425151566b3d','516b464f533138784d5441334d6a41794e5445784d5451774e6c38774d513d3d','51306c5557534256546b6c50546942435155354c','NULL','0','20000','1','0','NULL','1');

INSERT INTO test_mohan_payment (id, created_date_time, creator, creator_name, bill_company_id, bill_id, bill_number, bill_date, bill_type, party_id, party_name, party_type, payment_type, branch_id, payment_mode_id, payment_mode_name, bank_id, bank_name, open_balance_type, credit, debit, payment_tax_type, cash_balance, lr_id, deleted) VALUES ('19','2025-07-22 09:56:43','56564e46556c38774d513d3d','55334a706332396d64486468636d5636','54314a485155354a576b46555355394f587a45314d4455794d4449304d444d784e544935587a4178','5355355752564e55587a49794d4463794d4449314d446b314e6a517a587a4178','IN001/25-26','2025-07-22','Invest','5457396f5957343d','5457396f5957343d','NULL','','NULL','5547463562575675644639746232526c587a45784d4463794d4449314d5445774f544534587a4178','5279425151566b3d','516b464f533138784d5441334d6a41794e5445784d5451774e6c38774d513d3d','51306c5557534256546b6c50546942435155354c','NULL','20000','0','1','0','NULL','1');

INSERT INTO test_mohan_payment (id, created_date_time, creator, creator_name, bill_company_id, bill_id, bill_number, bill_date, bill_type, party_id, party_name, party_type, payment_type, branch_id, payment_mode_id, payment_mode_name, bank_id, bank_name, open_balance_type, credit, debit, payment_tax_type, cash_balance, lr_id, deleted) VALUES ('20','2025-07-22 09:57:59','56564e46556c38774d513d3d','55334a706332396d64486468636d5636','54314a485155354a576b46555355394f587a45314d4455794d4449304d444d784e544935587a4178','6333567a6347567563325666646d39315932686c636c38794d6a41334d6a41794e5441354e5463314f5638774d513d3d','SV001/25-26','2025-07-22','Suspense Voucher','553156545545564f553056665545465356466c664d5455774e7a49774d6a55784d4445794e445a664d44453d','533356745958493d','Suspense Party','','NULL','5547463562575675644639746232526c587a45784d4463794d4449314d5445774f544534587a4178','5279425151566b3d','516b464f533138784d5441334d6a41794e5445784d5451774e6c38774d513d3d','51306c5557534256546b6c50546942435155354c','Debit','0','23200','1','0','NULL','0');

INSERT INTO test_mohan_payment (id, created_date_time, creator, creator_name, bill_company_id, bill_id, bill_number, bill_date, bill_type, party_id, party_name, party_type, payment_type, branch_id, payment_mode_id, payment_mode_name, bank_id, bank_name, open_balance_type, credit, debit, payment_tax_type, cash_balance, lr_id, deleted) VALUES ('21','2025-07-22 09:58:33','56564e46556c38774d513d3d','55334a706332396d64486468636d5636','54314a485155354a576b46555355394f587a45314d4455794d4449304d444d784e544935587a4178','6333567a6347567563325666636d566a5a576c77644638794d6a41334d6a41794e5441354e54677a4d3138774d513d3d','SR001/25-26','2025-07-22','Suspense Receipt','553156545545564f553056665545465356466c664d5455774e7a49774d6a55784d4445794e445a664d44453d','533356745958493d','Suspense Party','','NULL','5547463562575675644639746232526c587a45784d4463794d4449314d5445774f544534587a4178','5279425151566b3d','516b464f533138784d5441334d6a41794e5445784d5451774e6c38774d513d3d','51306c5557534256546b6c50546942435155354c','Credit','23200','0','1','0','NULL','0');

INSERT INTO test_mohan_payment (id, created_date_time, creator, creator_name, bill_company_id, bill_id, bill_number, bill_date, bill_type, party_id, party_name, party_type, payment_type, branch_id, payment_mode_id, payment_mode_name, bank_id, bank_name, open_balance_type, credit, debit, payment_tax_type, cash_balance, lr_id, deleted) VALUES ('22','2025-07-22 17:41:30','56564e46556c38774d513d3d','55334a706332396d64486468636d5636','54314a485155354a576b46555355394f587a45314d4455794d4449304d444d784e544935587a4178','62484a664d6a49774e7a49774d6a55774e5451784d7a42664d44593d','2/CMB-P','2025-07-22','LR Entry','5130394f55306c48546b5646587a45354d4463794d4449314d4445784d6a557a587a4d31','','Consignee','','516c4a42546b4e49587a41354d4463794d4449314d4455304d6a5534587a4179','NULL','NULL','NULL','NULL','Debit','0','350','NULL','0','62484a664d6a49774e7a49774d6a55774e5451784d7a42664d44593d','1');

INSERT INTO test_mohan_payment (id, created_date_time, creator, creator_name, bill_company_id, bill_id, bill_number, bill_date, bill_type, party_id, party_name, party_type, payment_type, branch_id, payment_mode_id, payment_mode_name, bank_id, bank_name, open_balance_type, credit, debit, payment_tax_type, cash_balance, lr_id, deleted) VALUES ('23','2025-07-22 17:55:07','56564e46556c38774d513d3d','55334a706332396d64486468636d5636','54314a485155354a576b46555355394f587a45314d4455794d4449304d444d784e544935587a4178','62484a664d6a49774e7a49774d6a55774e5455314d4464664d44633d','1/TPR-P','2025-07-22','LR Entry','5130394f55306c48546b5646587a49794d4463794d4449314d4455304d444933587a517a','','Consignee','','516c4a42546b4e49587a41354d4463794d4449314d4455304d544577587a4178','NULL','NULL','NULL','NULL','Debit','0','1188','NULL','0','62484a664d6a49774e7a49774d6a55774e5455314d4464664d44633d','0');

INSERT INTO test_mohan_payment (id, created_date_time, creator, creator_name, bill_company_id, bill_id, bill_number, bill_date, bill_type, party_id, party_name, party_type, payment_type, branch_id, payment_mode_id, payment_mode_name, bank_id, bank_name, open_balance_type, credit, debit, payment_tax_type, cash_balance, lr_id, deleted) VALUES ('24','2025-07-22 17:59:51','56564e46556c38774d513d3d','55334a706332396d64486468636d5636','54314a485155354a576b46555355394f587a45314d4455794d4449304d444d784e544935587a4178','62484a664d6a49774e7a49774d6a55774e5455354e5446664d44673d','3/CMB-P','2025-07-22','LR Entry','5130394f55306c48546b5646587a49794d4463794d4449314d4455314e6a4d78587a5132','','Consignee','','516c4a42546b4e49587a41354d4463794d4449314d4455304d544577587a4178','NULL','NULL','NULL','NULL','Debit','0','135','NULL','0','62484a664d6a49774e7a49774d6a55774e5455354e5446664d44673d','0');

INSERT INTO test_mohan_payment (id, created_date_time, creator, creator_name, bill_company_id, bill_id, bill_number, bill_date, bill_type, party_id, party_name, party_type, payment_type, branch_id, payment_mode_id, payment_mode_name, bank_id, bank_name, open_balance_type, credit, debit, payment_tax_type, cash_balance, lr_id, deleted) VALUES ('25','2025-07-22 23:14:14','56564e46556c38774d513d3d','55334a706332396d64486468636d5636','54314a485155354a576b46555355394f587a45314d4455794d4449304d444d784e544935587a4178','646d39315932686c636c38794d6a41334d6a41794e5445784d5451784e4638774d773d3d','V003/25-26','2025-07-22','Voucher','5546565351306842553056665545465356466c664d5445774e7a49774d6a55784d54497a4d7a52664d44453d','533046424945465356553542513068425445464e49413d3d','Purchase Party','','NULL','5547463562575675644639746232526c587a45784d4463794d4449314d5445784d444930587a417a','5130465453413d3d','NULL','NULL','Debit','0','200000','2','1','NULL','0');

INSERT INTO test_mohan_payment (id, created_date_time, creator, creator_name, bill_company_id, bill_id, bill_number, bill_date, bill_type, party_id, party_name, party_type, payment_type, branch_id, payment_mode_id, payment_mode_name, bank_id, bank_name, open_balance_type, credit, debit, payment_tax_type, cash_balance, lr_id, deleted) VALUES ('26','2025-07-22 23:25:52','56564e46556c38774d513d3d','55334a706332396d64486468636d5636','54314a485155354a576b46555355394f587a45314d4455794d4449304d444d784e544935587a4178','62484a664d6a49774e7a49774d6a55784d5449314e544a664d446b3d','3/SVK-G','2025-04-01','LR Entry','51554e445545465356466c664d6a49774e7a49774d6a55784d5449314e544a664d444d3d','','Account Party','','516c4a42546b4e49587a41354d4463794d4449314d4455304d6a5534587a4179','NULL','NULL','NULL','NULL','Debit','0','9450','NULL','0','62484a664d6a49774e7a49774d6a55784d5449314e544a664d446b3d','0');

INSERT INTO test_mohan_payment (id, created_date_time, creator, creator_name, bill_company_id, bill_id, bill_number, bill_date, bill_type, party_id, party_name, party_type, payment_type, branch_id, payment_mode_id, payment_mode_name, bank_id, bank_name, open_balance_type, credit, debit, payment_tax_type, cash_balance, lr_id, deleted) VALUES ('27','2025-07-23 13:28:59','56564e46556c38774d513d3d','55334a706332396d64486468636d5636','54314a485155354a576b46555355394f587a45314d4455794d4449304d444d784e544935587a4178','62484a664d6a4d774e7a49774d6a55774d5449344e546c664d54413d','4/CMB-P','2025-04-01','LR Entry','5130394f55306c48546b5646587a497a4d4463794d4449314d4445794e6a4532587a6334','','Consignee','','516c4a42546b4e49587a41354d4463794d4449314d4455304d544577587a4178','NULL','NULL','NULL','NULL','Debit','0','2424','NULL','0','62484a664d6a4d774e7a49774d6a55774d5449344e546c664d54413d','0');

INSERT INTO test_mohan_payment (id, created_date_time, creator, creator_name, bill_company_id, bill_id, bill_number, bill_date, bill_type, party_id, party_name, party_type, payment_type, branch_id, payment_mode_id, payment_mode_name, bank_id, bank_name, open_balance_type, credit, debit, payment_tax_type, cash_balance, lr_id, deleted) VALUES ('28','2025-07-23 13:29:31','56564e46556c38774d513d3d','55334a706332396d64486468636d5636','54314a485155354a576b46555355394f587a45314d4455794d4449304d444d784e544935587a4178','62484a664d6a4d774e7a49774d6a55774d5449354d7a46664d54453d','1/CMB-G','2025-04-01','LR Entry','5130394f55306c48546b5646587a497a4d4463794d4449314d4445794e6a4532587a6334','','Consignee','','516c4a42546b4e49587a41354d4463794d4449314d4455304d544577587a4178','NULL','NULL','NULL','NULL','Debit','0','79','NULL','0','62484a664d6a4d774e7a49774d6a55774d5449354d7a46664d54453d','0');

INSERT INTO test_mohan_payment (id, created_date_time, creator, creator_name, bill_company_id, bill_id, bill_number, bill_date, bill_type, party_id, party_name, party_type, payment_type, branch_id, payment_mode_id, payment_mode_name, bank_id, bank_name, open_balance_type, credit, debit, payment_tax_type, cash_balance, lr_id, deleted) VALUES ('29','2025-07-23 13:31:15','56564e46556c38774d513d3d','55334a706332396d64486468636d5636','54314a485155354a576b46555355394f587a45314d4455794d4449304d444d784e544935587a4178','62484a664d6a4d774e7a49774d6a55774d544d784d5456664d54493d','2/CMB-G','2025-07-01','LR Entry','5130394f55306c48546b5646587a497a4d4463794d4449314d4445774f545179587a5935','','Consignee','','516c4a42546b4e49587a41354d4463794d4449314d4455304d6a5534587a4179','NULL','NULL','NULL','NULL','Debit','0','672','NULL','0','62484a664d6a4d774e7a49774d6a55774d544d784d5456664d54493d','0');

INSERT INTO test_mohan_payment (id, created_date_time, creator, creator_name, bill_company_id, bill_id, bill_number, bill_date, bill_type, party_id, party_name, party_type, payment_type, branch_id, payment_mode_id, payment_mode_name, bank_id, bank_name, open_balance_type, credit, debit, payment_tax_type, cash_balance, lr_id, deleted) VALUES ('30','2025-07-23 15:44:28','56564e46556c38774d513d3d','55334a706332396d64486468636d5636','54314a485155354a576b46555355394f587a45314d4455794d4449304d444d784e544935587a4178','52566851587a497a4d4463794d4449314d444d304e444934587a417a','EV003/25-26','2025-07-23','Expense','52566851587a497a4d4463794d4449314d444d304e444934587a417a','NULL','Expense Category','','NULL','5547463562575675644639746232526c587a45784d4463794d4449314d5445784d444930587a417a','5130465453413d3d','NULL','NULL','Debit','0','500','2','1','NULL','0');

INSERT INTO test_mohan_payment (id, created_date_time, creator, creator_name, bill_company_id, bill_id, bill_number, bill_date, bill_type, party_id, party_name, party_type, payment_type, branch_id, payment_mode_id, payment_mode_name, bank_id, bank_name, open_balance_type, credit, debit, payment_tax_type, cash_balance, lr_id, deleted) VALUES ('31','2025-07-23 16:40:37','56564e46556c38774d513d3d','55334a706332396d64486468636d5636','54314a485155354a576b46555355394f587a45314d4455794d4449304d444d784e544935587a4178','62484a664d6a4d774e7a49774d6a55774e4451774d7a64664d544d3d','1/TPR-G','2025-04-01','LR Entry','5130394f55306c48546b5646587a497a4d4463794d4449314d44457a4d6a4935587a6778','','Consignee','','516c4a42546b4e49587a41354d4463794d4449314d4455304d544577587a4178','NULL','NULL','NULL','NULL','Debit','0','74','NULL','0','62484a664d6a4d774e7a49774d6a55774e4451774d7a64664d544d3d','0');

INSERT INTO test_mohan_payment (id, created_date_time, creator, creator_name, bill_company_id, bill_id, bill_number, bill_date, bill_type, party_id, party_name, party_type, payment_type, branch_id, payment_mode_id, payment_mode_name, bank_id, bank_name, open_balance_type, credit, debit, payment_tax_type, cash_balance, lr_id, deleted) VALUES ('32','2025-07-23 16:42:23','56564e46556c38774d513d3d','55334a706332396d64486468636d5636','54314a485155354a576b46555355394f587a45314d4455794d4449304d444d784e544935587a4178','62484a664d6a4d774e7a49774d6a55774e4451794d6a4e664d54513d','5/CMB-P','2025-07-01','LR Entry','5130394f55306c48546b5646587a497a4d4463794d4449314d4445794e544130587a6333','','Consignee','','516c4a42546b4e49587a41354d4463794d4449314d4455304d544577587a4178','NULL','NULL','NULL','NULL','Debit','0','450','NULL','0','62484a664d6a4d774e7a49774d6a55774e4451794d6a4e664d54513d','0');

INSERT INTO test_mohan_payment (id, created_date_time, creator, creator_name, bill_company_id, bill_id, bill_number, bill_date, bill_type, party_id, party_name, party_type, payment_type, branch_id, payment_mode_id, payment_mode_name, bank_id, bank_name, open_balance_type, credit, debit, payment_tax_type, cash_balance, lr_id, deleted) VALUES ('33','2025-07-26 21:56:29','56564e46556c38774d513d3d','55334a706332396d64486468636d5636','54314a485155354a576b46555355394f587a45314d4455794d4449304d444d784e544935587a4178','556b564452556c51564638794e6a41334d6a41794e5441354e5459794f5638774d673d3d','RCT002/25-26','2025-07-26','Receipt','5130394f55306c48546b5646587a49794d4463794d4449314d4455304d444933587a517a','545339544c6b744a52464e445446564349464e445345395054413d3d','Consignee','','516c4a42546b4e49587a41354d4463794d4449314d4455304d544577587a4178','5547463562575675644639746232526c587a45784d4463794d4449314d5445774f544534587a4178','5279425151566b3d','516b464f533138784d5441334d6a41794e5445784d5451774e6c38774d513d3d','51306c5557534256546b6c50546942435155354c','Credit','500','0','2','0','62484a664d6a49774e7a49774d6a55774e5455314d4464664d44633d','0');

INSERT INTO test_mohan_payment (id, created_date_time, creator, creator_name, bill_company_id, bill_id, bill_number, bill_date, bill_type, party_id, party_name, party_type, payment_type, branch_id, payment_mode_id, payment_mode_name, bank_id, bank_name, open_balance_type, credit, debit, payment_tax_type, cash_balance, lr_id, deleted) VALUES ('34','2025-07-28 17:04:25','56564e46556c38774d513d3d','55334a706332396d64486468636d5636','54314a485155354a576b46555355394f587a45314d4455794d4449304d444d784e544935587a4178','62484a664d6a67774e7a49774d6a55774e5441304d6a56664d54553d','3/SVK-P','2025-04-23','LR Entry','5130394f55306c48546b5646587a49344d4463794d4449314d4451314e544935587a45314e773d3d','','Consignee','','516c4a42546b4e49587a41354d4463794d4449314d4455304d6a5534587a4179','NULL','NULL','NULL','NULL','Debit','0','1400','NULL','0','62484a664d6a67774e7a49774d6a55774e5441304d6a56664d54553d','0');

INSERT INTO test_mohan_payment (id, created_date_time, creator, creator_name, bill_company_id, bill_id, bill_number, bill_date, bill_type, party_id, party_name, party_type, payment_type, branch_id, payment_mode_id, payment_mode_name, bank_id, bank_name, open_balance_type, credit, debit, payment_tax_type, cash_balance, lr_id, deleted) VALUES ('35','2025-07-28 17:17:08','56564e46556c38774d513d3d','55334a706332396d64486468636d5636','54314a485155354a576b46555355394f587a45314d4455794d4449304d444d784e544935587a4178','62484a664d6a67774e7a49774d6a55774e5445334d4468664d54593d','4/SVK-P','2025-04-23','LR Entry','51554e445545465356466c664d6a67774e7a49774d6a55774e5445794d7a6c664d44553d','','Account Party','','516c4a42546b4e49587a41354d4463794d4449314d4455304d6a5534587a4179','NULL','NULL','NULL','NULL','Debit','0','2340','NULL','0','62484a664d6a67774e7a49774d6a55774e5445334d4468664d54593d','0');

INSERT INTO test_mohan_payment (id, created_date_time, creator, creator_name, bill_company_id, bill_id, bill_number, bill_date, bill_type, party_id, party_name, party_type, payment_type, branch_id, payment_mode_id, payment_mode_name, bank_id, bank_name, open_balance_type, credit, debit, payment_tax_type, cash_balance, lr_id, deleted) VALUES ('36','2025-07-30 20:23:03','56564e46556c38774d513d3d','55334a706332396d64486468636d5636','54314a485155354a576b46555355394f587a45314d4455794d4449304d444d784e544935587a4178','62484a664d7a41774e7a49774d6a55774f44497a4d444e664d54633d','5/SVK-P','2025-07-23','LR Entry','51554e445545465356466c664d7a41774e7a49774d6a55774f44497a4d444e664d44593d','','Account Party','','516c4a42546b4e49587a41354d4463794d4449314d4455304d6a5534587a4179','NULL','NULL','NULL','NULL','Debit','0','2210','NULL','0','62484a664d7a41774e7a49774d6a55774f44497a4d444e664d54633d','0');

INSERT INTO test_mohan_payment (id, created_date_time, creator, creator_name, bill_company_id, bill_id, bill_number, bill_date, bill_type, party_id, party_name, party_type, payment_type, branch_id, payment_mode_id, payment_mode_name, bank_id, bank_name, open_balance_type, credit, debit, payment_tax_type, cash_balance, lr_id, deleted) VALUES ('37','2025-07-30 20:28:13','56564e46556c38774d513d3d','55334a706332396d64486468636d5636','54314a485155354a576b46555355394f587a45314d4455794d4449304d444d784e544935587a4178','62484a664d7a41774e7a49774d6a55774f4449344d544e664d54673d','6/SVK-P','2025-07-23','LR Entry','51554e445545465356466c664d7a41774e7a49774d6a55774f4449344d544e664d44633d','','Account Party','','516c4a42546b4e49587a41354d4463794d4449314d4455304d6a5534587a4179','NULL','NULL','NULL','NULL','Debit','0','1760','NULL','0','62484a664d7a41774e7a49774d6a55774f4449344d544e664d54673d','0');

INSERT INTO test_mohan_payment (id, created_date_time, creator, creator_name, bill_company_id, bill_id, bill_number, bill_date, bill_type, party_id, party_name, party_type, payment_type, branch_id, payment_mode_id, payment_mode_name, bank_id, bank_name, open_balance_type, credit, debit, payment_tax_type, cash_balance, lr_id, deleted) VALUES ('38','2025-08-04 13:13:01','56564e46556c38774d513d3d','55334a706332396d64486468636d5636','54314a485155354a576b46555355394f587a45314d4455794d4449304d444d784e544935587a4178','62484a664d4451774f4449774d6a55774d54457a4d4446664d546b3d','3/CMB-G','2025-08-04','LR Entry','5130394f55306c48546b5646587a49794d4463794d4449314d44597a4e6a4d77587a5979','','Consignee','','516c4a42546b4e49587a41354d4463794d4449314d4455304d544577587a4178','NULL','NULL','NULL','NULL','Debit','0','1155','NULL','0','62484a664d4451774f4449774d6a55774d54457a4d4446664d546b3d','0');

INSERT INTO test_mohan_payment (id, created_date_time, creator, creator_name, bill_company_id, bill_id, bill_number, bill_date, bill_type, party_id, party_name, party_type, payment_type, branch_id, payment_mode_id, payment_mode_name, bank_id, bank_name, open_balance_type, credit, debit, payment_tax_type, cash_balance, lr_id, deleted) VALUES ('39','2025-08-04 13:16:00','56564e46556c38774d513d3d','55334a706332396d64486468636d5636','54314a485155354a576b46555355394f587a45314d4455794d4449304d444d784e544935587a4178','62484a664d4451774f4449774d6a55774d5445324d4442664d6a413d','6/CMB-P','2025-08-04','LR Entry','51554e445545465356466c664d7a41774e7a49774d6a55774f4449344d544e664d44633d','','Account Party','','516c4a42546b4e49587a41354d4463794d4449314d4455304d544577587a4178','NULL','NULL','NULL','NULL','Debit','0','2200','NULL','0','62484a664d4451774f4449774d6a55774d5445324d4442664d6a413d','0');


CREATE TABLE `test_mohan_payment_mode` (
  `id` int(100) NOT NULL AUTO_INCREMENT,
  `created_date_time` datetime NOT NULL,
  `creator` mediumtext NOT NULL,
  `creator_name` mediumtext NOT NULL,
  `bill_company_id` mediumtext NOT NULL,
  `payment_mode_id` mediumtext NOT NULL,
  `payment_mode_name` mediumtext NOT NULL,
  `lower_case_name` mediumtext NOT NULL,
  `cash_balance` mediumtext NOT NULL,
  `deleted` int(100) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=9 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;


INSERT INTO test_mohan_payment_mode (id, created_date_time, creator, creator_name, bill_company_id, payment_mode_id, payment_mode_name, lower_case_name, cash_balance, deleted) VALUES ('1','2025-07-11 23:09:18','56564e46556c38774d513d3d','55334a706332396d64486468636d5636','54314a485155354a576b46555355394f587a45314d4455794d4449304d444d784e544935587a4178','5547463562575675644639746232526c587a45784d4463794d4449314d5445774f544534587a4178','5279425151566b3d','5a79427759586b3d','0','0');

INSERT INTO test_mohan_payment_mode (id, created_date_time, creator, creator_name, bill_company_id, payment_mode_id, payment_mode_name, lower_case_name, cash_balance, deleted) VALUES ('2','2025-07-11 23:09:59','56564e46556c38774d513d3d','55334a706332396d64486468636d5636','54314a485155354a576b46555355394f587a45314d4455794d4449304d444d784e544935587a4178','5547463562575675644639746232526c587a45784d4463794d4449314d5445774f545535587a4179','55306c575155744255306b67516c4a42546b4e4949454e425530673d','63326c325957746863326b67596e4a68626d4e6f49474e686332673d','1','1');

INSERT INTO test_mohan_payment_mode (id, created_date_time, creator, creator_name, bill_company_id, payment_mode_id, payment_mode_name, lower_case_name, cash_balance, deleted) VALUES ('3','2025-07-11 23:10:24','56564e46556c38774d513d3d','55334a706332396d64486468636d5636','54314a485155354a576b46555355394f587a45314d4455794d4449304d444d784e544935587a4178','5547463562575675644639746232526c587a45784d4463794d4449314d5445784d444930587a417a','5130465453413d3d','5932467a61413d3d','1','0');

INSERT INTO test_mohan_payment_mode (id, created_date_time, creator, creator_name, bill_company_id, payment_mode_id, payment_mode_name, lower_case_name, cash_balance, deleted) VALUES ('4','2025-07-15 11:55:09','56564e46556c38774d513d3d','55334a706332396d64486468636d5636','54314a485155354a576b46555355394f587a45314d4455794d4449304d444d784e544935587a4178','5547463562575675644639746232526c587a45314d4463794d4449314d5445314e544135587a4130','55456850546b55675545465a','63476876626d556763474635','0','0');

INSERT INTO test_mohan_payment_mode (id, created_date_time, creator, creator_name, bill_company_id, payment_mode_id, payment_mode_name, lower_case_name, cash_balance, deleted) VALUES ('5','2025-07-17 22:09:41','56564e46556c38774d513d3d','55334a706332396d64486468636d5636','54314a485155354a576b46555355394f587a45314d4455794d4449304d444d784e544935587a4178','5547463562575675644639746232526c587a45334d4463794d4449314d5441774f545178587a4131','55304e42546b354655673d3d','63324e68626d356c63673d3d','0','0');

INSERT INTO test_mohan_payment_mode (id, created_date_time, creator, creator_name, bill_company_id, payment_mode_id, payment_mode_name, lower_case_name, cash_balance, deleted) VALUES ('6','2025-07-22 23:16:33','56564e46556c38774d513d3d','55334a706332396d64486468636d5636','54314a485155354a576b46555355394f587a45314d4455794d4449304d444d784e544935587a4178','5547463562575675644639746232526c587a49794d4463794d4449314d5445784e6a4d7a587a4132','546b564756413d3d','626d566d64413d3d','0','0');

INSERT INTO test_mohan_payment_mode (id, created_date_time, creator, creator_name, bill_company_id, payment_mode_id, payment_mode_name, lower_case_name, cash_balance, deleted) VALUES ('7','2025-07-22 23:16:53','56564e46556c38774d513d3d','55334a706332396d64486468636d5636','54314a485155354a576b46555355394f587a45314d4455794d4449304d444d784e544935587a4178','5547463562575675644639746232526c587a49794d4463794d4449314d5445784e6a557a587a4133','5355315155773d3d','6157317763773d3d','0','0');

INSERT INTO test_mohan_payment_mode (id, created_date_time, creator, creator_name, bill_company_id, payment_mode_id, payment_mode_name, lower_case_name, cash_balance, deleted) VALUES ('8','2025-07-22 23:17:14','56564e46556c38774d513d3d','55334a706332396d64486468636d5636','54314a485155354a576b46555355394f587a45314d4455794d4449304d444d784e544935587a4178','5547463562575675644639746232526c587a49794d4463794d4449314d5445784e7a4530587a4134','556c524855773d3d','636e526e63773d3d','0','0');


CREATE TABLE `test_mohan_product` (
  `id` int(100) NOT NULL AUTO_INCREMENT,
  `created_date_time` datetime NOT NULL,
  `creator` mediumtext NOT NULL,
  `creator_name` mediumtext NOT NULL,
  `bill_company_id` mediumtext NOT NULL,
  `product_id` mediumtext NOT NULL,
  `product_name` mediumtext NOT NULL,
  `lower_case_name` mediumtext NOT NULL,
  `unit_id` mediumtext NOT NULL,
  `unit_name` mediumtext NOT NULL,
  `purchase_price` mediumtext NOT NULL,
  `hsn_code` mediumtext NOT NULL,
  `tax_slab` mediumtext NOT NULL,
  `deleted` int(100) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=15 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;


INSERT INTO test_mohan_product (id, created_date_time, creator, creator_name, bill_company_id, product_id, product_name, lower_case_name, unit_id, unit_name, purchase_price, hsn_code, tax_slab, deleted) VALUES ('1','2025-07-11 23:19:35','56564e46556c38774d513d3d','55334a706332396d64486468636d5636','54314a485155354a576b46555355394f587a45314d4455794d4449304d444d784e544935587a4178','55464a5052465644564638784d5441334d6a41794e5445784d546b7a4e5638774d513d3d','52456c465530564d','5a476c6c63325673','5655354a564638784d4441334d6a41794e54417a4d7a63304d3138774d773d3d','62476c30636d553d','93.52','NULL','NULL','0');

INSERT INTO test_mohan_product (id, created_date_time, creator, creator_name, bill_company_id, product_id, product_name, lower_case_name, unit_id, unit_name, purchase_price, hsn_code, tax_slab, deleted) VALUES ('2','2025-07-14 10:31:57','56564e46556c38774d513d3d','55334a706332396d64486468636d5636','54314a485155354a576b46555355394f587a45314d4455794d4449304d444d784e544935587a4178','55464a5052465644564638784e4441334d6a41794e5445774d7a45314e3138774d673d3d','516b3959','596d3934','5655354a564638774f5441334d6a41794e5441314e4467314e6c38774d513d3d','546b3954','NULL','NULL','NULL','0');

INSERT INTO test_mohan_product (id, created_date_time, creator, creator_name, bill_company_id, product_id, product_name, lower_case_name, unit_id, unit_name, purchase_price, hsn_code, tax_slab, deleted) VALUES ('3','2025-07-14 10:32:21','56564e46556c38774d513d3d','55334a706332396d64486468636d5636','54314a485155354a576b46555355394f587a45314d4455794d4449304d444d784e544935587a4178','55464a5052465644564638784e4441334d6a41794e5445774d7a49794d5638774d773d3d','556b394d54413d3d','636d397362413d3d','5655354a564638774f5441334d6a41794e5441314e4467314e6c38774d513d3d','546b3954','NULL','NULL','NULL','0');

INSERT INTO test_mohan_product (id, created_date_time, creator, creator_name, bill_company_id, product_id, product_name, lower_case_name, unit_id, unit_name, purchase_price, hsn_code, tax_slab, deleted) VALUES ('4','2025-07-14 10:33:10','56564e46556c38774d513d3d','55334a706332396d64486468636d5636','54314a485155354a576b46555355394f587a45314d4455794d4449304d444d784e544935587a4178','55464a5052465644564638784e4441334d6a41794e5445774d7a4d784d4638774e413d3d','516b4653556b564d','596d4679636d5673','5655354a564638774f5441334d6a41794e5441314e4467314e6c38774d513d3d','546b3954','NULL','NULL','NULL','0');

INSERT INTO test_mohan_product (id, created_date_time, creator, creator_name, bill_company_id, product_id, product_name, lower_case_name, unit_id, unit_name, purchase_price, hsn_code, tax_slab, deleted) VALUES ('5','2025-07-14 10:33:57','56564e46556c38774d513d3d','55334a706332396d64486468636d5636','54314a485155354a576b46555355394f587a45314d4455794d4449304d444d784e544935587a4178','55464a5052465644564638784e4441334d6a41794e5445774d7a4d314e3138774e513d3d','52464a5654513d3d','5a484a3162513d3d','5655354a564638774f5441334d6a41794e5441314e4467314e6c38774d513d3d','546b3954','NULL','NULL','NULL','0');

INSERT INTO test_mohan_product (id, created_date_time, creator, creator_name, bill_company_id, product_id, product_name, lower_case_name, unit_id, unit_name, purchase_price, hsn_code, tax_slab, deleted) VALUES ('6','2025-07-14 10:34:40','56564e46556c38774d513d3d','55334a706332396d64486468636d5636','54314a485155354a576b46555355394f587a45314d4455794d4449304d444d784e544935587a4178','55464a5052465644564638784e4441334d6a41794e5445774d7a51304d4638774e673d3d','556b564654413d3d','636d566c62413d3d','5655354a564638774f5441334d6a41794e5441314e4467314e6c38774d513d3d','546b3954','NULL','NULL','NULL','0');

INSERT INTO test_mohan_product (id, created_date_time, creator, creator_name, bill_company_id, product_id, product_name, lower_case_name, unit_id, unit_name, purchase_price, hsn_code, tax_slab, deleted) VALUES ('7','2025-07-14 10:35:02','56564e46556c38774d513d3d','55334a706332396d64486468636d5636','54314a485155354a576b46555355394f587a45314d4455794d4449304d444d784e544935587a4178','55464a5052465644564638784e4441334d6a41794e5445774d7a55774d6c38774e773d3d','5545784256455567516b3959','6347786864475567596d3934','5655354a564638774f5441334d6a41794e5441314e4467314e6c38774d513d3d','546b3954','NULL','NULL','NULL','0');

INSERT INTO test_mohan_product (id, created_date_time, creator, creator_name, bill_company_id, product_id, product_name, lower_case_name, unit_id, unit_name, purchase_price, hsn_code, tax_slab, deleted) VALUES ('8','2025-07-14 10:35:26','56564e46556c38774d513d3d','55334a706332396d64486468636d5636','54314a485155354a576b46555355394f587a45314d4455794d4449304d444d784e544935587a4178','55464a5052465644564638784e4441334d6a41794e5445774d7a55794e6c38774f413d3d','51314a4251307446556c4d67516b3959','59334a685932746c636e4d67596d3934','5655354a564638774f5441334d6a41794e5441314e4467314e6c38774d513d3d','546b3954','NULL','NULL','NULL','0');

INSERT INTO test_mohan_product (id, created_date_time, creator, creator_name, bill_company_id, product_id, product_name, lower_case_name, unit_id, unit_name, purchase_price, hsn_code, tax_slab, deleted) VALUES ('9','2025-07-14 10:35:51','56564e46556c38774d513d3d','55334a706332396d64486468636d5636','54314a485155354a576b46555355394f587a45314d4455794d4449304d444d784e544935587a4178','55464a5052465644564638784e4441334d6a41794e5445774d7a55314d5638774f513d3d','5530314254457767516b3959','6332316862477767596d3934','5655354a564638774f5441334d6a41794e5441314e4467314e6c38774d513d3d','546b3954','NULL','NULL','NULL','0');

INSERT INTO test_mohan_product (id, created_date_time, creator, creator_name, bill_company_id, product_id, product_name, lower_case_name, unit_id, unit_name, purchase_price, hsn_code, tax_slab, deleted) VALUES ('10','2025-07-14 10:36:09','56564e46556c38774d513d3d','55334a706332396d64486468636d5636','54314a485155354a576b46555355394f587a45314d4455794d4449304d444d784e544935587a4178','55464a5052465644564638784e4441334d6a41794e5445774d7a59774f5638784d413d3d','516b6c4849454a5057413d3d','596d6c6e49474a7665413d3d','5655354a564638774f5441334d6a41794e5441314e4467314e6c38774d513d3d','546b3954','NULL','NULL','NULL','0');

INSERT INTO test_mohan_product (id, created_date_time, creator, creator_name, bill_company_id, product_id, product_name, lower_case_name, unit_id, unit_name, purchase_price, hsn_code, tax_slab, deleted) VALUES ('11','2025-07-14 10:36:39','56564e46556c38774d513d3d','55334a706332396d64486468636d5636','54314a485155354a576b46555355394f587a45314d4455794d4449304d444d784e544935587a4178','55464a5052465644564638784e4441334d6a41794e5445774d7a597a4f5638784d513d3d','516c564f52457846','596e56755a47786c','5655354a564638774f5441334d6a41794e5441314e4467314e6c38774d513d3d','546b3954','NULL','NULL','NULL','0');

INSERT INTO test_mohan_product (id, created_date_time, creator, creator_name, bill_company_id, product_id, product_name, lower_case_name, unit_id, unit_name, purchase_price, hsn_code, tax_slab, deleted) VALUES ('12','2025-07-14 10:36:58','56564e46556c38774d513d3d','55334a706332396d64486468636d5636','54314a485155354a576b46555355394f587a45314d4455794d4449304d444d784e544935587a4178','55464a5052465644564638784e4441334d6a41794e5445774d7a59314f4638784d673d3d','52466c46','5a486c6c','5655354a564638774f5441334d6a41794e5441314e4467314e6c38774d513d3d','546b3954','NULL','NULL','NULL','0');

INSERT INTO test_mohan_product (id, created_date_time, creator, creator_name, bill_company_id, product_id, product_name, lower_case_name, unit_id, unit_name, purchase_price, hsn_code, tax_slab, deleted) VALUES ('13','2025-07-14 10:37:10','56564e46556c38774d513d3d','55334a706332396d64486468636d5636','54314a485155354a576b46555355394f587a45314d4455794d4449304d444d784e544935587a4178','55464a5052465644564638784e4441334d6a41794e5445774d7a63784d4638784d773d3d','5130464f52513d3d','593246755a513d3d','5655354a564638774f5441334d6a41794e5441314e4467314e6c38774d513d3d','546b3954','NULL','NULL','NULL','0');

INSERT INTO test_mohan_product (id, created_date_time, creator, creator_name, bill_company_id, product_id, product_name, lower_case_name, unit_id, unit_name, purchase_price, hsn_code, tax_slab, deleted) VALUES ('14','2025-07-14 15:54:52','56564e46556c38774d513d3d','55334a706332396d64486468636d5636','54314a485155354a576b46555355394f587a45314d4455794d4449304d444d784e544935587a4178','55464a5052465644564638784e4441334d6a41794e54417a4e5451314d6c38784e413d3d','56486c795a513d3d','64486c795a513d3d','5655354a564638774f5441334d6a41794e5441314e4467314e6c38774d513d3d','546b3954','35000','3892','12%','0');


CREATE TABLE `test_mohan_purchase_entry` (
  `id` int(100) NOT NULL AUTO_INCREMENT,
  `created_date_time` datetime NOT NULL,
  `creator` mediumtext NOT NULL,
  `creator_name` mediumtext NOT NULL,
  `bill_company_id` mediumtext NOT NULL,
  `bill_company_details` mediumtext NOT NULL,
  `purchase_entry_id` mediumtext NOT NULL,
  `purchase_entry_date` date NOT NULL,
  `purchase_bill_date` date NOT NULL DEFAULT current_timestamp(),
  `purchase_entry_number` mediumtext NOT NULL,
  `party_id` mediumtext NOT NULL,
  `party_name_mobile_city` mediumtext NOT NULL,
  `party_details` mediumtext NOT NULL,
  `company_state` mediumtext NOT NULL,
  `party_state` mediumtext NOT NULL,
  `gst_option` mediumtext NOT NULL,
  `tax_type` mediumtext NOT NULL,
  `tax_option` mediumtext NOT NULL,
  `product_id` mediumtext NOT NULL,
  `product_name` mediumtext NOT NULL,
  `quantity` mediumtext NOT NULL,
  `total_qty` mediumtext NOT NULL,
  `rate` mediumtext NOT NULL,
  `final_rate` mediumtext NOT NULL,
  `overall_tax` mediumtext NOT NULL,
  `product_amount` mediumtext NOT NULL,
  `amount` mediumtext NOT NULL,
  `sub_total` mediumtext NOT NULL,
  `discount_name` mediumtext NOT NULL,
  `discount` mediumtext NOT NULL,
  `discount_value` mediumtext NOT NULL,
  `discounted_total` mediumtext NOT NULL,
  `charges_id` mediumtext NOT NULL,
  `charges_value` mediumtext NOT NULL,
  `charges_total` mediumtext NOT NULL,
  `cgst_value` mediumtext NOT NULL,
  `sgst_value` mediumtext NOT NULL,
  `igst_value` mediumtext NOT NULL,
  `total_tax_value` mediumtext NOT NULL,
  `product_tax` mediumtext NOT NULL,
  `charges_tax` mediumtext NOT NULL,
  `round_off` mediumtext NOT NULL,
  `total_amount` mediumtext NOT NULL,
  `unit_id` mediumtext NOT NULL,
  `unit_name` mediumtext NOT NULL,
  `round_off_type` mediumtext NOT NULL,
  `round_off_value` mediumtext NOT NULL,
  `payment_updation` mediumtext NOT NULL,
  `cancelled` int(100) NOT NULL,
  `deleted` int(100) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;


INSERT INTO test_mohan_purchase_entry (id, created_date_time, creator, creator_name, bill_company_id, bill_company_details, purchase_entry_id, purchase_entry_date, purchase_bill_date, purchase_entry_number, party_id, party_name_mobile_city, party_details, company_state, party_state, gst_option, tax_type, tax_option, product_id, product_name, quantity, total_qty, rate, final_rate, overall_tax, product_amount, amount, sub_total, discount_name, discount, discount_value, discounted_total, charges_id, charges_value, charges_total, cgst_value, sgst_value, igst_value, total_tax_value, product_tax, charges_tax, round_off, total_amount, unit_id, unit_name, round_off_type, round_off_value, payment_updation, cancelled, deleted) VALUES ('1','2025-07-19 15:30:17','56564e46556c38774d513d3d','55334a706332396d64486468636d5636','54314a485155354a576b46555355394f587a45314d4455794d4449304d444d784e544935587a4178','545539495155346756464a42546c4e5154314a554a43516b55314a4a546b6c5751564e424945314655314d67546b56425569516b4a464e70646d467259584e704a43516b566d6c796457526f645735685a3246794a43516b5647467461577767546d466b6453516b4a44637a4e7a4d344e5459334e7a636b4a4351324d6a59784d6a4d6b4a43516752314e55535534674f69417a4d305a53553142544d6a6b774d455178576c493d','5546565351306842553056664d546b774e7a49774d6a55774d7a4d774d5464664d44453d','2025-07-19','2025-07-19','232','5546565351306842553056665545465356466c664d5451774e7a49774d6a55774d7a557a4e546c664d44493d','566d6c756233526f4943416f4f4463344e7a67334f4463344e796b674c53425461585a686132467a61513d3d','566d6c756233526f4943516b4a4445794d79427a64484a6c5a585167596e6c6c4948426863334d67636d39685a43516b4a465a70636e566b61485675595764686369516b4a464e70646d467259584e704a43516b5647467461577767546d466b6453516b4a4459794e6a45344f53516b4a4467334f4463344e7a67334f44633d','Tamil Nadu','Tamil Nadu','1','1','1','55464a5052465644564638784e4441334d6a41794e54417a4e5451314d6c38784e413d3d','56486c795a513d3d','4','4','35000','35000.00','','140000','140000','140000','','','NULL','140000','NULL','NULL','NULL','8400.00','8400.00','0','16800.00','12%','','2','156800','5655354a564638774f5441334d6a41794e5441314e4467314e6c38774d513d3d','546b3954','','','0','0','0');


CREATE TABLE `test_mohan_receipt` (
  `id` int(100) NOT NULL AUTO_INCREMENT,
  `created_date_time` datetime NOT NULL,
  `creator` mediumtext NOT NULL,
  `creator_name` mediumtext NOT NULL,
  `receipt_id` mediumtext NOT NULL,
  `bill_company_id` mediumtext NOT NULL,
  `receipt_number` mediumtext NOT NULL,
  `receipt_date` date NOT NULL,
  `gcno` mediumtext NOT NULL,
  `payment_tax_type` mediumtext NOT NULL,
  `lr_id` mediumtext NOT NULL,
  `lr_number` mediumtext NOT NULL,
  `party_id` mediumtext NOT NULL,
  `name_mobile_city` mediumtext NOT NULL,
  `party_type` mediumtext NOT NULL,
  `party_name` mediumtext NOT NULL,
  `amount` mediumtext NOT NULL,
  `narration` mediumtext NOT NULL,
  `payment_mode_id` mediumtext NOT NULL,
  `payment_mode_name` mediumtext NOT NULL,
  `bank_id` mediumtext NOT NULL,
  `bank_name` mediumtext NOT NULL,
  `total_amount` mediumtext NOT NULL,
  `sales_bill_id` mediumtext NOT NULL,
  `consignor_city` mediumtext NOT NULL,
  `consignor_id` mediumtext NOT NULL,
  `consignor_mobile_number` mediumtext NOT NULL,
  `consignee_city` mediumtext NOT NULL,
  `consignee_id` mediumtext NOT NULL,
  `consignee_mobile_number` mediumtext NOT NULL,
  `content` mediumtext NOT NULL,
  `quantity` mediumtext NOT NULL,
  `rate` mediumtext NOT NULL,
  `freight` mediumtext NOT NULL,
  `cooly` mediumtext NOT NULL,
  `bill_no` mediumtext NOT NULL,
  `bill_date` date NOT NULL,
  `bill_value` mediumtext NOT NULL,
  `private_mark` mediumtext NOT NULL,
  `pay_option` mediumtext NOT NULL,
  `vehicle_no` mediumtext NOT NULL,
  `cnr_client_name` mediumtext NOT NULL,
  `cne_client_name` mediumtext NOT NULL,
  `tax_percentage` mediumtext NOT NULL,
  `gst_option` int(100) NOT NULL,
  `consignee_state` mediumtext NOT NULL,
  `consignor_state` mediumtext NOT NULL,
  `consignor_gst_number` mediumtext NOT NULL,
  `consignee_gst_number` mediumtext NOT NULL,
  `description` mediumtext NOT NULL,
  `consignor_identification` mediumtext NOT NULL,
  `consignee_identification` mediumtext NOT NULL,
  `branch_id` mediumtext NOT NULL,
  `tripsheet_profit_loss_id` mediumtext NOT NULL,
  `deleted` int(10) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;


INSERT INTO test_mohan_receipt (id, created_date_time, creator, creator_name, receipt_id, bill_company_id, receipt_number, receipt_date, gcno, payment_tax_type, lr_id, lr_number, party_id, name_mobile_city, party_type, party_name, amount, narration, payment_mode_id, payment_mode_name, bank_id, bank_name, total_amount, sales_bill_id, consignor_city, consignor_id, consignor_mobile_number, consignee_city, consignee_id, consignee_mobile_number, content, quantity, rate, freight, cooly, bill_no, bill_date, bill_value, private_mark, pay_option, vehicle_no, cnr_client_name, cne_client_name, tax_percentage, gst_option, consignee_state, consignor_state, consignor_gst_number, consignee_gst_number, description, consignor_identification, consignee_identification, branch_id, tripsheet_profit_loss_id, deleted) VALUES ('1','2025-07-22 09:42:04','56564e46556c38784e4441334d6a41794e54417a4d7a4d7a4f5638774f413d3d','56476870636e56745a573570','556b564452556c51564638794d6a41334d6a41794e5441354e4449774e4638774d513d3d','54314a485155354a576b46555355394f587a45314d4455794d4449304d444d784e544935587a4178','RCT001/25-26','2025-07-22','','1','62484a664d6a49774e7a49774d6a55774f544d354d6a56664d44513d','2/SVK-P','5130394f55306c48546b5646587a45354d4463794d4449314d5449304e445179587a4d78','545339544c6942555255564c5653424c56553142556b464f49455a425530684a543034674c5341774e4455324d6a49314d545177','Consignee','545339544c6942555255564c5653424c56553142556b464f49455a425530684a5430343d','5000','596d6c7362413d3d','5547463562575675644639746232526c587a45784d4463794d4449314d5445784d444930587a417a','5130465453413d3d','','','5000','','','','','','','','','','','','','','0000-00-00','','','','','','','','0','','','','','','','','516c4a42546b4e49587a45304d4463794d4449314d444d7a4d545534587a4130','','0');

INSERT INTO test_mohan_receipt (id, created_date_time, creator, creator_name, receipt_id, bill_company_id, receipt_number, receipt_date, gcno, payment_tax_type, lr_id, lr_number, party_id, name_mobile_city, party_type, party_name, amount, narration, payment_mode_id, payment_mode_name, bank_id, bank_name, total_amount, sales_bill_id, consignor_city, consignor_id, consignor_mobile_number, consignee_city, consignee_id, consignee_mobile_number, content, quantity, rate, freight, cooly, bill_no, bill_date, bill_value, private_mark, pay_option, vehicle_no, cnr_client_name, cne_client_name, tax_percentage, gst_option, consignee_state, consignor_state, consignor_gst_number, consignee_gst_number, description, consignor_identification, consignee_identification, branch_id, tripsheet_profit_loss_id, deleted) VALUES ('2','2025-07-26 21:56:29','56564e46556c38774d513d3d','55334a706332396d64486468636d5636','556b564452556c51564638794e6a41334d6a41794e5441354e5459794f5638774d673d3d','54314a485155354a576b46555355394f587a45314d4455794d4449304d444d784e544935587a4178','RCT002/25-26','2025-07-26','','2','62484a664d6a49774e7a49774d6a55774e5455314d4464664d44633d','1/TPR-P','5130394f55306c48546b5646587a49794d4463794d4449314d4455304d444933587a517a','545339544c6b744a52464e445446564349464e44534539505443417449446b334f5441794e7a59314d7a6b3d','Consignee','545339544c6b744a52464e445446564349464e445345395054413d3d','500','5448493d','5547463562575675644639746232526c587a45784d4463794d4449314d5445774f544534587a4178','5279425151566b3d','516b464f533138784d5441334d6a41794e5445784d5451774e6c38774d513d3d','51306c5557534256546b6c50546942435155354c','500','','','','','','','','','','','','','','0000-00-00','','','','','','','','0','','','','','','','','516c4a42546b4e49587a41354d4463794d4449314d4455304d544577587a4178','','0');


CREATE TABLE `test_mohan_return` (
  `id` int(100) NOT NULL AUTO_INCREMENT,
  `created_date_time` datetime NOT NULL,
  `creator` mediumtext NOT NULL,
  `creator_name` mediumtext NOT NULL,
  `bill_company_id` mediumtext NOT NULL,
  `return_id` mediumtext NOT NULL,
  `return_number` mediumtext NOT NULL,
  `return_date` date NOT NULL,
  `party_name` mediumtext NOT NULL,
  `amount` mediumtext NOT NULL,
  `narration` mediumtext NOT NULL,
  `payment_mode_id` mediumtext NOT NULL,
  `payment_mode_name` mediumtext NOT NULL,
  `bank_id` mediumtext NOT NULL,
  `bank_name` mediumtext NOT NULL,
  `total_amount` mediumtext NOT NULL,
  `payment_tax_type` mediumtext NOT NULL,
  `deleted` int(10) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;


INSERT INTO test_mohan_return (id, created_date_time, creator, creator_name, bill_company_id, return_id, return_number, return_date, party_name, amount, narration, payment_mode_id, payment_mode_name, bank_id, bank_name, total_amount, payment_tax_type, deleted) VALUES ('1','2025-07-22 09:55:21','56564e46556c38774d513d3d','55334a706332396d64486468636d5636','54314a485155354a576b46555355394f587a45314d4455794d4449304d444d784e544935587a4178','636d563064584a75587a49794d4463794d4449314d446b314e544978587a4178','RN001/25-26','2025-07-22','54325a6d61574e6c','3200','596d6c7362413d3d','5547463562575675644639746232526c587a45784d4463794d4449314d5445774f544534587a4178','5279425151566b3d','516b464f533138784d5441334d6a41794e5445784d5451774e6c38774d513d3d','51306c5557534256546b6c50546942435155354c','3200','1','1');

INSERT INTO test_mohan_return (id, created_date_time, creator, creator_name, bill_company_id, return_id, return_number, return_date, party_name, amount, narration, payment_mode_id, payment_mode_name, bank_id, bank_name, total_amount, payment_tax_type, deleted) VALUES ('2','2025-07-22 09:56:09','56564e46556c38774d513d3d','55334a706332396d64486468636d5636','54314a485155354a576b46555355394f587a45314d4455794d4449304d444d784e544935587a4178','636d563064584a75587a49794d4463794d4449314d446b314e6a4135587a4179','RN002/25-26','2025-07-22','54325a6d61574e6c','20000','516d6c7362413d3d','5547463562575675644639746232526c587a45784d4463794d4449314d5445774f544534587a4178','5279425151566b3d','516b464f533138784d5441334d6a41794e5445784d5451774e6c38774d513d3d','51306c5557534256546b6c50546942435155354c','20000','1','1');


CREATE TABLE `test_mohan_role` (
  `id` int(100) NOT NULL AUTO_INCREMENT,
  `created_date_time` datetime NOT NULL,
  `creator` mediumtext NOT NULL,
  `creator_name` mediumtext NOT NULL,
  `role_id` mediumtext NOT NULL,
  `role_name` mediumtext NOT NULL,
  `lower_case_name` mediumtext NOT NULL,
  `access_pages` mediumtext NOT NULL,
  `access_page_actions` mediumtext NOT NULL,
  `is_branch_staff` mediumtext NOT NULL,
  `deleted` int(100) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;


INSERT INTO test_mohan_role (id, created_date_time, creator, creator_name, role_id, role_name, lower_case_name, access_pages, access_page_actions, is_branch_staff, deleted) VALUES ('1','2025-07-11 21:50:08','56564e46556c38774d513d3d','55334a706332396d64486468636d5636','556b394d525638784d5441334d6a41794e5441354e5441774f4638774d513d3d','55315a4c49464e5551555a47','63335a7249484e3059575a6d','566d566f61574e735a513d3d,52484a70646d5679,55474635625756756443424e6232526c,516d467561773d3d,5132397563326c6e626d3979,5132397563326c6e626d566c,51574e6a623356756443425159584a3065513d3d,5446493d,56484a7063484e6f5a575630,556d567762334a3063773d3d','566d6c6c64773d3d$$$5157526b,566d6c6c64773d3d$$$5157526b,566d6c6c64773d3d$$$5157526b,566d6c6c64773d3d$$$5157526b,566d6c6c64773d3d$$$5157526b,566d6c6c64773d3d$$$5157526b,566d6c6c64773d3d$$$5157526b,566d6c6c64773d3d$$$5157526b$$$5257527064413d3d,566d6c6c64773d3d$$$5157526b$$$5257527064413d3d,566d6c6c64773d3d','yes','0');

INSERT INTO test_mohan_role (id, created_date_time, creator, creator_name, role_id, role_name, lower_case_name, access_pages, access_page_actions, is_branch_staff, deleted) VALUES ('2','2025-07-14 15:32:43','56564e46556c38774d513d3d','55334a706332396d64486468636d5636','556b394d525638784e4441334d6a41794e54417a4d7a49304d3138774d673d3d','5132397062574a68644739795a5342546447466d5a673d3d','5932397062574a68644739795a53427a6447466d5a673d3d','52484a70646d5679,5657357064413d3d,55474635625756756443424e6232526c,516d467561773d3d,5132397563326c6e626d3979,5132397563326c6e626d566c,51574e6a623356756443425159584a3065513d3d,5446493d,56484a7063484e6f5a575630,56484a7063484e6f5a5756304946427962325a706443424d62334e7a,5357353262326c6a5a53424259327475623364735a57526e5a57316c626e513d,5657356a62475668636d46755932556752573530636e6b3d,556d566a5a576c7764413d3d,556d567762334a3063773d3d','566d6c6c64773d3d$$$5157526b$$$5257527064413d3d$$$524756735a58526c,566d6c6c64773d3d$$$5157526b$$$5257527064413d3d$$$524756735a58526c,566d6c6c64773d3d$$$5157526b$$$5257527064413d3d$$$524756735a58526c,566d6c6c64773d3d$$$5157526b$$$5257527064413d3d$$$524756735a58526c,566d6c6c64773d3d$$$5157526b$$$5257527064413d3d$$$524756735a58526c,566d6c6c64773d3d$$$5157526b$$$5257527064413d3d$$$524756735a58526c,566d6c6c64773d3d$$$5157526b$$$5257527064413d3d$$$524756735a58526c,566d6c6c64773d3d$$$5157526b$$$5257527064413d3d$$$524756735a58526c,566d6c6c64773d3d$$$5157526b$$$5257527064413d3d$$$524756735a58526c,566d6c6c64773d3d$$$5157526b$$$5257527064413d3d$$$524756735a58526c,566d6c6c64773d3d$$$5157526b,566d6c6c64773d3d,566d6c6c64773d3d$$$5157526b$$$524756735a58526c,566d6c6c64773d3d','yes','0');


CREATE TABLE `test_mohan_sms_count` (
  `id` int(100) NOT NULL AUTO_INCREMENT,
  `created_date_time` datetime NOT NULL,
  `creator` int(100) NOT NULL,
  `creator_name` mediumtext NOT NULL,
  `type` mediumtext NOT NULL,
  `lr_number` mediumtext NOT NULL,
  `mobile_number` mediumtext NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=13 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;


INSERT INTO test_mohan_sms_count (id, created_date_time, creator, creator_name, type, lr_number, mobile_number) VALUES ('1','2025-07-22 09:44:55','2147483647','56476870636e56745a573570','Clearance','1/SVK-P','9500396765');

INSERT INTO test_mohan_sms_count (id, created_date_time, creator, creator_name, type, lr_number, mobile_number) VALUES ('2','2025-07-22 09:44:55','2147483647','56476870636e56745a573570','Clearance','1/SVK-P','7373071370');

INSERT INTO test_mohan_sms_count (id, created_date_time, creator, creator_name, type, lr_number, mobile_number) VALUES ('3','2025-07-22 09:45:05','2147483647','56476870636e56745a573570','Clearance','2/SVK-P','9047348999');

INSERT INTO test_mohan_sms_count (id, created_date_time, creator, creator_name, type, lr_number, mobile_number) VALUES ('4','2025-07-22 09:45:05','2147483647','56476870636e56745a573570','Clearance','2/SVK-P','0456225140');

INSERT INTO test_mohan_sms_count (id, created_date_time, creator, creator_name, type, lr_number, mobile_number) VALUES ('5','2025-07-22 09:45:16','2147483647','56476870636e56745a573570','Clearance','2/SVK-G','6369288515');

INSERT INTO test_mohan_sms_count (id, created_date_time, creator, creator_name, type, lr_number, mobile_number) VALUES ('6','2025-07-22 09:45:16','2147483647','56476870636e56745a573570','Clearance','2/SVK-G','8971377733');

INSERT INTO test_mohan_sms_count (id, created_date_time, creator, creator_name, type, lr_number, mobile_number) VALUES ('7','2025-07-22 17:43:00','2147483647','55334a706332396d64486468636d5636','Clearance','1/CMB-P','9442245371');

INSERT INTO test_mohan_sms_count (id, created_date_time, creator, creator_name, type, lr_number, mobile_number) VALUES ('8','2025-07-22 17:43:00','2147483647','55334a706332396d64486468636d5636','Clearance','1/CMB-P','9047036221');

INSERT INTO test_mohan_sms_count (id, created_date_time, creator, creator_name, type, lr_number, mobile_number) VALUES ('9','2025-07-22 18:01:47','2147483647','55334a706332396d64486468636d5636','Clearance','3/CMB-P','9894804601');

INSERT INTO test_mohan_sms_count (id, created_date_time, creator, creator_name, type, lr_number, mobile_number) VALUES ('10','2025-07-22 18:01:47','2147483647','55334a706332396d64486468636d5636','Clearance','3/CMB-P','7373752470');

INSERT INTO test_mohan_sms_count (id, created_date_time, creator, creator_name, type, lr_number, mobile_number) VALUES ('11','2025-08-04 13:23:45','2147483647','55334a706332396d64486468636d5636','Clearance','3/SVK-G','9442254214');

INSERT INTO test_mohan_sms_count (id, created_date_time, creator, creator_name, type, lr_number, mobile_number) VALUES ('12','2025-08-04 13:23:45','2147483647','55334a706332396d64486468636d5636','Clearance','3/SVK-G','7092223808');


CREATE TABLE `test_mohan_staff` (
  `id` int(100) NOT NULL,
  `created_date_time` datetime NOT NULL,
  `creator` mediumtext NOT NULL,
  `creator_name` mediumtext NOT NULL,
  `bill_company_id` mediumtext NOT NULL,
  `staff_id` mediumtext NOT NULL,
  `name` mediumtext NOT NULL,
  `mobile_number` mediumtext NOT NULL,
  `username` mediumtext NOT NULL,
  `lower_case_name` mediumtext NOT NULL,
  `password` mediumtext NOT NULL,
  `deleted` int(100) NOT NULL,
  `access_pages` mediumtext NOT NULL,
  `branch_id` mediumtext NOT NULL,
  `access_page_actions` mediumtext NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;



CREATE TABLE `test_mohan_stock` (
  `id` int(100) NOT NULL,
  `created_date_time` datetime NOT NULL,
  `creator` int(100) NOT NULL,
  `invoice_number` mediumtext NOT NULL,
  `gcno` mediumtext NOT NULL,
  `receipt_quantity` mediumtext NOT NULL,
  `invoice_quantity` mediumtext NOT NULL,
  `remarks` mediumtext NOT NULL,
  `unit_id` mediumtext NOT NULL,
  `deleted` int(100) NOT NULL,
  `creator_name` mediumtext NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;



CREATE TABLE `test_mohan_suspense_party` (
  `id` int(100) NOT NULL AUTO_INCREMENT,
  `created_date_time` datetime NOT NULL,
  `creator` mediumtext NOT NULL,
  `creator_name` mediumtext NOT NULL,
  `bill_company_id` mediumtext NOT NULL,
  `suspense_party_id` mediumtext NOT NULL,
  `suspense_party_name` mediumtext NOT NULL,
  `lower_case_name` mediumtext NOT NULL,
  `address` mediumtext NOT NULL,
  `city` mediumtext NOT NULL,
  `district` mediumtext NOT NULL,
  `state` mediumtext NOT NULL,
  `pincode` mediumtext NOT NULL,
  `mobile_number` mediumtext NOT NULL,
  `others_city` mediumtext NOT NULL,
  `suspense_party_details` mediumtext NOT NULL,
  `opening_balance` mediumtext NOT NULL,
  `opening_balance_type` mediumtext NOT NULL,
  `name_mobile_city` mediumtext NOT NULL,
  `identification` mediumtext NOT NULL,
  `deleted` int(100) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;


INSERT INTO test_mohan_suspense_party (id, created_date_time, creator, creator_name, bill_company_id, suspense_party_id, suspense_party_name, lower_case_name, address, city, district, state, pincode, mobile_number, others_city, suspense_party_details, opening_balance, opening_balance_type, name_mobile_city, identification, deleted) VALUES ('1','2025-07-15 10:12:46','56564e46556c38774d513d3d','55334a706332396d64486468636d5636','54314a485155354a576b46555355394f587a45314d4455794d4449304d444d784e544935587a4178','553156545545564f553056665545465356466c664d5455774e7a49774d6a55784d4445794e445a664d44453d','533356745958493d','613356745958493d','4d54497a49484e30636d566c64434269655755676347467a63773d3d','55326c325957746863326b3d','566d6c796457526f645735685a324679','5647467461577767546d466b64513d3d','NULL','4f4463344e7a67334e7a67344e773d3d','Sivakasi','533356745958496b4a4351784d6a4d67633352795a57563049474a355a53427759584e7a4a43516b566d6c796457526f645735685a3246794a43516b55326c325957746863326b6b4a435255595731706243424f595752314a43516b4f4463344e7a67334e7a67344e773d3d','10000','Debit','53335674595849674b4467334f4463344e7a63344f4463704943306755326c325957746863326b3d','NULL','0');


CREATE TABLE `test_mohan_suspense_receipt` (
  `id` int(100) NOT NULL AUTO_INCREMENT,
  `created_date_time` datetime NOT NULL,
  `creator` mediumtext NOT NULL,
  `creator_name` mediumtext NOT NULL,
  `bill_company_id` mediumtext NOT NULL,
  `suspense_receipt_id` mediumtext NOT NULL,
  `suspense_receipt_number` mediumtext NOT NULL,
  `suspense_receipt_date` date NOT NULL,
  `bill_type` mediumtext NOT NULL,
  `suspense_party_id` mediumtext NOT NULL,
  `name_mobile_city` mediumtext NOT NULL,
  `suspense_party_type` mediumtext NOT NULL,
  `suspense_party_name` mediumtext NOT NULL,
  `amount` mediumtext NOT NULL,
  `narration` mediumtext NOT NULL,
  `payment_mode_id` mediumtext NOT NULL,
  `payment_mode_name` mediumtext NOT NULL,
  `bank_id` mediumtext NOT NULL,
  `bank_name` mediumtext NOT NULL,
  `total_amount` mediumtext NOT NULL,
  `payment_tax_type` mediumtext NOT NULL,
  `deleted` int(10) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;


INSERT INTO test_mohan_suspense_receipt (id, created_date_time, creator, creator_name, bill_company_id, suspense_receipt_id, suspense_receipt_number, suspense_receipt_date, bill_type, suspense_party_id, name_mobile_city, suspense_party_type, suspense_party_name, amount, narration, payment_mode_id, payment_mode_name, bank_id, bank_name, total_amount, payment_tax_type, deleted) VALUES ('1','2025-07-22 09:58:33','56564e46556c38774d513d3d','55334a706332396d64486468636d5636','54314a485155354a576b46555355394f587a45314d4455794d4449304d444d784e544935587a4178','6333567a6347567563325666636d566a5a576c77644638794d6a41334d6a41794e5441354e54677a4d3138774d513d3d','SR001/25-26','2025-07-22','','553156545545564f553056665545465356466c664d5455774e7a49774d6a55784d4445794e445a664d44453d','53335674595849674b4467334f4463344e7a63344f4463704943306755326c325957746863326b3d','Suspense Party','533356745958493d','23200','596d6c7362413d3d','5547463562575675644639746232526c587a45784d4463794d4449314d5445774f544534587a4178','5279425151566b3d','516b464f533138784d5441334d6a41794e5445784d5451774e6c38774d513d3d','51306c5557534256546b6c50546942435155354c','23200','1','0');


CREATE TABLE `test_mohan_suspense_voucher` (
  `id` int(100) NOT NULL AUTO_INCREMENT,
  `created_date_time` datetime NOT NULL,
  `creator` mediumtext NOT NULL,
  `creator_name` mediumtext NOT NULL,
  `bill_company_id` mediumtext NOT NULL,
  `suspense_voucher_id` mediumtext NOT NULL,
  `suspense_voucher_number` mediumtext NOT NULL,
  `suspense_voucher_date` date NOT NULL,
  `bill_type` mediumtext NOT NULL,
  `suspense_party_id` mediumtext NOT NULL,
  `name_mobile_city` mediumtext NOT NULL,
  `suspense_party_type` mediumtext NOT NULL,
  `suspense_party_name` mediumtext NOT NULL,
  `amount` mediumtext NOT NULL,
  `narration` mediumtext NOT NULL,
  `payment_mode_id` mediumtext NOT NULL,
  `payment_mode_name` mediumtext NOT NULL,
  `bank_id` mediumtext NOT NULL,
  `bank_name` mediumtext NOT NULL,
  `total_amount` mediumtext NOT NULL,
  `payment_tax_type` mediumtext NOT NULL,
  `deleted` int(10) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;


INSERT INTO test_mohan_suspense_voucher (id, created_date_time, creator, creator_name, bill_company_id, suspense_voucher_id, suspense_voucher_number, suspense_voucher_date, bill_type, suspense_party_id, name_mobile_city, suspense_party_type, suspense_party_name, amount, narration, payment_mode_id, payment_mode_name, bank_id, bank_name, total_amount, payment_tax_type, deleted) VALUES ('1','2025-07-22 09:57:59','56564e46556c38774d513d3d','55334a706332396d64486468636d5636','54314a485155354a576b46555355394f587a45314d4455794d4449304d444d784e544935587a4178','6333567a6347567563325666646d39315932686c636c38794d6a41334d6a41794e5441354e5463314f5638774d513d3d','SV001/25-26','2025-07-22','','553156545545564f553056665545465356466c664d5455774e7a49774d6a55784d4445794e445a664d44453d','53335674595849674b4467334f4463344e7a63344f4463704943306755326c325957746863326b3d','Suspense Party','533356745958493d','23200','516d6c7362413d3d','5547463562575675644639746232526c587a45784d4463794d4449314d5445774f544534587a4178','5279425151566b3d','516b464f533138784d5441334d6a41794e5445784d5451774e6c38774d513d3d','51306c5557534256546b6c50546942435155354c','23200','1','0');


CREATE TABLE `test_mohan_tripsheet` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `created_date_time` datetime NOT NULL,
  `creator` mediumtext NOT NULL,
  `creator_name` mediumtext NOT NULL,
  `tripsheet_id` mediumtext NOT NULL,
  `tripsheet_number` mediumtext NOT NULL,
  `organization_id` mediumtext NOT NULL,
  `organization_details` mediumtext NOT NULL,
  `godown_id` mediumtext NOT NULL,
  `tripsheet_date` date NOT NULL,
  `reference_number` mediumtext NOT NULL,
  `vehicle_id` mediumtext NOT NULL,
  `vehicle_name` mediumtext NOT NULL,
  `vehicle_number` mediumtext NOT NULL,
  `from_branch_id` mediumtext NOT NULL,
  `from_branch_name` mediumtext NOT NULL,
  `to_branch_id` mediumtext NOT NULL,
  `to_branch_name` mediumtext NOT NULL,
  `driver_name` mediumtext NOT NULL,
  `driver_number` mediumtext NOT NULL,
  `driver_salary` mediumtext NOT NULL,
  `helper_name` mediumtext NOT NULL,
  `lr_id` mediumtext NOT NULL,
  `lr_date` mediumtext NOT NULL,
  `lr_number` mediumtext NOT NULL,
  `from_branch_lr_id` mediumtext NOT NULL,
  `to_branch_lr_id` mediumtext NOT NULL,
  `consignor_id` mediumtext NOT NULL,
  `consignee_id` mediumtext NOT NULL,
  `quantity` mediumtext NOT NULL,
  `weight` mediumtext NOT NULL,
  `unit_id` mediumtext NOT NULL,
  `price_per_qty` mediumtext NOT NULL,
  `total_amount` mediumtext NOT NULL,
  `bill_type` mediumtext NOT NULL,
  `luggage_id` mediumtext NOT NULL,
  `is_acknowledged` int(100) NOT NULL,
  `destination_branch_id` mediumtext NOT NULL,
  `destination_branch_name` mediumtext NOT NULL,
  `cancelled` int(100) NOT NULL,
  `deleted` int(100) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;


INSERT INTO test_mohan_tripsheet (id, created_date_time, creator, creator_name, tripsheet_id, tripsheet_number, organization_id, organization_details, godown_id, tripsheet_date, reference_number, vehicle_id, vehicle_name, vehicle_number, from_branch_id, from_branch_name, to_branch_id, to_branch_name, driver_name, driver_number, driver_salary, helper_name, lr_id, lr_date, lr_number, from_branch_lr_id, to_branch_lr_id, consignor_id, consignee_id, quantity, weight, unit_id, price_per_qty, total_amount, bill_type, luggage_id, is_acknowledged, destination_branch_id, destination_branch_name, cancelled, deleted) VALUES ('1','2025-07-21 10:08:18','56564e46556c38774d513d3d','55334a706332396d64486468636d5636','56464a4a55464e4952555655587a49784d4463794d4449314d5441774f444534587a4178','1/SVK-TS','54314a485155354a576b46555355394f587a45314d4455794d4449304d444d784e544935587a4178','545539495155346756464a42546c4e5154314a554a43516b55314a4a546b6c5751564e424945314655314d67546b56425569516b4a4641755379354f49464a505155517349464e4a566b464c51564e4a4a43516b55326c325957746863326b6b4a4351324d6a59784d6a4d6b4a435255595731706243424f595752314a43516b4d7a4e47556c4e51557a49354d4442454d5670534a43516b4e7a4d334d7a67314e6a63334e773d3d','NULL','2025-04-01','NULL','646d566f61574e735a5638774f5441334d6a41794e5441314e4455774d5638774d673d3d','566d566f61574e735a534179','564534674f545567516941314e44517a','516c4a42546b4e49587a41354d4463794d4449314d4455304d544577587a4178','55326c325957746863326b3d','516c4a42546b4e49587a41354d4463794d4449314d4455304d6a5534587a4179,516c4a42546b4e49587a45304d4463794d4449314d444d7a4d545534587a4130','56476870636e56776458493d,5132397062574a68644739795a534243636d46755932673d','545856796457646862673d3d','4e6a55344f4463354d446b774f413d3d','','NULL','62484a664d546b774e7a49774d6a55774d7a55304e5468664d44493d','2025-04-01','2/SVK-G','516c4a42546b4e49587a41354d4463794d4449314d4455304d544577587a4178','516c4a42546b4e49587a45304d4463794d4449314d444d7a4d545534587a4130','5130394f55306c48546b3953587a45344d4463794d4449314d4463784f54457a587a45794f413d3d','5130394f55306c48546b5646587a45354d4463794d4449314d4445784e6a4532587a4d32','100','NULL','5655354a564638774f5441334d6a41794e5441314e4467314e6c38774d513d3d','300','32550','ToPay','NULL','1','516c4a42546b4e49587a41354d4463794d4449314d4455304d6a5534587a4179','56476870636e56776458493d','0','0');

INSERT INTO test_mohan_tripsheet (id, created_date_time, creator, creator_name, tripsheet_id, tripsheet_number, organization_id, organization_details, godown_id, tripsheet_date, reference_number, vehicle_id, vehicle_name, vehicle_number, from_branch_id, from_branch_name, to_branch_id, to_branch_name, driver_name, driver_number, driver_salary, helper_name, lr_id, lr_date, lr_number, from_branch_lr_id, to_branch_lr_id, consignor_id, consignee_id, quantity, weight, unit_id, price_per_qty, total_amount, bill_type, luggage_id, is_acknowledged, destination_branch_id, destination_branch_name, cancelled, deleted) VALUES ('2','2025-07-22 09:40:00','56564e46556c38774d513d3d','55334a706332396d64486468636d5636','56464a4a55464e4952555655587a49794d4463794d4449314d446b304d444177587a4179','2/SVK-TS','54314a485155354a576b46555355394f587a45314d4455794d4449304d444d784e544935587a4178','545539495155346756464a42546c4e5154314a554a43516b55314a4a546b6c5751564e424945314655314d67546b56425569516b4a4641755379354f49464a505155517349464e4a566b464c51564e4a4a43516b55326c325957746863326b6b4a4351324d6a59784d6a4d6b4a435255595731706243424f595752314a43516b4d7a4e47556c4e51557a49354d4442454d5670534a43516b4e7a4d334d7a67314e6a63334e773d3d','NULL','2025-04-01','4d6a673d','646d566f61574e735a5638784e5441334d6a41794e5441354e4463314d6c38774e413d3d','523246755a584e6f49465a6c61476c6a6247553d','564534354e554d344d446732','516c4a42546b4e49587a41354d4463794d4449314d4455304d544577587a4178','55326c325957746863326b3d','516c4a42546b4e49587a45304d4463794d4449314d444d7a4d545534587a4130','5132397062574a68644739795a534243636d46755932673d','523246755a584e6f','4e6a63794f446b784f4449334d673d3d','','644746746157773d','62484a664d6a49774e7a49774d6a55774f544d354d6a56664d44513d,62484a664d6a49774e7a49774d6a55774f544d344d4442664d444d3d','2025-04-01$$$2025-04-01','2/SVK-P$$$1/SVK-P','516c4a42546b4e49587a41354d4463794d4449314d4455304d544577587a4178$$$516c4a42546b4e49587a41354d4463794d4449314d4455304d544577587a4178','516c4a42546b4e49587a45304d4463794d4449314d444d7a4d545534587a4130$$$516c4a42546b4e49587a45304d4463794d4449314d444d7a4d545534587a4130','5130394f55306c48546b3953587a45334d4463794d4449314d4467774f444135587a45784f413d3d$$$5130394f55306c48546b3953587a45324d4463794d4449314d4445774d7a4130587a5979','5130394f55306c48546b5646587a45354d4463794d4449314d5449304e445179587a4d78$$$5130394f55306c48546b5646587a49784d4463794d4449314d4467794d545178587a4d34','$$$100','100$$$','5655354a564638784d4441334d6a41794e54417a4d7a63304d3138774e413d3d$$$5655354a564638784d4441334d6a41794e54417a4d7a63304d3138774d773d3d','20$$$10','5000$$$3000','ToPay$$$ToPay','NULL','1','516c4a42546b4e49587a45304d4463794d4449314d444d7a4d545534587a4130','5132397062574a68644739795a534243636d46755932673d','0','0');

INSERT INTO test_mohan_tripsheet (id, created_date_time, creator, creator_name, tripsheet_id, tripsheet_number, organization_id, organization_details, godown_id, tripsheet_date, reference_number, vehicle_id, vehicle_name, vehicle_number, from_branch_id, from_branch_name, to_branch_id, to_branch_name, driver_name, driver_number, driver_salary, helper_name, lr_id, lr_date, lr_number, from_branch_lr_id, to_branch_lr_id, consignor_id, consignee_id, quantity, weight, unit_id, price_per_qty, total_amount, bill_type, luggage_id, is_acknowledged, destination_branch_id, destination_branch_name, cancelled, deleted) VALUES ('3','2025-07-22 09:52:51','56564e46556c38784e4441334d6a41794e54417a4d7a4d7a4f5638774f413d3d','56476870636e56745a573570','56464a4a55464e4952555655587a49794d4463794d4449314d446b314d6a5578587a417a','1/CMB-TS','54314a485155354a576b46555355394f587a45314d4455794d4449304d444d784e544935587a4178','545539495155346756464a42546c4e5154314a554a43516b55314a4a546b6c5751564e424945314655314d67546b56425569516b4a4641755379354f49464a505155517349464e4a566b464c51564e4a4a43516b55326c325957746863326b6b4a4351324d6a59784d6a4d6b4a435255595731706243424f595752314a43516b4d7a4e47556c4e51557a49354d4442454d5670534a43516b4e7a4d334d7a67314e6a63334e773d3d','NULL','2025-04-01','4d7a497a','646d566f61574e735a5638784e5441334d6a41794e5441354e4463314d6c38774e413d3d','523246755a584e6f49465a6c61476c6a6247553d','564534354e554d344d446732','516c4a42546b4e49587a45304d4463794d4449314d444d7a4d545534587a4130','5132397062574a68644739795a534243636d46755932673d','516c4a42546b4e49587a41354d4463794d4449314d4455304d544577587a4178','55326c325957746863326b3d','523246755a584e6f','4e6a63794f446b784f4449334d673d3d','','616e5672','62484a664d6a49774e7a49774d6a55774f5455784d6a46664d44553d','2025-04-01','1/CMB-P','516c4a42546b4e49587a45304d4463794d4449314d444d7a4d545534587a4130','516c4a42546b4e49587a41354d4463794d4449314d4455304d544577587a4178','5130394f55306c48546b3953587a45334d4463794d4449314d4463784e6a4933587a45774f513d3d','5130394f55306c48546b5646587a45354d4463794d4449314d5449784f545531587a4930','100','NULL','5655354a564638784d4441334d6a41794e54417a4d7a63304d3138774d773d3d','10','3500','ToPay','NULL','1','516c4a42546b4e49587a41354d4463794d4449314d4455304d544577587a4178','55326c325957746863326b3d','0','0');

INSERT INTO test_mohan_tripsheet (id, created_date_time, creator, creator_name, tripsheet_id, tripsheet_number, organization_id, organization_details, godown_id, tripsheet_date, reference_number, vehicle_id, vehicle_name, vehicle_number, from_branch_id, from_branch_name, to_branch_id, to_branch_name, driver_name, driver_number, driver_salary, helper_name, lr_id, lr_date, lr_number, from_branch_lr_id, to_branch_lr_id, consignor_id, consignee_id, quantity, weight, unit_id, price_per_qty, total_amount, bill_type, luggage_id, is_acknowledged, destination_branch_id, destination_branch_name, cancelled, deleted) VALUES ('4','2025-07-22 18:00:13','56564e46556c38774d513d3d','55334a706332396d64486468636d5636','56464a4a55464e4952555655587a49794d4463794d4449314d4459774d44457a587a4130','2/CMB-TS','54314a485155354a576b46555355394f587a45314d4455794d4449304d444d784e544935587a4178','545539495155346756464a42546c4e5154314a554a43516b55314a4a546b6c5751564e424945314655314d67546b56425569516b4a4641755379354f49464a505155517349464e4a566b464c51564e4a4a43516b55326c325957746863326b6b4a4351324d6a59784d6a4d6b4a435255595731706243424f595752314a43516b4d7a4e47556c4e51557a49354d4442454d5670534a43516b4e7a4d334d7a67314e6a63334e773d3d','NULL','2025-07-22','NULL','646d566f61574e735a5638784e5441334d6a41794e5441354e4463314d6c38774e413d3d','523246755a584e6f49465a6c61476c6a6247553d','564534354e554d344d446732','516c4a42546b4e49587a45304d4463794d4449314d444d7a4d545534587a4130','5132397062574a68644739795a534243636d46755932673d','516c4a42546b4e49587a41354d4463794d4449314d4455304d544577587a4178','55326c325957746863326b3d','523246755a584e6f','4e6a63794f446b784f4449334d673d3d','','NULL','62484a664d6a49774e7a49774d6a55774e5455354e5446664d44673d','2025-07-22','3/CMB-P','516c4a42546b4e49587a45304d4463794d4449314d444d7a4d545534587a4130','516c4a42546b4e49587a41354d4463794d4449314d4455304d544577587a4178','5130394f55306c48546b3953587a45334d4463794d4449314d4467784d544d31587a45794d413d3d','5130394f55306c48546b5646587a49794d4463794d4449314d4455314e6a4d78587a5132','3','NULL','5655354a564638784d4441334d6a41794e54417a4d7a63304d3138774e673d3d','42','135','ToPay','NULL','1','516c4a42546b4e49587a41354d4463794d4449314d4455304d544577587a4178','55326c325957746863326b3d','0','0');

INSERT INTO test_mohan_tripsheet (id, created_date_time, creator, creator_name, tripsheet_id, tripsheet_number, organization_id, organization_details, godown_id, tripsheet_date, reference_number, vehicle_id, vehicle_name, vehicle_number, from_branch_id, from_branch_name, to_branch_id, to_branch_name, driver_name, driver_number, driver_salary, helper_name, lr_id, lr_date, lr_number, from_branch_lr_id, to_branch_lr_id, consignor_id, consignee_id, quantity, weight, unit_id, price_per_qty, total_amount, bill_type, luggage_id, is_acknowledged, destination_branch_id, destination_branch_name, cancelled, deleted) VALUES ('5','2025-08-04 13:21:28','56564e46556c38774d513d3d','55334a706332396d64486468636d5636','56464a4a55464e4952555655587a41304d4467794d4449314d4445794d544934587a4131','3/SVK-TS','54314a485155354a576b46555355394f587a45314d4455794d4449304d444d784e544935587a4178','545539495155346756464a42546c4e5154314a554a43516b55314a4a546b6c5751564e424945314655314d67546b56425569516b4a4641755379354f49464a505155517349464e4a566b464c51564e4a4a43516b55326c325957746863326b6b4a4351324d6a59784d6a4d6b4a435255595731706243424f595752314a43516b4d7a4e47556c4e51557a49354d4442454d5670534a43516b4e7a4d334d7a67314e6a63334e773d3d','NULL','2025-04-01','NULL','646d566f61574e735a5638784e5441334d6a41794e5441354e4463314d6c38774e413d3d','523246755a584e6f49465a6c61476c6a6247553d','564534354e554d344d446732','516c4a42546b4e49587a41354d4463794d4449314d4455304d544577587a4178','55326c325957746863326b3d','516c4a42546b4e49587a41354d4463794d4449314d4455304d6a5534587a4179','56476870636e56776458493d','523246755a584e6f','4e6a63794f446b784f4449334d673d3d','','62326c3165513d3d','62484a664d7a41774e7a49774d6a55774f4449344d544e664d54673d,62484a664d7a41774e7a49774d6a55774f44497a4d444e664d54633d,62484a664d6a67774e7a49774d6a55774e5445334d4468664d54593d,62484a664d6a67774e7a49774d6a55774e5441304d6a56664d54553d,62484a664d6a49774e7a49774d6a55784d5449314e544a664d446b3d','2025-07-23$$$2025-07-23$$$2025-04-23$$$2025-04-23$$$2025-04-01','6/SVK-P$$$5/SVK-P$$$4/SVK-P$$$3/SVK-P$$$3/SVK-G','516c4a42546b4e49587a41354d4463794d4449314d4455304d544577587a4178$$$516c4a42546b4e49587a41354d4463794d4449314d4455304d544577587a4178$$$516c4a42546b4e49587a41354d4463794d4449314d4455304d544577587a4178$$$516c4a42546b4e49587a41354d4463794d4449314d4455304d544577587a4178$$$516c4a42546b4e49587a41354d4463794d4449314d4455304d544577587a4178','516c4a42546b4e49587a41354d4463794d4449314d4455304d6a5534587a4179$$$516c4a42546b4e49587a41354d4463794d4449314d4455304d6a5534587a4179$$$516c4a42546b4e49587a41354d4463794d4449314d4455304d6a5534587a4179$$$516c4a42546b4e49587a41354d4463794d4449314d4455304d6a5534587a4179$$$516c4a42546b4e49587a41354d4463794d4449314d4455304d6a5534587a4179','5130394f55306c48546b3953587a45304d4463794d4449314d5445784d544930587a4579$$$5130394f55306c48546b3953587a4d774d4463794d4449314d4467794d7a417a587a457a4d513d3d$$$5130394f55306c48546b3953587a45794d4463794d4449314d4459314f544d34587a417a$$$5130394f55306c48546b3953587a45324d4463794d4449314d4451784d544134587a6378$$$5130394f55306c48546b3953587a45314d4463794d4449314d44637a4d444133587a5135','5130394f55306c48546b5646587a497a4d4463794d4449314d4445794d7a5533587a6332$$$5130394f55306c48546b5646587a4d774d4463794d4449314d4467794d7a417a587a45314f513d3d$$$5130394f55306c48546b5646587a49344d4463794d4449314d4455784e445133587a45314f413d3d$$$5130394f55306c48546b5646587a49344d4463794d4449314d4451314e544935587a45314e773d3d$$$5130394f55306c48546b5646587a49794d4463794d4449314d44597a4e6a4d77587a5979','22$$$26$$$18$$$14$$$100','NULL','5655354a564638774f5441334d6a41794e5441314e4467314e6c38774d513d3d$$$5655354a564638774f5441334d6a41794e5441314e4467314e6c38774d513d3d$$$5655354a564638774f5441334d6a41794e5441314e4467314e6c38774d513d3d$$$5655354a564638774f5441334d6a41794e5441314e4467314e6c38774d513d3d$$$5655354a564638774f5441334d6a41794e5441314e4467314e6c38774d513d3d','70$$$75$$$120$$$90$$$80','1760$$$2210$$$2340$$$1400$$$9450','Account Party$$$Account Party$$$Account Party$$$ToPay$$$Account Party','NULL','1','516c4a42546b4e49587a41354d4463794d4449314d4455304d6a5534587a4179','56476870636e56776458493d','0','0');


CREATE TABLE `test_mohan_tripsheet_profit_loss` (
  `id` int(100) NOT NULL AUTO_INCREMENT,
  `created_date_time` datetime NOT NULL,
  `creator` mediumtext NOT NULL,
  `creator_name` mediumtext NOT NULL,
  `bill_company_id` mediumtext NOT NULL,
  `tripsheet_profit_loss_id` mediumtext NOT NULL,
  `trip_number` mediumtext NOT NULL,
  `vehicle_id` mediumtext NOT NULL,
  `vehicle_number` mediumtext NOT NULL,
  `driver_name` mediumtext NOT NULL,
  `from_tripsheet_date` date NOT NULL,
  `from_tripsheet_id` mediumtext NOT NULL,
  `from_tripsheet_number` mediumtext NOT NULL,
  `from_tripsheet_from_branch` mediumtext NOT NULL,
  `from_tripsheet_to_branch` mediumtext NOT NULL,
  `from_tripsheet_quantity` mediumtext NOT NULL,
  `from_tripsheet_weight` mediumtext NOT NULL,
  `from_tripsheet_rent` mediumtext NOT NULL,
  `to_tripsheet_date` date NOT NULL,
  `to_tripsheet_id` mediumtext NOT NULL,
  `to_tripsheet_number` mediumtext NOT NULL,
  `to_tripsheet_from_branch` mediumtext NOT NULL,
  `to_tripsheet_to_branch` mediumtext NOT NULL,
  `to_tripsheet_quantity` mediumtext NOT NULL,
  `to_tripsheet_weight` mediumtext NOT NULL,
  `to_tripsheet_rent` mediumtext NOT NULL,
  `total_rent` mediumtext NOT NULL,
  `trip_cost` mediumtext NOT NULL,
  `balance` mediumtext NOT NULL,
  `loading_wage` mediumtext NOT NULL,
  `night_food` mediumtext NOT NULL,
  `driver_salary` mediumtext NOT NULL,
  `tire_depreciation` mediumtext NOT NULL,
  `toll_gate` mediumtext NOT NULL,
  `net_balance` mediumtext NOT NULL,
  `starting_km` mediumtext NOT NULL,
  `ending_km` mediumtext NOT NULL,
  `travelled_km` mediumtext NOT NULL,
  `diesel` mediumtext NOT NULL,
  `mileage` mediumtext NOT NULL,
  `trip_balance` mediumtext NOT NULL,
  `advance` mediumtext NOT NULL,
  `diesel_cost` mediumtext NOT NULL,
  `diesel_cost_per_litre` mediumtext NOT NULL,
  `expense_name` mediumtext NOT NULL,
  `expense_value` mediumtext NOT NULL,
  `company_expense_type` mediumtext NOT NULL,
  `driver_expense_type` mediumtext NOT NULL,
  `tripsheet_status` mediumtext NOT NULL,
  `company_expense_name` mediumtext NOT NULL,
  `company_expense_value` mediumtext NOT NULL,
  `company_diesel_amount` mediumtext NOT NULL,
  `driver_diesel_amount` mediumtext NOT NULL,
  `lr_payment` mediumtext NOT NULL,
  `lr_delivery` mediumtext NOT NULL,
  `deleted` int(100) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;


INSERT INTO test_mohan_tripsheet_profit_loss (id, created_date_time, creator, creator_name, bill_company_id, tripsheet_profit_loss_id, trip_number, vehicle_id, vehicle_number, driver_name, from_tripsheet_date, from_tripsheet_id, from_tripsheet_number, from_tripsheet_from_branch, from_tripsheet_to_branch, from_tripsheet_quantity, from_tripsheet_weight, from_tripsheet_rent, to_tripsheet_date, to_tripsheet_id, to_tripsheet_number, to_tripsheet_from_branch, to_tripsheet_to_branch, to_tripsheet_quantity, to_tripsheet_weight, to_tripsheet_rent, total_rent, trip_cost, balance, loading_wage, night_food, driver_salary, tire_depreciation, toll_gate, net_balance, starting_km, ending_km, travelled_km, diesel, mileage, trip_balance, advance, diesel_cost, diesel_cost_per_litre, expense_name, expense_value, company_expense_type, driver_expense_type, tripsheet_status, company_expense_name, company_expense_value, company_diesel_amount, driver_diesel_amount, lr_payment, lr_delivery, deleted) VALUES ('1','2025-07-25 09:48:07','56564e46556c38774d513d3d','55334a706332396d64486468636d5636','54314a485155354a576b46555355394f587a45314d4455794d4449304d444d784e544935587a4178','56464a4a55464e49525556555831424d587a49314d4463794d4449314d446b304f444133587a4178','636a56354e585235','646d566f61574e735a5638784e5441334d6a41794e5441354e4463314d6c38774e413d3d','564534354e554d344d446732','5a6d646d5a32673d','2025-04-01','56464a4a55464e4952555655587a49794d4463794d4449314d446b304d444177587a4179','2/SVK-TS','516c4a42546b4e49587a41354d4463794d4449314d4455304d544577587a4178','516c4a42546b4e49587a45304d4463794d4449314d444d7a4d545534587a4130','100','100','8000','2025-04-01','56464a4a55464e4952555655587a49794d4463794d4449314d446b314d6a5578587a417a','1/CMB-TS','516c4a42546b4e49587a45304d4463794d4449314d444d7a4d545534587a4130','516c4a42546b4e49587a41354d4463794d4449314d4455304d544577587a4178','100','NULL','3500','11500.00','4500.00','NULL','NULL','NULL','NULL','NULL','NULL','7000.00','500','566','66.00','50','1.32','7000.00','NULL','4500.00','90','பூஜை,சாப்பாடு படி','NULL','','','','','','','','','','1');

INSERT INTO test_mohan_tripsheet_profit_loss (id, created_date_time, creator, creator_name, bill_company_id, tripsheet_profit_loss_id, trip_number, vehicle_id, vehicle_number, driver_name, from_tripsheet_date, from_tripsheet_id, from_tripsheet_number, from_tripsheet_from_branch, from_tripsheet_to_branch, from_tripsheet_quantity, from_tripsheet_weight, from_tripsheet_rent, to_tripsheet_date, to_tripsheet_id, to_tripsheet_number, to_tripsheet_from_branch, to_tripsheet_to_branch, to_tripsheet_quantity, to_tripsheet_weight, to_tripsheet_rent, total_rent, trip_cost, balance, loading_wage, night_food, driver_salary, tire_depreciation, toll_gate, net_balance, starting_km, ending_km, travelled_km, diesel, mileage, trip_balance, advance, diesel_cost, diesel_cost_per_litre, expense_name, expense_value, company_expense_type, driver_expense_type, tripsheet_status, company_expense_name, company_expense_value, company_diesel_amount, driver_diesel_amount, lr_payment, lr_delivery, deleted) VALUES ('2','2025-07-31 10:09:15','56564e46556c38774d513d3d','55334a706332396d64486468636d5636','54314a485155354a576b46555355394f587a45314d4455794d4449304d444d784e544935587a4178','56464a4a55464e49525556555831424d587a4d784d4463794d4449314d5441774f544531587a4179','4d6a4d30','646d566f61574e735a5638784e5441334d6a41794e5441354e4463314d6c38774e413d3d','564534354e554d344d446732','59574a6a','2025-04-01','56464a4a55464e4952555655587a49794d4463794d4449314d446b314d6a5578587a417a','1/CMB-TS','516c4a42546b4e49587a45304d4463794d4449314d444d7a4d545534587a4130','516c4a42546b4e49587a41354d4463794d4449314d4455304d544577587a4178','100','NULL','3500','2025-04-01','56464a4a55464e4952555655587a49794d4463794d4449314d446b304d444177587a4179','2/SVK-TS','516c4a42546b4e49587a41354d4463794d4449314d4455304d544577587a4178','516c4a42546b4e49587a45304d4463794d4449314d444d7a4d545534587a4130','100','100','8000','11500.00','44.00','NULL','NULL','NULL','NULL','NULL','NULL','11456.00','10','33','23.00','2','11.50','11456.00','NULL','44.00','22','பூஜை,சாப்பாடு படி','NULL','','','','','','','','','','1');


CREATE TABLE `test_mohan_unit` (
  `id` int(100) NOT NULL AUTO_INCREMENT,
  `created_date_time` datetime NOT NULL,
  `creator` mediumtext NOT NULL,
  `creator_name` mediumtext NOT NULL,
  `bill_company_id` mediumtext NOT NULL,
  `unit_id` mediumtext NOT NULL,
  `unit_name` mediumtext NOT NULL,
  `lower_case_name` mediumtext NOT NULL,
  `deleted` int(100) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=19 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;


INSERT INTO test_mohan_unit (id, created_date_time, creator, creator_name, bill_company_id, unit_id, unit_name, lower_case_name, deleted) VALUES ('1','2025-07-09 17:48:56','56564e46556c38774d513d3d','55334a706332396d64486468636d5636','54314a485155354a576b46555355394f587a45314d4455794d4449304d444d784e544935587a4178','5655354a564638774f5441334d6a41794e5441314e4467314e6c38774d513d3d','546b3954','626d397a','0');

INSERT INTO test_mohan_unit (id, created_date_time, creator, creator_name, bill_company_id, unit_id, unit_name, lower_case_name, deleted) VALUES ('2','2025-07-10 15:37:43','56564e46556c38774d513d3d','55334a706332396d64486468636d5636','54314a485155354a576b46555355394f587a45314d4455794d4449304d444d784e544935587a4178','5655354a564638784d4441334d6a41794e54417a4d7a63304d3138774d673d3d','62576c6a636d39754d54493d','62576c6a636d39754d54493d','1');

INSERT INTO test_mohan_unit (id, created_date_time, creator, creator_name, bill_company_id, unit_id, unit_name, lower_case_name, deleted) VALUES ('3','2025-07-10 15:37:43','56564e46556c38774d513d3d','55334a706332396d64486468636d5636','54314a485155354a576b46555355394f587a45314d4455794d4449304d444d784e544935587a4178','5655354a564638784d4441334d6a41794e54417a4d7a63304d3138774d773d3d','62476c30636d553d','62476c30636d553d','0');

INSERT INTO test_mohan_unit (id, created_date_time, creator, creator_name, bill_company_id, unit_id, unit_name, lower_case_name, deleted) VALUES ('4','2025-07-10 15:37:43','56564e46556c38774d513d3d','55334a706332396d64486468636d5636','54314a485155354a576b46555355394f587a45314d4455794d4449304d444d784e544935587a4178','5655354a564638784d4441334d6a41794e54417a4d7a63304d3138774e413d3d','6132633d','6132633d','0');

INSERT INTO test_mohan_unit (id, created_date_time, creator, creator_name, bill_company_id, unit_id, unit_name, lower_case_name, deleted) VALUES ('5','2025-07-10 15:37:43','56564e46556c38774d513d3d','55334a706332396d64486468636d5636','54314a485155354a576b46555355394f587a45314d4455794d4449304d444d784e544935587a4178','5655354a564638784d4441334d6a41794e54417a4d7a63304d3138774e513d3d','52334a6862513d3d','5a334a6862513d3d','0');

INSERT INTO test_mohan_unit (id, created_date_time, creator, creator_name, bill_company_id, unit_id, unit_name, lower_case_name, deleted) VALUES ('6','2025-07-10 15:37:43','56564e46556c38774d513d3d','55334a706332396d64486468636d5636','54314a485155354a576b46555355394f587a45314d4455794d4449304d444d784e544935587a4178','5655354a564638784d4441334d6a41794e54417a4d7a63304d3138774e673d3d','55476c6c5932567a','63476c6c5932567a','0');

INSERT INTO test_mohan_unit (id, created_date_time, creator, creator_name, bill_company_id, unit_id, unit_name, lower_case_name, deleted) VALUES ('7','2025-07-11 22:25:00','56564e46556c38784d5441334d6a41794e5441354e5445784d6c38774e673d3d','566b464553565a4654413d3d','54314a485155354a576b46555355394f587a45314d4455794d4449304d444d784e544935587a4178','5655354a564638784d5441334d6a41794e5445774d6a55774d4638774e773d3d','516b4653556b564d','596d4679636d5673','1');

INSERT INTO test_mohan_unit (id, created_date_time, creator, creator_name, bill_company_id, unit_id, unit_name, lower_case_name, deleted) VALUES ('8','2025-07-11 22:25:00','56564e46556c38784d5441334d6a41794e5441354e5445784d6c38774e673d3d','566b464553565a4654413d3d','54314a485155354a576b46555355394f587a45314d4455794d4449304d444d784e544935587a4178','5655354a564638784d5441334d6a41794e5445774d6a55774d4638774f413d3d','52464a5654513d3d','5a484a3162513d3d','1');

INSERT INTO test_mohan_unit (id, created_date_time, creator, creator_name, bill_company_id, unit_id, unit_name, lower_case_name, deleted) VALUES ('9','2025-07-11 22:25:00','56564e46556c38784d5441334d6a41794e5441354e5445784d6c38774e673d3d','566b464553565a4654413d3d','54314a485155354a576b46555355394f587a45314d4455794d4449304d444d784e544935587a4178','5655354a564638784d5441334d6a41794e5445774d6a55774d4638774f513d3d','5130464f52513d3d','593246755a513d3d','1');

INSERT INTO test_mohan_unit (id, created_date_time, creator, creator_name, bill_company_id, unit_id, unit_name, lower_case_name, deleted) VALUES ('10','2025-07-11 22:25:00','56564e46556c38784d5441334d6a41794e5441354e5445784d6c38774e673d3d','566b464553565a4654413d3d','54314a485155354a576b46555355394f587a45314d4455794d4449304d444d784e544935587a4178','5655354a564638784d5441334d6a41794e5445774d6a55774d4638784d413d3d','52466c46','5a486c6c','1');

INSERT INTO test_mohan_unit (id, created_date_time, creator, creator_name, bill_company_id, unit_id, unit_name, lower_case_name, deleted) VALUES ('11','2025-07-11 22:25:00','56564e46556c38784d5441334d6a41794e5441354e5445784d6c38774e673d3d','566b464553565a4654413d3d','54314a485155354a576b46555355394f587a45314d4455794d4449304d444d784e544935587a4178','5655354a564638784d5441334d6a41794e5445774d6a55774d4638784d513d3d','516c564f52457846','596e56755a47786c','1');

INSERT INTO test_mohan_unit (id, created_date_time, creator, creator_name, bill_company_id, unit_id, unit_name, lower_case_name, deleted) VALUES ('12','2025-07-11 22:25:00','56564e46556c38784d5441334d6a41794e5441354e5445784d6c38774e673d3d','566b464553565a4654413d3d','54314a485155354a576b46555355394f587a45314d4455794d4449304d444d784e544935587a4178','5655354a564638784d5441334d6a41794e5445774d6a55774d4638784d673d3d','516b6c4849454a5057413d3d','596d6c6e49474a7665413d3d','1');

INSERT INTO test_mohan_unit (id, created_date_time, creator, creator_name, bill_company_id, unit_id, unit_name, lower_case_name, deleted) VALUES ('13','2025-07-11 22:25:00','56564e46556c38784d5441334d6a41794e5441354e5445784d6c38774e673d3d','566b464553565a4654413d3d','54314a485155354a576b46555355394f587a45314d4455794d4449304d444d784e544935587a4178','5655354a564638784d5441334d6a41794e5445774d6a55774d4638784d773d3d','5530314254457767516b3959','6332316862477767596d3934','1');

INSERT INTO test_mohan_unit (id, created_date_time, creator, creator_name, bill_company_id, unit_id, unit_name, lower_case_name, deleted) VALUES ('14','2025-07-11 22:25:00','56564e46556c38784d5441334d6a41794e5441354e5445784d6c38774e673d3d','566b464553565a4654413d3d','54314a485155354a576b46555355394f587a45314d4455794d4449304d444d784e544935587a4178','5655354a564638784d5441334d6a41794e5445774d6a55774d4638784e413d3d','51314a4251307446556942435431673d','59334a685932746c636942696233673d','1');

INSERT INTO test_mohan_unit (id, created_date_time, creator, creator_name, bill_company_id, unit_id, unit_name, lower_case_name, deleted) VALUES ('15','2025-07-11 22:25:00','56564e46556c38784d5441334d6a41794e5441354e5445784d6c38774e673d3d','566b464553565a4654413d3d','54314a485155354a576b46555355394f587a45314d4455794d4449304d444d784e544935587a4178','5655354a564638784d5441334d6a41794e5445774d6a55774d4638784e513d3d','5545784256455567516b3959','6347786864475567596d3934','1');

INSERT INTO test_mohan_unit (id, created_date_time, creator, creator_name, bill_company_id, unit_id, unit_name, lower_case_name, deleted) VALUES ('16','2025-07-11 22:25:00','56564e46556c38784d5441334d6a41794e5441354e5445784d6c38774e673d3d','566b464553565a4654413d3d','54314a485155354a576b46555355394f587a45314d4455794d4449304d444d784e544935587a4178','5655354a564638784d5441334d6a41794e5445774d6a55774d4638784e673d3d','556b564654413d3d','636d566c62413d3d','1');

INSERT INTO test_mohan_unit (id, created_date_time, creator, creator_name, bill_company_id, unit_id, unit_name, lower_case_name, deleted) VALUES ('17','2025-07-11 22:25:00','56564e46556c38784d5441334d6a41794e5441354e5445784d6c38774e673d3d','566b464553565a4654413d3d','54314a485155354a576b46555355394f587a45314d4455794d4449304d444d784e544935587a4178','5655354a564638784d5441334d6a41794e5445774d6a55774d4638784e773d3d','556b394d54413d3d','636d397362413d3d','1');

INSERT INTO test_mohan_unit (id, created_date_time, creator, creator_name, bill_company_id, unit_id, unit_name, lower_case_name, deleted) VALUES ('18','2025-07-14 10:09:07','56564e46556c38784d5441334d6a41794e5441354e5445784d6c38774e673d3d','566b464553565a4654413d3d','54314a485155354a576b46555355394f587a45314d4455794d4449304d444d784e544935587a4178','5655354a564638784e4441334d6a41794e5445774d446b774e3138784f413d3d','546b3954','626d397a','1');


CREATE TABLE `test_mohan_unit_price` (
  `id` int(100) NOT NULL AUTO_INCREMENT,
  `created_date_time` datetime NOT NULL,
  `creator` mediumtext NOT NULL,
  `creator_name` mediumtext NOT NULL,
  `bill_company_id` mediumtext NOT NULL,
  `party_type` mediumtext NOT NULL,
  `party_id` mediumtext NOT NULL,
  `party_name` mediumtext NOT NULL,
  `unit_id` mediumtext NOT NULL,
  `unit_name` mediumtext NOT NULL,
  `price_value` mediumtext NOT NULL,
  `cooly_value` mediumtext NOT NULL,
  `deleted` int(100) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;


INSERT INTO test_mohan_unit_price (id, created_date_time, creator, creator_name, bill_company_id, party_type, party_id, party_name, unit_id, unit_name, price_value, cooly_value, deleted) VALUES ('1','2025-07-11 22:13:05','56564e46556c38784d5441334d6a41794e5441354e5445784d6c38774e673d3d','4e545932596a51324e4455314d7a55324e5745304e6a55304e44457a5a444e6b','54314a485155354a576b46555355394f587a45314d4455794d4449304d444d784e544935587a4178','Consignee','5130394f55306c48546b5646587a45784d4463794d4449314d5441784d7a4131587a4179','545339544c6c5a4654453156556c564851553467526b6c4f52534242556c5254','5655354a564638774f5441334d6a41794e5441314e4467314e6c38774d513d3d','516d3934','80','','0');

INSERT INTO test_mohan_unit_price (id, created_date_time, creator, creator_name, bill_company_id, party_type, party_id, party_name, unit_id, unit_name, price_value, cooly_value, deleted) VALUES ('2','2025-07-11 22:17:03','56564e46556c38784d5441334d6a41794e5441354e5445784d6c38774e673d3d','4e545932596a51324e4455314d7a55324e5745304e6a55304e44457a5a444e6b','54314a485155354a576b46555355394f587a45314d4455794d4449304d444d784e544935587a4178','Account Party','51554e445545465356466c664d5445774e7a49774d6a55784d4445334d444e664d44453d','545339544c6c5a4654453156556c564851553467526b6c4f52534242556c5254','5655354a564638774f5441334d6a41794e5441314e4467314e6c38774d513d3d','516d3934','80','','0');


CREATE TABLE `test_mohan_user` (
  `id` int(100) NOT NULL AUTO_INCREMENT,
  `created_date_time` datetime NOT NULL,
  `creator` mediumtext NOT NULL,
  `creator_name` mediumtext NOT NULL,
  `user_id` mediumtext NOT NULL,
  `name` mediumtext NOT NULL,
  `lower_case_name` mediumtext NOT NULL,
  `mobile_number` mediumtext NOT NULL,
  `type` mediumtext NOT NULL,
  `username` mediumtext NOT NULL,
  `password` mediumtext NOT NULL,
  `admin` int(100) NOT NULL,
  `role_id` mediumtext NOT NULL,
  `role_name` mediumtext NOT NULL,
  `branch_id` mediumtext NOT NULL,
  `is_branch_staff` mediumtext NOT NULL,
  `deleted` int(100) NOT NULL,
  `bill_company_id` mediumtext NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=9 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;


INSERT INTO test_mohan_user (id, created_date_time, creator, creator_name, user_id, name, lower_case_name, mobile_number, type, username, password, admin, role_id, role_name, branch_id, is_branch_staff, deleted, bill_company_id) VALUES ('1','2021-09-15 11:11:11','56564e46556c38774d513d3d','55334a706332396d64486468636d5636','56564e46556c38774d513d3d','55334a706332396d64486468636d5636','63334a706332396d64486468636d5636','4d544d304f546b344d7a517a4e413d3d','553356775a584967515752746157343d','55334a706332396d64486468636d5636','51575274615734784d6a4e41','1','NULL','NULL','NULL','NULL','0','5130394e5545464f575638774d513d3d');

INSERT INTO test_mohan_user (id, created_date_time, creator, creator_name, user_id, name, lower_case_name, mobile_number, type, username, password, admin, role_id, role_name, branch_id, is_branch_staff, deleted, bill_company_id) VALUES ('6','2025-07-11 21:51:12','56564e46556c38774d513d3d','55334a706332396d64486468636d5636','56564e46556c38784d5441334d6a41794e5441354e5445784d6c38774e673d3d','63335669596e553d','646d466b61585a6c62413d3d','4f44677a4f4441354f4451304f513d3d','Staff','566b464553565a4654413d3d','564734324e32467a4e7a55354e45413d','0','556b394d525638784d5441334d6a41794e5441354e5441774f4638774d513d3d','55315a4c49464e5551555a47','516c4a42546b4e49587a41354d4463794d4449314d4455304d544577587a4178','yes','0','54314a485155354a576b46555355394f587a45314d4455794d4449304d444d784e544935587a4178');

INSERT INTO test_mohan_user (id, created_date_time, creator, creator_name, user_id, name, lower_case_name, mobile_number, type, username, password, admin, role_id, role_name, branch_id, is_branch_staff, deleted, bill_company_id) VALUES ('7','2025-07-11 21:54:31','56564e46556c38774d513d3d','55334a706332396d64486468636d5636','56564e46556c38784d5441334d6a41794e5441354e54517a4d5638774e773d3d','56464253','644842794947396d5a6d6c6a5a513d3d','4f5459314e54557a4d6a41304f413d3d','Staff','5646425349453947526b6c4452513d3d','5648427951446b324e545531','0','556b394d525638784d5441334d6a41794e5441354e5441774f4638774d513d3d','55315a4c49464e5551555a47','516c4a42546b4e49587a41354d4463794d4449314d4455304d6a5534587a4179','yes','0','54314a485155354a576b46555355394f587a45314d4455794d4449304d444d784e544935587a4178');

INSERT INTO test_mohan_user (id, created_date_time, creator, creator_name, user_id, name, lower_case_name, mobile_number, type, username, password, admin, role_id, role_name, branch_id, is_branch_staff, deleted, bill_company_id) VALUES ('8','2025-07-14 15:33:39','56564e46556c38774d513d3d','55334a706332396d64486468636d5636','56564e46556c38784e4441334d6a41794e54417a4d7a4d7a4f5638774f413d3d','56476870636e56745a573570','5932397062574a68644739795a513d3d','4f4463344e7a67334f4463334f413d3d','Staff','5132397062574a68644739795a513d3d','5132397062574a68644739795a5445794d30413d','0','556b394d525638784e4441334d6a41794e54417a4d7a49304d3138774d673d3d','5132397062574a68644739795a5342546447466d5a673d3d','516c4a42546b4e49587a45304d4463794d4449314d444d7a4d545534587a4130','yes','0','54314a485155354a576b46555355394f587a45314d4455794d4449304d444d784e544935587a4178');


CREATE TABLE `test_mohan_user_staff` (
  `id` int(100) NOT NULL,
  `created_date_time` datetime NOT NULL,
  `creator` mediumtext NOT NULL,
  `creator_name` mediumtext NOT NULL,
  `bill_company_id` mediumtext NOT NULL,
  `staff_id` mediumtext NOT NULL,
  `name` mediumtext NOT NULL,
  `mobile_number` mediumtext NOT NULL,
  `username` mediumtext NOT NULL,
  `lower_case_name` mediumtext NOT NULL,
  `password` mediumtext NOT NULL,
  `deleted` int(100) NOT NULL,
  `access_pages` mediumtext NOT NULL,
  `branch_id` mediumtext NOT NULL,
  `access_page_actions` mediumtext NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;



CREATE TABLE `test_mohan_vehicle` (
  `id` int(100) NOT NULL AUTO_INCREMENT,
  `creator` mediumtext NOT NULL,
  `created_date_time` datetime NOT NULL,
  `creator_name` mediumtext NOT NULL,
  `bill_company_id` mediumtext NOT NULL,
  `vehicle_id` mediumtext NOT NULL,
  `name` mediumtext NOT NULL,
  `mobile_number` mediumtext NOT NULL,
  `vehicle_number` mediumtext NOT NULL,
  `vehicle_type` mediumtext NOT NULL,
  `insurance_date` date NOT NULL,
  `lower_case_name` mediumtext NOT NULL,
  `pollution_date` date NOT NULL,
  `permit_date` date NOT NULL,
  `np_tax_date` date NOT NULL,
  `road_tax_date` date NOT NULL,
  `fitness_date` date NOT NULL,
  `deleted` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;


INSERT INTO test_mohan_vehicle (id, creator, created_date_time, creator_name, bill_company_id, vehicle_id, name, mobile_number, vehicle_number, vehicle_type, insurance_date, lower_case_name, pollution_date, permit_date, np_tax_date, road_tax_date, fitness_date, deleted) VALUES ('1','56564e46556c38784d5441334d6a41794e5441354e5445784d6c38774e673d3d','2025-07-12 11:34:16','566b464553565a4654413d3d','54314a485155354a576b46555355394f587a45314d4455794d4449304d444d784e544935587a4178','646d566f61574e735a5638774f5441334d6a41794e5441314e4451304e5638774d513d3d','566d566f61574e735a534178','4f4467334d5449784d6a41354d413d3d','564534674f545567517941304d7a4d77','1','2025-07-09','644734674f545567597941304d7a4d77','0000-00-00','0000-00-00','0000-00-00','0000-00-00','0000-00-00','0');

INSERT INTO test_mohan_vehicle (id, creator, created_date_time, creator_name, bill_company_id, vehicle_id, name, mobile_number, vehicle_number, vehicle_type, insurance_date, lower_case_name, pollution_date, permit_date, np_tax_date, road_tax_date, fitness_date, deleted) VALUES ('2','56564e46556c38784d5441334d6a41794e5441354e5445784d6c38774e673d3d','2025-07-12 11:34:06','566b464553565a4654413d3d','54314a485155354a576b46555355394f587a45314d4455794d4449304d444d784e544935587a4178','646d566f61574e735a5638774f5441334d6a41794e5441314e4455774d5638774d673d3d','566d566f61574e735a534179','4f4463344e7a59314e6a63774d413d3d','564534674f545567516941314e44517a','','2025-07-09','644734674f545567596941314e44517a','0000-00-00','0000-00-00','0000-00-00','0000-00-00','0000-00-00','0');

INSERT INTO test_mohan_vehicle (id, creator, created_date_time, creator_name, bill_company_id, vehicle_id, name, mobile_number, vehicle_number, vehicle_type, insurance_date, lower_case_name, pollution_date, permit_date, np_tax_date, road_tax_date, fitness_date, deleted) VALUES ('3','56564e46556c38774d513d3d','2025-07-09 17:46:04','55334a706332396d64486468636d5636','54314a485155354a576b46555355394f587a45314d4455794d4449304d444d784e544935587a4178','646d566f61574e735a5638774f5441334d6a41794e5441314e44557a4e6c38774d773d3d','5248646b647a493d','4d6a4d7a4e4455314e5451304d513d3d','64324d784d6a4579','2','2025-07-11','64324d784d6a4579','0000-00-00','0000-00-00','0000-00-00','0000-00-00','0000-00-00','1');

INSERT INTO test_mohan_vehicle (id, creator, created_date_time, creator_name, bill_company_id, vehicle_id, name, mobile_number, vehicle_number, vehicle_type, insurance_date, lower_case_name, pollution_date, permit_date, np_tax_date, road_tax_date, fitness_date, deleted) VALUES ('4','56564e46556c38774d513d3d','2025-07-15 09:47:52','55334a706332396d64486468636d5636','','646d566f61574e735a5638784e5441334d6a41794e5441354e4463314d6c38774e413d3d','523246755a584e6f49465a6c61476c6a6247553d','4e6a4d344f5445334f4449344d513d3d','564534354e554d344d446732','2','2025-08-08','644734354e574d344d446732','0000-00-00','0000-00-00','0000-00-00','0000-00-00','0000-00-00','0');


CREATE TABLE `test_mohan_voucher` (
  `id` int(100) NOT NULL AUTO_INCREMENT,
  `created_date_time` datetime NOT NULL,
  `creator` mediumtext NOT NULL,
  `creator_name` mediumtext NOT NULL,
  `bill_company_id` mediumtext NOT NULL,
  `voucher_id` mediumtext NOT NULL,
  `voucher_number` mediumtext NOT NULL,
  `voucher_date` date NOT NULL,
  `bill_type` mediumtext NOT NULL,
  `party_id` mediumtext NOT NULL,
  `name_mobile_city` mediumtext NOT NULL,
  `party_type` mediumtext NOT NULL,
  `payment_type` mediumtext NOT NULL,
  `party_name` mediumtext NOT NULL,
  `amount` mediumtext NOT NULL,
  `narration` mediumtext NOT NULL,
  `payment_mode_id` mediumtext NOT NULL,
  `payment_mode_name` mediumtext NOT NULL,
  `bank_id` mediumtext NOT NULL,
  `bank_name` mediumtext NOT NULL,
  `total_amount` mediumtext NOT NULL,
  `payment_tax_type` mediumtext NOT NULL,
  `purchase_entry_id` mediumtext NOT NULL,
  `deleted` int(10) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;


INSERT INTO test_mohan_voucher (id, created_date_time, creator, creator_name, bill_company_id, voucher_id, voucher_number, voucher_date, bill_type, party_id, name_mobile_city, party_type, payment_type, party_name, amount, narration, payment_mode_id, payment_mode_name, bank_id, bank_name, total_amount, payment_tax_type, purchase_entry_id, deleted) VALUES ('1','2025-07-19 15:42:19','56564e46556c38774d513d3d','55334a706332396d64486468636d5636','54314a485155354a576b46555355394f587a45314d4455794d4449304d444d784e544935587a4178','646d39315932686c636c38784f5441334d6a41794e54417a4e4449784f5638774d513d3d','V001/25-26','2025-07-19','','5546565351306842553056665545465356466c664d5451774e7a49774d6a55774d7a557a4e546c664d44493d','566d6c756233526f4943416f4f4463344e7a67334f4463344e796b674c53425461585a686132467a61513d3d','1','','566d6c756233526f49413d3d','156800','596d6c7362413d3d','5547463562575675644639746232526c587a45784d4463794d4449314d5445774f544534587a4178','5279425151566b3d','516b464f533138784d5441334d6a41794e5445784d5451774e6c38774d513d3d','51306c5557534256546b6c50546942435155354c','156800','1','','1');

INSERT INTO test_mohan_voucher (id, created_date_time, creator, creator_name, bill_company_id, voucher_id, voucher_number, voucher_date, bill_type, party_id, name_mobile_city, party_type, payment_type, party_name, amount, narration, payment_mode_id, payment_mode_name, bank_id, bank_name, total_amount, payment_tax_type, purchase_entry_id, deleted) VALUES ('2','2025-07-19 15:43:47','56564e46556c38774d513d3d','55334a706332396d64486468636d5636','54314a485155354a576b46555355394f587a45314d4455794d4449304d444d784e544935587a4178','646d39315932686c636c38784f5441334d6a41794e54417a4e444d304e3138774d673d3d','V002/25-26','2025-07-19','','5546565351306842553056665545465356466c664d5451774e7a49774d6a55774d7a557a4e546c664d44493d','566d6c756233526f4943416f4f4463344e7a67334f4463344e796b674c53425461585a686132467a61513d3d','1','','566d6c756233526f49413d3d','156800','596d6c7362413d3d','5547463562575675644639746232526c587a45784d4463794d4449314d5445774f544534587a4178','5279425151566b3d','516b464f533138784d5441334d6a41794e5445784d5451774e6c38774d513d3d','51306c5557534256546b6c50546942435155354c','156800','1','','0');

INSERT INTO test_mohan_voucher (id, created_date_time, creator, creator_name, bill_company_id, voucher_id, voucher_number, voucher_date, bill_type, party_id, name_mobile_city, party_type, payment_type, party_name, amount, narration, payment_mode_id, payment_mode_name, bank_id, bank_name, total_amount, payment_tax_type, purchase_entry_id, deleted) VALUES ('3','2025-07-22 23:14:14','56564e46556c38774d513d3d','55334a706332396d64486468636d5636','54314a485155354a576b46555355394f587a45314d4455794d4449304d444d784e544935587a4178','646d39315932686c636c38794d6a41334d6a41794e5445784d5451784e4638774d773d3d','V003/25-26','2025-07-22','','5546565351306842553056665545465356466c664d5445774e7a49774d6a55784d54497a4d7a52664d44453d','533046424945465356553542513068425445464e4943416f4f5459314e544d774f4459304e436b674c53425461585a686132467a61513d3d','1','','533046424945465356553542513068425445464e49413d3d','200000','5132467a61413d3d','5547463562575675644639746232526c587a45784d4463794d4449314d5445784d444930587a417a','5130465453413d3d','','','200000','2','','0');
