<?php 
    class Payment_functions extends Basic_Functions {
      
        public function UpdateBalance($bill_id, $bill_number, $bill_date, $bill_type,$party_id, $party_name, $party_type,$payment_mode_id, $payment_mode_name,$bank_id, $bank_name, $credit, $debit, $open_balance_type,
        $payment_tax_type, $branch_id, $lr_id) {
            $query = "";
            $unique_id = "";
            $cash_balance = 0;
            $payment_type = "";

            // === Query based on bill type ===
            if (
                $bill_type == "Voucher" || $bill_type == "Expense" || $bill_type == "Suspense Voucher" ||
                $bill_type == "Suspense Receipt" || $bill_type == "Invest" || $bill_type == "Return" ||
                $bill_type == "Company"
            ) {
                $query = "SELECT id FROM " . $GLOBALS['payment_table'] . " 
                        WHERE bill_id = '$bill_id' 
                        AND payment_mode_id = '$payment_mode_id' 
                        AND bank_id = '$bank_id' 
                        AND payment_tax_type = '$payment_tax_type' 
                        AND deleted = '0'";
            } 
            else if ($bill_type == "Receipt") {
                $query = "SELECT id FROM " . $GLOBALS['payment_table'] . " 
                        WHERE bill_id = '$bill_id' 
                        AND payment_mode_id = '$payment_mode_id' 
                        AND bank_id = '$bank_id' 
                        AND payment_tax_type = '$payment_tax_type' 
                        AND lr_id = '$lr_id' 
                        AND deleted = '0'";
            } 
            else if ($party_type == "Branch") {
                $query = "SELECT id FROM " . $GLOBALS['payment_table'] . " 
                        WHERE bill_id = '$bill_id' 
                        AND payment_tax_type = '$payment_tax_type' 
                        AND deleted = '0'";
            } 
            else {
                $query = "SELECT id FROM " . $GLOBALS['payment_table'] . " 
                        WHERE bill_id = '$bill_id' 
                        AND deleted = '0'";
            }

            // === Handle branch_id ===
            if (empty($branch_id)) {
                $branch_id = $GLOBALS['null_value'];
            }

            // === Get payment type for Voucher ===
            if ($bill_type == "Voucher") {
                $payment_type = $this->getTableColumnValue(
                    $GLOBALS['voucher_table'], 'voucher_id', $bill_id, 'payment_type'
                );
            }

            $payment_tax_type = trim($payment_tax_type);

            // === Check if record exists ===
            $list = $this->getQueryRecords('', $query);
            if (!empty($list)) {
                foreach ($list as $data) {
                    if (!empty($data['id']) && $data['id'] != $GLOBALS['null_value']) {
                        $unique_id = $data['id'];
                    }
                }
            }

            // === Variables for partials & discount ===
            $is_partial = 0;
            $discount_value = 0;

            // === Handle Receipt Type ===
            if ($bill_type == "Receipt") {
                $is_partial_payment = 2;

                // Fetch LR-related arrays
                $lr_ids_str = $this->getTableColumnValue($GLOBALS['receipt_table'], 'receipt_id', $bill_id, 'lr_id');
                $is_partial_str = $this->getTableColumnValue($GLOBALS['receipt_table'], 'receipt_id', $bill_id, 'is_partial_payment');
                $discount_str = $this->getTableColumnValue($GLOBALS['receipt_table'], 'receipt_id', $bill_id, 'discount');

                // Convert to arrays
                $lr_ids = !empty($lr_ids_str) ? array_map('trim', explode(',', $lr_ids_str)) : [];
                $is_partials = !empty($is_partial_str) ? array_map('trim', explode(',', $is_partial_str)) : [];
                $discounts = !empty($discount_str) ? array_map('trim', explode(',', $discount_str)) : [];

                // Match current LR ID and get same index data
                if (!empty($lr_id) && !empty($lr_ids)) {
                    $index = array_search($lr_id, $lr_ids);
                    if ($index !== false) {
                        $is_partial = isset($is_partials[$index]) ? $is_partials[$index] : 0;
                        $discount_value = isset($discounts[$index]) ? $discounts[$index] : 0;
                    }
                }
            }

            // === LR Entry handling ===
            if ($bill_type == "LR Entry") {
                $lr_id = $bill_id;
            }
            if (empty($lr_id)) {
                $lr_id = $GLOBALS['null_value'];
            }

            // === Branch info from LR ===
            $update_from_branch = "";
            if (!empty($lr_id) && $lr_id != $GLOBALS['null_value']) {
                $update_from_branch = $this->getTableColumnValue(
                    $GLOBALS['lr_table'], 'lr_id', $lr_id, 'from_branch_id'
                );
            }

            // === Branch Opening handling ===
            if ($bill_type == 'Branch Tax Opening' || $bill_type == 'Branch Opening Balance') {
                $payment_mode_id = $this->getTableColumnValue(
                    $GLOBALS['payment_mode_table'], 'cash_balance', '1', 'payment_mode_id'
                );
            }

            // === Get cash balance ===
            if (!empty($payment_mode_id) && $payment_mode_id != $GLOBALS['null_value']) {
                $cash_balance = $this->getTableColumnValue(
                    $GLOBALS['payment_mode_table'], 'payment_mode_id', $payment_mode_id, 'cash_balance'
                );
            }

            $bill_date = date('Y-m-d', strtotime($bill_date));
            $created_date_time = $GLOBALS['create_date_time_label'];
            $creator = $GLOBALS['creator'];
            $creator_name = $GLOBALS['creator_name'];
            $bill_company_id = $GLOBALS['bill_company_id'];

            // === UPDATE EXISTING ===
            if (preg_match("/^\d+$/", $unique_id)) {
                $action = "Updated Successfully";
                $columns = array(
                    'creator_name', 'bill_company_id', 'bill_date',
                    'party_id', 'party_name', 'party_type',
                    'branch_id', 'bank_id', 'bank_name',
                    'payment_mode_id', 'payment_mode_name',
                    'open_balance_type', 'credit', 'debit',
                    'payment_tax_type', 'cash_balance',
                    'lr_id', 'payment_type', 'from_branch_id'
                );
                $values = array(
                    "'$creator_name'", "'$bill_company_id'", "'$bill_date'",
                    "'$party_id'", "'$party_name'", "'$party_type'",
                    "'$branch_id'", "'$bank_id'", "'$bank_name'",
                    "'$payment_mode_id'", "'$payment_mode_name'",
                    "'$open_balance_type'", "'$credit'", "'$debit'",
                    "'$payment_tax_type'", "'$cash_balance'",
                    "'$lr_id'", "'$payment_type'", "'$update_from_branch'"
                );
                $this->UpdateSQL($GLOBALS['payment_table'], $unique_id, $columns, $values, $action);
            } 
            // === INSERT NEW ===
            else {
                $action = "Inserted Successfully";
                $columns = array(
                    'bill_company_id', 'created_date_time', 'creator', 'creator_name',
                    'bill_id', 'bill_number', 'bill_date', 'bill_type',
                    'party_id', 'party_name', 'party_type',
                    'branch_id', 'bank_id', 'bank_name',
                    'payment_mode_id', 'payment_mode_name',
                    'open_balance_type', 'credit', 'debit',
                    'payment_tax_type', 'cash_balance',
                    'lr_id', 'payment_type', 'from_branch_id',
                    'is_partial_payment', 'discount', 'deleted'
                );
                $values = array(
                    "'$bill_company_id'", "'$created_date_time'", "'$creator'", "'$creator_name'",
                    "'$bill_id'", "'$bill_number'", "'$bill_date'", "'$bill_type'",
                    "'$party_id'", "'$party_name'", "'$party_type'",
                    "'$branch_id'", "'$bank_id'", "'$bank_name'",
                    "'$payment_mode_id'", "'$payment_mode_name'",
                    "'$open_balance_type'", "'$credit'", "'$debit'",
                    "'$payment_tax_type'", "'$cash_balance'",
                    "'$lr_id'", "'$payment_type'", "'$update_from_branch'",
                    "'$is_partial'", "'$discount_value'", "'0'"
                );
                $this->InsertSQL($GLOBALS['payment_table'], $columns, $values, $action);
            }
        }


        public function DeleteBranchPayment($bill_id, $branch_id, $payment_tax_type) {
            $select_query = ""; $list = array();
            if(!empty($branch_id) && !empty($payment_tax_type)) {
                $select_query = "SELECT id FROM ".$GLOBALS['payment_table']." WHERE bill_id = '".$bill_id."' AND branch_id = '".$branch_id."' AND payment_tax_type = '".$payment_tax_type."' AND deleted = '0'";
                $list = $this->getQueryRecords('', $select_query);
            }
            if(!empty($list)) {
                foreach($list as $data) {
                    if(!empty($data['id']) && $data['id'] != $GLOBALS['null_value']) {
                        $columns = array(); $values = array();
                        $columns = array('deleted');
                        $values = array('"1"');
                        $msg = $this->UpdateSQL($GLOBALS['payment_table'], $data['id'], $columns, $values, '');
                    }
                }
            }
        }
        public function DeletePayment($bill_id){
            $payment_bill_list = array(); $payment_unique_id = "";

            $payment_bill_list = $this->getTableRecords($GLOBALS['payment_table'], 'bill_id', $bill_id,'');
            if(!empty($payment_bill_list)){
                foreach($payment_bill_list as $value){
                    if(!empty($value['id'])){
                        $payment_unique_id = $value['id'];
                    }
                    if(preg_match("/^\d+$/", $payment_unique_id)) {
                        $action = "Payment Deleted.";
                    
                        $columns = array(); $values = array();						
                        $columns = array('deleted');
                        $values = array("'1'");
                        $msg = $this->UpdateSQL($GLOBALS['payment_table'], $payment_unique_id, $columns, $values, $action);
                    }
                }
            }
        }
        public function getPartyOpeningBalanceInPaymentExist($party_id, $bill_type) {
            $list = array(); $select_query = ""; $id = ""; $where = ""; $payment_id = "";
        
            if(!empty($party_id)){
                if(!empty($where)) {
                    $where = $where." party_id = '".$party_id."' AND ";
                }
                else {
                    $where = "party_id = '".$party_id."' AND ";
                }
            }
            if(!empty($bill_type)){
                if(!empty($where)) {
                    $where = $where." bill_type = '".$bill_type."' AND ";
                }
                else {
                    $where = "bill_type = '".$bill_type."' AND ";
                }
            }
            if(!empty($where)) {
                $select_query = "SELECT id FROM ".$GLOBALS['payment_table']." WHERE ".$where." deleted='0'";    
            }
            if(!empty($select_query)) {
                $list = $this->getQueryRecords($GLOBALS['payment_table'], $select_query);
            }
            if(!empty($list)) {
                foreach($list as $data) {
                    if(!empty($data['id']) && $data['id'] != $GLOBALS['null_value']) {
                        $payment_id = $data['id'];
                    }
                }
            }
            return $payment_id;
        }
        public function getPaymentUniqueID($bill_id, $payment_mode_id, $bank_id, $payment_tax_type) {
            $where = "";
            $select_query = "";
            $list = array();
            $unique_id = "";
            $bill_company_id = $GLOBALS['bill_company_id'];

            if (!empty($bill_company_id)) {
                $where = " bill_company_id = '" . $bill_company_id . "' AND ";
            }

            if (!empty($payment_mode_id) && $payment_mode_id != $GLOBALS['null_value']) {
                if (!empty($where)) {
                    $where = $where . " payment_mode_id = '" . $payment_mode_id . "' AND ";
                } else {
                    $where = " payment_mode_id = '" . $payment_mode_id . "' AND ";
                }
            }

            if (!empty($bank_id) && $bank_id != $GLOBALS['null_value']) {
                if (!empty($where)) {
                    $where = $where . " bank_id = '" . $bank_id . "' AND ";
                } else {
                    $where = " bank_id = '" . $bank_id . "' AND ";
                }
            }
            if (!empty($payment_tax_type) && $payment_tax_type != $GLOBALS['null_value']) {
                if (!empty($where)) {
                    $where = $where . " payment_tax_type = '" . $payment_tax_type . "' AND ";
                } else {
                    $where = " payment_tax_type = '" . $payment_tax_type . "' AND ";
                }
            }
            if (!empty($bill_id) && $bill_id != $GLOBALS['null_value']) {
                if (!empty($where)) {
                    $where = $where . " bill_id = '" . $bill_id . "' AND ";
                } else {
                    $where = " bill_id = '" . $bill_id . "' AND ";
                }
            }
        
            if (!empty($where)) {
                $select_query = "SELECT id FROM " . $GLOBALS['payment_table'] . " WHERE " . $where . " deleted = '0'";
                $list = $this->getQueryRecords('', $select_query);
            }
            if (!empty($list)) {
                foreach ($list as $data) {
                    if (!empty($data['id']) && $data['id'] != $GLOBALS['null_value']) {
                        $unique_id = $data['id'];
                    }
                }
            }

            return $unique_id;
        }
        public function PrevPaymentList($bill_unique_id) {
            $select_query = "";
            $list = array();
            $select_query = "SELECT * FROM " . $GLOBALS['payment_table'] . " WHERE bill_id = '" . $bill_unique_id . "' AND deleted = '0'";
            $list = $this->getQueryRecords('', $select_query);
            return $list;
        }
        public function DeleteCompanyOpeningBalance($organization_id,$payment_mode_id, $bank_id, $payment_tax_type) {
            $where = "";
            $select_query = "";
            $list = array();
            $unique_id = "";
            $bill_company_id = $GLOBALS['bill_company_id'];

            if (!empty($bill_company_id)) {
                $where = " bill_company_id = '" . $bill_company_id . "' AND ";
            }

            if (!empty($payment_mode_id) && $payment_mode_id != $GLOBALS['null_value']) {
                if (!empty($where)) {
                    $where = $where . " payment_mode_id = '" . $payment_mode_id . "' AND ";
                } else {
                    $where = " payment_mode_id = '" . $payment_mode_id . "' AND ";
                }
            }

            if (!empty($bank_id) && $bank_id != $GLOBALS['null_value']) {
                if (!empty($where)) {
                    $where = $where . " bank_id = '" . $bank_id . "' AND ";
                } else {
                    $where = " bank_id = '" . $bank_id . "' AND ";
                }
            }
            if (!empty($payment_tax_type) && $payment_tax_type != $GLOBALS['null_value']) {
                if (!empty($where)) {
                    $where = $where . " payment_tax_type = '" . $payment_tax_type . "' AND ";
                } else {
                    $where = " payment_tax_type = '" . $payment_tax_type . "' AND ";
                }
            }

            if (!empty($where)) {
                $select_query = "SELECT id FROM " . $GLOBALS['payment_table'] . " WHERE " . $where . " bill_type ='Voucher' AND deleted = '0'";
                $list = $this->getQueryRecords('', $select_query);
            }
            if (!empty($list)) {
                foreach ($list as $data) {
                    if (!empty($data['id']) && $data['id'] != $GLOBALS['null_value']) {
                        $unique_id = $data['id'];
                    }
                }
            }

            return $unique_id;
        }
        public function checkAvailableBalance($bill_company_id, $tax_type, $payment_mode_id, $bank_id) {
            $list = array(); $select_query = ""; $id = ""; $where = ""; $payment_id = ""; $total_credit = 0; $total_debit = 0;
            $balance = 0;
        
            if(!empty($bill_company_id)){
                if(!empty($where)) {
                    $where = $where." bill_company_id = '".$bill_company_id."' AND ";
                }
                else {
                    $where = "bill_company_id = '".$bill_company_id."' AND ";
                }
            }
            if(!empty($tax_type)){
                if(!empty($where)) {
                    $where = $where." payment_tax_type = '".$tax_type."' AND ";
                }
                else {
                    $where = "payment_tax_type = '".$tax_type."' AND ";
                }
            }
            if(!empty($payment_mode_id)){
                if(!empty($where)) {
                    $where = $where." payment_mode_id = '".$payment_mode_id."' AND ";
                }
                else {
                    $where = "payment_mode_id = '".$payment_mode_id."' AND ";
                }
            }
            if(!empty($bank_id)){
                if(!empty($where)) {
                    $where = $where." bank_id = '".$bank_id."' AND ";
                }
                else {
                    $where = "bank_id = '".$bank_id."' AND ";
                }
            }

            if(!empty($where)) {
                $select_query = "SELECT SUM(credit) as total_credit, SUM(debit) as total_debit FROM ".$GLOBALS['payment_table']." WHERE ".$where."  bill_type NOT IN ('Purchase Entry', 'LR Entry') AND deleted='0'";    
            }
            if(!empty($select_query)) {
                $list = $this->getQueryRecords($GLOBALS['payment_table'], $select_query);
            }
            if(!empty($list)) {
                foreach($list as $data) {
                    $total_credit += $data['total_credit'];
                    $total_debit += $data['total_debit']; 
                }
            }
            $balance = $total_credit - $total_debit;
            return $balance;
        }
        public function getPartyList($type) {
            $select_query = "";
            if($type == 'Purchase'){
                $select_query = "SELECT * FROM ".$GLOBALS['party_table']." WHERE party_type ='1' AND deleted ='0'";
            }
            $list = $this->getQueryRecords($GLOBALS['party_table'],$select_query);
            return $list;
        }
        public function getVoucherList($from_date, $to_date, $show_bill, $filter_party_id) {
            $list = array(); $select_query = ""; $where = "";

            if(!empty($filter_party_id)) {
                $where = "party_id = '" . $filter_party_id . "'";
            }

            if(!empty($from_date)) {
                $from_date = date("Y-m-d", strtotime($from_date));
                if(!empty($where)) {
                    $where = $where . " AND voucher_date >= '" . $from_date . "'";
                } else {
                    $where = "voucher_date >= '" . $from_date . "'";
                }
            }

            if(!empty($to_date)) {
                $to_date = date("Y-m-d", strtotime($to_date));
                if(!empty($where)) {
                    $where = $where . " AND voucher_date <= '" . $to_date . "'";
                } else {
                    $where = "voucher_date <= '" . $to_date . "'";
                }
            }

            if($show_bill == '0' || $show_bill == '1') {
                if(!empty($where)) {
                    $where = $where . " AND deleted = '" . $show_bill . "' ";
                } else {
                    $where = "deleted = '" . $show_bill . "' ";
                }
            }

            if(!empty($where)) {
                $select_query = "SELECT * FROM " . $GLOBALS['voucher_table'] . " WHERE " . $where . " ORDER BY id DESC";
            } 
            else {
                $select_query = "SELECT * FROM " . $GLOBALS['voucher_table'] . " WHERE deleted = '0' ORDER BY id DESC";
            }
            if(!empty($select_query)) {
                $list = $this->getQueryRecords($GLOBALS['voucher_table'], $select_query);
            }
            return $list;
        }
        public function GetPaymentAmountoldd($payment_tax_type,$payment_mode_id, $bank_id, $login_branch_id) {
            $list = array(); $select_query = ""; $where = "";$credit = 0;$debit =0;$total_amount =0; $cash_balance = 0;


                    // print_r($login_branch_id)
            // if(!empty($login_branch_id)){
            //     // if(is_array($login_branch_id)) {
			// 		for($i=0; $i < count($login_branch_id); $i++) {

            //             if(!empty($where)) {
            //                 $where = $where . " OR branch_id = '" . $login_branch_id[$i] . "'";
            //             } else {
            //                 $where = "branch_id = '" . $login_branch_id[$i] . "'";
            //             }
            //         }
            //     // }
            // }else{
            //     if(!empty($where)) {
            //         $where = $where . " AND branch_id = '" . $GLOBALS['null_value'] . "'";
            //     } else {
            //         $where = "branch_id = '" . $GLOBALS['null_value'] . "'";
            //     }
            // }

            if (!empty($login_branch_id)) {
                if (is_array($login_branch_id)) {
                    $branch_ids = array_map(function($id) {
                        return "'" . addslashes($id) . "'";
                    }, $login_branch_id);
                    $branch_list = implode(",", $branch_ids);
                    $where .= (!empty($where) ? " AND " : "") . "branch_id IN ($branch_list)";
                } else {
                    $branch_id = addslashes($login_branch_id);
                    $where .= (!empty($where) ? " AND " : "") . "branch_id = '" . $branch_id . "'";
                }
            }

            if(!empty($payment_tax_type) && $payment_tax_type != $GLOBALS['null_value']) {
                if(!empty($where)) {
                    $where = $where . " AND payment_tax_type = '" . $payment_tax_type . "'";
                } else {
                    $where = "payment_tax_type = '" . $payment_tax_type . "'";
                }
            }
        
            if(!empty($payment_mode_id) && $payment_mode_id != $GLOBALS['null_value']) {
                $cash_balance = $this->getTableColumnValue($GLOBALS['payment_mode_table'],'payment_mode_id',$payment_mode_id,'cash_balance');

                    if(!empty($where)) {
                        $where = $where . " AND payment_mode_id = '" . $payment_mode_id . "'";
                    } else {
                        $where = "payment_mode_id = '" . $payment_mode_id . "'";
                    }
                
                if(!empty($cash_balance) && $cash_balance != $GLOBALS['null_value']){
                    if(!empty($where)) {
                        $where = $where . " AND cash_balance = '" . $cash_balance . "'";
                    } else {
                        $where = "cash_balance = '" . $cash_balance . "'";
                    }
                }

            }

            if(!empty($bank_id) && $bank_id != $GLOBALS['null_value']) {
                if(!empty($where)) {
                    $where = $where . " AND bank_id = '" . $bank_id . "'";
                } else {
                    $where = "bank_id = '" . $bank_id . "'";
                }
            }
    
            if(!empty($where)) {
                $select_query = "SELECT * FROM " . $GLOBALS['payment_table'] . " WHERE " . $where . "  AND deleted ='0' ";
            } else {
                $select_query = "SELECT * FROM " . $GLOBALS['payment_table'] . " WHERE deleted ='0' ";
            }
            
            // echo $select_query;
            if(!empty($select_query)) {
                $list = $this->getQueryRecords($GLOBALS['payment_table'], $select_query);
                if(!empty($list)) {
                    foreach($list as $data) {
                        if(!empty($data['credit'])) {
                            $credit += (float)$data['credit'];
                        }
                        if(!empty($data['debit'])) {
                            $debit += (float)$data['debit'];
                        }
                        $total_amount = ($credit - $debit);
                    }
                }
            }
            return $total_amount;
        }


        public function GetPaymentAmount($payment_tax_type,$payment_mode_id, $bank_id, $login_branch_id) {
            $list = array(); $select_query = ""; $where = "";$credit = 0;$debit =0;$total_amount =0; $cash_balance = 0;


                    // print_r($login_branch_id)
            // if(!empty($login_branch_id)){
            //     // if(is_array($login_branch_id)) {
			// 		for($i=0; $i < count($login_branch_id); $i++) {

            //             if(!empty($where)) {
            //                 $where = $where . " OR branch_id = '" . $login_branch_id[$i] . "'";
            //             } else {
            //                 $where = "branch_id = '" . $login_branch_id[$i] . "'";
            //             }
            //         }
            //     // }
            // }else{
            //     if(!empty($where)) {
            //         $where = $where . " AND branch_id = '" . $GLOBALS['null_value'] . "'";
            //     } else {
            //         $where = "branch_id = '" . $GLOBALS['null_value'] . "'";
            //     }
            // }

            if (!empty($login_branch_id)) {
                if (is_array($login_branch_id)) {
                    $branch_ids = array_map(function($id) {
                        return "'" . addslashes($id) . "'";
                    }, $login_branch_id);
                    $branch_list = implode(",", $branch_ids);
                    $where .= (!empty($where) ? " AND " : "") . "branch_id IN ($branch_list)";
                } else {
                    $branch_id = addslashes($login_branch_id);
                    $where .= (!empty($where) ? " AND " : "") . "branch_id = '" . $branch_id . "'";
                }
            }

            if(!empty($payment_tax_type) && $payment_tax_type != $GLOBALS['null_value']) {
                if(!empty($where)) {
                    $where = $where . " AND payment_tax_type = '" . $payment_tax_type . "'";
                } else {
                    $where = "payment_tax_type = '" . $payment_tax_type . "'";
                }
            }
        
            if(!empty($payment_mode_id) && $payment_mode_id != $GLOBALS['null_value']) {
                $cash_balance = $this->getTableColumnValue($GLOBALS['payment_mode_table'],'payment_mode_id',$payment_mode_id,'cash_balance');

                    if(!empty($where)) {
                        $where = $where . " AND payment_mode_id = '" . $payment_mode_id . "'";
                    } else {
                        $where = "payment_mode_id = '" . $payment_mode_id . "'";
                    }
                
                if(!empty($cash_balance) && $cash_balance != $GLOBALS['null_value']){
                    if(!empty($where)) {
                        $where = $where . " AND cash_balance = '" . $cash_balance . "' ";
                    } else {
                        $where = "cash_balance = '" . $cash_balance . "'";
                    }
                    if(empty($login_branch_id)){
                        if(!empty($cash_balance) && $cash_balance == 1){
                            if(!empty($where)) {
                                $where .= " AND branch_id = '".$GLOBALS['null_value']."' ";
                            } else {
                                $where = " = '".$GLOBALS['null_value']."' ";
                            }
                        }
                    }
                }

            }
            // echo $GLOBALS['admin_user_type'];

            if(!empty($bank_id) && $bank_id != $GLOBALS['null_value']) {
                if(!empty($where)) {
                    $where = $where . " AND bank_id = '" . $bank_id . "'";
                } else {
                    $where = "bank_id = '" . $bank_id . "'";
                }
            }
    
            if(!empty($where)) {
               $select_query = "SELECT * FROM " . $GLOBALS['payment_table'] . " WHERE " . $where . " AND deleted ='0' ";
            } else {
                $select_query = "SELECT * FROM " . $GLOBALS['payment_table'] . " WHERE deleted ='0' ";
            }
            
            // echo $select_query;
            if(!empty($select_query)) {
                $list = $this->getQueryRecords($GLOBALS['payment_table'], $select_query);
                if(!empty($list)) {
                    foreach($list as $data) {
                        if(!empty($data['credit'])) {
                            $credit += (float)$data['credit'];
                        }
                        if(!empty($data['debit'])) {
                            $debit += (float)$data['debit'];
                        }
                        $total_amount = ($credit - $debit);
                    }
                }
            }
            return $total_amount;
        }
        public function getPendingList($party_id) {
            $select_query = ""; $list = array();
            if(!empty($party_id)) {
                
                $select_query = "SELECT * FROM " . $GLOBALS['payment_table'] . " WHERE (party_id = '" . $party_id . "') AND deleted = '0' ORDER BY bill_date ASC";
                
                $list = $this->getQueryRecords($GLOBALS['payment_table'], $select_query);
            }
            return $list;
        }
        public function getReceiptList($from_date, $to_date, $show_bill, $filter_party_id, $filter_lr_id, $login_branch_id) {
            
            $list = array(); $select_query = ""; $where = "";

            if(!empty($filter_party_id)) {
                $where = "party_id = '" . $filter_party_id . "'";
            }
       
            if(!empty($filter_lr_id) && $filter_lr_id != $GLOBALS['null_value']) {
                if(!empty($where)) {
                    $where = $where . " AND lr_id = '" . $filter_lr_id . "'";
                } else {
                    $where = "lr_id = '" . $filter_lr_id . "'";
                }
            }
    
            if(!empty($login_branch_id)) {
                $creator_name = $GLOBALS['creator_name'];
                $creator_name = $this->encode_decode('encrypt',$creator_name);
                
                if(!empty($creator_name) && $creator_name != $GLOBALS['null_value']) {
                    if(!empty($where)) {
                        $where = $where . " AND creator_name = '" . $creator_name . "'";
                    } else {
                        $where = "creator_name = '" . $creator_name . "'";
                    }
                }
            }

            if(!empty($from_date)) {
                $from_date = date("Y-m-d", strtotime($from_date));
                if(!empty($where)) {
                    $where = $where . " AND receipt_date >= '" . $from_date . "'";
                } else {
                    $where = "receipt_date >= '" . $from_date . "'";
                }
            }

            if(!empty($to_date)) {
                $to_date = date("Y-m-d", strtotime($to_date));
                if(!empty($where)) {
                    $where = $where . " AND receipt_date <= '" . $to_date . "'";
                } else {
                    $where = "receipt_date <= '" . $to_date . "'";
                }
            }

            if($show_bill == '0' || $show_bill == '1') {
                if(!empty($where)) {
                    $where = $where . " AND deleted = '" . $show_bill . "' ";
                } else {
                    $where = "deleted = '" . $show_bill . "' ";
                }
            }



            if(!empty($where)) {
                $select_query = "SELECT * FROM " . $GLOBALS['receipt_table'] . " WHERE " . $where . " ORDER BY id DESC";
            } 
            else {
                $select_query = "SELECT * FROM " . $GLOBALS['receipt_table'] . " WHERE deleted = '0' ORDER BY id DESC";
            }
            if(!empty($select_query)) {
                $list = $this->getQueryRecords($GLOBALS['receipt_table'], $select_query);
            }
            return $list;
        }
        public function getExpenseList($from_date, $to_date, $show_bill, $filter_expense_category_id) {
            $list = array(); $select_query = ""; $where = "";

            if(!empty($filter_expense_category_id)) {
                $where = "expense_category_id = '" . $filter_expense_category_id . "'";
            }

            if(!empty($from_date)) {
                $from_date = date("Y-m-d", strtotime($from_date));
                if(!empty($where)) {
                    $where = $where . " AND expense_date >= '" . $from_date . "'";
                } else {
                    $where = "expense_date >= '" . $from_date . "'";
                }
            }
        
            if(!empty($to_date)) {
                $to_date = date("Y-m-d", strtotime($to_date));
                if(!empty($where)) {
                    $where = $where . " AND expense_date <= '" . $to_date . "'";
                } else {
                    $where = "expense_date <= '" . $to_date . "'";
                }
            }

            if($show_bill == '0' || $show_bill == '1') {
                if(!empty($where)) {
                    $where = $where . " AND deleted = '" . $show_bill . "' ";
                } else {
                    $where = "deleted = '" . $show_bill . "' ";
                }
            }

            if(!empty($where)) {
                $select_query = "SELECT * FROM " . $GLOBALS['expense_table'] . " WHERE " . $where . " ORDER BY id DESC";
            } 
            else {
                $select_query = "SELECT * FROM " . $GLOBALS['expense_table'] . " WHERE deleted = '0' ORDER BY id DESC";
            }
            if(!empty($select_query)) {
                $list = $this->getQueryRecords($GLOBALS['expense_table'], $select_query);
            }
            return $list;
        }
        public function getSuspenseVoucherList($from_date, $to_date, $show_bill, $filter_party_id) {
            $list = array(); $select_query = ""; $where = "";

            if(!empty($filter_party_id)) {
                $where = "suspense_party_id = '" . $filter_party_id . "'";
            }

            if(!empty($from_date)) {
                $from_date = date("Y-m-d", strtotime($from_date));
                if(!empty($where)) {
                    $where = $where . " AND suspense_voucher_date >= '" . $from_date . "'";
                } else {
                    $where = "suspense_voucher_date >= '" . $from_date . "'";
                }
            }

            if(!empty($to_date)) {
                $to_date = date("Y-m-d", strtotime($to_date));
                if(!empty($where)) {
                    $where = $where . " AND suspense_voucher_date <= '" . $to_date . "'";
                } else {
                    $where = "suspense_voucher_date <= '" . $to_date . "'";
                }
            }

            if($show_bill == '0' || $show_bill == '1') {
                if(!empty($where)) {
                    $where = $where . " AND deleted = '" . $show_bill . "' ";
                } else {
                    $where = "deleted = '" . $show_bill . "' ";
                }
            }

            if(!empty($where)) {
                $select_query = "SELECT * FROM " . $GLOBALS['suspense_voucher_table'] . " WHERE " . $where . " ORDER BY id DESC";
            } 
            else {
                $select_query = "SELECT * FROM " . $GLOBALS['suspense_voucher_table'] . " WHERE deleted = '0' ORDER BY id DESC";
            }
            // echo $select_query;
            if(!empty($select_query)) {
                $list = $this->getQueryRecords($GLOBALS['suspense_voucher_table'], $select_query);
            }
            return $list;
        }
        public function getSuspensePartyList() {
            $select_query = "";
            $select_query = "SELECT * FROM ".$GLOBALS['suspense_party_table']." WHERE deleted ='0'";
            
            $list = $this->getQueryRecords($GLOBALS['suspense_party_table'],$select_query);
            return $list;
        }
        public function getSuspenseReceiptList($from_date, $to_date, $show_bill, $filter_party_id) {
            $list = array(); $select_query = ""; $where = "";

            if(!empty($filter_party_id)) {
                $where = "suspense_party_id = '" . $filter_party_id . "'";
            }

            if(!empty($from_date)) {
                $from_date = date("Y-m-d", strtotime($from_date));
                if(!empty($where)) {
                    $where = $where . " AND suspense_receipt_date >= '" . $from_date . "'";
                } else {
                    $where = "suspense_receipt_date >= '" . $from_date . "'";
                }
            }

            if(!empty($to_date)) {
                $to_date = date("Y-m-d", strtotime($to_date));
                if(!empty($where)) {
                    $where = $where . " AND suspense_receipt_date <= '" . $to_date . "'";
                } else {
                    $where = "suspense_receipt_date <= '" . $to_date . "'";
                }
            }

            if($show_bill == '0' || $show_bill == '1') {
                if(!empty($where)) {
                    $where = $where . " AND deleted = '" . $show_bill . "' ";
                } else {
                    $where = "deleted = '" . $show_bill . "' ";
                }
            }

            if(!empty($where)) {
                $select_query = "SELECT * FROM " . $GLOBALS['suspense_receipt_table'] . " WHERE " . $where . " ORDER BY id DESC";
            } 
            else {
                $select_query = "SELECT * FROM " . $GLOBALS['suspense_receipt_table'] . " WHERE deleted = '0' ORDER BY id DESC";
            }
            // echo $select_query;
            if(!empty($select_query)) {
                $list = $this->getQueryRecords($GLOBALS['suspense_receipt_table'], $select_query);
            }
            return $list;
        }
        public function getPaymentPartyList($bill_type) {
            $list = array(); $select_query = ""; $where = ""; 
        
            if($bill_type == 1) {
                $bill_type = "Voucher";
            }
            if($bill_type == 2) {
                $bill_type = "Receipt";
            }
            if($bill_type == 3) {
                $bill_type = "Expense";
            }
            if(!empty($bill_type)){
                if(!empty($where)) {
                    $where .= " bill_type = '" . $bill_type . "' AND";
                } else {
                    $where = " bill_type = '" . $bill_type . "' AND";
                }
            }
            
            if(!empty($where)) {
                $select_query = "SELECT * FROM " . $GLOBALS['payment_table'] . "  WHERE " . $where . " party_type NOT IN ('Branch','Company','Expense Category','Branch Opening Balance','Branch Tax Opening') AND deleted = '0' GROUP BY party_id ORDER BY created_date_time ASC ";
            } else {
                $select_query = "SELECT * FROM " . $GLOBALS['payment_table'] . "  WHERE party_type NOT IN ('Branch','Company','Expense Category','Branch Opening Balance','Branch Tax Opening') AND deleted = '0' GROUP BY party_id ORDER BY created_date_time ASC";
            }

            if(!empty($select_query)) {
                $list = $this->getQueryRecords('', $select_query);
            }
            // print_r($list);
            return $list;
        }
        public function getPaymentReportList($from_date,$to_date,$filter_bill_type,$filter_party_id,$payment_mode_id,$bank_id,$filter_category_id,$filter_driver_id){
            $reports = array();
            $where ="";
            $branch_id = ""; $login_branch_id = array();
            if(!empty($_SESSION[$GLOBALS['site_name_user_prefix'].'_user_id']) && isset($_SESSION[$GLOBALS['site_name_user_prefix'].'_user_id'])) {
                $is_branch_staff = $this->getTableColumnValue($GLOBALS['user_table'], 'user_id', $_SESSION[$GLOBALS['site_name_user_prefix'].'_user_id'], 'is_branch_staff');
                if($is_branch_staff == "yes") {
                    $branch_id = $this->getTableColumnValue($GLOBALS['user_table'], 'user_id', $_SESSION[$GLOBALS['site_name_user_prefix'].'_user_id'], 'branch_id');

					if(!empty($branch_id) && $branch_id != $GLOBALS['null_value']) {
						$login_branch_id = explode(",", $branch_id);
					}
					if (is_array($login_branch_id)) {
						$branch_ids = array_map(function($id) {
							return "'" . addslashes($id) . "'";
						}, $login_branch_id);
						$branch_list = implode(",", $branch_ids);
						$where .= "branch_id IN ($branch_list) ";
					} else {
						$branch_id = addslashes($login_branch_id);
						$where .= "branch_id = '" . $branch_id . "'  ";
					}
                }
            }

            if(!empty($from_date)) {
                $from_date = date("Y-m-d", strtotime($from_date));
                if(!empty($where)) {
                    $where = $where . " AND bill_date >= '" . $from_date . "'";
                } else {
                    $where = "bill_date >= '" . $from_date . "'";
                }
            }
            if(!empty($to_date)) {
                $to_date = date("Y-m-d", strtotime($to_date));
                if(!empty($where)) {
                    $where = $where . " AND bill_date <= '" . $to_date . "'";
                } else {
                    $where = "bill_date <= '" . $to_date . "'";
                }
            }

            if(!empty($filter_party_id)){ 
                if(!empty($where)) {
                    $where = $where . " AND party_id = '" . $filter_party_id . "' ";
                } else {
                    $where = "party_id = '" . $filter_party_id . "'";
                }
            }

            if(!empty($filter_category_id)){ 
                if(!empty($where)) {
                    $where = $where . " AND party_id = '" . $filter_category_id . "' ";
                } else {
                    $where = "party_id = '" . $filter_category_id . "'";
                }
            }

            if(!empty($filter_driver_id)){ 
                if(!empty($where)) {
                    $where = $where . " AND party_id = '" . $filter_driver_id . "' ";
                } else {
                    $where = "party_id = '" . $filter_driver_id . "'";
                }
            }
            
            if(!empty($bank_id)){ 
                if(!empty($where)) {
                    $where = $where . " AND bank_id = '" . $bank_id . "' ";
                } else {
                    $where = "bank_id = '" . $bank_id . "'";
                }
            }

            if(!empty($payment_mode_id)){ 
                if(!empty($where)) {
                    $where = $where . " AND payment_mode_id = '" . $payment_mode_id . "' ";
                } else {
                    $where = "payment_mode_id = '" . $payment_mode_id . "'";
                }
            }

            if($filter_bill_type == 1) {
                if(!empty($where)) {
                    $select_query = "SELECT * FROM " . $GLOBALS['payment_table'] . " WHERE " . $where . " AND bill_type = 'Voucher' AND deleted = '0' ORDER BY bill_date ASC";
                } else {
                    $select_query = "SELECT * FROM " . $GLOBALS['payment_table'] . " WHERE bill_type = 'Voucher' AND deleted = '0' ORDER BY bill_date ASC";
                }
            } else if($filter_bill_type == 2) {
                if(!empty($where)) {
                    $select_query = "SELECT * FROM " . $GLOBALS['payment_table'] . " WHERE " . $where . " AND bill_type = 'Receipt' AND deleted = '0' ORDER BY bill_date ASC"; 	
                } else {
                    $select_query = "SELECT * FROM " . $GLOBALS['payment_table'] . " WHERE bill_type = 'Receipt' AND deleted = '0' ORDER BY bill_date ASC"; 	
                }
            } else if($filter_bill_type == 3) {
                if(!empty($where)) {
                    $select_query = "SELECT * FROM " . $GLOBALS['payment_table'] . " WHERE " . $where . " AND bill_type = 'Expense' AND deleted = '0' ORDER BY bill_date ASC"; 	
                } else {
                    $select_query = "SELECT * FROM " . $GLOBALS['payment_table'] . " WHERE bill_type = 'Expense' AND deleted = '0' ORDER BY bill_date ASC"; 	
                }
            } else {
                if(!empty($where)) {
                    $select_query = "SELECT * FROM " . $GLOBALS['payment_table'] . " WHERE " . $where . " AND  bill_type IN ('voucher', 'expense', 'receipt')  AND deleted = '0' ORDER BY bill_date ASC";
                } else {
                    $select_query = "SELECT * FROM " . $GLOBALS['payment_table'] . " WHERE  bill_type IN ('voucher', 'expense', 'receipt')  AND deleted = '0' ORDER BY bill_date ASC";
                }
            }
            // echo $select_query;
            $reports = $this->getQueryRecords('', $select_query);
            return $reports;
        }
        public function GetLRNumberList($party_type, $party_id, $bill_type, $login_branch_id){
            $list = array(); $select_query = ""; $party_field_name = ""; $lr_number_list =array();

            if($party_type == 'consignor'){
                $party_field_name = 'consignor_id';
            }else if($party_type == 'consignee'){
                    $party_field_name = 'consignee_id';
            }else{
              $party_field_name = 'account_party_id';
                $bill_type = 'Account Party';
            }
            $where ="";
            if(!empty($party_id)){ 
                if(!empty($where)) {
                    $where = $where . " AND ".$party_field_name." = '" . $party_id . "' ";
                } else {
                    $where = " ".$party_field_name." = '" . $party_id . "'";
                }
            }
           
            if ($party_type == 'consignor' && !empty($login_branch_id)) {
                if (is_array($login_branch_id)) {
                    $branch_ids = array_map(function($id) {
                        return "'" . addslashes($id) . "'";
                    }, $login_branch_id);
                    $branch_list = implode(",", $branch_ids);
                    $where .= (!empty($where) ? " AND " : "") . "from_branch_id IN ($branch_list)";
                } else {
                    $branch_id = addslashes($login_branch_id);
                    $where .= (!empty($where) ? " AND " : "") . "from_branch_id = '" . $branch_id . "'";
                }
            }


            if(!empty($bill_type)){ 
                if(!empty($where)) {
                    $where = $where . " AND bill_type = '" . $bill_type . "' ";
                } else {
                    $where = "bill_type = '" . $bill_type . "'";
                }
            }

            if(!empty($where)) {
                $select_query = "SELECT * FROM " . $GLOBALS['lr_table'] . " WHERE " . $where . " AND  deleted = '0' ORDER BY lr_date DESC";
            } else {
                $select_query = "SELECT * FROM " . $GLOBALS['lr_table'] . " WHERE deleted = '0' ORDER BY lr_date DESC";
            }
            $lr_list = $this->getQueryRecords('', $select_query);

            $lr_number_list = [];


            $not_paid_list = [];
            $half_paid_list = [];

            if (!empty($lr_list)) {
                foreach ($lr_list as $data) {
                    if (!empty($data['lr_id'])) {
                        $lr_id = $data['lr_id'];

                        // Check if this LR has any partial payment (is_partial_payment = 1)
                        $check_partial_query = "
                            SELECT COUNT(*) AS cnt 
                            FROM " . $GLOBALS['payment_table'] . "
                            WHERE lr_id = '" . addslashes($lr_id) . "'
                            AND deleted = '0'
                        ";
                        $check_partial_result = $this->getQueryRecords('', $check_partial_query);

                        // If partial payment exists, skip this LR completely
                        // if (!empty($check_partial_result[0]['cnt']) && $check_partial_result[0]['cnt'] > 0) {
                        //     continue;
                        // }

                        // Now calculate normal payments
                        $payment_query = "
                            SELECT 
                                IFNULL(SUM(credit), 0) AS credit, 
                                IFNULL(SUM(debit), 0) AS debit
                            FROM " . $GLOBALS['payment_table'] . "
                            WHERE lr_id = '" . addslashes($lr_id) . "'
                            AND deleted = '0'
                            GROUP BY lr_id
                        ";
                        
                        $payment_result = $this->getQueryRecords('', $payment_query);

                        $credit = 0;
                        $debit  = 0;

                        if (!empty($payment_result)) {
                            $credit = (float)$payment_result[0]['credit'];
                            $debit  = (float)$payment_result[0]['debit'];
                        }

                        $pending_balance = $debit - $credit;

                        // echo $credit."hello".$debit;
                        // Not Paid
                        if ($credit == 0 && $debit > 0) {
                            $not_paid_list[] = [
                                'lr_id' => $lr_id,
                                'pending_amount' => $pending_balance,
                                'status' => 'Not Paid'
                            ];
                        }
                        // Half Paid
                        else if ($credit > 0 && $credit < $debit) {
                            $half_paid_list[] = [
                                'lr_id' => $lr_id,
                                'pending_amount' => $pending_balance,
                                'status' => 'Half Paid'
                            ];
                        }
                    }
                }
            }

            $lr_number_list = array_merge($not_paid_list, $half_paid_list);
            return $lr_number_list;

        }
        
        public function CheckBalanceForReceiptRestriction($receipt_id){
            $receipt_details = array(); $bank_ids = array(); $amount = array(); $payment_tax_types = array();
            $where = ""; $balance =0; $allow_delete = 0; $payment_mode_ids = array(); $total_credit = 0; $total_debit = 0;
            $select_query = "";
            $list = array();
            $unique_id = "";
            $receipt_details = $this->getTableRecords($GLOBALS['receipt_table'],'receipt_id',$receipt_id);
            if(!empty($receipt_details)){
                foreach($receipt_details as $data){
                    if(!empty($data['payment_mode_id'])){
                        $payment_mode_ids = explode(',',$data['payment_mode_id']);
                    }
                    if(!empty($data['bank_id'])){
                        $bank_ids = explode(',',$data['bank_id']);
                    }
                    if(!empty($data['amount'])){
                        $amount = explode(',',$data['amount']);
                    }
                    if(!empty($data['payment_tax_type'])){
                        $payment_tax_types = explode(',',$data['payment_tax_type']);
                    }
                }
            }
            if(!empty($payment_mode_ids)){

                for($i=0; $i < count($payment_mode_ids); $i++) {
                    $payment_mode_ids[$i] = trim($payment_mode_ids[$i]);
                    $payment_tax_types[$i] = trim($payment_tax_types[$i]);
                    
                    if (!empty($bank_ids[$i]) && $bank_ids[$i] != $GLOBALS['null_value']) {

                    $bank_ids[$i] = trim($bank_ids[$i]);
                    }
                
                    $amount[$i] = trim($amount[$i]);
            
                    $bill_company_id = $GLOBALS['bill_company_id'];

                    if (!empty($bill_company_id)) {
                        $where = " bill_company_id = '" . $bill_company_id . "' AND ";
                    }

                    if (!empty($payment_mode_ids[$i]) && $payment_mode_ids[$i] != $GLOBALS['null_value']) {
                        if (!empty($where)) {
                            $where = $where . " payment_mode_id = '" . $payment_mode_ids[$i] . "' AND ";
                        } else {
                            $where = " payment_mode_id = '" . $payment_mode_ids[$i] . "' AND ";
                        }
                    }

                    if (!empty($receipt_id) && $receipt_id != $GLOBALS['null_value']) {
                        if (!empty($where)) {
                            $where = $where . " bill_id != '" . $receipt_id . "' AND ";
                        } else {
                            $where = " bill_id != '" . $receipt_id . "' AND ";
                        }
                    }

                    if (!empty($bank_ids[$i]) && $bank_ids[$i] != $GLOBALS['null_value']) {
                        if (!empty($where)) {
                            $where = $where . " bank_id = '" . $bank_ids[$i] . "' AND ";
                        } else {
                            $where = " bank_id = '" . $bank_ids[$i] . "' AND ";
                        }
                    }
                    if (!empty($payment_tax_types[$i]) && $payment_tax_types[$i] != $GLOBALS['null_value']) {
                        if (!empty($where)) {
                            $where = $where . " payment_tax_type = '" . $payment_tax_types[$i] . "' AND ";
                        } else {
                            $where = " payment_tax_type = '" . $payment_tax_types[$i] . "' AND ";
                        }
                    }

                    if(!empty($where)) {
                        $select_query = "SELECT SUM(credit) as total_credit, SUM(debit) as total_debit FROM ".$GLOBALS['payment_table']." WHERE ".$where."  bill_type NOT IN ('Purchase Entry', 'LR Entry') AND deleted='0'";    
                    }
                    if(!empty($select_query)) {
                        $list = $this->getQueryRecords($GLOBALS['payment_table'], $select_query);
                    }
                    if(!empty($list)) {
                        foreach($list as $data) {
                            $total_credit += $data['total_credit'];
                            $total_debit += $data['total_debit']; 
                        }
                    }
                    $balance = $total_credit - $total_debit;
                    if ($balance < 0) {
                        $allow_delete = 1;
                    }
                
                }
            }
            return $allow_delete;

        }

        public function CheckBalanceForInvestRestriction($invest_id){
            $invest_details = array(); $bank_ids = array(); $amount = array(); $payment_tax_types = array();
            $where = ""; $balance =0; $allow_delete = 0; $payment_mode_ids = array(); $total_credit = 0; $total_debit = 0;
            $select_query = "";
            $list = array();
            $unique_id = "";
            $invest_details = $this->getTableRecords($GLOBALS['invest_table'],'invest_id',$invest_id);
            if(!empty($invest_details)){
                foreach($invest_details as $data){
                    if(!empty($data['payment_mode_id'])){
                        $payment_mode_ids = explode(',',$data['payment_mode_id']);
                    }
                    if(!empty($data['bank_id'])){
                        $bank_ids = explode(',',$data['bank_id']);
                    }
                    if(!empty($data['amount'])){
                        $amount = explode(',',$data['amount']);
                    }
                    if(!empty($data['payment_tax_type'])){
                        $payment_tax_types = explode(',',$data['payment_tax_type']);
                    }
                }
            }
            if(!empty($payment_mode_ids)){
                for($i=0; $i < count($payment_mode_ids); $i++) {
                    $payment_mode_ids[$i] = trim($payment_mode_ids[$i]);
                    $payment_tax_types[$i] = trim($payment_tax_types[$i]);
                    
                    if (!empty($bank_ids[$i]) && $bank_ids[$i] != $GLOBALS['null_value']) {

                    $bank_ids[$i] = trim($bank_ids[$i]);
                    }
                
                    $amount[$i] = trim($amount[$i]);
            
                    $bill_company_id = $GLOBALS['bill_company_id'];

                    if (!empty($bill_company_id)) {
                        $where = " bill_company_id = '" . $bill_company_id . "' AND ";
                    }

                    if (!empty($payment_mode_ids[$i]) && $payment_mode_ids[$i] != $GLOBALS['null_value']) {
                        if (!empty($where)) {
                            $where = $where . " payment_mode_id = '" . $payment_mode_ids[$i] . "' AND ";
                        } else {
                            $where = " payment_mode_id = '" . $payment_mode_ids[$i] . "' AND ";
                        }
                    }

                    if (!empty($invest_id) && $invest_id != $GLOBALS['null_value']) {
                        if (!empty($where)) {
                            $where = $where . " bill_id != '" . $invest_id . "' AND ";
                        } else {
                            $where = " bill_id != '" . $invest_id . "' AND ";
                        }
                    }

                    if (!empty($bank_ids[$i]) && $bank_ids[$i] != $GLOBALS['null_value']) {
                        if (!empty($where)) {
                            $where = $where . " bank_id = '" . $bank_ids[$i] . "' AND ";
                        } else {
                            $where = " bank_id = '" . $bank_ids[$i] . "' AND ";
                        }
                    }
                    if (!empty($payment_tax_types[$i]) && $payment_tax_types[$i] != $GLOBALS['null_value']) {
                        if (!empty($where)) {
                            $where = $where . " payment_tax_type = '" . $payment_tax_types[$i] . "' AND ";
                        } else {
                            $where = " payment_tax_type = '" . $payment_tax_types[$i] . "' AND ";
                        }
                    }

                    if(!empty($where)) {
                        $select_query = "SELECT SUM(credit) as total_credit, SUM(debit) as total_debit FROM ".$GLOBALS['payment_table']." WHERE ".$where."  bill_type NOT IN ('Purchase Entry', 'LR Entry') AND deleted='0'";    
                    }
                    if(!empty($select_query)) {
                        $list = $this->getQueryRecords($GLOBALS['payment_table'], $select_query);
                    }
                    if(!empty($list)) {
                        foreach($list as $data) {
                            $total_credit += $data['total_credit'];
                            $total_debit += $data['total_debit']; 
                        }
                    }
                    $balance = $total_credit - $total_debit;
                    if ($balance < 0) {
                        $allow_delete = 1;
                    }
                
                }
            }
            return $allow_delete;
        }
        public function getinvestList($bill_company_id,$from_date, $to_date, $show_bill) {
            $list = array(); $select_query = ""; $where = "";

            if(!empty($filter_party_id)) {
                $where = "party_id = '" . $filter_party_id . "'";
            }

            if(!empty($from_date)) {
                $from_date = date("Y-m-d", strtotime($from_date));
                if(!empty($where)) {
                    $where = $where . " AND invest_date >= '" . $from_date . "'";
                } else {
                    $where = "invest_date >= '" . $from_date . "'";
                }
            }

            if(!empty($to_date)) {
                $to_date = date("Y-m-d", strtotime($to_date));
                if(!empty($where)) {
                    $where = $where . " AND invest_date <= '" . $to_date . "'";
                } else {
                    $where = "invest_date <= '" . $to_date . "'";
                }
            }

            if($show_bill == '0' || $show_bill == '1') {
                if(!empty($where)) {
                    $where = $where . " AND deleted = '" . $show_bill . "' ";
                } else {
                    $where = "deleted = '" . $show_bill . "' ";
                }
            }

            if(!empty($where)) {
                $select_query = "SELECT * FROM " . $GLOBALS['invest_table'] . " WHERE " . $where . " ORDER BY id DESC";
            } 
            else {
                $select_query = "SELECT * FROM " . $GLOBALS['invest_table'] . " WHERE deleted = '0' ORDER BY id DESC";
            }
            if(!empty($select_query)) {
                $list = $this->getQueryRecords($GLOBALS['invest_table'], $select_query);
            }
            return $list;
        }
        public function getReturnList($bill_company_id,$from_date, $to_date, $show_bill) {
            $list = array(); $select_query = ""; $where = "";

            if(!empty($from_date)) {
                $from_date = date("Y-m-d", strtotime($from_date));
                if(!empty($where)) {
                    $where = $where . " AND return_date >= '" . $from_date . "'";
                } else {
                    $where = "return_date >= '" . $from_date . "'";
                }
            }

            if(!empty($to_date)) {
                $to_date = date("Y-m-d", strtotime($to_date));
                if(!empty($where)) {
                    $where = $where . " AND return_date <= '" . $to_date . "'";
                } else {
                    $where = "return_date <= '" . $to_date . "'";
                }
            }

            if($show_bill == '0' || $show_bill == '1') {
                if(!empty($where)) {
                    $where = $where . " AND deleted = '" . $show_bill . "' ";
                } else {
                    $where = "deleted = '" . $show_bill . "' ";
                }
            }

            if(!empty($where)) {
                $select_query = "SELECT * FROM " . $GLOBALS['return_table'] . " WHERE " . $where . " ORDER BY id DESC";
            } 
            else {
                $select_query = "SELECT * FROM " . $GLOBALS['return_table'] . " WHERE deleted = '0' ORDER BY id DESC";
            }
            if(!empty($select_query)) {
                $list = $this->getQueryRecords($GLOBALS['return_table'], $select_query);
            }
            return $list;
        }

        public function GetPaymentAmountForChecking($payment_tax_type,$payment_mode_id, $bank_id, $voucher_id) {
            $list = array(); $select_query = ""; $where = "";$credit = 0;$debit =0;$total_amount =0;


            if(!empty($payment_tax_type) && $payment_tax_type != $GLOBALS['null_value']) {
                if(!empty($where)) {
                    $where = $where . " AND payment_tax_type = '" . $payment_tax_type . "'";
                } else {
                    $where = "payment_tax_type = '" . $payment_tax_type . "'";
                }
            }
        
            if(!empty($payment_mode_id) && $payment_mode_id != $GLOBALS['null_value']) {
                if(!empty($where)) {
                    $where = $where . " AND payment_mode_id = '" . $payment_mode_id . "'";
                } else {
                    $where = "payment_mode_id = '" . $payment_mode_id . "'";
                }
            }

            if(!empty($bank_id) && $bank_id != $GLOBALS['null_value']) {
                if(!empty($where)) {
                    $where = $where . " AND bank_id = '" . $bank_id . "'";
                } else {
                    $where = "bank_id = '" . $bank_id . "'";
                }
            }

            if(!empty($voucher_id) && $voucher_id != $GLOBALS['null_value']) {
                if(!empty($where)) {
                    $where = $where . " AND bill_id != '" . $voucher_id . "'";
                } else {
                    $where = "bill_id != '" . $voucher_id . "'";
                }
            }

            if(!empty($where)) {
                $select_query = "SELECT * FROM " . $GLOBALS['payment_table'] . " WHERE " . $where . "  AND deleted ='0' ";
            } else {
                $select_query = "SELECT * FROM " . $GLOBALS['payment_table'] . " WHERE deleted ='0' ";
            }
            
            // echo $select_query;
            if(!empty($select_query)) {
                $list = $this->getQueryRecords($GLOBALS['payment_table'], $select_query);
                if(!empty($list)) {
                    foreach($list as $data) {
                        if(!empty($data['credit'])) {
                            $credit += (float)$data['credit'];
                        }
                        if(!empty($data['debit'])) {
                            $debit += (float)$data['debit'];
                        }
                        $total_amount = ($credit - $debit);
                    }
                }
            }
            return $total_amount;
        }

        public function CheckBalanceSuspenseForReceipt($suspense_receipt_id){
            $suspense_receipt_details = array(); $bank_ids = array(); $amount = array(); $payment_tax_types = array();
                    $where = ""; $balance =0; $allow_delete = 0; $payment_mode_ids = array(); $total_credit = 0; $total_debit = 0;
            $select_query = "";
            $list = array();
            $unique_id = "";
            $suspense_receipt_details = $this->getTableRecords($GLOBALS['suspense_receipt_table'],'suspense_receipt_id',$suspense_receipt_id);
            if(!empty($suspense_receipt_details)){
                foreach($suspense_receipt_details as $data){
                    if(!empty($data['payment_mode_id'])){
                        $payment_mode_ids = explode(',',$data['payment_mode_id']);
                    }
                    if(!empty($data['bank_id'])){
                        $bank_ids = explode(',',$data['bank_id']);
                    }
                    if(!empty($data['amount'])){
                        $amount = explode(',',$data['amount']);
                    }
                    if(!empty($data['payment_tax_type'])){
                        $payment_tax_types = explode(',',$data['payment_tax_type']);
                    }
                }
            }
            if(!empty($payment_mode_ids)){

                for($i=0; $i < count($payment_mode_ids); $i++) {
                    $payment_mode_ids[$i] = trim($payment_mode_ids[$i]);
                    $payment_tax_types[$i] = trim($payment_tax_types[$i]);
                    
                    if (!empty($bank_ids[$i]) && $bank_ids[$i] != $GLOBALS['null_value']) {

                    $bank_ids[$i] = trim($bank_ids[$i]);
                    }
                
                    $amount[$i] = trim($amount[$i]);
            
                    $bill_company_id = $GLOBALS['bill_company_id'];

                    if (!empty($bill_company_id)) {
                        $where = " bill_company_id = '" . $bill_company_id . "' AND ";
                    }

                    if (!empty($payment_mode_ids[$i]) && $payment_mode_ids[$i] != $GLOBALS['null_value']) {
                        if (!empty($where)) {
                            $where = $where . " payment_mode_id = '" . $payment_mode_ids[$i] . "' AND ";
                        } else {
                            $where = " payment_mode_id = '" . $payment_mode_ids[$i] . "' AND ";
                        }
                    }

                    if (!empty($suspense_receipt_id) && $suspense_receipt_id != $GLOBALS['null_value']) {
                        if (!empty($where)) {
                            $where = $where . " bill_id != '" . $suspense_receipt_id . "' AND ";
                        } else {
                            $where = " bill_id != '" . $suspense_receipt_id . "' AND ";
                        }
                    }

                    if (!empty($bank_ids[$i]) && $bank_ids[$i] != $GLOBALS['null_value']) {
                        if (!empty($where)) {
                            $where = $where . " bank_id = '" . $bank_ids[$i] . "' AND ";
                        } else {
                            $where = " bank_id = '" . $bank_ids[$i] . "' AND ";
                        }
                    }
                    if (!empty($payment_tax_types[$i]) && $payment_tax_types[$i] != $GLOBALS['null_value']) {
                        if (!empty($where)) {
                            $where = $where . " payment_tax_type = '" . $payment_tax_types[$i] . "' AND ";
                        } else {
                            $where = " payment_tax_type = '" . $payment_tax_types[$i] . "' AND ";
                        }
                    }

                    if(!empty($where)) {
                        $select_query = "SELECT SUM(credit) as total_credit, SUM(debit) as total_debit FROM ".$GLOBALS['payment_table']." WHERE ".$where."  bill_type NOT IN ('Purchase Entry', 'LR Entry') AND deleted='0'";    
                    }
                    if(!empty($select_query)) {
                        $list = $this->getQueryRecords($GLOBALS['payment_table'], $select_query);
                    }
                    if(!empty($list)) {
                        foreach($list as $data) {
                            $total_credit += $data['total_credit'];
                            $total_debit += $data['total_debit']; 
                        }
                    }
                    $balance = $total_credit - $total_debit;
                    if ($balance < 0) {
                        $allow_delete = 1;
                    }
                
                }
            }
            return $allow_delete;

        }

        public function getDriverSalary($party_id) {
            $select_query = "";$credit =0;
            $list = array();
            $select_query = "SELECT SUM(credit) as credit FROM " . $GLOBALS['payment_table'] . " WHERE party_id = '" . $party_id . "' AND bill_type='Tripsheet' AND deleted = '0'";
            if(!empty($select_query)) {
                $list = $this->getQueryRecords($GLOBALS['payment_table'], $select_query);
            }
            if(!empty($list)) {
                foreach($list as $data) {
                    $credit = $data['credit'];
                }
            }

            return $credit;
        }

        public function getLRReceiptAmount($lr_number){
                $list = array(); $select_query = "";
            if (!empty($lr_number)) {
                $where = " bill_number = '" . $lr_number . "' AND ";
            }
            $select_query = "SELECT SUM(credit) as credit FROM " . $GLOBALS['payment_table'] . " WHERE ".$where." deleted = '0'";

            if(!empty($select_query)) {
                $list = $this->getQueryRecords($GLOBALS['payment_table'], $select_query);
            }
            if(!empty($list)) {
                foreach($list as $data) {
                    $credit = $data['credit'];
                }
            }

            return $credit;
        }

        public function getLRReceiptAmountTotal($lr_number) {
            $balance = 0;
            if (!empty($lr_number)) {
        
                    $lr_id = $this->getTableColumnValue($GLOBALS['lr_table'],'lr_number', $lr_number,'lr_id');

                    if (!empty($lr_id)) {
                        $where = " lr_id = '" . $lr_id . "' AND ";
                    }
                       $select_query = "SELECT (SUM(debit) - SUM(credit)) AS balance
                        FROM " . $GLOBALS['payment_table'] . "
                        WHERE " . $where . " deleted = '0'";

                if(!empty($select_query)){
                     $list = $this->getQueryRecords($GLOBALS['payment_table'], $select_query);
                }

                if (!empty($list)) {
                    $balance = (float)$list[0]['balance'];
                    // $credit = (float)$list[0]['credit'];
                    // $balance = $debit - $credit;
                }
            }

            return $balance;
        }


        public function checkPaymentCompleted($lr_id) {
            $result = 1; // Default to 1 (not fully paid)
            $select_query = "";

            if (!empty($lr_id)) {
                $select_query = "
                    SELECT SUM(credit) AS credit, SUM(debit) AS debit 
                    FROM " . $GLOBALS['payment_table'] . "
                    WHERE lr_id = '" . $lr_id . "' AND deleted = '0'
                ";
            if(!empty($select_query)) {

                $list = $this->getQueryRecords($GLOBALS['payment_table'], $select_query);
            }

                if (!empty($list)) {
                    $credit = (float) $list[0]['credit'];
                    $debit  = (float) $list[0]['debit'];

                    if ($credit == $debit) {
                        $result = 0; // Fully paid
                    }
                }
            }

            return $result;
        }
        function DeleteTripsheetProfitLoss($delete_tripsheet_profit_loss_id)
        {
            $is_delete =0;
            $expense_list = array();
            $expense_list = $this->getTableRecords($GLOBALS['expense_table'],'tripsheet_profit_loss_id',$delete_tripsheet_profit_loss_id,'');
            $action = "";
            $action = "Tripsheet Profit Loss Deleted.";
            foreach($expense_list as $list)
            {
                if(!empty($list['expense_id']))
                {
                    $payment_list = $this->getTableRecords($GLOBALS['payment_table'],'bill_id',$list['expense_id'],'');
                    foreach($payment_list as $payment)
                    {
                        if(!empty($payment['id']))
                        {
                            $columns = array(); $values = array();          		
                            $columns = array('deleted');
                            $values = array("'1'");
                            $msg = $this->UpdateSQL($GLOBALS['payment_table'], $payment['id'], $columns, $values, $action);
                        }
                    }
                    $columns = array(); $values = array();          		
                    $columns = array('deleted');
                    $values = array("'1'");
                    $msg = $this->UpdateSQL($GLOBALS['expense_table'], $list['id'], $columns, $values, $action);
                }
            }
            $receipt_list =array();
            $receipt_list = $this->getTableRecords($GLOBALS['receipt_table'],'tripsheet_profit_loss_id',$delete_tripsheet_profit_loss_id,'');
            foreach($receipt_list as $list)
            {
                if(!empty($list['receipt_id']))
                {
                    $payment_list = $this->getTableRecords($GLOBALS['payment_table'],'bill_id',$list['receipt_id'],'');
                    foreach($payment_list as $payment)
                    {
                        if(!empty($payment['id']))
                        {
                            $columns = array(); $values = array();          		
                            $columns = array('deleted');
                            $values = array("'1'");
                            $msg = $this->UpdateSQL($GLOBALS['payment_table'], $payment['id'], $columns, $values, $action);
                        }
                    }
                    $is_delete = 1;
                    $columns = array(); $values = array();          		
                    $columns = array('deleted');
                    $values = array("'1'");
                    $msg = $this->UpdateSQL($GLOBALS['receipt_table'], $list['id'], $columns, $values, $action);
                }
            }
            return $is_delete;
        }

 
        // public function GetLRNumberPaymentList($party_type, $party_id, $bill_type, $login_branch_id) {
        //     $lr_number_list = array();

        //     // Determine party field name
        //     if ($party_type == 'consignor') {
        //         $party_field_name = 'consignor_id';
        //     } else if ($party_type == 'consignee') {
        //         $party_field_name = 'consignee_id';
        //     } else {
        //         $party_field_name = 'account_party_id';
        //         $bill_type = 'Account Party';
        //     }

        //     // Build WHERE clause
        //     $where = "";
        //     if (!empty($party_id)) { 
        //         $where .= (!empty($where) ? " AND " : "") . $party_field_name . " = '" . addslashes($party_id) . "'";
        //     }

        //     // Handle branch filter for consignor
        //     if ($party_type == 'consignor' && !empty($login_branch_id)) {
        //         if (is_array($login_branch_id)) {
        //             $branch_ids = array_map(function($id) {
        //                 return "'" . addslashes($id) . "'";
        //             }, $login_branch_id);
        //             $branch_list = implode(",", $branch_ids);
        //             $where .= (!empty($where) ? " AND " : "") . "from_branch_id IN ($branch_list)";
        //         } else {
        //             $branch_id = addslashes($login_branch_id);
        //             $where .= (!empty($where) ? " AND " : "") . "from_branch_id = '" . $branch_id . "'";
        //         }
        //     }

        //     // Bill type filter
        //     if (!empty($bill_type)) { 
        //         $where .= (!empty($where) ? " AND " : "") . "bill_type = '" . addslashes($bill_type) . "'";
        //     }

        //     // 🔹 STEP 1: Get Opening Balance for this party
        //     $opening_query = "
        //         SELECT 
        //             IFNULL(SUM(credit), 0) AS credit,
        //             IFNULL(SUM(debit), 0) AS debit
        //         FROM " . $GLOBALS['payment_table'] . "
        //         WHERE (lr_id = '' OR lr_id = '0' OR lr_id IS NULL OR lr_id='NULL')
        //         AND deleted = '0'
        //         AND party_id = '" . addslashes($party_id) . "'
        //     ";
            
        //     $opening_result = $this->getQueryRecords('', $opening_query);
        //     $opening_credit = 0;
        //     $opening_debit  = 0;

        //     if (!empty($opening_result)) {
        //         $opening_credit = floatval($opening_result[0]['credit']);
        //         $opening_debit  = floatval($opening_result[0]['debit']);
        //     }

        //     $opening_balance = $opening_debit - $opening_credit;

        //     // Add opening balance record FIRST
        //     $lr_number_list[] = array(
        //         'lr_id' => 'OPENING_BALANCE',
        //         'pending_amount' => $opening_balance
        //     );

        //     // 🔹 STEP 2: Get all LRs for this party
        //     $select_query = "
        //         SELECT lr_id 
        //         FROM " . $GLOBALS['lr_table'] . " 
        //         WHERE " . ($where ?: "1") . " 
        //         AND deleted = '0'
        //         ORDER BY lr_date DESC
        //     ";

        //     $lr_list = $this->getQueryRecords('', $select_query);

        //     // 🔹 STEP 3: Calculate LR pending balances
        //    $lr_number_list = [];

        //     if (!empty($lr_list)) {
        //         foreach ($lr_list as $data) {
        //             if (!empty($data['lr_id'])) {
        //                 $lr_id = $data['lr_id'];

        //                 // Get total credit and debit for this LR and party
        //                 $payment_query = "
        //                     SELECT 
        //                         IFNULL(SUM(credit), 0) AS credit,
        //                         IFNULL(SUM(debit), 0) AS debit
        //                     FROM " . $GLOBALS['payment_table'] . "
        //                     WHERE lr_id = '" . addslashes($lr_id) . "'
        //                     AND deleted = '0'
        //                     AND party_id = '" . addslashes($party_id) . "'
        //                 ";

        //                 $payment_result = $this->getQueryRecords('', $payment_query);

        //                 $credit = 0; 
        //                 $debit  = 0;

        //                 if (!empty($payment_result)) {
        //                     $credit = floatval($payment_result[0]['credit']);
        //                     $debit  = floatval($payment_result[0]['debit']);
        //                 }

        //                 $pending_balance = $debit - $credit;

        //                 // ✅ Only include NOT PAID LRs (debit > 0, credit == 0)
        //                 if ($debit > 0 && $credit == 0) {
        //                     $lr_number_list[] = [
        //                         'lr_id' => $lr_id,
        //                         'pending_amount' => $pending_balance
        //                     ];
        //                 }
        //             }
        //         }
        //     }


        //     // 🔹 STEP 4: Return full list (Opening + LRs)
        //     return $lr_number_list;
        // }

        // public function GetLRNumberPaymentList($party_type, $party_id, $bill_type, $login_branch_id) {
        //     $lr_number_list = array();

          
        //     if ($party_type == 'consignor') {
        //         $party_field_name = 'consignor_id';
        //     } else if ($party_type == 'consignee') {
        //         $party_field_name = 'consignee_id';
        //     } else {
        //         $party_field_name = 'account_party_id';
        //         $bill_type = 'Account Party';
        //     }

            
        //     $where = "";
        //     if (!empty($party_id)) { 
        //         $where .= (!empty($where) ? " AND " : "") . $party_field_name . " = '" . addslashes($party_id) . "'";
        //     }

        //     // Handle branch filter for consignor
        //     if ($party_type == 'consignor' && !empty($login_branch_id)) {
        //         if (is_array($login_branch_id)) {
        //             $branch_ids = array_map(function($id) {
        //                 return "'" . addslashes($id) . "'";
        //             }, $login_branch_id);
        //             $branch_list = implode(",", $branch_ids);
        //             $where .= (!empty($where) ? " AND " : "") . "from_branch_id IN ($branch_list)";
        //         } else {
        //             $branch_id = addslashes($login_branch_id);
        //             $where .= (!empty($where) ? " AND " : "") . "from_branch_id = '" . $branch_id . "'";
        //         }
        //     }

        //     // Bill type filter
        //     if (!empty($bill_type)) { 
        //         $where .= (!empty($where) ? " AND " : "") . "bill_type = '" . addslashes($bill_type) . "'";
        //     }

        //     // Get Opening Balance for this party
        //     $opening_query = "
        //         SELECT 
        //             IFNULL(SUM(credit), 0) AS credit,
        //             IFNULL(SUM(debit), 0) AS debit
        //         FROM " . $GLOBALS['payment_table'] . "
        //         WHERE (lr_id = '0' OR lr_id IS NULL OR lr_id='NULL')
        //         AND deleted = '0'
        //         AND party_id = '" . addslashes($party_id) . "'
        //     ";
            
        //     $opening_result = $this->getQueryRecords('', $opening_query);
        //     $opening_credit = 0;
        //     $opening_debit  = 0;

        //     if (!empty($opening_result)) {
        //         $opening_credit = floatval($opening_result[0]['credit']);
        //         $opening_debit  = floatval($opening_result[0]['debit']);
        //     }

        //     $opening_balance = $opening_debit - $opening_credit;

        //     // Add opening balance FIRST only if unpaid
        //     if ($opening_balance > 0) {
        //         $lr_number_list[] = [
        //             'lr_id' => 'OPENING_BALANCE',
        //             'pending_amount' => $opening_balance
        //         ];
        //     }

        //     // Get all LRs for this party
        //     $select_query = "
        //         SELECT lr_id 
        //         FROM " . $GLOBALS['lr_table'] . " 
        //         WHERE " . ($where ?: "1") . " 
        //         AND deleted = '0'
        //         ORDER BY lr_date ASC
        //     ";

        //     $lr_list = $this->getQueryRecords('', $select_query);

        //     $not_paid_list = [];
        //     $half_paid_list = [];

        //     if (!empty($lr_list)) {
        //         foreach ($lr_list as $data) {
        //             if (!empty($data['lr_id'])) {
        //                 $lr_id = $data['lr_id'];

        //                 $payment_query = "
        //                     SELECT 
        //                         IFNULL(SUM(credit), 0) AS credit,
        //                         IFNULL(SUM(debit), 0) AS debit
        //                     FROM " . $GLOBALS['payment_table'] . "
        //                     WHERE lr_id = '" . addslashes($lr_id) . "'
        //                     AND (is_partial_payment != '1' OR is_partial_payment IS NULL)
        //                     AND deleted = '0'
        //                     AND party_id = '" . addslashes($party_id) . "'
        //                 ";

        //                 $payment_result = $this->getQueryRecords('', $payment_query);

        //                 $credit = 0; 
        //                 $debit  = 0;

        //                 if (!empty($payment_result)) {
        //                     $credit = floatval($payment_result[0]['credit']);
        //                     $debit  = floatval($payment_result[0]['debit']);
        //                 }

        //                 $pending_balance = $debit - $credit;

        //                 // NOT PAID (no credit made yet)
        //                 if ($debit > 0 && $credit == 0) {
        //                     $not_paid_list[] = [
        //                         'lr_id' => $lr_id,
        //                         'pending_amount' => $pending_balance,
        //                         'status' => 'Not Paid'
        //                     ];
        //                 }

        //                 // HALF PAID (some payment made, but not full)
        //                 else if ($credit > 0 && $credit < $debit) {
        //                     $half_paid_list[] = [
        //                         'lr_id' => $lr_id,
        //                         'pending_amount' => $pending_balance,
        //                         'status' => 'Half Paid'
        //                     ];
        //                 }
        //             }
        //         }
        //     }

        //     // Merge both results into one list
        //     $lr_number_list = array_merge($not_paid_list, $half_paid_list);
           
        //     // Return the final list
        //     return $lr_number_list;
        // }

        public function GetLRNumberPaymentList($party_type, $party_id, $bill_type, $login_branch_id) {
            $lr_number_list = array();

            if ($party_type == 'consignor') {
                $party_field_name = 'consignor_id';
            } else if ($party_type == 'consignee') {
                $party_field_name = 'consignee_id';
            } else {
                $party_field_name = 'account_party_id';
                $bill_type = 'Account Party';
            }

            $where = "";
            if (!empty($party_id)) { 
                $where .= (!empty($where) ? " AND " : "") . $party_field_name . " = '" . addslashes($party_id) . "'";
            }

            // Handle branch filter for consignor
            if ($party_type == 'consignor' && !empty($login_branch_id)) {
                if (is_array($login_branch_id)) {
                    $branch_ids = array_map(function($id) {
                        return "'" . addslashes($id) . "'";
                    }, $login_branch_id);
                    $branch_list = implode(",", $branch_ids);
                    $where .= (!empty($where) ? " AND " : "") . "from_branch_id IN ($branch_list)";
                } else {
                    $branch_id = addslashes($login_branch_id);
                    $where .= (!empty($where) ? " AND " : "") . "from_branch_id = '" . $branch_id . "'";
                }
            }

            // Bill type filter
            if (!empty($bill_type)) { 
                $where .= (!empty($where) ? " AND " : "") . "bill_type = '" . addslashes($bill_type) . "'";
            }

            // Get Opening Balance for this party
            $opening_query = "
                SELECT 
                    IFNULL(SUM(credit), 0) AS credit,
                    IFNULL(SUM(debit), 0) AS debit
                FROM " . $GLOBALS['payment_table'] . "
                WHERE (lr_id = '0' OR lr_id IS NULL OR lr_id='NULL')
                AND deleted = '0'
                AND party_id = '" . addslashes($party_id) . "'
            ";

            $opening_result = $this->getQueryRecords('', $opening_query);
            $opening_credit = 0;
            $opening_debit  = 0;

            if (!empty($opening_result)) {
                $opening_credit = floatval($opening_result[0]['credit']);
                $opening_debit  = floatval($opening_result[0]['debit']);
            }

            $opening_balance = $opening_debit - $opening_credit;

            // Add opening balance FIRST (only if unpaid)
            if ($opening_balance > 0) {
                $lr_number_list[] = [
                    'lr_id' => 'OPENING_BALANCE',
                    'pending_amount' => $opening_balance,
                    'status' => 'Opening Balance'
                ];
            }

            // Get all LRs for this party
            $select_query = "
                SELECT lr_id 
                FROM " . $GLOBALS['lr_table'] . " 
                WHERE " . ($where ?: "1") . " 
                AND deleted = '0'
                ORDER BY lr_date ASC
            ";

            $lr_list = $this->getQueryRecords('', $select_query);

            $not_paid_list = [];
            $half_paid_list = [];

            if (!empty($lr_list)) {
                foreach ($lr_list as $data) {
                    if (!empty($data['lr_id'])) {
                        $lr_id = $data['lr_id'];

                        $payment_query = "
                            SELECT 
                                IFNULL(SUM(credit), 0) AS credit,
                                IFNULL(SUM(debit), 0) AS debit
                            FROM " . $GLOBALS['payment_table'] . "
                            WHERE lr_id = '" . addslashes($lr_id) . "'
                            AND (is_partial_payment != '1' OR is_partial_payment IS NULL)
                            AND deleted = '0'
                            AND party_id = '" . addslashes($party_id) . "'
                        ";

                        $payment_result = $this->getQueryRecords('', $payment_query);

                        $credit = 0; 
                        $debit  = 0;

                        if (!empty($payment_result)) {
                            $credit = floatval($payment_result[0]['credit']);
                            $debit  = floatval($payment_result[0]['debit']);
                        }

                        $pending_balance = $debit - $credit;

                        if ($pending_balance > 0) {
                            if ($credit == 0) {
                                $not_paid_list[] = [
                                    'lr_id' => $lr_id,
                                    'pending_amount' => $pending_balance,
                                    'status' => 'Not Paid'
                                ];
                            } else if ($credit < $debit) {
                                $half_paid_list[] = [
                                    'lr_id' => $lr_id,
                                    'pending_amount' => $pending_balance,
                                    'status' => 'Half Paid'
                                ];
                            }
                        }
                    }
                }
            }

            // Merge all results but KEEP existing opening balance if present
            $lr_number_list = array_merge($lr_number_list, $not_paid_list, $half_paid_list);

            // Return combined final list (opening + LR balances)
            return $lr_number_list;
        }


        public function getLRBalanceAmount($lr_id){
            $list = array(); $select_query = ""; 
            $credit = 0; $debit = 0; $balance = 0;
            $where ="";

        
            if(!empty($lr_id)){ 
                if(!empty($where)) {
                    $where = $where . " AND lr_id = '" . $lr_id . "' ";
                } else {
                    $where = "lr_id = '" . $lr_id . "'";
                }
            }
            
            if(!empty($where)) {
                $select_query = "SELECT SUM(credit) as credit,SUM(debit) as debit FROM " . $GLOBALS['payment_table'] . " WHERE " . $where . " AND  deleted = '0'";
            } else {
                $select_query = "SELECT * FROM " . $GLOBALS['lr_table'] . " WHERE deleted = '0' ORDER BY lr_date DESC";
            }
            $lr_list = $this->getQueryRecords('', $select_query);
            if(!empty($lr_list)) {
                foreach($lr_list as $data) {
                    if(!empty($data['credit']) && $data['credit']!=$GLOBALS['null_value']){
                        $credit = $data['credit'];
                    }

                    if(!empty($data['debit']) && $data['debit']!=$GLOBALS['null_value']){
                        $debit = $data['debit'];
                    }

                }
            }
            
            $balance = $debit - $credit;

            return $balance;
           
        }

        public function getPartyPaymentList($party_type,$party_id)
        {
            $where ="";
            if(!empty($party_id))
            {
                if(!empty($where))
                {
                    $where .= 'party_id = "'.$party_id.'" AND ';
                }
                else
                {
                    $where = 'party_id = "'.$party_id.'" AND ';
                }
            }
            $select_query ="";
            $select_query ="SELECT * FROM ".$GLOBALS['payment_table']." WHERE ".$where." (bill_type = 'LR Entry' OR bill_type ='Opening Balance') AND deleted ='0' ";
            $payment_list =array();
            $payment_list = $this->getQueryRecords($GLOBALS['payment_table'],$select_query);
            return $payment_list;
        }
        
        public function getLrReceiptPaymentDetails($unique_lr_id){
            $select_query ="";
            $select_query = "SELECT * FROM ".$GLOBALS['payment_table']." WHERE lr_id ='".$unique_lr_id."' AND bill_type ='Receipt' AND deleted ='0' ORDER BY id ASC";
            $lr_list =array();
            $lr_list = $this->getQueryRecords($GLOBALS['payment_table'],$select_query);
            $lr_amount =0;
            if(!empty($lr_list))
            {
                foreach($lr_list as $data)
                {
                    $lr_amount += $data['credit'];
                }
            }
            return $lr_amount;
        }
    } 
?>